/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirLookupTrackerComponent;
import org.jetbrains.kotlin.fir.FirLookupTrackerComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirImport;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.builder.FirErrorImportBuilder;
import org.jetbrains.kotlin.fir.declarations.builder.FirResolvedImportBuilder;
import org.jetbrains.kotlin.fir.resolve.MainSessionComponentsKt;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeImportFromSingleton;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.transformers.FirAbstractTreeTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.FirImportResolveTransformerKt;
import org.jetbrains.kotlin.fir.resolve.transformers.PackageOrClass;
import org.jetbrains.kotlin.fir.symbols.AbstractFirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0017\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ)\u0010\u0013\u001a\u0002H\u0014\"\b\b\u0000\u0010\u0014*\u00020\u00152\u0006\u0010\u0016\u001a\u0002H\u00142\b\u0010\u0017\u001a\u0004\u0018\u00010\u0002H\u0016\u00a2\u0006\u0002\u0010\u0018J\u001a\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\n2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0002H\u0016J\u0018\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u00112\u0006\u0010 \u001a\u00020\u001cH\u0002R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000f\u001a\u00020\u0010*\u00020\u00118TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0012\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirImportResolveTransformer;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirAbstractTreeTransformer;", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "phase", "Lorg/jetbrains/kotlin/fir/declarations/FirResolvePhase;", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/declarations/FirResolvePhase;)V", "currentFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "symbolProvider", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "isAcceptable", "", "Lorg/jetbrains/kotlin/name/FqName;", "(Lorg/jetbrains/kotlin/name/FqName;)Z", "transformElement", "E", "Lorg/jetbrains/kotlin/fir/FirElement;", "element", "data", "(Lorg/jetbrains/kotlin/fir/FirElement;Ljava/lang/Object;)Lorg/jetbrains/kotlin/fir/FirElement;", "transformFile", "file", "transformImport", "Lorg/jetbrains/kotlin/fir/declarations/FirImport;", "import", "transformImportForFqName", "fqName", "delegate", "resolve"})
public class FirImportResolveTransformer
extends FirAbstractTreeTransformer<Object> {
    @NotNull
    private final FirSession session;
    @NotNull
    private final FirSymbolProvider symbolProvider;
    @Nullable
    private FirFile currentFile;

    protected FirImportResolveTransformer(@NotNull FirSession session2, @NotNull FirResolvePhase phase) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)((Object)phase), (String)"phase");
        super(phase);
        this.session = session2;
        this.symbolProvider = MainSessionComponentsKt.getSymbolProvider(this.session);
    }

    @Override
    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    @Override
    @NotNull
    public <E extends FirElement> E transformElement(@NotNull E element, @Nullable Object data) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        return element;
    }

    public FirImportResolveTransformer(@NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        this(session2, FirResolvePhase.IMPORTS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public FirFile transformFile(@NotNull FirFile file2, @Nullable Object data) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.checkSessionConsistency(file2);
        file2.replaceResolvePhase(this.getTransformerPhase());
        FirFile firFile = file2;
        boolean bl = false;
        boolean bl2 = false;
        FirFile it = firFile;
        boolean bl3 = false;
        FirFile prevValue = this.currentFile;
        this.currentFile = file2;
        try {
            it.transformChildren(this, null);
        }
        finally {
            this.currentFile = prevValue;
        }
        return firFile;
    }

    @Override
    @NotNull
    public FirImport transformImport(@NotNull FirImport firImport, @Nullable Object data) {
        FqName fqName2;
        Object it;
        boolean bl;
        boolean bl2;
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)firImport, (String)"import");
        Object object3 = firImport.getImportedFqName();
        if (object3 == null) {
            object2 = null;
        } else {
            object = object3;
            bl2 = false;
            bl = false;
            it = object;
            boolean bl3 = false;
            object2 = fqName2 = !((FqName)it).isRoot() ? object : null;
        }
        if (fqName2 == null) {
            return firImport;
        }
        FqName fqName3 = fqName2;
        if (!this.isAcceptable(fqName3)) {
            return firImport;
        }
        if (firImport.isAllUnder()) {
            return this.transformImportForFqName(fqName3, firImport);
        }
        object3 = fqName3.parent();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"fqName.parent()");
        FqName parentFqName = object3;
        object3 = this.currentFile;
        if (object3 != null) {
            object = object3;
            bl2 = false;
            bl = false;
            it = object;
            boolean bl4 = false;
            FirLookupTrackerComponent firLookupTrackerComponent = FirLookupTrackerComponentKt.getLookupTracker(this.getSession());
            if (firLookupTrackerComponent != null) {
                Object object4 = fqName3.shortName();
                Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"fqName.shortName()");
                Name name2 = object4;
                object4 = parentFqName.asString();
                Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"parentFqName.asString()");
                firLookupTrackerComponent.recordLookup(name2, (String)object4, firImport.getSource(), ((FirFile)it).getSource());
            }
        }
        return this.transformImportForFqName(parentFqName, firImport);
    }

    protected boolean isAcceptable(@NotNull FqName $this$isAcceptable) {
        Intrinsics.checkNotNullParameter((Object)$this$isAcceptable, (String)"<this>");
        return true;
    }

    private final FirImport transformImportForFqName(FqName fqName2, FirImport delegate2) {
        FirRegularClass firClass2;
        PackageOrClass packageOrClass = FirImportResolveTransformerKt.resolveToPackageOrClass(this.symbolProvider, fqName2);
        if (packageOrClass == null) {
            return delegate2;
        }
        PackageOrClass packageOrClass2 = packageOrClass;
        FqName packageFqName = packageOrClass2.component1();
        FqName relativeClassFqName = packageOrClass2.component2();
        FirClassLikeSymbol<?> classSymbol = packageOrClass2.component3();
        Object object = classSymbol;
        FirClassLikeDeclaration firClassLikeDeclaration = object == null ? null : (FirClassLikeDeclaration)((AbstractFirBasedSymbol)object).getFir();
        FirRegularClass firRegularClass = firClass2 = firClassLikeDeclaration instanceof FirRegularClass ? (FirRegularClass)firClassLikeDeclaration : null;
        if (delegate2.isAllUnder() && ((firClassLikeDeclaration = firClass2) == null ? false : ((object = ((FirRegularClass)firClassLikeDeclaration).getClassKind()) == null ? false : ((ClassKind)((Object)object)).isSingleton()))) {
            boolean $i$f$buildErrorImport = false;
            boolean bl = false;
            FirErrorImportBuilder firErrorImportBuilder = new FirErrorImportBuilder();
            boolean bl2 = false;
            boolean bl3 = false;
            FirErrorImportBuilder $this$transformImportForFqName_u24lambda_u2d3 = firErrorImportBuilder;
            boolean bl4 = false;
            $this$transformImportForFqName_u24lambda_u2d3.setDelegate(delegate2);
            $this$transformImportForFqName_u24lambda_u2d3.setDiagnostic(new ConeImportFromSingleton(firClass2.getName()));
            return firErrorImportBuilder.build();
        }
        boolean $i$f$buildResolvedImport = false;
        boolean bl = false;
        FirResolvedImportBuilder firResolvedImportBuilder = new FirResolvedImportBuilder();
        boolean bl5 = false;
        boolean bl6 = false;
        FirResolvedImportBuilder $this$transformImportForFqName_u24lambda_u2d4 = firResolvedImportBuilder;
        boolean bl7 = false;
        $this$transformImportForFqName_u24lambda_u2d4.setDelegate(delegate2);
        $this$transformImportForFqName_u24lambda_u2d4.setPackageFqName(packageFqName);
        $this$transformImportForFqName_u24lambda_u2d4.setRelativeClassName(relativeClassFqName);
        return firResolvedImportBuilder.build();
    }
}

