/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirFakeSourceElementKind;
import org.jetbrains.kotlin.fir.FirRealSourceElementKind;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.FirSourceElementKind;
import org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationCheckerUtilsKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirCallableMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u0010\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J$\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0018\u0010\u0005\u001a\u00020\u0006*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOpenMemberChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassChecker;", "()V", "shouldReportOpenFromSource", "", "Lorg/jetbrains/kotlin/fir/FirSourceElement;", "getShouldReportOpenFromSource", "(Lorg/jetbrains/kotlin/fir/FirSourceElement;)Z", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirOpenMemberChecker
extends FirDeclarationChecker<FirClass<?>> {
    @NotNull
    public static final FirOpenMemberChecker INSTANCE = new FirOpenMemberChecker();

    private FirOpenMemberChecker() {
    }

    @Override
    public void check(@NotNull FirClass<?> declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter(declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        if (FirDeclarationCheckerUtilsKt.getCanHaveOpenMembers(declaration2)) {
            return;
        }
        for (FirDeclaration memberDeclaration : declaration2.getDeclarations()) {
            Object object;
            if (!(memberDeclaration instanceof FirCallableMemberDeclaration) || memberDeclaration instanceof FirConstructor || (object = memberDeclaration.getSource()) == null) continue;
            FirSourceElement source = object;
            FirMemberDeclaration $this$isOpen$iv = (FirMemberDeclaration)memberDeclaration;
            boolean $i$f$isOpen = false;
            if (!($this$isOpen$iv.getStatus().getModality() == Modality.OPEN)) {
                FirElement firElement = memberDeclaration;
                object = KtTokens.OPEN_KEYWORD;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"OPEN_KEYWORD");
                if (!FirKeywordUtilsKt.hasModifier(firElement, (KtModifierKeywordToken)((Object)object)) || !this.getShouldReportOpenFromSource(source)) continue;
            }
            if (declaration2.getClassKind() == ClassKind.OBJECT) {
                DiagnosticReporterKt.reportOn$default(reporter, source, FirErrors.INSTANCE.getNON_FINAL_MEMBER_IN_OBJECT(), context2, null, 8, null);
                continue;
            }
            DiagnosticReporterKt.reportOn$default(reporter, source, FirErrors.INSTANCE.getNON_FINAL_MEMBER_IN_FINAL_CLASS(), context2, null, 8, null);
        }
    }

    private final boolean getShouldReportOpenFromSource(FirSourceElement $this$shouldReportOpenFromSource) {
        FirSourceElementKind firSourceElementKind = $this$shouldReportOpenFromSource.getKind();
        return Intrinsics.areEqual((Object)firSourceElementKind, (Object)FirRealSourceElementKind.INSTANCE) ? true : Intrinsics.areEqual((Object)firSourceElementKind, (Object)FirFakeSourceElementKind.PropertyFromParameter.INSTANCE);
    }
}

