/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codeMetaInfo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codeMetaInfo.CodeMetaInfoParser;
import org.jetbrains.kotlin.codeMetaInfo.model.ParsedCodeMetaInfo;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/codeMetaInfo/CodeMetaInfoParser;", "", "()V", "closingRegex", "Lkotlin/text/Regex;", "getClosingRegex", "()Lkotlin/text/Regex;", "openingOrClosingRegex", "getOpeningOrClosingRegex", "openingRegex", "getOpeningRegex", "tagRegex", "getCodeMetaInfoFromText", "", "Lorg/jetbrains/kotlin/codeMetaInfo/model/ParsedCodeMetaInfo;", "renderedText", "", "Opening", "test-infrastructure-utils"})
public final class CodeMetaInfoParser {
    @NotNull
    public static final CodeMetaInfoParser INSTANCE = new CodeMetaInfoParser();
    @NotNull
    private static final Regex openingRegex;
    @NotNull
    private static final Regex closingRegex;
    @NotNull
    private static final Regex openingOrClosingRegex;
    @NotNull
    private static final Regex tagRegex;

    private CodeMetaInfoParser() {
    }

    @NotNull
    public final Regex getOpeningRegex() {
        return openingRegex;
    }

    @NotNull
    public final Regex getClosingRegex() {
        return closingRegex;
    }

    @NotNull
    public final Regex getOpeningOrClosingRegex() {
        return openingOrClosingRegex;
    }

    @NotNull
    public final List<ParsedCodeMetaInfo> getCodeMetaInfoFromText(@NotNull String renderedText) {
        int closingStartOffset;
        Intrinsics.checkNotNullParameter((Object)renderedText, (String)"renderedText");
        String text2 = renderedText;
        ArrayDeque openings = new ArrayDeque();
        ArrayDeque stackOfOpenings = new ArrayDeque();
        boolean bl = false;
        Map closingOffsets = new LinkedHashMap();
        boolean bl2 = false;
        List result2 = new ArrayList();
        int counter = 0;
        while (true) {
            String string2;
            Object openingMatch22;
            boolean bl3;
            int n;
            int openingStartOffset = Integer.MAX_VALUE;
            closingStartOffset = Integer.MAX_VALUE;
            MatchResult opening = Regex.find$default((Regex)openingRegex, (CharSequence)text2, (int)0, (int)2, null);
            MatchResult closing = Regex.find$default((Regex)closingRegex, (CharSequence)text2, (int)0, (int)2, null);
            if (opening == null && closing == null) break;
            if (opening != null) {
                openingStartOffset = opening.getRange().getFirst();
            }
            if (closing != null) {
                closingStartOffset = closing.getRange().getFirst();
            }
            if (openingStartOffset < closingStartOffset) {
                boolean bl4 = false;
                int n2 = 0;
                n2 = 0;
                n = 0;
                if (opening == null) {
                    bl3 = false;
                    String string3 = "Required value was null.";
                    throw (Throwable)new IllegalArgumentException(string3.toString());
                }
                n2 = counter;
                counter = n2 + 1;
                MatchGroup matchGroup = opening.getGroups().get(2);
                Intrinsics.checkNotNull((Object)matchGroup);
                openingMatch22 = new Opening(n2, matchGroup.getValue(), opening.getRange().getFirst());
                openings.addLast(openingMatch22);
                stackOfOpenings.addLast(openingMatch22);
                String string4 = text2;
                n = opening.getRange().getLast() + 1;
                bl3 = false;
                String string5 = string4;
                if (string5 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                string2 = ((Object)StringsKt.removeRange((CharSequence)string5, (int)openingStartOffset, (int)n)).toString();
            } else {
                boolean openingMatch22 = false;
                boolean bl5 = false;
                bl5 = false;
                n = 0;
                if (closing == null) {
                    bl3 = false;
                    String string6 = "Required value was null.";
                    throw (Throwable)new IllegalArgumentException(string6.toString());
                }
                openingMatch22 = closingOffsets;
                Object object = stackOfOpenings.removeLast();
                Integer n3 = closing.getRange().getFirst();
                bl3 = false;
                openingMatch22.put(object, n3);
                openingMatch22 = text2;
                int n4 = closing.getRange().getLast() + 1;
                n = 0;
                Object object2 = openingMatch22;
                if (object2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                string2 = ((Object)StringsKt.removeRange((CharSequence)((CharSequence)object2), (int)closingStartOffset, (int)n4)).toString();
            }
            text2 = string2;
        }
        if (openings.size() != closingOffsets.size()) {
            String openingStartOffset = "Opening and closing tags counts are not equals";
            closingStartOffset = 0;
            throw (Throwable)new IllegalStateException(openingStartOffset.toString());
        }
        while (!openings.isEmpty()) {
            Opening openingMatchResult = (Opening)openings.removeLast();
            int closingMatchResult = ((Number)MapsKt.getValue((Map)closingOffsets, (Object)openingMatchResult)).intValue();
            String allMetaInfos = openingMatchResult.getTags();
            Sequence $this$forEach$iv = SequencesKt.map((Sequence)Regex.findAll$default((Regex)tagRegex, (CharSequence)allMetaInfos, (int)0, (int)2, null), (Function1)getCodeMetaInfoFromText.1.INSTANCE);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                List list2;
                MatchGroupCollection it = (MatchGroupCollection)element$iv;
                boolean bl6 = false;
                MatchGroup matchGroup = it.get(1);
                Intrinsics.checkNotNull((Object)matchGroup);
                String tag = matchGroup.getValue();
                MatchGroup matchGroup2 = it.get(3);
                if (matchGroup2 == null) {
                    list2 = null;
                } else {
                    String string7 = matchGroup2.getValue();
                    if (string7 == null) {
                        list2 = null;
                    } else {
                        String[] stringArray = new String[]{";"};
                        list2 = StringsKt.split$default((CharSequence)string7, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                    }
                }
                List list3 = list2;
                List attributes2 = list3 == null ? CollectionsKt.emptyList() : list3;
                matchGroup2 = it.get(5);
                String description2 = matchGroup2 == null ? null : matchGroup2.getValue();
                result2.add(new ParsedCodeMetaInfo(openingMatchResult.getStartOffset(), closingMatchResult, CollectionsKt.toMutableList((Collection)attributes2), tag, description2));
            }
        }
        return result2;
    }

    static {
        String string2 = "(<!([^\"]*?((\".*?\")(, \".*?\")*?)?[^\"]*?)!>)";
        boolean bl = false;
        openingRegex = new Regex(string2);
        string2 = "(<!>)";
        bl = false;
        closingRegex = new Regex(string2);
        string2 = '(' + closingRegex.getPattern() + '|' + openingRegex.getPattern() + ')';
        bl = false;
        openingOrClosingRegex = new Regex(string2);
        string2 = "([\\S&&[^,(){}]]+)([{](.*?)[}])?(\\(\"(.*?)\"\\))?(, )?";
        bl = false;
        tagRegex = new Regex(string2);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0010\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/codeMetaInfo/CodeMetaInfoParser$Opening;", "", "index", "", "tags", "", "startOffset", "(ILjava/lang/String;I)V", "getIndex", "()I", "getStartOffset", "getTags", "()Ljava/lang/String;", "equals", "", "other", "hashCode", "test-infrastructure-utils"})
    private static final class Opening {
        private final int index;
        @NotNull
        private final String tags;
        private final int startOffset;

        public Opening(int index2, @NotNull String tags, int startOffset) {
            Intrinsics.checkNotNullParameter((Object)tags, (String)"tags");
            this.index = index2;
            this.tags = tags;
            this.startOffset = startOffset;
        }

        public final int getIndex() {
            return this.index;
        }

        @NotNull
        public final String getTags() {
            return this.tags;
        }

        public final int getStartOffset() {
            return this.startOffset;
        }

        public boolean equals(@Nullable Object other) {
            Object object;
            if (this == other) {
                return true;
            }
            if (!Intrinsics.areEqual(this.getClass(), (object = other) == null ? null : object.getClass())) {
                return false;
            }
            if (other == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.codeMetaInfo.CodeMetaInfoParser.Opening");
            }
            Opening cfr_ignored_0 = (Opening)other;
            return this.index == ((Opening)other).index;
        }

        public int hashCode() {
            return this.index;
        }
    }
}

