/*
 * Decompiled with CFR 0.152.
 */
package com.intellij;

import com.intellij.AbstractBundle;
import com.intellij.BundleBase;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AbstractExtensionPointBean;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Map;
import java.util.ResourceBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DynamicBundle
extends AbstractBundle {
    private static final Logger LOG = Logger.getInstance(DynamicBundle.class);
    public static final DynamicBundle INSTANCE = new DynamicBundle(""){};
    private static final Map<String, DynamicBundle> ourBundlesForForms = ContainerUtil.createConcurrentSoftValueMap();

    protected DynamicBundle(@NotNull String pathToBundle) {
        if (pathToBundle == null) {
            DynamicBundle.$$$reportNull$$$1(0);
        }
        if (pathToBundle == null) {
            DynamicBundle.$$$reportNull$$$0(0);
        }
        super(pathToBundle);
    }

    protected ResourceBundle findBundle(@NotNull String pathToBundle, @NotNull ClassLoader baseLoader, @NotNull ResourceBundle.Control control) {
        if (pathToBundle == null) {
            DynamicBundle.$$$reportNull$$$1(1);
        }
        if (baseLoader == null) {
            DynamicBundle.$$$reportNull$$$1(2);
        }
        if (control == null) {
            DynamicBundle.$$$reportNull$$$1(3);
        }
        if (pathToBundle == null) {
            DynamicBundle.$$$reportNull$$$0(1);
        }
        if (baseLoader == null) {
            DynamicBundle.$$$reportNull$$$0(2);
        }
        if (control == null) {
            DynamicBundle.$$$reportNull$$$0(3);
        }
        ResourceBundle base = super.findBundle(pathToBundle, baseLoader, control);
        LanguageBundleEP langBundle = DynamicBundle.findLanguageBundle();
        if (langBundle == null) {
            return base;
        }
        ResourceBundle pluginBundle = super.findBundle(pathToBundle, langBundle.getLoaderForClass(), control);
        if (pluginBundle == null) {
            return base;
        }
        try {
            if (DynamicBundleInternal.SET_PARENT != null) {
                DynamicBundleInternal.SET_PARENT.invoke(pluginBundle, base);
            }
        }
        catch (Throwable e) {
            LOG.warn(e);
            return base;
        }
        return pluginBundle;
    }

    @Nullable
    private static LanguageBundleEP findLanguageBundle() {
        try {
            Application application = ApplicationManager.getApplication();
            if (application == null) {
                return null;
            }
            if (application.isUnitTestMode() && !application.getExtensionArea().hasExtensionPoint(LanguageBundleEP.EP_NAME)) {
                return null;
            }
            return (LanguageBundleEP)((Object)LanguageBundleEP.EP_NAME.findExtension(LanguageBundleEP.class));
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    @Deprecated
    public static ResourceBundle getBundle(@NotNull String baseName) {
        Class callerClass;
        if (baseName == null) {
            DynamicBundle.$$$reportNull$$$1(4);
        }
        if (baseName == null) {
            DynamicBundle.$$$reportNull$$$0(4);
        }
        return DynamicBundle.getBundle(baseName, (callerClass = ReflectionUtil.findCallerClass((int)2)) == null ? DynamicBundle.class : callerClass);
    }

    @Deprecated
    public static ResourceBundle getBundle(@NotNull String baseName, @NotNull Class<?> formClass) {
        if (baseName == null) {
            DynamicBundle.$$$reportNull$$$1(5);
        }
        if (formClass == null) {
            DynamicBundle.$$$reportNull$$$1(6);
        }
        if (baseName == null) {
            DynamicBundle.$$$reportNull$$$0(5);
        }
        if (formClass == null) {
            DynamicBundle.$$$reportNull$$$0(6);
        }
        DynamicBundle dynamic = ourBundlesForForms.computeIfAbsent(baseName, s -> new DynamicBundle((String)s){});
        final ResourceBundle rb = dynamic.getResourceBundle(formClass.getClassLoader());
        if (BundleBase.SHOW_LOCALIZED_MESSAGES) {
            return new ResourceBundle(){

                @Override
                protected Object handleGetObject(@NotNull String key) {
                    if (key == null) {
                        3.$$$reportNull$$$1(0);
                    }
                    if (key == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    Object get2 = rb.getObject(key);
                    assert (get2 instanceof String) : "Language bundles should contain only strings";
                    return BundleBase.appendLocalizationMarker((String)((String)get2));
                }

                @Override
                @NotNull
                public Enumeration<String> getKeys() {
                    Enumeration<String> enumeration = rb.getKeys();
                    if (enumeration == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    if (enumeration == null) {
                        3.$$$reportNull$$$1(1);
                    }
                    return enumeration;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string2;
                    switch (n) {
                        default: {
                            string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: {
                            string2 = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "key";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/DynamicBundle$3";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/DynamicBundle$3";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getKeys";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "handleGetObject";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string3 = String.format(string2, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string3);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalStateException(string3);
                            break;
                        }
                    }
                    throw runtimeException;
                }

                private static /* synthetic */ void $$$reportNull$$$1(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string2;
                    switch (n) {
                        default: {
                            string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: {
                            string2 = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "key";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/DynamicBundle$3";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/DynamicBundle$3";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getKeys";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "handleGetObject";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string3 = String.format(string2, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string3);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalStateException(string3);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            };
        }
        return rb;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToBundle";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseLoader";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "control";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formClass";
                break;
            }
        }
        objectArray2[1] = "com/intellij/DynamicBundle";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findBundle";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getBundle";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static /* synthetic */ void $$$reportNull$$$1(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToBundle";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseLoader";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "control";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formClass";
                break;
            }
        }
        objectArray2[1] = "com/intellij/DynamicBundle";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findBundle";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getBundle";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class LanguageBundleEP
    extends AbstractExtensionPointBean {
        public static final ExtensionPointName<LanguageBundleEP> EP_NAME = ExtensionPointName.create((String)"com.intellij.languageBundle");
    }

    private static class DynamicBundleInternal {
        private static final MethodHandle SET_PARENT;

        private DynamicBundleInternal() {
        }

        static {
            try {
                Method method = ResourceBundle.class.getDeclaredMethod("setParent", ResourceBundle.class);
                method.setAccessible(true);
                SET_PARENT = MethodHandles.lookup().unreflect(method);
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

