/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.frontend.classic.handlers;

import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codeMetaInfo.CodeMetaInfoRendererKt;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.WrappedException;
import org.jetbrains.kotlin.test.directives.FirDiagnosticsDirectives;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.model.AfterAnalysisChecker;
import org.jetbrains.kotlin.test.runners.AbstractFirDiagnosticTest;
import org.jetbrains.kotlin.test.services.AssertionsKt;
import org.jetbrains.kotlin.test.services.KotlinTestInfo;
import org.jetbrains.kotlin.test.services.KotlinTestInfoKt;
import org.jetbrains.kotlin.test.services.TestModuleStructure;
import org.jetbrains.kotlin.test.services.TestModuleStructureKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.utils.FileUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0006H\u0016J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/test/frontend/classic/handlers/FirTestDataConsistencyHandler;", "Lorg/jetbrains/kotlin/test/model/AfterAnalysisChecker;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "directives", "", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "getDirectives", "()Ljava/util/List;", "check", "", "failedAssertions", "Lorg/jetbrains/kotlin/test/WrappedException;", "runFirTestAndGeneratedTestData", "testData", "Ljava/io/File;", "firTestData", "tests-common-new"})
public final class FirTestDataConsistencyHandler
extends AfterAnalysisChecker {
    public FirTestDataConsistencyHandler(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        super(testServices);
    }

    @Override
    @NotNull
    public List<DirectivesContainer> getDirectives() {
        return CollectionsKt.listOf((Object)FirDiagnosticsDirectives.INSTANCE);
    }

    @Override
    public void check(@NotNull List<? extends WrappedException> failedAssertions) {
        Intrinsics.checkNotNullParameter(failedAssertions, (String)"failedAssertions");
        TestModuleStructure moduleStructure = TestModuleStructureKt.getModuleStructure(this.getTestServices());
        File testData = (File)CollectionsKt.first(moduleStructure.getOriginalTestDataFiles());
        if (Intrinsics.areEqual((Object)FilesKt.getExtension((File)testData), (Object)"kts")) {
            return;
        }
        if (moduleStructure.getAllDirectives().contains(FirDiagnosticsDirectives.INSTANCE.getFIR_IDENTICAL())) {
            return;
        }
        File firTestData = FileUtilsKt.getFirTestDataFile(testData);
        if (!firTestData.exists()) {
            this.runFirTestAndGeneratedTestData(testData, firTestData);
            return;
        }
        String string2 = CodeMetaInfoRendererKt.clearTextFromDiagnosticMarkup(FilesKt.readText$default((File)testData, null, (int)1, null));
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String originalFileContent = ((Object)StringsKt.trim((CharSequence)string3)).toString();
        String string4 = CodeMetaInfoRendererKt.clearTextFromDiagnosticMarkup(FilesKt.readText$default((File)firTestData, null, (int)1, null));
        boolean bl2 = false;
        String string5 = string4;
        if (string5 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String firFileContent = ((Object)StringsKt.trim((CharSequence)string5)).toString();
        if (!Intrinsics.areEqual((Object)System.lineSeparator(), (Object)"\n")) {
            originalFileContent = StringsKt.replace$default((String)originalFileContent, (String)"\r\n", (String)"\n", (boolean)false, (int)4, null);
            firFileContent = StringsKt.replace$default((String)firFileContent, (String)"\r\n", (String)"\n", (boolean)false, (int)4, null);
        }
        if (!Intrinsics.areEqual((Object)originalFileContent, (Object)firFileContent)) {
            Assertions.assertEqualsToFile$default(AssertionsKt.getAssertions(this.getTestServices()), firTestData, originalFileContent, null, (Function0)new Function0<String>(testData, firTestData){
                final /* synthetic */ File $testData;
                final /* synthetic */ File $firTestData;
                {
                    this.$testData = $testData;
                    this.$firTestData = $firTestData;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Original and fir test data aren't identical. Please, add changes from " + this.$testData.getName() + " to " + this.$firTestData.getName();
                }
            }, 4, null);
        }
    }

    private final void runFirTestAndGeneratedTestData(File testData, File firTestData) {
        FilesKt.writeText$default((File)firTestData, (String)CodeMetaInfoRendererKt.clearTextFromDiagnosticMarkup(FilesKt.readText$default((File)testData, null, (int)1, null)), null, (int)2, null);
        AbstractFirDiagnosticTest test2 = new AbstractFirDiagnosticTest(){};
        test2.initTestInfo(KotlinTestInfo.copy$default(KotlinTestInfoKt.getTestInfo(this.getTestServices()), Intrinsics.stringPlus((String)KotlinTestInfoKt.getTestInfo(this.getTestServices()).getClassName(), (Object)"_fir_anonymous"), null, null, 6, null));
        String string2 = firTestData.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"firTestData.absolutePath");
        test2.runTest(string2);
    }
}

