/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.services;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.CompilerConfigurationKey;
import org.jetbrains.kotlin.test.directives.model.Directive;
import org.jetbrains.kotlin.test.directives.model.DirectiveKt;
import org.jetbrains.kotlin.test.directives.model.RegisteredDirectives;
import org.jetbrains.kotlin.test.directives.model.SimpleDirective;
import org.jetbrains.kotlin.test.directives.model.ValueDirective;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J&\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00052\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\b\u0002\u0010\u0015\u001a\u00020\u0007J,\u0010\u0012\u001a\u00020\r\"\b\b\u0000\u0010\u0016*\u00020\u00012\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00160\u000b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0006R \u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\n\u001a\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/test/services/DirectiveToConfigurationKeyExtractor;", "", "()V", "booleanDirectivesMap", "", "Lorg/jetbrains/kotlin/test/directives/model/SimpleDirective;", "Lorg/jetbrains/kotlin/config/CompilerConfigurationKey;", "", "invertedBooleanDirectives", "", "valueDirectivesMap", "Lorg/jetbrains/kotlin/test/directives/model/ValueDirective;", "configure", "", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "registeredDirectives", "Lorg/jetbrains/kotlin/test/directives/model/RegisteredDirectives;", "register", "directive", "key", "isInverted", "T", "test-infrastructure"})
public final class DirectiveToConfigurationKeyExtractor {
    @NotNull
    private final Map<SimpleDirective, CompilerConfigurationKey<Boolean>> booleanDirectivesMap;
    @NotNull
    private final Set<SimpleDirective> invertedBooleanDirectives;
    @NotNull
    private final Map<ValueDirective<?>, CompilerConfigurationKey<?>> valueDirectivesMap;

    public DirectiveToConfigurationKeyExtractor() {
        boolean bl = false;
        this.booleanDirectivesMap = new LinkedHashMap();
        bl = false;
        this.invertedBooleanDirectives = new LinkedHashSet();
        bl = false;
        this.valueDirectivesMap = new LinkedHashMap();
    }

    public final void register(@NotNull SimpleDirective directive2, @NotNull CompilerConfigurationKey<Boolean> key, boolean isInverted) {
        Intrinsics.checkNotNullParameter((Object)directive2, (String)"directive");
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Object object = this.booleanDirectivesMap;
        boolean bl = false;
        object.put((SimpleDirective)directive2, key);
        if (isInverted) {
            object = this;
            Collection collection = ((DirectiveToConfigurationKeyExtractor)object).invertedBooleanDirectives;
            boolean bl2 = false;
            collection.add(directive2);
        }
    }

    public static /* synthetic */ void register$default(DirectiveToConfigurationKeyExtractor directiveToConfigurationKeyExtractor, SimpleDirective simpleDirective, CompilerConfigurationKey compilerConfigurationKey, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        directiveToConfigurationKeyExtractor.register(simpleDirective, compilerConfigurationKey, bl);
    }

    public final <T> void register(@NotNull ValueDirective<T> directive2, @NotNull CompilerConfigurationKey<T> key) {
        Intrinsics.checkNotNullParameter(directive2, (String)"directive");
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Map<ValueDirective<?>, CompilerConfigurationKey<?>> map = this.valueDirectivesMap;
        boolean bl = false;
        map.put(directive2, key);
    }

    public final void configure(@NotNull CompilerConfiguration configuration2, @NotNull RegisteredDirectives registeredDirectives) {
        CompilerConfigurationKey<Boolean> key;
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)registeredDirectives, (String)"registeredDirectives");
        Map<SimpleDirective, CompilerConfigurationKey<Boolean>> entry4 = this.booleanDirectivesMap;
        boolean bl = false;
        Iterator<Map.Entry<Directive, CompilerConfigurationKey<Boolean>>> iterator2 = entry4.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<SimpleDirective, CompilerConfigurationKey<Boolean>> entry;
            Map.Entry<SimpleDirective, CompilerConfigurationKey<Boolean>> entry2 = entry = iterator2.next();
            boolean bl2 = false;
            SimpleDirective directive2 = entry2.getKey();
            Map.Entry<SimpleDirective, CompilerConfigurationKey<Boolean>> entry3 = entry;
            boolean bl3 = false;
            key = entry3.getValue();
            if (!registeredDirectives.contains(directive2)) continue;
            boolean value232 = !this.invertedBooleanDirectives.contains(directive2);
            configuration2.put(key, value232);
        }
        Map<ValueDirective<?>, CompilerConfigurationKey<?>> map = this.valueDirectivesMap;
        boolean directive2 = false;
        for (Map.Entry<Directive, CompilerConfigurationKey<Boolean>> entry : map.entrySet()) {
            key = entry;
            boolean value232 = false;
            ValueDirective directive3 = (ValueDirective)key.getKey();
            Map.Entry<Directive, CompilerConfigurationKey<Boolean>> value232 = entry;
            boolean bl4 = false;
            key = value232.getValue();
            Object t = DirectiveKt.singleOrZeroValue(registeredDirectives, directive3);
            if (t == null) continue;
            Object value2 = t;
            configuration2.put(key, value2);
        }
    }
}

