/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.builders;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.test.directives.model.Directive;
import org.jetbrains.kotlin.test.directives.model.RegisteredDirectives;
import org.jetbrains.kotlin.test.directives.model.RegisteredDirectivesImpl;
import org.jetbrains.kotlin.test.directives.model.SimpleDirective;
import org.jetbrains.kotlin.test.directives.model.StringDirective;
import org.jetbrains.kotlin.test.directives.model.ValueDirective;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\r\u001a\u00020\u000eJ=\u0010\u000f\u001a\u00020\u0010\"\b\b\u0000\u0010\u0011*\u00020\u0012\"\u0004\b\u0001\u0010\u0013*\u000e\u0012\u0004\u0012\u0002H\u0011\u0012\u0004\u0012\u0002H\u00130\u00072\u0006\u0010\u0014\u001a\u0002H\u00112\u0006\u0010\u0015\u001a\u0002H\u0013H\u0002\u00a2\u0006\u0002\u0010\u0016J\r\u0010\u0017\u001a\u00020\u0010*\u00020\u0005H\u0086\u0002J\r\u0010\u0017\u001a\u00020\u0010*\u00020\bH\u0086\u0002J\u0011\u0010\u0017\u001a\u00020\u0010*\u0006\u0012\u0002\b\u00030\fH\u0086\u0002J\r\u0010\u0018\u001a\u00020\u0010*\u00020\u0005H\u0086\u0002J\u0015\u0010\u0019\u001a\u00020\u0010*\u00020\b2\u0006\u0010\u0015\u001a\u00020\nH\u0086\u0004J\u001b\u0010\u0019\u001a\u00020\u0010*\u00020\b2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0086\u0004J*\u0010\u0019\u001a\u00020\u0010\"\b\b\u0000\u0010\u001b*\u00020\u0001*\b\u0012\u0004\u0012\u0002H\u001b0\f2\u0006\u0010\u0015\u001a\u0002H\u001bH\u0086\u0004\u00a2\u0006\u0002\u0010\u001cJ+\u0010\u0019\u001a\u00020\u0010\"\b\b\u0000\u0010\u001b*\u00020\u0001*\b\u0012\u0004\u0012\u0002H\u001b0\f2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u001b0\tH\u0086\u0004R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000b\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/test/builders/RegisteredDirectivesBuilder;", "", "()V", "simpleDirectives", "", "Lorg/jetbrains/kotlin/test/directives/model/SimpleDirective;", "stringDirectives", "", "Lorg/jetbrains/kotlin/test/directives/model/StringDirective;", "", "", "valueDirectives", "Lorg/jetbrains/kotlin/test/directives/model/ValueDirective;", "build", "Lorg/jetbrains/kotlin/test/directives/model/RegisteredDirectives;", "putWithExistsCheck", "", "K", "Lorg/jetbrains/kotlin/test/directives/model/Directive;", "V", "key", "value", "(Ljava/util/Map;Lorg/jetbrains/kotlin/test/directives/model/Directive;Ljava/lang/Object;)V", "unaryMinus", "unaryPlus", "with", "values", "T", "(Lorg/jetbrains/kotlin/test/directives/model/ValueDirective;Ljava/lang/Object;)V", "tests-common-new"})
public final class RegisteredDirectivesBuilder {
    @NotNull
    private final List<SimpleDirective> simpleDirectives;
    @NotNull
    private final Map<StringDirective, List<String>> stringDirectives;
    @NotNull
    private final Map<ValueDirective<?>, List<Object>> valueDirectives;

    public RegisteredDirectivesBuilder() {
        boolean bl = false;
        this.simpleDirectives = new ArrayList();
        bl = false;
        this.stringDirectives = new LinkedHashMap();
        bl = false;
        this.valueDirectives = new LinkedHashMap();
    }

    public final void unaryPlus(@NotNull SimpleDirective $this$unaryPlus) {
        Intrinsics.checkNotNullParameter((Object)$this$unaryPlus, (String)"<this>");
        RegisteredDirectivesBuilder registeredDirectivesBuilder = this;
        Collection collection = registeredDirectivesBuilder.simpleDirectives;
        boolean bl = false;
        collection.add($this$unaryPlus);
    }

    public final void unaryMinus(@NotNull SimpleDirective $this$unaryMinus) {
        Intrinsics.checkNotNullParameter((Object)$this$unaryMinus, (String)"<this>");
        this.simpleDirectives.remove($this$unaryMinus);
    }

    public final void with(@NotNull StringDirective $this$with, @NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)$this$with, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.with($this$with, CollectionsKt.listOf((Object)value2));
    }

    public final void with(@NotNull StringDirective $this$with, @NotNull List<String> values2) {
        Intrinsics.checkNotNullParameter((Object)$this$with, (String)"<this>");
        Intrinsics.checkNotNullParameter(values2, (String)"values");
        this.putWithExistsCheck(this.stringDirectives, (Directive)$this$with, values2);
    }

    public final void unaryMinus(@NotNull StringDirective $this$unaryMinus) {
        Intrinsics.checkNotNullParameter((Object)$this$unaryMinus, (String)"<this>");
        this.stringDirectives.remove($this$unaryMinus);
    }

    public final <T> void with(@NotNull ValueDirective<T> $this$with, @NotNull T value2) {
        Intrinsics.checkNotNullParameter($this$with, (String)"<this>");
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        this.with($this$with, CollectionsKt.listOf(value2));
    }

    public final <T> void with(@NotNull ValueDirective<T> $this$with, @NotNull List<? extends T> values2) {
        Intrinsics.checkNotNullParameter($this$with, (String)"<this>");
        Intrinsics.checkNotNullParameter(values2, (String)"values");
        this.putWithExistsCheck(this.valueDirectives, (Directive)$this$with, values2);
    }

    public final void unaryMinus(@NotNull ValueDirective<?> $this$unaryMinus) {
        Intrinsics.checkNotNullParameter($this$unaryMinus, (String)"<this>");
        this.valueDirectives.remove($this$unaryMinus);
    }

    private final <K extends Directive, V> void putWithExistsCheck(Map<K, V> $this$putWithExistsCheck, K key, V value2) {
        V alreadyRegistered = $this$putWithExistsCheck.put(key, value2);
        if (alreadyRegistered != null) {
            String string2 = "Default values for " + key + " directive already registered";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
    }

    @NotNull
    public final RegisteredDirectives build() {
        return new RegisteredDirectivesImpl(this.simpleDirectives, this.stringDirectives, this.valueDirectives);
    }
}

