/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codeMetaInfo.renderConfigurations;

import com.intellij.openapi.util.text.StringUtil;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codeMetaInfo.model.CodeMetaInfo;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0004J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000bH\u0004J\u0012\u0010\u0012\u001a\u00020\u000b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000bH\u0004R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\u0004\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/codeMetaInfo/renderConfigurations/AbstractCodeMetaInfoRenderConfiguration;", "", "renderParams", "", "(Z)V", "clickOrPressRegex", "Lkotlin/text/Regex;", "getRenderParams", "()Z", "setRenderParams", "asString", "", "codeMetaInfo", "Lorg/jetbrains/kotlin/codeMetaInfo/model/CodeMetaInfo;", "getAdditionalParams", "getAttributesString", "sanitizeLineBreaks", "originalText", "sanitizeLineMarkerTooltip", "test-infrastructure-utils"})
public abstract class AbstractCodeMetaInfoRenderConfiguration {
    private boolean renderParams;
    @NotNull
    private final Regex clickOrPressRegex;

    public AbstractCodeMetaInfoRenderConfiguration(boolean renderParams) {
        this.renderParams = renderParams;
        String string2 = "Click or press (.*)to navigate";
        boolean bl = false;
        this.clickOrPressRegex = new Regex(string2);
    }

    public /* synthetic */ AbstractCodeMetaInfoRenderConfiguration(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        this(bl);
    }

    public final boolean getRenderParams() {
        return this.renderParams;
    }

    public final void setRenderParams(boolean bl) {
        this.renderParams = bl;
    }

    @NotNull
    public String asString(@NotNull CodeMetaInfo codeMetaInfo) {
        Intrinsics.checkNotNullParameter((Object)codeMetaInfo, (String)"codeMetaInfo");
        return Intrinsics.stringPlus((String)codeMetaInfo.getTag(), (Object)this.getAttributesString(codeMetaInfo));
    }

    @NotNull
    public String getAdditionalParams(@NotNull CodeMetaInfo codeMetaInfo) {
        Intrinsics.checkNotNullParameter((Object)codeMetaInfo, (String)"codeMetaInfo");
        return "";
    }

    @NotNull
    protected final String sanitizeLineMarkerTooltip(@Nullable String originalText) {
        if (originalText == null) {
            return "null";
        }
        CharSequence charSequence = StringUtil.removeHtmlTags((String)originalText);
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"removeHtmlTags(originalText)");
        charSequence = StringsKt.replace$default((String)charSequence, (String)"\u00a0", (String)"", (boolean)false, (int)4, null);
        Regex regex = this.clickOrPressRegex;
        String string2 = "";
        boolean bl = false;
        charSequence = regex.replace(charSequence, string2);
        boolean bl2 = false;
        CharSequence charSequence2 = charSequence;
        if (charSequence2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        String noHtmlTags = ((Object)StringsKt.trim((CharSequence)charSequence2)).toString();
        return this.sanitizeLineBreaks(noHtmlTags);
    }

    @NotNull
    protected final String sanitizeLineBreaks(@NotNull String originalText) {
        Intrinsics.checkNotNullParameter((Object)originalText, (String)"originalText");
        String sanitizedText = originalText;
        String string2 = StringUtil.replace((String)sanitizedText, (String)"\r\n", (String)" ");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"replace(sanitizedText, \"\\r\\n\", \" \")");
        sanitizedText = string2;
        string2 = StringUtil.replace((String)sanitizedText, (String)"\n", (String)" ");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"replace(sanitizedText, \"\\n\", \" \")");
        sanitizedText = string2;
        string2 = StringUtil.replace((String)sanitizedText, (String)"\r", (String)" ");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"replace(sanitizedText, \"\\r\", \" \")");
        sanitizedText = string2;
        return sanitizedText;
    }

    @NotNull
    protected final String getAttributesString(@NotNull CodeMetaInfo codeMetaInfo) {
        Intrinsics.checkNotNullParameter((Object)codeMetaInfo, (String)"codeMetaInfo");
        if (codeMetaInfo.getAttributes().isEmpty()) {
            return "";
        }
        return '{' + CollectionsKt.joinToString$default((Iterable)codeMetaInfo.getAttributes(), (CharSequence)";", null, null, (int)0, null, null, (int)62, null) + '}';
    }

    public AbstractCodeMetaInfoRenderConfiguration() {
        this(false, 1, null);
    }
}

