/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.builders;

import com.intellij.openapi.Disposable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.test.TestConfiguration;
import org.jetbrains.kotlin.test.TestInfrastructureInternals;
import org.jetbrains.kotlin.test.builders.DefaultsProviderBuilder;
import org.jetbrains.kotlin.test.builders.RegisteredDirectivesBuilder;
import org.jetbrains.kotlin.test.directives.model.DirectivesContainer;
import org.jetbrains.kotlin.test.impl.TestConfigurationImpl;
import org.jetbrains.kotlin.test.model.AbstractTestFacade;
import org.jetbrains.kotlin.test.model.AfterAnalysisChecker;
import org.jetbrains.kotlin.test.model.AnalysisHandler;
import org.jetbrains.kotlin.test.model.BackendFacade;
import org.jetbrains.kotlin.test.model.BackendInputHandler;
import org.jetbrains.kotlin.test.model.BinaryArtifactHandler;
import org.jetbrains.kotlin.test.model.Frontend2BackendConverter;
import org.jetbrains.kotlin.test.model.FrontendFacade;
import org.jetbrains.kotlin.test.model.FrontendOutputHandler;
import org.jetbrains.kotlin.test.services.AdditionalMetaInfoProcessor;
import org.jetbrains.kotlin.test.services.AdditionalSourceProvider;
import org.jetbrains.kotlin.test.services.AssertionsService;
import org.jetbrains.kotlin.test.services.CompilerConfigurationProvider;
import org.jetbrains.kotlin.test.services.DefaultsDsl;
import org.jetbrains.kotlin.test.services.EnvironmentConfigurator;
import org.jetbrains.kotlin.test.services.KotlinTestInfo;
import org.jetbrains.kotlin.test.services.MetaTestConfigurator;
import org.jetbrains.kotlin.test.services.ModuleStructureTransformer;
import org.jetbrains.kotlin.test.services.ServiceRegistrationData;
import org.jetbrains.kotlin.test.services.SourceFilePreprocessor;
import org.jetbrains.kotlin.test.services.TestService;
import org.jetbrains.kotlin.test.services.TestServices;

@DefaultsDsl
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00f0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020AJ%\u0010B\u001a\u00020\u001e2\u0017\u0010C\u001a\u0013\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u001e0\u0005\u00a2\u0006\u0002\b\u001fH\u0086\b\u00f8\u0001\u0000J\u0006\u0010D\u001a\u00020\u001eJ'\u0010E\u001a\u00020\u001e2\u0006\u0010F\u001a\u00020A2\u0017\u0010G\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u001e0\u0005\u00a2\u0006\u0002\b\u001fJ'\u0010E\u001a\u00020\u001e2\u0006\u0010F\u001a\u00020\u001d2\u0017\u0010G\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u001e0\u0005\u00a2\u0006\u0002\b\u001fJ'\u0010H\u001a\u00020\u001e2\u0006\u0010F\u001a\u00020A2\u0017\u0010G\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u001e0\u0005\u00a2\u0006\u0002\b\u001fJ'\u0010H\u001a\u00020\u001e2\u0006\u0010F\u001a\u00020\u001d2\u0017\u0010G\u001a\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u001e0\u0005\u00a2\u0006\u0002\b\u001fJ%\u0010I\u001a\u00020\u001e2\u0017\u0010C\u001a\u0013\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020\u001e0\u0005\u00a2\u0006\u0002\b\u001fH\u0086\b\u00f8\u0001\u0000J\u0006\u0010J\u001a\u00020\u001eJ.\u0010K\u001a\u00020\u001e\"\n\b\u0000\u0010L\u0018\u0001*\u00020M2\u0014\b\b\u0010N\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u0002HL0\u0005H\u0086\b\u00f8\u0001\u0000J\u000e\u0010K\u001a\u00020\u001e2\u0006\u0010O\u001a\u00020\nJK\u0010P\u001a\u00020\u001e2>\u0010Q\u001a \u0012\u001c\b\u0001\u0012\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\f0\u0005j\b\u0012\u0004\u0012\u00020\f`\b0R\"\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\f0\u0005j\b\u0012\u0004\u0012\u00020\f`\b\u00a2\u0006\u0002\u0010SJK\u0010T\u001a\u00020\u001e2>\u0010U\u001a \u0012\u001c\b\u0001\u0012\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000e0\u0005j\b\u0012\u0004\u0012\u00020\u000e`\b0R\"\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000e0\u0005j\b\u0012\u0004\u0012\u00020\u000e`\b\u00a2\u0006\u0002\u0010SJ[\u0010V\u001a\u00020\u001e2N\u0010W\u001a(\u0012$\b\u0001\u0012 \u0012\u0004\u0012\u00020\u0006\u0012\b\u0012\u0006\u0012\u0002\b\u00030X0\u0005j\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030X`\b0R\" \u0012\u0004\u0012\u00020\u0006\u0012\b\u0012\u0006\u0012\u0002\b\u00030X0\u0005j\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030X`\b\u00a2\u0006\u0002\u0010SJk\u0010Y\u001a\u00020\u001e2^\u0010W\u001a0\u0012,\b\u0001\u0012(\u0012\u0004\u0012\u00020\u0006\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030Z0\u0005j\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030Z`\b0R\"(\u0012\u0004\u0012\u00020\u0006\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030Z0\u0005j\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030Z`\b\u00a2\u0006\u0002\u0010SJ[\u0010[\u001a\u00020\u001e2N\u0010W\u001a(\u0012$\b\u0001\u0012 \u0012\u0004\u0012\u00020\u0006\u0012\b\u0012\u0006\u0012\u0002\b\u00030\\0\u0005j\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\\`\b0R\" \u0012\u0004\u0012\u00020\u0006\u0012\b\u0012\u0006\u0012\u0002\b\u00030\\0\u0005j\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\\`\b\u00a2\u0006\u0002\u0010SJK\u0010]\u001a\u00020\u001e2>\u0010+\u001a \u0012\u001c\b\u0001\u0012\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00190\u0005j\b\u0012\u0004\u0012\u00020\u0019`\b0R\"\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00190\u0005j\b\u0012\u0004\u0012\u00020\u0019`\b\u00a2\u0006\u0002\u0010SJ(\u0010^\u001a\u00020\u001e2\u001e\u0010_\u001a\u001a\u0012\u0004\u0012\u00020\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u0018\u0012\u0004\u0012\u00020\u001a0\u0016H\u0007J\u001f\u0010`\u001a\u00020\u001e2\u0012\u0010)\u001a\n\u0012\u0006\b\u0001\u0012\u00020*0R\"\u00020*\u00a2\u0006\u0002\u0010aJk\u0010b\u001a\u00020\u001e2^\u0010W\u001a0\u0012,\b\u0001\u0012(\u0012\u0004\u0012\u00020\u0006\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030c0\u0005j\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030c`\b0R\"(\u0012\u0004\u0012\u00020\u0006\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030c0\u0005j\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030c`\b\u00a2\u0006\u0002\u0010SJ[\u0010d\u001a\u00020\u001e2N\u0010W\u001a(\u0012$\b\u0001\u0012 \u0012\u0004\u0012\u00020\u0006\u0012\b\u0012\u0006\u0012\u0002\b\u00030e0\u0005j\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030e`\b0R\" \u0012\u0004\u0012\u00020\u0006\u0012\b\u0012\u0006\u0012\u0002\b\u00030e0\u0005j\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030e`\b\u00a2\u0006\u0002\u0010SJ[\u0010f\u001a\u00020\u001e2N\u0010W\u001a(\u0012$\b\u0001\u0012 \u0012\u0004\u0012\u00020\u0006\u0012\b\u0012\u0006\u0012\u0002\b\u00030g0\u0005j\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030g`\b0R\" \u0012\u0004\u0012\u00020\u0006\u0012\b\u0012\u0006\u0012\u0002\b\u00030g0\u0005j\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030g`\b\u00a2\u0006\u0002\u0010SJK\u0010h\u001a\u00020\u001e2>\u0010i\u001a \u0012\u001c\b\u0001\u0012\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\b\u0012\u0004\u0012\u00020\u0007`\b0R\"\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\b\u0012\u0004\u0012\u00020\u0007`\b\u00a2\u0006\u0002\u0010SJK\u0010j\u001a\u00020\u001e2>\u0010k\u001a \u0012\u001c\b\u0001\u0012\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u0002030\u0005j\b\u0012\u0004\u0012\u000203`\b0R\"\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u0002030\u0005j\b\u0012\u0004\u0012\u000203`\b\u00a2\u0006\u0002\u0010SJ!\u0010l\u001a\u00020\u001e2\u0012\u0010m\u001a\n\u0012\u0006\b\u0001\u0012\u0002050R\"\u000205H\u0007\u00a2\u0006\u0002\u0010nJU\u0010o\u001a\u00020\u001e2>\u0010p\u001a \u0012\u001c\b\u0001\u0012\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u0002070\u0005j\b\u0012\u0004\u0012\u000207`\b0R\"\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u0002070\u0005j\b\u0012\u0004\u0012\u000207`\b2\b\b\u0002\u0010q\u001a\u000201\u00a2\u0006\u0002\u0010rJ\u0015\u0010s\u001a\u00020A*\u00020A2\u0006\u0010t\u001a\u00020AH\u0086\u0004J\f\u0010u\u001a\u00020A*\u00020AH\u0002R*\u0010\u0003\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\b\u0012\u0004\u0012\u00020\u0007`\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000b\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\f0\u0005j\b\u0012\u0004\u0012\u00020\f`\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\r\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000e0\u0005j\b\u0012\u0004\u0012\u00020\u000e`\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R(\u0010\u0015\u001a\u001c\u0012\u0004\u0012\u00020\u0017\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u0018\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R1\u0010\u001b\u001a%\u0012!\u0012\u001f\u0012\u0004\u0012\u00020\u001d\u0012\u0015\u0012\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u001e0\u0005\u00a2\u0006\u0002\b\u001f0\u001c0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R1\u0010 \u001a%\u0012!\u0012\u001f\u0012\u0004\u0012\u00020\u001d\u0012\u0015\u0012\u0013\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u001e0\u0005\u00a2\u0006\u0002\b\u001f0\u001c0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010!\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020&\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0014\u0010)\u001a\b\u0012\u0004\u0012\u00020*0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010+\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00190\u0005j\b\u0012\u0004\u0012\u00020\u0019`\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R:\u0010,\u001a.\u0012*\u0012(\u0012\u0004\u0012\u00020\u0006\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030-0\u0005j\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030-`\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010.\u001a&\u0012\"\u0012 \u0012\u0004\u0012\u00020\u0006\u0012\b\u0012\u0006\u0012\u0002\b\u00030/0\u0005j\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030/`\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u000201X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u00102\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u0002030\u0005j\b\u0012\u0004\u0012\u000203`\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00104\u001a\b\u0012\u0004\u0012\u0002050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u00106\u001a\u001e\u0012\u001a\u0012\u0018\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u0002070\u0005j\b\u0012\u0004\u0012\u000207`\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00108\u001a\u000209X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006v"}, d2={"Lorg/jetbrains/kotlin/test/builders/TestConfigurationBuilder;", "", "()V", "additionalMetaInfoProcessors", "", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/test/services/TestServices;", "Lorg/jetbrains/kotlin/test/services/AdditionalMetaInfoProcessor;", "Lorg/jetbrains/kotlin/test/Constructor;", "additionalServices", "Lorg/jetbrains/kotlin/test/services/ServiceRegistrationData;", "additionalSourceProviders", "Lorg/jetbrains/kotlin/test/services/AdditionalSourceProvider;", "afterAnalysisCheckers", "Lorg/jetbrains/kotlin/test/model/AfterAnalysisChecker;", "assertions", "Lorg/jetbrains/kotlin/test/services/AssertionsService;", "getAssertions", "()Lorg/jetbrains/kotlin/test/services/AssertionsService;", "setAssertions", "(Lorg/jetbrains/kotlin/test/services/AssertionsService;)V", "compilerConfigurationProvider", "Lkotlin/Function2;", "Lcom/intellij/openapi/Disposable;", "", "Lorg/jetbrains/kotlin/test/services/EnvironmentConfigurator;", "Lorg/jetbrains/kotlin/test/services/CompilerConfigurationProvider;", "configurationsByNegativeTestDataCondition", "Lkotlin/Pair;", "Lkotlin/text/Regex;", "", "Lkotlin/ExtensionFunctionType;", "configurationsByPositiveTestDataCondition", "defaultRegisteredDirectivesBuilder", "Lorg/jetbrains/kotlin/test/builders/RegisteredDirectivesBuilder;", "getDefaultRegisteredDirectivesBuilder", "()Lorg/jetbrains/kotlin/test/builders/RegisteredDirectivesBuilder;", "defaultsProviderBuilder", "Lorg/jetbrains/kotlin/test/builders/DefaultsProviderBuilder;", "getDefaultsProviderBuilder", "()Lorg/jetbrains/kotlin/test/builders/DefaultsProviderBuilder;", "directives", "Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;", "environmentConfigurators", "facades", "Lorg/jetbrains/kotlin/test/model/AbstractTestFacade;", "handlers", "Lorg/jetbrains/kotlin/test/model/AnalysisHandler;", "metaInfoHandlerEnabled", "", "metaTestConfigurators", "Lorg/jetbrains/kotlin/test/services/MetaTestConfigurator;", "moduleStructureTransformers", "Lorg/jetbrains/kotlin/test/services/ModuleStructureTransformer;", "sourcePreprocessors", "Lorg/jetbrains/kotlin/test/services/SourceFilePreprocessor;", "testInfo", "Lorg/jetbrains/kotlin/test/services/KotlinTestInfo;", "getTestInfo", "()Lorg/jetbrains/kotlin/test/services/KotlinTestInfo;", "setTestInfo", "(Lorg/jetbrains/kotlin/test/services/KotlinTestInfo;)V", "build", "Lorg/jetbrains/kotlin/test/TestConfiguration;", "testDataPath", "", "defaultDirectives", "init", "enableMetaInfoHandler", "forTestsMatching", "pattern", "configuration", "forTestsNotMatching", "globalDefaults", "unregisterAllFacades", "useAdditionalService", "T", "Lorg/jetbrains/kotlin/test/services/TestService;", "serviceConstructor", "serviceRegistrationData", "useAdditionalSourceProviders", "providers", "", "([Lkotlin/jvm/functions/Function1;)V", "useAfterAnalysisCheckers", "checkers", "useArtifactsHandlers", "constructor", "Lorg/jetbrains/kotlin/test/model/BinaryArtifactHandler;", "useBackendFacades", "Lorg/jetbrains/kotlin/test/model/BackendFacade;", "useBackendHandlers", "Lorg/jetbrains/kotlin/test/model/BackendInputHandler;", "useConfigurators", "useCustomCompilerConfigurationProvider", "provider", "useDirectives", "([Lorg/jetbrains/kotlin/test/directives/model/DirectivesContainer;)V", "useFrontend2BackendConverters", "Lorg/jetbrains/kotlin/test/model/Frontend2BackendConverter;", "useFrontendFacades", "Lorg/jetbrains/kotlin/test/model/FrontendFacade;", "useFrontendHandlers", "Lorg/jetbrains/kotlin/test/model/FrontendOutputHandler;", "useMetaInfoProcessors", "updaters", "useMetaTestConfigurators", "configurators", "useModuleStructureTransformers", "transformers", "([Lorg/jetbrains/kotlin/test/services/ModuleStructureTransformer;)V", "useSourcePreprocessor", "preprocessors", "needToPrepend", "([Lkotlin/jvm/functions/Function1;Z)V", "or", "other", "toMatchingRegexString", "tests-common-new"})
public final class TestConfigurationBuilder {
    @NotNull
    private final DefaultsProviderBuilder defaultsProviderBuilder = new DefaultsProviderBuilder();
    public AssertionsService assertions;
    @NotNull
    private final List<Function1<TestServices, AbstractTestFacade<?, ?>>> facades;
    @NotNull
    private final List<Function1<TestServices, AnalysisHandler<?>>> handlers;
    @NotNull
    private final List<Function1<TestServices, SourceFilePreprocessor>> sourcePreprocessors;
    @NotNull
    private final List<Function1<TestServices, AdditionalMetaInfoProcessor>> additionalMetaInfoProcessors;
    @NotNull
    private final List<Function1<TestServices, EnvironmentConfigurator>> environmentConfigurators;
    @NotNull
    private final List<Function1<TestServices, AdditionalSourceProvider>> additionalSourceProviders;
    @NotNull
    private final List<ModuleStructureTransformer> moduleStructureTransformers;
    @NotNull
    private final List<Function1<TestServices, MetaTestConfigurator>> metaTestConfigurators;
    @NotNull
    private final List<Function1<TestServices, AfterAnalysisChecker>> afterAnalysisCheckers;
    private boolean metaInfoHandlerEnabled;
    @NotNull
    private final List<DirectivesContainer> directives;
    @NotNull
    private final RegisteredDirectivesBuilder defaultRegisteredDirectivesBuilder;
    @NotNull
    private final List<Pair<Regex, Function1<TestConfigurationBuilder, Unit>>> configurationsByPositiveTestDataCondition;
    @NotNull
    private final List<Pair<Regex, Function1<TestConfigurationBuilder, Unit>>> configurationsByNegativeTestDataCondition;
    @NotNull
    private final List<ServiceRegistrationData> additionalServices;
    @Nullable
    private Function2<? super Disposable, ? super List<? extends EnvironmentConfigurator>, ? extends CompilerConfigurationProvider> compilerConfigurationProvider;
    public KotlinTestInfo testInfo;

    public TestConfigurationBuilder() {
        boolean bl = false;
        this.facades = new ArrayList();
        bl = false;
        this.handlers = new ArrayList();
        bl = false;
        this.sourcePreprocessors = new ArrayList();
        bl = false;
        this.additionalMetaInfoProcessors = new ArrayList();
        bl = false;
        this.environmentConfigurators = new ArrayList();
        bl = false;
        this.additionalSourceProviders = new ArrayList();
        bl = false;
        this.moduleStructureTransformers = new ArrayList();
        bl = false;
        this.metaTestConfigurators = new ArrayList();
        bl = false;
        this.afterAnalysisCheckers = new ArrayList();
        bl = false;
        this.directives = new ArrayList();
        this.defaultRegisteredDirectivesBuilder = new RegisteredDirectivesBuilder();
        bl = false;
        this.configurationsByPositiveTestDataCondition = new ArrayList();
        bl = false;
        this.configurationsByNegativeTestDataCondition = new ArrayList();
        bl = false;
        this.additionalServices = new ArrayList();
    }

    @NotNull
    public final DefaultsProviderBuilder getDefaultsProviderBuilder() {
        return this.defaultsProviderBuilder;
    }

    @NotNull
    public final AssertionsService getAssertions() {
        AssertionsService assertionsService = this.assertions;
        if (assertionsService != null) {
            return assertionsService;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"assertions");
        return null;
    }

    public final void setAssertions(@NotNull AssertionsService assertionsService) {
        Intrinsics.checkNotNullParameter((Object)assertionsService, (String)"<set-?>");
        this.assertions = assertionsService;
    }

    @NotNull
    public final RegisteredDirectivesBuilder getDefaultRegisteredDirectivesBuilder() {
        return this.defaultRegisteredDirectivesBuilder;
    }

    @NotNull
    public final KotlinTestInfo getTestInfo() {
        KotlinTestInfo kotlinTestInfo = this.testInfo;
        if (kotlinTestInfo != null) {
            return kotlinTestInfo;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"testInfo");
        return null;
    }

    public final void setTestInfo(@NotNull KotlinTestInfo kotlinTestInfo) {
        Intrinsics.checkNotNullParameter((Object)kotlinTestInfo, (String)"<set-?>");
        this.testInfo = kotlinTestInfo;
    }

    public final /* synthetic */ <T extends TestService> void useAdditionalService(Function1<? super TestServices, ? extends T> serviceConstructor) {
        Intrinsics.checkNotNullParameter(serviceConstructor, (String)"serviceConstructor");
        boolean $i$f$useAdditionalService = false;
        boolean $i$f$service = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        this.useAdditionalService(new ServiceRegistrationData((KClass<? extends TestService>)Reflection.getOrCreateKotlinClass(TestService.class), serviceConstructor));
    }

    public final void useAdditionalService(@NotNull ServiceRegistrationData serviceRegistrationData) {
        Intrinsics.checkNotNullParameter((Object)serviceRegistrationData, (String)"serviceRegistrationData");
        TestConfigurationBuilder testConfigurationBuilder = this;
        Collection collection = testConfigurationBuilder.additionalServices;
        boolean bl = false;
        collection.add(serviceRegistrationData);
    }

    public final void forTestsMatching(@NotNull String pattern, @NotNull Function1<? super TestConfigurationBuilder, Unit> configuration2) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter(configuration2, (String)"configuration");
        String string2 = this.toMatchingRegexString(pattern);
        boolean bl = false;
        Regex regex = new Regex(string2);
        this.forTestsMatching(regex, configuration2);
    }

    public final void forTestsNotMatching(@NotNull String pattern, @NotNull Function1<? super TestConfigurationBuilder, Unit> configuration2) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter(configuration2, (String)"configuration");
        String string2 = this.toMatchingRegexString(pattern);
        boolean bl = false;
        Regex regex = new Regex(string2);
        this.forTestsNotMatching(regex, configuration2);
    }

    @NotNull
    public final String or(@NotNull String $this$or, @NotNull String other) {
        Intrinsics.checkNotNullParameter((Object)$this$or, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return $this$or + '|' + other;
    }

    private final String toMatchingRegexString(String $this$toMatchingRegexString) {
        String string2 = $this$toMatchingRegexString;
        return Intrinsics.areEqual((Object)string2, (Object)"*") ? ".*" : "^.*/(" + StringsKt.replace$default((String)$this$toMatchingRegexString, (String)"*", (String)".*", (boolean)false, (int)4, null) + ")$";
    }

    public final void forTestsMatching(@NotNull Regex pattern, @NotNull Function1<? super TestConfigurationBuilder, Unit> configuration2) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter(configuration2, (String)"configuration");
        TestConfigurationBuilder testConfigurationBuilder = this;
        Collection collection = testConfigurationBuilder.configurationsByPositiveTestDataCondition;
        Pair pair = TuplesKt.to((Object)pattern, configuration2);
        boolean bl = false;
        collection.add(pair);
    }

    public final void forTestsNotMatching(@NotNull Regex pattern, @NotNull Function1<? super TestConfigurationBuilder, Unit> configuration2) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter(configuration2, (String)"configuration");
        TestConfigurationBuilder testConfigurationBuilder = this;
        Collection collection = testConfigurationBuilder.configurationsByNegativeTestDataCondition;
        Pair pair = TuplesKt.to((Object)pattern, configuration2);
        boolean bl = false;
        collection.add(pair);
    }

    public final void globalDefaults(@NotNull Function1<? super DefaultsProviderBuilder, Unit> init2) {
        Intrinsics.checkNotNullParameter(init2, (String)"init");
        boolean $i$f$globalDefaults = false;
        DefaultsProviderBuilder defaultsProviderBuilder = this.getDefaultsProviderBuilder();
        boolean bl = false;
        boolean bl2 = false;
        init2.invoke((Object)defaultsProviderBuilder);
    }

    public final void unregisterAllFacades() {
        this.facades.clear();
    }

    public final void useFrontendFacades(Function1<? super TestServices, ? extends FrontendFacade<?>> ... constructor2) {
        Intrinsics.checkNotNullParameter(constructor2, (String)"constructor");
        TestConfigurationBuilder testConfigurationBuilder = this;
        Collection collection = testConfigurationBuilder.facades;
        boolean bl = false;
        CollectionsKt.addAll((Collection)collection, (Object[])constructor2);
    }

    public final void useBackendFacades(Function1<? super TestServices, ? extends BackendFacade<?, ?>> ... constructor2) {
        Intrinsics.checkNotNullParameter(constructor2, (String)"constructor");
        TestConfigurationBuilder testConfigurationBuilder = this;
        Collection collection = testConfigurationBuilder.facades;
        boolean bl = false;
        CollectionsKt.addAll((Collection)collection, (Object[])constructor2);
    }

    public final void useFrontend2BackendConverters(Function1<? super TestServices, ? extends Frontend2BackendConverter<?, ?>> ... constructor2) {
        Intrinsics.checkNotNullParameter(constructor2, (String)"constructor");
        TestConfigurationBuilder testConfigurationBuilder = this;
        Collection collection = testConfigurationBuilder.facades;
        boolean bl = false;
        CollectionsKt.addAll((Collection)collection, (Object[])constructor2);
    }

    public final void useFrontendHandlers(Function1<? super TestServices, ? extends FrontendOutputHandler<?>> ... constructor2) {
        Intrinsics.checkNotNullParameter(constructor2, (String)"constructor");
        TestConfigurationBuilder testConfigurationBuilder = this;
        Collection collection = testConfigurationBuilder.handlers;
        boolean bl = false;
        CollectionsKt.addAll((Collection)collection, (Object[])constructor2);
    }

    public final void useBackendHandlers(Function1<? super TestServices, ? extends BackendInputHandler<?>> ... constructor2) {
        Intrinsics.checkNotNullParameter(constructor2, (String)"constructor");
        TestConfigurationBuilder testConfigurationBuilder = this;
        Collection collection = testConfigurationBuilder.handlers;
        boolean bl = false;
        CollectionsKt.addAll((Collection)collection, (Object[])constructor2);
    }

    public final void useArtifactsHandlers(Function1<? super TestServices, ? extends BinaryArtifactHandler<?>> ... constructor2) {
        Intrinsics.checkNotNullParameter(constructor2, (String)"constructor");
        TestConfigurationBuilder testConfigurationBuilder = this;
        Collection collection = testConfigurationBuilder.handlers;
        boolean bl = false;
        CollectionsKt.addAll((Collection)collection, (Object[])constructor2);
    }

    public final void useSourcePreprocessor(@NotNull Function1<? super TestServices, ? extends SourceFilePreprocessor>[] preprocessors, boolean needToPrepend) {
        Intrinsics.checkNotNullParameter(preprocessors, (String)"preprocessors");
        if (needToPrepend) {
            this.sourcePreprocessors.addAll(0, ArraysKt.toList((Object[])preprocessors));
        } else {
            CollectionsKt.addAll((Collection)this.sourcePreprocessors, (Object[])preprocessors);
        }
    }

    public static /* synthetic */ void useSourcePreprocessor$default(TestConfigurationBuilder testConfigurationBuilder, Function1[] function1Array, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        testConfigurationBuilder.useSourcePreprocessor(function1Array, bl);
    }

    public final void useDirectives(DirectivesContainer ... directives2) {
        Intrinsics.checkNotNullParameter((Object)directives2, (String)"directives");
        TestConfigurationBuilder testConfigurationBuilder = this;
        Collection collection = testConfigurationBuilder.directives;
        boolean bl = false;
        CollectionsKt.addAll((Collection)collection, (Object[])directives2);
    }

    public final void useConfigurators(Function1<? super TestServices, ? extends EnvironmentConfigurator> ... environmentConfigurators) {
        Intrinsics.checkNotNullParameter(environmentConfigurators, (String)"environmentConfigurators");
        TestConfigurationBuilder testConfigurationBuilder = this;
        Collection collection = testConfigurationBuilder.environmentConfigurators;
        boolean bl = false;
        CollectionsKt.addAll((Collection)collection, (Object[])environmentConfigurators);
    }

    public final void useMetaInfoProcessors(Function1<? super TestServices, ? extends AdditionalMetaInfoProcessor> ... updaters) {
        Intrinsics.checkNotNullParameter(updaters, (String)"updaters");
        TestConfigurationBuilder testConfigurationBuilder = this;
        Collection collection = testConfigurationBuilder.additionalMetaInfoProcessors;
        boolean bl = false;
        CollectionsKt.addAll((Collection)collection, (Object[])updaters);
    }

    public final void useAdditionalSourceProviders(Function1<? super TestServices, ? extends AdditionalSourceProvider> ... providers) {
        Intrinsics.checkNotNullParameter(providers, (String)"providers");
        TestConfigurationBuilder testConfigurationBuilder = this;
        Collection collection = testConfigurationBuilder.additionalSourceProviders;
        boolean bl = false;
        CollectionsKt.addAll((Collection)collection, (Object[])providers);
    }

    @TestInfrastructureInternals
    public final void useModuleStructureTransformers(ModuleStructureTransformer ... transformers) {
        Intrinsics.checkNotNullParameter((Object)transformers, (String)"transformers");
        TestConfigurationBuilder testConfigurationBuilder = this;
        Collection collection = testConfigurationBuilder.moduleStructureTransformers;
        boolean bl = false;
        CollectionsKt.addAll((Collection)collection, (Object[])transformers);
    }

    @TestInfrastructureInternals
    public final void useCustomCompilerConfigurationProvider(@NotNull Function2<? super Disposable, ? super List<? extends EnvironmentConfigurator>, ? extends CompilerConfigurationProvider> provider2) {
        Intrinsics.checkNotNullParameter(provider2, (String)"provider");
        this.compilerConfigurationProvider = provider2;
    }

    public final void useMetaTestConfigurators(Function1<? super TestServices, ? extends MetaTestConfigurator> ... configurators) {
        Intrinsics.checkNotNullParameter(configurators, (String)"configurators");
        TestConfigurationBuilder testConfigurationBuilder = this;
        Collection collection = testConfigurationBuilder.metaTestConfigurators;
        boolean bl = false;
        CollectionsKt.addAll((Collection)collection, (Object[])configurators);
    }

    public final void useAfterAnalysisCheckers(Function1<? super TestServices, ? extends AfterAnalysisChecker> ... checkers) {
        Intrinsics.checkNotNullParameter(checkers, (String)"checkers");
        TestConfigurationBuilder testConfigurationBuilder = this;
        Collection collection = testConfigurationBuilder.afterAnalysisCheckers;
        boolean bl = false;
        CollectionsKt.addAll((Collection)collection, (Object[])checkers);
    }

    public final void defaultDirectives(@NotNull Function1<? super RegisteredDirectivesBuilder, Unit> init2) {
        Intrinsics.checkNotNullParameter(init2, (String)"init");
        boolean $i$f$defaultDirectives = false;
        RegisteredDirectivesBuilder registeredDirectivesBuilder = this.getDefaultRegisteredDirectivesBuilder();
        boolean bl = false;
        boolean bl2 = false;
        init2.invoke((Object)registeredDirectivesBuilder);
    }

    public final void enableMetaInfoHandler() {
        this.metaInfoHandlerEnabled = true;
    }

    @NotNull
    public final TestConfiguration build(@NotNull String testDataPath) {
        Regex regex;
        Intrinsics.checkNotNullParameter((Object)testDataPath, (String)"testDataPath");
        boolean bl = false;
        Path path2 = Paths.get(testDataPath, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"Paths.get(path)");
        Iterator<Pair<Regex, Function1<TestConfigurationBuilder, Unit>>> iterator2 = path2.normalize().toUri().toString();
        Intrinsics.checkNotNullExpressionValue((Object)iterator2, (String)"Path(testDataPath).normalize().toUri().toString()");
        String absoluteTestDataPath = iterator2;
        for (Pair pair : this.configurationsByPositiveTestDataCondition) {
            regex = (Regex)pair.component1();
            Function1 configuration2 = (Function1)pair.component2();
            if (!regex.matches((CharSequence)absoluteTestDataPath)) continue;
            configuration2.invoke((Object)this);
        }
        for (Pair<Regex, Function1<TestConfigurationBuilder, Unit>> pair : this.configurationsByNegativeTestDataCondition) {
            regex = (Regex)pair.component1();
            Function1 configuration2 = (Function1)pair.component2();
            if (regex.matches((CharSequence)absoluteTestDataPath)) continue;
            configuration2.invoke((Object)this);
        }
        return new TestConfigurationImpl(this.getTestInfo(), this.defaultsProviderBuilder.build(), this.getAssertions(), this.facades, this.handlers, this.sourcePreprocessors, this.additionalMetaInfoProcessors, this.environmentConfigurators, this.additionalSourceProviders, this.moduleStructureTransformers, this.metaTestConfigurators, this.afterAnalysisCheckers, this.compilerConfigurationProvider, this.metaInfoHandlerEnabled, this.directives, this.defaultRegisteredDirectivesBuilder.build(), this.additionalServices);
    }
}

