/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.builders;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.AnalysisFlag;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.JvmAnalysisFlags;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.config.LanguageVersionSettingsImpl;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.directives.LanguageSettingsDirectives;
import org.jetbrains.kotlin.test.directives.model.DirectiveKt;
import org.jetbrains.kotlin.test.directives.model.RegisteredDirectives;
import org.jetbrains.kotlin.test.services.DefaultsDsl;
import org.jetbrains.kotlin.test.services.EnvironmentConfigurator;
import org.jetbrains.kotlin.test.util.PatternsKt;

@DefaultsDsl
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0007\u0018\u0000 42\u00020\u0001:\u00014B\u0005\u00a2\u0006\u0002\u0010\u0002JH\u0010\u0015\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00170\u0005\u0012\u0004\u0012\u0002H\u0017\u0018\u00010\u0016\"\b\b\u0000\u0010\u0017*\u00020\u00012\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00170\u00052\r\u0010\u0019\u001a\t\u0018\u0001H\u0017\u00a2\u0006\u0002\b\u001aH\u0002\u00a2\u0006\u0002\u0010\u001bJ\u0006\u0010\u001c\u001a\u00020\u001dJ&\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\b\u0010%\u001a\u0004\u0018\u00010&J\u000e\u0010'\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020\u0013J\u000e\u0010)\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020\u0013J\u000e\u0010*\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020\u0013J\u0010\u0010+\u001a\u00020\u001f2\u0006\u0010,\u001a\u00020-H\u0002J\u0017\u0010.\u001a\u0004\u0018\u00010/2\u0006\u00100\u001a\u00020/H\u0002\u00a2\u0006\u0002\u00101J'\u00102\u001a\u00020\u001f\"\u0004\b\u0000\u0010\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u00170\u00052\u0006\u0010\u0019\u001a\u0002H\u0017\u00a2\u0006\u0002\u00103R \u0010\u0003\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lorg/jetbrains/kotlin/test/builders/LanguageVersionSettingsBuilder;", "", "()V", "analysisFlags", "", "Lorg/jetbrains/kotlin/config/AnalysisFlag;", "apiVersion", "Lorg/jetbrains/kotlin/config/ApiVersion;", "getApiVersion", "()Lorg/jetbrains/kotlin/config/ApiVersion;", "setApiVersion", "(Lorg/jetbrains/kotlin/config/ApiVersion;)V", "languageVersion", "Lorg/jetbrains/kotlin/config/LanguageVersion;", "getLanguageVersion", "()Lorg/jetbrains/kotlin/config/LanguageVersion;", "setLanguageVersion", "(Lorg/jetbrains/kotlin/config/LanguageVersion;)V", "specificFeatures", "Lorg/jetbrains/kotlin/config/LanguageFeature;", "Lorg/jetbrains/kotlin/config/LanguageFeature$State;", "analysisFlag", "Lkotlin/Pair;", "T", "flag", "value", "Lkotlin/internal/NoInfer;", "(Lorg/jetbrains/kotlin/config/AnalysisFlag;Ljava/lang/Object;)Lkotlin/Pair;", "build", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "configureUsingDirectives", "", "directives", "Lorg/jetbrains/kotlin/test/directives/model/RegisteredDirectives;", "environmentConfigurators", "", "Lorg/jetbrains/kotlin/test/services/EnvironmentConfigurator;", "targetBackend", "Lorg/jetbrains/kotlin/test/TargetBackend;", "disable", "feature", "enable", "enableWithWarning", "parseLanguageFeature", "featureString", "", "trueOrNull", "", "condition", "(Z)Ljava/lang/Boolean;", "withFlag", "(Lorg/jetbrains/kotlin/config/AnalysisFlag;Ljava/lang/Object;)V", "Companion", "test-infrastructure"})
public final class LanguageVersionSettingsBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private LanguageVersion languageVersion = LanguageVersion.LATEST_STABLE;
    @NotNull
    private ApiVersion apiVersion = ApiVersion.LATEST_STABLE;
    @NotNull
    private final Map<LanguageFeature, LanguageFeature.State> specificFeatures;
    @NotNull
    private final Map<AnalysisFlag<?>, Object> analysisFlags;

    public LanguageVersionSettingsBuilder() {
        boolean bl = false;
        this.specificFeatures = new LinkedHashMap();
        bl = false;
        this.analysisFlags = new LinkedHashMap();
    }

    @NotNull
    public final LanguageVersion getLanguageVersion() {
        return this.languageVersion;
    }

    public final void setLanguageVersion(@NotNull LanguageVersion languageVersion) {
        Intrinsics.checkNotNullParameter((Object)languageVersion, (String)"<set-?>");
        this.languageVersion = languageVersion;
    }

    @NotNull
    public final ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    public final void setApiVersion(@NotNull ApiVersion apiVersion) {
        Intrinsics.checkNotNullParameter((Object)apiVersion, (String)"<set-?>");
        this.apiVersion = apiVersion;
    }

    public final void enable(@NotNull LanguageFeature feature) {
        Intrinsics.checkNotNullParameter((Object)((Object)feature), (String)"feature");
        Map<LanguageFeature, LanguageFeature.State> map = this.specificFeatures;
        LanguageFeature.State state = LanguageFeature.State.ENABLED;
        boolean bl = false;
        map.put(feature, state);
    }

    public final void enableWithWarning(@NotNull LanguageFeature feature) {
        Intrinsics.checkNotNullParameter((Object)((Object)feature), (String)"feature");
        Map<LanguageFeature, LanguageFeature.State> map = this.specificFeatures;
        LanguageFeature.State state = LanguageFeature.State.ENABLED_WITH_WARNING;
        boolean bl = false;
        map.put(feature, state);
    }

    public final void disable(@NotNull LanguageFeature feature) {
        Intrinsics.checkNotNullParameter((Object)((Object)feature), (String)"feature");
        Map<LanguageFeature, LanguageFeature.State> map = this.specificFeatures;
        LanguageFeature.State state = LanguageFeature.State.DISABLED;
        boolean bl = false;
        map.put(feature, state);
    }

    public final <T> void withFlag(@NotNull AnalysisFlag<? extends T> flag, T value2) {
        Intrinsics.checkNotNullParameter(flag, (String)"flag");
        Map<AnalysisFlag<?>, Object> map = this.analysisFlags;
        boolean bl = false;
        map.put(flag, value2);
    }

    public final void configureUsingDirectives(@NotNull RegisteredDirectives directives2, @NotNull List<? extends EnvironmentConfigurator> environmentConfigurators, @Nullable TargetBackend targetBackend) {
        Object it;
        Intrinsics.checkNotNullParameter((Object)directives2, (String)"directives");
        Intrinsics.checkNotNullParameter(environmentConfigurators, (String)"environmentConfigurators");
        ApiVersion apiVersion = DirectiveKt.singleOrZeroValue(directives2, LanguageSettingsDirectives.INSTANCE.getAPI_VERSION());
        if (apiVersion != null) {
            LanguageVersion languageVersion;
            this.apiVersion = apiVersion;
            Comparable comparable = (Comparable)((Object)LanguageVersion.LATEST_STABLE);
            LanguageVersion languageVersion2 = LanguageVersion.Companion.fromVersionString(apiVersion.getVersionString());
            Intrinsics.checkNotNull((Object)languageVersion2);
            this.languageVersion = languageVersion = (LanguageVersion)((Object)ComparisonsKt.maxOf((Comparable)comparable, (Comparable)((Comparable)((Object)languageVersion2))));
        }
        Object[] objectArray = new Pair[13];
        Object object = directives2.get(LanguageSettingsDirectives.INSTANCE.getEXPERIMENTAL());
        boolean bl = false;
        boolean bl2 = false;
        Pair pair = object;
        AnalysisFlag<List<String>> analysisFlag = AnalysisFlags.getExperimental();
        LanguageVersionSettingsBuilder languageVersionSettingsBuilder = this;
        int n = 0;
        Object[] objectArray2 = objectArray;
        boolean bl3 = false;
        Collection collection = (Collection)it;
        boolean bl4 = false;
        boolean bl5 = !collection.isEmpty();
        objectArray2[n] = languageVersionSettingsBuilder.analysisFlag(analysisFlag, bl5 ? object : null);
        object = directives2.get(LanguageSettingsDirectives.INSTANCE.getUSE_EXPERIMENTAL());
        bl = false;
        bl2 = false;
        it = object;
        analysisFlag = AnalysisFlags.getUseExperimental();
        languageVersionSettingsBuilder = this;
        n = 1;
        objectArray2 = objectArray;
        boolean bl6 = false;
        collection = (Collection)it;
        bl4 = false;
        bl5 = !collection.isEmpty();
        objectArray2[n] = languageVersionSettingsBuilder.analysisFlag(analysisFlag, bl5 ? object : null);
        objectArray[2] = this.analysisFlag(AnalysisFlags.getIgnoreDataFlowInAssert(), this.trueOrNull(directives2.contains(LanguageSettingsDirectives.INSTANCE.getIGNORE_DATA_FLOW_IN_ASSERT())));
        objectArray[3] = this.analysisFlag(AnalysisFlags.getConstraintSystemForOverloadResolution(), DirectiveKt.singleOrZeroValue(directives2, LanguageSettingsDirectives.INSTANCE.getCONSTRAINT_SYSTEM_FOR_OVERLOAD_RESOLUTION()));
        objectArray[4] = this.analysisFlag(AnalysisFlags.getAllowResultReturnType(), this.trueOrNull(directives2.contains(LanguageSettingsDirectives.INSTANCE.getALLOW_RESULT_RETURN_TYPE())));
        objectArray[5] = this.analysisFlag(AnalysisFlags.getExplicitApiMode(), DirectiveKt.singleOrZeroValue(directives2, LanguageSettingsDirectives.INSTANCE.getEXPLICIT_API_MODE()));
        objectArray[6] = this.analysisFlag(AnalysisFlags.getAllowKotlinPackage(), this.trueOrNull(directives2.contains(LanguageSettingsDirectives.INSTANCE.getALLOW_KOTLIN_PACKAGE())));
        objectArray[7] = this.analysisFlag(JvmAnalysisFlags.getJvmDefaultMode(), DirectiveKt.singleOrZeroValue(directives2, LanguageSettingsDirectives.INSTANCE.getJVM_DEFAULT_MODE()));
        objectArray[8] = this.analysisFlag(JvmAnalysisFlags.getInheritMultifileParts(), this.trueOrNull(directives2.contains(LanguageSettingsDirectives.INSTANCE.getINHERIT_MULTIFILE_PARTS())));
        objectArray[9] = this.analysisFlag(JvmAnalysisFlags.getSanitizeParentheses(), this.trueOrNull(directives2.contains(LanguageSettingsDirectives.INSTANCE.getSANITIZE_PARENTHESES())));
        objectArray[10] = this.analysisFlag(JvmAnalysisFlags.getEnableJvmPreview(), this.trueOrNull(directives2.contains(LanguageSettingsDirectives.INSTANCE.getENABLE_JVM_PREVIEW())));
        objectArray[11] = this.analysisFlag(JvmAnalysisFlags.getUseIR(), !((object = targetBackend) == null ? false : !((TargetBackend)((Object)object)).isIR()));
        objectArray[12] = this.analysisFlag(AnalysisFlags.getExplicitApiVersion(), this.trueOrNull(apiVersion != null));
        List analysisFlags = CollectionsKt.listOfNotNull((Object[])objectArray);
        Iterable $this$forEach$iv = analysisFlags;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Pair)element$iv;
            boolean bl7 = false;
            this.withFlag((AnalysisFlag)it.getFirst(), it.getSecond());
        }
        $this$forEach$iv = environmentConfigurators;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (EnvironmentConfigurator)element$iv;
            boolean bl8 = false;
            Iterable $this$forEach$iv2 = ((EnvironmentConfigurator)it).provideAdditionalAnalysisFlags(directives2, this.getLanguageVersion()).entrySet();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Map.Entry $dstr$flag$value = (Map.Entry)element$iv2;
                boolean bl9 = false;
                Map.Entry entry = $dstr$flag$value;
                boolean bl10 = false;
                AnalysisFlag flag = (AnalysisFlag)entry.getKey();
                Map.Entry entry2 = $dstr$flag$value;
                boolean bl11 = false;
                Object value2 = entry2.getValue();
                this.withFlag(flag, value2);
            }
        }
        $this$forEach$iv = directives2.get(LanguageSettingsDirectives.INSTANCE.getLANGUAGE());
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl12 = false;
            this.parseLanguageFeature((String)it);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void parseLanguageFeature(String featureString) {
        matcher = PatternsKt.getLANGUAGE_FEATURE_PATTERN().matcher(featureString);
        if (!matcher.find()) {
            var3_3 = "Wrong syntax in the '// !" + LanguageSettingsDirectives.INSTANCE.getLANGUAGE().getName() + ": ...' directive:\n                   found: '" + featureString + "'\n                   Must be '((+|-|warn:)LanguageFeatureName)+'\n                   where '+' means 'enable', '-' means 'disable', 'warn:' means 'enable with warning'\n                   and language feature names are names of enum entries in LanguageFeature enum class";
            var4_5 = false;
            throw (Throwable)new IllegalStateException(var3_3.toString());
        }
        mode = matcher.group(1);
        if (mode == null) ** GOTO lbl-1000
        tmp = -1;
        switch (mode.hashCode()) {
            case 43: {
                if (mode.equals("+")) {
                    tmp = 1;
                }
                break;
            }
            case 45: {
                if (mode.equals("-")) {
                    tmp = 2;
                }
                break;
            }
            case 112901748: {
                if (mode.equals("warn:")) {
                    tmp = 3;
                }
                break;
            }
        }
        switch (tmp) {
            case 1: {
                v0 = LanguageFeature.State.ENABLED;
                break;
            }
            case 2: {
                v0 = LanguageFeature.State.DISABLED;
                break;
            }
            case 3: {
                v0 = LanguageFeature.State.ENABLED_WITH_WARNING;
                break;
            }
            default: lbl-1000:
            // 2 sources

            {
                var5_7 = Intrinsics.stringPlus((String)"Unknown mode for language feature: ", (Object)mode);
                var6_9 = false;
                throw (Throwable)new IllegalStateException(var5_7.toString());
            }
        }
        mode = v0;
        name = matcher.group(2);
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
        var6_10 = LanguageFeature.Companion.fromString(name);
        if (var6_10 == null) {
            var7_11 = "Language feature with name \"" + name + "\" not found";
            var8_13 = false;
            throw (Throwable)new IllegalStateException(var7_11.toString());
        }
        feature = var6_10;
        var6_10 = this.specificFeatures;
        var7_12 = false;
        var6_10.put(feature, mode);
    }

    private final <T> Pair<AnalysisFlag<T>, T> analysisFlag(AnalysisFlag<? extends T> flag, T value2) {
        Pair pair;
        T t = value2;
        if (t == null) {
            pair = null;
        } else {
            T t2 = t;
            boolean bl = false;
            boolean bl2 = false;
            T p0 = t2;
            boolean bl3 = false;
            pair = TuplesKt.to(flag, p0);
        }
        return pair;
    }

    private final Boolean trueOrNull(boolean condition) {
        Boolean bl;
        boolean $i$f$runIf = false;
        if (condition) {
            boolean bl2 = false;
            bl = true;
        } else {
            bl = null;
        }
        return bl;
    }

    @NotNull
    public final LanguageVersionSettings build() {
        return new LanguageVersionSettingsImpl(this.languageVersion, this.apiVersion, this.analysisFlags, this.specificFeatures);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/test/builders/LanguageVersionSettingsBuilder$Companion;", "", "()V", "fromExistingSettings", "Lorg/jetbrains/kotlin/test/builders/LanguageVersionSettingsBuilder;", "builder", "test-infrastructure"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LanguageVersionSettingsBuilder fromExistingSettings(@NotNull LanguageVersionSettingsBuilder builder2) {
            Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
            LanguageVersionSettingsBuilder languageVersionSettingsBuilder = new LanguageVersionSettingsBuilder();
            boolean bl = false;
            boolean bl2 = false;
            LanguageVersionSettingsBuilder $this$fromExistingSettings_u24lambda_u2d0 = languageVersionSettingsBuilder;
            boolean bl3 = false;
            $this$fromExistingSettings_u24lambda_u2d0.setLanguageVersion(builder2.getLanguageVersion());
            $this$fromExistingSettings_u24lambda_u2d0.setApiVersion(builder2.getApiVersion());
            LanguageVersionSettingsBuilder languageVersionSettingsBuilder2 = $this$fromExistingSettings_u24lambda_u2d0;
            Map map = languageVersionSettingsBuilder2.specificFeatures;
            Map map2 = builder2.specificFeatures;
            boolean bl4 = false;
            map.putAll(map2);
            languageVersionSettingsBuilder2 = $this$fromExistingSettings_u24lambda_u2d0;
            map = languageVersionSettingsBuilder2.analysisFlags;
            map2 = builder2.analysisFlags;
            bl4 = false;
            map.putAll(map2);
            return languageVersionSettingsBuilder;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

