/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.backend.handlers;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import junit.framework.TestCase;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.codegen.ClassFileFactory;
import org.jetbrains.kotlin.codegen.CodegenTestUtil;
import org.jetbrains.kotlin.codegen.GeneratedClassLoader;
import org.jetbrains.kotlin.codegen.TestUtilsKt;
import org.jetbrains.kotlin.codegen.forTestCompile.ForTestCompileRuntime;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.backend.handlers.JvmBinaryArtifactHandler;
import org.jetbrains.kotlin.test.backend.handlers.JvmBoxRunner;
import org.jetbrains.kotlin.test.clientserver.TestProxy;
import org.jetbrains.kotlin.test.directives.CodegenTestDirectives;
import org.jetbrains.kotlin.test.model.BinaryArtifacts;
import org.jetbrains.kotlin.test.model.DependencyDescription;
import org.jetbrains.kotlin.test.model.DependencyKind;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.CompilerConfigurationProviderKt;
import org.jetbrains.kotlin.test.services.DependencyProviderKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.services.configuration.JvmEnvironmentConfigurator;
import org.jetbrains.kotlin.test.services.jvm.CompiledClassesManager;
import org.jetbrains.kotlin.test.services.jvm.CompiledClassesManagerKt;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 .2\u00020\u0001:\u0001.B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J<\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0006H\u0002JD\u0010\u0019\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0006H\u0002J\u0016\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\t0\u001c2\u0006\u0010\u001d\u001a\u00020\u000fH\u0002J \u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u0006H\u0002J\u0018\u0010 \u001a\u00020\u001f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J,\u0010!\u001a\u00020\"2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0002J\u0010\u0010#\u001a\u00020\r2\u0006\u0010$\u001a\u00020\u0006H\u0016J\u0018\u0010%\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020'H\u0016J\u0012\u0010(\u001a\u0004\u0018\u00010\u0017*\u0006\u0012\u0002\b\u00030\u0015H\u0002J\u000e\u0010)\u001a\u0004\u0018\u00010\"*\u00020*H\u0002J\u0018\u0010+\u001a\u0006\u0012\u0002\b\u00030\u0015*\u00020,2\u0006\u0010-\u001a\u00020\"H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\u00020\b*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/JvmBoxRunner;", "Lorg/jetbrains/kotlin/test/backend/handlers/JvmBinaryArtifactHandler;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "boxMethodFound", "", "url", "Ljava/net/URL;", "Ljava/io/File;", "getUrl", "(Ljava/io/File;)Ljava/net/URL;", "callBoxMethodAndCheckResult", "", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "classFileFactory", "Lorg/jetbrains/kotlin/codegen/ClassFileFactory;", "classLoader", "Ljava/net/URLClassLoader;", "clazz", "Ljava/lang/Class;", "method", "Ljava/lang/reflect/Method;", "unexpectedBehaviour", "callBoxMethodAndCheckResultWithCleanup", "reportProblems", "computeRuntimeClasspath", "", "rootModule", "createAndVerifyClassLoader", "Lorg/jetbrains/kotlin/codegen/GeneratedClassLoader;", "createClassLoader", "invokeBoxInSeparateProcess", "", "processAfterAllModules", "someAssertionWasFailed", "processModule", "info", "Lorg/jetbrains/kotlin/test/model/BinaryArtifacts$Jvm;", "getBoxMethodOrNull", "getFacadeFqName", "Lorg/jetbrains/kotlin/psi/KtFile;", "getGeneratedClass", "Ljava/lang/ClassLoader;", "className", "Companion", "tests-common-new"})
public final class JvmBoxRunner
extends JvmBinaryArtifactHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean boxMethodFound;
    private static final String BOX_IN_SEPARATE_PROCESS_PORT = System.getProperty("kotlin.test.box.in.separate.process.port");

    public JvmBoxRunner(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        super(testServices, false, 2, null);
    }

    @Override
    public void processAfterAllModules(boolean someAssertionWasFailed) {
        if (!this.boxMethodFound) {
            this.getAssertions().fail((Function0<String>)((Function0)processAfterAllModules.1.INSTANCE));
            throw null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processModule(@NotNull TestModule module2, @NotNull BinaryArtifacts.Jvm info) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Collection collection = info.getClassFileFactory().getInputFiles();
        boolean bl = false;
        if (collection.isEmpty()) {
            boolean bl2 = false;
            return;
        }
        List ktFiles = (List)collection;
        boolean reportProblems = !kotlin.collections.CollectionsKt.contains((Iterable)module2.getDirectives().get(CodegenTestDirectives.INSTANCE.getIGNORE_BACKEND()), (Object)((Object)module2.getTargetBackend()));
        GeneratedClassLoader classLoader = this.createAndVerifyClassLoader(module2, info.getClassFileFactory(), reportProblems);
        try {
            for (KtFile ktFile : ktFiles) {
                Class<?> clazz;
                Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"ktFile");
                String string2 = this.getFacadeFqName(ktFile);
                if (string2 == null) continue;
                String className2 = string2;
                try {
                    clazz = this.getGeneratedClass(classLoader, className2);
                }
                catch (LinkageError e) {
                    throw new AssertionError("Failed to load class '" + className2 + "':\n" + info.getClassFileFactory().createText(), e);
                }
                Class<?> clazz2 = clazz;
                Method method = this.getBoxMethodOrNull(clazz2);
                if (method == null) continue;
                Method method2 = method;
                this.boxMethodFound = true;
                this.callBoxMethodAndCheckResultWithCleanup(module2, info.getClassFileFactory(), classLoader, clazz2, method2, false, reportProblems);
                return;
            }
        }
        finally {
            classLoader.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void callBoxMethodAndCheckResultWithCleanup(TestModule module2, ClassFileFactory classFileFactory, URLClassLoader classLoader, Class<?> clazz, Method method, boolean unexpectedBehaviour, boolean reportProblems) {
        try {
            this.callBoxMethodAndCheckResult(module2, classFileFactory, classLoader, clazz, method, unexpectedBehaviour);
        }
        catch (Throwable e) {
            if (reportProblems) {
                try {
                    String string2 = classFileFactory.createText();
                    boolean bl = false;
                    System.out.println((Object)string2);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            throw e;
        }
        finally {
            TestUtilsKt.clearReflectionCache(classLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void callBoxMethodAndCheckResult(TestModule module2, ClassFileFactory classFileFactory, URLClassLoader classLoader, Class<?> clazz, Method method, boolean unexpectedBehaviour) {
        String result2;
        Object object;
        if (BOX_IN_SEPARATE_PROCESS_PORT != null) {
            object = this.invokeBoxInSeparateProcess(module2, classFileFactory, classLoader, clazz);
        } else {
            Object object2;
            ClassLoader savedClassLoader = Thread.currentThread().getContextClassLoader();
            if (savedClassLoader != classLoader) {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
            try {
                object2 = method.invoke(null, new Object[0]);
                if (object2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                }
                object2 = (String)object2;
            }
            finally {
                if (savedClassLoader != classLoader) {
                    Thread.currentThread().setContextClassLoader(savedClassLoader);
                }
            }
            object = result2 = object2;
        }
        if (unexpectedBehaviour) {
            TestCase.assertNotSame((Object)"OK", (Object)result2);
        } else {
            Assertions.assertEquals$default(this.getAssertions(), "OK", result2, null, 4, null);
        }
    }

    private final String invokeBoxInSeparateProcess(TestModule module2, ClassFileFactory classFileFactory, URLClassLoader classLoader, Class<?> clazz) {
        Object object;
        List classPath2 = kotlin.collections.CollectionsKt.toMutableList((Collection)TestUtilsKt.extractUrls(classLoader));
        if (classLoader instanceof GeneratedClassLoader) {
            URL javaPath;
            object = CompiledClassesManagerKt.getCompiledClassesManager(this.getTestServices()).getCompiledJavaDirForModule(module2);
            URL uRL = javaPath = object == null ? null : this.getUrl((File)object);
            if (javaPath != null) {
                classPath2.add(0, javaPath);
            }
            classPath2.add(0, this.getUrl(CompiledClassesManagerKt.getCompiledClassesManager(this.getTestServices()).getCompiledKotlinDirForModule(module2, classFileFactory)));
        }
        object = Integer.valueOf(BOX_IN_SEPARATE_PROCESS_PORT);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"valueOf(BOX_IN_SEPARATE_PROCESS_PORT)");
        int n = ((Number)object).intValue();
        object = clazz.getCanonicalName();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"clazz.canonicalName");
        TestProxy proxy = new TestProxy(n, (String)object, classPath2);
        return proxy.runTest();
    }

    private final URL getUrl(File $this$url) {
        URL uRL = $this$url.toURI().toURL();
        Intrinsics.checkNotNullExpressionValue((Object)uRL, (String)"toURI().toURL()");
        return uRL;
    }

    private final GeneratedClassLoader createAndVerifyClassLoader(TestModule module2, ClassFileFactory classFileFactory, boolean reportProblems) {
        GeneratedClassLoader classLoader = this.createClassLoader(module2, classFileFactory);
        boolean verificationSucceeded = CodegenTestUtil.verifyAllFilesWithAsm(classFileFactory, classLoader, reportProblems);
        if (!verificationSucceeded) {
            this.getAssertions().fail((Function0<String>)((Function0)createAndVerifyClassLoader.1.INSTANCE));
            throw null;
        }
        return classLoader;
    }

    /*
     * WARNING - void declaration
     */
    private final GeneratedClassLoader createClassLoader(TestModule module2, ClassFileFactory classFileFactory) {
        void $this$toTypedArray$iv;
        Collection<URL> collection;
        void $this$mapTo$iv$iv;
        Collection $this$map$iv;
        CompilerConfiguration configuration2 = CompilerConfigurationProviderKt.getCompilerConfigurationProvider(this.getTestServices()).getCompilerConfiguration(module2);
        URL[] uRLArray = configuration2.get(JvmEnvironmentConfigurator.Companion.getTEST_CONFIGURATION_KIND_KEY());
        ClassLoader classLoader = (uRLArray == null ? false : uRLArray.getWithReflection()) ? ForTestCompileRuntime.runtimeAndReflectJarClassLoader() : ForTestCompileRuntime.runtimeJarClassLoader();
        Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"if (configuration[TEST_C\u2026arClassLoader()\n        }");
        ClassLoader parentClassLoader = classLoader;
        List<File> classpath = this.computeRuntimeClasspath(module2);
        Iterable iterable = classpath;
        ClassLoader classLoader2 = parentClassLoader;
        ClassFileFactory classFileFactory2 = classFileFactory;
        boolean $i$f$map = false;
        void var9_11 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            File file2 = (File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            URL uRL = it.toURI().toURL();
            collection.add(uRL);
        }
        collection = (List)destination$iv$iv;
        $this$map$iv = collection;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        URL[] uRLArray2 = thisCollection$iv.toArray(new URL[0]);
        if (uRLArray2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        uRLArray = uRLArray2;
        URL[] uRLArray3 = Arrays.copyOf(uRLArray, uRLArray.length);
        ClassLoader classLoader3 = classLoader2;
        ClassFileFactory classFileFactory3 = classFileFactory2;
        return new GeneratedClassLoader(classFileFactory3, classLoader3, uRLArray3);
    }

    private final List<File> computeRuntimeClasspath(TestModule rootModule) {
        boolean bl = false;
        Set visited2 = new LinkedHashSet();
        boolean bl2 = false;
        List result2 = new ArrayList();
        JvmBoxRunner.computeRuntimeClasspath$computeClasspath(visited2, result2, this, rootModule, true);
        return result2;
    }

    private final String getFacadeFqName(KtFile $this$getFacadeFqName) {
        String string2;
        Collection collection = CodegenUtil.getMemberDeclarationsToGenerate($this$getFacadeFqName);
        boolean bl = false;
        boolean condition$iv = !collection.isEmpty();
        boolean $i$f$runIf = false;
        if (condition$iv) {
            boolean bl2 = false;
            string2 = JvmFileClassUtil.getFileClassInfoNoResolve($this$getFacadeFqName).getFacadeClassFqName().asString();
        } else {
            string2 = null;
        }
        return string2;
    }

    private final Class<?> getGeneratedClass(ClassLoader $this$getGeneratedClass, String className2) {
        try {
            Class<?> clazz = $this$getGeneratedClass.loadClass(className2);
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"loadClass(className)");
            return clazz;
        }
        catch (ClassNotFoundException e) {
            this.getAssertions().fail((Function0<String>)((Function0)new Function0<String>(className2){
                final /* synthetic */ String $className;
                {
                    this.$className = $className;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return Intrinsics.stringPlus((String)"No class file was generated for: ", (Object)this.$className);
                }
            }));
            throw null;
        }
    }

    private final Method getBoxMethodOrNull(Class<?> $this$getBoxMethodOrNull) {
        Method method;
        try {
            method = $this$getBoxMethodOrNull.getMethod("box", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        return method;
    }

    private static final void computeRuntimeClasspath$computeClasspath(Set<TestModule> visited2, List<File> result2, JvmBoxRunner this$0, TestModule module2, boolean isRoot) {
        if (!visited2.add(module2)) {
            return;
        }
        if (!isRoot) {
            result2.add(CompiledClassesManager.getCompiledKotlinDirForModule$default(CompiledClassesManagerKt.getCompiledClassesManager(this$0.getTestServices()), module2, null, 2, null));
        }
        CollectionsKt.addIfNotNull((Collection)result2, CompiledClassesManagerKt.getCompiledClassesManager(this$0.getTestServices()).getCompiledJavaDirForModule(module2));
        for (DependencyDescription dependency : module2.getAllDependencies()) {
            if (dependency.getKind() != DependencyKind.Binary) continue;
            JvmBoxRunner.computeRuntimeClasspath$computeClasspath(visited2, result2, this$0, DependencyProviderKt.getDependencyProvider(this$0.getTestServices()).getTestModule(dependency.getModuleName()), false);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/test/backend/handlers/JvmBoxRunner$Companion;", "", "()V", "BOX_IN_SEPARATE_PROCESS_PORT", "", "kotlin.jvm.PlatformType", "tests-common-new"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

