/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirFakeSourceElementKind;
import org.jetbrains.kotlin.fir.FirSourceElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirConstChecksKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirModifier;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.fir.analysis.diagnostics.DiagnosticReporterKt;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirConstPropertyChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/diagnostics/DiagnosticReporter;", "checkers"})
public final class FirConstPropertyChecker
extends FirDeclarationChecker<FirProperty> {
    @NotNull
    public static final FirConstPropertyChecker INSTANCE = new FirConstPropertyChecker();

    private FirConstPropertyChecker() {
    }

    @Override
    public void check(@NotNull FirProperty declaration2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter) {
        FirSourceElement source;
        ClassKind classKind;
        Object object;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        FirMemberDeclaration $this$isConst$iv = declaration2;
        boolean $i$f$isConst2 = false;
        if (!$this$isConst$iv.getStatus().isConst()) {
            return;
        }
        if (declaration2.isVar()) {
            FirElement firElement = declaration2;
            Object $i$f$isConst2 = KtTokens.CONST_KEYWORD;
            Intrinsics.checkNotNullExpressionValue((Object)$i$f$isConst2, (String)"CONST_KEYWORD");
            FirModifier<?> constModifier = FirKeywordUtilsKt.getModifier(firElement, $i$f$isConst2);
            $i$f$isConst2 = constModifier;
            if ($i$f$isConst2 != null) {
                object = $i$f$isConst2;
                boolean bl = false;
                boolean bl2 = false;
                Object it = object;
                boolean bl3 = false;
                DiagnosticReporterKt.reportOn$default(reporter, ((FirModifier)it).getSource(), FirErrors.INSTANCE.getWRONG_MODIFIER_TARGET(), (Object)((FirModifier)it).getToken(), "vars", context2, null, 32, null);
            }
        }
        FirRegularClass $i$f$isConst2 = (object = CollectionsKt.lastOrNull(context2.getContainingDeclarations())) instanceof FirRegularClass ? (FirRegularClass)object : null;
        ClassKind classKind2 = classKind = $i$f$isConst2 == null ? null : $i$f$isConst2.getClassKind();
        if (classKind != ClassKind.OBJECT && context2.getContainingDeclarations().size() > 1) {
            DiagnosticReporterKt.reportOn$default(reporter, declaration2.getSource(), FirErrors.INSTANCE.getCONST_VAL_NOT_TOP_LEVEL_OR_OBJECT(), context2, null, 8, null);
            return;
        }
        object = declaration2.getGetter();
        FirSourceElement firSourceElement = source = object == null ? null : ((FirPropertyAccessor)object).getSource();
        if (source != null && !(source.getKind() instanceof FirFakeSourceElementKind)) {
            DiagnosticReporterKt.reportOn$default(reporter, source, FirErrors.INSTANCE.getCONST_VAL_WITH_GETTER(), context2, null, 8, null);
            return;
        }
        if (declaration2.getDelegate() != null) {
            object = declaration2.getDelegate();
            DiagnosticReporterKt.reportOn$default(reporter, object == null ? null : ((FirExpression)object).getSource(), FirErrors.INSTANCE.getCONST_VAL_WITH_DELEGATE(), context2, null, 8, null);
            return;
        }
        FirExpression initializer2 = declaration2.getInitializer();
        if (initializer2 == null) {
            DiagnosticReporterKt.reportOn$default(reporter, declaration2.getSource(), FirErrors.INSTANCE.getCONST_VAL_WITHOUT_INITIALIZER(), context2, null, 8, null);
            return;
        }
        ConeKotlinType type2 = TypeExpansionUtilsKt.fullyExpandedType(FirTypeUtilsKt.getConeType(declaration2.getReturnTypeRef()), context2.getSession());
        if (!(type2 instanceof ConeClassErrorType) && !FirConstChecksKt.canBeUsedForConstVal(type2)) {
            DiagnosticReporterKt.reportOn$default(reporter, declaration2.getSource(), FirErrors.INSTANCE.getTYPE_CANT_BE_USED_FOR_CONST_VAL(), FirTypeUtilsKt.getConeType(declaration2.getReturnTypeRef()), context2, null, 16, null);
            return;
        }
        if (FirConstChecksKt.checkConstantArguments(initializer2, context2.getSession()) != null) {
            DiagnosticReporterKt.reportOn$default(reporter, initializer2.getSource(), FirErrors.INSTANCE.getCONST_VAL_WITH_NON_CONST_INITIALIZER(), context2, null, 8, null);
        }
    }
}

