/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function6;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.overrides.FakeOverrideBuilder;
import org.jetbrains.kotlin.backend.common.overrides.FakeOverrideClassFilter;
import org.jetbrains.kotlin.backend.common.serialization.BasicIrModuleDeserializerKt;
import org.jetbrains.kotlin.backend.common.serialization.IrBodyDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.IrDeclarationDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.IrFileDeserializerKt;
import org.jetbrains.kotlin.backend.common.serialization.IrLibraryFile;
import org.jetbrains.kotlin.backend.common.serialization.IrSymbolDeserializer;
import org.jetbrains.kotlin.backend.common.serialization.encodings.BinaryCoordinates;
import org.jetbrains.kotlin.backend.common.serialization.encodings.BinaryNameAndType;
import org.jetbrains.kotlin.backend.common.serialization.encodings.BinarySymbolData;
import org.jetbrains.kotlin.backend.common.serialization.encodings.BinaryTypeProjection;
import org.jetbrains.kotlin.backend.common.serialization.encodings.ClassFlags;
import org.jetbrains.kotlin.backend.common.serialization.encodings.FieldFlags;
import org.jetbrains.kotlin.backend.common.serialization.encodings.FunctionFlags;
import org.jetbrains.kotlin.backend.common.serialization.encodings.LocalVariableFlags;
import org.jetbrains.kotlin.backend.common.serialization.encodings.PropertyFlags;
import org.jetbrains.kotlin.backend.common.serialization.encodings.TypeAliasFlags;
import org.jetbrains.kotlin.backend.common.serialization.encodings.TypeParameterFlags;
import org.jetbrains.kotlin.backend.common.serialization.encodings.ValueParameterFlags;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrAnonymousInit;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrClass;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrConstructor;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrConstructorCall;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrDeclaration;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrDeclarationBase;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrDynamicType;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrEnumEntry;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrErrorDeclaration;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrErrorType;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrExpression;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrField;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrFunction;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrFunctionBase;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrInlineClassRepresentation;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrProperty;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrSimpleType;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrStatement;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrType;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrTypeAbbreviation;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrTypeAlias;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrTypeParameter;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrValueParameter;
import org.jetbrains.kotlin.backend.common.serialization.proto.IrVariable;
import org.jetbrains.kotlin.descriptors.InlineClassRepresentation;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOriginImpl;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.impl.IrVariableImpl;
import org.jetbrains.kotlin.ir.descriptors.IrBuiltIns;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrStatementOriginImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrErrorExpressionImpl;
import org.jetbrains.kotlin.ir.symbols.IrAnonymousInitializerSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrDelegatingSymbol;
import org.jetbrains.kotlin.ir.symbols.IrEnumEntrySymbol;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrLocalDelegatedPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbolKt;
import org.jetbrains.kotlin.ir.symbols.IrTypeAliasSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrVariableSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrPublicSymbolBase;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.types.impl.IrDynamicTypeImpl;
import org.jetbrains.kotlin.ir.types.impl.IrErrorTypeImpl;
import org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeImpl;
import org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeImplKt;
import org.jetbrains.kotlin.ir.types.impl.IrStarProjectionImpl;
import org.jetbrains.kotlin.ir.types.impl.IrTypeAbbreviationImpl;
import org.jetbrains.kotlin.ir.types.impl.IrUninitializedType;
import org.jetbrains.kotlin.ir.util.IdSignature;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.protobuf.CodedInputStream;
import org.jetbrains.kotlin.protobuf.ExtensionRegistryLite;
import org.jetbrains.kotlin.protobuf.GeneratedMessageLite;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.model.SimpleTypeMarker;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00e6\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u00b5\u00012\u00020\u0001:\u0002\u00b5\u0001B\u0091\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\u0006\u0010\u000f\u001a\u00020\r\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\b\b\u0002\u0010\u0016\u001a\u00020\r\u0012\u0014\b\u0002\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001a0\u0018\u0012\b\b\u0002\u0010\u001b\u001a\u00020\r\u0012\b\b\u0002\u0010\u001c\u001a\u00020\r\u00a2\u0006\u0002\u0010\u001dJ\u0016\u00101\u001a\b\u0012\u0004\u0012\u000203022\u0006\u00104\u001a\u000205H\u0002J!\u00106\u001a\b\u0012\u0004\u0012\u000208072\f\u00109\u001a\b\u0012\u0004\u0012\u00020:07H\u0000\u00a2\u0006\u0002\b;J\u000e\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?J\u0010\u0010@\u001a\u00020A2\u0006\u0010>\u001a\u00020BH\u0002J\u0010\u0010C\u001a\u00020D2\u0006\u0010>\u001a\u00020EH\u0002J\u0010\u0010F\u001a\u00020G2\u0006\u0010>\u001a\u00020HH\u0002J\u000e\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020,J\u0014\u0010L\u001a\b\u0012\u0004\u0012\u000203022\u0006\u0010>\u001a\u00020MJ\u0010\u0010N\u001a\u00020O2\u0006\u0010>\u001a\u00020PH\u0002J\u0010\u0010Q\u001a\u0002052\u0006\u0010>\u001a\u00020RH\u0002J\u0010\u0010S\u001a\u00020T2\u0006\u0010>\u001a\u00020UH\u0002J\u000e\u0010V\u001a\u00020W2\u0006\u0010X\u001a\u00020,J\u0010\u0010Y\u001a\u00020Z2\u0006\u0010>\u001a\u00020[H\u0002J\u0010\u0010\\\u001a\u00020]2\u0006\u0010>\u001a\u00020^H\u0002J\u0015\u0010_\u001a\u00020`2\u0006\u0010>\u001a\u00020aH\u0000\u00a2\u0006\u0002\bbJ\u0010\u0010c\u001a\u00020d2\u0006\u0010>\u001a\u00020eH\u0002J\u0010\u0010f\u001a\u00020g2\u0006\u0010>\u001a\u00020hH\u0002J\u0015\u0010i\u001a\u00020(2\u0006\u0010j\u001a\u00020kH\u0000\u00a2\u0006\u0002\blJ\u000e\u0010m\u001a\u00020-2\u0006\u0010K\u001a\u00020,J\u0010\u0010n\u001a\u00020o2\u0006\u0010>\u001a\u00020pH\u0002J\u0010\u0010q\u001a\u00020r2\u0006\u0010>\u001a\u00020kH\u0002J\u0010\u0010s\u001a\u00020-2\u0006\u0010>\u001a\u00020tH\u0002J \u0010u\u001a\u00020v2\u0006\u0010>\u001a\u00020w2\u0006\u0010K\u001a\u00020,2\u0006\u0010x\u001a\u00020\rH\u0002J\u0018\u0010y\u001a\u00020z2\u0006\u0010>\u001a\u00020{2\u0006\u0010K\u001a\u00020,H\u0002J\u000e\u0010|\u001a\u00020}2\u0006\u0010>\u001a\u00020~J\u0011\u0010\u007f\u001a\u00030\u0080\u00012\u0006\u0010K\u001a\u00020,H\u0002J\u0011\u0010\u0081\u0001\u001a\u0004\u0018\u00010-2\u0006\u0010K\u001a\u00020,J\u0012\u0010\u0082\u0001\u001a\u0002032\u0007\u0010>\u001a\u00030\u0083\u0001H\u0002J\u0010\u0010\u0084\u0001\u001a\u00030\u0085\u00012\u0006\u0010K\u001a\u00020,J\u0013\u0010\u0086\u0001\u001a\u00030\u0087\u00012\u0007\u0010>\u001a\u00030\u0088\u0001H\u0002J&\u0010\u0089\u0001\u001a\b\u0012\u0004\u0012\u00020v072\r\u0010\u008a\u0001\u001a\b\u0012\u0004\u0012\u00020w072\u0006\u0010x\u001a\u00020\rH\u0002J\u001e\u0010\u008b\u0001\u001a\b\u0012\u0004\u0012\u00020z072\r\u0010\u008a\u0001\u001a\b\u0012\u0004\u0012\u00020{07H\u0002J\u0013\u0010\u008c\u0001\u001a\u00030\u008d\u00012\u0007\u0010\u008e\u0001\u001a\u00020(H\u0002J\u001a\u0010\u008f\u0001\u001a\u00020\r2\u0006\u0010>\u001a\u00020?2\u0007\u0010\u0090\u0001\u001a\u000205H\u0002J\u0012\u0010\u0091\u0001\u001a\u00030\u0092\u00012\u0006\u0010K\u001a\u00020,H\u0002J\u0012\u0010\u0093\u0001\u001a\u00030\u0094\u00012\u0006\u0010K\u001a\u00020,H\u0002J\u0011\u0010\u0095\u0001\u001a\u00020t2\u0006\u0010K\u001a\u00020,H\u0002J\u0012\u0010\u0096\u0001\u001a\u00030\u0097\u00012\u0006\u0010K\u001a\u00020,H\u0002J\u0012\u0010\u0098\u0001\u001a\u00030\u0097\u00012\u0006\u0010K\u001a\u00020,H\u0002J\u0013\u0010\u0099\u0001\u001a\u00030\u008d\u00012\u0007\u0010\u008e\u0001\u001a\u00020(H\u0002Ja\u0010\u009a\u0001\u001a\u0003H\u009b\u0001\"\u000e\b\u0000\u0010\u009b\u0001*\u00020=*\u00030\u009c\u00012\u0007\u0010>\u001a\u00030\u009d\u000125\u0010\u009e\u0001\u001a0\u0012\u0004\u0012\u00020(\u0012\u0005\u0012\u00030\u00a0\u0001\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020,\u0012\u0005\u0012\u00030\u00a1\u0001\u0012\u0004\u0012\u00020k\u0012\u0005\u0012\u0003H\u009b\u00010\u009f\u0001H\u0082\b\u00a2\u0006\u0003\u0010\u00a2\u0001J^\u0010\u00a3\u0001\u001a\u0003H\u009b\u0001\"\n\b\u0000\u0010\u009b\u0001*\u00030\u00a4\u00012\u0007\u0010>\u001a\u00030\u00a5\u000126\u0010\u009e\u0001\u001a1\u0012\u0005\u0012\u00030\u00a6\u0001\u0012\u0005\u0012\u00030\u00a0\u0001\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020,\u0012\u0005\u0012\u00030\u00a1\u0001\u0012\u0004\u0012\u00020k\u0012\u0005\u0012\u0003H\u009b\u00010\u009f\u0001H\u0082\b\u00a2\u0006\u0003\u0010\u00a7\u0001J%\u0010\u00a8\u0001\u001a\u00030\u008d\u00012\u0007\u0010\u00a9\u0001\u001a\u00020\r2\u000f\u0010\u00aa\u0001\u001a\n\u0012\u0005\u0012\u00030\u008d\u00010\u00ab\u0001H\u0082\bJ\r\u0010\u00ac\u0001\u001a\u00020\r*\u00020-H\u0002J?\u0010\u00ad\u0001\u001a\u0003H\u009b\u0001\"\t\b\u0000\u0010\u009b\u0001*\u00020%*\u0003H\u009b\u00012\u001c\u0010\u009e\u0001\u001a\u0017\u0012\u0005\u0012\u0003H\u009b\u0001\u0012\u0005\u0012\u00030\u008d\u00010\u00ae\u0001\u00a2\u0006\u0003\b\u00af\u0001H\u0082\b\u00a2\u0006\u0003\u0010\u00b0\u0001J?\u0010\u00b1\u0001\u001a\u00030\u008d\u0001\"\n\b\u0000\u0010\u009b\u0001*\u00030\u00a4\u0001*\u0003H\u009b\u00012\u001c\u0010\u009e\u0001\u001a\u0017\u0012\u0005\u0012\u0003H\u009b\u0001\u0012\u0005\u0012\u00030\u008d\u00010\u00ae\u0001\u00a2\u0006\u0003\b\u00af\u0001H\u0002\u00a2\u0006\u0003\u0010\u00b2\u0001J+\u0010\u00b3\u0001\u001a\u00030\u008d\u0001*\u00020]2\u001b\u0010\u00b4\u0001\u001a\u0016\u0012\u0004\u0012\u00020]\u0012\u0005\u0012\u00030\u008d\u00010\u00ae\u0001\u00a2\u0006\u0003\b\u00af\u0001H\u0002R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u000e\u0010\u001c\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010 \u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u000e\u0010$\u001a\u00020%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010&\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020(0'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u001a\u0010+\u001a\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020-0'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00b6\u0001"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/IrDeclarationDeserializer;", "", "builtIns", "Lorg/jetbrains/kotlin/ir/descriptors/IrBuiltIns;", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "irFactory", "Lorg/jetbrains/kotlin/ir/declarations/IrFactory;", "fileReader", "Lorg/jetbrains/kotlin/backend/common/serialization/IrLibraryFile;", "file", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "allowErrorNodes", "", "deserializeInlineFunctions", "deserializeBodies", "symbolDeserializer", "Lorg/jetbrains/kotlin/backend/common/serialization/IrSymbolDeserializer;", "platformFakeOverrideClassFilter", "Lorg/jetbrains/kotlin/backend/common/overrides/FakeOverrideClassFilter;", "fakeOverrideBuilder", "Lorg/jetbrains/kotlin/backend/common/overrides/FakeOverrideBuilder;", "skipMutableState", "additionalStatementOriginIndex", "", "", "Lorg/jetbrains/kotlin/ir/expressions/IrStatementOrigin;", "allowErrorStatementOrigins", "allowRedeclaration", "(Lorg/jetbrains/kotlin/ir/descriptors/IrBuiltIns;Lorg/jetbrains/kotlin/ir/util/SymbolTable;Lorg/jetbrains/kotlin/ir/declarations/IrFactory;Lorg/jetbrains/kotlin/backend/common/serialization/IrLibraryFile;Lorg/jetbrains/kotlin/ir/declarations/IrFile;ZZZLorg/jetbrains/kotlin/backend/common/serialization/IrSymbolDeserializer;Lorg/jetbrains/kotlin/backend/common/overrides/FakeOverrideClassFilter;Lorg/jetbrains/kotlin/backend/common/overrides/FakeOverrideBuilder;ZLjava/util/Map;ZZ)V", "getAllowErrorNodes", "()Z", "bodyDeserializer", "Lorg/jetbrains/kotlin/backend/common/serialization/IrBodyDeserializer;", "getBodyDeserializer", "()Lorg/jetbrains/kotlin/backend/common/serialization/IrBodyDeserializer;", "currentParent", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "delegatedSymbolMap", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "getIrFactory", "()Lorg/jetbrains/kotlin/ir/declarations/IrFactory;", "irTypeCache", "", "Lorg/jetbrains/kotlin/ir/types/IrType;", "isEffectivelyExternal", "getSymbolDeserializer", "()Lorg/jetbrains/kotlin/backend/common/serialization/IrSymbolDeserializer;", "computeMissingInlineClassRepresentationForCompatibility", "Lorg/jetbrains/kotlin/descriptors/InlineClassRepresentation;", "Lorg/jetbrains/kotlin/ir/types/IrSimpleType;", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "deserializeAnnotations", "", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "annotations", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrConstructorCall;", "deserializeAnnotations$ir_serialization_common", "deserializeDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "proto", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrDeclaration;", "deserializeDynamicType", "Lorg/jetbrains/kotlin/ir/types/IrDynamicType;", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrDynamicType;", "deserializeErrorDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrErrorDeclaration;", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrErrorDeclaration;", "deserializeErrorType", "Lorg/jetbrains/kotlin/ir/types/IrErrorType;", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrErrorType;", "deserializeExpressionBody", "Lorg/jetbrains/kotlin/ir/expressions/IrExpressionBody;", "index", "deserializeInlineClassRepresentation", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrInlineClassRepresentation;", "deserializeIrAnonymousInit", "Lorg/jetbrains/kotlin/ir/declarations/IrAnonymousInitializer;", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrAnonymousInit;", "deserializeIrClass", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrClass;", "deserializeIrConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrConstructor;", "deserializeIrDeclarationOrigin", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOriginImpl;", "protoName", "deserializeIrEnumEntry", "Lorg/jetbrains/kotlin/ir/declarations/IrEnumEntry;", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrEnumEntry;", "deserializeIrField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrField;", "deserializeIrFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrFunction;", "deserializeIrFunction$ir_serialization_common", "deserializeIrLocalDelegatedProperty", "Lorg/jetbrains/kotlin/ir/declarations/IrLocalDelegatedProperty;", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrLocalDelegatedProperty;", "deserializeIrProperty", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrProperty;", "deserializeIrSymbolAndRemap", "code", "", "deserializeIrSymbolAndRemap$ir_serialization_common", "deserializeIrType", "deserializeIrTypeAlias", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeAlias;", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrTypeAlias;", "deserializeIrTypeArgument", "Lorg/jetbrains/kotlin/ir/types/IrTypeArgument;", "deserializeIrTypeData", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrType;", "deserializeIrTypeParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParameter;", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrTypeParameter;", "isGlobal", "deserializeIrValueParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrValueParameter;", "deserializeIrVariable", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrVariable;", "deserializeName", "Lorg/jetbrains/kotlin/name/Name;", "deserializeNullableIrType", "deserializeSimpleType", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrSimpleType;", "deserializeStatementBody", "Lorg/jetbrains/kotlin/ir/IrElement;", "deserializeTypeAbbreviation", "Lorg/jetbrains/kotlin/ir/types/IrTypeAbbreviation;", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrTypeAbbreviation;", "deserializeTypeParameters", "protos", "deserializeValueParameters", "eraseDelegatedSymbol", "", "symbol", "isSkippableFakeOverride", "parent", "loadExpressionBodyProto", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrExpression;", "loadStatementBodyProto", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrStatement;", "loadTypeProto", "readBody", "Lorg/jetbrains/kotlin/protobuf/CodedInputStream;", "readType", "recordDelegatedSymbol", "withDeserializedIrDeclarationBase", "T", "Lorg/jetbrains/kotlin/ir/declarations/IrSymbolOwner;", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrDeclarationBase;", "block", "Lkotlin/Function6;", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOrigin;", "(Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrDeclarationBase;Lkotlin/jvm/functions/Function6;)Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "withDeserializedIrFunctionBase", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrFunctionBase;", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "(Lorg/jetbrains/kotlin/backend/common/serialization/proto/IrFunctionBase;Lkotlin/jvm/functions/Function6;)Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "withExternalValue", "value", "fn", "Lkotlin/Function0;", "checkObjectLeak", "usingParent", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "(Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "withBodyGuard", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;Lkotlin/jvm/functions/Function1;)V", "withInitializerGuard", "f", "Companion", "ir.serialization.common"})
public final class IrDeclarationDeserializer {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final SymbolTable symbolTable;
    @NotNull
    private final IrFactory irFactory;
    @NotNull
    private final IrLibraryFile fileReader;
    @NotNull
    private final IrFile file;
    private final boolean allowErrorNodes;
    private final boolean deserializeInlineFunctions;
    private boolean deserializeBodies;
    @NotNull
    private final IrSymbolDeserializer symbolDeserializer;
    @NotNull
    private final FakeOverrideClassFilter platformFakeOverrideClassFilter;
    @NotNull
    private final FakeOverrideBuilder fakeOverrideBuilder;
    private final boolean skipMutableState;
    private final boolean allowRedeclaration;
    @NotNull
    private final IrBodyDeserializer bodyDeserializer;
    @NotNull
    private final Map<Integer, org.jetbrains.kotlin.ir.types.IrType> irTypeCache;
    @NotNull
    private IrDeclarationParent currentParent;
    @NotNull
    private final Map<IrSymbol, IrSymbol> delegatedSymbolMap;
    private boolean isEffectivelyExternal;
    @NotNull
    private static final List<KClass<?>> allKnownDeclarationOrigins;
    @NotNull
    private static final Map<String, IrDeclarationOriginImpl> declarationOriginIndex;
    @NotNull
    private static final List<KClass<?>> allKnownStatementOrigins;
    @NotNull
    private static final Map<String, IrStatementOriginImpl> statementOriginIndex;

    public IrDeclarationDeserializer(@NotNull IrBuiltIns builtIns, @NotNull SymbolTable symbolTable, @NotNull IrFactory irFactory, @NotNull IrLibraryFile fileReader, @NotNull IrFile file2, boolean allowErrorNodes, boolean deserializeInlineFunctions, boolean deserializeBodies, @NotNull IrSymbolDeserializer symbolDeserializer2, @NotNull FakeOverrideClassFilter platformFakeOverrideClassFilter, @NotNull FakeOverrideBuilder fakeOverrideBuilder2, boolean skipMutableState, @NotNull Map<String, ? extends IrStatementOrigin> additionalStatementOriginIndex, boolean allowErrorStatementOrigins, boolean allowRedeclaration) {
        Intrinsics.checkNotNullParameter((Object)builtIns, (String)"builtIns");
        Intrinsics.checkNotNullParameter((Object)symbolTable, (String)"symbolTable");
        Intrinsics.checkNotNullParameter((Object)irFactory, (String)"irFactory");
        Intrinsics.checkNotNullParameter((Object)fileReader, (String)"fileReader");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)symbolDeserializer2, (String)"symbolDeserializer");
        Intrinsics.checkNotNullParameter((Object)platformFakeOverrideClassFilter, (String)"platformFakeOverrideClassFilter");
        Intrinsics.checkNotNullParameter((Object)fakeOverrideBuilder2, (String)"fakeOverrideBuilder");
        Intrinsics.checkNotNullParameter(additionalStatementOriginIndex, (String)"additionalStatementOriginIndex");
        this.symbolTable = symbolTable;
        this.irFactory = irFactory;
        this.fileReader = fileReader;
        this.file = file2;
        this.allowErrorNodes = allowErrorNodes;
        this.deserializeInlineFunctions = deserializeInlineFunctions;
        this.deserializeBodies = deserializeBodies;
        this.symbolDeserializer = symbolDeserializer2;
        this.platformFakeOverrideClassFilter = platformFakeOverrideClassFilter;
        this.fakeOverrideBuilder = fakeOverrideBuilder2;
        this.skipMutableState = skipMutableState;
        this.allowRedeclaration = allowRedeclaration;
        this.bodyDeserializer = new IrBodyDeserializer(builtIns, this.allowErrorNodes, this.irFactory, this.fileReader, this, MapsKt.plus(statementOriginIndex, additionalStatementOriginIndex), allowErrorStatementOrigins);
        boolean bl = false;
        this.irTypeCache = new LinkedHashMap();
        this.currentParent = this.file;
        bl = false;
        this.delegatedSymbolMap = new LinkedHashMap();
    }

    public /* synthetic */ IrDeclarationDeserializer(IrBuiltIns irBuiltIns, SymbolTable symbolTable, IrFactory irFactory, IrLibraryFile irLibraryFile, IrFile irFile, boolean bl, boolean bl2, boolean bl3, IrSymbolDeserializer irSymbolDeserializer, FakeOverrideClassFilter fakeOverrideClassFilter, FakeOverrideBuilder fakeOverrideBuilder2, boolean bl4, Map map, boolean bl5, boolean bl6, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x800) != 0) {
            bl4 = false;
        }
        if ((n & 0x1000) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 0x2000) != 0) {
            bl5 = false;
        }
        if ((n & 0x4000) != 0) {
            bl6 = false;
        }
        this(irBuiltIns, symbolTable, irFactory, irLibraryFile, irFile, bl, bl2, bl3, irSymbolDeserializer, fakeOverrideClassFilter, fakeOverrideBuilder2, bl4, map, bl5, bl6);
    }

    @NotNull
    public final IrFactory getIrFactory() {
        return this.irFactory;
    }

    public final boolean getAllowErrorNodes() {
        return this.allowErrorNodes;
    }

    @NotNull
    public final IrSymbolDeserializer getSymbolDeserializer() {
        return this.symbolDeserializer;
    }

    @NotNull
    public final IrBodyDeserializer getBodyDeserializer() {
        return this.bodyDeserializer;
    }

    private final Name deserializeName(int index2) {
        String name2 = IrFileDeserializerKt.deserializeString(this.fileReader, index2);
        Name name3 = Name.guessByFirstCharacter(name2);
        Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"guessByFirstCharacter(name)");
        return name3;
    }

    private final CodedInputStream readType(int index2) {
        return BasicIrModuleDeserializerKt.getCodedInputStream(this.fileReader.type(index2));
    }

    private final IrType loadTypeProto(int index2) {
        IrType irType = IrType.parseFrom(this.readType(index2), ExtensionRegistryLite.newInstance());
        Intrinsics.checkNotNullExpressionValue((Object)irType, (String)"parseFrom(readType(index\u2026gistryLite.newInstance())");
        return irType;
    }

    @Nullable
    public final org.jetbrains.kotlin.ir.types.IrType deserializeNullableIrType(int index2) {
        return index2 == -1 ? null : this.deserializeIrType(index2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final org.jetbrains.kotlin.ir.types.IrType deserializeIrType(int index2) {
        Object object;
        void $this$getOrPut$iv;
        Map<Integer, org.jetbrains.kotlin.ir.types.IrType> map = this.irTypeCache;
        Integer key$iv = index2;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            IrType typeData = this.loadTypeProto(index2);
            org.jetbrains.kotlin.ir.types.IrType answer$iv = this.deserializeIrTypeData(typeData);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (org.jetbrains.kotlin.ir.types.IrType)object;
    }

    private final IrTypeArgument deserializeIrTypeArgument(long proto) {
        long encoding = BinaryTypeProjection.Companion.decode-2ztXSlc(proto);
        if (BinaryTypeProjection.isStarProjection-impl(encoding)) {
            return IrStarProjectionImpl.INSTANCE;
        }
        return IrSimpleTypeImplKt.makeTypeProjection(this.deserializeIrType(BinaryTypeProjection.getTypeIndex-impl(encoding)), BinaryTypeProjection.getVariance-impl(encoding));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<org.jetbrains.kotlin.ir.expressions.IrConstructorCall> deserializeAnnotations$ir_serialization_common(@NotNull List<IrConstructorCall> annotations2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(annotations2, (String)"annotations");
        Iterable $this$map$iv = annotations2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrConstructorCall irConstructorCall = (IrConstructorCall)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            org.jetbrains.kotlin.ir.expressions.IrConstructorCall irConstructorCall2 = this.getBodyDeserializer().deserializeAnnotation((IrConstructorCall)it);
            collection.add(irConstructorCall2);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final org.jetbrains.kotlin.ir.types.IrSimpleType deserializeSimpleType(IrSimpleType proto) {
        org.jetbrains.kotlin.ir.types.IrTypeAbbreviation irTypeAbbreviation;
        void $this$mapTo$iv$iv;
        IrClassifierSymbol irClassifierSymbol;
        Object object = this.deserializeIrSymbolAndRemap$ir_serialization_common(proto.getClassifier());
        IrClassifierSymbol irClassifierSymbol2 = irClassifierSymbol = object instanceof IrClassifierSymbol ? (IrClassifierSymbol)object : null;
        if (irClassifierSymbol == null) {
            object = "could not convert sym to ClassifierSymbol";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(object.toString());
        }
        IrClassifierSymbol symbol2 = irClassifierSymbol;
        object = proto.getArgumentList();
        Intrinsics.checkNotNullExpressionValue(object, (String)"proto.argumentList");
        Iterable $this$map$iv = (Iterable)object;
        boolean $i$f$map22 = false;
        Object object2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Long l = (Long)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            IrTypeArgument irTypeArgument = this.deserializeIrTypeArgument(it.longValue());
            collection.add(irTypeArgument);
        }
        List arguments2 = (List)destination$iv$iv;
        List<IrConstructorCall> $i$f$map22 = proto.getAnnotationList();
        Intrinsics.checkNotNullExpressionValue($i$f$map22, (String)"proto.annotationList");
        List<org.jetbrains.kotlin.ir.expressions.IrConstructorCall> annotations2 = this.deserializeAnnotations$ir_serialization_common($i$f$map22);
        boolean bl = proto.getHasQuestionMark();
        if (proto.hasAbbreviation()) {
            object2 = proto.getAbbreviation();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"proto.abbreviation");
            irTypeAbbreviation = this.deserializeTypeAbbreviation((IrTypeAbbreviation)object2);
        } else {
            irTypeAbbreviation = null;
        }
        org.jetbrains.kotlin.ir.types.IrSimpleType result2 = new IrSimpleTypeImpl(null, symbol2, bl, arguments2, annotations2, irTypeAbbreviation);
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final org.jetbrains.kotlin.ir.types.IrTypeAbbreviation deserializeTypeAbbreviation(IrTypeAbbreviation proto) {
        Collection<IrTypeArgument> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object object;
        List<IrConstructorCall> list2 = this.deserializeIrSymbolAndRemap$ir_serialization_common(proto.getTypeAlias());
        boolean bl = false;
        boolean bl2 = false;
        IrSymbol it = list2;
        boolean bl3 = false;
        Object object2 = object = it instanceof IrTypeAliasSymbol ? (IrTypeAliasSymbol)it : null;
        if (object == null) {
            String string2 = Intrinsics.stringPlus((String)"IrTypeAliasSymbol expected: ", (Object)it);
            boolean bl4 = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        IrTypeAliasSymbol irTypeAliasSymbol = object;
        boolean bl5 = proto.getHasQuestionMark();
        list2 = proto.getArgumentList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"proto.argumentList");
        list2 = list2;
        boolean bl6 = bl5;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            Long l = (Long)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl7 = false;
            Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"it");
            IrTypeArgument irTypeArgument = this.deserializeIrTypeArgument(it2.longValue());
            collection.add(irTypeArgument);
        }
        collection = (List)destination$iv$iv;
        list2 = proto.getAnnotationList();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"proto.annotationList");
        List<org.jetbrains.kotlin.ir.expressions.IrConstructorCall> list3 = this.deserializeAnnotations$ir_serialization_common(list2);
        List list4 = collection;
        boolean bl8 = bl6;
        IrTypeAliasSymbol irTypeAliasSymbol2 = irTypeAliasSymbol;
        return new IrTypeAbbreviationImpl(irTypeAliasSymbol2, bl8, list4, list3);
    }

    private final org.jetbrains.kotlin.ir.types.IrDynamicType deserializeDynamicType(IrDynamicType proto) {
        List<IrConstructorCall> list2 = proto.getAnnotationList();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"proto.annotationList");
        List<org.jetbrains.kotlin.ir.expressions.IrConstructorCall> annotations2 = this.deserializeAnnotations$ir_serialization_common(list2);
        return new IrDynamicTypeImpl(null, annotations2, Variance.INVARIANT);
    }

    private final org.jetbrains.kotlin.ir.types.IrErrorType deserializeErrorType(IrErrorType proto) {
        boolean bl = this.allowErrorNodes;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "IrErrorType found but error code is not allowed";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        List<IrConstructorCall> list2 = proto.getAnnotationList();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"proto.annotationList");
        List<org.jetbrains.kotlin.ir.expressions.IrConstructorCall> annotations2 = this.deserializeAnnotations$ir_serialization_common(list2);
        return new IrErrorTypeImpl(null, annotations2, Variance.INVARIANT);
    }

    private final org.jetbrains.kotlin.ir.types.IrType deserializeIrTypeData(IrType proto) {
        org.jetbrains.kotlin.ir.types.IrType irType;
        IrType.KindCase kindCase = proto.getKindCase();
        int n = kindCase == null ? -1 : WhenMappings.$EnumSwitchMapping$0[kindCase.ordinal()];
        switch (n) {
            case 1: {
                IrSimpleType irSimpleType = proto.getSimple();
                Intrinsics.checkNotNullExpressionValue((Object)irSimpleType, (String)"proto.simple");
                irType = this.deserializeSimpleType(irSimpleType);
                break;
            }
            case 2: {
                IrDynamicType irDynamicType = proto.getDynamic();
                Intrinsics.checkNotNullExpressionValue((Object)irDynamicType, (String)"proto.dynamic");
                irType = this.deserializeDynamicType(irDynamicType);
                break;
            }
            case 3: {
                IrErrorType irErrorType = proto.getError();
                Intrinsics.checkNotNullExpressionValue((Object)irErrorType, (String)"proto.error");
                irType = this.deserializeErrorType(irErrorType);
                break;
            }
            default: {
                String string2 = Intrinsics.stringPlus((String)"Unexpected IrType kind: ", (Object)proto.getKindCase());
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
        }
        return irType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T extends IrDeclarationParent> T usingParent(T $this$usingParent, Function1<? super T, Unit> block) {
        boolean $i$f$usingParent = false;
        T t = $this$usingParent;
        boolean bl = false;
        boolean bl2 = false;
        T $this$usingParent_u24lambda_u2d6 = t;
        boolean bl3 = false;
        IrDeclarationParent oldParent = this.currentParent;
        this.currentParent = $this$usingParent_u24lambda_u2d6;
        try {
            block.invoke($this$usingParent_u24lambda_u2d6);
        }
        finally {
            InlineMarker.finallyStart((int)1);
            this.currentParent = oldParent;
            InlineMarker.finallyEnd((int)1);
        }
        return t;
    }

    @NotNull
    public final IrSymbol deserializeIrSymbolAndRemap$ir_serialization_common(long code) {
        IrSymbol irSymbol2 = this.symbolDeserializer.deserializeIrSymbol(code);
        boolean bl = false;
        boolean bl2 = false;
        IrSymbol it = irSymbol2;
        boolean bl3 = false;
        IrSymbol irSymbol3 = this.delegatedSymbolMap.get(it);
        return irSymbol3 == null ? it : irSymbol3;
    }

    private final void recordDelegatedSymbol(IrSymbol symbol2) {
        if (symbol2 instanceof IrDelegatingSymbol) {
            Map<IrSymbol, IrSymbol> map = this.delegatedSymbolMap;
            Object s = ((IrDelegatingSymbol)symbol2).getDelegate();
            boolean bl = false;
            map.put(symbol2, (IrSymbol)s);
        }
    }

    private final void eraseDelegatedSymbol(IrSymbol symbol2) {
        if (symbol2 instanceof IrDelegatingSymbol) {
            this.delegatedSymbolMap.remove(symbol2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void withExternalValue(boolean value2, Function0<Unit> fn) {
        boolean $i$f$withExternalValue = false;
        boolean oldExternalValue = this.isEffectivelyExternal;
        this.isEffectivelyExternal = value2;
        try {
            fn.invoke();
        }
        finally {
            InlineMarker.finallyStart((int)1);
            this.isEffectivelyExternal = oldExternalValue;
            InlineMarker.finallyEnd((int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T extends org.jetbrains.kotlin.ir.declarations.IrDeclaration & IrSymbolOwner> T withDeserializedIrDeclarationBase(IrDeclarationBase proto, Function6<? super IrSymbol, ? super IdSignature, ? super Integer, ? super Integer, ? super IrDeclarationOrigin, ? super Long, ? extends T> block) {
        boolean $i$f$withDeserializedIrDeclarationBase = false;
        Pair<IrSymbol, IdSignature> pair = this.getSymbolDeserializer().deserializeIrSymbolToDeclare(proto.getSymbol());
        IrSymbol s = (IrSymbol)pair.component1();
        IdSignature uid = (IdSignature)pair.component2();
        long coordinates = BinaryCoordinates.Companion.decode-ViYoqTc(proto.getCoordinates());
        try {
            org.jetbrains.kotlin.ir.declarations.IrDeclaration irDeclaration2;
            this.recordDelegatedSymbol(s);
            org.jetbrains.kotlin.ir.declarations.IrDeclaration result2 = (org.jetbrains.kotlin.ir.declarations.IrDeclaration)block.invoke((Object)s, (Object)uid, (Object)BinaryCoordinates.getStartOffset-impl(coordinates), (Object)BinaryCoordinates.getEndOffset-impl(coordinates), (Object)this.deserializeIrDeclarationOrigin(proto.getOriginName()), (Object)proto.getFlags());
            if (!this.allowRedeclaration || result2.getAnnotations().isEmpty()) {
                irDeclaration2 = result2;
                Collection collection = irDeclaration2.getAnnotations();
                List<IrConstructorCall> list2 = proto.getAnnotationList();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"proto.annotationList");
                irDeclaration2.setAnnotations(CollectionsKt.plus((Collection)collection, (Iterable)this.deserializeAnnotations$ir_serialization_common(list2)));
            }
            if (!this.skipMutableState) {
                result2.setParent(this.currentParent);
            }
            irDeclaration2 = result2;
            return (T)irDeclaration2;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            this.eraseDelegatedSymbol(s);
            InlineMarker.finallyEnd((int)1);
        }
    }

    private final org.jetbrains.kotlin.ir.declarations.IrTypeParameter deserializeIrTypeParameter(IrTypeParameter proto, int index2, boolean isGlobal) {
        org.jetbrains.kotlin.ir.declarations.IrTypeParameter irTypeParameter2;
        Name name2 = this.deserializeName(proto.getName());
        long coordinates = BinaryCoordinates.Companion.decode-ViYoqTc(proto.getBase().getCoordinates());
        long flags = TypeParameterFlags.Companion.decode-dTrNHuw(proto.getBase().getFlags());
        Function1 factory2 = (Function1)new Function1<IrTypeParameterSymbol, org.jetbrains.kotlin.ir.declarations.IrTypeParameter>(this, coordinates, proto, name2, index2, flags){
            final /* synthetic */ IrDeclarationDeserializer this$0;
            final /* synthetic */ long $coordinates;
            final /* synthetic */ IrTypeParameter $proto;
            final /* synthetic */ Name $name;
            final /* synthetic */ int $index;
            final /* synthetic */ long $flags;
            {
                this.this$0 = $receiver;
                this.$coordinates = $coordinates;
                this.$proto = $proto;
                this.$name = $name;
                this.$index = $index;
                this.$flags = $flags;
                super(1);
            }

            @NotNull
            public final org.jetbrains.kotlin.ir.declarations.IrTypeParameter invoke(@NotNull IrTypeParameterSymbol symbol2) {
                Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
                return this.this$0.getIrFactory().createTypeParameter(BinaryCoordinates.getStartOffset-impl(this.$coordinates), BinaryCoordinates.getEndOffset-impl(this.$coordinates), this.this$0.deserializeIrDeclarationOrigin(this.$proto.getBase().getOriginName()), symbol2, this.$name, this.$index, TypeParameterFlags.isReified-impl(this.$flags), TypeParameterFlags.getVariance-impl(this.$flags));
            }
        };
        Object sig = null;
        Object object = this.symbolTable;
        boolean bl = false;
        boolean bl2 = false;
        SymbolTable $this$deserializeIrTypeParameter_u24lambda_u2d8 = object;
        boolean bl3 = false;
        if (isGlobal) {
            Pair<IrSymbol, IdSignature> p = this.getSymbolDeserializer().deserializeIrSymbolToDeclare(proto.getBase().getSymbol());
            IrTypeParameterSymbol symbol2 = (IrTypeParameterSymbol)p.getFirst();
            sig = p.getSecond();
            irTypeParameter2 = $this$deserializeIrTypeParameter_u24lambda_u2d8.declareGlobalTypeParameter((IdSignature)sig, (Function0<? extends IrTypeParameterSymbol>)((Function0)new Function0<IrTypeParameterSymbol>(symbol2){
                final /* synthetic */ IrTypeParameterSymbol $symbol;
                {
                    this.$symbol = $symbol;
                    super(0);
                }

                @NotNull
                public final IrTypeParameterSymbol invoke() {
                    return this.$symbol;
                }
            }), (Function1<? super IrTypeParameterSymbol, ? extends org.jetbrains.kotlin.ir.declarations.IrTypeParameter>)factory2);
        } else {
            long symbolData = BinarySymbolData.Companion.decode-9x8F8T0(proto.getBase().getSymbol());
            sig = this.getSymbolDeserializer().deserializeIdSignature(BinarySymbolData.getSignatureId-impl(symbolData));
            irTypeParameter2 = $this$deserializeIrTypeParameter_u24lambda_u2d8.declareScopedTypeParameter((IdSignature)sig, (Function0<? extends IrTypeParameterSymbol>)((Function0)deserializeIrTypeParameter.result.1.2.INSTANCE), (Function1<? super IrTypeParameterSymbol, ? extends org.jetbrains.kotlin.ir.declarations.IrTypeParameter>)factory2);
        }
        org.jetbrains.kotlin.ir.declarations.IrTypeParameter result2 = irTypeParameter2;
        this.symbolDeserializer.referenceLocalIrSymbol(result2.getSymbol(), (IdSignature)sig);
        object = result2;
        Collection collection = object.getAnnotations();
        List<IrConstructorCall> list2 = proto.getBase().getAnnotationList();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"proto.base.annotationList");
        object.setAnnotations(CollectionsKt.plus((Collection)collection, (Iterable)this.deserializeAnnotations$ir_serialization_common(list2)));
        result2.setParent(this.currentParent);
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final org.jetbrains.kotlin.ir.declarations.IrValueParameter deserializeIrValueParameter(IrValueParameter proto, int index2) {
        Object object;
        void this_$iv;
        IrDeclarationDeserializer irDeclarationDeserializer = this;
        IrDeclarationBase irDeclarationBase = proto.getBase();
        Intrinsics.checkNotNullExpressionValue((Object)irDeclarationBase, (String)"proto.base");
        IrDeclarationBase proto$iv = irDeclarationBase;
        boolean $i$f$withDeserializedIrDeclarationBase = false;
        Pair<IrSymbol, IdSignature> pair = this_$iv.getSymbolDeserializer().deserializeIrSymbolToDeclare(proto$iv.getSymbol());
        IrSymbol s$iv = (IrSymbol)pair.component1();
        IdSignature uid$iv = (IdSignature)pair.component2();
        long coordinates$iv = BinaryCoordinates.Companion.decode-ViYoqTc(proto$iv.getCoordinates());
        try {
            void origin;
            void endOffset;
            void startOffset;
            void fcode;
            ((IrDeclarationDeserializer)this_$iv).recordDelegatedSymbol(s$iv);
            long l = proto$iv.getFlags();
            IrDeclarationOrigin irDeclarationOrigin = this_$iv.deserializeIrDeclarationOrigin(proto$iv.getOriginName());
            int n = BinaryCoordinates.getEndOffset-impl(coordinates$iv);
            int n2 = BinaryCoordinates.getStartOffset-impl(coordinates$iv);
            object = uid$iv;
            IrSymbol symbol2 = s$iv;
            boolean bl = false;
            long flags = ValueParameterFlags.Companion.decode-eyNVhwA((long)fcode);
            long nameAndType = BinaryNameAndType.Companion.decode-WXC2TjU(proto.getNameType());
            org.jetbrains.kotlin.ir.declarations.IrValueParameter irValueParameter = this.getIrFactory().createValueParameter((int)startOffset, (int)endOffset, (IrDeclarationOrigin)origin, (IrValueParameterSymbol)symbol2, this.deserializeName(BinaryNameAndType.getNameIndex-impl(nameAndType)), index2, this.deserializeIrType(BinaryNameAndType.getTypeIndex-impl(nameAndType)), proto.hasVarargElementType() ? this.deserializeIrType(proto.getVarargElementType()) : null, ValueParameterFlags.isCrossInline-impl(flags), ValueParameterFlags.isNoInline-impl(flags), ValueParameterFlags.isHidden-impl(flags), ValueParameterFlags.isAssignable-impl(flags));
            boolean bl2 = false;
            boolean bl3 = false;
            org.jetbrains.kotlin.ir.declarations.IrValueParameter $this$deserializeIrValueParameter_u24lambda_u2d10_u24lambda_u2d9 = irValueParameter;
            boolean bl4 = false;
            if (proto.hasDefaultValue()) {
                $this$deserializeIrValueParameter_u24lambda_u2d10_u24lambda_u2d9.setDefaultValue(this.deserializeExpressionBody(proto.getDefaultValue()));
            }
            org.jetbrains.kotlin.ir.declarations.IrDeclaration result$iv = irValueParameter;
            if (!((IrDeclarationDeserializer)this_$iv).allowRedeclaration || result$iv.getAnnotations().isEmpty()) {
                object = result$iv;
                Collection collection = object.getAnnotations();
                List<IrConstructorCall> list2 = proto$iv.getAnnotationList();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"proto.annotationList");
                object.setAnnotations(CollectionsKt.plus((Collection)collection, (Iterable)this_$iv.deserializeAnnotations$ir_serialization_common(list2)));
            }
            if (!((IrDeclarationDeserializer)this_$iv).skipMutableState) {
                result$iv.setParent(((IrDeclarationDeserializer)this_$iv).currentParent);
            }
            object = result$iv;
        }
        finally {
            ((IrDeclarationDeserializer)this_$iv).eraseDelegatedSymbol(s$iv);
        }
        return (org.jetbrains.kotlin.ir.declarations.IrValueParameter)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final org.jetbrains.kotlin.ir.declarations.IrClass deserializeIrClass(IrClass proto) {
        Object object;
        void proto$iv;
        void this_$iv;
        IrDeclarationDeserializer irDeclarationDeserializer = this;
        IrDeclarationBase irDeclarationBase = proto.getBase();
        Intrinsics.checkNotNullExpressionValue((Object)irDeclarationBase, (String)"proto.base");
        boolean $i$f$withDeserializedIrDeclarationBase = false;
        Pair<IrSymbol, IdSignature> pair = this_$iv.getSymbolDeserializer().deserializeIrSymbolToDeclare(proto$iv.getSymbol());
        IrSymbol s$iv = (IrSymbol)pair.component1();
        IdSignature uid$iv = (IdSignature)pair.component2();
        long coordinates$iv = BinaryCoordinates.Companion.decode-ViYoqTc(proto$iv.getCoordinates());
        try {
            void var23_23;
            block20: {
                void this_$iv2;
                void $this$usingParent$iv;
                void origin;
                void endOffset;
                void startOffset;
                void signature2;
                void fcode;
                ((IrDeclarationDeserializer)this_$iv).recordDelegatedSymbol(s$iv);
                long l = proto$iv.getFlags();
                IrDeclarationOrigin irDeclarationOrigin = this_$iv.deserializeIrDeclarationOrigin(proto$iv.getOriginName());
                int n = BinaryCoordinates.getEndOffset-impl(coordinates$iv);
                int n2 = BinaryCoordinates.getStartOffset-impl(coordinates$iv);
                object = uid$iv;
                IrSymbol symbol2 = s$iv;
                boolean bl = false;
                long flags = ClassFlags.Companion.decode-K2PyDQs((long)fcode);
                if (this.allowRedeclaration && symbol2.isBound()) {
                    org.jetbrains.kotlin.ir.declarations.IrClass irClass2 = (org.jetbrains.kotlin.ir.declarations.IrClass)symbol2.getOwner();
                    return irClass2;
                }
                IrDeclarationDeserializer irDeclarationDeserializer2 = this;
                IrDeclarationParent irDeclarationParent = this.symbolTable.declareClass((IdSignature)signature2, (Function0<? extends IrClassSymbol>)((Function0)new Function0<IrClassSymbol>(symbol2){
                    final /* synthetic */ IrSymbol $symbol;
                    {
                        this.$symbol = $symbol;
                        super(0);
                    }

                    @NotNull
                    public final IrClassSymbol invoke() {
                        return (IrClassSymbol)this.$symbol;
                    }
                }), (Function1<? super IrClassSymbol, ? extends org.jetbrains.kotlin.ir.declarations.IrClass>)((Function1)new Function1<IrClassSymbol, org.jetbrains.kotlin.ir.declarations.IrClass>(this, (int)startOffset, (int)endOffset, (IrDeclarationOrigin)origin, proto, flags){
                    final /* synthetic */ IrDeclarationDeserializer this$0;
                    final /* synthetic */ int $startOffset;
                    final /* synthetic */ int $endOffset;
                    final /* synthetic */ IrDeclarationOrigin $origin;
                    final /* synthetic */ IrClass $proto;
                    final /* synthetic */ long $flags;
                    {
                        this.this$0 = $receiver;
                        this.$startOffset = $startOffset;
                        this.$endOffset = $endOffset;
                        this.$origin = $origin;
                        this.$proto = $proto;
                        this.$flags = $flags;
                        super(1);
                    }

                    @NotNull
                    public final org.jetbrains.kotlin.ir.declarations.IrClass invoke(@NotNull IrClassSymbol it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return IrFactory.DefaultImpls.createClass$default(this.this$0.getIrFactory(), this.$startOffset, this.$endOffset, this.$origin, it, IrDeclarationDeserializer.access$deserializeName(this.this$0, this.$proto.getName()), ClassFlags.getKind-impl(this.$flags), ClassFlags.getVisibility-impl(this.$flags), ClassFlags.getModality-impl(this.$flags), ClassFlags.isCompanion-impl(this.$flags), ClassFlags.isInner-impl(this.$flags), ClassFlags.isData-impl(this.$flags), ClassFlags.isExternal-impl(this.$flags) || IrDeclarationDeserializer.access$isEffectivelyExternal$p(this.this$0), ClassFlags.isInline-impl(this.$flags), ClassFlags.isExpect-impl(this.$flags), ClassFlags.isFun-impl(this.$flags), null, 32768, null);
                    }
                }));
                boolean $i$f$usingParent = false;
                var23_23 = $this$usingParent$iv;
                boolean bl2 = false;
                boolean bl3 = false;
                void $this$usingParent_u24lambda_u2d6$iv = var23_23;
                boolean bl4 = false;
                IrDeclarationParent oldParent$iv = ((IrDeclarationDeserializer)this_$iv2).currentParent;
                ((IrDeclarationDeserializer)this_$iv2).currentParent = (IrDeclarationParent)$this$usingParent_u24lambda_u2d6$iv;
                try {
                    InlineClassRepresentation<org.jetbrains.kotlin.ir.types.IrSimpleType> inlineClassRepresentation2;
                    void this_$iv3;
                    void it;
                    Collection<org.jetbrains.kotlin.ir.types.IrType> collection;
                    void $this$mapTo$iv$iv;
                    IrDeclarationDeserializer $this$map$iv;
                    org.jetbrains.kotlin.ir.declarations.IrClass $this$deserializeIrClass_u24lambda_u2d16_u24lambda_u2d15 = (org.jetbrains.kotlin.ir.declarations.IrClass)$this$usingParent_u24lambda_u2d6$iv;
                    boolean bl5 = false;
                    if (this.skipMutableState) break block20;
                    Object object2 = proto.getTypeParameterList();
                    Intrinsics.checkNotNullExpressionValue(object2, (String)"proto.typeParameterList");
                    $this$deserializeIrClass_u24lambda_u2d16_u24lambda_u2d15.setTypeParameters(this.deserializeTypeParameters((List<IrTypeParameter>)object2, true));
                    object2 = proto.getSuperTypeList();
                    Intrinsics.checkNotNullExpressionValue(object2, (String)"proto.superTypeList");
                    object2 = (Iterable)object2;
                    org.jetbrains.kotlin.ir.declarations.IrClass irClass3 = $this$deserializeIrClass_u24lambda_u2d16_u24lambda_u2d15;
                    boolean $i$f$map = false;
                    void var34_34 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)((Object)$this$map$iv), (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        Integer n3 = (Integer)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl6 = false;
                        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                        org.jetbrains.kotlin.ir.types.IrType irType = this.deserializeIrType(it.intValue());
                        collection.add(irType);
                    }
                    collection = (List)destination$iv$iv;
                    irClass3.setSuperTypes((List<? extends org.jetbrains.kotlin.ir.types.IrType>)collection);
                    $this$map$iv = this;
                    boolean value$iv = $this$deserializeIrClass_u24lambda_u2d16_u24lambda_u2d15.isExternal();
                    boolean $i$f$withExternalValue = false;
                    boolean oldExternalValue$iv = ((IrDeclarationDeserializer)this_$iv3).isEffectivelyExternal;
                    ((IrDeclarationDeserializer)this_$iv3).isEffectivelyExternal = value$iv;
                    try {
                        void $this$mapTo$iv;
                        void $this$filterNotTo$iv$iv;
                        Iterable $this$filterNot$iv;
                        boolean bl7 = false;
                        Object object3 = proto.getDeclarationList();
                        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"proto.declarationList");
                        object3 = (Iterable)object3;
                        boolean $i$f$filterNot = false;
                        it = $this$filterNot$iv;
                        Collection destination$iv$iv2 = new ArrayList();
                        boolean $i$f$filterNotTo = false;
                        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                            IrDeclaration it2 = (IrDeclaration)element$iv$iv;
                            boolean bl8 = false;
                            Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"it");
                            if (this.isSkippableFakeOverride(it2, $this$deserializeIrClass_u24lambda_u2d16_u24lambda_u2d15)) continue;
                            destination$iv$iv2.add(element$iv$iv);
                        }
                        $this$filterNot$iv = (List)destination$iv$iv2;
                        Collection destination$iv = $this$deserializeIrClass_u24lambda_u2d16_u24lambda_u2d15.getDeclarations();
                        boolean $i$f$mapTo2 = false;
                        for (Object item$iv : $this$mapTo$iv) {
                            void it3;
                            IrDeclaration irDeclaration2 = (IrDeclaration)item$iv;
                            Collection collection2 = destination$iv;
                            boolean bl9 = false;
                            Intrinsics.checkNotNullExpressionValue((Object)it3, (String)"it");
                            org.jetbrains.kotlin.ir.declarations.IrDeclaration irDeclaration3 = this.deserializeDeclaration((IrDeclaration)it3);
                            collection2.add(irDeclaration3);
                        }
                    }
                    finally {
                        ((IrDeclarationDeserializer)this_$iv3).isEffectivelyExternal = oldExternalValue$iv;
                    }
                    object2 = proto.getThisReceiver();
                    Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"proto.thisReceiver");
                    $this$deserializeIrClass_u24lambda_u2d16_u24lambda_u2d15.setThisReceiver(this.deserializeIrValueParameter((IrValueParameter)object2, -1));
                    if (!ClassFlags.isInline-impl(flags)) {
                        inlineClassRepresentation2 = null;
                    } else if (proto.hasInlineClassRepresentation()) {
                        object2 = proto.getInlineClassRepresentation();
                        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"proto.inlineClassRepresentation");
                        inlineClassRepresentation2 = this.deserializeInlineClassRepresentation((IrInlineClassRepresentation)object2);
                    } else {
                        inlineClassRepresentation2 = this.computeMissingInlineClassRepresentationForCompatibility($this$deserializeIrClass_u24lambda_u2d16_u24lambda_u2d15);
                    }
                    $this$deserializeIrClass_u24lambda_u2d16_u24lambda_u2d15.setInlineClassRepresentation(inlineClassRepresentation2);
                    this.fakeOverrideBuilder.enqueueClass($this$deserializeIrClass_u24lambda_u2d16_u24lambda_u2d15, (IdSignature)signature2);
                }
                finally {
                    ((IrDeclarationDeserializer)this_$iv2).currentParent = oldParent$iv;
                }
            }
            org.jetbrains.kotlin.ir.declarations.IrDeclaration result$iv = (org.jetbrains.kotlin.ir.declarations.IrClass)var23_23;
            if (!((IrDeclarationDeserializer)this_$iv).allowRedeclaration || result$iv.getAnnotations().isEmpty()) {
                object = result$iv;
                Collection collection = object.getAnnotations();
                List<IrConstructorCall> list2 = proto$iv.getAnnotationList();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"proto.annotationList");
                object.setAnnotations(CollectionsKt.plus((Collection)collection, (Iterable)this_$iv.deserializeAnnotations$ir_serialization_common(list2)));
            }
            if (!((IrDeclarationDeserializer)this_$iv).skipMutableState) {
                result$iv.setParent(((IrDeclarationDeserializer)this_$iv).currentParent);
            }
            object = result$iv;
        }
        finally {
            ((IrDeclarationDeserializer)this_$iv).eraseDelegatedSymbol(s$iv);
        }
        return (org.jetbrains.kotlin.ir.declarations.IrClass)object;
    }

    @NotNull
    public final InlineClassRepresentation<org.jetbrains.kotlin.ir.types.IrSimpleType> deserializeInlineClassRepresentation(@NotNull IrInlineClassRepresentation proto) {
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        return new InlineClassRepresentation<SimpleTypeMarker>(this.deserializeName(proto.getUnderlyingPropertyName()), (org.jetbrains.kotlin.ir.types.IrSimpleType)this.deserializeIrType(proto.getUnderlyingPropertyType()));
    }

    private final InlineClassRepresentation<org.jetbrains.kotlin.ir.types.IrSimpleType> computeMissingInlineClassRepresentationForCompatibility(org.jetbrains.kotlin.ir.declarations.IrClass irClass2) {
        org.jetbrains.kotlin.ir.declarations.IrConstructor irConstructor2 = IrUtilsKt.getPrimaryConstructor(irClass2);
        if (irConstructor2 == null) {
            String string2 = Intrinsics.stringPlus((String)"Inline class has no primary constructor: ", (Object)RenderIrElementKt.render(irClass2));
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        org.jetbrains.kotlin.ir.declarations.IrConstructor ctor = irConstructor2;
        org.jetbrains.kotlin.ir.declarations.IrValueParameter irValueParameter = (org.jetbrains.kotlin.ir.declarations.IrValueParameter)CollectionsKt.singleOrNull(ctor.getValueParameters());
        if (irValueParameter == null) {
            String string3 = Intrinsics.stringPlus((String)"Failed to get single parameter of inline class constructor: ", (Object)RenderIrElementKt.render(ctor));
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string3.toString());
        }
        org.jetbrains.kotlin.ir.declarations.IrValueParameter parameter = irValueParameter;
        return new InlineClassRepresentation<SimpleTypeMarker>(parameter.getName(), (org.jetbrains.kotlin.ir.types.IrSimpleType)parameter.getType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final org.jetbrains.kotlin.ir.declarations.IrTypeAlias deserializeIrTypeAlias(IrTypeAlias proto) {
        Object object;
        void proto$iv;
        void this_$iv;
        IrDeclarationDeserializer irDeclarationDeserializer = this;
        IrDeclarationBase irDeclarationBase = proto.getBase();
        Intrinsics.checkNotNullExpressionValue((Object)irDeclarationBase, (String)"proto.base");
        boolean $i$f$withDeserializedIrDeclarationBase = false;
        Pair<IrSymbol, IdSignature> pair = this_$iv.getSymbolDeserializer().deserializeIrSymbolToDeclare(proto$iv.getSymbol());
        IrSymbol s$iv = (IrSymbol)pair.component1();
        IdSignature uid$iv = (IdSignature)pair.component2();
        long coordinates$iv = BinaryCoordinates.Companion.decode-ViYoqTc(proto$iv.getCoordinates());
        try {
            void this_$iv2;
            void $this$usingParent$iv;
            void origin;
            void endOffset;
            void startOffset;
            void fcode;
            void uniqId;
            ((IrDeclarationDeserializer)this_$iv).recordDelegatedSymbol(s$iv);
            long l = proto$iv.getFlags();
            IrDeclarationOrigin irDeclarationOrigin = this_$iv.deserializeIrDeclarationOrigin(proto$iv.getOriginName());
            int n = BinaryCoordinates.getEndOffset-impl(coordinates$iv);
            int n2 = BinaryCoordinates.getStartOffset-impl(coordinates$iv);
            object = uid$iv;
            IrSymbol symbol2 = s$iv;
            boolean bl = false;
            boolean bl2 = symbol2 instanceof IrTypeAliasSymbol;
            boolean bl3 = false;
            boolean bl4 = false;
            bl4 = false;
            boolean bl5 = false;
            if (!bl2) {
                boolean bl6 = false;
                String string2 = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string2.toString());
            }
            IrDeclarationDeserializer irDeclarationDeserializer2 = this;
            IrDeclarationParent irDeclarationParent = this.symbolTable.declareTypeAlias((IdSignature)uniqId, (Function0<? extends IrTypeAliasSymbol>)((Function0)new Function0<IrTypeAliasSymbol>(symbol2){
                final /* synthetic */ IrSymbol $symbol;
                {
                    this.$symbol = $symbol;
                    super(0);
                }

                @NotNull
                public final IrTypeAliasSymbol invoke() {
                    return (IrTypeAliasSymbol)this.$symbol;
                }
            }), (Function1<? super IrTypeAliasSymbol, ? extends org.jetbrains.kotlin.ir.declarations.IrTypeAlias>)((Function1)new Function1<IrTypeAliasSymbol, org.jetbrains.kotlin.ir.declarations.IrTypeAlias>((long)fcode, proto, this, (int)startOffset, (int)endOffset, (IrDeclarationOrigin)origin){
                final /* synthetic */ long $fcode;
                final /* synthetic */ IrTypeAlias $proto;
                final /* synthetic */ IrDeclarationDeserializer this$0;
                final /* synthetic */ int $startOffset;
                final /* synthetic */ int $endOffset;
                final /* synthetic */ IrDeclarationOrigin $origin;
                {
                    this.$fcode = $fcode;
                    this.$proto = $proto;
                    this.this$0 = $receiver;
                    this.$startOffset = $startOffset;
                    this.$endOffset = $endOffset;
                    this.$origin = $origin;
                    super(1);
                }

                @NotNull
                public final org.jetbrains.kotlin.ir.declarations.IrTypeAlias invoke(@NotNull IrTypeAliasSymbol it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    long flags = TypeAliasFlags.Companion.decode-OrzgV44(this.$fcode);
                    long nameType = BinaryNameAndType.Companion.decode-WXC2TjU(this.$proto.getNameType());
                    return this.this$0.getIrFactory().createTypeAlias(this.$startOffset, this.$endOffset, it, IrDeclarationDeserializer.access$deserializeName(this.this$0, BinaryNameAndType.getNameIndex-impl(nameType)), TypeAliasFlags.getVisibility-impl(flags), this.this$0.deserializeIrType(BinaryNameAndType.getTypeIndex-impl(nameType)), TypeAliasFlags.isActual-impl(flags), this.$origin);
                }
            }));
            boolean $i$f$usingParent = false;
            void var21_25 = $this$usingParent$iv;
            boolean bl7 = false;
            boolean bl8 = false;
            void $this$usingParent_u24lambda_u2d6$iv = var21_25;
            boolean bl9 = false;
            IrDeclarationParent oldParent$iv = ((IrDeclarationDeserializer)this_$iv2).currentParent;
            ((IrDeclarationDeserializer)this_$iv2).currentParent = (IrDeclarationParent)$this$usingParent_u24lambda_u2d6$iv;
            try {
                org.jetbrains.kotlin.ir.declarations.IrTypeAlias $this$deserializeIrTypeAlias_u24lambda_u2d18_u24lambda_u2d17 = (org.jetbrains.kotlin.ir.declarations.IrTypeAlias)$this$usingParent_u24lambda_u2d6$iv;
                boolean bl10 = false;
                if (!this.skipMutableState) {
                    List<IrTypeParameter> list2 = proto.getTypeParameterList();
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"proto.typeParameterList");
                    $this$deserializeIrTypeAlias_u24lambda_u2d18_u24lambda_u2d17.setTypeParameters(this.deserializeTypeParameters(list2, true));
                }
            }
            finally {
                ((IrDeclarationDeserializer)this_$iv2).currentParent = oldParent$iv;
            }
            org.jetbrains.kotlin.ir.declarations.IrDeclaration result$iv = (org.jetbrains.kotlin.ir.declarations.IrTypeAlias)var21_25;
            if (!((IrDeclarationDeserializer)this_$iv).allowRedeclaration || result$iv.getAnnotations().isEmpty()) {
                object = result$iv;
                Collection collection = object.getAnnotations();
                List<IrConstructorCall> list3 = proto$iv.getAnnotationList();
                Intrinsics.checkNotNullExpressionValue(list3, (String)"proto.annotationList");
                object.setAnnotations(CollectionsKt.plus((Collection)collection, (Iterable)this_$iv.deserializeAnnotations$ir_serialization_common(list3)));
            }
            if (!((IrDeclarationDeserializer)this_$iv).skipMutableState) {
                result$iv.setParent(((IrDeclarationDeserializer)this_$iv).currentParent);
            }
            object = result$iv;
        }
        finally {
            ((IrDeclarationDeserializer)this_$iv).eraseDelegatedSymbol(s$iv);
        }
        return (org.jetbrains.kotlin.ir.declarations.IrTypeAlias)object;
    }

    private final org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration deserializeErrorDeclaration(IrErrorDeclaration proto) {
        boolean bl = this.allowErrorNodes;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "IrErrorDeclaration found but error code is not allowed";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        long coordinates = BinaryCoordinates.Companion.decode-ViYoqTc(proto.getCoordinates());
        org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration irErrorDeclaration = IrFactory.DefaultImpls.createErrorDeclaration$default(this.irFactory, BinaryCoordinates.getStartOffset-impl(coordinates), BinaryCoordinates.getEndOffset-impl(coordinates), null, 4, null);
        boolean bl5 = false;
        boolean bl6 = false;
        org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration it = irErrorDeclaration;
        boolean bl7 = false;
        it.setParent(this.currentParent);
        return irErrorDeclaration;
    }

    /*
     * WARNING - void declaration
     */
    private final List<org.jetbrains.kotlin.ir.declarations.IrTypeParameter> deserializeTypeParameters(List<IrTypeParameter> protos, boolean isGlobal) {
        Object proto;
        ArrayList<org.jetbrains.kotlin.ir.declarations.IrTypeParameter> result2 = new ArrayList<org.jetbrains.kotlin.ir.declarations.IrTypeParameter>(protos.size());
        int n = 0;
        int n2 = protos.size() + -1;
        if (n <= n2) {
            do {
                int index2 = n++;
                proto = protos.get(index2);
                result2.add(this.deserializeIrTypeParameter((IrTypeParameter)proto, index2, isGlobal));
            } while (n <= n2);
        }
        if ((n = 0) <= (n2 = protos.size() + -1)) {
            do {
                Collection<org.jetbrains.kotlin.ir.types.IrType> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                int i = n++;
                org.jetbrains.kotlin.ir.declarations.IrTypeParameter irTypeParameter2 = (org.jetbrains.kotlin.ir.declarations.IrTypeParameter)result2.get(i);
                proto = protos.get(i).getSuperTypeList();
                Intrinsics.checkNotNullExpressionValue((Object)proto, (String)"protos[i].superTypeList");
                proto = (Iterable)proto;
                org.jetbrains.kotlin.ir.declarations.IrTypeParameter irTypeParameter3 = irTypeParameter2;
                boolean $i$f$map = false;
                void var9_9 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Integer n3 = (Integer)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    org.jetbrains.kotlin.ir.types.IrType irType = this.deserializeIrType(it.intValue());
                    collection.add(irType);
                }
                collection = (List)destination$iv$iv;
                irTypeParameter3.setSuperTypes((List<? extends org.jetbrains.kotlin.ir.types.IrType>)collection);
            } while (n <= n2);
        }
        return result2;
    }

    private final List<org.jetbrains.kotlin.ir.declarations.IrValueParameter> deserializeValueParameters(List<IrValueParameter> protos) {
        ArrayList<org.jetbrains.kotlin.ir.declarations.IrValueParameter> result2 = new ArrayList<org.jetbrains.kotlin.ir.declarations.IrValueParameter>(protos.size());
        int n = 0;
        int n2 = protos.size() + -1;
        if (n <= n2) {
            do {
                int i = n++;
                result2.add(this.deserializeIrValueParameter(protos.get(i), i));
            } while (n <= n2);
        }
        return result2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean checkObjectLeak(org.jetbrains.kotlin.ir.types.IrType $this$checkObjectLeak) {
        boolean bl;
        if (!($this$checkObjectLeak instanceof org.jetbrains.kotlin.ir.types.IrSimpleType)) return false;
        IrClassifierSymbol irClassifierSymbol = ((org.jetbrains.kotlin.ir.types.IrSimpleType)$this$checkObjectLeak).getClassifier();
        boolean bl2 = false;
        boolean bl3 = false;
        IrClassifierSymbol it = irClassifierSymbol;
        boolean bl4 = false;
        if (!IrSymbolKt.isPublicApi(it) && !(it instanceof IrTypeParameterSymbol)) {
            return true;
        }
        boolean bl5 = false;
        if (bl5) return true;
        Iterable $this$any$iv = ((org.jetbrains.kotlin.ir.types.IrSimpleType)$this$checkObjectLeak).getArguments();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            IrTypeArgument it2 = (IrTypeArgument)element$iv;
            boolean bl6 = false;
            org.jetbrains.kotlin.ir.types.IrType irType = IrTypesKt.getTypeOrNull(it2);
            if (irType == null) {
                bl = false;
                continue;
            }
            if (this.checkObjectLeak(irType)) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T extends org.jetbrains.kotlin.ir.declarations.IrFunction> void withBodyGuard(T $this$withBodyGuard, Function1<? super T, Unit> block) {
        boolean oldBodiesPolicy = this.deserializeBodies;
        try {
            this.deserializeBodies = oldBodiesPolicy || IrDeclarationDeserializer.withBodyGuard$checkInlineBody(this, $this$withBodyGuard) || this.checkObjectLeak($this$withBodyGuard.getReturnType());
            block.invoke($this$withBodyGuard);
        }
        finally {
            this.deserializeBodies = oldBodiesPolicy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void withInitializerGuard(org.jetbrains.kotlin.ir.declarations.IrField $this$withInitializerGuard, Function1<? super org.jetbrains.kotlin.ir.declarations.IrField, Unit> f) {
        boolean oldBodiesPolicy = this.deserializeBodies;
        try {
            this.deserializeBodies = oldBodiesPolicy || this.checkObjectLeak($this$withInitializerGuard.getType());
            f.invoke((Object)$this$withInitializerGuard);
        }
        finally {
            this.deserializeBodies = oldBodiesPolicy;
        }
    }

    private final CodedInputStream readBody(int index2) {
        return BasicIrModuleDeserializerKt.getCodedInputStream(this.fileReader.body(index2));
    }

    private final IrStatement loadStatementBodyProto(int index2) {
        IrStatement irStatement = IrStatement.parseFrom(this.readBody(index2), ExtensionRegistryLite.newInstance());
        Intrinsics.checkNotNullExpressionValue((Object)irStatement, (String)"parseFrom(readBody(index\u2026gistryLite.newInstance())");
        return irStatement;
    }

    private final IrExpression loadExpressionBodyProto(int index2) {
        IrExpression irExpression = IrExpression.parseFrom(this.readBody(index2), ExtensionRegistryLite.newInstance());
        Intrinsics.checkNotNullExpressionValue((Object)irExpression, (String)"parseFrom(readBody(index\u2026gistryLite.newInstance())");
        return irExpression;
    }

    @NotNull
    public final IrExpressionBody deserializeExpressionBody(int index2) {
        org.jetbrains.kotlin.ir.expressions.IrExpression irExpression;
        if (this.deserializeBodies) {
            IrExpression bodyData = this.loadExpressionBodyProto(index2);
            irExpression = this.bodyDeserializer.deserializeExpression(bodyData);
        } else {
            IrErrorTypeImpl errorType = new IrErrorTypeImpl(null, CollectionsKt.emptyList(), Variance.INVARIANT);
            irExpression = new IrErrorExpressionImpl(-1, -1, errorType, "Expression body is not deserialized yet");
        }
        return this.irFactory.createExpressionBody(irExpression);
    }

    @NotNull
    public final IrElement deserializeStatementBody(int index2) {
        IrElement irElement;
        if (this.deserializeBodies) {
            IrStatement bodyData = this.loadStatementBodyProto(index2);
            irElement = this.bodyDeserializer.deserializeStatement$ir_serialization_common(bodyData);
        } else {
            IrErrorTypeImpl errorType = new IrErrorTypeImpl(null, CollectionsKt.emptyList(), Variance.INVARIANT);
            irElement = this.irFactory.createBlockBody(-1, -1, CollectionsKt.listOf((Object)new IrErrorExpressionImpl(-1, -1, errorType, "Statement body is not deserialized yet")));
        }
        return irElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final <T extends org.jetbrains.kotlin.ir.declarations.IrFunction> T withDeserializedIrFunctionBase(IrFunctionBase proto, Function6<? super IrFunctionSymbol, ? super IdSignature, ? super Integer, ? super Integer, ? super IrDeclarationOrigin, ? super Long, ? extends T> block) {
        Object object;
        void this_$iv;
        boolean $i$f$withDeserializedIrFunctionBase = false;
        IrDeclarationDeserializer irDeclarationDeserializer = this;
        IrDeclarationBase irDeclarationBase = proto.getBase();
        Intrinsics.checkNotNullExpressionValue((Object)irDeclarationBase, (String)"proto.base");
        IrDeclarationBase proto$iv = irDeclarationBase;
        boolean $i$f$withDeserializedIrDeclarationBase = false;
        Pair<IrSymbol, IdSignature> pair = this_$iv.getSymbolDeserializer().deserializeIrSymbolToDeclare(proto$iv.getSymbol());
        IrSymbol s$iv = (IrSymbol)pair.component1();
        IdSignature uid$iv = (IdSignature)pair.component2();
        long coordinates$iv = BinaryCoordinates.Companion.decode-ViYoqTc(proto$iv.getCoordinates());
        try {
            void this_$iv2;
            void fcode;
            void origin;
            void endOffset;
            void startOffset;
            void idSig;
            ((IrDeclarationDeserializer)this_$iv).recordDelegatedSymbol(s$iv);
            long l = proto$iv.getFlags();
            IrDeclarationOrigin irDeclarationOrigin = this_$iv.deserializeIrDeclarationOrigin(proto$iv.getOriginName());
            int n = BinaryCoordinates.getEndOffset-impl(coordinates$iv);
            int n2 = BinaryCoordinates.getStartOffset-impl(coordinates$iv);
            object = uid$iv;
            IrSymbol symbol2 = s$iv;
            boolean bl = false;
            SymbolTable $this$withScope$iv = this.symbolTable;
            boolean $i$f$withScope = false;
            $this$withScope$iv.enterScope(symbol2);
            SymbolTable $this$withDeserializedIrFunctionBase_u24lambda_u2d26_u24lambda_u2d25 = $this$withScope$iv;
            boolean bl2 = false;
            IrDeclarationDeserializer irDeclarationDeserializer2 = this;
            IrDeclarationParent $this$usingParent$iv = (IrDeclarationParent)block.invoke((Object)((IrFunctionSymbol)symbol2), (Object)idSig, (Object)((int)startOffset), (Object)((int)endOffset), (Object)origin, (Object)((long)fcode));
            boolean $i$f$usingParent = false;
            IrDeclarationParent irDeclarationParent = $this$usingParent$iv;
            boolean bl3 = false;
            boolean bl4 = false;
            IrDeclarationParent $this$usingParent_u24lambda_u2d6$iv = irDeclarationParent;
            boolean bl5 = false;
            IrDeclarationParent oldParent$iv = ((IrDeclarationDeserializer)this_$iv2).currentParent;
            ((IrDeclarationDeserializer)this_$iv2).currentParent = $this$usingParent_u24lambda_u2d6$iv;
            try {
                org.jetbrains.kotlin.ir.declarations.IrFunction $this$withDeserializedIrFunctionBase_u24lambda_u2d26_u24lambda_u2d25_u24lambda_u2d24 = (org.jetbrains.kotlin.ir.declarations.IrFunction)$this$usingParent_u24lambda_u2d6$iv;
                boolean bl6 = false;
                if (!this.skipMutableState) {
                    List<IrTypeParameter> list2 = proto.getTypeParameterList();
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"proto.typeParameterList");
                    $this$withDeserializedIrFunctionBase_u24lambda_u2d26_u24lambda_u2d25_u24lambda_u2d24.setTypeParameters(this.deserializeTypeParameters(list2, false));
                    long nameType = BinaryNameAndType.Companion.decode-WXC2TjU(proto.getNameType());
                    $this$withDeserializedIrFunctionBase_u24lambda_u2d26_u24lambda_u2d25_u24lambda_u2d24.setReturnType(this.deserializeIrType(BinaryNameAndType.getTypeIndex-impl(nameType)));
                    this.withBodyGuard($this$withDeserializedIrFunctionBase_u24lambda_u2d26_u24lambda_u2d25_u24lambda_u2d24, new Function1<T, Unit>(this, proto){
                        final /* synthetic */ IrDeclarationDeserializer this$0;
                        final /* synthetic */ IrFunctionBase $proto;
                        {
                            this.this$0 = $receiver;
                            this.$proto = $proto;
                            super(1);
                        }

                        public final void invoke(@NotNull T $this$withBodyGuard) {
                            Intrinsics.checkNotNullParameter($this$withBodyGuard, (String)"$this$withBodyGuard");
                            Object object = this.$proto.getValueParameterList();
                            Intrinsics.checkNotNullExpressionValue(object, (String)"proto.valueParameterList");
                            ((org.jetbrains.kotlin.ir.declarations.IrFunction)$this$withBodyGuard).setValueParameters(IrDeclarationDeserializer.access$deserializeValueParameters(this.this$0, object));
                            if (this.$proto.hasDispatchReceiver()) {
                                object = this.$proto.getDispatchReceiver();
                                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"proto.dispatchReceiver");
                                ((org.jetbrains.kotlin.ir.declarations.IrFunction)$this$withBodyGuard).setDispatchReceiverParameter(IrDeclarationDeserializer.access$deserializeIrValueParameter(this.this$0, (IrValueParameter)object, -1));
                            }
                            if (this.$proto.hasExtensionReceiver()) {
                                object = this.$proto.getExtensionReceiver();
                                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"proto.extensionReceiver");
                                ((org.jetbrains.kotlin.ir.declarations.IrFunction)$this$withBodyGuard).setExtensionReceiverParameter(IrDeclarationDeserializer.access$deserializeIrValueParameter(this.this$0, (IrValueParameter)object, -1));
                            }
                            if (this.$proto.hasBody()) {
                                ((org.jetbrains.kotlin.ir.declarations.IrFunction)$this$withBodyGuard).setBody((IrBody)this.this$0.deserializeStatementBody(this.$proto.getBody()));
                            }
                        }
                    });
                }
            }
            finally {
                InlineMarker.finallyStart((int)1);
                ((IrDeclarationDeserializer)this_$iv2).currentParent = oldParent$iv;
                InlineMarker.finallyEnd((int)1);
            }
            org.jetbrains.kotlin.ir.declarations.IrFunction result$iv = (org.jetbrains.kotlin.ir.declarations.IrFunction)irDeclarationParent;
            $this$withScope$iv.leaveScope(symbol2);
            org.jetbrains.kotlin.ir.declarations.IrDeclaration result$iv2 = result$iv;
            if (!((IrDeclarationDeserializer)this_$iv).allowRedeclaration || result$iv2.getAnnotations().isEmpty()) {
                object = result$iv2;
                Collection collection = object.getAnnotations();
                List<IrConstructorCall> list3 = proto$iv.getAnnotationList();
                Intrinsics.checkNotNullExpressionValue(list3, (String)"proto.annotationList");
                object.setAnnotations(CollectionsKt.plus((Collection)collection, (Iterable)this_$iv.deserializeAnnotations$ir_serialization_common(list3)));
            }
            if (!((IrDeclarationDeserializer)this_$iv).skipMutableState) {
                result$iv2.setParent(((IrDeclarationDeserializer)this_$iv).currentParent);
            }
            object = result$iv2;
        }
        finally {
            InlineMarker.finallyStart((int)1);
            ((IrDeclarationDeserializer)this_$iv).eraseDelegatedSymbol(s$iv);
            InlineMarker.finallyEnd((int)1);
        }
        return (T)((org.jetbrains.kotlin.ir.declarations.IrFunction)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final IrSimpleFunction deserializeIrFunction$ir_serialization_common(@NotNull IrFunction proto) {
        Object object;
        void this_$iv$iv;
        void proto$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        IrDeclarationDeserializer irDeclarationDeserializer = this;
        IrFunctionBase irFunctionBase = proto.getBase();
        Intrinsics.checkNotNullExpressionValue((Object)irFunctionBase, (String)"proto.base");
        boolean $i$f$withDeserializedIrFunctionBase = false;
        void var5_5 = this_$iv;
        IrDeclarationBase irDeclarationBase = proto$iv.getBase();
        Intrinsics.checkNotNullExpressionValue((Object)irDeclarationBase, (String)"proto.base");
        IrDeclarationBase proto$iv$iv = irDeclarationBase;
        boolean $i$f$withDeserializedIrDeclarationBase = false;
        Pair<IrSymbol, IdSignature> pair = this_$iv$iv.getSymbolDeserializer().deserializeIrSymbolToDeclare(proto$iv$iv.getSymbol());
        IrSymbol s$iv$iv = (IrSymbol)pair.component1();
        IdSignature uid$iv$iv = (IdSignature)pair.component2();
        long coordinates$iv$iv = BinaryCoordinates.Companion.decode-ViYoqTc(proto$iv$iv.getCoordinates());
        try {
            void this_$iv$iv2;
            Collection<IrSimpleFunctionSymbol> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void origin;
            void endOffset;
            void startOffset;
            void idSig;
            void fcode;
            void idSig$iv;
            void startOffset$iv;
            void endOffset$iv;
            void origin$iv;
            void fcode$iv;
            ((IrDeclarationDeserializer)this_$iv$iv).recordDelegatedSymbol(s$iv$iv);
            long l = proto$iv$iv.getFlags();
            IrDeclarationOrigin irDeclarationOrigin = this_$iv$iv.deserializeIrDeclarationOrigin(proto$iv$iv.getOriginName());
            int n = BinaryCoordinates.getEndOffset-impl(coordinates$iv$iv);
            int n2 = BinaryCoordinates.getStartOffset-impl(coordinates$iv$iv);
            object = uid$iv$iv;
            IrSymbol symbol$iv = s$iv$iv;
            boolean bl = false;
            SymbolTable $this$withScope$iv$iv = ((IrDeclarationDeserializer)this_$iv).symbolTable;
            boolean $i$f$withScope = false;
            $this$withScope$iv$iv.enterScope(symbol$iv);
            SymbolTable $this$withDeserializedIrFunctionBase_u24lambda_u2d26_u24lambda_u2d25$iv = $this$withScope$iv$iv;
            boolean bl2 = false;
            void var25_25 = this_$iv;
            void var26_26 = fcode$iv;
            void var28_27 = origin$iv;
            void var29_28 = endOffset$iv;
            void var30_29 = startOffset$iv;
            void var31_31 = idSig$iv;
            IrFunctionSymbol symbol2 = (IrFunctionSymbol)symbol$iv;
            boolean bl3 = false;
            long flags = FunctionFlags.Companion.decode-UIJRpeM((long)fcode);
            if (this.allowRedeclaration && symbol2.isBound()) {
                IrSimpleFunction irSimpleFunction = (IrSimpleFunction)symbol2.getOwner();
                return irSimpleFunction;
            }
            IrSimpleFunction irSimpleFunction = this.symbolTable.declareSimpleFunction((IdSignature)idSig, (Function0<? extends IrSimpleFunctionSymbol>)((Function0)new Function0<IrSimpleFunctionSymbol>(symbol2){
                final /* synthetic */ IrFunctionSymbol $symbol;
                {
                    this.$symbol = $symbol;
                    super(0);
                }

                @NotNull
                public final IrSimpleFunctionSymbol invoke() {
                    return (IrSimpleFunctionSymbol)this.$symbol;
                }
            }), (Function1<? super IrSimpleFunctionSymbol, ? extends IrSimpleFunction>)((Function1)new Function1<IrSimpleFunctionSymbol, IrSimpleFunction>(proto, this, (int)startOffset, (int)endOffset, (IrDeclarationOrigin)origin, flags){
                final /* synthetic */ IrFunction $proto;
                final /* synthetic */ IrDeclarationDeserializer this$0;
                final /* synthetic */ int $startOffset;
                final /* synthetic */ int $endOffset;
                final /* synthetic */ IrDeclarationOrigin $origin;
                final /* synthetic */ long $flags;
                {
                    this.$proto = $proto;
                    this.this$0 = $receiver;
                    this.$startOffset = $startOffset;
                    this.$endOffset = $endOffset;
                    this.$origin = $origin;
                    this.$flags = $flags;
                    super(1);
                }

                @NotNull
                public final IrSimpleFunction invoke(@NotNull IrSimpleFunctionSymbol it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    long nameType = BinaryNameAndType.Companion.decode-WXC2TjU(this.$proto.getBase().getNameType());
                    return IrFactory.DefaultImpls.createFunction$default(this.this$0.getIrFactory(), this.$startOffset, this.$endOffset, this.$origin, it, IrDeclarationDeserializer.access$deserializeName(this.this$0, BinaryNameAndType.getNameIndex-impl(nameType)), FunctionFlags.getVisibility-impl(this.$flags), FunctionFlags.getModality-impl(this.$flags), IrUninitializedType.INSTANCE, FunctionFlags.isInline-impl(this.$flags), FunctionFlags.isExternal-impl(this.$flags) || IrDeclarationDeserializer.access$isEffectivelyExternal$p(this.this$0), FunctionFlags.isTailrec-impl(this.$flags), FunctionFlags.isSuspend-impl(this.$flags), FunctionFlags.isOperator-impl(this.$flags), FunctionFlags.isInfix-impl(this.$flags), FunctionFlags.isExpect-impl(this.$flags), FunctionFlags.isFakeOverride-impl(this.$flags), null, 65536, null);
                }
            }));
            boolean bl4 = false;
            boolean bl5 = false;
            IrSimpleFunction $this$deserializeIrFunction_u24lambda_u2d29_u24lambda_u2d28 = irSimpleFunction;
            boolean bl6 = false;
            Iterable<Long> iterable = proto.getOverriddenList();
            Intrinsics.checkNotNullExpressionValue(iterable, (String)"proto.overriddenList");
            iterable = iterable;
            IrSimpleFunction irSimpleFunction2 = $this$deserializeIrFunction_u24lambda_u2d29_u24lambda_u2d28;
            boolean $i$f$map = false;
            void var44_45 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Long l2 = (Long)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl7 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                IrSimpleFunctionSymbol irSimpleFunctionSymbol = (IrSimpleFunctionSymbol)this.deserializeIrSymbolAndRemap$ir_serialization_common(it.longValue());
                collection.add(irSimpleFunctionSymbol);
            }
            collection = (List)destination$iv$iv;
            irSimpleFunction2.setOverriddenSymbols(collection);
            IrDeclarationParent $this$usingParent$iv$iv = irSimpleFunction;
            boolean $i$f$usingParent = false;
            IrDeclarationParent irDeclarationParent = $this$usingParent$iv$iv;
            boolean bl8 = false;
            boolean bl9 = false;
            IrDeclarationParent $this$usingParent_u24lambda_u2d6$iv$iv = irDeclarationParent;
            boolean bl10 = false;
            IrDeclarationParent oldParent$iv$iv = ((IrDeclarationDeserializer)this_$iv$iv2).currentParent;
            ((IrDeclarationDeserializer)this_$iv$iv2).currentParent = $this$usingParent_u24lambda_u2d6$iv$iv;
            try {
                org.jetbrains.kotlin.ir.declarations.IrFunction $this$withDeserializedIrFunctionBase_u24lambda_u2d26_u24lambda_u2d25_u24lambda_u2d24$iv = (org.jetbrains.kotlin.ir.declarations.IrFunction)$this$usingParent_u24lambda_u2d6$iv$iv;
                boolean bl11 = false;
                if (!((IrDeclarationDeserializer)this_$iv).skipMutableState) {
                    List<IrTypeParameter> list2 = proto$iv.getTypeParameterList();
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"proto.typeParameterList");
                    $this$withDeserializedIrFunctionBase_u24lambda_u2d26_u24lambda_u2d25_u24lambda_u2d24$iv.setTypeParameters(((IrDeclarationDeserializer)this_$iv).deserializeTypeParameters(list2, false));
                    long nameType$iv = BinaryNameAndType.Companion.decode-WXC2TjU(proto$iv.getNameType());
                    $this$withDeserializedIrFunctionBase_u24lambda_u2d26_u24lambda_u2d25_u24lambda_u2d24$iv.setReturnType(this_$iv.deserializeIrType(BinaryNameAndType.getTypeIndex-impl(nameType$iv)));
                    ((IrDeclarationDeserializer)this_$iv).withBodyGuard($this$withDeserializedIrFunctionBase_u24lambda_u2d26_u24lambda_u2d25_u24lambda_u2d24$iv, new /* invalid duplicate definition of identical inner class */);
                }
            }
            finally {
                ((IrDeclarationDeserializer)this_$iv$iv2).currentParent = oldParent$iv$iv;
            }
            org.jetbrains.kotlin.ir.declarations.IrFunction result$iv$iv = (org.jetbrains.kotlin.ir.declarations.IrFunction)irDeclarationParent;
            $this$withScope$iv$iv.leaveScope(symbol$iv);
            org.jetbrains.kotlin.ir.declarations.IrDeclaration result$iv$iv2 = result$iv$iv;
            if (!((IrDeclarationDeserializer)this_$iv$iv).allowRedeclaration || result$iv$iv2.getAnnotations().isEmpty()) {
                object = result$iv$iv2;
                Collection collection2 = object.getAnnotations();
                List<IrConstructorCall> list3 = proto$iv$iv.getAnnotationList();
                Intrinsics.checkNotNullExpressionValue(list3, (String)"proto.annotationList");
                object.setAnnotations(CollectionsKt.plus((Collection)collection2, (Iterable)this_$iv$iv.deserializeAnnotations$ir_serialization_common(list3)));
            }
            if (!((IrDeclarationDeserializer)this_$iv$iv).skipMutableState) {
                result$iv$iv2.setParent(((IrDeclarationDeserializer)this_$iv$iv).currentParent);
            }
            object = result$iv$iv2;
        }
        finally {
            ((IrDeclarationDeserializer)this_$iv$iv).eraseDelegatedSymbol(s$iv$iv);
        }
        return (IrSimpleFunction)((org.jetbrains.kotlin.ir.declarations.IrFunction)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final org.jetbrains.kotlin.ir.declarations.IrVariable deserializeIrVariable(@NotNull IrVariable proto) {
        Object object;
        void proto$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        IrDeclarationDeserializer irDeclarationDeserializer = this;
        IrDeclarationBase irDeclarationBase = proto.getBase();
        Intrinsics.checkNotNullExpressionValue((Object)irDeclarationBase, (String)"proto.base");
        boolean $i$f$withDeserializedIrDeclarationBase = false;
        Pair<IrSymbol, IdSignature> pair = this_$iv.getSymbolDeserializer().deserializeIrSymbolToDeclare(proto$iv.getSymbol());
        IrSymbol s$iv = (IrSymbol)pair.component1();
        IdSignature uid$iv = (IdSignature)pair.component2();
        long coordinates$iv = BinaryCoordinates.Companion.decode-ViYoqTc(proto$iv.getCoordinates());
        try {
            void origin;
            void endOffset;
            void startOffset;
            void fcode;
            ((IrDeclarationDeserializer)this_$iv).recordDelegatedSymbol(s$iv);
            long l = proto$iv.getFlags();
            IrDeclarationOrigin irDeclarationOrigin = this_$iv.deserializeIrDeclarationOrigin(proto$iv.getOriginName());
            int n = BinaryCoordinates.getEndOffset-impl(coordinates$iv);
            int n2 = BinaryCoordinates.getStartOffset-impl(coordinates$iv);
            object = uid$iv;
            IrSymbol symbol2 = s$iv;
            boolean bl = false;
            long flags = LocalVariableFlags.Companion.decode-QnIyQoc((long)fcode);
            long nameType = BinaryNameAndType.Companion.decode-WXC2TjU(proto.getNameType());
            org.jetbrains.kotlin.ir.declarations.IrVariable irVariable2 = this.allowRedeclaration && symbol2.isBound() ? (org.jetbrains.kotlin.ir.declarations.IrVariable)symbol2.getOwner() : (org.jetbrains.kotlin.ir.declarations.IrVariable)new IrVariableImpl((int)startOffset, (int)endOffset, (IrDeclarationOrigin)origin, (IrVariableSymbol)symbol2, this.deserializeName(BinaryNameAndType.getNameIndex-impl(nameType)), this.deserializeIrType(BinaryNameAndType.getTypeIndex-impl(nameType)), LocalVariableFlags.isVar-impl(flags), LocalVariableFlags.isConst-impl(flags), LocalVariableFlags.isLateinit-impl(flags));
            boolean bl2 = false;
            boolean bl3 = false;
            org.jetbrains.kotlin.ir.declarations.IrVariable $this$deserializeIrVariable_u24lambda_u2d31_u24lambda_u2d30 = irVariable2;
            boolean bl4 = false;
            if (proto.hasInitializer()) {
                IrBodyDeserializer irBodyDeserializer = this.getBodyDeserializer();
                IrExpression irExpression = proto.getInitializer();
                Intrinsics.checkNotNullExpressionValue((Object)irExpression, (String)"proto.initializer");
                $this$deserializeIrVariable_u24lambda_u2d31_u24lambda_u2d30.setInitializer(irBodyDeserializer.deserializeExpression(irExpression));
            }
            org.jetbrains.kotlin.ir.declarations.IrDeclaration result$iv = irVariable2;
            if (!((IrDeclarationDeserializer)this_$iv).allowRedeclaration || result$iv.getAnnotations().isEmpty()) {
                object = result$iv;
                Collection collection = object.getAnnotations();
                List<IrConstructorCall> list2 = proto$iv.getAnnotationList();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"proto.annotationList");
                object.setAnnotations(CollectionsKt.plus((Collection)collection, (Iterable)this_$iv.deserializeAnnotations$ir_serialization_common(list2)));
            }
            if (!((IrDeclarationDeserializer)this_$iv).skipMutableState) {
                result$iv.setParent(((IrDeclarationDeserializer)this_$iv).currentParent);
            }
            object = result$iv;
        }
        finally {
            ((IrDeclarationDeserializer)this_$iv).eraseDelegatedSymbol(s$iv);
        }
        return (org.jetbrains.kotlin.ir.declarations.IrVariable)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final org.jetbrains.kotlin.ir.declarations.IrEnumEntry deserializeIrEnumEntry(IrEnumEntry proto) {
        Object object;
        void proto$iv;
        void this_$iv;
        IrDeclarationDeserializer irDeclarationDeserializer = this;
        IrDeclarationBase irDeclarationBase = proto.getBase();
        Intrinsics.checkNotNullExpressionValue((Object)irDeclarationBase, (String)"proto.base");
        boolean $i$f$withDeserializedIrDeclarationBase = false;
        Pair<IrSymbol, IdSignature> pair = this_$iv.getSymbolDeserializer().deserializeIrSymbolToDeclare(proto$iv.getSymbol());
        IrSymbol s$iv = (IrSymbol)pair.component1();
        IdSignature uid$iv = (IdSignature)pair.component2();
        long coordinates$iv = BinaryCoordinates.Companion.decode-ViYoqTc(proto$iv.getCoordinates());
        try {
            void origin;
            void endOffset;
            void startOffset;
            void uniqId;
            ((IrDeclarationDeserializer)this_$iv).recordDelegatedSymbol(s$iv);
            long l = proto$iv.getFlags();
            IrDeclarationOrigin irDeclarationOrigin = this_$iv.deserializeIrDeclarationOrigin(proto$iv.getOriginName());
            int n = BinaryCoordinates.getEndOffset-impl(coordinates$iv);
            int n2 = BinaryCoordinates.getStartOffset-impl(coordinates$iv);
            object = uid$iv;
            IrSymbol symbol2 = s$iv;
            boolean bl = false;
            org.jetbrains.kotlin.ir.declarations.IrEnumEntry irEnumEntry = this.symbolTable.declareEnumEntry((IdSignature)uniqId, (Function0<? extends IrEnumEntrySymbol>)((Function0)new Function0<IrEnumEntrySymbol>(symbol2){
                final /* synthetic */ IrSymbol $symbol;
                {
                    this.$symbol = $symbol;
                    super(0);
                }

                @NotNull
                public final IrEnumEntrySymbol invoke() {
                    return (IrEnumEntrySymbol)this.$symbol;
                }
            }), (Function1<? super IrEnumEntrySymbol, ? extends org.jetbrains.kotlin.ir.declarations.IrEnumEntry>)((Function1)new Function1<IrEnumEntrySymbol, org.jetbrains.kotlin.ir.declarations.IrEnumEntry>(this, (int)startOffset, (int)endOffset, (IrDeclarationOrigin)origin, proto){
                final /* synthetic */ IrDeclarationDeserializer this$0;
                final /* synthetic */ int $startOffset;
                final /* synthetic */ int $endOffset;
                final /* synthetic */ IrDeclarationOrigin $origin;
                final /* synthetic */ IrEnumEntry $proto;
                {
                    this.this$0 = $receiver;
                    this.$startOffset = $startOffset;
                    this.$endOffset = $endOffset;
                    this.$origin = $origin;
                    this.$proto = $proto;
                    super(1);
                }

                @NotNull
                public final org.jetbrains.kotlin.ir.declarations.IrEnumEntry invoke(@NotNull IrEnumEntrySymbol it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return this.this$0.getIrFactory().createEnumEntry(this.$startOffset, this.$endOffset, this.$origin, it, IrDeclarationDeserializer.access$deserializeName(this.this$0, this.$proto.getName()));
                }
            }));
            boolean bl2 = false;
            boolean bl3 = false;
            org.jetbrains.kotlin.ir.declarations.IrEnumEntry $this$deserializeIrEnumEntry_u24lambda_u2d33_u24lambda_u2d32 = irEnumEntry;
            boolean bl4 = false;
            if (!this.skipMutableState) {
                if (proto.hasCorrespondingClass()) {
                    IrClass irClass2 = proto.getCorrespondingClass();
                    Intrinsics.checkNotNullExpressionValue((Object)irClass2, (String)"proto.correspondingClass");
                    $this$deserializeIrEnumEntry_u24lambda_u2d33_u24lambda_u2d32.setCorrespondingClass(this.deserializeIrClass(irClass2));
                }
                if (proto.hasInitializer()) {
                    $this$deserializeIrEnumEntry_u24lambda_u2d33_u24lambda_u2d32.setInitializerExpression(this.deserializeExpressionBody(proto.getInitializer()));
                }
            }
            org.jetbrains.kotlin.ir.declarations.IrDeclaration result$iv = irEnumEntry;
            if (!((IrDeclarationDeserializer)this_$iv).allowRedeclaration || result$iv.getAnnotations().isEmpty()) {
                object = result$iv;
                Collection collection = object.getAnnotations();
                List<IrConstructorCall> list2 = proto$iv.getAnnotationList();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"proto.annotationList");
                object.setAnnotations(CollectionsKt.plus((Collection)collection, (Iterable)this_$iv.deserializeAnnotations$ir_serialization_common(list2)));
            }
            if (!((IrDeclarationDeserializer)this_$iv).skipMutableState) {
                result$iv.setParent(((IrDeclarationDeserializer)this_$iv).currentParent);
            }
            object = result$iv;
        }
        finally {
            ((IrDeclarationDeserializer)this_$iv).eraseDelegatedSymbol(s$iv);
        }
        return (org.jetbrains.kotlin.ir.declarations.IrEnumEntry)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final IrAnonymousInitializer deserializeIrAnonymousInit(IrAnonymousInit proto) {
        Object object;
        void proto$iv;
        void this_$iv;
        IrDeclarationDeserializer irDeclarationDeserializer = this;
        IrDeclarationBase irDeclarationBase = proto.getBase();
        Intrinsics.checkNotNullExpressionValue((Object)irDeclarationBase, (String)"proto.base");
        boolean $i$f$withDeserializedIrDeclarationBase = false;
        Pair<IrSymbol, IdSignature> pair = this_$iv.getSymbolDeserializer().deserializeIrSymbolToDeclare(proto$iv.getSymbol());
        IrSymbol s$iv = (IrSymbol)pair.component1();
        IdSignature uid$iv = (IdSignature)pair.component2();
        long coordinates$iv = BinaryCoordinates.Companion.decode-ViYoqTc(proto$iv.getCoordinates());
        try {
            void origin;
            void endOffset;
            void startOffset;
            ((IrDeclarationDeserializer)this_$iv).recordDelegatedSymbol(s$iv);
            long l = proto$iv.getFlags();
            IrDeclarationOrigin irDeclarationOrigin = this_$iv.deserializeIrDeclarationOrigin(proto$iv.getOriginName());
            int n = BinaryCoordinates.getEndOffset-impl(coordinates$iv);
            int n2 = BinaryCoordinates.getStartOffset-impl(coordinates$iv);
            object = uid$iv;
            IrSymbol symbol2 = s$iv;
            boolean bl = false;
            IrAnonymousInitializer irAnonymousInitializer = IrFactory.DefaultImpls.createAnonymousInitializer$default(this.getIrFactory(), (int)startOffset, (int)endOffset, (IrDeclarationOrigin)origin, (IrAnonymousInitializerSymbol)symbol2, false, 16, null);
            boolean bl2 = false;
            boolean bl3 = false;
            IrAnonymousInitializer $this$deserializeIrAnonymousInit_u24lambda_u2d35_u24lambda_u2d34 = irAnonymousInitializer;
            boolean bl4 = false;
            $this$deserializeIrAnonymousInit_u24lambda_u2d35_u24lambda_u2d34.setBody((IrBlockBody)this.deserializeStatementBody(proto.getBody()));
            org.jetbrains.kotlin.ir.declarations.IrDeclaration result$iv = irAnonymousInitializer;
            if (!((IrDeclarationDeserializer)this_$iv).allowRedeclaration || result$iv.getAnnotations().isEmpty()) {
                object = result$iv;
                Collection collection = object.getAnnotations();
                List<IrConstructorCall> list2 = proto$iv.getAnnotationList();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"proto.annotationList");
                object.setAnnotations(CollectionsKt.plus((Collection)collection, (Iterable)this_$iv.deserializeAnnotations$ir_serialization_common(list2)));
            }
            if (!((IrDeclarationDeserializer)this_$iv).skipMutableState) {
                result$iv.setParent(((IrDeclarationDeserializer)this_$iv).currentParent);
            }
            object = result$iv;
        }
        finally {
            ((IrDeclarationDeserializer)this_$iv).eraseDelegatedSymbol(s$iv);
        }
        return (IrAnonymousInitializer)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final org.jetbrains.kotlin.ir.declarations.IrConstructor deserializeIrConstructor(IrConstructor proto) {
        Object object;
        void this_$iv$iv;
        void proto$iv;
        void this_$iv;
        IrDeclarationDeserializer irDeclarationDeserializer = this;
        IrFunctionBase irFunctionBase = proto.getBase();
        Intrinsics.checkNotNullExpressionValue((Object)irFunctionBase, (String)"proto.base");
        boolean $i$f$withDeserializedIrFunctionBase = false;
        void var5_5 = this_$iv;
        IrDeclarationBase irDeclarationBase = proto$iv.getBase();
        Intrinsics.checkNotNullExpressionValue((Object)irDeclarationBase, (String)"proto.base");
        IrDeclarationBase proto$iv$iv = irDeclarationBase;
        boolean $i$f$withDeserializedIrDeclarationBase = false;
        Pair<IrSymbol, IdSignature> pair = this_$iv$iv.getSymbolDeserializer().deserializeIrSymbolToDeclare(proto$iv$iv.getSymbol());
        IrSymbol s$iv$iv = (IrSymbol)pair.component1();
        IdSignature uid$iv$iv = (IdSignature)pair.component2();
        long coordinates$iv$iv = BinaryCoordinates.Companion.decode-ViYoqTc(proto$iv$iv.getCoordinates());
        try {
            void this_$iv$iv2;
            void origin;
            void endOffset;
            void startOffset;
            void idSig;
            void fcode;
            void idSig$iv;
            void startOffset$iv;
            void endOffset$iv;
            void origin$iv;
            void fcode$iv;
            ((IrDeclarationDeserializer)this_$iv$iv).recordDelegatedSymbol(s$iv$iv);
            long l = proto$iv$iv.getFlags();
            IrDeclarationOrigin irDeclarationOrigin = this_$iv$iv.deserializeIrDeclarationOrigin(proto$iv$iv.getOriginName());
            int n = BinaryCoordinates.getEndOffset-impl(coordinates$iv$iv);
            int n2 = BinaryCoordinates.getStartOffset-impl(coordinates$iv$iv);
            object = uid$iv$iv;
            IrSymbol symbol$iv = s$iv$iv;
            boolean bl = false;
            SymbolTable $this$withScope$iv$iv = ((IrDeclarationDeserializer)this_$iv).symbolTable;
            boolean $i$f$withScope = false;
            $this$withScope$iv$iv.enterScope(symbol$iv);
            SymbolTable $this$withDeserializedIrFunctionBase_u24lambda_u2d26_u24lambda_u2d25$iv = $this$withScope$iv$iv;
            boolean bl2 = false;
            void var25_25 = this_$iv;
            void var26_26 = fcode$iv;
            void var28_27 = origin$iv;
            void var29_28 = endOffset$iv;
            void var30_29 = startOffset$iv;
            void var31_31 = idSig$iv;
            IrFunctionSymbol symbol2 = (IrFunctionSymbol)symbol$iv;
            boolean bl3 = false;
            boolean bl4 = symbol2 instanceof IrConstructorSymbol;
            boolean bl5 = false;
            boolean bl6 = false;
            bl6 = false;
            boolean bl7 = false;
            if (!bl4) {
                boolean bl8 = false;
                String string2 = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string2.toString());
            }
            long flags = FunctionFlags.Companion.decode-UIJRpeM((long)fcode);
            long nameType = BinaryNameAndType.Companion.decode-WXC2TjU(proto.getBase().getNameType());
            IrDeclarationParent $this$usingParent$iv$iv = this.symbolTable.declareConstructor((IdSignature)idSig, (Function0<? extends IrConstructorSymbol>)((Function0)new Function0<IrConstructorSymbol>(symbol2){
                final /* synthetic */ IrFunctionSymbol $symbol;
                {
                    this.$symbol = $symbol;
                    super(0);
                }

                @NotNull
                public final IrConstructorSymbol invoke() {
                    return (IrConstructorSymbol)this.$symbol;
                }
            }), (Function1<? super IrConstructorSymbol, ? extends org.jetbrains.kotlin.ir.declarations.IrConstructor>)((Function1)new Function1<IrConstructorSymbol, org.jetbrains.kotlin.ir.declarations.IrConstructor>(this, (int)startOffset, (int)endOffset, (IrDeclarationOrigin)origin, nameType, flags){
                final /* synthetic */ IrDeclarationDeserializer this$0;
                final /* synthetic */ int $startOffset;
                final /* synthetic */ int $endOffset;
                final /* synthetic */ IrDeclarationOrigin $origin;
                final /* synthetic */ long $nameType;
                final /* synthetic */ long $flags;
                {
                    this.this$0 = $receiver;
                    this.$startOffset = $startOffset;
                    this.$endOffset = $endOffset;
                    this.$origin = $origin;
                    this.$nameType = $nameType;
                    this.$flags = $flags;
                    super(1);
                }

                @NotNull
                public final org.jetbrains.kotlin.ir.declarations.IrConstructor invoke(@NotNull IrConstructorSymbol it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return IrFactory.DefaultImpls.createConstructor$default(this.this$0.getIrFactory(), this.$startOffset, this.$endOffset, this.$origin, it, IrDeclarationDeserializer.access$deserializeName(this.this$0, BinaryNameAndType.getNameIndex-impl(this.$nameType)), FunctionFlags.getVisibility-impl(this.$flags), IrUninitializedType.INSTANCE, FunctionFlags.isInline-impl(this.$flags), FunctionFlags.isExternal-impl(this.$flags) || IrDeclarationDeserializer.access$isEffectivelyExternal$p(this.this$0), FunctionFlags.isPrimary-impl(this.$flags), FunctionFlags.isExpect-impl(this.$flags), null, 2048, null);
                }
            }));
            boolean $i$f$usingParent = false;
            IrDeclarationParent irDeclarationParent = $this$usingParent$iv$iv;
            boolean bl9 = false;
            boolean bl10 = false;
            IrDeclarationParent $this$usingParent_u24lambda_u2d6$iv$iv = irDeclarationParent;
            boolean bl11 = false;
            IrDeclarationParent oldParent$iv$iv = ((IrDeclarationDeserializer)this_$iv$iv2).currentParent;
            ((IrDeclarationDeserializer)this_$iv$iv2).currentParent = $this$usingParent_u24lambda_u2d6$iv$iv;
            try {
                org.jetbrains.kotlin.ir.declarations.IrFunction $this$withDeserializedIrFunctionBase_u24lambda_u2d26_u24lambda_u2d25_u24lambda_u2d24$iv = (org.jetbrains.kotlin.ir.declarations.IrFunction)$this$usingParent_u24lambda_u2d6$iv$iv;
                boolean bl12 = false;
                if (!((IrDeclarationDeserializer)this_$iv).skipMutableState) {
                    List<IrTypeParameter> list2 = proto$iv.getTypeParameterList();
                    Intrinsics.checkNotNullExpressionValue(list2, (String)"proto.typeParameterList");
                    $this$withDeserializedIrFunctionBase_u24lambda_u2d26_u24lambda_u2d25_u24lambda_u2d24$iv.setTypeParameters(((IrDeclarationDeserializer)this_$iv).deserializeTypeParameters(list2, false));
                    long nameType$iv = BinaryNameAndType.Companion.decode-WXC2TjU(proto$iv.getNameType());
                    $this$withDeserializedIrFunctionBase_u24lambda_u2d26_u24lambda_u2d25_u24lambda_u2d24$iv.setReturnType(this_$iv.deserializeIrType(BinaryNameAndType.getTypeIndex-impl(nameType$iv)));
                    ((IrDeclarationDeserializer)this_$iv).withBodyGuard($this$withDeserializedIrFunctionBase_u24lambda_u2d26_u24lambda_u2d25_u24lambda_u2d24$iv, new /* invalid duplicate definition of identical inner class */);
                }
            }
            finally {
                ((IrDeclarationDeserializer)this_$iv$iv2).currentParent = oldParent$iv$iv;
            }
            org.jetbrains.kotlin.ir.declarations.IrFunction result$iv$iv = (org.jetbrains.kotlin.ir.declarations.IrFunction)irDeclarationParent;
            $this$withScope$iv$iv.leaveScope(symbol$iv);
            org.jetbrains.kotlin.ir.declarations.IrDeclaration result$iv$iv2 = result$iv$iv;
            if (!((IrDeclarationDeserializer)this_$iv$iv).allowRedeclaration || result$iv$iv2.getAnnotations().isEmpty()) {
                object = result$iv$iv2;
                Collection collection = object.getAnnotations();
                List<IrConstructorCall> list3 = proto$iv$iv.getAnnotationList();
                Intrinsics.checkNotNullExpressionValue(list3, (String)"proto.annotationList");
                object.setAnnotations(CollectionsKt.plus((Collection)collection, (Iterable)this_$iv$iv.deserializeAnnotations$ir_serialization_common(list3)));
            }
            if (!((IrDeclarationDeserializer)this_$iv$iv).skipMutableState) {
                result$iv$iv2.setParent(((IrDeclarationDeserializer)this_$iv$iv).currentParent);
            }
            object = result$iv$iv2;
        }
        finally {
            ((IrDeclarationDeserializer)this_$iv$iv).eraseDelegatedSymbol(s$iv$iv);
        }
        return (org.jetbrains.kotlin.ir.declarations.IrConstructor)((org.jetbrains.kotlin.ir.declarations.IrFunction)object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final org.jetbrains.kotlin.ir.declarations.IrField deserializeIrField(IrField proto) {
        Object object;
        void proto$iv;
        void this_$iv;
        IrDeclarationDeserializer irDeclarationDeserializer = this;
        IrDeclarationBase irDeclarationBase = proto.getBase();
        Intrinsics.checkNotNullExpressionValue((Object)irDeclarationBase, (String)"proto.base");
        boolean $i$f$withDeserializedIrDeclarationBase = false;
        Pair<IrSymbol, IdSignature> pair = this_$iv.getSymbolDeserializer().deserializeIrSymbolToDeclare(proto$iv.getSymbol());
        IrSymbol s$iv = (IrSymbol)pair.component1();
        IdSignature uid$iv = (IdSignature)pair.component2();
        long coordinates$iv = BinaryCoordinates.Companion.decode-ViYoqTc(proto$iv.getCoordinates());
        try {
            void this_$iv2;
            void origin;
            void endOffset;
            void startOffset;
            void uniqId;
            void fcode;
            ((IrDeclarationDeserializer)this_$iv).recordDelegatedSymbol(s$iv);
            long l = proto$iv.getFlags();
            IrDeclarationOrigin irDeclarationOrigin = this_$iv.deserializeIrDeclarationOrigin(proto$iv.getOriginName());
            int n = BinaryCoordinates.getEndOffset-impl(coordinates$iv);
            int n2 = BinaryCoordinates.getStartOffset-impl(coordinates$iv);
            object = uid$iv;
            IrSymbol symbol2 = s$iv;
            boolean bl = false;
            boolean bl2 = symbol2 instanceof IrFieldSymbol;
            boolean bl3 = false;
            boolean bl4 = false;
            bl4 = false;
            boolean bl5 = false;
            if (!bl2) {
                boolean bl6 = false;
                String string2 = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string2.toString());
            }
            long nameType = BinaryNameAndType.Companion.decode-WXC2TjU(proto.getNameType());
            org.jetbrains.kotlin.ir.types.IrType type2 = this.deserializeIrType(BinaryNameAndType.getTypeIndex-impl(nameType));
            long flags = FieldFlags.Companion.decode-TfoGUTA((long)fcode);
            org.jetbrains.kotlin.ir.declarations.IrField field2 = this.allowRedeclaration && symbol2.isBound() ? (org.jetbrains.kotlin.ir.declarations.IrField)((IrFieldSymbol)symbol2).getOwner() : this.symbolTable.declareField((IdSignature)uniqId, (Function0<? extends IrFieldSymbol>)((Function0)new Function0<IrFieldSymbol>(symbol2){
                final /* synthetic */ IrSymbol $symbol;
                {
                    this.$symbol = $symbol;
                    super(0);
                }

                @NotNull
                public final IrFieldSymbol invoke() {
                    return (IrFieldSymbol)this.$symbol;
                }
            }), (Function1<? super IrFieldSymbol, ? extends org.jetbrains.kotlin.ir.declarations.IrField>)((Function1)new Function1<IrFieldSymbol, org.jetbrains.kotlin.ir.declarations.IrField>(this, (int)startOffset, (int)endOffset, (IrDeclarationOrigin)origin, nameType, type2, flags){
                final /* synthetic */ IrDeclarationDeserializer this$0;
                final /* synthetic */ int $startOffset;
                final /* synthetic */ int $endOffset;
                final /* synthetic */ IrDeclarationOrigin $origin;
                final /* synthetic */ long $nameType;
                final /* synthetic */ org.jetbrains.kotlin.ir.types.IrType $type;
                final /* synthetic */ long $flags;
                {
                    this.this$0 = $receiver;
                    this.$startOffset = $startOffset;
                    this.$endOffset = $endOffset;
                    this.$origin = $origin;
                    this.$nameType = $nameType;
                    this.$type = $type;
                    this.$flags = $flags;
                    super(1);
                }

                @NotNull
                public final org.jetbrains.kotlin.ir.declarations.IrField invoke(@NotNull IrFieldSymbol it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return this.this$0.getIrFactory().createField(this.$startOffset, this.$endOffset, this.$origin, it, IrDeclarationDeserializer.access$deserializeName(this.this$0, BinaryNameAndType.getNameIndex-impl(this.$nameType)), this.$type, FieldFlags.getVisibility-impl(this.$flags), FieldFlags.isFinal-impl(this.$flags), FieldFlags.isExternal-impl(this.$flags) || IrDeclarationDeserializer.access$isEffectivelyExternal$p(this.this$0), FieldFlags.isStatic-impl(this.$flags));
                }
            }));
            IrDeclarationDeserializer irDeclarationDeserializer2 = this;
            IrDeclarationParent $this$usingParent$iv = field2;
            boolean $i$f$usingParent = false;
            IrDeclarationParent irDeclarationParent = $this$usingParent$iv;
            boolean bl7 = false;
            boolean bl8 = false;
            IrDeclarationParent $this$usingParent_u24lambda_u2d6$iv = irDeclarationParent;
            boolean bl9 = false;
            IrDeclarationParent oldParent$iv = ((IrDeclarationDeserializer)this_$iv2).currentParent;
            ((IrDeclarationDeserializer)this_$iv2).currentParent = $this$usingParent_u24lambda_u2d6$iv;
            try {
                org.jetbrains.kotlin.ir.declarations.IrField $this$deserializeIrField_u24lambda_u2d38_u24lambda_u2d37 = (org.jetbrains.kotlin.ir.declarations.IrField)$this$usingParent_u24lambda_u2d6$iv;
                boolean bl10 = false;
                if (proto.hasInitializer()) {
                    this.withInitializerGuard($this$deserializeIrField_u24lambda_u2d38_u24lambda_u2d37, (Function1<? super org.jetbrains.kotlin.ir.declarations.IrField, Unit>)((Function1)new Function1<org.jetbrains.kotlin.ir.declarations.IrField, Unit>(this, proto){
                        final /* synthetic */ IrDeclarationDeserializer this$0;
                        final /* synthetic */ IrField $proto;
                        {
                            this.this$0 = $receiver;
                            this.$proto = $proto;
                            super(1);
                        }

                        public final void invoke(@NotNull org.jetbrains.kotlin.ir.declarations.IrField $this$withInitializerGuard) {
                            Intrinsics.checkNotNullParameter((Object)$this$withInitializerGuard, (String)"$this$withInitializerGuard");
                            $this$withInitializerGuard.setInitializer(this.this$0.deserializeExpressionBody(this.$proto.getInitializer()));
                        }
                    }));
                }
            }
            finally {
                ((IrDeclarationDeserializer)this_$iv2).currentParent = oldParent$iv;
            }
            org.jetbrains.kotlin.ir.declarations.IrDeclaration result$iv = field2;
            if (!((IrDeclarationDeserializer)this_$iv).allowRedeclaration || result$iv.getAnnotations().isEmpty()) {
                object = result$iv;
                Collection collection = object.getAnnotations();
                List<IrConstructorCall> list2 = proto$iv.getAnnotationList();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"proto.annotationList");
                object.setAnnotations(CollectionsKt.plus((Collection)collection, (Iterable)this_$iv.deserializeAnnotations$ir_serialization_common(list2)));
            }
            if (!((IrDeclarationDeserializer)this_$iv).skipMutableState) {
                result$iv.setParent(((IrDeclarationDeserializer)this_$iv).currentParent);
            }
            object = result$iv;
        }
        finally {
            ((IrDeclarationDeserializer)this_$iv).eraseDelegatedSymbol(s$iv);
        }
        return (org.jetbrains.kotlin.ir.declarations.IrField)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty deserializeIrLocalDelegatedProperty(IrLocalDelegatedProperty proto) {
        Object object;
        void proto$iv;
        void this_$iv;
        IrDeclarationDeserializer irDeclarationDeserializer = this;
        IrDeclarationBase irDeclarationBase = proto.getBase();
        Intrinsics.checkNotNullExpressionValue((Object)irDeclarationBase, (String)"proto.base");
        boolean $i$f$withDeserializedIrDeclarationBase = false;
        Pair<IrSymbol, IdSignature> pair = this_$iv.getSymbolDeserializer().deserializeIrSymbolToDeclare(proto$iv.getSymbol());
        IrSymbol s$iv = (IrSymbol)pair.component1();
        IdSignature uid$iv = (IdSignature)pair.component2();
        long coordinates$iv = BinaryCoordinates.Companion.decode-ViYoqTc(proto$iv.getCoordinates());
        try {
            void origin;
            void endOffset;
            void startOffset;
            org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty prop2;
            void fcode;
            ((IrDeclarationDeserializer)this_$iv).recordDelegatedSymbol(s$iv);
            long l = proto$iv.getFlags();
            IrDeclarationOrigin irDeclarationOrigin = this_$iv.deserializeIrDeclarationOrigin(proto$iv.getOriginName());
            int n = BinaryCoordinates.getEndOffset-impl(coordinates$iv);
            int n2 = BinaryCoordinates.getStartOffset-impl(coordinates$iv);
            object = uid$iv;
            IrSymbol symbol2 = s$iv;
            boolean bl = false;
            long flags = LocalVariableFlags.Companion.decode-QnIyQoc((long)fcode);
            long nameAndType = BinaryNameAndType.Companion.decode-WXC2TjU(proto.getNameType());
            org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty irLocalDelegatedProperty = prop2 = this.allowRedeclaration && symbol2.isBound() ? (org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty)symbol2.getOwner() : this.getIrFactory().createLocalDelegatedProperty((int)startOffset, (int)endOffset, (IrDeclarationOrigin)origin, (IrLocalDelegatedPropertySymbol)symbol2, this.deserializeName(BinaryNameAndType.getNameIndex-impl(nameAndType)), this.deserializeIrType(BinaryNameAndType.getTypeIndex-impl(nameAndType)), LocalVariableFlags.isVar-impl(flags));
            if (!this.skipMutableState) {
                org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty irLocalDelegatedProperty2 = prop2;
                boolean bl2 = false;
                boolean bl3 = false;
                org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty $this$deserializeIrLocalDelegatedProperty_u24lambda_u2d40_u24lambda_u2d39 = irLocalDelegatedProperty2;
                boolean bl4 = false;
                GeneratedMessageLite generatedMessageLite = proto.getDelegate();
                Intrinsics.checkNotNullExpressionValue((Object)generatedMessageLite, (String)"proto.delegate");
                $this$deserializeIrLocalDelegatedProperty_u24lambda_u2d40_u24lambda_u2d39.setDelegate(this.deserializeIrVariable((IrVariable)generatedMessageLite));
                generatedMessageLite = proto.getGetter();
                Intrinsics.checkNotNullExpressionValue((Object)generatedMessageLite, (String)"proto.getter");
                $this$deserializeIrLocalDelegatedProperty_u24lambda_u2d40_u24lambda_u2d39.setGetter(this.deserializeIrFunction$ir_serialization_common((IrFunction)generatedMessageLite));
                if (proto.hasSetter()) {
                    generatedMessageLite = proto.getSetter();
                    Intrinsics.checkNotNullExpressionValue((Object)generatedMessageLite, (String)"proto.setter");
                    $this$deserializeIrLocalDelegatedProperty_u24lambda_u2d40_u24lambda_u2d39.setSetter(this.deserializeIrFunction$ir_serialization_common((IrFunction)generatedMessageLite));
                }
            }
            org.jetbrains.kotlin.ir.declarations.IrDeclaration result$iv = prop2;
            if (!((IrDeclarationDeserializer)this_$iv).allowRedeclaration || result$iv.getAnnotations().isEmpty()) {
                object = result$iv;
                Collection collection = object.getAnnotations();
                List<IrConstructorCall> list2 = proto$iv.getAnnotationList();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"proto.annotationList");
                object.setAnnotations(CollectionsKt.plus((Collection)collection, (Iterable)this_$iv.deserializeAnnotations$ir_serialization_common(list2)));
            }
            if (!((IrDeclarationDeserializer)this_$iv).skipMutableState) {
                result$iv.setParent(((IrDeclarationDeserializer)this_$iv).currentParent);
            }
            object = result$iv;
        }
        finally {
            ((IrDeclarationDeserializer)this_$iv).eraseDelegatedSymbol(s$iv);
        }
        return (org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final org.jetbrains.kotlin.ir.declarations.IrProperty deserializeIrProperty(IrProperty proto) {
        Object object;
        void proto$iv;
        void this_$iv;
        IrDeclarationDeserializer irDeclarationDeserializer = this;
        IrDeclarationBase irDeclarationBase = proto.getBase();
        Intrinsics.checkNotNullExpressionValue((Object)irDeclarationBase, (String)"proto.base");
        boolean $i$f$withDeserializedIrDeclarationBase = false;
        Pair<IrSymbol, IdSignature> pair = this_$iv.getSymbolDeserializer().deserializeIrSymbolToDeclare(proto$iv.getSymbol());
        IrSymbol s$iv = (IrSymbol)pair.component1();
        IdSignature uid$iv = (IdSignature)pair.component2();
        long coordinates$iv = BinaryCoordinates.Companion.decode-ViYoqTc(proto$iv.getCoordinates());
        try {
            void origin;
            void endOffset;
            void startOffset;
            void uniqId;
            org.jetbrains.kotlin.ir.declarations.IrProperty prop2;
            void fcode;
            ((IrDeclarationDeserializer)this_$iv).recordDelegatedSymbol(s$iv);
            long l = proto$iv.getFlags();
            IrDeclarationOrigin irDeclarationOrigin = this_$iv.deserializeIrDeclarationOrigin(proto$iv.getOriginName());
            int n = BinaryCoordinates.getEndOffset-impl(coordinates$iv);
            int n2 = BinaryCoordinates.getStartOffset-impl(coordinates$iv);
            object = uid$iv;
            IrSymbol symbol2 = s$iv;
            boolean bl = false;
            boolean bl2 = symbol2 instanceof IrPropertySymbol;
            boolean bl3 = false;
            boolean bl4 = false;
            bl4 = false;
            boolean bl5 = false;
            if (!bl2) {
                boolean bl6 = false;
                String string2 = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string2.toString());
            }
            long flags = PropertyFlags.Companion.decode-85tB66k((long)fcode);
            org.jetbrains.kotlin.ir.declarations.IrProperty irProperty2 = prop2 = this.allowRedeclaration && symbol2.isBound() ? (org.jetbrains.kotlin.ir.declarations.IrProperty)((IrPropertySymbol)symbol2).getOwner() : this.symbolTable.declareProperty((IdSignature)uniqId, (Function0<? extends IrPropertySymbol>)((Function0)new Function0<IrPropertySymbol>(symbol2){
                final /* synthetic */ IrSymbol $symbol;
                {
                    this.$symbol = $symbol;
                    super(0);
                }

                @NotNull
                public final IrPropertySymbol invoke() {
                    return (IrPropertySymbol)this.$symbol;
                }
            }), (Function1<? super IrPropertySymbol, ? extends org.jetbrains.kotlin.ir.declarations.IrProperty>)((Function1)new Function1<IrPropertySymbol, org.jetbrains.kotlin.ir.declarations.IrProperty>(this, (int)startOffset, (int)endOffset, (IrDeclarationOrigin)origin, proto, flags){
                final /* synthetic */ IrDeclarationDeserializer this$0;
                final /* synthetic */ int $startOffset;
                final /* synthetic */ int $endOffset;
                final /* synthetic */ IrDeclarationOrigin $origin;
                final /* synthetic */ IrProperty $proto;
                final /* synthetic */ long $flags;
                {
                    this.this$0 = $receiver;
                    this.$startOffset = $startOffset;
                    this.$endOffset = $endOffset;
                    this.$origin = $origin;
                    this.$proto = $proto;
                    this.$flags = $flags;
                    super(1);
                }

                @NotNull
                public final org.jetbrains.kotlin.ir.declarations.IrProperty invoke(@NotNull IrPropertySymbol it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return IrFactory.DefaultImpls.createProperty$default(this.this$0.getIrFactory(), this.$startOffset, this.$endOffset, this.$origin, it, IrDeclarationDeserializer.access$deserializeName(this.this$0, this.$proto.getName()), PropertyFlags.getVisibility-impl(this.$flags), PropertyFlags.getModality-impl(this.$flags), PropertyFlags.isVar-impl(this.$flags), PropertyFlags.isConst-impl(this.$flags), PropertyFlags.isLateinit-impl(this.$flags), PropertyFlags.isDelegated-impl(this.$flags), PropertyFlags.isExternal-impl(this.$flags) || IrDeclarationDeserializer.access$isEffectivelyExternal$p(this.this$0), PropertyFlags.isExpect-impl(this.$flags), PropertyFlags.isFakeOverride-impl(this.$flags), null, 16384, null);
                }
            }));
            if (!this.skipMutableState) {
                void this_$iv2;
                org.jetbrains.kotlin.ir.declarations.IrProperty irProperty3 = prop2;
                boolean bl7 = false;
                boolean bl8 = false;
                org.jetbrains.kotlin.ir.declarations.IrProperty $this$deserializeIrProperty_u24lambda_u2d46_u24lambda_u2d45 = irProperty3;
                boolean bl9 = false;
                IrDeclarationDeserializer irDeclarationDeserializer2 = this;
                boolean value$iv = $this$deserializeIrProperty_u24lambda_u2d46_u24lambda_u2d45.isExternal();
                boolean $i$f$withExternalValue = false;
                boolean oldExternalValue$iv = ((IrDeclarationDeserializer)this_$iv2).isEffectivelyExternal;
                ((IrDeclarationDeserializer)this_$iv2).isEffectivelyExternal = value$iv;
                try {
                    Unit unit;
                    Object it;
                    org.jetbrains.kotlin.ir.declarations.IrProperty irProperty4;
                    boolean bl10;
                    boolean bl11;
                    Object object2;
                    boolean bl12 = false;
                    if (proto.hasGetter()) {
                        object2 = proto.getGetter();
                        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"proto.getter");
                        object2 = this.deserializeIrFunction$ir_serialization_common((IrFunction)object2);
                        bl11 = false;
                        bl10 = false;
                        Object object3 = object2;
                        irProperty4 = $this$deserializeIrProperty_u24lambda_u2d46_u24lambda_u2d45;
                        boolean bl13 = false;
                        ((IrSimpleFunction)it).setCorrespondingPropertySymbol((IrPropertySymbol)symbol2);
                        unit = Unit.INSTANCE;
                        irProperty4.setGetter((IrSimpleFunction)object2);
                    }
                    if (proto.hasSetter()) {
                        object2 = proto.getSetter();
                        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"proto.setter");
                        object2 = this.deserializeIrFunction$ir_serialization_common((IrFunction)object2);
                        bl11 = false;
                        bl10 = false;
                        it = object2;
                        irProperty4 = $this$deserializeIrProperty_u24lambda_u2d46_u24lambda_u2d45;
                        boolean bl14 = false;
                        ((IrSimpleFunction)it).setCorrespondingPropertySymbol((IrPropertySymbol)symbol2);
                        unit = Unit.INSTANCE;
                        irProperty4.setSetter((IrSimpleFunction)object2);
                    }
                    if (proto.hasBackingField()) {
                        object2 = proto.getBackingField();
                        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"proto.backingField");
                        object2 = this.deserializeIrField((IrField)object2);
                        bl11 = false;
                        bl10 = false;
                        it = object2;
                        irProperty4 = $this$deserializeIrProperty_u24lambda_u2d46_u24lambda_u2d45;
                        boolean bl15 = false;
                        ((org.jetbrains.kotlin.ir.declarations.IrField)it).setCorrespondingPropertySymbol((IrPropertySymbol)symbol2);
                        unit = Unit.INSTANCE;
                        irProperty4.setBackingField((org.jetbrains.kotlin.ir.declarations.IrField)object2);
                    }
                }
                finally {
                    ((IrDeclarationDeserializer)this_$iv2).isEffectivelyExternal = oldExternalValue$iv;
                }
            }
            org.jetbrains.kotlin.ir.declarations.IrDeclaration result$iv = prop2;
            if (!((IrDeclarationDeserializer)this_$iv).allowRedeclaration || result$iv.getAnnotations().isEmpty()) {
                object = result$iv;
                Collection collection = object.getAnnotations();
                List<IrConstructorCall> list2 = proto$iv.getAnnotationList();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"proto.annotationList");
                object.setAnnotations(CollectionsKt.plus((Collection)collection, (Iterable)this_$iv.deserializeAnnotations$ir_serialization_common(list2)));
            }
            if (!((IrDeclarationDeserializer)this_$iv).skipMutableState) {
                result$iv.setParent(((IrDeclarationDeserializer)this_$iv).currentParent);
            }
            object = result$iv;
        }
        finally {
            ((IrDeclarationDeserializer)this_$iv).eraseDelegatedSymbol(s$iv);
        }
        return (org.jetbrains.kotlin.ir.declarations.IrProperty)object;
    }

    @NotNull
    public final IrDeclarationOriginImpl deserializeIrDeclarationOrigin(int protoName) {
        String originName = IrFileDeserializerKt.deserializeString(this.fileReader, protoName);
        IrDeclarationOriginImpl irDeclarationOriginImpl = declarationOriginIndex.get(originName);
        return irDeclarationOriginImpl == null ? (IrDeclarationOriginImpl)new IrDeclarationOriginImpl(originName){
            final /* synthetic */ String $originName;
            {
                this.$originName = $originName;
                super($originName, false, 2, null);
            }
        } : irDeclarationOriginImpl;
    }

    @NotNull
    public final org.jetbrains.kotlin.ir.declarations.IrDeclaration deserializeDeclaration(@NotNull IrDeclaration proto) {
        org.jetbrains.kotlin.ir.declarations.IrDeclaration irDeclaration2;
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        IrDeclaration.DeclaratorCase declaratorCase = proto.getDeclaratorCase();
        Intrinsics.checkNotNull((Object)declaratorCase);
        IrDeclaration.DeclaratorCase declaratorCase2 = declaratorCase;
        int n = WhenMappings.$EnumSwitchMapping$1[declaratorCase2.ordinal()];
        switch (n) {
            case 1: {
                GeneratedMessageLite generatedMessageLite = proto.getIrAnonymousInit();
                Intrinsics.checkNotNullExpressionValue((Object)generatedMessageLite, (String)"proto.irAnonymousInit");
                irDeclaration2 = this.deserializeIrAnonymousInit((IrAnonymousInit)generatedMessageLite);
                break;
            }
            case 2: {
                GeneratedMessageLite generatedMessageLite = proto.getIrConstructor();
                Intrinsics.checkNotNullExpressionValue((Object)generatedMessageLite, (String)"proto.irConstructor");
                irDeclaration2 = this.deserializeIrConstructor((IrConstructor)generatedMessageLite);
                break;
            }
            case 3: {
                GeneratedMessageLite generatedMessageLite = proto.getIrField();
                Intrinsics.checkNotNullExpressionValue((Object)generatedMessageLite, (String)"proto.irField");
                irDeclaration2 = this.deserializeIrField((IrField)generatedMessageLite);
                break;
            }
            case 4: {
                GeneratedMessageLite generatedMessageLite = proto.getIrClass();
                Intrinsics.checkNotNullExpressionValue((Object)generatedMessageLite, (String)"proto.irClass");
                irDeclaration2 = this.deserializeIrClass((IrClass)generatedMessageLite);
                break;
            }
            case 5: {
                GeneratedMessageLite generatedMessageLite = proto.getIrFunction();
                Intrinsics.checkNotNullExpressionValue((Object)generatedMessageLite, (String)"proto.irFunction");
                irDeclaration2 = this.deserializeIrFunction$ir_serialization_common((IrFunction)generatedMessageLite);
                break;
            }
            case 6: {
                GeneratedMessageLite generatedMessageLite = proto.getIrProperty();
                Intrinsics.checkNotNullExpressionValue((Object)generatedMessageLite, (String)"proto.irProperty");
                irDeclaration2 = this.deserializeIrProperty((IrProperty)generatedMessageLite);
                break;
            }
            case 7: {
                GeneratedMessageLite generatedMessageLite = proto.getIrTypeParameter();
                Intrinsics.checkNotNullExpressionValue((Object)generatedMessageLite, (String)"proto.irTypeParameter");
                irDeclaration2 = this.deserializeIrTypeParameter((IrTypeParameter)generatedMessageLite, proto.getIrTypeParameter().getIndex(), proto.getIrTypeParameter().getIsGlobal());
                break;
            }
            case 8: {
                GeneratedMessageLite generatedMessageLite = proto.getIrVariable();
                Intrinsics.checkNotNullExpressionValue((Object)generatedMessageLite, (String)"proto.irVariable");
                irDeclaration2 = this.deserializeIrVariable((IrVariable)generatedMessageLite);
                break;
            }
            case 9: {
                GeneratedMessageLite generatedMessageLite = proto.getIrValueParameter();
                Intrinsics.checkNotNullExpressionValue((Object)generatedMessageLite, (String)"proto.irValueParameter");
                irDeclaration2 = this.deserializeIrValueParameter((IrValueParameter)generatedMessageLite, proto.getIrValueParameter().getIndex());
                break;
            }
            case 10: {
                GeneratedMessageLite generatedMessageLite = proto.getIrEnumEntry();
                Intrinsics.checkNotNullExpressionValue((Object)generatedMessageLite, (String)"proto.irEnumEntry");
                irDeclaration2 = this.deserializeIrEnumEntry((IrEnumEntry)generatedMessageLite);
                break;
            }
            case 11: {
                GeneratedMessageLite generatedMessageLite = proto.getIrLocalDelegatedProperty();
                Intrinsics.checkNotNullExpressionValue((Object)generatedMessageLite, (String)"proto.irLocalDelegatedProperty");
                irDeclaration2 = this.deserializeIrLocalDelegatedProperty((IrLocalDelegatedProperty)generatedMessageLite);
                break;
            }
            case 12: {
                GeneratedMessageLite generatedMessageLite = proto.getIrTypeAlias();
                Intrinsics.checkNotNullExpressionValue((Object)generatedMessageLite, (String)"proto.irTypeAlias");
                irDeclaration2 = this.deserializeIrTypeAlias((IrTypeAlias)generatedMessageLite);
                break;
            }
            case 13: {
                GeneratedMessageLite generatedMessageLite = proto.getIrErrorDeclaration();
                Intrinsics.checkNotNullExpressionValue((Object)generatedMessageLite, (String)"proto.irErrorDeclaration");
                irDeclaration2 = this.deserializeErrorDeclaration((IrErrorDeclaration)generatedMessageLite);
                break;
            }
            case 14: {
                String string2 = Intrinsics.stringPlus((String)"Declaration deserialization not implemented: ", (Object)proto.getDeclaratorCase());
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        org.jetbrains.kotlin.ir.declarations.IrDeclaration declaration2 = irDeclaration2;
        return declaration2;
    }

    private final boolean isSkippableFakeOverride(IrDeclaration proto, org.jetbrains.kotlin.ir.declarations.IrClass parent2) {
        boolean bl;
        IrSymbol irSymbol2;
        if (!this.platformFakeOverrideClassFilter.needToConstructFakeOverrides(parent2)) {
            return false;
        }
        IrDeclaration.DeclaratorCase declaratorCase = proto.getDeclaratorCase();
        Intrinsics.checkNotNull((Object)declaratorCase);
        IrDeclaration.DeclaratorCase declaratorCase2 = declaratorCase;
        int n = WhenMappings.$EnumSwitchMapping$1[declaratorCase2.ordinal()];
        switch (n) {
            case 5: {
                irSymbol2 = this.symbolDeserializer.deserializeIrSymbol(proto.getIrFunction().getBase().getBase().getSymbol());
                break;
            }
            case 6: {
                irSymbol2 = this.symbolDeserializer.deserializeIrSymbol(proto.getIrProperty().getBase().getSymbol());
                break;
            }
            default: {
                return false;
            }
        }
        IrSymbol symbol2 = irSymbol2;
        if (!(symbol2 instanceof IrPublicSymbolBase)) {
            return false;
        }
        if (!((IrPublicSymbolBase)symbol2).getSignature().isPublic()) {
            return false;
        }
        IrDeclaration.DeclaratorCase declaratorCase3 = proto.getDeclaratorCase();
        Intrinsics.checkNotNull((Object)declaratorCase3);
        declaratorCase2 = declaratorCase3;
        n = WhenMappings.$EnumSwitchMapping$1[declaratorCase2.ordinal()];
        switch (n) {
            case 5: {
                bl = FunctionFlags.isFakeOverride-impl(FunctionFlags.Companion.decode-UIJRpeM(proto.getIrFunction().getBase().getBase().getFlags()));
                break;
            }
            case 6: {
                bl = PropertyFlags.isFakeOverride-impl(PropertyFlags.Companion.decode-85tB66k(proto.getIrProperty().getBase().getFlags()));
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    private static final <T extends org.jetbrains.kotlin.ir.declarations.IrFunction> boolean withBodyGuard$checkInlineBody(IrDeclarationDeserializer this$0, T $this_withBodyGuard) {
        return this$0.deserializeInlineFunctions && $this_withBodyGuard instanceof IrSimpleFunction && $this_withBodyGuard.isInline();
    }

    public static final /* synthetic */ Name access$deserializeName(IrDeclarationDeserializer $this, int index2) {
        return $this.deserializeName(index2);
    }

    public static final /* synthetic */ List access$deserializeValueParameters(IrDeclarationDeserializer $this, List protos) {
        return $this.deserializeValueParameters(protos);
    }

    public static final /* synthetic */ org.jetbrains.kotlin.ir.declarations.IrValueParameter access$deserializeIrValueParameter(IrDeclarationDeserializer $this, IrValueParameter proto, int index2) {
        return $this.deserializeIrValueParameter(proto, index2);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$mapNotNullTo$iv$iv;
        Object element$iv$iv2;
        void $this$associateByTo$iv$iv;
        Object object;
        Object object2;
        void $this$mapTo$iv$iv;
        Companion = new Companion(null);
        allKnownDeclarationOrigins = CollectionsKt.toList((Iterable)Reflection.getOrCreateKotlinClass(IrDeclarationOrigin.class).getNestedClasses());
        Iterable $this$map$iv = allKnownDeclarationOrigins;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable<IrStatementOriginImpl> destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KClass kClass2 = (KClass)item$iv$iv;
            object2 = destination$iv$iv;
            boolean bl = false;
            Object object3 = it.getObjectInstance();
            if (object3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclarationOriginImpl");
            }
            object = (IrDeclarationOriginImpl)object3;
            object2.add(object);
        }
        Iterable $this$associateBy$iv = (List)destination$iv$iv;
        boolean $i$f$associateBy = false;
        int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associateBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv22);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv2 : $this$associateByTo$iv$iv) {
            void it;
            IrDeclarationOriginImpl bl = (IrDeclarationOriginImpl)element$iv$iv2;
            object2 = destination$iv$iv2;
            boolean bl2 = false;
            object = it.getName();
            object2.put(object, element$iv$iv2);
        }
        declarationOriginIndex = destination$iv$iv2;
        allKnownStatementOrigins = CollectionsKt.toList((Iterable)Reflection.getOrCreateKotlinClass(IrStatementOrigin.class).getNestedClasses());
        Iterable $this$mapNotNull$iv = allKnownStatementOrigins;
        boolean $i$f$mapNotNull = false;
        Iterable capacity$iv22 = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        element$iv$iv2 = $this$forEach$iv$iv$iv.iterator();
        while (element$iv$iv2.hasNext()) {
            IrStatementOriginImpl irStatementOriginImpl;
            Object element$iv$iv$iv;
            Object element$iv$iv3 = element$iv$iv$iv = element$iv$iv2.next();
            boolean bl = false;
            KClass it = (KClass)element$iv$iv3;
            boolean bl3 = false;
            Object object4 = it.getObjectInstance();
            if ((object4 instanceof IrStatementOriginImpl ? (IrStatementOriginImpl)object4 : null) == null) continue;
            irStatementOriginImpl = irStatementOriginImpl;
            boolean bl4 = false;
            boolean bl5 = false;
            IrStatementOriginImpl it$iv$iv = irStatementOriginImpl;
            boolean bl6 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        $this$associateBy$iv = (List)destination$iv$iv;
        $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associateBy$iv;
        destination$iv$iv = new LinkedHashMap(capacity$iv);
        $i$f$associateByTo = false;
        for (Object element$iv$iv2 : $this$associateByTo$iv$iv) {
            void it;
            IrStatementOriginImpl element$iv$iv$iv = (IrStatementOriginImpl)element$iv$iv2;
            object2 = destination$iv$iv;
            boolean bl = false;
            object = it.getDebugName();
            object2.put(object, element$iv$iv2);
        }
        statementOriginIndex = destination$iv$iv;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0018\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\f0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/IrDeclarationDeserializer$Companion;", "", "()V", "allKnownDeclarationOrigins", "", "Lkotlin/reflect/KClass;", "allKnownStatementOrigins", "declarationOriginIndex", "", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOriginImpl;", "statementOriginIndex", "Lorg/jetbrains/kotlin/ir/expressions/IrStatementOriginImpl;", "ir.serialization.common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[IrType.KindCase.values().length];
            nArray[IrType.KindCase.SIMPLE.ordinal()] = 1;
            nArray[IrType.KindCase.DYNAMIC.ordinal()] = 2;
            nArray[IrType.KindCase.ERROR.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[IrDeclaration.DeclaratorCase.values().length];
            nArray[IrDeclaration.DeclaratorCase.IR_ANONYMOUS_INIT.ordinal()] = 1;
            nArray[IrDeclaration.DeclaratorCase.IR_CONSTRUCTOR.ordinal()] = 2;
            nArray[IrDeclaration.DeclaratorCase.IR_FIELD.ordinal()] = 3;
            nArray[IrDeclaration.DeclaratorCase.IR_CLASS.ordinal()] = 4;
            nArray[IrDeclaration.DeclaratorCase.IR_FUNCTION.ordinal()] = 5;
            nArray[IrDeclaration.DeclaratorCase.IR_PROPERTY.ordinal()] = 6;
            nArray[IrDeclaration.DeclaratorCase.IR_TYPE_PARAMETER.ordinal()] = 7;
            nArray[IrDeclaration.DeclaratorCase.IR_VARIABLE.ordinal()] = 8;
            nArray[IrDeclaration.DeclaratorCase.IR_VALUE_PARAMETER.ordinal()] = 9;
            nArray[IrDeclaration.DeclaratorCase.IR_ENUM_ENTRY.ordinal()] = 10;
            nArray[IrDeclaration.DeclaratorCase.IR_LOCAL_DELEGATED_PROPERTY.ordinal()] = 11;
            nArray[IrDeclaration.DeclaratorCase.IR_TYPE_ALIAS.ordinal()] = 12;
            nArray[IrDeclaration.DeclaratorCase.IR_ERROR_DECLARATION.ordinal()] = 13;
            nArray[IrDeclaration.DeclaratorCase.DECLARATOR_NOT_SET.ordinal()] = 14;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

