/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.renderer;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.container.ComponentProvider;
import org.jetbrains.kotlin.container.DslKt;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnonymousInitializer;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionType;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.renderer.AbstractDescriptorRendererTest;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.CompilerEnvironment;
import org.jetbrains.kotlin.resolve.TargetEnvironment;
import org.jetbrains.kotlin.resolve.lazy.JvmResolveUtil;
import org.jetbrains.kotlin.resolve.lazy.ResolveSession;
import org.jetbrains.kotlin.test.ConfigurationKind;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.KotlinTestWithEnvironment;
import org.jetbrains.kotlin.test.testFramework.KtUsefulTestCase;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0014J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014R\u0014\u0010\u0003\u001a\u00020\u00048TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/renderer/AbstractDescriptorRendererTest;", "Lorg/jetbrains/kotlin/test/KotlinTestWithEnvironment;", "()V", "targetEnvironment", "Lorg/jetbrains/kotlin/resolve/TargetEnvironment;", "getTargetEnvironment", "()Lorg/jetbrains/kotlin/resolve/TargetEnvironment;", "createEnvironment", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "doTest", "", "path", "", "getDescriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "container", "Lorg/jetbrains/kotlin/container/ComponentProvider;", "tests-common"})
public abstract class AbstractDescriptorRendererTest
extends KotlinTestWithEnvironment {
    @NotNull
    protected DeclarationDescriptor getDescriptor(@NotNull KtDeclaration declaration, @NotNull ComponentProvider container) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        ComponentProvider $this$get$iv = container;
        boolean $i$f$get = false;
        DeclarationDescriptor declarationDescriptor = ((ResolveSession)DslKt.getService((ComponentProvider)$this$get$iv, ResolveSession.class)).resolveToDescriptor(declaration);
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"container.get<ResolveSession>().resolveToDescriptor(declaration)");
        return declarationDescriptor;
    }

    @NotNull
    protected TargetEnvironment getTargetEnvironment() {
        return (TargetEnvironment)CompilerEnvironment.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    public final void doTest(@NotNull String path) {
        void $this$mapTo$iv$iv;
        ComponentProvider container;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String string = FileUtil.loadFile((File)new File(path), (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"loadFile(File(path), true)");
        String fileText = string;
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        KtFile psiFile = new KtPsiFactory(project, false, 2, null).createFile(fileText);
        KotlinCoreEnvironment kotlinCoreEnvironment = this.getEnvironment();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinCoreEnvironment, (String)"environment");
        ComponentProvider $this$get$iv = container = JvmResolveUtil.createContainer((KotlinCoreEnvironment)kotlinCoreEnvironment, (Collection)CollectionsKt.listOf((Object)psiFile), (TargetEnvironment)this.getTargetEnvironment());
        boolean $i$f$get = false;
        ModuleDescriptor module2 = (ModuleDescriptor)DslKt.getService((ComponentProvider)$this$get$iv, ModuleDescriptor.class);
        ArrayList<DeclarationDescriptor> descriptors = new ArrayList<DeclarationDescriptor>();
        psiFile.accept((PsiElementVisitor)new KtVisitorVoid(descriptors, module2, this, container){
            final /* synthetic */ ArrayList<DeclarationDescriptor> $descriptors;
            final /* synthetic */ ModuleDescriptor $module;
            final /* synthetic */ AbstractDescriptorRendererTest this$0;
            final /* synthetic */ ComponentProvider $container;
            {
                this.$descriptors = $descriptors;
                this.$module = $module;
                this.this$0 = $receiver;
                this.$container = $container;
            }

            public void visitKtFile(@NotNull KtFile file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                FqName fqName = file.getPackageFqName();
                if (!fqName.isRoot()) {
                    this.$descriptors.add((DeclarationDescriptor)this.$module.getPackage(fqName));
                }
                file.acceptChildren((PsiElementVisitor)this);
            }

            public void visitParameter(@NotNull KtParameter parameter) {
                PsiElement declaringElement;
                Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
                PsiElement psiElement = declaringElement = parameter.getParent().getParent();
                if (psiElement instanceof KtFunctionType) {
                    return;
                }
                if (psiElement instanceof KtNamedFunction) {
                    Intrinsics.checkNotNullExpressionValue((Object)declaringElement, (String)"declaringElement");
                    this.addCorrespondingParameterDescriptor((FunctionDescriptor)this.this$0.getDescriptor((KtDeclaration)declaringElement, this.$container), parameter);
                } else if (psiElement instanceof KtPrimaryConstructor) {
                    KtClassOrObject ktClassOrObject = ((KtPrimaryConstructor)declaringElement).getContainingClassOrObject();
                    ClassDescriptor classDescriptor = (ClassDescriptor)this.this$0.getDescriptor((KtDeclaration)ktClassOrObject, this.$container);
                    ClassConstructorDescriptor classConstructorDescriptor = classDescriptor.getUnsubstitutedPrimaryConstructor();
                    Intrinsics.checkNotNull((Object)classConstructorDescriptor);
                    ClassConstructorDescriptor classConstructorDescriptor2 = classConstructorDescriptor;
                    this.addCorrespondingParameterDescriptor((FunctionDescriptor)classConstructorDescriptor2, parameter);
                } else {
                    super.visitParameter(parameter);
                }
            }

            public void visitPropertyAccessor(@NotNull KtPropertyAccessor accessor) {
                Intrinsics.checkNotNullParameter((Object)accessor, (String)"accessor");
                KtProperty ktProperty = accessor.getProperty();
                Intrinsics.checkNotNullExpressionValue((Object)ktProperty, (String)"accessor.property");
                KtProperty property = ktProperty;
                PropertyDescriptor propertyDescriptor = (PropertyDescriptor)this.this$0.getDescriptor((KtDeclaration)property, this.$container);
                if (accessor.isGetter()) {
                    PropertyGetterDescriptor propertyGetterDescriptor = propertyDescriptor.getGetter();
                    Intrinsics.checkNotNull((Object)propertyGetterDescriptor);
                    this.$descriptors.add((DeclarationDescriptor)propertyGetterDescriptor);
                } else {
                    PropertySetterDescriptor propertySetterDescriptor = propertyDescriptor.getSetter();
                    Intrinsics.checkNotNull((Object)propertySetterDescriptor);
                    this.$descriptors.add((DeclarationDescriptor)propertySetterDescriptor);
                }
                accessor.acceptChildren((PsiElementVisitor)this);
            }

            public void visitAnonymousInitializer(@NotNull KtAnonymousInitializer initializer) {
                Intrinsics.checkNotNullParameter((Object)initializer, (String)"initializer");
                initializer.acceptChildren((PsiElementVisitor)this);
            }

            public void visitDeclaration(@NotNull KtDeclaration element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                DeclarationDescriptor descriptor = this.this$0.getDescriptor(element, this.$container);
                this.$descriptors.add(descriptor);
                if (!(!(descriptor instanceof ClassDescriptor) || element instanceof KtClassOrObject && ((KtClassOrObject)element).hasExplicitPrimaryConstructor() || ((ClassDescriptor)descriptor).getUnsubstitutedPrimaryConstructor() == null)) {
                    ClassConstructorDescriptor classConstructorDescriptor = ((ClassDescriptor)descriptor).getUnsubstitutedPrimaryConstructor();
                    Intrinsics.checkNotNull((Object)classConstructorDescriptor);
                    this.$descriptors.add((DeclarationDescriptor)classConstructorDescriptor);
                }
                element.acceptChildren((PsiElementVisitor)this);
            }

            public void visitKtElement(@NotNull KtElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                element.acceptChildren((PsiElementVisitor)this);
            }

            private final void addCorrespondingParameterDescriptor(FunctionDescriptor functionDescriptor, KtParameter parameter) {
                for (ValueParameterDescriptor valueParameterDescriptor : functionDescriptor.getValueParameters()) {
                    if (!Intrinsics.areEqual((Object)valueParameterDescriptor.getName(), (Object)parameter.getNameAsName())) continue;
                    this.$descriptors.add((DeclarationDescriptor)valueParameterDescriptor);
                }
                parameter.acceptChildren((PsiElementVisitor)this);
            }
        });
        DescriptorRenderer renderer2 = DescriptorRenderer.Companion.withOptions((Function1)doTest.renderer.1.INSTANCE);
        Iterable $this$map$iv = descriptors;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DeclarationDescriptor declarationDescriptor = (DeclarationDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = renderer2.render((DeclarationDescriptor)it);
            collection.add(string2);
        }
        String renderedDescriptors = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        DocumentImpl document = new DocumentImpl(psiFile.getText());
        KtUsefulTestCase.assertSameLines(KotlinTestUtils.getLastCommentedLines((Document)document), renderedDescriptors);
    }

    @Override
    @NotNull
    protected KotlinCoreEnvironment createEnvironment() {
        KotlinCoreEnvironment kotlinCoreEnvironment = this.createEnvironmentWithMockJdk(ConfigurationKind.JDK_ONLY);
        Intrinsics.checkNotNullExpressionValue((Object)kotlinCoreEnvironment, (String)"createEnvironmentWithMockJdk(ConfigurationKind.JDK_ONLY)");
        return kotlinCoreEnvironment;
    }
}

