/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.checkers;

import com.intellij.psi.PsiFile;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.checkers.AbstractDiagnosticsTest;
import org.jetbrains.kotlin.checkers.DiagnosedRange;
import org.jetbrains.kotlin.checkers.DiagnosticData;
import org.jetbrains.kotlin.checkers.Test;
import org.jetbrains.kotlin.checkers.TestCheckerUtil;
import org.jetbrains.kotlin.checkers.diagnostics.ActualDiagnostic;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.test.ConfigurationKind;
import org.jetbrains.kotlin.test.KotlinTestWithEnvironment;
import org.jetbrains.kotlin.test.util.KtTestUtil;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0014J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\rH\u0002J\u0006\u0010\u000e\u001a\u00020\tJ\u0006\u0010\u000f\u001a\u00020\tJ\u0006\u0010\u0010\u001a\u00020\tJ\u0006\u0010\u0011\u001a\u00020\tJ\u0006\u0010\u0012\u001a\u00020\tJ\u0006\u0010\u0013\u001a\u00020\tJ\u0006\u0010\u0014\u001a\u00020\tJ\u0006\u0010\u0015\u001a\u00020\tR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/checkers/CheckerTestUtilTest;", "Lorg/jetbrains/kotlin/test/KotlinTestWithEnvironment;", "()V", "diagnostics", "", "Lorg/jetbrains/kotlin/checkers/DiagnosticData;", "createEnvironment", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "doTest", "", "test", "Lorg/jetbrains/kotlin/checkers/Test;", "getTestDataPath", "", "testAbstractJetDiagnosticsTest", "testBoth", "testEquals", "testMissing", "testMissingInTheMiddle", "testUnexpected", "testWrongParameterInMultiRange", "testWrongParameters", "Companion", "tests-common"})
public final class CheckerTestUtilTest
extends KotlinTestWithEnvironment {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<DiagnosticData> diagnostics;

    public CheckerTestUtilTest() {
        Object[] objectArray = new DiagnosticData[]{new DiagnosticData(0, 0, "UNUSED_PARAMETER", 8, 9), new DiagnosticData(1, 1, "CONSTANT_EXPECTED_TYPE_MISMATCH", 56, 57), new DiagnosticData(2, 2, "UNUSED_VARIABLE", 67, 68), new DiagnosticData(3, 3, "TYPE_MISMATCH", 98, 99), new DiagnosticData(4, 4, "NONE_APPLICABLE", 120, 121), new DiagnosticData(5, 5, "TYPE_MISMATCH", 159, 167), new DiagnosticData(6, 6, "UNRESOLVED_REFERENCE", 164, 166), new DiagnosticData(7, 6, "TOO_MANY_ARGUMENTS", 164, 166)};
        this.diagnostics = CollectionsKt.listOf((Object[])objectArray);
    }

    private final String getTestDataPath() {
        return Intrinsics.stringPlus((String)KtTestUtil.getTestDataPathBase(), (Object)"/diagnostics/checkerTestUtil");
    }

    @Override
    @NotNull
    protected KotlinCoreEnvironment createEnvironment() {
        KotlinCoreEnvironment kotlinCoreEnvironment = this.createEnvironmentWithMockJdk(ConfigurationKind.ALL);
        Intrinsics.checkNotNullExpressionValue((Object)kotlinCoreEnvironment, (String)"createEnvironmentWithMockJdk(ConfigurationKind.ALL)");
        return kotlinCoreEnvironment;
    }

    private final void doTest(Test test2) {
        KtFile ktFile = TestCheckerUtil.createCheckAndReturnPsiFile("test.kt", KtTestUtil.doLoadFile((String)this.getTestDataPath(), (String)"test.kt"), this.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"createCheckAndReturnPsiFile(\n            \"test.kt\",\n            KtTestUtil.doLoadFile(getTestDataPath(), \"test.kt\"),\n            project\n        )");
        PsiFile psiFile = (PsiFile)ktFile;
        ktFile = this.getEnvironment();
        Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"environment");
        test2.test(psiFile, (KotlinCoreEnvironment)ktFile);
    }

    public final void testEquals() {
        String[] stringArray = new String[]{};
        this.doTest(new Test(stringArray){

            public void makeTestData(@NotNull List<ActualDiagnostic> diagnostics, @NotNull List<DiagnosedRange> diagnosedRanges) {
                Intrinsics.checkNotNullParameter(diagnostics, (String)"diagnostics");
                Intrinsics.checkNotNullParameter(diagnosedRanges, (String)"diagnosedRanges");
            }
        });
    }

    public final void testMissing() {
        DiagnosticData typeMismatch1 = this.diagnostics.get(1);
        String[] stringArray = new String[]{CheckerTestUtilTest.Companion.missing(typeMismatch1)};
        String[] stringArray2 = stringArray;
        this.doTest(new Test(typeMismatch1, stringArray2){
            final /* synthetic */ DiagnosticData $typeMismatch1;
            {
                this.$typeMismatch1 = $typeMismatch1;
                super($super_call_param$1);
            }

            public void makeTestData(@NotNull List<ActualDiagnostic> diagnostics, @NotNull List<DiagnosedRange> diagnosedRanges) {
                Intrinsics.checkNotNullParameter(diagnostics, (String)"diagnostics");
                Intrinsics.checkNotNullParameter(diagnosedRanges, (String)"diagnosedRanges");
                diagnostics.remove(this.$typeMismatch1.getIndex());
            }
        });
    }

    public final void testUnexpected() {
        DiagnosticData typeMismatch1 = this.diagnostics.get(1);
        String[] stringArray = new String[]{CheckerTestUtilTest.Companion.unexpected(typeMismatch1)};
        String[] stringArray2 = stringArray;
        this.doTest(new Test(typeMismatch1, stringArray2){
            final /* synthetic */ DiagnosticData $typeMismatch1;
            {
                this.$typeMismatch1 = $typeMismatch1;
                super($super_call_param$1);
            }

            public void makeTestData(@NotNull List<ActualDiagnostic> diagnostics, @NotNull List<DiagnosedRange> diagnosedRanges) {
                Intrinsics.checkNotNullParameter(diagnostics, (String)"diagnostics");
                Intrinsics.checkNotNullParameter(diagnosedRanges, (String)"diagnosedRanges");
                diagnosedRanges.remove(this.$typeMismatch1.getIndex());
            }
        });
    }

    public final void testBoth() {
        DiagnosticData typeMismatch1 = this.diagnostics.get(1);
        DiagnosticData unresolvedReference = this.diagnostics.get(6);
        String[] stringArray = new String[]{CheckerTestUtilTest.Companion.unexpected(typeMismatch1), CheckerTestUtilTest.Companion.missing(unresolvedReference)};
        String[] stringArray2 = stringArray;
        this.doTest(new Test(typeMismatch1, unresolvedReference, stringArray2){
            final /* synthetic */ DiagnosticData $typeMismatch1;
            final /* synthetic */ DiagnosticData $unresolvedReference;
            {
                this.$typeMismatch1 = $typeMismatch1;
                this.$unresolvedReference = $unresolvedReference;
                super($super_call_param$1);
            }

            public void makeTestData(@NotNull List<ActualDiagnostic> diagnostics, @NotNull List<DiagnosedRange> diagnosedRanges) {
                Intrinsics.checkNotNullParameter(diagnostics, (String)"diagnostics");
                Intrinsics.checkNotNullParameter(diagnosedRanges, (String)"diagnosedRanges");
                diagnosedRanges.remove(this.$typeMismatch1.getRangeIndex());
                diagnostics.remove(this.$unresolvedReference.getIndex());
            }
        });
    }

    public final void testMissingInTheMiddle() {
        DiagnosticData noneApplicable = this.diagnostics.get(4);
        DiagnosticData typeMismatch3 = this.diagnostics.get(5);
        String[] stringArray = new String[]{CheckerTestUtilTest.Companion.unexpected(noneApplicable), CheckerTestUtilTest.Companion.missing(typeMismatch3)};
        String[] stringArray2 = stringArray;
        this.doTest(new Test(noneApplicable, typeMismatch3, stringArray2){
            final /* synthetic */ DiagnosticData $noneApplicable;
            final /* synthetic */ DiagnosticData $typeMismatch3;
            {
                this.$noneApplicable = $noneApplicable;
                this.$typeMismatch3 = $typeMismatch3;
                super($super_call_param$1);
            }

            public void makeTestData(@NotNull List<ActualDiagnostic> diagnostics, @NotNull List<DiagnosedRange> diagnosedRanges) {
                Intrinsics.checkNotNullParameter(diagnostics, (String)"diagnostics");
                Intrinsics.checkNotNullParameter(diagnosedRanges, (String)"diagnosedRanges");
                diagnosedRanges.remove(this.$noneApplicable.getRangeIndex());
                diagnostics.remove(this.$typeMismatch3.getIndex());
            }
        });
    }

    public final void testWrongParameters() {
        DiagnosticData unused = this.diagnostics.get(2);
        String[] stringArray = new String[]{"i"};
        String unusedDiagnostic = CheckerTestUtilTest.Companion.asTextDiagnostic(unused, stringArray);
        String[] stringArray2 = new String[]{unusedDiagnostic};
        DiagnosedRange range = CheckerTestUtilTest.Companion.asDiagnosticRange(unused, stringArray2);
        String wrongParameter = Companion.wrongParameters(unusedDiagnostic, "OI;UNUSED_VARIABLE(a)", unused.getStartOffset(), unused.getEndOffset());
        String[] stringArray3 = new String[]{wrongParameter};
        String[] stringArray4 = stringArray3;
        this.doTest(new Test(unused, range, stringArray4){
            final /* synthetic */ DiagnosticData $unused;
            final /* synthetic */ DiagnosedRange $range;
            {
                this.$unused = $unused;
                this.$range = $range;
                super($super_call_param$1);
            }

            public void makeTestData(@NotNull List<ActualDiagnostic> diagnostics, @NotNull List<DiagnosedRange> diagnosedRanges) {
                Intrinsics.checkNotNullParameter(diagnostics, (String)"diagnostics");
                Intrinsics.checkNotNullParameter(diagnosedRanges, (String)"diagnosedRanges");
                diagnosedRanges.set(this.$unused.getRangeIndex(), this.$range);
            }
        });
    }

    public final void testWrongParameterInMultiRange() {
        DiagnosticData unresolvedReference = this.diagnostics.get(6);
        String[] stringArray = new String[]{"i"};
        String unusedDiagnostic = CheckerTestUtilTest.Companion.asTextDiagnostic(unresolvedReference, stringArray);
        String toManyArguments = CheckerTestUtilTest.Companion.asTextDiagnostic(this.diagnostics.get(7), new String[0]);
        String[] stringArray2 = new String[]{unusedDiagnostic, toManyArguments};
        DiagnosedRange range = CheckerTestUtilTest.Companion.asDiagnosticRange(unresolvedReference, stringArray2);
        String wrongParameter = Companion.wrongParameters(unusedDiagnostic, "OI;UNRESOLVED_REFERENCE(xx)", unresolvedReference.getStartOffset(), unresolvedReference.getEndOffset());
        String[] stringArray3 = new String[]{wrongParameter};
        String[] stringArray4 = stringArray3;
        this.doTest(new Test(unresolvedReference, range, stringArray4){
            final /* synthetic */ DiagnosticData $unresolvedReference;
            final /* synthetic */ DiagnosedRange $range;
            {
                this.$unresolvedReference = $unresolvedReference;
                this.$range = $range;
                super($super_call_param$1);
            }

            public void makeTestData(@NotNull List<ActualDiagnostic> diagnostics, @NotNull List<DiagnosedRange> diagnosedRanges) {
                Intrinsics.checkNotNullParameter(diagnostics, (String)"diagnostics");
                Intrinsics.checkNotNullParameter(diagnosedRanges, (String)"diagnosedRanges");
                diagnosedRanges.set(this.$unresolvedReference.getRangeIndex(), this.$range);
            }
        });
    }

    public final void testAbstractJetDiagnosticsTest() {
        AbstractDiagnosticsTest test2 = new AbstractDiagnosticsTest(){
            {
                this.setUp();
            }
        };
        test2.doTest(this.getTestDataPath() + File.separatorChar + "test_with_diagnostic.kt");
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J)\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b\"\u00020\tH\u0002\u00a2\u0006\u0002\u0010\nJ)\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b\"\u00020\tH\u0002\u00a2\u0006\u0002\u0010\rJ\u001e\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0006H\u0002J\u001e\u0010\u0014\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0011J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0006H\u0002J&\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u0011\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/checkers/CheckerTestUtilTest$Companion;", "", "()V", "asDiagnosticRange", "Lorg/jetbrains/kotlin/checkers/DiagnosedRange;", "diagnosticData", "Lorg/jetbrains/kotlin/checkers/DiagnosticData;", "textDiagnostics", "", "", "(Lorg/jetbrains/kotlin/checkers/DiagnosticData;[Ljava/lang/String;)Lorg/jetbrains/kotlin/checkers/DiagnosedRange;", "asTextDiagnostic", "params", "(Lorg/jetbrains/kotlin/checkers/DiagnosticData;[Ljava/lang/String;)Ljava/lang/String;", "missing", "type", "expectedStart", "", "expectedEnd", "data", "unexpected", "actualStart", "actualEnd", "wrongParameters", "expected", "actual", "start", "end", "tests-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String wrongParameters(@NotNull String expected, @NotNull String actual2, int start, int end) {
            Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
            Intrinsics.checkNotNullParameter((Object)actual2, (String)"actual");
            return "Wrong parameters " + expected + " != " + actual2 + " at " + start + " to " + end;
        }

        @NotNull
        public final String unexpected(@NotNull String type, int actualStart, int actualEnd) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            return "Unexpected " + type + " at " + actualStart + " to " + actualEnd;
        }

        @NotNull
        public final String missing(@NotNull String type, int expectedStart, int expectedEnd) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            return "Missing " + type + " at " + expectedStart + " to " + expectedEnd;
        }

        private final String unexpected(DiagnosticData data) {
            return this.unexpected(data.getName(), data.getStartOffset(), data.getEndOffset());
        }

        private final String missing(DiagnosticData data) {
            return this.missing(data.getName(), data.getStartOffset(), data.getEndOffset());
        }

        private final String asTextDiagnostic(DiagnosticData diagnosticData, String ... params) {
            String string = Intrinsics.stringPlus((String)diagnosticData.getName(), (Object)"(");
            return ArraysKt.joinToString$default((Object[])params, (CharSequence)"; ", (CharSequence)string, (CharSequence)")", (int)0, null, null, (int)56, null);
        }

        private final DiagnosedRange asDiagnosticRange(DiagnosticData diagnosticData, String ... textDiagnostics) {
            DiagnosedRange range = new DiagnosedRange(diagnosticData.getStartOffset());
            range.setEnd(diagnosticData.getEndOffset());
            for (String textDiagnostic : textDiagnostics) {
                range.addDiagnostic(textDiagnostic);
            }
            return range;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

