/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.TestHelperGeneratorKt;
import org.jetbrains.kotlin.test.Directives;
import org.jetbrains.kotlin.test.InTextDirectivesUtils;
import org.jetbrains.kotlin.test.KotlinBaseTest;
import org.jetbrains.kotlin.test.KotlinTestUtils;

public class TestFiles {
    private static final String MODULE_DELIMITER = ",\\s*";
    private static final Pattern MODULE_PATTERN = Pattern.compile("//\\s*MODULE:\\s*([^()\\n]+)(?:\\(([^()]+(?:,\\s*[^()]+)*)\\))?\\s*(?:\\(([^()]+(?:,\\s*[^()]+)*)\\))?\n");
    private static final Pattern FILE_PATTERN = Pattern.compile("//\\s*FILE:\\s*(.*)\n");
    private static final Pattern LINE_SEPARATOR_PATTERN = Pattern.compile("\\r\\n|\\r|\\n");

    @NotNull
    public static <M extends KotlinBaseTest.TestModule, F> List<F> createTestFiles(@Nullable String testFileName, String expectedText, TestFileFactory<M, F> factory) {
        return TestFiles.createTestFiles(testFileName, expectedText, factory, false);
    }

    @NotNull
    public static <M extends KotlinBaseTest.TestModule, F> List<F> createTestFiles(String testFileName, String expectedText, TestFileFactory<M, F> factory, boolean preserveLocations) {
        return TestFiles.createTestFiles(testFileName, expectedText, factory, preserveLocations, false);
    }

    @NotNull
    public static <M extends KotlinBaseTest.TestModule, F> List<F> createTestFiles(String testFileName, String expectedText, TestFileFactory<M, F> factory, boolean preserveLocations, boolean parseDirectivesPerFile) {
        String commonPrefixOrWholeFile;
        HashMap<String, KotlinBaseTest.TestModule> modules = new HashMap<String, KotlinBaseTest.TestModule>();
        ArrayList testFiles = Lists.newArrayList();
        Matcher fileMatcher = FILE_PATTERN.matcher(expectedText);
        Matcher moduleMatcher = MODULE_PATTERN.matcher(expectedText);
        boolean hasModules = false;
        boolean fileFound = fileMatcher.find();
        boolean moduleFound = moduleMatcher.find();
        if (!fileFound && !moduleFound) {
            assert (testFileName != null) : "testFileName should not be null if no FILE directive defined";
            testFiles.add(factory.createFile(null, testFileName, expectedText, KotlinTestUtils.parseDirectives(expectedText)));
            commonPrefixOrWholeFile = expectedText;
        } else {
            boolean nextModuleExists;
            Directives allFilesOrCommonPrefixDirectives = parseDirectivesPerFile ? null : KotlinTestUtils.parseDirectives(expectedText);
            int processedChars = 0;
            KotlinBaseTest.TestModule module2 = null;
            boolean firstFileProcessed = false;
            int commonStart = moduleFound ? moduleMatcher.start() : fileMatcher.start();
            commonPrefixOrWholeFile = expectedText.substring(0, commonStart);
            do {
                boolean nextFileExists;
                if (moduleFound) {
                    String moduleName = moduleMatcher.group(1);
                    String moduleDependencies = moduleMatcher.group(2);
                    String moduleFriends = moduleMatcher.group(3);
                    if (moduleName != null) {
                        moduleName = moduleName.trim();
                        hasModules = true;
                        module2 = (KotlinBaseTest.TestModule)factory.createModule(moduleName, TestFiles.parseModuleList(moduleDependencies), TestFiles.parseModuleList(moduleFriends));
                        KotlinBaseTest.TestModule oldValue = modules.put(moduleName, module2);
                        assert (oldValue == null) : "Module with name " + moduleName + " already present in file";
                    }
                }
                moduleFound = nextModuleExists = moduleMatcher.find();
                do {
                    String fileName = fileMatcher.group(1);
                    int start = processedChars;
                    nextFileExists = fileMatcher.find();
                    int end = nextFileExists && nextModuleExists ? Math.min(fileMatcher.start(), moduleMatcher.start()) : (nextFileExists ? fileMatcher.start() : expectedText.length());
                    String fileText = preserveLocations ? TestFiles.substringKeepingLocations(expectedText, start, end) : expectedText.substring(start, end);
                    String expectedText1 = firstFileProcessed ? commonPrefixOrWholeFile + fileText : fileText;
                    testFiles.add(factory.createFile(module2, fileName, fileText, parseDirectivesPerFile ? KotlinTestUtils.parseDirectives(expectedText1) : allFilesOrCommonPrefixDirectives));
                    processedChars = end;
                    firstFileProcessed = true;
                } while ((nextFileExists || nextModuleExists) && (!nextModuleExists || fileMatcher.start() <= moduleMatcher.start()));
            } while (nextModuleExists);
            assert (processedChars == expectedText.length()) : "Characters skipped from " + processedChars + " to " + (expectedText.length() - 1);
        }
        if (InTextDirectivesUtils.isDirectiveDefined((String)expectedText, (String)"WITH_COROUTINES")) {
            KotlinBaseTest.TestModule supportModule;
            KotlinBaseTest.TestModule testModule = supportModule = hasModules ? (KotlinBaseTest.TestModule)factory.createModule("support", Collections.emptyList(), Collections.emptyList()) : null;
            if (supportModule != null) {
                KotlinBaseTest.TestModule oldValue = modules.put(supportModule.name, supportModule);
                assert (oldValue == null) : "Module with name " + supportModule.name + " already present in file";
            }
            boolean checkStateMachine = InTextDirectivesUtils.isDirectiveDefined((String)expectedText, (String)"CHECK_STATE_MACHINE");
            boolean checkTailCallOptimization = InTextDirectivesUtils.isDirectiveDefined((String)expectedText, (String)"CHECK_TAIL_CALL_OPTIMIZATION");
            testFiles.add(factory.createFile(supportModule, "CoroutineUtil.kt", TestHelperGeneratorKt.createTextForCoroutineHelpers(checkStateMachine, checkTailCallOptimization), KotlinTestUtils.parseDirectives(commonPrefixOrWholeFile)));
        }
        for (KotlinBaseTest.TestModule module3 : modules.values()) {
            if (module3 == null) continue;
            module3.getDependencies().addAll(module3.dependenciesSymbols.stream().map(name -> {
                KotlinBaseTest.TestModule dep = (KotlinBaseTest.TestModule)modules.get(name);
                assert (dep != null) : "Dependency not found:" + name + "for module " + module2.name;
                return dep;
            }).collect(Collectors.toList()));
            module3.getFriends().addAll(module3.friendsSymbols.stream().map(name -> {
                KotlinBaseTest.TestModule dep = (KotlinBaseTest.TestModule)modules.get(name);
                assert (dep != null) : "Dependency not found:" + name + "for module " + module2.name;
                return dep;
            }).collect(Collectors.toList()));
        }
        ArrayList arrayList = testFiles;
        if (arrayList == null) {
            TestFiles.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    private static String substringKeepingLocations(String string, int start, int end) {
        Matcher matcher = LINE_SEPARATOR_PATTERN.matcher(string);
        StringBuilder prefix = new StringBuilder();
        int lastLineOffset = 0;
        while (matcher.find() && matcher.end() <= start) {
            lastLineOffset = matcher.end();
            prefix.append('\n');
        }
        while (lastLineOffset++ < start) {
            prefix.append(' ');
        }
        return prefix + string.substring(start, end);
    }

    private static List<String> parseModuleList(@Nullable String dependencies) {
        if (dependencies == null) {
            return Collections.emptyList();
        }
        return StringsKt.split((CharSequence)dependencies, (Pattern)Pattern.compile(MODULE_DELIMITER), (int)0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/test/TestFiles", "createTestFiles"));
    }

    public static abstract class TestFileFactoryNoModules<F>
    implements TestFileFactory<KotlinBaseTest.TestModule, F> {
        @Override
        public final F createFile(@Nullable KotlinBaseTest.TestModule module2, @NotNull String fileName, @NotNull String text, @NotNull Directives directives) {
            if (fileName == null) {
                TestFileFactoryNoModules.$$$reportNull$$$0(0);
            }
            if (text == null) {
                TestFileFactoryNoModules.$$$reportNull$$$0(1);
            }
            if (directives == null) {
                TestFileFactoryNoModules.$$$reportNull$$$0(2);
            }
            return this.create(fileName, text, directives);
        }

        @NotNull
        public abstract F create(@NotNull String var1, @NotNull String var2, @NotNull Directives var3);

        @Override
        public KotlinBaseTest.TestModule createModule(@NotNull String name, @NotNull List<String> dependencies, @NotNull List<String> friends) {
            if (name == null) {
                TestFileFactoryNoModules.$$$reportNull$$$0(3);
            }
            if (dependencies == null) {
                TestFileFactoryNoModules.$$$reportNull$$$0(4);
            }
            if (friends == null) {
                TestFileFactoryNoModules.$$$reportNull$$$0(5);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "directives";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dependencies";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "friends";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/test/TestFiles$TestFileFactoryNoModules";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createFile";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createModule";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface TestFileFactory<M, F> {
        public F createFile(@Nullable M var1, @NotNull String var2, @NotNull String var3, @NotNull Directives var4);

        public M createModule(@NotNull String var1, @NotNull List<String> var2, @NotNull List<String> var3);
    }
}

