/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.checkers.CompilerTestLanguageVersionSettingsKt;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.CompilerConfigurationKey;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.test.AnalysisFlagExtractorKt;
import org.jetbrains.kotlin.test.ConfigurationKind;
import org.jetbrains.kotlin.test.Directives;
import org.jetbrains.kotlin.test.InTextDirectivesUtils;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestJdkKind;
import org.jetbrains.kotlin.test.testFramework.KtUsefulTestCase;
import org.jetbrains.kotlin.test.util.KtTestUtil;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 **\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0003*+,B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000eH\u0014JN\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00062\u000e\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u000e2\u000e\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u000e2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u000eH\u0004J\u001e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u000e2\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bH$J\u001e\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u00152\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000eH\u0014J\u0010\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020\u001bH\u0014J\u0016\u0010!\u001a\u00020\u00112\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000eH\u0014J\u0016\u0010\"\u001a\u00020\u00132\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000eH\u0014J\b\u0010#\u001a\u00020$H\u0014J\b\u0010%\u001a\u00020\nH\u0014J\u0010\u0010&\u001a\u00020\n2\u0006\u0010'\u001a\u00020(H\u0014J\u0010\u0010)\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014R\u0014\u0010\u0005\u001a\u00020\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/test/KotlinBaseTest;", "F", "Lorg/jetbrains/kotlin/test/KotlinBaseTest$TestFile;", "Lorg/jetbrains/kotlin/test/testFramework/KtUsefulTestCase;", "()V", "backend", "Lorg/jetbrains/kotlin/test/TargetBackend;", "getBackend", "()Lorg/jetbrains/kotlin/test/TargetBackend;", "configureTestSpecific", "", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "testFiles", "", "createConfiguration", "kind", "Lorg/jetbrains/kotlin/test/ConfigurationKind;", "jdkKind", "Lorg/jetbrains/kotlin/test/TestJdkKind;", "classpath", "Ljava/io/File;", "javaSource", "testFilesWithConfigurationDirectives", "createTestFilesFromFile", "file", "expectedText", "", "doMultiFileTest", "wholeFile", "files", "doTest", "filePath", "extractConfigurationKind", "getTestJdkKind", "parseDirectivesPerFiles", "", "setUp", "setupEnvironment", "environment", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "updateConfiguration", "Companion", "TestFile", "TestModule", "tests-common"})
public abstract class KotlinBaseTest<F extends TestFile>
extends KtUsefulTestCase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TargetBackend backend = TargetBackend.ANY;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void doTest(@NotNull String filePath) throws Exception {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        File file = new File(filePath);
        String expectedText = KtTestUtil.doLoadFile((File)file);
        Intrinsics.checkNotNullExpressionValue((Object)expectedText, (String)"expectedText");
        this.doMultiFileTest(file, this.createTestFilesFromFile(file, expectedText));
    }

    @NotNull
    protected abstract List<F> createTestFilesFromFile(@NotNull File var1, @NotNull String var2);

    protected void doMultiFileTest(@NotNull File wholeFile, @NotNull List<? extends F> files) throws Exception {
        Intrinsics.checkNotNullParameter((Object)wholeFile, (String)"wholeFile");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        throw new UnsupportedOperationException("Multi-file test cases are not supported in this test");
    }

    @NotNull
    protected TestJdkKind getTestJdkKind(@NotNull List<? extends F> files) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter(files, (String)"files");
            Iterable $this$any$iv = files;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TestFile file = (TestFile)element$iv;
                    boolean bl2 = false;
                    if (!InTextDirectivesUtils.isDirectiveDefined((String)file.content, (String)"JDK_15")) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            return TestJdkKind.FULL_JDK_15;
        }
        for (TestFile file : files) {
            if (!InTextDirectivesUtils.isDirectiveDefined((String)file.content, (String)"FULL_JDK")) continue;
            return TestJdkKind.FULL_JDK;
        }
        return TestJdkKind.MOCK_JDK;
    }

    @NotNull
    protected ConfigurationKind extractConfigurationKind(@NotNull List<? extends F> files) {
        Intrinsics.checkNotNullParameter(files, (String)"files");
        return Companion.extractConfigurationKind(files);
    }

    protected void updateConfiguration(@NotNull CompilerConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
    }

    protected void setupEnvironment(@NotNull KotlinCoreEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
    }

    protected boolean parseDirectivesPerFiles() {
        return false;
    }

    @NotNull
    protected TargetBackend getBackend() {
        return this.backend;
    }

    protected void configureTestSpecific(@NotNull CompilerConfiguration configuration, @NotNull List<? extends TestFile> testFiles) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter(testFiles, (String)"testFiles");
    }

    @NotNull
    protected final CompilerConfiguration createConfiguration(@NotNull ConfigurationKind kind, @NotNull TestJdkKind jdkKind, @NotNull TargetBackend backend, @NotNull List<? extends File> classpath, @NotNull List<? extends File> javaSource, @NotNull List<? extends TestFile> testFilesWithConfigurationDirectives) {
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        Intrinsics.checkNotNullParameter((Object)jdkKind, (String)"jdkKind");
        Intrinsics.checkNotNullParameter((Object)backend, (String)"backend");
        Intrinsics.checkNotNullParameter(classpath, (String)"classpath");
        Intrinsics.checkNotNullParameter(javaSource, (String)"javaSource");
        Intrinsics.checkNotNullParameter(testFilesWithConfigurationDirectives, (String)"testFilesWithConfigurationDirectives");
        CompilerConfiguration compilerConfiguration = KotlinTestUtils.newConfiguration(kind, jdkKind, classpath, javaSource);
        Intrinsics.checkNotNullExpressionValue((Object)compilerConfiguration, (String)"newConfiguration(kind, jdkKind, classpath, javaSource)");
        CompilerConfiguration configuration = compilerConfiguration;
        configuration.put(JVMConfigurationKeys.IR, (Object)backend.isIR());
        KotlinBaseTest.Companion.updateConfigurationByDirectivesInTestFiles(testFilesWithConfigurationDirectives, configuration, this.parseDirectivesPerFiles());
        this.updateConfiguration(configuration);
        this.configureTestSpecific(configuration, testFilesWithConfigurationDirectives);
        return configuration;
    }

    @JvmStatic
    public static final void updateConfigurationByDirectivesInTestFiles(@NotNull List<? extends TestFile> testFilesWithConfigurationDirectives, @NotNull CompilerConfiguration configuration) {
        Companion.updateConfigurationByDirectivesInTestFiles(testFilesWithConfigurationDirectives, configuration);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B!\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0011\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\n\u001a\u0004\u0018\u00010\rH\u0096\u0002J\b\u0010\u000e\u001a\u00020\tH\u0016J\b\u0010\u000f\u001a\u00020\u0003H\u0016R\u0010\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/test/KotlinBaseTest$TestFile;", "", "name", "", "content", "directives", "Lorg/jetbrains/kotlin/test/Directives;", "(Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/kotlin/test/Directives;)V", "compareTo", "", "other", "equals", "", "", "hashCode", "toString", "tests-common"})
    public static class TestFile
    implements Comparable<TestFile> {
        @JvmField
        @NotNull
        public final String name;
        @JvmField
        @NotNull
        public final String content;
        @JvmField
        @NotNull
        public final Directives directives;

        @JvmOverloads
        public TestFile(@NotNull String name, @NotNull String content2, @NotNull Directives directives) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
            Intrinsics.checkNotNullParameter((Object)directives, (String)"directives");
            this.name = name;
            this.content = content2;
            this.directives = directives;
        }

        public /* synthetic */ TestFile(String string, String string2, Directives directives, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                directives = new Directives();
            }
            this(string, string2, directives);
        }

        @Override
        public int compareTo(@NotNull TestFile other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return this.name.compareTo(other.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof TestFile && Intrinsics.areEqual((Object)((TestFile)other).name, (Object)this.name);
        }

        @NotNull
        public String toString() {
            return this.name;
        }

        @JvmOverloads
        public TestFile(@NotNull String name, @NotNull String content2) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
            this(name, content2, null, 4, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0007J\u0011\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0000H\u0096\u0002J\b\u0010\u0011\u001a\u00020\u0003H\u0016R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00000\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00000\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/test/KotlinBaseTest$TestModule;", "", "name", "", "dependenciesSymbols", "", "friendsSymbols", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;)V", "dependencies", "", "getDependencies", "()Ljava/util/List;", "friends", "getFriends", "compareTo", "", "other", "toString", "tests-common"})
    public static class TestModule
    implements Comparable<TestModule> {
        @JvmField
        @NotNull
        public final String name;
        @JvmField
        @NotNull
        public final List<String> dependenciesSymbols;
        @JvmField
        @NotNull
        public final List<String> friendsSymbols;
        @NotNull
        private final List<TestModule> dependencies;
        @NotNull
        private final List<TestModule> friends;

        public TestModule(@NotNull String name, @NotNull List<String> dependenciesSymbols, @NotNull List<String> friendsSymbols) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(dependenciesSymbols, (String)"dependenciesSymbols");
            Intrinsics.checkNotNullParameter(friendsSymbols, (String)"friendsSymbols");
            this.name = name;
            this.dependenciesSymbols = dependenciesSymbols;
            this.friendsSymbols = friendsSymbols;
            boolean bl = false;
            this.dependencies = new ArrayList();
            bl = false;
            this.friends = new ArrayList();
        }

        @NotNull
        public final List<TestModule> getDependencies() {
            return this.dependencies;
        }

        @NotNull
        public final List<TestModule> getFriends() {
            return this.friends;
        }

        @Override
        public int compareTo(@NotNull TestModule other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return this.name.compareTo(other.name);
        }

        @NotNull
        public String toString() {
            return this.name;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\u0014\u0010\b\u001a\u00020\t2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\u001e\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0007J&\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001e\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u0006H\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/test/KotlinBaseTest$Companion;", "", "()V", "extractConfigurationKind", "Lorg/jetbrains/kotlin/test/ConfigurationKind;", "files", "", "Lorg/jetbrains/kotlin/test/KotlinBaseTest$TestFile;", "getTestJdkKind", "Lorg/jetbrains/kotlin/test/TestJdkKind;", "updateConfigurationByDirectivesInTestFiles", "", "testFilesWithConfigurationDirectives", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "usePreparsedDirectives", "", "updateConfigurationWithFlags", "flags", "", "tests-common"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void updateConfigurationByDirectivesInTestFiles(@NotNull List<? extends TestFile> testFilesWithConfigurationDirectives, @NotNull CompilerConfiguration configuration) {
            Intrinsics.checkNotNullParameter(testFilesWithConfigurationDirectives, (String)"testFilesWithConfigurationDirectives");
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            this.updateConfigurationByDirectivesInTestFiles(testFilesWithConfigurationDirectives, configuration, false);
        }

        private final void updateConfigurationByDirectivesInTestFiles(List<? extends TestFile> testFilesWithConfigurationDirectives, CompilerConfiguration configuration, boolean usePreparsedDirectives) {
            LanguageVersionSettings explicitLanguageVersionSettings = null;
            List kotlinConfigurationFlags = new ArrayList(0);
            for (TestFile testFile : testFilesWithConfigurationDirectives) {
                String version;
                boolean bl;
                String targetString;
                Directives directives;
                String content2 = testFile.content;
                if (usePreparsedDirectives) {
                    directives = testFile.directives;
                } else {
                    Directives directives2 = KotlinTestUtils.parseDirectives(content2);
                    Intrinsics.checkNotNullExpressionValue((Object)directives2, (String)"parseDirectives(content)");
                    directives = directives2;
                }
                Directives directives3 = directives;
                List<String> flags = directives3.listValues("KOTLIN_CONFIGURATION_FLAGS");
                if (flags != null) {
                    kotlinConfigurationFlags.addAll((Collection)flags);
                }
                if ((targetString = directives3.get("JVM_TARGET")) != null) {
                    JvmTarget jvmTarget = JvmTarget.Companion.fromString(targetString);
                    if (jvmTarget == null) {
                        String string = Intrinsics.stringPlus((String)"Unknown target: ", (Object)targetString);
                        bl = false;
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                    JvmTarget jvmTarget2 = jvmTarget;
                    configuration.put(JVMConfigurationKeys.JVM_TARGET, (Object)jvmTarget2);
                }
                if (directives3.contains("ENABLE_JVM_PREVIEW")) {
                    configuration.put(JVMConfigurationKeys.ENABLE_JVM_PREVIEW, (Object)true);
                }
                if ((version = directives3.get("LANGUAGE_VERSION")) != null) {
                    throw new AssertionError((Object)"Do not use LANGUAGE_VERSION directive in compiler tests because it's prone to limiting the test\nto a specific language version, which will become obsolete at some point and the test won't check\nthings like feature intersection with newer releases. Use `// !LANGUAGE: [+-]FeatureName` directive instead,\nwhere FeatureName is an entry of the enum `LanguageFeature`\n");
                }
                LanguageVersionSettings fileLanguageVersionSettings = CompilerTestLanguageVersionSettingsKt.parseLanguageVersionSettings(directives3);
                if (fileLanguageVersionSettings == null) continue;
                boolean bl2 = explicitLanguageVersionSettings == null;
                bl = false;
                if (_Assertions.ENABLED && !bl2) {
                    boolean bl3 = false;
                    String string = "Should not specify !LANGUAGE directive twice";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                explicitLanguageVersionSettings = fileLanguageVersionSettings;
            }
            if (explicitLanguageVersionSettings != null) {
                CommonConfigurationKeysKt.setLanguageVersionSettings((CompilerConfiguration)configuration, explicitLanguageVersionSettings);
            }
            this.updateConfigurationWithFlags(configuration, kotlinConfigurationFlags);
        }

        private final void updateConfigurationWithFlags(CompilerConfiguration configuration, List<String> flags) {
            Map configurationFlags = AnalysisFlagExtractorKt.parseAnalysisFlags(flags);
            Iterable $this$forEach$iv = configurationFlags.entrySet();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry $dstr$key$value = (Map.Entry)element$iv;
                boolean bl = false;
                Map.Entry entry = $dstr$key$value;
                boolean bl2 = false;
                CompilerConfigurationKey key = (CompilerConfigurationKey)entry.getKey();
                Map.Entry entry2 = $dstr$key$value;
                boolean bl3 = false;
                Object value = entry2.getValue();
                configuration.put(key, value);
            }
        }

        @NotNull
        public final ConfigurationKind extractConfigurationKind(@NotNull List<? extends TestFile> files) {
            Intrinsics.checkNotNullParameter(files, (String)"files");
            boolean addRuntime = false;
            boolean addReflect = false;
            for (TestFile testFile : files) {
                if (InTextDirectivesUtils.isDirectiveDefined((String)testFile.content, (String)"WITH_RUNTIME")) {
                    addRuntime = true;
                }
                if (InTextDirectivesUtils.isDirectiveDefined((String)testFile.content, (String)"WITH_STDLIB")) {
                    addRuntime = true;
                }
                if (!InTextDirectivesUtils.isDirectiveDefined((String)testFile.content, (String)"WITH_REFLECT")) continue;
                addReflect = true;
            }
            return addReflect ? ConfigurationKind.ALL : (addRuntime ? ConfigurationKind.NO_KOTLIN_REFLECT : ConfigurationKind.JDK_ONLY);
        }

        @NotNull
        public final TestJdkKind getTestJdkKind(@NotNull List<? extends TestFile> files) {
            Intrinsics.checkNotNullParameter(files, (String)"files");
            for (TestFile testFile : files) {
                if (!InTextDirectivesUtils.isDirectiveDefined((String)testFile.content, (String)"FULL_JDK")) continue;
                return TestJdkKind.FULL_JDK;
            }
            return TestJdkKind.MOCK_JDK;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

