/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.checkers;

import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.reflect.KDeclarationContainer;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ObsoleteTestInfrastructure;
import org.jetbrains.kotlin.TestsCompilerError;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.analyzer.common.CommonResolverForModuleFactory;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.jvm.JvmBuiltIns;
import org.jetbrains.kotlin.checkers.AbstractDiagnosticsTest;
import org.jetbrains.kotlin.checkers.BaseDiagnosticsTest;
import org.jetbrains.kotlin.checkers.CompilerTestLanguageVersionSettings;
import org.jetbrains.kotlin.checkers.LazyOperationsLog;
import org.jetbrains.kotlin.checkers.LoggingStorageManager;
import org.jetbrains.kotlin.cli.common.messages.AnalyzerWithCompilerReport;
import org.jetbrains.kotlin.cli.common.messages.GroupingMessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageRenderer;
import org.jetbrains.kotlin.cli.common.messages.PrintingMessageCollector;
import org.jetbrains.kotlin.cli.jvm.compiler.JvmPackagePartProvider;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.compiler.NoScopeRecordCliBindingTrace;
import org.jetbrains.kotlin.cli.jvm.compiler.TopDownAnalyzerFacadeForJVM;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.config.LanguageVersionSettingsImpl;
import org.jetbrains.kotlin.container.ComponentProvider;
import org.jetbrains.kotlin.container.DslKt;
import org.jetbrains.kotlin.container.StorageComponentContainer;
import org.jetbrains.kotlin.context.ContextKt;
import org.jetbrains.kotlin.context.GlobalContext;
import org.jetbrains.kotlin.context.ModuleContext;
import org.jetbrains.kotlin.context.ProjectContext;
import org.jetbrains.kotlin.context.SimpleGlobalContext;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleCapability;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentProvider;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.descriptors.impl.CompositePackageFragmentProvider;
import org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters1;
import org.jetbrains.kotlin.diagnostics.DiagnosticWithParameters2;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.GenericDiagnostics;
import org.jetbrains.kotlin.diagnostics.PsiDiagnosticUtils;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.frontend.java.di.InjectionKt;
import org.jetbrains.kotlin.incremental.components.ExpectActualTracker;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.load.java.lazy.ModuleClassResolver;
import org.jetbrains.kotlin.load.java.lazy.SingleModuleClassResolver;
import org.jetbrains.kotlin.load.kotlin.PackagePartProvider;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.platform.CommonPlatforms;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.TargetPlatformKt;
import org.jetbrains.kotlin.platform.jvm.JvmPlatforms;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.AnalyzingUtils;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.CompilerEnvironment;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.LazyTopDownAnalyzer;
import org.jetbrains.kotlin.resolve.TargetEnvironment;
import org.jetbrains.kotlin.resolve.TopDownAnalysisMode;
import org.jetbrains.kotlin.resolve.calls.model.MutableResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.jvm.JavaDescriptorResolver;
import org.jetbrains.kotlin.resolve.lazy.KotlinCodeAnalyzer;
import org.jetbrains.kotlin.resolve.lazy.declarations.DeclarationProviderFactory;
import org.jetbrains.kotlin.resolve.lazy.declarations.FileBasedDeclarationProviderFactory;
import org.jetbrains.kotlin.storage.ExceptionTracker;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.test.InTextDirectivesUtils;
import org.jetbrains.kotlin.test.KotlinBaseTest;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.testFramework.KtUsefulTestCase;
import org.jetbrains.kotlin.test.util.DescriptorValidator;
import org.jetbrains.kotlin.test.util.RecursiveDescriptorComparator;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;
import org.junit.Assert;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@ObsoleteTestInfrastructure(replacer="org.jetbrains.kotlin.test.runners.AbstractDiagnosticTest")
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00c8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u0000 X2\u00020\u0001:\u0001XB\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0010\u0010\u0007\u001a\f\u0012\b\u0012\u00060\tR\u00020\u00010\bH\u0014J\"\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0010\u0010\u0007\u001a\f\u0012\b\u0012\u00060\tR\u00020\u00010\bH\u0002J>\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u000f0\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014J*\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001a2\u0010\u0010\u001b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u0013H\u0002J&\u0010\u001f\u001a\u00020\u00042\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000f0\b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001e\u001a\u00020\u0013H\u0002J\u0018\u0010#\u001a\u00020\u00042\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\"\u0010&\u001a\u00020\u00042\u0006\u0010'\u001a\u00020\u00062\u0010\u0010(\u001a\f\u0012\b\u0012\u00060\tR\u00020\u00010\bH\u0002J\u001a\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010+\u001a\u00020,2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010-\u001a\u00020\u00042\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001e\u001a\u00020\u0013H\u0002J\u0018\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020%2\u0006\u00101\u001a\u000202H\u0014J>\u00103\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u000105\u0012\u0004\u0012\u00020/042\u001e\u00106\u001a\u001a\u0012\u0006\u0012\u0004\u0018\u000105\u0012\u000e\u0012\f\u0012\b\u0012\u00060\tR\u00020\u00010\b072\u0006\u00101\u001a\u000202H\u0002J\u0010\u00108\u001a\u00020/2\u0006\u00101\u001a\u000202H\u0014J(\u00109\u001a\u00020:2\u0010\u0010(\u001a\f\u0012\b\u0012\u00060\tR\u00020\u00010\b2\f\u0010;\u001a\b\u0012\u0004\u0012\u00020<0\u001cH\u0002J\b\u0010=\u001a\u00020\u0013H\u0014J\u0016\u0010>\u001a\b\u0012\u0004\u0012\u00020/0\b2\u0006\u0010?\u001a\u00020/H\u0014J\u0016\u0010@\u001a\b\u0012\u0004\u0012\u00020\u000f0\b2\u0006\u0010A\u001a\u00020/H\u0002J\"\u0010B\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00062\u0010\u0010\u0007\u001a\f\u0012\b\u0012\u00060\tR\u00020\u00010\bH\u0014J\u0010\u0010C\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\u0014\u0010D\u001a\u00020E2\n\u0010F\u001a\u00060\tR\u00020\u0001H\u0002J\u0010\u0010G\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001c\u0010H\u001a\b\u0012\u0004\u0012\u00020E0I2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u000f0\bH\u0002J\u001a\u0010J\u001a\u00020\u00172\u0010\u0010?\u001a\f\u0012\b\u0012\u00060\tR\u00020\u00010\bH\u0014J\u001a\u0010K\u001a\u00020\u00132\u0010\u0010?\u001a\f\u0012\b\u0012\u00060\tR\u00020\u00010\bH\u0014J\u0084\u0001\u0010L\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0010\u0010(\u001a\f\u0012\b\u0012\u00060\tR\u00020\u00010\b2\u001e\u0010M\u001a\u001a\u0012\u0006\u0012\u0004\u0018\u000105\u0012\u000e\u0012\f\u0012\b\u0012\u00060\tR\u00020\u00010\b072\u0014\u0010N\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u000105\u0012\u0004\u0012\u00020/072\u0014\u0010O\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u000105\u0012\u0004\u0012\u00020\"072\u0014\u0010P\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u000105\u0012\u0004\u0012\u00020\u001307H\u0014J(\u0010Q\u001a\u00020\u00152\u001e\u00106\u001a\u001a\u0012\u0006\u0012\u0004\u0018\u000105\u0012\u000e\u0012\f\u0012\b\u0012\u00060\tR\u00020\u00010\b07H\u0014J\u0010\u0010R\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\b\u0010S\u001a\u00020\u0015H\u0014J8\u0010T\u001a\u00020\u00042\u0006\u0010'\u001a\u00020\u00062\u0010\u0010(\u001a\f\u0012\b\u0012\u00060\tR\u00020\u00010\b2\u0014\u0010;\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u000105\u0012\u0004\u0012\u00020/07H\u0002J\u0010\u0010U\u001a\u00020%*\u00060Vj\u0002`WH\u0002\u00a8\u0006Y"}, d2={"Lorg/jetbrains/kotlin/checkers/AbstractDiagnosticsTest;", "Lorg/jetbrains/kotlin/checkers/BaseDiagnosticsTest;", "()V", "analyzeAndCheck", "", "testDataFile", "Ljava/io/File;", "files", "", "Lorg/jetbrains/kotlin/checkers/BaseDiagnosticsTest$TestFile;", "analyzeAndCheckUnhandled", "analyzeModuleContents", "Lorg/jetbrains/kotlin/analyzer/AnalysisResult;", "moduleContext", "Lorg/jetbrains/kotlin/context/ModuleContext;", "Lorg/jetbrains/kotlin/psi/KtFile;", "moduleTrace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "separateModules", "", "jvmTarget", "Lorg/jetbrains/kotlin/config/JvmTarget;", "assertResolvedCallsAreCompleted", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "resolvedCalls", "", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "configuredLanguageVersionSettings", "checkAllResolvedCallsAreCompleted", "ktFiles", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "checkDiagnostics", "actualText", "", "checkDynamicCallDescriptors", "expectedFile", "testFiles", "checkLazyResolveLog", "", "lazyOperationsLog", "Lorg/jetbrains/kotlin/checkers/LazyOperationsLog;", "checkResolvedCallsInDiagnostics", "createModule", "Lorg/jetbrains/kotlin/descriptors/impl/ModuleDescriptorImpl;", "moduleName", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "createModules", "", "Lorg/jetbrains/kotlin/checkers/BaseDiagnosticsTest$TestModule;", "groupedByModule", "", "createSealedModule", "createdAffectedPackagesConfiguration", "Lorg/jetbrains/kotlin/test/util/RecursiveDescriptorComparator$Configuration;", "modules", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "defaultLanguageVersionSettings", "getAdditionalDependencies", "module", "getCommonCodeFilesForPlatformSpecificModule", "moduleDescriptor", "getExpectedDescriptorFile", "getExpectedDiagnosticsFile", "getJavaFilePackage", "Lorg/jetbrains/kotlin/name/Name;", "testFile", "getLazyLogFile", "getTopLevelPackagesFromFileList", "", "loadJvmTarget", "loadLanguageVersionSettings", "performAdditionalChecksAfterDiagnostics", "moduleFiles", "moduleDescriptors", "moduleBindings", "languageVersionSettingsByModule", "shouldSkipJvmSignatureDiagnostics", "shouldValidateFirTestData", "skipDescriptorsValidation", "validateAndCompareDescriptorWithFile", "cleanupInferenceDiagnostics", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "Companion", "tests-common"})
public abstract class AbstractDiagnosticsTest
extends BaseDiagnosticsTest {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private static final Function1<String, String> HASH_SANITIZER;
    @NotNull
    private static final ModuleCapability<List<KtFile>> MODULE_FILES;
    @NotNull
    private static final List<Name> NAMES_OF_CHECK_TYPE_HELPER;

    @Override
    protected void analyzeAndCheck(@NotNull File testDataFile, @NotNull List<BaseDiagnosticsTest.TestFile> files) {
        Intrinsics.checkNotNullParameter((Object)testDataFile, (String)"testDataFile");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        try {
            this.analyzeAndCheckUnhandled(testDataFile, files);
        }
        catch (AssertionError t) {
            throw t;
        }
        catch (AssertionFailedError t) {
            throw t;
        }
        catch (Throwable t) {
            throw new TestsCompilerError(t);
        }
    }

    protected boolean shouldValidateFirTestData(@NotNull File testDataFile) {
        Intrinsics.checkNotNullParameter((Object)testDataFile, (String)"testDataFile");
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final void analyzeAndCheckUnhandled(File testDataFile, List<BaseDiagnosticsTest.TestFile> files) {
        Object it;
        Object object;
        boolean bl;
        Iterable $this$any$iv;
        StorageManager storageManager;
        ExceptionTracker tracker;
        LazyOperationsLog lazyOperationsLog;
        Map groupedByModule;
        List answer$iv$iv$iv;
        Object $this$getOrPut$iv$iv$iv;
        Object p0;
        block30: {
            void $this$groupByTo$iv$iv;
            Iterable $this$groupBy$iv = files;
            boolean $i$f$groupBy = false;
            Iterable iterable = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object2;
                p0 = (BaseDiagnosticsTest.TestFile)element$iv$iv;
                boolean bl2 = false;
                BaseDiagnosticsTest.TestModule key$iv$iv = ((BaseDiagnosticsTest.TestFile)p0).getModule();
                $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut22 = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl3 = false;
                    answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object2 = answer$iv$iv$iv;
                } else {
                    object2 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object2;
                list$iv$iv.add(element$iv$iv);
            }
            groupedByModule = destination$iv$iv;
            lazyOperationsLog = null;
            tracker = new ExceptionTracker();
            storageManager = null;
            $this$any$iv = files;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    p0 = (BaseDiagnosticsTest.TestFile)element$iv;
                    boolean bl4 = false;
                    if (!((BaseDiagnosticsTest.TestFile)p0).getCheckLazyLog()) continue;
                    bl = true;
                    break block30;
                }
                bl = false;
            }
        }
        if (bl) {
            lazyOperationsLog = new LazyOperationsLog(HASH_SANITIZER);
            $this$any$iv = LockBasedStorageManager.createWithExceptionHandling((String)"AbstractDiagnosticTest", (LockBasedStorageManager.ExceptionHandlingStrategy)((LockBasedStorageManager.ExceptionHandlingStrategy)tracker));
            Intrinsics.checkNotNullExpressionValue((Object)$this$any$iv, (String)"createWithExceptionHandling(\"AbstractDiagnosticTest\", tracker)");
            storageManager = (StorageManager)new LoggingStorageManager((StorageManager)$this$any$iv, lazyOperationsLog.getAddRecordFunction());
        } else {
            $this$any$iv = LockBasedStorageManager.createWithExceptionHandling((String)"AbstractDiagnosticTest", (LockBasedStorageManager.ExceptionHandlingStrategy)((LockBasedStorageManager.ExceptionHandlingStrategy)tracker));
            Intrinsics.checkNotNullExpressionValue((Object)$this$any$iv, (String)"createWithExceptionHandling(\"AbstractDiagnosticTest\", tracker)");
            storageManager = (StorageManager)$this$any$iv;
        }
        SimpleGlobalContext context = new SimpleGlobalContext(storageManager, tracker);
        Map modules = this.createModules(groupedByModule, context.getStorageManager());
        HashMap moduleBindings = new HashMap();
        HashMap languageVersionSettingsByModule = new HashMap();
        Object bl4 = groupedByModule;
        boolean key$iv$iv = false;
        p0 = bl4.entrySet().iterator();
        while (p0.hasNext()) {
            BindingContext module22;
            Object object3;
            $this$getOrPut$iv$iv$iv = bl4 = (Map.Entry)p0.next();
            boolean $i$f$getOrPut22 = false;
            BaseDiagnosticsTest.TestModule testModule = (BaseDiagnosticsTest.TestModule)$this$getOrPut$iv$iv$iv.getKey();
            Object $i$f$getOrPut22 = bl4;
            boolean value$iv$iv$iv = false;
            List testFilesInModule = (List)$i$f$getOrPut22.getValue();
            List<KtFile> ktFiles = this.getKtFiles(testFilesInModule, true);
            answer$iv$iv$iv = modules.get(testModule);
            Intrinsics.checkNotNull((Object)answer$iv$iv$iv);
            List oldModule = answer$iv$iv$iv;
            LanguageVersionSettings languageVersionSettings = this.loadLanguageVersionSettings(testFilesInModule);
            Map map = languageVersionSettingsByModule;
            boolean bl5 = false;
            map.put(testModule, languageVersionSettings);
            ModuleContext moduleContext = ContextKt.withModule((ProjectContext)ContextKt.withProject((GlobalContext)((GlobalContext)context), (Project)this.getProject()), (ModuleDescriptor)((ModuleDescriptor)oldModule));
            boolean separateModules = groupedByModule.size() == 1 && CollectionsKt.single((Iterable)groupedByModule.keySet()) == null;
            AnalysisResult result = this.analyzeModuleContents(moduleContext, ktFiles, (BindingTrace)new NoScopeRecordCliBindingTrace(), languageVersionSettings, separateModules, this.loadJvmTarget(testFilesInModule));
            if (!Intrinsics.areEqual((Object)oldModule, (Object)result.getModuleDescriptor())) {
                object3 = modules;
                ModuleDescriptorImpl moduleDescriptorImpl = (ModuleDescriptorImpl)result.getModuleDescriptor();
                boolean bl6 = false;
                object3.put(testModule, moduleDescriptorImpl);
                for (BindingContext module22 : modules.values()) {
                    ListIterator<ModuleDescriptorImpl> it2 = TypeIntrinsics.asMutableList((Object)module22.getTestOnly_AllDependentModules()).listIterator();
                    while (it2.hasNext()) {
                        if (!Intrinsics.areEqual(it2.next(), (Object)oldModule)) continue;
                        it2.set((ModuleDescriptorImpl)result.getModuleDescriptor());
                    }
                }
            }
            object3 = moduleBindings;
            module22 = result.getBindingContext();
            boolean it2 = false;
            object3.put(testModule, module22);
            this.checkAllResolvedCallsAreCompleted(ktFiles, result.getBindingContext(), languageVersionSettings);
        }
        Throwable exceptionFromLazyResolveLogValidation = null;
        if (lazyOperationsLog != null) {
            exceptionFromLazyResolveLogValidation = this.checkLazyResolveLog(lazyOperationsLog, testDataFile);
        } else {
            File lazyLogFile = this.getLazyLogFile(testDataFile);
            KtUsefulTestCase.assertFalse((String)Intrinsics.stringPlus((String)"No lazy log expected, but found: ", (Object)lazyLogFile.getAbsolutePath()), (boolean)lazyLogFile.exists());
        }
        Throwable exceptionFromDescriptorValidation = null;
        try {
            File expectedFile = this.getExpectedDescriptorFile(testDataFile, files);
            this.validateAndCompareDescriptorWithFile(expectedFile, files, modules);
        }
        catch (Throwable e) {
            exceptionFromDescriptorValidation = e;
        }
        boolean ok = true;
        ByteArrayOutputStream diagnosticsFullTextByteArrayStream = new ByteArrayOutputStream();
        PrintStream diagnosticsFullTextPrintStream = new PrintStream(diagnosticsFullTextByteArrayStream);
        boolean shouldCheckDiagnosticsFullText = false;
        GroupingMessageCollector diagnosticsFullTextCollector = new GroupingMessageCollector((MessageCollector)new PrintingMessageCollector(diagnosticsFullTextPrintStream, MessageRenderer.SYSTEM_INDEPENDENT_RELATIVE_PATHS, true), false);
        StringBuilder actualText = new StringBuilder();
        for (BaseDiagnosticsTest.TestFile testFile : files) {
            void $this$mapNotNullTo$iv$iv;
            Iterable destination$iv$iv;
            List list;
            KotlinBaseTest.TestModule module3 = testFile.getModule();
            Map map = modules;
            boolean bl7 = false;
            ModuleDescriptorImpl it2 = map.get(module3);
            Intrinsics.checkNotNull((Object)it2);
            boolean isCommonModule = TargetPlatformKt.isCommon((TargetPlatform)it2.getPlatform());
            if (!isCommonModule) {
                list = CollectionsKt.emptyList();
            } else {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = modules.entrySet();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Map.Entry $dstr$testModule = (Map.Entry)element$iv$iv;
                    boolean bl8 = false;
                    List list2 = $dstr$testModule;
                    boolean bl9 = false;
                    BaseDiagnosticsTest.TestModule testModule = (BaseDiagnosticsTest.TestModule)list2.getKey();
                    list2 = (list2 = testModule) == null ? null : ((KotlinBaseTest.TestModule)((Object)list2)).getDependencies();
                    bl9 = false;
                    List list3 = list2;
                    if (list3 == null) {
                        list3 = CollectionsKt.emptyList();
                    }
                    if (!CollectionsKt.contains((Iterable)list3, (Object)module3)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list = (List)destination$iv$iv;
            }
            List implementingModules = list;
            Iterable $this$mapNotNull$iv = implementingModules;
            boolean $i$f$mapNotNull22 = false;
            destination$iv$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Pair pair;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl10 = false;
                Map.Entry $dstr$testModule$moduleDescriptor = (Map.Entry)element$iv$iv;
                boolean bl11 = false;
                Map.Entry entry = $dstr$testModule$moduleDescriptor;
                boolean bl12 = false;
                BaseDiagnosticsTest.TestModule testModule = (BaseDiagnosticsTest.TestModule)entry.getKey();
                Map.Entry entry2 = $dstr$testModule$moduleDescriptor;
                boolean bl13 = false;
                ModuleDescriptorImpl moduleDescriptor = (ModuleDescriptorImpl)entry2.getValue();
                TargetPlatform platform = moduleDescriptor.getPlatform();
                if (platform != null && !TargetPlatformKt.isCommon((TargetPlatform)platform)) {
                    BindingContext bindingContext = (BindingContext)moduleBindings.get(testModule);
                    Intrinsics.checkNotNull((Object)bindingContext);
                    pair = TuplesKt.to((Object)platform, (Object)bindingContext);
                } else {
                    pair = null;
                }
                if (pair == null) continue;
                Pair pair2 = pair;
                boolean bl14 = false;
                boolean bl15 = false;
                Pair it$iv$iv = pair2;
                boolean bl16 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            List implementingModulesBindings = (List)destination$iv$iv2;
            Map map2 = modules;
            boolean bl17 = false;
            ModuleDescriptorImpl $i$f$mapNotNull22 = (ModuleDescriptorImpl)map2.get(module3);
            Intrinsics.checkNotNull((Object)$i$f$mapNotNull22);
            ModuleDescriptorImpl moduleDescriptor = $i$f$mapNotNull22;
            Map map3 = moduleBindings;
            boolean bl18 = false;
            map2 = (BindingContext)map3.get(module3);
            Intrinsics.checkNotNull((Object)map2);
            Map moduleBindingContext = map2;
            boolean bl19 = this.shouldSkipJvmSignatureDiagnostics(groupedByModule) || isCommonModule;
            map3 = languageVersionSettingsByModule;
            bl18 = false;
            map2 = (LanguageVersionSettings)map3.get(module3);
            Intrinsics.checkNotNull((Object)map2);
            ok &= testFile.getActualText((BindingContext)moduleBindingContext, implementingModulesBindings, actualText, bl19, (LanguageVersionSettings)map2, moduleDescriptor);
            if (!testFile.getRenderDiagnosticsFullText()) continue;
            shouldCheckDiagnosticsFullText = true;
            map2 = moduleBindingContext.getDiagnostics();
            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"moduleBindingContext.diagnostics");
            AnalyzerWithCompilerReport.Companion.reportDiagnostics((GenericDiagnostics)map2, (MessageCollector)diagnosticsFullTextCollector);
        }
        Throwable exceptionFromDynamicCallDescriptorsValidation = null;
        try {
            File expectedFile = new File(Intrinsics.stringPlus((String)FileUtil.getNameWithoutExtension((String)testDataFile.getAbsolutePath()), (Object)".dynamic.txt"));
            this.checkDynamicCallDescriptors(expectedFile, files);
        }
        catch (Throwable e) {
            exceptionFromDynamicCallDescriptorsValidation = e;
        }
        if (shouldCheckDiagnosticsFullText) {
            diagnosticsFullTextCollector.flush();
            diagnosticsFullTextPrintStream.flush();
            File file = new File(Intrinsics.stringPlus((String)FileUtil.getNameWithoutExtension((String)testDataFile.getAbsolutePath()), (Object)".diag.txt"));
            object = diagnosticsFullTextByteArrayStream.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"diagnosticsFullTextByteArrayStream.toByteArray()");
            boolean bl20 = false;
            KotlinTestUtils.assertEqualsToFile(file, new String((byte[])object, Charsets.UTF_8));
        }
        this.checkDiagnostics(this.cleanupInferenceDiagnostics(actualText), testDataFile);
        KtUsefulTestCase.assertTrue((String)"Diagnostics mismatch. See the output above", (boolean)ok);
        object = exceptionFromDescriptorValidation;
        if (object != null) {
            Throwable throwable = object;
            boolean bl21 = false;
            boolean bl22 = false;
            it = throwable;
            boolean bl23 = false;
            throw it;
        }
        object = exceptionFromLazyResolveLogValidation;
        if (object != null) {
            Object object4 = object;
            boolean bl24 = false;
            boolean bl25 = false;
            it = object4;
            boolean bl26 = false;
            throw it;
        }
        object = exceptionFromDynamicCallDescriptorsValidation;
        if (object != null) {
            Object object5 = object;
            boolean bl27 = false;
            boolean bl28 = false;
            it = object5;
            boolean bl29 = false;
            throw it;
        }
        this.performAdditionalChecksAfterDiagnostics(testDataFile, files, groupedByModule, modules, moduleBindings, languageVersionSettingsByModule);
    }

    protected void checkDiagnostics(@NotNull String actualText, @NotNull File testDataFile) {
        Intrinsics.checkNotNullParameter((Object)actualText, (String)"actualText");
        Intrinsics.checkNotNullParameter((Object)testDataFile, (String)"testDataFile");
        KotlinTestUtils.assertEqualsToFile(this.getExpectedDiagnosticsFile(testDataFile), actualText);
    }

    private final String cleanupInferenceDiagnostics(StringBuilder $this$cleanupInferenceDiagnostics) {
        CharSequence charSequence = $this$cleanupInferenceDiagnostics;
        Regex regex = new Regex("NI;([\\S]*), OI;\\1([,!])");
        Function1 function1 = cleanupInferenceDiagnostics.1.INSTANCE;
        boolean bl = false;
        return regex.replace(charSequence, function1);
    }

    @NotNull
    protected File getExpectedDiagnosticsFile(@NotNull File testDataFile) {
        Intrinsics.checkNotNullParameter((Object)testDataFile, (String)"testDataFile");
        return testDataFile;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    protected File getExpectedDescriptorFile(@NotNull File testDataFile, @NotNull List<BaseDiagnosticsTest.TestFile> files) {
        block7: {
            block5: {
                block6: {
                    Intrinsics.checkNotNullParameter((Object)testDataFile, (String)"testDataFile");
                    Intrinsics.checkNotNullParameter(files, (String)"files");
                    originalTestFileText = FilesKt.readText$default((File)testDataFile, null, (int)1, null);
                    if (!InTextDirectivesUtils.isDirectiveDefined((String)originalTestFileText, (String)"// JAVAC_EXPECTED_FILE") || !this.getEnvironment().getConfiguration().getBoolean(JVMConfigurationKeys.USE_JAVAC)) break block6;
                    v0 = ".javac.txt";
                    break block7;
                }
                if (!InTextDirectivesUtils.isDirectiveDefined((String)originalTestFileText, (String)"// NI_EXPECTED_FILE")) ** GOTO lbl-1000
                $this$any$iv = files;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    v1 = false;
                } else {
                    for (T element$iv : $this$any$iv) {
                        it = (BaseDiagnosticsTest.TestFile)element$iv;
                        $i$a$-any-AbstractDiagnosticsTest$getExpectedDescriptorFile$postfix$1 = false;
                        if (!it.getNewInferenceEnabled()) continue;
                        v1 = true;
                        break block5;
                    }
                    v1 = false;
                }
            }
            if (v1 && !BaseDiagnosticsTest.Companion.getUSE_OLD_INFERENCE_DIAGNOSTICS_FOR_NI()) {
                v0 = ".ni.txt";
            } else lbl-1000:
            // 2 sources

            {
                v0 = ".txt";
            }
        }
        postfix = v0;
        return new File(Intrinsics.stringPlus((String)FileUtil.getNameWithoutExtension((String)testDataFile.getAbsolutePath()), (Object)postfix));
    }

    protected void performAdditionalChecksAfterDiagnostics(@NotNull File testDataFile, @NotNull List<BaseDiagnosticsTest.TestFile> testFiles, @NotNull Map<BaseDiagnosticsTest.TestModule, ? extends List<BaseDiagnosticsTest.TestFile>> moduleFiles, @NotNull Map<BaseDiagnosticsTest.TestModule, ModuleDescriptorImpl> moduleDescriptors, @NotNull Map<BaseDiagnosticsTest.TestModule, ? extends BindingContext> moduleBindings, @NotNull Map<BaseDiagnosticsTest.TestModule, ? extends LanguageVersionSettings> languageVersionSettingsByModule) {
        Intrinsics.checkNotNullParameter((Object)testDataFile, (String)"testDataFile");
        Intrinsics.checkNotNullParameter(testFiles, (String)"testFiles");
        Intrinsics.checkNotNullParameter(moduleFiles, (String)"moduleFiles");
        Intrinsics.checkNotNullParameter(moduleDescriptors, (String)"moduleDescriptors");
        Intrinsics.checkNotNullParameter(moduleBindings, (String)"moduleBindings");
        Intrinsics.checkNotNullParameter(languageVersionSettingsByModule, (String)"languageVersionSettingsByModule");
    }

    @NotNull
    protected LanguageVersionSettings loadLanguageVersionSettings(@NotNull List<BaseDiagnosticsTest.TestFile> module2) {
        Intrinsics.checkNotNullParameter(module2, (String)"module");
        LanguageVersionSettings result = null;
        for (BaseDiagnosticsTest.TestFile file : module2) {
            LanguageVersionSettings current = file.getCustomLanguageVersionSettings();
            if (current == null) continue;
            if (result != null && !Intrinsics.areEqual((Object)result, (Object)current)) {
                Assert.fail((String)"More than one file in the module has LANGUAGE or API_VERSION directive specified. This is not supported. Please move all directives into one file");
            }
            result = current;
        }
        LanguageVersionSettings languageVersionSettings = result;
        return languageVersionSettings == null ? this.defaultLanguageVersionSettings() : languageVersionSettings;
    }

    @NotNull
    protected LanguageVersionSettings defaultLanguageVersionSettings() {
        return new CompilerTestLanguageVersionSettings(BaseDiagnosticsTest.Companion.getDEFAULT_DIAGNOSTIC_TESTS_FEATURES(), LanguageVersionSettingsImpl.DEFAULT.getApiVersion(), LanguageVersionSettingsImpl.DEFAULT.getLanguageVersion(), null, 8, null);
    }

    @NotNull
    protected JvmTarget loadJvmTarget(@NotNull List<BaseDiagnosticsTest.TestFile> module2) {
        Intrinsics.checkNotNullParameter(module2, (String)"module");
        JvmTarget result = null;
        for (BaseDiagnosticsTest.TestFile file : module2) {
            JvmTarget current = file.getJvmTarget();
            if (current == null) continue;
            if (result != null && result != current) {
                Assert.fail((String)"More than one file in the module has JVM_TARGET directive specified. This is not supported. Please move all directives into one file");
            }
            result = current;
        }
        JvmTarget jvmTarget = result;
        return jvmTarget == null ? JvmTarget.DEFAULT : jvmTarget;
    }

    private final void checkDynamicCallDescriptors(File expectedFile, List<BaseDiagnosticsTest.TestFile> testFiles) {
        RecursiveDescriptorComparator serializer = new RecursiveDescriptorComparator(RecursiveDescriptorComparator.RECURSIVE_ALL);
        StringBuilder actualText = new StringBuilder();
        for (BaseDiagnosticsTest.TestFile testFile : testFiles) {
            for (DeclarationDescriptor descriptor : testFile.getDynamicCallDescriptors()) {
                String actualSerialized = serializer.serializeRecursively(descriptor);
                actualText.append(actualSerialized);
            }
        }
        CharSequence charSequence = actualText;
        boolean bl = false;
        if (charSequence.length() > 0 || expectedFile.exists()) {
            KotlinTestUtils.assertEqualsToFile(expectedFile, actualText.toString());
        }
    }

    protected boolean shouldSkipJvmSignatureDiagnostics(@NotNull Map<BaseDiagnosticsTest.TestModule, ? extends List<BaseDiagnosticsTest.TestFile>> groupedByModule) {
        Intrinsics.checkNotNullParameter(groupedByModule, (String)"groupedByModule");
        return groupedByModule.size() > 1;
    }

    private final Throwable checkLazyResolveLog(LazyOperationsLog lazyOperationsLog, File testDataFile) {
        Throwable throwable;
        try {
            File expectedFile = this.getLazyLogFile(testDataFile);
            KotlinTestUtils.assertEqualsToFile(expectedFile, lazyOperationsLog.getText(), HASH_SANITIZER);
            throwable = null;
        }
        catch (Throwable e) {
            throwable = e;
        }
        return throwable;
    }

    private final File getLazyLogFile(File testDataFile) {
        return new File(Intrinsics.stringPlus((String)FileUtil.getNameWithoutExtension((String)testDataFile.getAbsolutePath()), (Object)".lazy.log"));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected AnalysisResult analyzeModuleContents(@NotNull ModuleContext moduleContext, @NotNull List<? extends KtFile> files, @NotNull BindingTrace moduleTrace, @NotNull LanguageVersionSettings languageVersionSettings, boolean separateModules, @NotNull JvmTarget jvmTarget) {
        Intrinsics.checkNotNullParameter((Object)moduleContext, (String)"moduleContext");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        Intrinsics.checkNotNullParameter((Object)moduleTrace, (String)"moduleTrace");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        Intrinsics.checkNotNullParameter((Object)jvmTarget, (String)"jvmTarget");
        List files2 = files;
        if (separateModules) {
            void $this$analyzeModuleContents_u24lambda_u2d7;
            CompilerConfiguration compilerConfiguration = this.getEnvironment().getConfiguration().copy();
            boolean bl = false;
            boolean bl2 = false;
            CompilerConfiguration compilerConfiguration2 = compilerConfiguration;
            BindingTrace bindingTrace = moduleTrace;
            Collection collection = files2;
            Project project = moduleContext.getProject();
            boolean bl3 = false;
            Intrinsics.checkNotNullExpressionValue((Object)$this$analyzeModuleContents_u24lambda_u2d7, (String)"this");
            CommonConfigurationKeysKt.setLanguageVersionSettings((CompilerConfiguration)$this$analyzeModuleContents_u24lambda_u2d7, (LanguageVersionSettings)languageVersionSettings);
            $this$analyzeModuleContents_u24lambda_u2d7.put(JVMConfigurationKeys.JVM_TARGET, (Object)jvmTarget);
            Unit unit = Unit.INSTANCE;
            CompilerConfiguration compilerConfiguration3 = compilerConfiguration;
            Intrinsics.checkNotNullExpressionValue((Object)compilerConfiguration3, (String)"environment.configuration.copy().apply {\n                    this.languageVersionSettings = languageVersionSettings\n                    this.put(JVMConfigurationKeys.JVM_TARGET, jvmTarget)\n                }");
            return TopDownAnalyzerFacadeForJVM.analyzeFilesWithJavaIntegration$default((Project)project, (Collection)collection, (BindingTrace)bindingTrace, (CompilerConfiguration)compilerConfiguration3, (Function1)((Function1)new Function1<GlobalSearchScope, JvmPackagePartProvider>(this.getEnvironment()){

                @NotNull
                public final JvmPackagePartProvider invoke(@NotNull GlobalSearchScope p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return ((KotlinCoreEnvironment)this.receiver).createPackagePartProvider(p0);
                }

                @NotNull
                public final String getSignature() {
                    return "createPackagePartProvider(Lcom/intellij/psi/search/GlobalSearchScope;)Lorg/jetbrains/kotlin/cli/jvm/compiler/JvmPackagePartProvider;";
                }

                @NotNull
                public final String getName() {
                    return "createPackagePartProvider";
                }

                @NotNull
                public final KDeclarationContainer getOwner() {
                    return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(KotlinCoreEnvironment.class);
                }
            }), null, null, null, null, null, (int)992, null);
        }
        ModuleDescriptorImpl moduleDescriptor = (ModuleDescriptorImpl)moduleContext.getModule();
        TargetPlatform platform = moduleDescriptor.getPlatform();
        if (TargetPlatformKt.isCommon((TargetPlatform)platform)) {
            Collection collection = files2;
            Name name = moduleDescriptor.getName();
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"moduleDescriptor.name");
            return CommonResolverForModuleFactory.Companion.analyzeFiles$default((CommonResolverForModuleFactory.Companion)CommonResolverForModuleFactory.Companion, (Collection)collection, (Name)name, (boolean)true, (LanguageVersionSettings)languageVersionSettings, (TargetPlatform)CommonPlatforms.INSTANCE.getDefaultCommonPlatform(), (TargetEnvironment)((TargetEnvironment)CompilerEnvironment.INSTANCE), (Map)MapsKt.mapOf((Pair)TuplesKt.to(MODULE_FILES, (Object)files2)), null, (Function1)analyzeModuleContents.3.INSTANCE, (int)128, null);
        }
        if (platform != null) {
            files2 = CollectionsKt.plus((Collection)files2, (Iterable)this.getCommonCodeFilesForPlatformSpecificModule(moduleDescriptor));
        }
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)moduleContext.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(moduleContext.project)");
        GlobalSearchScope moduleContentScope = globalSearchScope;
        SingleModuleClassResolver moduleClassResolver = new SingleModuleClassResolver();
        StorageComponentContainer container = InjectionKt.createContainerForLazyResolveWithJava$default((TargetPlatform)JvmPlatforms.INSTANCE.jvmPlatformByTargetVersion(jvmTarget), (ModuleContext)moduleContext, (BindingTrace)moduleTrace, (DeclarationProviderFactory)((DeclarationProviderFactory)new FileBasedDeclarationProviderFactory(moduleContext.getStorageManager(), (Collection)files2)), (GlobalSearchScope)moduleContentScope, (ModuleClassResolver)((ModuleClassResolver)moduleClassResolver), (TargetEnvironment)((TargetEnvironment)CompilerEnvironment.INSTANCE), (LookupTracker)((LookupTracker)LookupTracker.DO_NOTHING.INSTANCE), (ExpectActualTracker)((ExpectActualTracker)ExpectActualTracker.DoNothing.INSTANCE), (PackagePartProvider)((PackagePartProvider)this.getEnvironment().createPackagePartProvider(moduleContentScope)), (LanguageVersionSettings)languageVersionSettings, (boolean)true, null, null, null, null, (int)61440, null);
        InjectionKt.initJvmBuiltInsForTopDownAnalysis((ComponentProvider)((ComponentProvider)container));
        ComponentProvider $this$get$iv = (ComponentProvider)container;
        boolean $i$f$get = false;
        moduleClassResolver.setResolver((JavaDescriptorResolver)DslKt.getService((ComponentProvider)$this$get$iv, JavaDescriptorResolver.class));
        $this$get$iv = new PackageFragmentProvider[2];
        ComponentProvider $this$get$iv2 = (ComponentProvider)container;
        boolean $i$f$get2 = false;
        $this$get$iv[0] = ((KotlinCodeAnalyzer)DslKt.getService((ComponentProvider)$this$get$iv2, KotlinCodeAnalyzer.class)).getPackageFragmentProvider();
        $this$get$iv2 = (ComponentProvider)container;
        $i$f$get2 = false;
        $this$get$iv[1] = (PackageFragmentProvider)((JavaDescriptorResolver)DslKt.getService((ComponentProvider)$this$get$iv2, JavaDescriptorResolver.class)).getPackageFragmentProvider();
        moduleDescriptor.initialize((PackageFragmentProvider)new CompositePackageFragmentProvider(CollectionsKt.listOf((Object[])$this$get$iv)));
        $this$get$iv = (ComponentProvider)container;
        $i$f$get = false;
        LazyTopDownAnalyzer.analyzeDeclarations$default((LazyTopDownAnalyzer)((LazyTopDownAnalyzer)DslKt.getService((ComponentProvider)$this$get$iv, LazyTopDownAnalyzer.class)), (TopDownAnalysisMode)TopDownAnalysisMode.TopLevelDeclarations, (Collection)files2, null, null, (int)12, null);
        BindingContext bindingContext = moduleTrace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"moduleTrace.bindingContext");
        return AnalysisResult.Companion.success(bindingContext, (ModuleDescriptor)moduleDescriptor);
    }

    private final List<KtFile> getCommonCodeFilesForPlatformSpecificModule(ModuleDescriptorImpl moduleDescriptor) {
        List dependencies = moduleDescriptor.getTestOnly_AllDependentModules();
        ArrayList result = new ArrayList(0);
        for (ModuleDescriptorImpl dependency : dependencies) {
            if (!TargetPlatformKt.isCommon((TargetPlatform)dependency.getPlatform())) continue;
            List list = (List)dependency.getCapability(MODULE_FILES);
            if (list == null) {
                String string = Intrinsics.stringPlus((String)"MODULE_FILES should have been set for the common module: ", (Object)dependency);
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            List files = list;
            result.addAll(files);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final void validateAndCompareDescriptorWithFile(File expectedFile, List<BaseDiagnosticsTest.TestFile> testFiles, Map<BaseDiagnosticsTest.TestModule, ModuleDescriptorImpl> modules) {
        Object[] objectArray;
        Object object;
        Object element$iv$iv22;
        Iterator $this$flatMapTo$iv$iv;
        boolean bl;
        block11: {
            if (this.skipDescriptorsValidation()) {
                return;
            }
            Iterable $this$any$iv = testFiles;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    BaseDiagnosticsTest.TestFile file = (BaseDiagnosticsTest.TestFile)element$iv;
                    boolean bl2 = false;
                    if (!InTextDirectivesUtils.isDirectiveDefined((String)file.getExpectedText(), (String)"// SKIP_TXT")) continue;
                    bl = true;
                    break block11;
                }
                bl = false;
            }
        }
        if (bl) {
            KtUsefulTestCase.assertFalse((String)Intrinsics.stringPlus((String)".txt file should not exist if SKIP_TXT directive is used: ", (Object)expectedFile), (boolean)expectedFile.exists());
            return;
        }
        RecursiveDescriptorComparator comparator = new RecursiveDescriptorComparator(this.createdAffectedPackagesConfiguration(testFiles, modules.values()));
        boolean isMultiModuleTest = modules.size() != 1;
        Iterable $this$flatMap$iv = testFiles;
        boolean $i$f$flatMap = false;
        Iterable bl2 = $this$flatMap$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Object object2 = $this$flatMapTo$iv$iv.iterator();
        while (object2.hasNext()) {
            void $this$mapTo$iv$iv;
            element$iv$iv22 = object2.next();
            BaseDiagnosticsTest.TestFile it = (BaseDiagnosticsTest.TestFile)element$iv$iv22;
            boolean bl3 = false;
            String[] stringArray = new String[]{"// RENDER_PACKAGE:"};
            object = InTextDirectivesUtils.findListWithPrefixes((String)it.getExpectedText(), (String[])stringArray);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"findListWithPrefixes(it.expectedText, \"// RENDER_PACKAGE:\")");
            Object[] $this$map$iv = (Object[])object;
            boolean $i$f$map = false;
            objectArray = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl4 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it2, (String)"it");
                void var26_42 = it2;
                boolean bl5 = false;
                FqName fqName = new FqName(((Object)StringsKt.trim((CharSequence)((CharSequence)var26_42))).toString());
                collection.add(fqName);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Set packages = CollectionsKt.toSet((Iterable)CollectionsKt.plus((Collection)((List)destination$iv$iv), (Object)FqName.ROOT));
        Map textByPackage2 = org.jetbrains.kotlin.utils.CollectionsKt.keysToMap((Iterable)packages, (Function1)validateAndCompareDescriptorWithFile.textByPackage.1.INSTANCE);
        List sortedModules = CollectionsKt.sortedWith((Iterable)modules.keySet(), AbstractDiagnosticsTest::validateAndCompareDescriptorWithFile$lambda-11);
        $this$flatMapTo$iv$iv = textByPackage2.entrySet().iterator();
        while ($this$flatMapTo$iv$iv.hasNext()) {
            object2 = destination$iv$iv = $this$flatMapTo$iv$iv.next();
            boolean element$iv$iv22 = false;
            FqName packageName = (FqName)object2.getKey();
            element$iv$iv22 = destination$iv$iv;
            boolean list$iv$iv = false;
            StringBuilder packageText = (StringBuilder)element$iv$iv22.getValue();
            Iterator module2 = sortedModules.iterator();
            while (module2.hasNext()) {
                ModuleDescriptorImpl bl3 = modules.get(module2.next());
                Intrinsics.checkNotNull((Object)bl3);
                ModuleDescriptorImpl moduleDescriptor = bl3;
                Intrinsics.checkNotNullExpressionValue((Object)packageName, (String)"packageName");
                PackageViewDescriptor aPackage = moduleDescriptor.getPackage(packageName);
                KtUsefulTestCase.assertFalse((boolean)aPackage.isEmpty());
                if (isMultiModuleTest) {
                    StringCompanionObject $i$f$map = StringCompanionObject.INSTANCE;
                    object = "// -- Module: %s --\n";
                    objectArray = new Object[]{moduleDescriptor.getName()};
                    boolean bl6 = false;
                    String string = String.format((String)object, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.lang.String.format(format, *args)");
                    packageText.append(string);
                }
                String actualSerialized = comparator.serializeRecursively((DeclarationDescriptor)aPackage);
                packageText.append(actualSerialized);
                if (!isMultiModuleTest || !module2.hasNext()) continue;
                packageText.append("\n\n");
            }
        }
        String allPackagesText = CollectionsKt.joinToString$default((Iterable)textByPackage2.values(), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
        int lineCount = StringUtil.getLineBreakCount((CharSequence)allPackagesText);
        boolean bl7 = lineCount < 1000;
        boolean bl8 = false;
        if (_Assertions.ENABLED && !bl7) {
            boolean bl9 = false;
            String string = "Rendered descriptors of this test take up " + lineCount + " lines. Please ensure you don't render JRE contents to the .txt file. Such tests are hard to maintain, take long time to execute and are subject to sudden unreviewed changes anyway.";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        KotlinTestUtils.assertEqualsToFile(expectedFile, allPackagesText);
    }

    protected boolean skipDescriptorsValidation() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final Name getJavaFilePackage(BaseDiagnosticsTest.TestFile testFile) {
        Pattern pattern = Pattern.compile("^\\s*package [.\\w\\d]*", 8);
        Matcher matcher = pattern.matcher(testFile.getExpectedText());
        if (matcher.find()) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Object object = testFile.getExpectedText();
            int n = matcher.start();
            int n2 = matcher.end();
            boolean bl = false;
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string = object.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            object = new String[]{" "};
            object = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)string, (String[])object, (boolean)false, (int)0, (int)6, null));
            boolean $i$f$filter = false;
            CharSequence charSequence = (CharSequence)$this$filter$iv;
            Appendable destination$iv$iv = new StringBuilder();
            boolean $i$f$filterTo = false;
            int n3 = 0;
            int n4 = $this$filterTo$iv$iv.length();
            while (n3 < n4) {
                void index$iv$iv;
                char element$iv$iv;
                char it = element$iv$iv = $this$filterTo$iv$iv.charAt((int)index$iv$iv);
                boolean bl2 = false;
                if (!CharsKt.isWhitespace((char)it)) {
                    destination$iv$iv.append(element$iv$iv);
                }
                ++index$iv$iv;
            }
            String string2 = ((StringBuilder)destination$iv$iv).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"filterTo(StringBuilder(), predicate).toString()");
            object = string2;
            n = 0;
            boolean bl3 = false;
            Object it = object;
            boolean bl4 = false;
            String[] stringArray = new String[]{"."};
            Name name = Name.identifier((String)((String)CollectionsKt.first((List)StringsKt.split$default((CharSequence)((CharSequence)it), (String[])stringArray, (boolean)false, (int)0, (int)6, null))));
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"testFile.expectedText\n                .substring(matcher.start(), matcher.end())\n                .split(\" \")\n                .last()\n                .filter { !it.isWhitespace() }\n                .let { Name.identifier(it.split(\".\").first()) }");
            return name;
        }
        Name name = SpecialNames.ROOT_PACKAGE;
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"ROOT_PACKAGE");
        return name;
    }

    /*
     * WARNING - void declaration
     */
    private final RecursiveDescriptorComparator.Configuration createdAffectedPackagesConfiguration(List<BaseDiagnosticsTest.TestFile> testFiles, Collection<? extends ModuleDescriptor> modules) {
        boolean bl;
        Set packagesNames;
        block5: {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            BaseDiagnosticsTest.TestFile it;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = testFiles;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (BaseDiagnosticsTest.TestFile)element$iv$iv;
                boolean bl2 = false;
                if (!(it.getKtFile() == null)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (BaseDiagnosticsTest.TestFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                Name name = this.getJavaFilePackage(it);
                collection.add(name);
            }
            packagesNames = CollectionsKt.toSet((Iterable)CollectionsKt.plus((Collection)((List)destination$iv$iv), (Iterable)this.getTopLevelPackagesFromFileList(this.getKtFiles(testFiles, false))));
            Iterable $this$any$iv = testFiles;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    BaseDiagnosticsTest.TestFile it2 = (BaseDiagnosticsTest.TestFile)element$iv;
                    boolean bl4 = false;
                    if (!it2.getDeclareCheckType()) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        boolean checkTypeEnabled = bl;
        Predicate<DeclarationDescriptor> stepIntoFilter = arg_0 -> AbstractDiagnosticsTest.createdAffectedPackagesConfiguration$lambda-18(modules, packagesNames, checkTypeEnabled, arg_0);
        RecursiveDescriptorComparator.Configuration configuration = RecursiveDescriptorComparator.RECURSIVE.filterRecursion(stepIntoFilter).withValidationStrategy(DescriptorValidator.ValidationVisitor.errorTypesAllowed()).checkFunctionContracts(true);
        Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"RECURSIVE.filterRecursion(stepIntoFilter)\n            .withValidationStrategy(DescriptorValidator.ValidationVisitor.errorTypesAllowed())\n            .checkFunctionContracts(true)");
        return configuration;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<Name> getTopLevelPackagesFromFileList(List<? extends KtFile> files) {
        void var3_3;
        void $this$mapTo$iv;
        Iterable iterable = files;
        Collection destination$iv = new LinkedHashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void file;
            KtFile ktFile = (KtFile)item$iv;
            Collection collection = destination$iv;
            boolean bl = false;
            List list = file.getPackageFqName().pathSegments();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"file.packageFqName.pathSegments()");
            Name name = (Name)CollectionsKt.firstOrNull((List)list);
            Name name2 = name == null ? SpecialNames.ROOT_PACKAGE : name;
            collection.add(name2);
        }
        return (Set)var3_3;
    }

    private final Map<BaseDiagnosticsTest.TestModule, ModuleDescriptorImpl> createModules(Map<BaseDiagnosticsTest.TestModule, ? extends List<BaseDiagnosticsTest.TestFile>> groupedByModule, StorageManager storageManager) {
        ModuleDescriptorImpl module2;
        HashMap<BaseDiagnosticsTest.TestModule, ModuleDescriptorImpl> modules = new HashMap<BaseDiagnosticsTest.TestModule, ModuleDescriptorImpl>();
        for (BaseDiagnosticsTest.TestModule testModule : groupedByModule.keySet()) {
            module2 = testModule == null ? this.createSealedModule(storageManager) : this.createModule(testModule.name, storageManager);
            modules.put(testModule, module2);
        }
        for (BaseDiagnosticsTest.TestModule testModule : groupedByModule.keySet()) {
            ModuleDescriptorImpl moduleDescriptorImpl;
            if (testModule == null) continue;
            ModuleDescriptorImpl moduleDescriptorImpl2 = (ModuleDescriptorImpl)modules.get(testModule);
            Intrinsics.checkNotNull((Object)moduleDescriptorImpl2);
            module2 = moduleDescriptorImpl = moduleDescriptorImpl2;
            ArrayList<ModuleDescriptorImpl> dependencies = new ArrayList<ModuleDescriptorImpl>();
            dependencies.add(module2);
            for (KotlinBaseTest.TestModule dependency : testModule.getDependencies()) {
                ModuleDescriptorImpl moduleDescriptorImpl3 = (ModuleDescriptorImpl)modules.get((BaseDiagnosticsTest.TestModule)dependency);
                Intrinsics.checkNotNull((Object)moduleDescriptorImpl3);
                dependencies.add(moduleDescriptorImpl3);
            }
            dependencies.add(module2.getBuiltIns().getBuiltInsModule());
            dependencies.addAll((Collection)this.getAdditionalDependencies(module2));
            module2.setDependencies((List)dependencies);
        }
        return modules;
    }

    @NotNull
    protected List<ModuleDescriptorImpl> getAdditionalDependencies(@NotNull ModuleDescriptorImpl module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        return CollectionsKt.emptyList();
    }

    @NotNull
    protected ModuleDescriptorImpl createModule(@NotNull String moduleName, @NotNull StorageManager storageManager) {
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        Intrinsics.checkNotNullParameter((Object)storageManager, (String)"storageManager");
        TargetPlatform platform = this.parseModulePlatformByName(moduleName);
        JvmBuiltIns builtIns = new JvmBuiltIns(storageManager, JvmBuiltIns.Kind.FROM_CLASS_LOADER);
        Name name = Name.special((String)('<' + moduleName + '>'));
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"special(\"<$moduleName>\")");
        return new ModuleDescriptorImpl(name, storageManager, (KotlinBuiltIns)builtIns, platform, null, null, 48, null);
    }

    @NotNull
    protected ModuleDescriptorImpl createSealedModule(@NotNull StorageManager storageManager) {
        Intrinsics.checkNotNullParameter((Object)storageManager, (String)"storageManager");
        ModuleDescriptorImpl moduleDescriptorImpl = this.createModule("test-module-jvm", storageManager);
        boolean bl = false;
        boolean bl2 = false;
        ModuleDescriptorImpl $this$createSealedModule_u24lambda_u2d20 = moduleDescriptorImpl;
        boolean bl3 = false;
        ModuleDescriptorImpl[] moduleDescriptorImplArray = new ModuleDescriptorImpl[2];
        moduleDescriptorImplArray[0] = $this$createSealedModule_u24lambda_u2d20;
        ModuleDescriptorImpl moduleDescriptorImpl2 = $this$createSealedModule_u24lambda_u2d20.getBuiltIns().getBuiltInsModule();
        Intrinsics.checkNotNullExpressionValue((Object)moduleDescriptorImpl2, (String)"builtIns.builtInsModule");
        moduleDescriptorImplArray[1] = moduleDescriptorImpl2;
        $this$createSealedModule_u24lambda_u2d20.setDependencies(moduleDescriptorImplArray);
        return moduleDescriptorImpl;
    }

    private final void checkAllResolvedCallsAreCompleted(List<? extends KtFile> ktFiles, BindingContext bindingContext, LanguageVersionSettings configuredLanguageVersionSettings) {
        boolean bl;
        Object object;
        boolean bl2;
        block7: {
            Iterable $this$any$iv = ktFiles;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl2 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KtFile file = (KtFile)element$iv;
                    boolean bl3 = false;
                    object = AnalyzingUtils.getSyntaxErrorRanges((PsiElement)((PsiElement)file));
                    bl = false;
                    boolean bl4 = !object.isEmpty();
                    if (!bl4) continue;
                    bl2 = true;
                    break block7;
                }
                bl2 = false;
            }
        }
        if (bl2) {
            return;
        }
        ImmutableMap $i$f$any = bindingContext.getSliceContents((ReadOnlySlice)BindingContext.RESOLVED_CALL);
        Intrinsics.checkNotNullExpressionValue((Object)$i$f$any, (String)"bindingContext.getSliceContents(BindingContext.RESOLVED_CALL)");
        ImmutableMap resolvedCallsEntries = $i$f$any;
        ArrayList<KtElement> unresolvedCallsOnElements = new ArrayList<KtElement>();
        Object object2 = (Map)resolvedCallsEntries;
        boolean file = false;
        Object object3 = object2.entrySet().iterator();
        while (object3.hasNext()) {
            Object bl3 = object2 = (Map.Entry)object3.next();
            boolean bl5 = false;
            Call call = (Call)bl3.getKey();
            object = object2;
            bl = false;
            ResolvedCall resolvedCall = (ResolvedCall)object.getValue();
            KtElement ktElement = call.getCallElement();
            Intrinsics.checkNotNullExpressionValue((Object)ktElement, (String)"call.callElement");
            KtElement element = ktElement;
            if (configuredLanguageVersionSettings.supportsFeature(LanguageFeature.NewInference)) continue;
            if (resolvedCall == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.resolve.calls.model.MutableResolvedCall<*>");
            }
            if (((MutableResolvedCall)resolvedCall).isCompleted()) continue;
            unresolvedCallsOnElements.add(element);
        }
        object3 = unresolvedCallsOnElements;
        boolean bl6 = false;
        if (!object3.isEmpty()) {
            TestCase.fail((String)Intrinsics.stringPlus((String)"There are uncompleted resolved calls for the following elements:\n", (Object)CollectionsKt.joinToString$default((Iterable)unresolvedCallsOnElements, (CharSequence)"\n", null, null, (int)0, null, (Function1)checkAllResolvedCallsAreCompleted.2.INSTANCE, (int)30, null)));
        }
        this.checkResolvedCallsInDiagnostics(bindingContext, configuredLanguageVersionSettings);
    }

    private final void checkResolvedCallsInDiagnostics(BindingContext bindingContext, LanguageVersionSettings configuredLanguageVersionSettings) {
        Object[] objectArray = new DiagnosticFactory1[]{Errors.OVERLOAD_RESOLUTION_AMBIGUITY, Errors.NONE_APPLICABLE, Errors.CANNOT_COMPLETE_RESOLVE, Errors.UNRESOLVED_REFERENCE_WRONG_RECEIVER, Errors.ASSIGN_OPERATOR_AMBIGUITY, Errors.ITERATOR_AMBIGUITY};
        Set diagnosticsStoringResolvedCalls1 = SetsKt.setOf((Object[])objectArray);
        DiagnosticFactory2[] diagnosticFactory2Array = new DiagnosticFactory2[]{Errors.COMPONENT_FUNCTION_AMBIGUITY, Errors.DELEGATE_SPECIAL_FUNCTION_AMBIGUITY, Errors.DELEGATE_SPECIAL_FUNCTION_NONE_APPLICABLE};
        Set diagnosticsStoringResolvedCalls2 = SetsKt.setOf((Object[])diagnosticFactory2Array);
        for (Diagnostic diagnostic : bindingContext.getDiagnostics()) {
            Object object;
            DiagnosticFactory diagnosticFactory = diagnostic.getFactory();
            if (CollectionsKt.contains((Iterable)diagnosticsStoringResolvedCalls1, (Object)diagnosticFactory)) {
                object = ((DiagnosticWithParameters1)DiagnosticFactory.Companion.cast((UnboundDiagnostic)diagnostic, (Collection)diagnosticsStoringResolvedCalls1)).getA();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"DiagnosticFactory.cast(diagnostic, diagnosticsStoringResolvedCalls1).a");
                this.assertResolvedCallsAreCompleted(diagnostic, (Collection)object, configuredLanguageVersionSettings);
                continue;
            }
            if (!CollectionsKt.contains((Iterable)diagnosticsStoringResolvedCalls2, (Object)diagnosticFactory)) continue;
            object = ((DiagnosticWithParameters2)DiagnosticFactory.Companion.cast((UnboundDiagnostic)diagnostic, (Collection)diagnosticsStoringResolvedCalls2)).getB();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"DiagnosticFactory.cast(diagnostic, diagnosticsStoringResolvedCalls2).b");
            this.assertResolvedCallsAreCompleted(diagnostic, (Collection)object, configuredLanguageVersionSettings);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void assertResolvedCallsAreCompleted(Diagnostic diagnostic, Collection<? extends ResolvedCall<?>> resolvedCalls, LanguageVersionSettings configuredLanguageVersionSettings) {
        boolean bl;
        String string;
        block4: {
            void $this$all$iv;
            PsiElement element = diagnostic.getPsiElement();
            Object object = DiagnosticUtils.getLineAndColumnInPsiFile((PsiFile)element.getContainingFile(), (TextRange)element.getTextRange());
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getLineAndColumnInPsiFile(element.containingFile, element.textRange)");
            PsiDiagnosticUtils.LineAndColumn lineAndColumn = object;
            if (configuredLanguageVersionSettings.supportsFeature(LanguageFeature.NewInference)) {
                return;
            }
            object = resolvedCalls;
            string = "Resolved calls stored in " + diagnostic.getFactory().getName() + "\nfor '" + element.getText() + '\'' + lineAndColumn + " are not completed";
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    ResolvedCall it = (ResolvedCall)element$iv;
                    boolean bl2 = false;
                    if (((MutableResolvedCall)it).isCompleted()) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        boolean bl3 = bl;
        KtUsefulTestCase.assertTrue((String)string, (boolean)bl3);
    }

    private static final int validateAndCompareDescriptorWithFile$lambda-11(BaseDiagnosticsTest.TestModule x, BaseDiagnosticsTest.TestModule y) {
        int n;
        if (x == null && y == null) {
            n = 0;
        } else if (x == null && y != null) {
            n = -1;
        } else if (x != null && y == null) {
            n = 1;
        } else if (x != null && y != null) {
            n = x.compareTo(y);
        } else {
            String string = "Unreachable";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean createdAffectedPackagesConfiguration$lambda-18(Collection $modules, Set $packagesNames, boolean $checkTypeEnabled, DeclarationDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)$modules, (String)"$modules");
        Intrinsics.checkNotNullParameter((Object)$packagesNames, (String)"$packagesNames");
        ModuleDescriptor module2 = DescriptorUtils.getContainingModuleOrNull((DeclarationDescriptor)descriptor);
        if (!CollectionsKt.contains((Iterable)$modules, (Object)module2)) {
            return false;
        }
        if (descriptor instanceof PackageViewDescriptor) {
            FqName fqName = ((PackageViewDescriptor)descriptor).getFqName();
            if (fqName.isRoot()) return true;
            List list = fqName.pathSegments();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fqName.pathSegments()");
            if (!$packagesNames.contains(CollectionsKt.first((List)list))) return false;
            return true;
        }
        if (!$checkTypeEnabled) return true;
        if (!NAMES_OF_CHECK_TYPE_HELPER.contains(descriptor.getName())) return true;
        return false;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        Companion = new Companion(null);
        HASH_SANITIZER = Companion.HASH_SANITIZER.1.INSTANCE;
        MODULE_FILES = new ModuleCapability("");
        Object[] objectArray = new String[]{"checkSubtype", "CheckTypeInv", "_", "checkType"};
        Iterable $this$map$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Name name = Name.identifier((String)it);
            collection.add(name);
        }
        NAMES_OF_CHECK_TYPE_HELPER = (List)var3_3;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/checkers/AbstractDiagnosticsTest$Companion;", "", "()V", "HASH_SANITIZER", "Lkotlin/Function1;", "", "MODULE_FILES", "Lorg/jetbrains/kotlin/descriptors/ModuleCapability;", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "NAMES_OF_CHECK_TYPE_HELPER", "Lorg/jetbrains/kotlin/name/Name;", "tests-common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

