/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.util;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.testFramework.KtUsefulTestCase;
import org.junit.Assert;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J,\u0010\b\u001a\u00020\u00042\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rH\u0016J:\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\u000e2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u00132\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J \u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00162\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rH\u0016J,\u0010\u0017\u001a\u00020\u00042\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rH\u0016J\"\u0010\u0018\u001a\u00020\u00042\b\u0010\u0015\u001a\u0004\u0018\u00010\n2\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rH\u0016J:\u0010\u0019\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u001a2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u001b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u001b2\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rH\u0016J \u0010\u001c\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00162\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\rH\u0016J\u0016\u0010\u001d\u001a\u00020\u001e2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/test/util/JUnit4Assertions;", "Lorg/jetbrains/kotlin/test/Assertions;", "()V", "assertAll", "", "exceptions", "", "", "assertEquals", "expected", "", "actual", "message", "Lkotlin/Function0;", "", "assertEqualsToFile", "expectedFile", "Ljava/io/File;", "sanitizer", "Lkotlin/Function1;", "assertFalse", "value", "", "assertNotEquals", "assertNotNull", "assertSameElements", "T", "", "assertTrue", "fail", "", "tests-common"})
public final class JUnit4Assertions
extends Assertions {
    @NotNull
    public static final JUnit4Assertions INSTANCE = new JUnit4Assertions();

    private JUnit4Assertions() {
    }

    public void assertEqualsToFile(@NotNull File expectedFile, @NotNull String actual2, @NotNull Function1<? super String, String> sanitizer, @NotNull Function0<String> message) {
        Intrinsics.checkNotNullParameter((Object)expectedFile, (String)"expectedFile");
        Intrinsics.checkNotNullParameter((Object)actual2, (String)"actual");
        Intrinsics.checkNotNullParameter(sanitizer, (String)"sanitizer");
        Intrinsics.checkNotNullParameter(message, (String)"message");
        KotlinTestUtils.assertEqualsToFile(expectedFile, actual2, sanitizer);
    }

    public void assertEquals(@Nullable Object expected, @Nullable Object actual2, @Nullable Function0<String> message) {
        Function0<String> function0 = message;
        Assert.assertEquals((String)(function0 == null ? null : (String)function0.invoke()), (Object)expected, (Object)actual2);
    }

    public void assertNotEquals(@Nullable Object expected, @Nullable Object actual2, @Nullable Function0<String> message) {
        Function0<String> function0 = message;
        Assert.assertNotEquals((String)(function0 == null ? null : (String)function0.invoke()), (Object)expected, (Object)actual2);
    }

    public void assertTrue(boolean value, @Nullable Function0<String> message) {
        Function0<String> function0 = message;
        Assert.assertTrue((String)(function0 == null ? null : (String)function0.invoke()), (boolean)value);
    }

    public void assertFalse(boolean value, @Nullable Function0<String> message) {
        Function0<String> function0 = message;
        Assert.assertFalse((String)(function0 == null ? null : (String)function0.invoke()), (boolean)value);
    }

    public void assertNotNull(@Nullable Object value, @Nullable Function0<String> message) {
        Function0<String> function0 = message;
        Assert.assertNotNull((String)(function0 == null ? null : (String)function0.invoke()), (Object)value);
    }

    public <T> void assertSameElements(@NotNull Collection<? extends T> expected, @NotNull Collection<? extends T> actual2, @Nullable Function0<String> message) {
        String string;
        Intrinsics.checkNotNullParameter(expected, (String)"expected");
        Intrinsics.checkNotNullParameter(actual2, (String)"actual");
        Function0<String> function0 = message;
        KtUsefulTestCase.assertSameElements(function0 == null ? "" : ((string = (String)function0.invoke()) == null ? "" : string), expected, actual2);
    }

    public void assertAll(@NotNull List<? extends Throwable> exceptions) {
        Intrinsics.checkNotNullParameter(exceptions, (String)"exceptions");
        Iterable $this$forEach$iv = exceptions;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        if (iterator.hasNext()) {
            Object element$iv = iterator.next();
            Throwable it = (Throwable)element$iv;
            boolean bl = false;
            throw it;
        }
    }

    @NotNull
    public Void fail(@NotNull Function0<String> message) {
        Intrinsics.checkNotNullParameter(message, (String)"message");
        throw new AssertionError(message.invoke());
    }
}

