/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constants.evaluate;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiElement;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.config.LanguageVersionSettingsImpl;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DelegatingBindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.annotation.AbstractAnnotationDescriptorResolveTest;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.AbstractCompileTimeConstantEvaluatorTest;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.test.InTextDirectivesUtils;
import org.jetbrains.kotlin.test.KotlinTestUtils;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\b&\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J*\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0018\u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00060\nH\u0002J\u000e\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u001e\u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u000bH\u0002J\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u00132\u0006\u0010\u0014\u001a\u00020\u0006\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/resolve/constants/evaluate/AbstractCompileTimeConstantEvaluatorTest;", "Lorg/jetbrains/kotlin/resolve/annotation/AbstractAnnotationDescriptorResolveTest;", "()V", "doConstantTest", "", "path", "", "doIsPureTest", "doTest", "getValueToTest", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "doUsesVariableAsConstantTest", "evaluateInitializer", "Lorg/jetbrains/kotlin/resolve/constants/CompileTimeConstant;", "context", "property", "getObjectsToTest", "", "fileText", "Companion", "tests-common"})
public abstract class AbstractCompileTimeConstantEvaluatorTest
extends AbstractAnnotationDescriptorResolveTest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Pattern pattern = Pattern.compile(".+(?=:)");

    public final void doConstantTest(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.doTest(path, (Function2<? super VariableDescriptor, ? super BindingContext, String>)((Function2)doConstantTest.1.INSTANCE));
    }

    public final void doIsPureTest(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.doTest(path, (Function2<? super VariableDescriptor, ? super BindingContext, String>)((Function2)new Function2<VariableDescriptor, BindingContext, String>(this){
            final /* synthetic */ AbstractCompileTimeConstantEvaluatorTest this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            @NotNull
            public final String invoke(@NotNull VariableDescriptor property, @NotNull BindingContext context) {
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                CompileTimeConstant compileTimeConstant = AbstractCompileTimeConstantEvaluatorTest.access$evaluateInitializer(this.this$0, context, property);
                return String.valueOf(compileTimeConstant == null ? null : Boolean.valueOf(compileTimeConstant.isPure()));
            }
        }));
    }

    public final void doUsesVariableAsConstantTest(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.doTest(path, (Function2<? super VariableDescriptor, ? super BindingContext, String>)((Function2)new Function2<VariableDescriptor, BindingContext, String>(this){
            final /* synthetic */ AbstractCompileTimeConstantEvaluatorTest this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            @NotNull
            public final String invoke(@NotNull VariableDescriptor property, @NotNull BindingContext context) {
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                CompileTimeConstant compileTimeConstant = AbstractCompileTimeConstantEvaluatorTest.access$evaluateInitializer(this.this$0, context, property);
                return String.valueOf(compileTimeConstant == null ? null : Boolean.valueOf(compileTimeConstant.getUsesVariableAsConstant()));
            }
        }));
    }

    private final CompileTimeConstant<?> evaluateInitializer(BindingContext context, VariableDescriptor property) {
        PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration((DeclarationDescriptor)((DeclarationDescriptor)property));
        if (psiElement == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtProperty");
        }
        KtProperty propertyDeclaration = (KtProperty)psiElement;
        ModuleDescriptor moduleDescriptor = DescriptorUtilsKt.getModule((DeclarationDescriptor)((DeclarationDescriptor)property));
        LanguageVersionSettings languageVersionSettings = (LanguageVersionSettings)LanguageVersionSettingsImpl.DEFAULT;
        psiElement = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"project");
        ConstantExpressionEvaluator constantExpressionEvaluator = new ConstantExpressionEvaluator(moduleDescriptor, languageVersionSettings, (Project)psiElement);
        KtExpression ktExpression = propertyDeclaration.getInitializer();
        Intrinsics.checkNotNull((Object)ktExpression);
        psiElement = ktExpression;
        return constantExpressionEvaluator.evaluateExpression((KtExpression)psiElement, (BindingTrace)new DelegatingBindingTrace(context, "trace for evaluating compile time constant", false, null, false, null, 60, null), property.getType());
    }

    private final void doTest(String path, Function2<? super VariableDescriptor, ? super BindingContext, String> getValueToTest) {
        String expected;
        File myFile = new File(path);
        String string = FileUtil.loadFile((File)myFile, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"loadFile(myFile, true)");
        String fileText = string;
        PackageFragmentDescriptor packageFragmentDescriptor = this.getPackage(fileText);
        Intrinsics.checkNotNullExpressionValue((Object)packageFragmentDescriptor, (String)"getPackage(fileText)");
        PackageFragmentDescriptor packageView = packageFragmentDescriptor;
        List<String> propertiesForTest = this.getObjectsToTest(fileText);
        boolean bl = false;
        ArrayList<Pair> expectedActual = new ArrayList<Pair>();
        for (String propertyName : propertiesForTest) {
            VariableDescriptor variableDescriptor;
            String expectedPropertyPrefix = "// val " + propertyName + ": ";
            String[] stringArray = new String[]{expectedPropertyPrefix};
            expected = InTextDirectivesUtils.findStringWithPrefixes((String)fileText, (String[])stringArray);
            AbstractAnnotationDescriptorResolveTest.assertNotNull((String)expected, (Object)Intrinsics.stringPlus((String)"Failed to find expected directive: ", (Object)expectedPropertyPrefix));
            PropertyDescriptor propertyDescriptor = AbstractAnnotationDescriptorResolveTest.getPropertyDescriptor(packageView, propertyName, false);
            if (propertyDescriptor == null) {
                BindingContext bindingContext = this.getContext();
                Intrinsics.checkNotNull((Object)bindingContext);
                variableDescriptor = AbstractAnnotationDescriptorResolveTest.getLocalVarDescriptor(bindingContext, propertyName);
            } else {
                variableDescriptor = (VariableDescriptor)propertyDescriptor;
            }
            VariableDescriptor variableDescriptor2 = variableDescriptor;
            Intrinsics.checkNotNullExpressionValue((Object)variableDescriptor2, (String)"AbstractAnnotationDescriptorResolveTest.getPropertyDescriptor(packageView, propertyName, false)\n            ?: AbstractAnnotationDescriptorResolveTest.getLocalVarDescriptor(context!!, propertyName)");
            VariableDescriptor property = variableDescriptor2;
            propertyDescriptor = this.getContext();
            Intrinsics.checkNotNull((Object)propertyDescriptor);
            String testedObject = (String)getValueToTest.invoke((Object)property, (Object)propertyDescriptor);
            Intrinsics.checkNotNull((Object)expected);
            expectedActual.add(TuplesKt.to((Object)Intrinsics.stringPlus((String)expectedPropertyPrefix, (Object)expected), (Object)Intrinsics.stringPlus((String)expectedPropertyPrefix, (Object)testedObject)));
        }
        String actualFileText = fileText;
        for (Pair pair : expectedActual) {
            expected = (String)pair.component1();
            String actual2 = (String)pair.component2();
            boolean bl2 = StringsKt.contains$default((CharSequence)actualFileText, (CharSequence)expected, (boolean)false, (int)2, null);
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl2) {
                boolean bl4 = false;
                String string2 = Intrinsics.stringPlus((String)"File text should contain ", (Object)expected);
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
            actualFileText = StringsKt.replace$default((String)actualFileText, (String)expected, (String)actual2, (boolean)false, (int)4, null);
        }
        KotlinTestUtils.assertEqualsToFile(myFile, actualFileText);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getObjectsToTest(@NotNull String fileText) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)fileText, (String)"fileText");
        String[] stringArray = new String[]{"// val"};
        List list = InTextDirectivesUtils.findListWithPrefixes((String)fileText, (String[])stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"findListWithPrefixes(fileText, \"// val\")");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string;
            void it;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Matcher matcher = pattern.matcher((CharSequence)it);
            String string3 = matcher.find() ? ((string = matcher.group(0)) == null ? Intrinsics.stringPlus((String)"Couldn't match tested object ", (Object)it) : string) : Intrinsics.stringPlus((String)"Couldn't match tested object ", (Object)it);
            collection.add(string3);
        }
        return (List)destination$iv$iv;
    }

    public static final /* synthetic */ CompileTimeConstant access$evaluateInitializer(AbstractCompileTimeConstantEvaluatorTest $this, BindingContext context, VariableDescriptor property) {
        return $this.evaluateInitializer(context, property);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/resolve/constants/evaluate/AbstractCompileTimeConstantEvaluatorTest$Companion;", "", "()V", "pattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "getPattern", "()Ljava/util/regex/Pattern;", "tests-common"})
    public static final class Companion {
        private Companion() {
        }

        public final Pattern getPattern() {
            return pattern;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

