/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.checkers;

import com.google.common.collect.Lists;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.test.AssertionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.checkers.CheckerTestUtilTest;
import org.jetbrains.kotlin.checkers.DiagnosedRange;
import org.jetbrains.kotlin.checkers.DiagnosticDiffCallbacks;
import org.jetbrains.kotlin.checkers.diagnostics.ActualDiagnostic;
import org.jetbrains.kotlin.checkers.diagnostics.TextDiagnostic;
import org.jetbrains.kotlin.checkers.utils.CheckerTestUtil;
import org.jetbrains.kotlin.checkers.utils.DiagnosticsRenderingConfiguration;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.lazy.JvmResolveUtil;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.tests.di.ContainerForTests;
import org.jetbrains.kotlin.tests.di.InjectionKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\"\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J$\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\nH&J\u0016\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012R\u0018\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/checkers/Test;", "", "expectedMessages", "", "", "([Ljava/lang/String;)V", "[Ljava/lang/String;", "makeTestData", "", "diagnostics", "", "Lorg/jetbrains/kotlin/checkers/diagnostics/ActualDiagnostic;", "diagnosedRanges", "Lorg/jetbrains/kotlin/checkers/DiagnosedRange;", "test", "psiFile", "Lcom/intellij/psi/PsiFile;", "environment", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "tests-common"})
abstract class Test {
    @NotNull
    private final String[] expectedMessages;

    public Test(String ... expectedMessages) {
        Intrinsics.checkNotNullParameter((Object)expectedMessages, (String)"expectedMessages");
        this.expectedMessages = expectedMessages;
    }

    public final void test(@NotNull PsiFile psiFile, @NotNull KotlinCoreEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        BindingContext bindingContext = JvmResolveUtil.analyze((KtFile)((KtFile)psiFile), (KotlinCoreEnvironment)environment).getBindingContext();
        ModuleDescriptorImpl moduleDescriptorImpl = KotlinTestUtils.createEmptyModule();
        Intrinsics.checkNotNullExpressionValue((Object)moduleDescriptorImpl, (String)"createEmptyModule()");
        ModuleDescriptorImpl emptyModule = moduleDescriptorImpl;
        ContainerForTests container = InjectionKt.createContainerForTests(environment.getProject(), (ModuleDescriptor)emptyModule);
        DataFlowValueFactory dataFlowValueFactory = container.getDataFlowValueFactory();
        LanguageVersionSettings languageVersionSettings = container.getExpressionTypingServices().getLanguageVersionSettings();
        Intrinsics.checkNotNullExpressionValue((Object)languageVersionSettings, (String)"container.expressionTypingServices.languageVersionSettings");
        LanguageVersionSettings languageVersionSettings2 = languageVersionSettings;
        boolean bl = false;
        String string = CheckerTestUtil.INSTANCE.addDiagnosticMarkersToText(psiFile, (Collection)CheckerTestUtil.getDiagnosticsIncludingSyntaxErrors$default((CheckerTestUtil)CheckerTestUtil.INSTANCE, (BindingContext)bindingContext, (PsiElement)((PsiElement)psiFile), (boolean)false, (List)new ArrayList(), (DiagnosticsRenderingConfiguration)new DiagnosticsRenderingConfiguration(null, false, languageVersionSettings2, false, 8, null), (DataFlowValueFactory)dataFlowValueFactory, (ModuleDescriptorImpl)emptyModule, null, (int)128, null)).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"CheckerTestUtil.addDiagnosticMarkersToText(\n            psiFile,\n            CheckerTestUtil.getDiagnosticsIncludingSyntaxErrors(\n                bindingContext, psiFile,\n                false,\n                mutableListOf(),\n                DiagnosticsRenderingConfiguration(null, false, languageVersionSettings),\n                dataFlowValueFactory,\n                emptyModule\n            )\n        ).toString()");
        String expectedText = string;
        ArrayList diagnosedRanges = Lists.newArrayList();
        Intrinsics.checkNotNullExpressionValue((Object)diagnosedRanges, (String)"diagnosedRanges");
        bl = false;
        CheckerTestUtil.INSTANCE.parseDiagnosedRanges(expectedText, (List)diagnosedRanges, (Map)new LinkedHashMap());
        boolean bl2 = false;
        List actualDiagnostics = CheckerTestUtil.getDiagnosticsIncludingSyntaxErrors$default((CheckerTestUtil)CheckerTestUtil.INSTANCE, (BindingContext)bindingContext, (PsiElement)((PsiElement)psiFile), (boolean)false, (List)new ArrayList(), (DiagnosticsRenderingConfiguration)new DiagnosticsRenderingConfiguration(null, false, languageVersionSettings2, false, 8, null), (DataFlowValueFactory)dataFlowValueFactory, (ModuleDescriptorImpl)emptyModule, null, (int)128, null);
        this.makeTestData(actualDiagnostics, diagnosedRanges);
        String[] stringArray = this.expectedMessages;
        Object[] objectArray = new String[stringArray.length];
        System.arraycopy(stringArray, 0, objectArray, 0, stringArray.length);
        List expectedMessages = CollectionsKt.listOf((Object[])objectArray);
        boolean bl3 = false;
        List actualMessages = new ArrayList();
        CheckerTestUtil.INSTANCE.diagnosticsDiff((List)diagnosedRanges, (Collection)actualDiagnostics, new DiagnosticDiffCallbacks(actualMessages){
            final /* synthetic */ List<String> $actualMessages;
            {
                this.$actualMessages = $actualMessages;
            }

            public void missingDiagnostic(@NotNull TextDiagnostic diagnostic, int expectedStart, int expectedEnd) {
                Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
                this.$actualMessages.add(CheckerTestUtilTest.Companion.missing(diagnostic.getDescription(), expectedStart, expectedEnd));
            }

            public void wrongParametersDiagnostic(@NotNull TextDiagnostic expectedDiagnostic, @NotNull TextDiagnostic actualDiagnostic, int start, int end) {
                Intrinsics.checkNotNullParameter((Object)expectedDiagnostic, (String)"expectedDiagnostic");
                Intrinsics.checkNotNullParameter((Object)actualDiagnostic, (String)"actualDiagnostic");
                this.$actualMessages.add(CheckerTestUtilTest.Companion.wrongParameters(TextDiagnostic.asString$default((TextDiagnostic)expectedDiagnostic, (boolean)false, (boolean)false, (int)3, null), TextDiagnostic.asString$default((TextDiagnostic)actualDiagnostic, (boolean)false, (boolean)false, (int)3, null), start, end));
            }

            public void unexpectedDiagnostic(@NotNull TextDiagnostic diagnostic, int actualStart, int actualEnd) {
                Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
                this.$actualMessages.add(CheckerTestUtilTest.Companion.unexpected(diagnostic.getDescription(), actualStart, actualEnd));
            }
        });
        AssertionsKt.assertEquals$default((Object)CollectionsKt.joinToString$default((Iterable)expectedMessages, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), (Object)CollectionsKt.joinToString$default((Iterable)actualMessages, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), null, (int)4, null);
    }

    public abstract void makeTestData(@NotNull List<ActualDiagnostic> var1, @NotNull List<DiagnosedRange> var2);
}

