/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test;

import com.google.common.collect.Lists;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TagsTestDataUtil {
    public static String insertInfoTags(List<LineMarkerInfo> lineMarkers, boolean withDescription, String text) {
        List<LineMarkerTagPoint> lineMarkerPoints = TagsTestDataUtil.toLineMarkerTagPoints(lineMarkers, withDescription);
        return TagsTestDataUtil.insertTagsInText(lineMarkerPoints, text, t -> null);
    }

    public static String insertInfoTags(List<HighlightInfo> highlights, String text) {
        List<HighlightTagPoint> highlightPoints = TagsTestDataUtil.toHighlightTagPoints(highlights);
        return TagsTestDataUtil.insertTagsInText(highlightPoints, text, t -> null);
    }

    public static String generateTextWithCaretAndSelection(@NotNull Editor editor) {
        if (editor == null) {
            TagsTestDataUtil.$$$reportNull$$$0(0);
        }
        ArrayList points = Lists.newArrayList();
        points.add(new TagInfo<String>(editor.getCaretModel().getOffset(), true, "caret"));
        if (editor.getSelectionModel().hasSelection()) {
            points.add(new TagInfo<String>(editor.getSelectionModel().getSelectionStart(), true, "selection"));
            points.add(new TagInfo<String>(editor.getSelectionModel().getSelectionEnd(), false, "selection"));
        }
        return TagsTestDataUtil.insertTagsInText(points, editor.getDocument().getText(), t -> null);
    }

    public static String insertTagsInText(List<? extends TagInfo> tags, String text, Function<TagInfo, String> computeExtraAttributes) {
        StringBuilder builder = new StringBuilder(text);
        List sortedTagPoints = Lists.reverse(tags.stream().sorted().collect(Collectors.toList()));
        for (TagInfo point : sortedTagPoints) {
            String tagText;
            if (point.isStart) {
                String closeSuffix;
                String attributesString = point.getAttributesString();
                String extraAttributes = computeExtraAttributes.apply(point);
                String allAttributes = extraAttributes != null ? attributesString + " " + extraAttributes : attributesString;
                String string = closeSuffix = point.isClosed ? "/" : "";
                tagText = attributesString.isEmpty() ? String.format("<%s%s>", point.getName(), closeSuffix) : String.format("<%s %s%s>", point.getName(), allAttributes, closeSuffix);
            } else {
                tagText = String.format("</%s>", point.getName());
            }
            builder.insert(point.offset, tagText);
        }
        return builder.toString();
    }

    @NotNull
    public static List<LineMarkerTagPoint> toLineMarkerTagPoints(Collection<LineMarkerInfo> lineMarkers, boolean withDescription) {
        ArrayList lineMarkerPoints = Lists.newArrayList();
        for (LineMarkerInfo markerInfo : lineMarkers) {
            lineMarkerPoints.add(new LineMarkerTagPoint(markerInfo.startOffset, true, markerInfo, withDescription));
            lineMarkerPoints.add(new LineMarkerTagPoint(markerInfo.endOffset, false, markerInfo, withDescription));
        }
        ArrayList arrayList = lineMarkerPoints;
        if (arrayList == null) {
            TagsTestDataUtil.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    public static List<HighlightTagPoint> toHighlightTagPoints(Collection<HighlightInfo> highlights) {
        ArrayList highlightPoints = Lists.newArrayList();
        for (HighlightInfo highlight : highlights) {
            highlightPoints.add(new HighlightTagPoint(highlight.startOffset, true, highlight));
            highlightPoints.add(new HighlightTagPoint(highlight.endOffset, false, highlight));
        }
        ArrayList arrayList = highlightPoints;
        if (arrayList == null) {
            TagsTestDataUtil.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @NotNull
    private static String sanitizeLineMarkerTooltip(@Nullable String originalText) {
        if (originalText == null) {
            return "null";
        }
        String noHtmlTags = StringUtil.removeHtmlTags((String)originalText);
        String string = TagsTestDataUtil.sanitizeLineBreaks(noHtmlTags);
        if (string == null) {
            TagsTestDataUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static String sanitizeLineBreaks(String originalText) {
        return StringUtil.replace((String)originalText, (String)"\n", (String)" ");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/test/TagsTestDataUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/test/TagsTestDataUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "toLineMarkerTagPoints";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "toHighlightTagPoints";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "sanitizeLineMarkerTooltip";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "generateTextWithCaretAndSelection";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class LineMarkerTagPoint
    extends TagInfo<LineMarkerInfo> {
        private final boolean withDescription;

        public LineMarkerTagPoint(int offset, boolean start, LineMarkerInfo info, boolean withDescription) {
            super(offset, start, info);
            this.withDescription = withDescription;
        }

        @Override
        @NotNull
        public String getName() {
            return "lineMarker";
        }

        @Override
        @NotNull
        public String getAttributesString() {
            return this.withDescription ? String.format("descr=\"%s\"", TagsTestDataUtil.sanitizeLineMarkerTooltip(((LineMarkerInfo)this.data).getLineMarkerTooltip())) : "descr=\"*\"";
        }
    }

    public static class HighlightTagPoint
    extends TagInfo<HighlightInfo> {
        private final HighlightInfo highlightInfo;

        private HighlightTagPoint(int offset, boolean start, HighlightInfo info) {
            super(offset, start, info);
            this.highlightInfo = info;
        }

        @Override
        @NotNull
        public String getName() {
            String string = this.highlightInfo.getSeverity().equals((Object)HighlightSeverity.INFORMATION) ? "info" : this.highlightInfo.getSeverity().toString().toLowerCase();
            if (string == null) {
                HighlightTagPoint.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        public String getAttributesString() {
            if (this.isStart) {
                if (this.highlightInfo.getDescription() != null) {
                    String string = String.format("descr=\"%s\" textAttributesKey=\"%s\"", TagsTestDataUtil.sanitizeLineBreaks(this.highlightInfo.getDescription()), this.highlightInfo.forcedTextAttributesKey);
                    if (string == null) {
                        HighlightTagPoint.$$$reportNull$$$0(1);
                    }
                    return string;
                }
                String string = String.format("textAttributesKey=\"%s\"", this.highlightInfo.forcedTextAttributesKey);
                if (string == null) {
                    HighlightTagPoint.$$$reportNull$$$0(2);
                }
                return string;
            }
            return "";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "org/jetbrains/kotlin/test/TagsTestDataUtil$HighlightTagPoint";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAttributesString";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static class TagInfo<Data>
    implements Comparable<TagInfo<?>> {
        protected final int offset;
        protected final boolean isStart;
        protected final boolean isClosed;
        protected final boolean isFixed;
        public final Data data;

        public TagInfo(int offset, boolean start, Data data) {
            this(offset, start, false, false, data);
        }

        public TagInfo(int offset, boolean isStart, boolean isClosed, boolean isFixed, Data data) {
            if (isClosed && !isStart) {
                throw new IllegalArgumentException("isClosed should be true only for start tags");
            }
            this.offset = offset;
            this.isStart = isStart;
            this.isClosed = isClosed;
            this.isFixed = isFixed;
            this.data = data;
        }

        @Override
        public int compareTo(@NotNull TagInfo<?> other) {
            if (other == null) {
                TagInfo.$$$reportNull$$$0(0);
            }
            if (this.offset != other.offset) {
                return Integer.valueOf(this.offset).compareTo(other.offset);
            }
            if (this.isStart != other.isStart) {
                return this.isStart ? -1 : 1;
            }
            if (this.isFixed || other.isFixed) {
                return 0;
            }
            String thisTag = this.getName();
            String otherTag = other.getName();
            return thisTag.compareTo(otherTag) * (this.isStart ? -1 : 1);
        }

        @NotNull
        public String getName() {
            String string = this.data.toString();
            if (string == null) {
                TagInfo.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public String getAttributesString() {
            return "";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "other";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/kotlin/test/TagsTestDataUtil$TagInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/kotlin/test/TagsTestDataUtil$TagInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "compareTo";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

