/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analyzer.ModuleContent;
import org.jetbrains.kotlin.analyzer.ModuleInfo;
import org.jetbrains.kotlin.analyzer.common.CommonResolverForModuleFactory;
import org.jetbrains.kotlin.backend.common.serialization.metadata.KlibMetadataModuleDescriptorFactory;
import org.jetbrains.kotlin.backend.common.serialization.metadata.KlibMetadataMonolithicSerializer;
import org.jetbrains.kotlin.backend.common.serialization.metadata.KlibMetadataVersion;
import org.jetbrains.kotlin.builtins.DefaultBuiltIns;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.config.ContentRootsKt;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.config.LanguageVersionSettingsImpl;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.deserialization.PlatformDependentTypeTransformer;
import org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.kotlin.konan.file.File;
import org.jetbrains.kotlin.konan.file.FileKt;
import org.jetbrains.kotlin.konan.util.KlibMetadataFactories;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.library.KotlinLibraryVersioning;
import org.jetbrains.kotlin.library.SerializedMetadata;
import org.jetbrains.kotlin.library.SingleFileKlibResolveStrategy;
import org.jetbrains.kotlin.library.SingleFileResolveKt;
import org.jetbrains.kotlin.library.ToolingSingleFileKlibResolveStrategy;
import org.jetbrains.kotlin.library.impl.BuiltInsPlatform;
import org.jetbrains.kotlin.library.impl.KotlinLibraryLayoutForWriter;
import org.jetbrains.kotlin.library.impl.KotlinLibraryWriterImpl;
import org.jetbrains.kotlin.library.metadata.NativeTypeTransformer;
import org.jetbrains.kotlin.library.metadata.NullFlexibleTypeDeserializer;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.platform.CommonPlatforms;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.serialization.deserialization.FlexibleTypeDeserializer;
import org.jetbrains.kotlin.serialization.deserialization.MetadataPartProvider;
import org.jetbrains.kotlin.storage.LockBasedStorageManager;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.test.KlibTestUtil;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.util.DummyLogger;
import org.jetbrains.kotlin.util.Logger;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=50, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0007J\u001e\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/test/KlibTestUtil;", "", "()V", "compileCommonSourcesToKlib", "", "sourceFiles", "", "Ljava/io/File;", "libraryName", "", "klibFile", "deserializeKlibToCommonModule", "Lorg/jetbrains/kotlin/descriptors/impl/ModuleDescriptorImpl;", "serializeCommonModuleToKlib", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "tests-common"})
public final class KlibTestUtil {
    @NotNull
    public static final KlibTestUtil INSTANCE = new KlibTestUtil();

    private KlibTestUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void compileCommonSourcesToKlib(@NotNull Collection<? extends java.io.File> sourceFiles, @NotNull String libraryName, @NotNull java.io.File klibFile) {
        ModuleDescriptor moduleDescriptor;
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(sourceFiles, (String)"sourceFiles");
        Intrinsics.checkNotNullParameter((Object)libraryName, (String)"libraryName");
        Intrinsics.checkNotNullParameter((Object)klibFile, (String)"klibFile");
        boolean bl = !Name.guessByFirstCharacter((String)libraryName).isSpecial();
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = Intrinsics.stringPlus((String)"Invalid library name: ", (Object)libraryName);
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Object object = KotlinTestUtils.newConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"newConfiguration()");
        CompilerConfiguration configuration = object;
        configuration.put(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY, (Object)MessageCollector.Companion.getNONE());
        configuration.put(CommonConfigurationKeys.MODULE_NAME, (Object)libraryName);
        object = sourceFiles;
        CompilerConfiguration compilerConfiguration = configuration;
        boolean $i$f$map22 = false;
        void bl4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            java.io.File file = (java.io.File)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl5 = false;
            String string = it.getAbsolutePath();
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        ContentRootsKt.addKotlinSourceRoots((CompilerConfiguration)compilerConfiguration, (List)collection);
        Disposable $i$f$map22 = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)$i$f$map22, (String)"newDisposable()");
        Disposable rootDisposable = $i$f$map22;
        try {
            KotlinCoreEnvironment environment = KotlinCoreEnvironment.Companion.createForTests(rootDisposable, configuration, EnvironmentConfigFiles.METADATA_CONFIG_FILES);
            Collection collection2 = environment.getSourceFiles();
            Name name = Name.special((String)('<' + libraryName + '>'));
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"special(\"<$libraryName>\")");
            moduleDescriptor = CommonResolverForModuleFactory.Companion.analyzeFiles$default((CommonResolverForModuleFactory.Companion)CommonResolverForModuleFactory.Companion, (Collection)collection2, (Name)name, (boolean)true, (LanguageVersionSettings)CommonConfigurationKeysKt.getLanguageVersionSettings((CompilerConfiguration)environment.getConfiguration()), (TargetPlatform)CommonPlatforms.INSTANCE.getDefaultCommonPlatform(), null, null, (Function1)((Function1)new Function1<ModuleContent<? extends ModuleInfo>, MetadataPartProvider>(environment){
                final /* synthetic */ KotlinCoreEnvironment $environment;
                {
                    this.$environment = $environment;
                    super(1);
                }

                @NotNull
                public final MetadataPartProvider invoke(@NotNull ModuleContent<? extends ModuleInfo> content2) {
                    Intrinsics.checkNotNullParameter(content2, (String)"content");
                    return (MetadataPartProvider)this.$environment.createPackagePartProvider(content2.getModuleContentScope());
                }
            }), (int)96, null).getModuleDescriptor();
        }
        finally {
            Disposer.dispose((Disposable)rootDisposable);
        }
        ModuleDescriptor module2 = moduleDescriptor;
        this.serializeCommonModuleToKlib(module2, libraryName, klibFile);
    }

    public final void serializeCommonModuleToKlib(@NotNull ModuleDescriptor module2, @NotNull String libraryName, @NotNull java.io.File klibFile) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)libraryName, (String)"libraryName");
        Intrinsics.checkNotNullParameter((Object)klibFile, (String)"klibFile");
        boolean bl = Intrinsics.areEqual((Object)FilesKt.getExtension((java.io.File)klibFile), (Object)"klib");
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "KLIB file must have klib extension";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        LanguageVersionSettingsImpl languageVersionSettingsImpl = LanguageVersionSettingsImpl.DEFAULT;
        KlibMetadataVersion klibMetadataVersion = KlibMetadataVersion.INSTANCE;
        KlibMetadataMonolithicSerializer serializer = new KlibMetadataMonolithicSerializer((LanguageVersionSettings)languageVersionSettingsImpl, (BinaryVersion)klibMetadataVersion, null, false, false, false, 48, null);
        SerializedMetadata serializedMetadata = serializer.serializeModule(module2);
        File unzippedDir = FileKt.createTempDir((String)libraryName);
        String string = klibFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"klibFile.path");
        KotlinLibraryLayoutForWriter layout = new KotlinLibraryLayoutForWriter(new File(string), unzippedDir, null, 4, null);
        KotlinLibraryWriterImpl library = new KotlinLibraryWriterImpl(libraryName, new KotlinLibraryVersioning(null, null, null, KlibMetadataVersion.INSTANCE.toString(), null), BuiltInsPlatform.COMMON, CollectionsKt.emptyList(), false, libraryName, layout, null, null, null, 896, null);
        library.addMetadata(serializedMetadata);
        library.commit();
    }

    @NotNull
    public final ModuleDescriptorImpl deserializeKlibToCommonModule(@NotNull java.io.File klibFile) {
        Intrinsics.checkNotNullParameter((Object)klibFile, (String)"klibFile");
        String string = klibFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"klibFile.path");
        KotlinLibrary library = SingleFileResolveKt.resolveSingleFileKlib((File)new File(string), (Logger)((Logger)DummyLogger.INSTANCE), (SingleFileKlibResolveStrategy)((SingleFileKlibResolveStrategy)ToolingSingleFileKlibResolveStrategy.INSTANCE));
        KlibMetadataFactories metadataFactories2 = new KlibMetadataFactories((Function1)deserializeKlibToCommonModule.metadataFactories.1.INSTANCE, (FlexibleTypeDeserializer)NullFlexibleTypeDeserializer.INSTANCE, (PlatformDependentTypeTransformer)new NativeTypeTransformer());
        KlibMetadataModuleDescriptorFactory klibMetadataModuleDescriptorFactory = metadataFactories2.getDefaultDeserializedDescriptorFactory();
        LanguageVersionSettings languageVersionSettings = (LanguageVersionSettings)LanguageVersionSettingsImpl.DEFAULT;
        Object[] objectArray = LockBasedStorageManager.NO_LOCKS;
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"NO_LOCKS");
        ModuleDescriptorImpl module2 = klibMetadataModuleDescriptorFactory.createDescriptor(library, languageVersionSettings, (StorageManager)objectArray, (KotlinBuiltIns)DefaultBuiltIns.Companion.getInstance(), null);
        objectArray = new ModuleDescriptorImpl[]{DefaultBuiltIns.Companion.getInstance().getBuiltInsModule(), module2};
        module2.setDependencies(CollectionsKt.listOf((Object[])objectArray));
        return module2;
    }
}

