/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.builtins;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.lazy.LazyResolveTestUtilsKt;
import org.jetbrains.kotlin.test.KotlinTestUtils;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=50, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00042\u0006\u0010\b\u001a\u00020\tH\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/serialization/builtins/BuiltinsTestUtils;", "", "()V", "BUILTIN_PACKAGE_NAMES", "", "Lorg/jetbrains/kotlin/name/FqName;", "allFilesUnder", "Ljava/io/File;", "directory", "", "compileBuiltinsModule", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "environment", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "tests-common"})
public final class BuiltinsTestUtils {
    @NotNull
    public static final BuiltinsTestUtils INSTANCE = new BuiltinsTestUtils();
    @JvmField
    @NotNull
    public static final List<FqName> BUILTIN_PACKAGE_NAMES;

    private BuiltinsTestUtils() {
    }

    @NotNull
    public final ModuleDescriptor compileBuiltinsModule(@NotNull KotlinCoreEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        ModuleDescriptor moduleDescriptor = KotlinTestUtils.loadToJetFiles(environment, ContainerUtil.concat(this.allFilesUnder("core/builtins/native"), this.allFilesUnder("core/builtins/src")));
        Intrinsics.checkNotNullExpressionValue(moduleDescriptor, (String)"loadToJetFiles(\n            environment, ContainerUtil.concat<File>(\n                allFilesUnder(\"core/builtins/native\"),\n                allFilesUnder(\"core/builtins/src\")\n            )\n        )");
        ModuleDescriptor files = moduleDescriptor;
        moduleDescriptor = LazyResolveTestUtilsKt.createResolveSessionForFiles(environment.getProject(), (Collection)files, false).getModuleDescriptor();
        Intrinsics.checkNotNullExpressionValue((Object)moduleDescriptor, (String)"createResolveSessionForFiles(environment.project, files, false).moduleDescriptor");
        return moduleDescriptor;
    }

    private final List<File> allFilesUnder(String directory) {
        List list = FileUtil.findFilesByMask((Pattern)Pattern.compile(".*\\.kt"), (File)new File(directory));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"findFilesByMask(Pattern.compile(\".*\\\\.kt\"), File(directory))");
        return list;
    }

    static {
        Object[] objectArray = new FqName[]{StandardNames.BUILT_INS_PACKAGE_FQ_NAME, StandardNames.COLLECTIONS_PACKAGE_FQ_NAME, StandardNames.RANGES_PACKAGE_FQ_NAME};
        BUILTIN_PACKAGE_NAMES = CollectionsKt.listOf((Object[])objectArray);
    }
}

