/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constraintSystem;

import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.TypeResolver;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.IntegerValueTypeConstructor;
import org.jetbrains.kotlin.resolve.constraintSystem.ConstraintSystemTestDataKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.test.DummyTraces;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=50, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001e\u0010\r\u001a\u00020\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/resolve/constraintSystem/ConstraintSystemTestData;", "", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "project", "Lcom/intellij/openapi/project/Project;", "typeResolver", "Lorg/jetbrains/kotlin/resolve/TypeResolver;", "(Lorg/jetbrains/kotlin/resolve/BindingContext;Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/resolve/TypeResolver;)V", "functionFoo", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "scopeToResolveTypeParameters", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "findFunctionByName", "functions", "", "name", "", "getParameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "getType", "Lorg/jetbrains/kotlin/types/KotlinType;", "tests-common"})
public final class ConstraintSystemTestData {
    @NotNull
    private final Project project;
    @NotNull
    private final TypeResolver typeResolver;
    @NotNull
    private final FunctionDescriptor functionFoo;
    @NotNull
    private final LexicalScope scopeToResolveTypeParameters;

    public ConstraintSystemTestData(@NotNull BindingContext context, @NotNull Project project, @NotNull TypeResolver typeResolver) {
        LexicalScope lexicalScope;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)typeResolver, (String)"typeResolver");
        this.project = project;
        this.typeResolver = typeResolver;
        Object object = context.getSliceContents((ReadOnlySlice)BindingContext.FUNCTION);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context.getSliceContents(BindingContext.FUNCTION)");
        ImmutableMap functions = object;
        object = functions.values();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"functions.values");
        this.functionFoo = this.findFunctionByName((Collection<? extends FunctionDescriptor>)object, "foo");
        PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration((DeclarationDescriptor)((DeclarationDescriptor)this.functionFoo));
        if (psiElement == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFunction");
        }
        KtFunction function = (KtFunction)psiElement;
        KtExpression fooBody = function.getBodyExpression();
        LexicalScope lexicalScope2 = (LexicalScope)context.get((ReadOnlySlice)BindingContext.LEXICAL_SCOPE, (Object)fooBody);
        Intrinsics.checkNotNull((Object)lexicalScope2);
        this.scopeToResolveTypeParameters = lexicalScope = lexicalScope2;
    }

    private final FunctionDescriptor findFunctionByName(Collection<? extends FunctionDescriptor> functions, String name) {
        Object v0;
        block2: {
            Iterable $this$firstOrNull$iv = functions;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                FunctionDescriptor it = (FunctionDescriptor)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName().asString(), (Object)name)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        FunctionDescriptor functionDescriptor = v0;
        if (functionDescriptor == null) {
            throw new AssertionError((Object)("Function " + name + " is not declared"));
        }
        return functionDescriptor;
    }

    @NotNull
    public final TypeParameterDescriptor getParameterDescriptor(@NotNull String name) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            List list = this.functionFoo.getTypeParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"functionFoo.typeParameters");
            Iterable $this$firstOrNull$iv = list;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                TypeParameterDescriptor it = (TypeParameterDescriptor)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName().asString(), (Object)name)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        TypeParameterDescriptor typeParameterDescriptor = v0;
        if (typeParameterDescriptor == null) {
            throw new AssertionError((Object)("Unsupported type parameter name: " + name + ". You may add it to constraintSystem/declarations.kt"));
        }
        return typeParameterDescriptor;
    }

    @NotNull
    public final KotlinType getType(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Matcher matcher = ConstraintSystemTestDataKt.access$getINTEGER_VALUE_TYPE_PATTERN$p().matcher(name);
        if (matcher.find()) {
            String string = matcher.group(1);
            Intrinsics.checkNotNull((Object)string);
            String number = string;
            CompileTimeConstant.Parameters parameters = new CompileTimeConstant.Parameters(false, false, false, false, false, false, false);
            String string2 = number;
            boolean bl = false;
            boolean bl2 = false;
            return (KotlinType)KotlinTypeFactory.simpleTypeWithNonTrivialMemberScope((Annotations)Annotations.Companion.getEMPTY(), (TypeConstructor)((TypeConstructor)new IntegerValueTypeConstructor(Long.parseLong(string2), DescriptorUtilsKt.getModule((DeclarationDescriptor)((DeclarationDescriptor)this.functionFoo)), parameters)), (List)CollectionsKt.emptyList(), (boolean)false, (MemberScope)((MemberScope)MemberScope.Empty.INSTANCE));
        }
        KtTypeReference ktTypeReference = new KtPsiFactory(this.project, false, 2, null).createType(name);
        BindingTrace bindingTrace = DummyTraces.DUMMY_TRACE;
        Intrinsics.checkNotNullExpressionValue((Object)bindingTrace, (String)"DUMMY_TRACE");
        return this.typeResolver.resolveType(this.scopeToResolveTypeParameters, ktTypeReference, bindingTrace, true);
    }
}

