/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.constraintSystem;

import com.intellij.openapi.project.Project;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.rendering.Renderers;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.TypeResolver;
import org.jetbrains.kotlin.resolve.calls.inference.CallHandle;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintContext;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilderImpl;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.ConstraintPositionKind;
import org.jetbrains.kotlin.resolve.constraintSystem.ConstraintSystemTestData;
import org.jetbrains.kotlin.resolve.lazy.JvmResolveUtil;
import org.jetbrains.kotlin.test.ConfigurationKind;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.KotlinTestWithEnvironment;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.tests.di.InjectionKt;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=50, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u00002\u00020\u0001:\u0002\u001e\u001fB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0011\u001a\u00020\u0004H\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0014J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\bJ\u001c\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\b0\u0018H\u0002J\u001c\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\b0\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\b0\u0018H\u0002J\b\u0010\u001c\u001a\u00020\u0015H\u0014J\b\u0010\u001d\u001a\u00020\u0015H\u0014R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/resolve/constraintSystem/AbstractConstraintSystemTest;", "Lorg/jetbrains/kotlin/test/KotlinTestWithEnvironment;", "()V", "_testDeclarations", "Lorg/jetbrains/kotlin/resolve/constraintSystem/ConstraintSystemTestData;", "_typeResolver", "Lorg/jetbrains/kotlin/resolve/TypeResolver;", "testDataPath", "", "getTestDataPath", "()Ljava/lang/String;", "testDeclarations", "getTestDeclarations", "()Lorg/jetbrains/kotlin/resolve/constraintSystem/ConstraintSystemTestData;", "typeResolver", "getTypeResolver", "()Lorg/jetbrains/kotlin/resolve/TypeResolver;", "analyzeDeclarations", "createEnvironment", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "doTest", "", "filePath", "parseConstraints", "", "Lorg/jetbrains/kotlin/resolve/constraintSystem/AbstractConstraintSystemTest$MyConstraint;", "lines", "parseVariables", "setUp", "tearDown", "MyConstraint", "MyConstraintKind", "tests-common"})
public abstract class AbstractConstraintSystemTest
extends KotlinTestWithEnvironment {
    @Nullable
    private TypeResolver _typeResolver;
    @Nullable
    private ConstraintSystemTestData _testDeclarations;

    private final TypeResolver getTypeResolver() {
        TypeResolver typeResolver = this._typeResolver;
        Intrinsics.checkNotNull((Object)typeResolver);
        return typeResolver;
    }

    private final ConstraintSystemTestData getTestDeclarations() {
        ConstraintSystemTestData constraintSystemTestData = this._testDeclarations;
        Intrinsics.checkNotNull((Object)constraintSystemTestData);
        return constraintSystemTestData;
    }

    @Override
    @NotNull
    protected KotlinCoreEnvironment createEnvironment() {
        KotlinCoreEnvironment kotlinCoreEnvironment = this.createEnvironmentWithMockJdk(ConfigurationKind.ALL);
        Intrinsics.checkNotNullExpressionValue((Object)kotlinCoreEnvironment, (String)"createEnvironmentWithMockJdk(ConfigurationKind.ALL)");
        return kotlinCoreEnvironment;
    }

    @Override
    protected void setUp() {
        super.setUp();
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        Project project2 = project;
        project = KotlinTestUtils.createEmptyModule();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"createEmptyModule()");
        this._typeResolver = InjectionKt.createContainerForTests(project2, (ModuleDescriptor)project).getTypeResolver();
        this._testDeclarations = this.analyzeDeclarations();
    }

    @Override
    protected void tearDown() {
        this._typeResolver = null;
        this._testDeclarations = null;
        super.tearDown();
    }

    private final String getTestDataPath() {
        return Intrinsics.stringPlus((String)KtTestUtil.getTestDataPathBase(), (Object)"/constraintSystem/");
    }

    private final ConstraintSystemTestData analyzeDeclarations() {
        String fileName = "declarations.kt";
        KtFile ktFile = KtTestUtil.createFile((String)fileName, (String)KtTestUtil.doLoadFile((String)this.getTestDataPath(), (String)fileName), (Project)this.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"createFile(\n            fileName,\n            KtTestUtil.doLoadFile(testDataPath, fileName),\n            project\n        )");
        KtFile psiFile = ktFile;
        KotlinCoreEnvironment kotlinCoreEnvironment = this.getEnvironment();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinCoreEnvironment, (String)"environment");
        BindingContext bindingContext = JvmResolveUtil.analyzeAndCheckForErrors((KtFile)psiFile, (KotlinCoreEnvironment)kotlinCoreEnvironment).getBindingContext();
        kotlinCoreEnvironment = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinCoreEnvironment, (String)"project");
        return new ConstraintSystemTestData(bindingContext, (Project)kotlinCoreEnvironment, this.getTypeResolver());
    }

    /*
     * WARNING - void declaration
     */
    public final void doTest(@NotNull String filePath) {
        void $this$mapTo$iv$iv;
        Object object;
        MyConstraintKind it;
        int n2;
        Collection collection;
        Iterator<MyConstraint> $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        File constraintsFile = new File(filePath);
        List constraintsFileText = FilesKt.readLines$default((File)constraintsFile, null, (int)1, null);
        ConstraintSystemBuilderImpl builder = new ConstraintSystemBuilderImpl(null, 1, null);
        List<String> variables = this.parseVariables(constraintsFileText);
        boolean fixVariables = constraintsFileText.contains("FIX_VARIABLES");
        Iterable $this$map$iv = variables;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv2.iterator();
        while (iterator.hasNext()) {
            Object item$iv$iv = iterator.next();
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            n2 = 0;
            object = this.getTestDeclarations().getParameterDescriptor((String)((Object)it));
            collection.add(object);
        }
        List typeParameterDescriptors = (List)destination$iv$iv;
        TypeSubstitutor substitutor = ConstraintSystem.Builder.DefaultImpls.registerTypeVariables$default((ConstraintSystem.Builder)((ConstraintSystem.Builder)builder), (CallHandle)((CallHandle)CallHandle.NONE.INSTANCE), (Collection)typeParameterDescriptors, (boolean)false, (int)4, null);
        List<MyConstraint> constraints = this.parseConstraints(constraintsFileText);
        for (MyConstraint constraint : constraints) {
            KotlinType firstType = AbstractConstraintSystemTest.doTest$getType(this, substitutor, constraint.getFirstType());
            KotlinType secondType = AbstractConstraintSystemTest.doTest$getType(this, substitutor, constraint.getSecondType());
            ConstraintContext context = new ConstraintContext(ConstraintPositionKind.SPECIAL.position(), null, true, true, 2, null);
            it = constraint.getKind();
            n2 = WhenMappings.$EnumSwitchMapping$0[it.ordinal()];
            switch (n2) {
                case 1: {
                    builder.addSubtypeConstraint(firstType, secondType, context.getPosition());
                    break;
                }
                case 2: {
                    builder.addSubtypeConstraint(secondType, firstType, context.getPosition());
                    break;
                }
                case 3: {
                    builder.addConstraint(ConstraintSystemBuilderImpl.ConstraintKind.EQUAL, firstType, secondType, context);
                }
            }
        }
        if (fixVariables) {
            builder.fixVariables();
        }
        ConstraintSystem system = builder.build();
        String resultingStatus = Renderers.INSTANCE.renderConstraintSystem(system, Renderers.ConstraintSystemRenderingVerbosity.COMPACT);
        TypeSubstitutor resultingSubstitutor = system.getResultingSubstitutor();
        Iterable $this$map$iv2 = typeParameterDescriptors;
        boolean $i$f$map2 = false;
        Iterable n2 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string;
            void it2;
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            ConstraintSystemTestData constraintSystemTestData = this.getTestDeclarations();
            String string2 = it2.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.name.asString()");
            KotlinType parameterType = constraintSystemTestData.getType(string2);
            KotlinType resultType = resultingSubstitutor.substitute(parameterType, Variance.INVARIANT);
            StringBuilder stringBuilder = new StringBuilder().append(it2.getName()).append('=');
            KotlinType kotlinType = resultType;
            if (kotlinType == null) {
                string = null;
            } else {
                void it3;
                KotlinType kotlinType2 = kotlinType;
                boolean bl2 = false;
                boolean bl3 = false;
                KotlinType kotlinType3 = kotlinType2;
                StringBuilder stringBuilder2 = stringBuilder;
                boolean bl4 = false;
                String string3 = DescriptorRenderer.SHORT_NAMES_IN_TYPES.renderType((KotlinType)it3);
                stringBuilder = stringBuilder2;
                string = string3;
            }
            object = stringBuilder.append((Object)string).toString();
            collection.add(object);
        }
        String result = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv2), (CharSequence)"\n", (CharSequence)"result:\n", null, (int)0, null, null, (int)60, null);
        File boundsFile = new File(StringsKt.replace$default((String)filePath, (String)"constraints", (String)"bounds", (boolean)false, (int)4, null));
        KotlinTestUtils.assertEqualsToFile(boundsFile, CollectionsKt.joinToString$default((Iterable)constraintsFileText, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null) + "\n\n" + resultingStatus + "\n\n" + result);
    }

    private final List<String> parseVariables(List<String> lines) {
        String first = (String)CollectionsKt.first(lines);
        String variablesString = "VARIABLES ";
        boolean bl = StringsKt.startsWith$default((String)first, (String)variablesString, (boolean)false, (int)2, null);
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = Intrinsics.stringPlus((String)"The first line should contain variables: ", (Object)first);
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        char[] cArray = new char[]{' '};
        List variables = StringsKt.split$default((CharSequence)StringsKt.substringAfter$default((String)first, (String)variablesString, null, (int)2, null), (char[])cArray, (boolean)false, (int)0, (int)6, null);
        return CollectionsKt.toList((Iterable)variables);
    }

    /*
     * WARNING - void declaration
     */
    private final List<MyConstraint> parseConstraints(List<String> lines) {
        void $this$mapTo$iv$iv;
        String line;
        Iterable $this$filterTo$iv$iv;
        Object object;
        Collection collection;
        void $this$mapTo$iv$iv2;
        MyConstraintKind[] $this$map$iv = MyConstraintKind.values();
        boolean $i$f$map = false;
        MyConstraintKind[] myConstraintKindArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            void var12_15 = item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            object = TuplesKt.to((Object)it.getToken(), (Object)it);
            collection.add(object);
        }
        Map kindsMap = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        Set kinds = kindsMap.keySet();
        Iterable $this$filter$iv = lines;
        boolean $i$f$filter = false;
        Iterable $i$f$mapTo22 = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block9: {
                line = (String)element$iv$iv;
                boolean bl2 = false;
                Iterable $this$any$iv = kinds;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String kind = (String)element$iv;
                        boolean bl3 = false;
                        if (!StringsKt.contains$default((CharSequence)line, (CharSequence)kind, (boolean)false, (int)2, null)) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List linesWithConstraints = (List)destination$iv$iv2;
        Iterable $this$map$iv2 = linesWithConstraints;
        boolean $i$f$map2 = false;
        $this$filterTo$iv$iv = $this$map$iv2;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Object element$iv2;
            block10: {
                line = (String)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl = false;
                Iterable $this$first$iv = kinds;
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    String it = (String)element$iv2;
                    boolean bl4 = false;
                    if (!StringsKt.contains$default((CharSequence)line, (CharSequence)it, (boolean)false, (int)2, null)) continue;
                    break block10;
                }
                throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            String kind = (String)element$iv2;
            String $i$f$first = StringsKt.substringBefore$default((String)line, (String)kind, null, (int)2, null);
            boolean bl = false;
            String string = $i$f$first;
            if (string == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String firstType = ((Object)StringsKt.trim((CharSequence)string)).toString();
            Object object2 = StringsKt.substringAfter$default((String)line, (String)kind, null, (int)2, null);
            boolean bl5 = false;
            Object object3 = object2;
            if (object3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
            }
            String secondType = ((Object)StringsKt.trim((CharSequence)((CharSequence)object3))).toString();
            object2 = (MyConstraintKind)((Object)kindsMap.get(kind));
            Intrinsics.checkNotNull((Object)object2);
            object = new MyConstraint((MyConstraintKind)((Object)object2), firstType, secondType);
            collection.add(object);
        }
        return (List)destination$iv$iv2;
    }

    private static final KotlinType doTest$getType(AbstractConstraintSystemTest this$0, TypeSubstitutor substitutor, String typeString) {
        KotlinType kotlinType = this$0.getTestDeclarations().getType(typeString);
        boolean bl = false;
        boolean bl2 = false;
        KotlinType $this$doTest_u24getType_u24lambda_u2d2 = kotlinType;
        boolean bl3 = false;
        boolean bl4 = !ErrorUtils.containsErrorType((KotlinType)$this$doTest_u24getType_u24lambda_u2d2);
        boolean bl5 = false;
        if (_Assertions.ENABLED && !bl4) {
            boolean bl6 = false;
            String string = "Type " + $this$doTest_u24getType_u24lambda_u2d2 + " is resolved to or contains error type";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        KotlinType type = kotlinType;
        if ((kotlinType = substitutor.substitute(type, Variance.INVARIANT)) == null) {
            String string = Intrinsics.stringPlus((String)"Failed to substitute ", (Object)type);
            bl2 = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return kotlinType;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=50, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/resolve/constraintSystem/AbstractConstraintSystemTest$MyConstraint;", "", "kind", "Lorg/jetbrains/kotlin/resolve/constraintSystem/AbstractConstraintSystemTest$MyConstraintKind;", "firstType", "", "secondType", "(Lorg/jetbrains/kotlin/resolve/constraintSystem/AbstractConstraintSystemTest$MyConstraintKind;Ljava/lang/String;Ljava/lang/String;)V", "getFirstType", "()Ljava/lang/String;", "getKind", "()Lorg/jetbrains/kotlin/resolve/constraintSystem/AbstractConstraintSystemTest$MyConstraintKind;", "getSecondType", "tests-common"})
    public static final class MyConstraint {
        @NotNull
        private final MyConstraintKind kind;
        @NotNull
        private final String firstType;
        @NotNull
        private final String secondType;

        public MyConstraint(@NotNull MyConstraintKind kind, @NotNull String firstType, @NotNull String secondType) {
            Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
            Intrinsics.checkNotNullParameter((Object)firstType, (String)"firstType");
            Intrinsics.checkNotNullParameter((Object)secondType, (String)"secondType");
            this.kind = kind;
            this.firstType = firstType;
            this.secondType = secondType;
        }

        @NotNull
        public final MyConstraintKind getKind() {
            return this.kind;
        }

        @NotNull
        public final String getFirstType() {
            return this.firstType;
        }

        @NotNull
        public final String getSecondType() {
            return this.secondType;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=50, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/resolve/constraintSystem/AbstractConstraintSystemTest$MyConstraintKind;", "", "token", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getToken", "()Ljava/lang/String;", "SUBTYPE", "SUPERTYPE", "EQUAL", "tests-common"})
    public static final class MyConstraintKind
    extends Enum<MyConstraintKind> {
        @NotNull
        private final String token;
        public static final /* enum */ MyConstraintKind SUBTYPE = new MyConstraintKind("<:");
        public static final /* enum */ MyConstraintKind SUPERTYPE = new MyConstraintKind(">:");
        public static final /* enum */ MyConstraintKind EQUAL = new MyConstraintKind(":=");
        private static final /* synthetic */ MyConstraintKind[] $VALUES;

        private MyConstraintKind(String token) {
            this.token = token;
        }

        @NotNull
        public final String getToken() {
            return this.token;
        }

        public static MyConstraintKind[] values() {
            MyConstraintKind[] myConstraintKindArray = $VALUES;
            MyConstraintKind[] myConstraintKindArray2 = new MyConstraintKind[myConstraintKindArray.length];
            System.arraycopy(myConstraintKindArray, 0, myConstraintKindArray2, 0, myConstraintKindArray.length);
            return myConstraintKindArray2;
        }

        public static MyConstraintKind valueOf(String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return Enum.valueOf(MyConstraintKind.class, value);
        }

        static {
            $VALUES = myConstraintKindArray = new MyConstraintKind[]{MyConstraintKind.SUBTYPE, MyConstraintKind.SUPERTYPE, MyConstraintKind.EQUAL};
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=3, xi=50)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MyConstraintKind.values().length];
            nArray[MyConstraintKind.SUBTYPE.ordinal()] = 1;
            nArray[MyConstraintKind.SUPERTYPE.ordinal()] = 2;
            nArray[MyConstraintKind.EQUAL.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

