/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jvm.compiler;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import junit.framework.ComparisonFailure;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.checkers.CompilerTestLanguageVersionSettings;
import org.jetbrains.kotlin.checkers.CompilerTestLanguageVersionSettingsKt;
import org.jetbrains.kotlin.cli.common.config.ContentRootsKt;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.compiler.NoScopeRecordCliBindingTrace;
import org.jetbrains.kotlin.cli.jvm.compiler.TopDownAnalyzerFacadeForJVM;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRootsKt;
import org.jetbrains.kotlin.codegen.GenerationUtils;
import org.jetbrains.kotlin.codegen.forTestCompile.ForTestCompileRuntime;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.CompilerConfigurationKey;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.jvm.compiler.DeserializedScopeValidationVisitor;
import org.jetbrains.kotlin.jvm.compiler.ExpectedLoadErrorsUtil;
import org.jetbrains.kotlin.jvm.compiler.LoadDescriptorUtil;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedClassDescriptor;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.ConfigurationKind;
import org.jetbrains.kotlin.test.Directives;
import org.jetbrains.kotlin.test.InTextDirectivesUtils;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TestCaseWithTmpdir;
import org.jetbrains.kotlin.test.TestFiles;
import org.jetbrains.kotlin.test.TestJdkKind;
import org.jetbrains.kotlin.test.util.DescriptorValidator;
import org.jetbrains.kotlin.test.util.JUnit4Assertions;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.test.util.RecursiveDescriptorComparator;
import org.jetbrains.kotlin.test.util.RecursiveDescriptorComparatorAdaptor;
import org.junit.Assert;

public abstract class AbstractLoadJavaTest
extends TestCaseWithTmpdir {
    public static final RecursiveDescriptorComparator.Configuration COMPARATOR_CONFIGURATION = RecursiveDescriptorComparator.DONT_INCLUDE_METHODS_OF_OBJECT.renderDeclarationsFromOtherModules(true);

    protected boolean withForeignAnnotations() {
        return false;
    }

    protected void doTestCompiledJava(@NotNull String javaFileName) throws Exception {
        if (javaFileName == null) {
            AbstractLoadJavaTest.$$$reportNull$$$0(0);
        }
        this.doTestCompiledJava(javaFileName, COMPARATOR_CONFIGURATION);
    }

    protected void doTestCompiledJavaAndKotlin(@NotNull String expectedFileName) throws Exception {
        if (expectedFileName == null) {
            AbstractLoadJavaTest.$$$reportNull$$$0(1);
        }
        File expectedFile = new File(expectedFileName);
        File sourcesDir = new File(expectedFileName.replaceFirst("\\.txt$", ""));
        if (this.useJavacWrapper()) {
            return;
        }
        List kotlinSources = FileUtil.findFilesByMask((Pattern)Pattern.compile(".+\\.kt"), (File)sourcesDir);
        KotlinCoreEnvironment environment = KotlinCoreEnvironment.createForTests((Disposable)this.getTestRootDisposable(), (CompilerConfiguration)KotlinTestUtils.newConfiguration(ConfigurationKind.JDK_ONLY, TestJdkKind.MOCK_JDK, this.getClasspath(new File[0]), Collections.emptyList()), (EnvironmentConfigFiles)EnvironmentConfigFiles.JVM_CONFIG_FILES);
        this.registerJavacIfNeeded(environment);
        this.configureEnvironment(environment);
        LoadDescriptorUtil.compileKotlinToDirAndGetModule(kotlinSources, this.tmpdir, environment);
        List javaSources = FileUtil.findFilesByMask((Pattern)Pattern.compile(".+\\.java"), (File)sourcesDir);
        Pair<PackageViewDescriptor, BindingContext> binaryPackageAndContext = this.compileJavaAndLoadTestPackageAndBindingContextFromBinary(javaSources, this.tmpdir, ConfigurationKind.JDK_ONLY, null);
        AbstractLoadJavaTest.checkJavaPackage(expectedFile, (PackageViewDescriptor)binaryPackageAndContext.first, (BindingContext)binaryPackageAndContext.second, COMPARATOR_CONFIGURATION);
    }

    @NotNull
    protected File getExpectedFile(@NotNull String expectedFileName) {
        if (expectedFileName == null) {
            AbstractLoadJavaTest.$$$reportNull$$$0(2);
        }
        return new File(expectedFileName);
    }

    @NotNull
    private List<File> getClasspath(File ... files) {
        ArrayList<File> classpath = new ArrayList<File>(this.getExtraClasspath());
        classpath.add(KtTestUtil.getAnnotationsJar());
        classpath.addAll(Arrays.asList(files));
        ArrayList<File> arrayList = classpath;
        if (arrayList == null) {
            AbstractLoadJavaTest.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    protected List<File> getExtraClasspath() {
        List<File> list = Collections.emptyList();
        if (list == null) {
            AbstractLoadJavaTest.$$$reportNull$$$0(4);
        }
        return list;
    }

    protected void doTestCompiledJavaIncludeObjectMethods(@NotNull String javaFileName) throws Exception {
        if (javaFileName == null) {
            AbstractLoadJavaTest.$$$reportNull$$$0(5);
        }
        this.doTestCompiledJava(javaFileName, RecursiveDescriptorComparator.RECURSIVE.renderDeclarationsFromOtherModules(true));
    }

    protected void doTestCompiledKotlin(@NotNull String ktFileName) throws Exception {
        if (ktFileName == null) {
            AbstractLoadJavaTest.$$$reportNull$$$0(6);
        }
        this.doTestCompiledKotlin(ktFileName, ConfigurationKind.JDK_ONLY, false);
    }

    protected void doTestCompiledKotlinWithTypeTable(@NotNull String ktFileName) throws Exception {
        if (ktFileName == null) {
            AbstractLoadJavaTest.$$$reportNull$$$0(7);
        }
        this.doTestCompiledKotlin(ktFileName, ConfigurationKind.JDK_ONLY, true);
    }

    protected void doTestCompiledKotlinWithStdlib(@NotNull String ktFileName) throws Exception {
        if (ktFileName == null) {
            AbstractLoadJavaTest.$$$reportNull$$$0(8);
        }
        this.doTestCompiledKotlin(ktFileName, ConfigurationKind.ALL, false);
    }

    private void doTestCompiledKotlin(@NotNull String ktFileName, @NotNull ConfigurationKind configurationKind, boolean useTypeTableInSerializer) throws Exception {
        if (ktFileName == null) {
            AbstractLoadJavaTest.$$$reportNull$$$0(9);
        }
        if (configurationKind == null) {
            AbstractLoadJavaTest.$$$reportNull$$$0(10);
        }
        File ktFile = new File(ktFileName);
        File txtFile = this.getTxtFileFromKtFile(ktFileName);
        CompilerConfiguration configuration = KotlinTestUtils.newConfiguration(configurationKind, TestJdkKind.MOCK_JDK, this.getClasspath(new File[0]), Collections.emptyList());
        this.updateConfiguration(configuration);
        if (useTypeTableInSerializer) {
            configuration.put(JVMConfigurationKeys.USE_TYPE_TABLE, (Object)true);
        }
        String fileContent = FileUtil.loadFile((File)ktFile, (boolean)true);
        AbstractLoadJavaTest.updateConfigurationWithDirectives(fileContent, configuration);
        KotlinCoreEnvironment environment = KotlinCoreEnvironment.createForTests((Disposable)this.getTestRootDisposable(), (CompilerConfiguration)configuration, (EnvironmentConfigFiles)EnvironmentConfigFiles.JVM_CONFIG_FILES);
        this.registerJavacIfNeeded(environment);
        this.configureEnvironment(environment);
        ModuleDescriptor module2 = LoadDescriptorUtil.compileKotlinToDirAndGetModule(Collections.singletonList(ktFile), this.tmpdir, environment);
        PackageViewDescriptor packageFromSource = module2.getPackage(LoadDescriptorUtil.TEST_PACKAGE_FQNAME);
        Assert.assertEquals((Object)"test", (Object)packageFromSource.getName().asString());
        PackageViewDescriptor packageFromBinary = (PackageViewDescriptor)LoadDescriptorUtil.loadTestPackageAndBindingContextFromJavaRoot((File)this.tmpdir, (Disposable)this.getTestRootDisposable(), (TestJdkKind)this.getJdkKind(), (ConfigurationKind)configurationKind, (boolean)true, (boolean)false, (boolean)this.useJavacWrapper(), (boolean)this.withForeignAnnotations(), (LanguageVersionSettings)((LanguageVersionSettings)configuration.get((CompilerConfigurationKey)CommonConfigurationKeys.LANGUAGE_VERSION_SETTINGS)), this.getExtraClasspath(), (Consumer<KotlinCoreEnvironment>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, configureEnvironment(org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment ), (Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;)V)((AbstractLoadJavaTest)this)).first;
        for (DeclarationDescriptor descriptor : DescriptorUtils.getAllDescriptors((MemberScope)packageFromBinary.getMemberScope())) {
            if (descriptor instanceof ClassDescriptor) assert (descriptor instanceof DeserializedClassDescriptor) : DescriptorUtils.getFqName((DeclarationDescriptor)descriptor) + " is loaded as " + descriptor.getClass();
        }
        DescriptorValidator.validate((DescriptorValidator.ValidationVisitor)DescriptorValidator.ValidationVisitor.errorTypesForbidden(), (DeclarationDescriptor)packageFromSource);
        DescriptorValidator.validate((DescriptorValidator.ValidationVisitor)new DeserializedScopeValidationVisitor(), (DeclarationDescriptor)packageFromBinary);
        RecursiveDescriptorComparator.Configuration comparatorConfiguration = COMPARATOR_CONFIGURATION.checkPrimaryConstructors(true).checkPropertyAccessors(true).checkFunctionContracts(true);
        if (InTextDirectivesUtils.isDirectiveDefined((String)fileContent, (String)"NO_CHECK_SOURCE_VS_BINARY")) {
            RecursiveDescriptorComparatorAdaptor.validateAndCompareDescriptorWithFile((DeclarationDescriptor)packageFromBinary, comparatorConfiguration, txtFile);
        } else {
            RecursiveDescriptorComparatorAdaptor.compareDescriptors((DeclarationDescriptor)packageFromSource, (DeclarationDescriptor)packageFromBinary, comparatorConfiguration, txtFile);
        }
    }

    public static void updateConfigurationWithDirectives(String content2, CompilerConfiguration configuration) {
        Directives directives = KotlinTestUtils.parseDirectives(content2);
        CompilerTestLanguageVersionSettings languageVersionSettings = CompilerTestLanguageVersionSettingsKt.parseLanguageVersionSettings(directives);
        if (languageVersionSettings == null) {
            languageVersionSettings = CompilerTestLanguageVersionSettingsKt.defaultLanguageVersionSettings();
        }
        CommonConfigurationKeysKt.setLanguageVersionSettings((CompilerConfiguration)configuration, (LanguageVersionSettings)languageVersionSettings);
        if (InTextDirectivesUtils.isDirectiveDefined((String)content2, (String)"ANDROID_ANNOTATIONS")) {
            JvmContentRootsKt.addJvmClasspathRoot((CompilerConfiguration)configuration, (File)ForTestCompileRuntime.androidAnnotationsForTests());
        }
        if (InTextDirectivesUtils.isDirectiveDefined((String)content2, (String)"JVM_ANNOTATIONS")) {
            JvmContentRootsKt.addJvmClasspathRoot((CompilerConfiguration)configuration, (File)ForTestCompileRuntime.jvmAnnotationsForTests());
        }
    }

    protected boolean usePsiClassFilesReading() {
        return false;
    }

    protected boolean useJavacWrapper() {
        return false;
    }

    protected void registerJavacIfNeeded(KotlinCoreEnvironment environment) {
    }

    protected void configureEnvironment(KotlinCoreEnvironment environment) {
    }

    protected void updateConfiguration(CompilerConfiguration configuration) {
    }

    protected void doTestJavaAgainstKotlin(String expectedFileName) throws Exception {
        File expectedFile = new File(expectedFileName);
        File sourcesDir = new File(expectedFileName.replaceFirst("\\.txt$", ""));
        FileUtil.copyDir((File)sourcesDir, (File)new File(this.tmpdir, "test"), pathname -> pathname.getName().endsWith(".java"));
        CompilerConfiguration configuration = KotlinTestUtils.newConfiguration(ConfigurationKind.JDK_ONLY, this.getJdkKind(), new File[0]);
        this.updateConfiguration(configuration);
        ContentRootsKt.addKotlinSourceRoot((CompilerConfiguration)configuration, (String)sourcesDir.getAbsolutePath());
        JvmContentRootsKt.addJavaSourceRoot((CompilerConfiguration)configuration, (File)new File("compiler/testData/loadJava/include"));
        JvmContentRootsKt.addJavaSourceRoot((CompilerConfiguration)configuration, (File)this.tmpdir);
        KotlinCoreEnvironment environment = KotlinCoreEnvironment.createForTests((Disposable)this.getTestRootDisposable(), (CompilerConfiguration)configuration, (EnvironmentConfigFiles)EnvironmentConfigFiles.JVM_CONFIG_FILES);
        this.registerJavacIfNeeded(environment);
        this.configureEnvironment(environment);
        AnalysisResult result = TopDownAnalyzerFacadeForJVM.analyzeFilesWithJavaIntegration((Project)environment.getProject(), (Collection)environment.getSourceFiles(), (BindingTrace)new NoScopeRecordCliBindingTrace(), (CompilerConfiguration)configuration, arg_0 -> ((KotlinCoreEnvironment)environment).createPackagePartProvider(arg_0));
        PackageViewDescriptor packageView = result.getModuleDescriptor().getPackage(LoadDescriptorUtil.TEST_PACKAGE_FQNAME);
        AbstractLoadJavaTest.checkJavaPackage(expectedFile, packageView, result.getBindingContext(), COMPARATOR_CONFIGURATION);
    }

    protected void doTestKotlinAgainstCompiledJavaWithKotlin(@NotNull String expectedFileName) throws Exception {
        if (expectedFileName == null) {
            AbstractLoadJavaTest.$$$reportNull$$$0(11);
        }
        File kotlinSrc = new File(expectedFileName);
        File librarySrc = new File(expectedFileName.replaceFirst("\\.kt$", ""));
        File expectedFile = new File(expectedFileName.replaceFirst("\\.kt$", ".txt"));
        File libraryOut = new File(this.tmpdir, "libraryOut");
        KotlinTestUtils.compileKotlinWithJava(FileUtil.findFilesByMask((Pattern)Pattern.compile(".+\\.java$"), (File)librarySrc), FileUtil.findFilesByMask((Pattern)Pattern.compile(".+\\.kt$"), (File)librarySrc), libraryOut, this.getTestRootDisposable(), null);
        KotlinCoreEnvironment environment = KotlinCoreEnvironment.createForTests((Disposable)this.getTestRootDisposable(), (CompilerConfiguration)KotlinTestUtils.newConfiguration(ConfigurationKind.JDK_ONLY, this.getJdkKind(), this.getClasspath(libraryOut), Collections.emptyList()), (EnvironmentConfigFiles)EnvironmentConfigFiles.JVM_CONFIG_FILES);
        this.registerJavacIfNeeded(environment);
        this.configureEnvironment(environment);
        KtFile ktFile = KtTestUtil.createFile((String)kotlinSrc.getPath(), (String)FileUtil.loadFile((File)kotlinSrc, (boolean)true), (Project)environment.getProject());
        ModuleDescriptor module2 = GenerationUtils.compileFiles(Collections.singletonList(ktFile), (KotlinCoreEnvironment)environment).getModule();
        PackageViewDescriptor packageView = module2.getPackage(LoadDescriptorUtil.TEST_PACKAGE_FQNAME);
        AbstractLoadJavaTest.assertFalse((boolean)packageView.isEmpty());
        RecursiveDescriptorComparatorAdaptor.validateAndCompareDescriptorWithFile((DeclarationDescriptor)packageView, COMPARATOR_CONFIGURATION.withValidationStrategy((DescriptorValidator.ValidationVisitor)new DeserializedScopeValidationVisitor()), expectedFile);
    }

    @NotNull
    protected TestJdkKind getJdkKind() {
        TestJdkKind testJdkKind = TestJdkKind.MOCK_JDK;
        if (testJdkKind == null) {
            AbstractLoadJavaTest.$$$reportNull$$$0(12);
        }
        return testJdkKind;
    }

    protected void doTestSourceJava(@NotNull String javaFileName) throws Exception {
        if (javaFileName == null) {
            AbstractLoadJavaTest.$$$reportNull$$$0(13);
        }
        File originalJavaFile = new File(javaFileName);
        File expectedFile = this.getTxtFile(javaFileName);
        File testPackageDir = new File(this.tmpdir, "test");
        AbstractLoadJavaTest.assertTrue((boolean)testPackageDir.mkdir());
        FileUtil.copy((File)originalJavaFile, (File)new File(testPackageDir, originalJavaFile.getName()));
        Directives directives = KotlinTestUtils.parseDirectives(FileUtil.loadFile((File)originalJavaFile));
        CompilerTestLanguageVersionSettings languageVersionSettings = CompilerTestLanguageVersionSettingsKt.parseLanguageVersionSettings(directives);
        Pair<PackageViewDescriptor, BindingContext> javaPackageAndContext = LoadDescriptorUtil.loadTestPackageAndBindingContextFromJavaRoot(this.tmpdir, this.getTestRootDisposable(), this.getJdkKind(), ConfigurationKind.JDK_ONLY, false, false, this.useJavacWrapper(), this.withForeignAnnotations(), languageVersionSettings);
        AbstractLoadJavaTest.checkJavaPackage(expectedFile, (PackageViewDescriptor)javaPackageAndContext.first, (BindingContext)javaPackageAndContext.second, COMPARATOR_CONFIGURATION.withValidationStrategy(DescriptorValidator.ValidationVisitor.errorTypesAllowed()));
    }

    private void doTestCompiledJava(@NotNull String javaFileName, RecursiveDescriptorComparator.Configuration configuration) throws Exception {
        if (javaFileName == null) {
            AbstractLoadJavaTest.$$$reportNull$$$0(14);
        }
        final File srcDir = new File(this.tmpdir, "src");
        File compiledDir = new File(this.tmpdir, "compiled");
        AbstractLoadJavaTest.assertTrue((boolean)srcDir.mkdir());
        AbstractLoadJavaTest.assertTrue((boolean)compiledDir.mkdir());
        String fileContent = FileUtil.loadFile((File)new File(javaFileName));
        List<File> srcFiles = TestFiles.createTestFiles(new File(javaFileName).getName(), fileContent, new TestFiles.TestFileFactoryNoModules<File>(){

            @Override
            @NotNull
            public File create(@NotNull String fileName, @NotNull String text, @NotNull Directives directives) {
                if (fileName == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (text == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (directives == null) {
                    1.$$$reportNull$$$0(2);
                }
                File targetFile = new File(srcDir, fileName);
                try {
                    FileUtil.writeToFile((File)targetFile, (String)text);
                }
                catch (IOException e) {
                    throw new AssertionError((Object)e);
                }
                File file = targetFile;
                if (file == null) {
                    1.$$$reportNull$$$0(3);
                }
                return file;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "fileName";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "text";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "directives";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/kotlin/jvm/compiler/AbstractLoadJavaTest$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/kotlin/jvm/compiler/AbstractLoadJavaTest$1";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "create";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "create";
                        break;
                    }
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        Directives directives = KotlinTestUtils.parseDirectives(fileContent);
        CompilerTestLanguageVersionSettings languageVersionSettings = CompilerTestLanguageVersionSettingsKt.parseLanguageVersionSettings(directives);
        Pair<PackageViewDescriptor, BindingContext> javaPackageAndContext = this.compileJavaAndLoadTestPackageAndBindingContextFromBinary(srcFiles, compiledDir, ConfigurationKind.ALL, languageVersionSettings);
        AbstractLoadJavaTest.checkJavaPackage(this.getExpectedFile(AbstractLoadJavaTest.useTxtSuffixIfFileExists(javaFileName.replaceFirst("\\.java$", ".txt"), "compiled")), (PackageViewDescriptor)javaPackageAndContext.first, (BindingContext)javaPackageAndContext.second, configuration);
    }

    public static String useTxtSuffixIfFileExists(String name, String suffix) {
        File differentResultFile = KotlinTestUtils.replaceExtension(new File(name), suffix + ".txt");
        if (differentResultFile.exists()) {
            return differentResultFile.getPath();
        }
        return name;
    }

    @NotNull
    private Pair<PackageViewDescriptor, BindingContext> compileJavaAndLoadTestPackageAndBindingContextFromBinary(@NotNull Collection<File> javaFiles, @NotNull File outDir, @NotNull ConfigurationKind configurationKind, @Nullable LanguageVersionSettings explicitLanguageVersionSettings) throws IOException {
        if (javaFiles == null) {
            AbstractLoadJavaTest.$$$reportNull$$$0(15);
        }
        if (outDir == null) {
            AbstractLoadJavaTest.$$$reportNull$$$0(16);
        }
        if (configurationKind == null) {
            AbstractLoadJavaTest.$$$reportNull$$$0(17);
        }
        LoadDescriptorUtil.compileJavaWithAnnotationsJar(javaFiles, outDir, this.getAdditionalJavacArgs(), this.getJdkHomeForJavac(), this.withForeignAnnotations());
        Pair<PackageViewDescriptor, BindingContext> pair = LoadDescriptorUtil.loadTestPackageAndBindingContextFromJavaRoot(outDir, this.getTestRootDisposable(), this.getJdkKind(), configurationKind, true, this.usePsiClassFilesReading(), this.useJavacWrapper(), this.withForeignAnnotations(), explicitLanguageVersionSettings, this.getExtraClasspath(), this::configureEnvironment);
        if (pair == null) {
            AbstractLoadJavaTest.$$$reportNull$$$0(18);
        }
        return pair;
    }

    protected List<String> getAdditionalJavacArgs() {
        return Collections.emptyList();
    }

    @Nullable
    protected File getJdkHomeForJavac() {
        return null;
    }

    private static void checkJavaPackage(File txtFile, PackageViewDescriptor javaPackage, BindingContext bindingContext, RecursiveDescriptorComparator.Configuration configuration) {
        boolean fail = false;
        try {
            ExpectedLoadErrorsUtil.checkForLoadErrors((PackageViewDescriptor)javaPackage, (BindingContext)bindingContext, (Assertions)JUnit4Assertions.INSTANCE);
        }
        catch (ComparisonFailure e) {
            System.err.println("Expected: " + e.getExpected());
            System.err.println("Actual  : " + e.getActual());
            e.printStackTrace();
            fail = true;
        }
        catch (AssertionError e) {
            ((Throwable)((Object)e)).printStackTrace();
            fail = true;
        }
        RecursiveDescriptorComparatorAdaptor.validateAndCompareDescriptorWithFile((DeclarationDescriptor)javaPackage, configuration, txtFile);
        if (fail) {
            AbstractLoadJavaTest.fail((String)"See error above");
        }
    }

    private File getTxtFile(String javaFileName) {
        try {
            String fileText = FileUtil.loadFile((File)new File(javaFileName));
            if (this.useJavacWrapper() && InTextDirectivesUtils.isDirectiveDefined((String)fileText, (String)"// JAVAC_EXPECTED_FILE")) {
                return new File(javaFileName.replaceFirst("\\.java$", ".javac.txt"));
            }
            return new File(javaFileName.replaceFirst("\\.java$", ".txt"));
        }
        catch (IOException e) {
            return new File(javaFileName.replaceFirst("\\.java$", ".txt"));
        }
    }

    private File getTxtFileFromKtFile(String ktFileName) {
        try {
            String fileText = FileUtil.loadFile((File)new File(ktFileName));
            if (this.useJavacWrapper() && InTextDirectivesUtils.isDirectiveDefined((String)fileText, (String)"// JAVAC_EXPECTED_FILE")) {
                return new File(ktFileName.replaceFirst("\\.kt$", ".javac.txt"));
            }
            return new File(ktFileName.replaceFirst("\\.kt$", ".txt"));
        }
        catch (IOException e) {
            return new File(ktFileName.replaceFirst("\\.kt$", ".txt"));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 12: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 12: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaFileName";
                break;
            }
            case 1: 
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedFileName";
                break;
            }
            case 3: 
            case 4: 
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/jvm/compiler/AbstractLoadJavaTest";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ktFileName";
                break;
            }
            case 10: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationKind";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaFiles";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/jvm/compiler/AbstractLoadJavaTest";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getClasspath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtraClasspath";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getJdkKind";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "compileJavaAndLoadTestPackageAndBindingContextFromBinary";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doTestCompiledJava";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "doTestCompiledJavaAndKotlin";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getExpectedFile";
                break;
            }
            case 3: 
            case 4: 
            case 12: 
            case 18: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doTestCompiledJavaIncludeObjectMethods";
                break;
            }
            case 6: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "doTestCompiledKotlin";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doTestCompiledKotlinWithTypeTable";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doTestCompiledKotlinWithStdlib";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "doTestKotlinAgainstCompiledJavaWithKotlin";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "doTestSourceJava";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "compileJavaAndLoadTestPackageAndBindingContextFromBinary";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 12: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

