/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir;

import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.serialization.signature.IdSignatureDescriptor;
import org.jetbrains.kotlin.cli.js.K2JsIrCompilerKt;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FindClassInModuleKt;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.ir.AbstractIrGeneratorTestCase;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrVerifier;
import org.jetbrains.kotlin.ir.backend.js.lower.serialization.ir.JsManglerDesc;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.impl.IrFactoryImpl;
import org.jetbrains.kotlin.ir.util.DeclarationStubGenerator;
import org.jetbrains.kotlin.ir.util.DeepCopyIrTreeWithSymbols;
import org.jetbrains.kotlin.ir.util.DeepCopySymbolRemapper;
import org.jetbrains.kotlin.ir.util.DeepCopyTypeRemapper;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.DumpKotlinLikeKt;
import org.jetbrains.kotlin.ir.util.FakeOverridesStrategy;
import org.jetbrains.kotlin.ir.util.IdSignatureComposer;
import org.jetbrains.kotlin.ir.util.KotlinLikeDumpOptions;
import org.jetbrains.kotlin.ir.util.KotlinMangler;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.SymbolRemapper;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.ir.util.TypeRemapper;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformer;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoidKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.scripting.compiler.plugin.JsScriptEvaluationExtensionKt;
import org.jetbrains.kotlin.test.Assertions;
import org.jetbrains.kotlin.test.KotlinBaseTest;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.testFramework.KtUsefulTestCase;
import org.jetbrains.kotlin.test.util.JUnit4Assertions;
import org.jetbrains.kotlin.utils.ExceptionUtilsKt;
import org.jetbrains.kotlin.utils.fileUtils.FileUtilsKt;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=50, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000 \"2\u00020\u0001:\u0004\"#$%B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0004J\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0014J\u001e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0014J \u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0004H\u0002J\u001a\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\t2\b\b\u0002\u0010\u0018\u001a\u00020\u0017H\u0014J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\tH\u0002J\u0010\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001c\u0010\u001c\u001a\u00020\u001d*\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0017H\u0002\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/ir/AbstractIrTextTestCase;", "Lorg/jetbrains/kotlin/ir/AbstractIrGeneratorTestCase;", "()V", "buildFragmentAndTestIt", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "wholeFile", "Ljava/io/File;", "testFiles", "", "Lorg/jetbrains/kotlin/test/KotlinBaseTest$TestFile;", "configureTestSpecific", "", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "doTest", "doTestIrFileAgainstExpectations", "dir", "testFile", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "doTestIrModuleDependencies", "irModule", "getExpectedTextFileName", "", "name", "parseExpectations", "Lorg/jetbrains/kotlin/ir/AbstractIrTextTestCase$Expectations;", "verify", "generateExternalClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "Lorg/jetbrains/kotlin/ir/util/DeclarationStubGenerator;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "externalClassFqn", "Companion", "Expectations", "IrTreeFileLabel", "RegexpInText", "tests-common"})
public abstract class AbstractIrTextTestCase
extends AbstractIrGeneratorTestCase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Regex EXPECTED_OCCURRENCES_PATTERN = new Regex("^\\s*//\\s*(\\d+)\\s*(.*)$");
    @NotNull
    private static final Regex IR_FILE_TXT_PATTERN = new Regex("// IR_FILE: (.*)$");
    @NotNull
    private static final Regex DUMP_EXTERNAL_CLASS = new Regex("// DUMP_EXTERNAL_CLASS (.*)");
    @NotNull
    private static final Regex EXTERNAL_FILE_PATTERN = new Regex("// EXTERNAL_FILE");

    @Override
    protected void doTest(@NotNull File wholeFile, @NotNull List<? extends KotlinBaseTest.TestFile> testFiles) {
        Intrinsics.checkNotNullParameter((Object)wholeFile, (String)"wholeFile");
        Intrinsics.checkNotNullParameter(testFiles, (String)"testFiles");
        IrModuleFragment irModule = this.buildFragmentAndTestIt(wholeFile, testFiles);
        this.doTestIrModuleDependencies(wholeFile, irModule);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final IrModuleFragment buildFragmentAndTestIt(@NotNull File wholeFile, @NotNull List<? extends KotlinBaseTest.TestFile> testFiles) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)wholeFile, (String)"wholeFile");
        Intrinsics.checkNotNullParameter(testFiles, (String)"testFiles");
        File dir = wholeFile.getParentFile();
        boolean ignoreErrors = AbstractIrGeneratorTestCase.Companion.shouldIgnoreErrors$tests_common(wholeFile);
        IrModuleFragment irModule = this.generateIrModule(ignoreErrors);
        Iterable $this$filter$iv = testFiles;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KotlinBaseTest.TestFile it = (KotlinBaseTest.TestFile)element$iv$iv;
            boolean bl = false;
            if (!(StringsKt.endsWith$default((String)it.name, (String)".kt", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)it.name, (String)".kts", (boolean)false, (int)2, null))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List ktFiles = (List)destination$iv$iv;
        for (Pair pair : CollectionsKt.zip((Iterable)ktFiles, (Iterable)irModule.getFiles())) {
            KotlinBaseTest.TestFile testFile = (KotlinBaseTest.TestFile)pair.component1();
            IrFile irFile = (IrFile)pair.component2();
            Intrinsics.checkNotNullExpressionValue((Object)dir, (String)"dir");
            this.doTestIrFileAgainstExpectations(dir, testFile, irFile);
        }
        return irModule;
    }

    /*
     * WARNING - void declaration
     */
    private final void doTestIrModuleDependencies(File wholeFile, IrModuleFragment irModule) {
        void destination$iv;
        void $this$mapNotNullTo$iv;
        String wholeText = FilesKt.readText$default((File)wholeFile, null, (int)1, null);
        JsManglerDesc mangler = JsManglerDesc.INSTANCE;
        IdSignatureDescriptor signaturer = new IdSignatureDescriptor((KotlinMangler.DescriptorMangler)mangler);
        DeclarationStubGenerator stubGenerator = new DeclarationStubGenerator(irModule.getDescriptor(), new SymbolTable((IdSignatureComposer)signaturer, (IrFactory)IrFactoryImpl.INSTANCE, null, 4, null), CommonConfigurationKeysKt.getLanguageVersionSettings((CompilerConfiguration)this.myEnvironment.getConfiguration()), null, 8, null);
        String path = wholeFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
        String replacedPath = StringsKt.replace$default((String)path, (String)".kt", (String)"__", (boolean)false, (int)4, null);
        File[] fileArray = wholeFile.getParentFile().listFiles();
        if (fileArray == null) {
            return;
        }
        File[] filesInDir = fileArray;
        File[] fileArray2 = filesInDir;
        boolean bl = false;
        Collection collection = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Collection collection2 = $this$forEach$iv$iv;
        int n = ((void)collection2).length;
        for (int i = 0; i < n; ++i) {
            String string;
            void element$iv$iv;
            void element$iv = element$iv$iv = collection2[i];
            boolean bl2 = false;
            void it = element$iv;
            boolean bl3 = false;
            String string2 = it.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.path");
            if ((StringsKt.startsWith$default((String)string2, (String)replacedPath, (boolean)false, (int)2, null) ? it.getPath() : null) == null) continue;
            string = string;
            boolean bl4 = false;
            boolean bl5 = false;
            String it$iv = string;
            boolean bl6 = false;
            destination$iv.add(it$iv);
        }
        List externalFilePaths = (List)destination$iv;
        for (String externalClassFqn : Companion.parseDumpExternalClasses$tests_common(wholeText)) {
            String classDump = DumpIrTreeKt.dump$default((IrElement)((IrElement)this.generateExternalClass(stubGenerator, irModule.getDescriptor(), externalClassFqn)), (boolean)false, (int)1, null);
            String expectedFilePath = StringsKt.replace$default((String)path, (String)".kt", (String)("__" + externalClassFqn + ".txt"), (boolean)false, (int)4, null);
            File expectedFile = new File(expectedFilePath);
            collection2 = externalFilePaths;
            n = 0;
            collection2.remove(expectedFilePath);
            KotlinTestUtils.assertEqualsToFile(expectedFile, classDump);
        }
        KtUsefulTestCase.assertEmpty(Intrinsics.stringPlus((String)"The following external dump files were not built: ", (Object)externalFilePaths), externalFilePaths);
    }

    private final IrClass generateExternalClass(DeclarationStubGenerator $this$generateExternalClass, ModuleDescriptor descriptor, String externalClassFqn) {
        ClassId classId = ClassId.topLevel((FqName)new FqName(externalClassFqn));
        Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"topLevel(FqName(externalClassFqn))");
        ClassDescriptor classDescriptor = FindClassInModuleKt.findClassAcrossModuleDependencies((ModuleDescriptor)descriptor, (ClassId)classId);
        if (classDescriptor == null) {
            throw new AssertionError((Object)Intrinsics.stringPlus((String)"Can't find a class in external dependencies: ", (Object)externalClassFqn));
        }
        ClassDescriptor classDescriptor2 = classDescriptor;
        return (IrClass)$this$generateExternalClass.generateMemberStub((DeclarationDescriptor)classDescriptor2);
    }

    @Override
    protected void configureTestSpecific(@NotNull CompilerConfiguration configuration, @NotNull List<? extends KotlinBaseTest.TestFile> testFiles) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            Intrinsics.checkNotNullParameter(testFiles, (String)"testFiles");
            Iterable $this$any$iv = testFiles;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    KotlinBaseTest.TestFile it = (KotlinBaseTest.TestFile)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.endsWith$default((String)it.name, (String)".kts", (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            JsScriptEvaluationExtensionKt.loadScriptConfiguration((CompilerConfiguration)configuration);
            K2JsIrCompilerKt.loadPluginsForTests((CompilerConfiguration)configuration);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void doTestIrFileAgainstExpectations(File dir, KotlinBaseTest.TestFile testFile, IrFile irFile) {
        if (Companion.isExternalFile$tests_common(testFile)) {
            return;
        }
        Expectations expectations = this.parseExpectations(dir, testFile);
        String irFileDump = DumpIrTreeKt.dump((IrElement)((IrElement)irFile), (boolean)true);
        StringBuilder expected = new StringBuilder();
        StringBuilder actual2 = new StringBuilder();
        for (RegexpInText expectation : expectations.getRegexps()) {
            expected.append(expectation.getNumberOfOccurrences()).append(" ").append(expectation.getNeedle()).append("\n");
            int actualCount = StringUtil.findMatches((String)irFileDump, (Pattern)Pattern.compile('(' + expectation.getNeedle() + ')')).size();
            actual2.append(actualCount).append(" ").append(expectation.getNeedle()).append("\n");
        }
        for (IrTreeFileLabel irTreeFileLabel : expectations.getIrTreeFileLabels()) {
            void p1;
            void p0;
            String actualTrees = DumpIrTreeKt.dumpTreesFromLineNumber((IrFile)irFile, (int)irTreeFileLabel.getLineNumber(), (boolean)true);
            KotlinTestUtils.assertEqualsToFile(irTreeFileLabel.getExpectedTextFile(), actualTrees);
            this.verify(irFile);
            IrElement $this$deepCopyWithSymbols_u24default$iv = (IrElement)irFile;
            IrDeclarationParent initialParent$iv = null;
            boolean $i$f$deepCopyWithSymbols = false;
            DeepCopySymbolRemapper symbolRemapper$iv = new DeepCopySymbolRemapper(null, 1, null);
            IrElementVisitorVoidKt.acceptVoid((IrElement)$this$deepCopyWithSymbols_u24default$iv, (IrElementVisitorVoid)((IrElementVisitorVoid)symbolRemapper$iv));
            DeepCopyTypeRemapper typeRemapper$iv = new DeepCopyTypeRemapper((SymbolRemapper)symbolRemapper$iv);
            TypeRemapper typeRemapper = (TypeRemapper)typeRemapper$iv;
            SymbolRemapper symbolRemapper = (SymbolRemapper)symbolRemapper$iv;
            IrElement irElement = $this$deepCopyWithSymbols_u24default$iv;
            DeepCopyIrTreeWithSymbols deepCopyIrTreeWithSymbols = new DeepCopyIrTreeWithSymbols((SymbolRemapper)p0, (TypeRemapper)p1);
            IrElement irElement2 = PatchDeclarationParentsKt.patchDeclarationParents((IrElement)irElement.transform((IrElementTransformer)deepCopyIrTreeWithSymbols, null), initialParent$iv);
            if (irElement2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrFile");
            }
            IrFile irFileCopy = (IrFile)((IrElement)((IrFile)irElement2));
            String copiedTrees = DumpIrTreeKt.dumpTreesFromLineNumber((IrFile)irFileCopy, (int)irTreeFileLabel.getLineNumber(), (boolean)true);
            TestCase.assertEquals((String)"IR dump mismatch after deep copy with symbols", (String)actualTrees, (String)copiedTrees);
            this.verify(irFileCopy);
            if (testFile.directives.contains("SKIP_KT_DUMP")) continue;
            String kotlinLikeDump = DumpKotlinLikeKt.dumpKotlinLike((IrElement)((IrElement)irFile), (KotlinLikeDumpOptions)new KotlinLikeDumpOptions(false, false, false, false, null, FakeOverridesStrategy.NONE, 25, null));
            File file = FileUtilsKt.withReplacedExtensionOrNull((File)irTreeFileLabel.getExpectedTextFile(), (String)".txt", (String)".kt.txt");
            Intrinsics.checkNotNull((Object)file);
            File kotlinLikeDumpExpectedFile = file;
            KotlinTestUtils.assertEqualsToFile(kotlinLikeDumpExpectedFile, kotlinLikeDump);
        }
        try {
            TestCase.assertEquals((String)irFileDump, (String)expected.toString(), (String)actual2.toString());
        }
        catch (Throwable e) {
            boolean bl = false;
            System.out.println((Object)irFileDump);
            throw ExceptionUtilsKt.rethrow((Throwable)e);
        }
    }

    private final void verify(IrFile irFile) {
        new IrVerifier((Assertions)JUnit4Assertions.INSTANCE).verifyWithAssert(irFile);
    }

    @NotNull
    protected String getExpectedTextFileName(@NotNull KotlinBaseTest.TestFile testFile, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)testFile, (String)"testFile");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return StringsKt.replace$default((String)StringsKt.replace$default((String)name, (String)".kts", (String)".txt", (boolean)false, (int)4, null), (String)".kt", (String)".txt", (boolean)false, (int)4, null);
    }

    public static /* synthetic */ String getExpectedTextFileName$default(AbstractIrTextTestCase abstractIrTextTestCase, KotlinBaseTest.TestFile testFile, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getExpectedTextFileName");
        }
        if ((n & 2) != 0) {
            string = testFile.name;
        }
        return abstractIrTextTestCase.getExpectedTextFileName(testFile, string);
    }

    /*
     * WARNING - void declaration
     */
    private final Expectations parseExpectations(File dir, KotlinBaseTest.TestFile testFile) {
        void $this$mapNotNullTo$iv$iv$iv;
        void $this$matchLinesWith$iv;
        boolean bl;
        MatchResult matchResult;
        void $this$mapNotNullTo$iv$iv$iv2;
        Companion $this$matchLinesWith$iv2;
        Companion companion = Companion;
        String string = testFile.content;
        Object regex$iv = EXPECTED_OCCURRENCES_PATTERN;
        boolean $i$f$matchLinesWith = false;
        Iterable $this$mapNotNull$iv$iv = StringsKt.lines((CharSequence)((CharSequence)((Object)$this$matchLinesWith$iv2)));
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv$iv;
        Iterable<RegexpInText> destination$iv$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv$iv = $this$mapNotNullTo$iv$iv$iv2;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            RegexpInText regexpInText;
            Object element$iv$iv$iv$iv;
            Object element$iv$iv$iv = element$iv$iv$iv$iv = iterator.next();
            boolean bl2 = false;
            String it$iv = (String)element$iv$iv$iv;
            boolean bl3 = false;
            MatchResult matchResult2 = regex$iv.matchEntire((CharSequence)it$iv);
            if (matchResult2 == null) {
                regexpInText = null;
            } else {
                matchResult = matchResult2;
                boolean bl4 = false;
                bl = false;
                MatchResult it = matchResult;
                boolean bl5 = false;
                String string2 = (String)it.getGroupValues().get(2);
                boolean bl6 = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                regexpInText = new RegexpInText((String)it.getGroupValues().get(1), ((Object)StringsKt.trim((CharSequence)string3)).toString());
            }
            if (regexpInText == null) continue;
            RegexpInText regexpInText2 = regexpInText;
            boolean bl7 = false;
            boolean bl8 = false;
            RegexpInText it$iv$iv$iv = regexpInText2;
            boolean bl9 = false;
            destination$iv$iv$iv.add(it$iv$iv$iv);
        }
        List regexps = (List)destination$iv$iv$iv;
        $this$matchLinesWith$iv2 = Companion;
        regex$iv = testFile.content;
        Regex regex$iv2 = IR_FILE_TXT_PATTERN;
        boolean $i$f$matchLinesWith2 = false;
        Iterable $this$mapNotNull$iv$iv2 = StringsKt.lines((CharSequence)((CharSequence)$this$matchLinesWith$iv));
        boolean $i$f$mapNotNull2 = false;
        destination$iv$iv$iv = $this$mapNotNull$iv$iv2;
        Collection destination$iv$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv$iv2 = $this$mapNotNullTo$iv$iv$iv;
        boolean $i$f$forEach2 = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv$iv2.iterator();
        while (iterator2.hasNext()) {
            IrTreeFileLabel irTreeFileLabel;
            Object element$iv$iv$iv$iv;
            Object element$iv$iv$iv = element$iv$iv$iv$iv = iterator2.next();
            boolean bl10 = false;
            String it$iv = (String)element$iv$iv$iv;
            boolean bl11 = false;
            matchResult = regex$iv2.matchEntire((CharSequence)it$iv);
            if (matchResult == null) {
                irTreeFileLabel = null;
            } else {
                MatchResult matchResult3 = matchResult;
                bl = false;
                boolean bl12 = false;
                MatchResult it = matchResult3;
                boolean bl13 = false;
                String string4 = (String)it.getGroupValues().get(1);
                boolean bl14 = false;
                String string5 = string4;
                if (string5 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                String fileName = ((Object)StringsKt.trim((CharSequence)string5)).toString();
                File file = new File(dir, this.getExpectedTextFileName(testFile, fileName));
                irTreeFileLabel = new IrTreeFileLabel(file, 0);
            }
            if (irTreeFileLabel == null) continue;
            IrTreeFileLabel irTreeFileLabel2 = irTreeFileLabel;
            boolean bl15 = false;
            boolean bl16 = false;
            IrTreeFileLabel it$iv$iv$iv = irTreeFileLabel2;
            boolean bl17 = false;
            destination$iv$iv$iv2.add(it$iv$iv$iv);
        }
        List treeFiles = (List)destination$iv$iv$iv2;
        if (treeFiles.isEmpty()) {
            File file = new File(dir, AbstractIrTextTestCase.getExpectedTextFileName$default(this, testFile, null, 2, null));
            treeFiles = CollectionsKt.listOf((Object)new IrTreeFileLabel(file, 0));
        }
        return new Expectations(regexps, treeFiles);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=50, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0002\u0010\u0007R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/ir/AbstractIrTextTestCase$Expectations;", "", "regexps", "", "Lorg/jetbrains/kotlin/ir/AbstractIrTextTestCase$RegexpInText;", "irTreeFileLabels", "Lorg/jetbrains/kotlin/ir/AbstractIrTextTestCase$IrTreeFileLabel;", "(Ljava/util/List;Ljava/util/List;)V", "getIrTreeFileLabels", "()Ljava/util/List;", "getRegexps", "tests-common"})
    public static final class Expectations {
        @NotNull
        private final List<RegexpInText> regexps;
        @NotNull
        private final List<IrTreeFileLabel> irTreeFileLabels;

        public Expectations(@NotNull List<RegexpInText> regexps, @NotNull List<IrTreeFileLabel> irTreeFileLabels) {
            Intrinsics.checkNotNullParameter(regexps, (String)"regexps");
            Intrinsics.checkNotNullParameter(irTreeFileLabels, (String)"irTreeFileLabels");
            this.regexps = regexps;
            this.irTreeFileLabels = irTreeFileLabels;
        }

        @NotNull
        public final List<RegexpInText> getRegexps() {
            return this.regexps;
        }

        @NotNull
        public final List<IrTreeFileLabel> getIrTreeFileLabels() {
            return this.irTreeFileLabels;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=50, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B\u0015\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/ir/AbstractIrTextTestCase$RegexpInText;", "", "countStr", "", "needle", "(Ljava/lang/String;Ljava/lang/String;)V", "numberOfOccurrences", "", "(ILjava/lang/String;)V", "getNeedle", "()Ljava/lang/String;", "getNumberOfOccurrences", "()I", "tests-common"})
    public static final class RegexpInText {
        private final int numberOfOccurrences;
        @NotNull
        private final String needle;

        public RegexpInText(int numberOfOccurrences, @NotNull String needle) {
            Intrinsics.checkNotNullParameter((Object)needle, (String)"needle");
            this.numberOfOccurrences = numberOfOccurrences;
            this.needle = needle;
        }

        public final int getNumberOfOccurrences() {
            return this.numberOfOccurrences;
        }

        @NotNull
        public final String getNeedle() {
            return this.needle;
        }

        public RegexpInText(@NotNull String countStr, @NotNull String needle) {
            Intrinsics.checkNotNullParameter((Object)countStr, (String)"countStr");
            Intrinsics.checkNotNullParameter((Object)needle, (String)"needle");
            Integer n = Integer.valueOf(countStr);
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"valueOf(countStr)");
            this(((Number)n).intValue(), needle);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=50, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/ir/AbstractIrTextTestCase$IrTreeFileLabel;", "", "expectedTextFile", "Ljava/io/File;", "lineNumber", "", "(Ljava/io/File;I)V", "getExpectedTextFile", "()Ljava/io/File;", "getLineNumber", "()I", "tests-common"})
    public static final class IrTreeFileLabel {
        @NotNull
        private final File expectedTextFile;
        private final int lineNumber;

        public IrTreeFileLabel(@NotNull File expectedTextFile, int lineNumber) {
            Intrinsics.checkNotNullParameter((Object)expectedTextFile, (String)"expectedTextFile");
            this.expectedTextFile = expectedTextFile;
            this.lineNumber = lineNumber;
        }

        @NotNull
        public final File getExpectedTextFile() {
            return this.expectedTextFile;
        }

        public final int getLineNumber() {
            return this.lineNumber;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=50, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b\fJ\u0011\u0010\r\u001a\u00020\u000e*\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010J5\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00120\t\"\u0004\b\u0000\u0010\u0012*\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00042\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u0002H\u00120\u0015H\u0082\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/ir/AbstractIrTextTestCase$Companion;", "", "()V", "DUMP_EXTERNAL_CLASS", "Lkotlin/text/Regex;", "EXPECTED_OCCURRENCES_PATTERN", "EXTERNAL_FILE_PATTERN", "IR_FILE_TXT_PATTERN", "parseDumpExternalClasses", "", "", "text", "parseDumpExternalClasses$tests_common", "isExternalFile", "", "Lorg/jetbrains/kotlin/test/KotlinBaseTest$TestFile;", "isExternalFile$tests_common", "matchLinesWith", "T", "regex", "ifMatched", "Lkotlin/Function1;", "Lkotlin/text/MatchResult;", "tests-common"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final <T> List<T> matchLinesWith(String $this$matchLinesWith, Regex regex, Function1<? super MatchResult, ? extends T> ifMatched) {
            void $this$mapNotNullTo$iv$iv;
            boolean $i$f$matchLinesWith = false;
            Iterable $this$mapNotNull$iv = StringsKt.lines((CharSequence)$this$matchLinesWith);
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object object;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                MatchResult matchResult = regex.matchEntire((CharSequence)it);
                if (matchResult == null) {
                    object = null;
                } else {
                    MatchResult matchResult2 = matchResult;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    object = ifMatched.invoke((Object)matchResult2);
                }
                if (object == null) continue;
                Object object2 = object;
                boolean bl5 = false;
                boolean bl6 = false;
                Object it$iv$iv = object2;
                boolean bl7 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<String> parseDumpExternalClasses$tests_common(@NotNull String text) {
            void $this$mapNotNullTo$iv$iv$iv;
            void $this$matchLinesWith$iv;
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Companion companion = this;
            String string = text;
            Regex regex$iv = DUMP_EXTERNAL_CLASS;
            boolean $i$f$matchLinesWith = false;
            Iterable $this$mapNotNull$iv$iv = StringsKt.lines((CharSequence)((CharSequence)$this$matchLinesWith$iv));
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv$iv;
            Collection destination$iv$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv$iv = $this$mapNotNullTo$iv$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                String string2;
                Object element$iv$iv$iv$iv;
                Object element$iv$iv$iv = element$iv$iv$iv$iv = iterator.next();
                boolean bl = false;
                String it$iv = (String)element$iv$iv$iv;
                boolean bl2 = false;
                MatchResult matchResult = regex$iv.matchEntire((CharSequence)it$iv);
                if (matchResult == null) {
                    string2 = null;
                } else {
                    MatchResult matchResult2 = matchResult;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    MatchResult it = matchResult2;
                    boolean bl5 = false;
                    string2 = (String)it.getGroupValues().get(1);
                }
                if (string2 == null) continue;
                String string3 = string2;
                boolean bl6 = false;
                boolean bl7 = false;
                String it$iv$iv$iv = string3;
                boolean bl8 = false;
                destination$iv$iv$iv.add(it$iv$iv$iv);
            }
            return (List)destination$iv$iv$iv;
        }

        public final boolean isExternalFile$tests_common(@NotNull KotlinBaseTest.TestFile $this$isExternalFile) {
            Intrinsics.checkNotNullParameter((Object)$this$isExternalFile, (String)"<this>");
            return EXTERNAL_FILE_PATTERN.containsMatchIn((CharSequence)$this$isExternalFile.content);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

