/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir;

import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.AbstractIrGeneratorTestCase;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFileKt;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir2cfg.generators.FunctionGenerator;
import org.jetbrains.kotlin.ir2cfg.graph.ControlFlowGraph;
import org.jetbrains.kotlin.ir2cfg.util.ControlFlowRendererKt;
import org.jetbrains.kotlin.test.KotlinBaseTest;
import org.jetbrains.kotlin.test.KotlinTestUtils;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=50, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0014J\f\u0010\n\u001a\u00020\u000b*\u00020\fH\u0002J\f\u0010\n\u001a\u00020\u000b*\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/ir/AbstractIrCfgTestCase;", "Lorg/jetbrains/kotlin/ir/AbstractIrGeneratorTestCase;", "()V", "doTest", "", "wholeFile", "Ljava/io/File;", "testFiles", "", "Lorg/jetbrains/kotlin/test/KotlinBaseTest$TestFile;", "cfgDump", "", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "tests-common"})
public abstract class AbstractIrCfgTestCase
extends AbstractIrGeneratorTestCase {
    private final String cfgDump(IrFile $this$cfgDump) {
        StringBuilder builder = new StringBuilder();
        for (IrDeclaration declaration : $this$cfgDump.getDeclarations()) {
            StringBuilder stringBuilder;
            if (!(declaration instanceof IrFunction)) continue;
            StringBuilder stringBuilder2 = builder;
            CharSequence charSequence = Intrinsics.stringPlus((String)"// FUN: ", (Object)((IrFunction)declaration).getName());
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append((String)charSequence), (String)"append(value)");
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append('\\n')");
            ControlFlowGraph cfg = new FunctionGenerator((IrFunction)declaration).generate();
            charSequence = builder;
            String string = ControlFlowRendererKt.dump((ControlFlowGraph)cfg);
            boolean bl3 = false;
            StringBuilder stringBuilder3 = ((StringBuilder)charSequence).append(string);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(value)");
            StringBuilder stringBuilder4 = stringBuilder3;
            boolean bl4 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append('\\n')");
            charSequence = builder;
            string = Intrinsics.stringPlus((String)"// END FUN: ", (Object)((IrFunction)declaration).getName());
            bl3 = false;
            StringBuilder stringBuilder5 = ((StringBuilder)charSequence).append(string);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(value)");
            stringBuilder4 = stringBuilder5;
            bl4 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4.append('\n'), (String)"append('\\n')");
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        return string;
    }

    private final String cfgDump(IrModuleFragment $this$cfgDump) {
        StringBuilder builder = new StringBuilder();
        for (IrFile file : $this$cfgDump.getFiles()) {
            StringBuilder stringBuilder = builder;
            String string = Intrinsics.stringPlus((String)"// FILE: ", (Object)IrFileKt.getPath((IrFile)file));
            boolean bl = false;
            StringBuilder stringBuilder2 = stringBuilder.append(string);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
            StringBuilder stringBuilder3 = stringBuilder2;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
            stringBuilder = builder;
            string = this.cfgDump(file);
            bl = false;
            StringBuilder stringBuilder4 = stringBuilder.append(string);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(value)");
            stringBuilder3 = stringBuilder4;
            bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
            stringBuilder = builder;
            string = Intrinsics.stringPlus((String)"// END FILE: ", (Object)IrFileKt.getPath((IrFile)file));
            bl = false;
            StringBuilder stringBuilder5 = stringBuilder.append(string);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(value)");
            stringBuilder3 = stringBuilder5;
            bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append('\\n')");
            stringBuilder = builder;
            boolean bl3 = false;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append('\\n')");
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        return string;
    }

    @Override
    protected void doTest(@NotNull File wholeFile, @NotNull List<? extends KotlinBaseTest.TestFile> testFiles) {
        Intrinsics.checkNotNullParameter((Object)wholeFile, (String)"wholeFile");
        Intrinsics.checkNotNullParameter(testFiles, (String)"testFiles");
        IrModuleFragment irModule = this.generateIrModule(false);
        String irModuleDump = this.cfgDump(irModule);
        String string = wholeFile.getCanonicalPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"wholeFile.canonicalPath");
        String expectedPath = StringsKt.replace$default((String)string, (String)".kt", (String)".txt", (boolean)false, (int)4, null);
        File expectedFile = new File(expectedPath);
        KotlinTestUtils.assertEqualsToFile(expectedFile, irModuleDump);
    }
}

