/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.integration;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.regex.Pattern;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.KotlinCompilerVersion;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TestCaseWithTmpdir;
import org.jetbrains.kotlin.test.WithMutedInDatabaseRunTest;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.utils.KotlinPaths;
import org.jetbrains.kotlin.utils.PathUtil;

@WithMutedInDatabaseRunTest
public abstract class KotlinIntegrationTestBase
extends TestCaseWithTmpdir {
    @Override
    protected void runTest() throws Throwable {
        KotlinTestUtils.runTestWithThrowable(this, () -> super.runTest());
    }

    protected int runJava(@NotNull String testDataDir, @Nullable String logName, String ... arguments) throws Exception {
        if (testDataDir == null) {
            KotlinIntegrationTestBase.$$$reportNull$$$0(0);
        }
        if (arguments == null) {
            KotlinIntegrationTestBase.$$$reportNull$$$0(1);
        }
        GeneralCommandLine commandLine = new GeneralCommandLine().withWorkDirectory(testDataDir);
        commandLine.setExePath(KotlinIntegrationTestBase.getJavaRuntime().getAbsolutePath());
        commandLine.addParameters(arguments);
        StringBuilder executionLog = new StringBuilder();
        int exitCode = KotlinIntegrationTestBase.runProcess(commandLine, executionLog);
        if (logName == null) {
            KotlinIntegrationTestBase.assertEquals((String)"Non-zero exit code", (int)0, (int)exitCode);
        } else {
            this.check(testDataDir, logName, executionLog.toString());
        }
        return exitCode;
    }

    private static String normalizePath(String content2, File baseDir, String pathId) {
        String contentWithRelativePaths = content2.replace(baseDir.getAbsolutePath(), pathId);
        String RELATIVE_PATH_WITH_MIXED_SEPARATOR = Regex.Companion.escape(pathId) + "[-.\\w/\\\\]*";
        return new Regex(RELATIVE_PATH_WITH_MIXED_SEPARATOR).replace((CharSequence)contentWithRelativePaths, mr -> FileUtil.toSystemIndependentName((String)mr.getValue()));
    }

    @NotNull
    protected String normalizeOutput(@NotNull File testDataDir, @NotNull String content2) {
        if (testDataDir == null) {
            KotlinIntegrationTestBase.$$$reportNull$$$0(2);
        }
        if (content2 == null) {
            KotlinIntegrationTestBase.$$$reportNull$$$0(3);
        }
        content2 = KotlinIntegrationTestBase.normalizePath(content2, testDataDir, "[TestData]");
        content2 = KotlinIntegrationTestBase.normalizePath(content2, this.tmpdir, "[Temp]");
        content2 = KotlinIntegrationTestBase.normalizePath(content2, KotlinIntegrationTestBase.getCompilerLib(), "[CompilerLib]");
        content2 = KotlinIntegrationTestBase.normalizePath(content2, new File(KtTestUtil.getHomeDirectory()), "[KotlinProjectHome]");
        content2 = content2.replaceAll(Pattern.quote(KotlinCompilerVersion.VERSION), "[KotlinVersion]");
        content2 = content2.replaceAll("\\(JRE .+\\)", "(JRE [JREVersion])");
        content2 = StringUtil.convertLineSeparators((String)content2);
        content2 = content2.replaceAll("\n.*Picked up [_A-Z]+:.*\n", "\n");
        String string = content2 = content2.replaceFirst("\nERR:\n\nReturn code:", "\nReturn code:");
        if (string == null) {
            KotlinIntegrationTestBase.$$$reportNull$$$0(4);
        }
        return string;
    }

    private void check(String testDataDir, String baseName, String content2) throws IOException {
        File expectedFile = new File(testDataDir, baseName + ".expected");
        String normalizedContent = this.normalizeOutput(new File(testDataDir), content2);
        KotlinTestUtils.assertEqualsToFile(expectedFile, normalizedContent);
    }

    private static int runProcess(GeneralCommandLine commandLine, StringBuilder executionLog) throws ExecutionException {
        OSProcessHandler handler = new OSProcessHandler(commandLine.createProcess(), commandLine.getCommandLineString(), commandLine.getCharset());
        StringBuilder outContent = new StringBuilder();
        StringBuilder errContent = new StringBuilder();
        handler.addProcessListener((ProcessListener)new OutputListener(outContent, errContent));
        handler.startNotify();
        handler.waitFor();
        int exitCode = handler.getProcess().exitValue();
        KotlinIntegrationTestBase.appendIfNotEmpty(executionLog, "OUT:\n", outContent.toString());
        KotlinIntegrationTestBase.appendIfNotEmpty(executionLog, "\nERR:\n", errContent.toString());
        executionLog.append("\nReturn code: ").append(exitCode).append("\n");
        return exitCode;
    }

    private static void appendIfNotEmpty(StringBuilder executionLog, String prefix, String content2) {
        if (content2.length() > 0) {
            executionLog.append(prefix);
            executionLog.append(content2);
        }
    }

    private static File getJavaRuntime() {
        File javaHome = new File(System.getProperty("java.home"));
        String javaExe = SystemInfo.isWindows ? "java.exe" : "java";
        File runtime = new File(javaHome, "bin" + File.separator + javaExe);
        KotlinIntegrationTestBase.assertTrue((String)("No java runtime at " + runtime), (boolean)runtime.isFile());
        return runtime;
    }

    public static File getCompilerLib() {
        return KotlinIntegrationTestBase.getKotlinPaths().getLibPath().getAbsoluteFile();
    }

    public static KotlinPaths getKotlinPaths() {
        KotlinPaths paths = PathUtil.getKotlinPathsForDistDirectory();
        KotlinIntegrationTestBase.assertTrue((String)"Compiler dist not found. Build 'dist' target.", (boolean)paths.getLibPath().isDirectory());
        return paths;
    }

    static {
        System.setProperty("java.awt.headless", "true");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testDataDir";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/integration/KotlinIntegrationTestBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/integration/KotlinIntegrationTestBase";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeOutput";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runJava";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "normalizeOutput";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class OutputListener
    extends ProcessAdapter {
        private final StringBuilder out;
        private final StringBuilder err;

        public OutputListener(@NotNull StringBuilder out, @NotNull StringBuilder err) {
            if (out == null) {
                OutputListener.$$$reportNull$$$0(0);
            }
            if (err == null) {
                OutputListener.$$$reportNull$$$0(1);
            }
            this.out = out;
            this.err = err;
        }

        public void onTextAvailable(ProcessEvent event, Key outputType) {
            if (outputType == ProcessOutputTypes.STDERR) {
                this.err.append(event.getText());
            } else if (outputType != ProcessOutputTypes.SYSTEM) {
                this.out.append(event.getText());
            }
        }

        public void processTerminated(ProcessEvent event) {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "out";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "err";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/kotlin/integration/KotlinIntegrationTestBase$OutputListener";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

