/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import junit.framework.TestCase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.output.OutputFile;
import org.jetbrains.kotlin.backend.common.output.OutputFileCollection;
import org.jetbrains.kotlin.cli.common.output.OutputUtilsKt;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.codegen.ClassFileFactory;
import org.jetbrains.kotlin.codegen.CodegenTestCase;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.test.ConfigurationKind;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TestJdkKind;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;

public abstract class AbstractGenerateNotNullAssertionsTest
extends CodegenTestCase {
    @Override
    @NotNull
    protected String getPrefix() {
        return "notNullAssertions";
    }

    private void setUpEnvironment(boolean disableCallAssertions, boolean disableParamAssertions) {
        File[] fileArray;
        if (this.javaClassesOutputDirectory != null) {
            File[] fileArray2 = new File[1];
            fileArray = fileArray2;
            fileArray2[0] = this.javaClassesOutputDirectory;
        } else {
            fileArray = new File[]{};
        }
        File[] extraClassPath = fileArray;
        CompilerConfiguration configuration = KotlinTestUtils.newConfiguration(ConfigurationKind.JDK_ONLY, TestJdkKind.MOCK_JDK, extraClassPath);
        configuration.put(JVMConfigurationKeys.DISABLE_CALL_ASSERTIONS, (Object)disableCallAssertions);
        configuration.put(JVMConfigurationKeys.DISABLE_PARAM_ASSERTIONS, (Object)disableParamAssertions);
        configuration.put(JVMConfigurationKeys.IR, (Object)this.getBackend().isIR());
        this.myEnvironment = KotlinCoreEnvironment.createForTests((Disposable)this.getTestRootDisposable(), (CompilerConfiguration)configuration, (EnvironmentConfigFiles)EnvironmentConfigFiles.JVM_CONFIG_FILES);
        this.myFiles = null;
    }

    private void loadSource(@NotNull String fileName) {
        if (fileName == null) {
            AbstractGenerateNotNullAssertionsTest.$$$reportNull$$$0(0);
        }
        this.loadFileByFullPath(KtTestUtil.getTestDataPathBase() + "/codegen/" + this.getPrefix() + "/" + fileName);
    }

    protected void doTestNoAssertionsForKotlinFromBinary(String binaryDependencyFilename, String testFilename) {
        this.setUpEnvironment(false, true);
        this.loadSource(binaryDependencyFilename);
        ClassFileFactory outputFiles = this.generateClassesInFile();
        this.javaClassesOutputDirectory = new File(FileUtil.getTempDirectory(), "kotlin-classes");
        OutputUtilsKt.writeAllTo((OutputFileCollection)outputFiles, (File)this.javaClassesOutputDirectory);
        this.setUpEnvironment(false, true);
        this.loadSource(testFilename);
        this.assertNoIntrinsicsMethodIsCalledInMyClasses(false);
    }

    private void assertNoIntrinsicsMethodIsCalledInMyClasses(boolean noClassFileIsAnError) {
        for (KtFile jetFile : this.myFiles.getPsiFiles()) {
            String fileClassName = JvmFileClassUtil.getFileClassInfoNoResolve((KtFile)jetFile).getFileClassFqName().asString();
            this.assertNoIntrinsicsMethodIsCalled(fileClassName, noClassFileIsAnError);
        }
    }

    private void assertNoIntrinsicsMethodIsCalled(String className, boolean noClassFileIsAnError) {
        ClassFileFactory classes = this.generateClassesInFile();
        OutputFile file = classes.get(className + ".class");
        if (noClassFileIsAnError) {
            AbstractGenerateNotNullAssertionsTest.assertNotNull((String)("File for " + className + " is absent"), (Object)file);
        } else if (file == null) {
            return;
        }
        ClassReader reader = new ClassReader(file.asByteArray());
        reader.accept(new ClassVisitor(524288){

            public MethodVisitor visitMethod(int access, final @NotNull String callerName, final @NotNull String callerDesc, String signature, String[] exceptions) {
                if (callerName == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (callerDesc == null) {
                    1.$$$reportNull$$$0(1);
                }
                return new MethodVisitor(524288){

                    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
                        TestCase.assertFalse((String)("Intrinsics method is called: " + name + desc + "  Caller: " + callerName + callerDesc), (boolean)"kotlin/jvm/internal/Intrinsics".equals(owner));
                    }
                };
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "callerName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "callerDesc";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/kotlin/codegen/AbstractGenerateNotNullAssertionsTest$1";
                objectArray[2] = "visitMethod";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, 0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "org/jetbrains/kotlin/codegen/AbstractGenerateNotNullAssertionsTest", "loadSource"));
    }
}

