/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kotlin.Pair;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.modules.ModuleBuilder;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.codegen.ClassFileFactory;
import org.jetbrains.kotlin.codegen.CodegenTestCase;
import org.jetbrains.kotlin.codegen.GenerationUtils;
import org.jetbrains.kotlin.codegen.forTestCompile.ForTestCompileRuntime;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.load.kotlin.ModuleVisibilityManager;
import org.jetbrains.kotlin.load.kotlin.PackagePartClassUtils;
import org.jetbrains.kotlin.modules.Module;
import org.jetbrains.kotlin.test.ConfigurationKind;
import org.jetbrains.kotlin.test.InTextDirectivesUtils;
import org.jetbrains.kotlin.test.KotlinBaseTest;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.utils.ExceptionUtilsKt;

public abstract class AbstractCompileKotlinAgainstKotlinTest
extends CodegenTestCase {
    private File tmpdir;
    protected File aDir;
    protected File bDir;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.tmpdir = KotlinTestUtils.tmpDirForTest(this);
        this.aDir = new File(this.tmpdir, "a");
        this.bDir = new File(this.tmpdir, "b");
        KtTestUtil.mkdirs((File)this.aDir);
        KtTestUtil.mkdirs((File)this.bDir);
    }

    @Override
    protected void doMultiFileTest(@NotNull File wholeFile, @NotNull List<? extends KotlinBaseTest.TestFile> files) {
        boolean isIgnored;
        if (wholeFile == null) {
            AbstractCompileKotlinAgainstKotlinTest.$$$reportNull$$$0(0);
        }
        if (files == null) {
            AbstractCompileKotlinAgainstKotlinTest.$$$reportNull$$$0(1);
        }
        this.doTwoFileTest(files, !(isIgnored = InTextDirectivesUtils.isIgnoredTarget((TargetBackend)this.getBackend(), (File)wholeFile)));
    }

    @NotNull
    protected Pair<ClassFileFactory, ClassFileFactory> doTwoFileTest(@NotNull List<KotlinBaseTest.TestFile> files, boolean reportProblems) {
        if (files == null) {
            AbstractCompileKotlinAgainstKotlinTest.$$$reportNull$$$0(2);
        }
        assert (files.size() == 2 || files.size() == 3 && files.get((int)2).name.equals("CoroutineUtil.kt")) : "There should be exactly two files in this test";
        KotlinBaseTest.TestFile fileA = files.get(0);
        KotlinBaseTest.TestFile fileB = files.get(1);
        ClassFileFactory factoryA = this.compileA(fileA, files);
        ClassFileFactory factoryB = null;
        try {
            factoryB = this.compileB(fileB, files);
            this.invokeBox(PackagePartClassUtils.getFilePartShortName((String)new File(fileB.name).getName()));
        }
        catch (Throwable e) {
            if (reportProblems) {
                String result = "FIRST: \n\n" + factoryA.createText();
                if (factoryB != null) {
                    result = result + "\n\nSECOND: \n\n" + factoryB.createText();
                }
                System.out.println(result);
            }
            throw ExceptionUtilsKt.rethrow((Throwable)e);
        }
        return new Pair((Object)factoryA, (Object)factoryB);
    }

    protected void invokeBox(@NotNull String className) throws Exception {
        if (className == null) {
            AbstractCompileKotlinAgainstKotlinTest.$$$reportNull$$$0(3);
        }
        this.callBoxMethodAndCheckResult(this.createGeneratedClassLoader(), className);
    }

    @Override
    protected boolean parseDirectivesPerFiles() {
        return true;
    }

    @NotNull
    private URLClassLoader createGeneratedClassLoader() throws Exception {
        return new URLClassLoader(new URL[]{this.bDir.toURI().toURL(), this.aDir.toURI().toURL()}, ForTestCompileRuntime.runtimeAndReflectJarClassLoader());
    }

    @NotNull
    protected TargetBackend getBackendA() {
        TargetBackend targetBackend = this.getBackend();
        if (targetBackend == null) {
            AbstractCompileKotlinAgainstKotlinTest.$$$reportNull$$$0(4);
        }
        return targetBackend;
    }

    @NotNull
    protected TargetBackend getBackendB() {
        TargetBackend targetBackend = this.getBackend();
        if (targetBackend == null) {
            AbstractCompileKotlinAgainstKotlinTest.$$$reportNull$$$0(5);
        }
        return targetBackend;
    }

    @NotNull
    private ClassFileFactory compileA(@NotNull KotlinBaseTest.TestFile testFile, List<KotlinBaseTest.TestFile> files) {
        if (testFile == null) {
            AbstractCompileKotlinAgainstKotlinTest.$$$reportNull$$$0(6);
        }
        Disposable compileDisposable = this.createDisposable("compileA");
        CompilerConfiguration configuration = this.createConfiguration(ConfigurationKind.ALL, this.getTestJdkKind(files), this.getBackendA(), Collections.singletonList(KtTestUtil.getAnnotationsJar()), Collections.emptyList(), Collections.singletonList(testFile));
        configuration.put(CommonConfigurationKeys.MODULE_NAME, (Object)"a");
        KotlinCoreEnvironment environment = KotlinCoreEnvironment.createForTests((Disposable)compileDisposable, (CompilerConfiguration)configuration, (EnvironmentConfigFiles)EnvironmentConfigFiles.JVM_CONFIG_FILES);
        List<KotlinBaseTest.TestFile> filesToCompile = files.size() == 2 ? Collections.singletonList(testFile) : Arrays.asList(testFile, files.get(2));
        return this.compileKotlin(filesToCompile, this.aDir, environment, compileDisposable);
    }

    @NotNull
    private ClassFileFactory compileB(@NotNull KotlinBaseTest.TestFile testFile, List<KotlinBaseTest.TestFile> files) {
        if (testFile == null) {
            AbstractCompileKotlinAgainstKotlinTest.$$$reportNull$$$0(7);
        }
        String commonHeader = StringsKt.substringBefore((String)files.get((int)0).content, (String)"FILE:", (String)"");
        CompilerConfiguration configuration = this.createConfiguration(ConfigurationKind.ALL, this.getTestJdkKind(files), this.getBackendB(), Arrays.asList(KtTestUtil.getAnnotationsJar(), this.aDir), Collections.emptyList(), Arrays.asList(testFile, new KotlinBaseTest.TestFile("header", commonHeader)));
        configuration.put(CommonConfigurationKeys.MODULE_NAME, (Object)"b");
        Disposable compileDisposable = this.createDisposable("compileB");
        KotlinCoreEnvironment environment = KotlinCoreEnvironment.createForTests((Disposable)compileDisposable, (CompilerConfiguration)configuration, (EnvironmentConfigFiles)EnvironmentConfigFiles.JVM_CONFIG_FILES);
        return this.compileKotlin(Collections.singletonList(testFile), this.bDir, environment, compileDisposable);
    }

    private Disposable createDisposable(String debugName) {
        Disposable disposable = Disposer.newDisposable((String)("CompileDisposable" + debugName));
        Disposer.register((Disposable)this.getTestRootDisposable(), (Disposable)disposable);
        return disposable;
    }

    @NotNull
    private ClassFileFactory compileKotlin(@NotNull List<KotlinBaseTest.TestFile> files, @NotNull File outputDir, @NotNull KotlinCoreEnvironment environment, @NotNull Disposable disposable) {
        if (files == null) {
            AbstractCompileKotlinAgainstKotlinTest.$$$reportNull$$$0(8);
        }
        if (outputDir == null) {
            AbstractCompileKotlinAgainstKotlinTest.$$$reportNull$$$0(9);
        }
        if (environment == null) {
            AbstractCompileKotlinAgainstKotlinTest.$$$reportNull$$$0(10);
        }
        if (disposable == null) {
            AbstractCompileKotlinAgainstKotlinTest.$$$reportNull$$$0(11);
        }
        List ktFiles = files.stream().map(file -> KtTestUtil.createFile((String)file.name, (String)file.content, (Project)environment.getProject())).collect(Collectors.toList());
        ModuleVisibilityManager.SERVICE.getInstance((Project)environment.getProject()).addModule((Module)new ModuleBuilder("module for test", this.tmpdir.getAbsolutePath(), "test"));
        ClassFileFactory outputFiles = GenerationUtils.compileFilesTo(ktFiles, (KotlinCoreEnvironment)environment, (File)outputDir);
        Disposer.dispose((Disposable)disposable);
        ClassFileFactory classFileFactory = outputFiles;
        if (classFileFactory == null) {
            AbstractCompileKotlinAgainstKotlinTest.$$$reportNull$$$0(12);
        }
        return classFileFactory;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wholeFile";
                break;
            }
            case 1: 
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 4: 
            case 5: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/AbstractCompileKotlinAgainstKotlinTest";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFile";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputDir";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/AbstractCompileKotlinAgainstKotlinTest";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBackendA";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBackendB";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "compileKotlin";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doMultiFileTest";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doTwoFileTest";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invokeBox";
                break;
            }
            case 4: 
            case 5: 
            case 12: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "compileA";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "compileB";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "compileKotlin";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

