/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.io.path.PathsKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CLITool;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.js.K2JSCompiler;
import org.jetbrains.kotlin.cli.js.dce.K2JSDce;
import org.jetbrains.kotlin.cli.jvm.K2JVMCompiler;
import org.jetbrains.kotlin.cli.metadata.K2MetadataCompiler;
import org.jetbrains.kotlin.config.KotlinCompilerVersion;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmMetadataVersion;
import org.jetbrains.kotlin.test.CompilerTestUtil;
import org.jetbrains.kotlin.test.InTextDirectivesUtils;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TestCaseWithTmpdir;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.jetbrains.kotlin.utils.ExceptionUtilsKt;
import org.jetbrains.kotlin.utils.JsMetadataVersion;
import org.jetbrains.kotlin.utils.PathUtil;
import org.junit.Assert;

public abstract class AbstractCliTest
extends TestCaseWithTmpdir {
    private static final String TESTDATA_DIR = "$TESTDATA_DIR$";
    private static final String BUILD_FILE_ARGUMENT_PREFIX = "-Xbuild-file=";

    public static Pair<String, ExitCode> executeCompilerGrabOutput(@NotNull CLITool<?> compiler, @NotNull List<String> args2) {
        int next;
        if (compiler == null) {
            AbstractCliTest.$$$reportNull$$$0(0);
        }
        if (args2 == null) {
            AbstractCliTest.$$$reportNull$$$0(1);
        }
        StringBuilder output = new StringBuilder();
        int index = 0;
        do {
            if ((next = args2.subList(index, args2.size()).indexOf("---")) == -1) {
                next = args2.size();
            }
            Pair<String, ExitCode> pair = CompilerTestUtil.executeCompiler(compiler, args2.subList(index, next));
            output.append((String)pair.getFirst());
            if (pair.getSecond() == ExitCode.OK) continue;
            return new Pair((Object)output.toString(), pair.getSecond());
        } while ((index = next + 1) < args2.size());
        return new Pair((Object)output.toString(), (Object)ExitCode.OK);
    }

    @NotNull
    public static String getNormalizedCompilerOutput(@NotNull String pureOutput, @Nullable ExitCode exitCode, @NotNull String testDataDir) {
        if (pureOutput == null) {
            AbstractCliTest.$$$reportNull$$$0(2);
        }
        if (testDataDir == null) {
            AbstractCliTest.$$$reportNull$$$0(3);
        }
        String testDataAbsoluteDir = new File(testDataDir).getAbsolutePath();
        String normalizedOutputWithoutExitCode = StringUtil.convertLineSeparators((String)pureOutput).replace(testDataAbsoluteDir, TESTDATA_DIR).replace(FileUtil.toSystemIndependentName((String)testDataAbsoluteDir), TESTDATA_DIR).replace(PathUtil.getKotlinPathsForDistDirectory().getHomePath().getAbsolutePath(), "$PROJECT_DIR$").replace(PathUtil.getKotlinPathsForDistDirectory().getHomePath().getParentFile().getAbsolutePath(), "$DIST_DIR$").replace("expected version is " + JvmMetadataVersion.INSTANCE, "expected version is $ABI_VERSION$").replace("expected version is " + JsMetadataVersion.INSTANCE, "expected version is $ABI_VERSION$").replace("\\", "/").replace(KotlinCompilerVersion.VERSION, "$VERSION$").replace("\nNote: on Windows, arguments that contain delimiter characters (whitespace, =, ;, ,) need to be surrounded with double quotes (\").\n", "").replaceAll("log4j:WARN.*\n", "");
        String string = exitCode == null ? normalizedOutputWithoutExitCode : normalizedOutputWithoutExitCode + exitCode + "\n";
        if (string == null) {
            AbstractCliTest.$$$reportNull$$$0(4);
        }
        return string;
    }

    private void doTest(@NotNull String fileName, @NotNull CLITool<?> compiler) {
        if (fileName == null) {
            AbstractCliTest.$$$reportNull$$$0(5);
        }
        if (compiler == null) {
            AbstractCliTest.$$$reportNull$$$0(6);
        }
        System.setProperty("java.awt.headless", "true");
        Pair<String, ExitCode> outputAndExitCode = AbstractCliTest.executeCompilerGrabOutput(compiler, AbstractCliTest.readArgs(fileName, this.tmpdir.getPath()));
        String actual2 = AbstractCliTest.getNormalizedCompilerOutput((String)outputAndExitCode.getFirst(), (ExitCode)outputAndExitCode.getSecond(), new File(fileName).getParent());
        File outFile = new File(fileName.replaceFirst("\\.args$", ".out"));
        KotlinTestUtils.assertEqualsToFile(outFile, actual2);
        File additionalTestConfig = new File(fileName.replaceFirst("\\.args$", ".test"));
        if (additionalTestConfig.exists()) {
            this.doTestAdditionalChecks(additionalTestConfig, fileName);
        }
    }

    private void doTestAdditionalChecks(@NotNull File testConfigFile, @NotNull String argsFilePath) {
        if (testConfigFile == null) {
            AbstractCliTest.$$$reportNull$$$0(7);
        }
        if (argsFilePath == null) {
            AbstractCliTest.$$$reportNull$$$0(8);
        }
        ArrayList<String> diagnostics = new ArrayList<String>(0);
        String content2 = FilesKt.readText((File)testConfigFile, (Charset)Charsets.UTF_8);
        List existsList = InTextDirectivesUtils.findListWithPrefixes((String)content2, (String[])new String[]{"// EXISTS: "});
        for (Object fileName : existsList) {
            File file = this.checkedPathToFile((String)fileName, argsFilePath);
            if (!file.exists()) {
                diagnostics.add("File does not exist, but should: " + (String)fileName);
                continue;
            }
            if (file.isFile()) continue;
            diagnostics.add("File is a directory, but should be a normal file: " + (String)fileName);
        }
        List absentList = InTextDirectivesUtils.findListWithPrefixes((String)content2, (String[])new String[]{"// ABSENT: "});
        for (Object fileName : absentList) {
            File file = this.checkedPathToFile((String)fileName, argsFilePath);
            if (!file.exists() || !file.isFile()) continue;
            diagnostics.add("File exists, but shouldn't: " + (String)fileName);
        }
        List containsTextList = InTextDirectivesUtils.findLinesWithPrefixesRemoved((String)content2, (String[])new String[]{"// CONTAINS: "});
        for (String containsSpec : containsTextList) {
            String[] parts = containsSpec.split(",", 2);
            String fileName = parts[0].trim();
            String contentToSearch = parts[1].trim();
            File file = this.checkedPathToFile(fileName, argsFilePath);
            if (!file.exists()) {
                diagnostics.add("File does not exist: " + fileName);
                continue;
            }
            if (file.isDirectory()) {
                diagnostics.add("File is a directory: " + fileName);
                continue;
            }
            String text = FilesKt.readText((File)file, (Charset)Charsets.UTF_8);
            if (text.contains(contentToSearch)) continue;
            diagnostics.add("File " + fileName + " does not contain string: " + contentToSearch);
        }
        List notContainsTextList = InTextDirectivesUtils.findLinesWithPrefixesRemoved((String)content2, (String[])new String[]{"// NOT_CONTAINS: "});
        for (String notContainsSpec : notContainsTextList) {
            String[] parts = notContainsSpec.split(",", 2);
            String fileName = parts[0].trim();
            String contentToSearch = parts[1].trim();
            File file = this.checkedPathToFile(fileName, argsFilePath);
            if (!file.exists()) {
                diagnostics.add("File does not exist: " + fileName);
                continue;
            }
            if (file.isDirectory()) {
                diagnostics.add("File is a directory: " + fileName);
                continue;
            }
            String text = FilesKt.readText((File)file, (Charset)Charsets.UTF_8);
            if (!text.contains(contentToSearch)) continue;
            diagnostics.add("File " + fileName + " contains string: " + contentToSearch);
        }
        if (!diagnostics.isEmpty()) {
            diagnostics.add(0, diagnostics.size() + " problem(s) found:");
            Assert.fail((String)org.jetbrains.kotlin.utils.StringsKt.join(diagnostics, (String)"\n"));
        }
    }

    @NotNull
    private File checkedPathToFile(@NotNull String path, @NotNull String argsFilePath) {
        if (path == null) {
            AbstractCliTest.$$$reportNull$$$0(9);
        }
        if (argsFilePath == null) {
            AbstractCliTest.$$$reportNull$$$0(10);
        }
        if (path.startsWith("$TESTDATA_DIR$/")) {
            return new File(new File(argsFilePath).getParent(), path.substring(TESTDATA_DIR.length() + 1));
        }
        return new File(this.tmpdir, path);
    }

    @NotNull
    private static List<String> readArgs(@NotNull String testArgsFilePath, @NotNull String tempDir) {
        if (testArgsFilePath == null) {
            AbstractCliTest.$$$reportNull$$$0(11);
        }
        if (tempDir == null) {
            AbstractCliTest.$$$reportNull$$$0(12);
        }
        File testArgsFile = new File(testArgsFilePath);
        List lines = FilesKt.readLines((File)testArgsFile, (Charset)Charsets.UTF_8);
        List list = CollectionsKt.mapNotNull((Iterable)lines, arg -> AbstractCliTest.readArg(arg, testArgsFile.getParentFile().getAbsolutePath(), tempDir));
        if (list == null) {
            AbstractCliTest.$$$reportNull$$$0(13);
        }
        return list;
    }

    private static String readArg(String arg, @NotNull String testDataDir, @NotNull String tempDir) {
        if (testDataDir == null) {
            AbstractCliTest.$$$reportNull$$$0(14);
        }
        if (tempDir == null) {
            AbstractCliTest.$$$reportNull$$$0(15);
        }
        if (arg.isEmpty()) {
            return null;
        }
        String argWithColonsReplaced = arg.replace("\\:", "$COLON$").replace(":", File.pathSeparator).replace("$COLON$", ":");
        String argWithTestPathsReplaced = AbstractCliTest.replaceTestPaths(argWithColonsReplaced, testDataDir, tempDir);
        if (arg.startsWith(BUILD_FILE_ARGUMENT_PREFIX)) {
            return AbstractCliTest.replacePathsInBuildXml(argWithTestPathsReplaced, testDataDir, tempDir);
        }
        if (arg.startsWith("@")) {
            return AbstractCliTest.createTempFileWithPathsReplaced(argWithTestPathsReplaced, "@", "", testDataDir, tempDir);
        }
        return argWithTestPathsReplaced;
    }

    @NotNull
    public static String replacePathsInBuildXml(@NotNull String argument, @NotNull String testDataDir, @NotNull String tempDir) {
        if (argument == null) {
            AbstractCliTest.$$$reportNull$$$0(16);
        }
        if (testDataDir == null) {
            AbstractCliTest.$$$reportNull$$$0(17);
        }
        if (tempDir == null) {
            AbstractCliTest.$$$reportNull$$$0(18);
        }
        return AbstractCliTest.createTempFileWithPathsReplaced(argument, BUILD_FILE_ARGUMENT_PREFIX, ".xml", testDataDir, tempDir);
    }

    @NotNull
    private static String createTempFileWithPathsReplaced(@NotNull String argument, @NotNull String argumentPrefix, @NotNull String tempFileSuffix, @NotNull String testDataDir, @NotNull String tempDir) {
        String string;
        String filePath;
        Path file;
        if (argument == null) {
            AbstractCliTest.$$$reportNull$$$0(19);
        }
        if (argumentPrefix == null) {
            AbstractCliTest.$$$reportNull$$$0(20);
        }
        if (tempFileSuffix == null) {
            AbstractCliTest.$$$reportNull$$$0(21);
        }
        if (testDataDir == null) {
            AbstractCliTest.$$$reportNull$$$0(22);
        }
        if (tempDir == null) {
            AbstractCliTest.$$$reportNull$$$0(23);
        }
        if (!Files.exists(file = Paths.get(filePath = StringsKt.substringAfter((String)argument, (String)argumentPrefix, (String)argument), new String[0]), new LinkOption[0])) {
            String string2 = argument;
            if (string2 == null) {
                AbstractCliTest.$$$reportNull$$$0(24);
            }
            return string2;
        }
        try {
            Path result = Files.createTempFile(Paths.get(tempDir, new String[0]), file.getFileName().toString(), tempFileSuffix, new FileAttribute[0]);
            String oldContent = PathsKt.readText((Path)file, (Charset)Charsets.UTF_8);
            String newContent = AbstractCliTest.replaceTestPaths(oldContent, testDataDir, tempDir);
            PathsKt.writeText((Path)result, (CharSequence)newContent, (Charset)Charsets.UTF_8, (OpenOption[])new OpenOption[0]);
            string = argumentPrefix + result.toAbsolutePath();
        }
        catch (IOException e) {
            throw ExceptionUtilsKt.rethrow((Throwable)e);
        }
        if (string == null) {
            AbstractCliTest.$$$reportNull$$$0(25);
        }
        return string;
    }

    private static String replaceTestPaths(@NotNull String str, @NotNull String testDataDir, @NotNull String tempDir) {
        if (str == null) {
            AbstractCliTest.$$$reportNull$$$0(26);
        }
        if (testDataDir == null) {
            AbstractCliTest.$$$reportNull$$$0(27);
        }
        if (tempDir == null) {
            AbstractCliTest.$$$reportNull$$$0(28);
        }
        return str.replace("$TEMP_DIR$", tempDir).replace(TESTDATA_DIR, testDataDir).replace("$FOREIGN_ANNOTATIONS_DIR$", new File("third-party/annotations").getPath()).replace("$JDK_15$", KtTestUtil.getJdk15Home().getPath());
    }

    protected void doJvmTest(@NotNull String fileName) {
        if (fileName == null) {
            AbstractCliTest.$$$reportNull$$$0(29);
        }
        this.doTest(fileName, (CLITool<?>)new K2JVMCompiler());
    }

    protected void doJsTest(@NotNull String fileName) {
        if (fileName == null) {
            AbstractCliTest.$$$reportNull$$$0(30);
        }
        this.doTest(fileName, (CLITool<?>)new K2JSCompiler());
    }

    protected void doJsDceTest(@NotNull String fileName) {
        if (fileName == null) {
            AbstractCliTest.$$$reportNull$$$0(31);
        }
        this.doTest(fileName, (CLITool<?>)new K2JSDce());
    }

    protected void doMetadataTest(@NotNull String fileName) {
        if (fileName == null) {
            AbstractCliTest.$$$reportNull$$$0(32);
        }
        this.doTest(fileName, (CLITool<?>)new K2MetadataCompiler());
    }

    public static String removePerfOutput(String output) {
        String[] lines = StringUtil.splitByLinesKeepSeparators((String)output);
        StringBuilder result = new StringBuilder();
        for (String line : lines) {
            if (line.contains("PERF:")) continue;
            result.append(line);
        }
        return result.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 13: 
            case 24: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 13: 
            case 24: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compiler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pureOutput";
                break;
            }
            case 3: 
            case 14: 
            case 17: 
            case 22: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testDataDir";
                break;
            }
            case 4: 
            case 13: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/cli/AbstractCliTest";
                break;
            }
            case 5: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testConfigFile";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argsFilePath";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testArgsFilePath";
                break;
            }
            case 12: 
            case 15: 
            case 18: 
            case 23: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tempDir";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentPrefix";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tempFileSuffix";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/cli/AbstractCliTest";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNormalizedCompilerOutput";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "readArgs";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempFileWithPathsReplaced";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "executeCompilerGrabOutput";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getNormalizedCompilerOutput";
                break;
            }
            case 4: 
            case 13: 
            case 24: 
            case 25: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doTest";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doTestAdditionalChecks";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "checkedPathToFile";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "readArgs";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "readArg";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "replacePathsInBuildXml";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createTempFileWithPathsReplaced";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "replaceTestPaths";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "doJvmTest";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "doJsTest";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "doJsDceTest";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "doMetadataTest";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 13: 
            case 24: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

