/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.checkers;

import com.intellij.psi.PsiClass;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.checkers.LazyOperationsLogKt;
import org.jetbrains.kotlin.checkers.LoggingStorageManager;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.Named;
import org.jetbrains.kotlin.load.java.structure.JavaNamedElement;
import org.jetbrains.kotlin.load.java.structure.impl.JavaClassImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaTypeImpl;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.NameResolver;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.renderer.DescriptorRenderer;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.tasks.ResolutionCandidate;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.serialization.deserialization.DeserializationContext;
import org.jetbrains.kotlin.serialization.deserialization.NameResolverUtilKt;
import org.jetbrains.kotlin.serialization.deserialization.TypeDeserializer;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.utils.Printer;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=50, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001#B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u0019\u001a\u00020\u0004J\u0010\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u0001H\u0002J\u0012\u0010\u001c\u001a\u00020\u00042\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u0002J \u0010\u001d\u001a\u00020\u00042\b\u0010\u001e\u001a\u0004\u0018\u00010\u00012\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u001fH\u0002J\u0010\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u0016H\u0002J\f\u0010\"\u001a\u00020\u0004*\u00020\u0004H\u0002R2\u0010\u0006\u001a#\u0012\u0013\u0012\u00110\u0001\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001d\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/checkers/LazyOperationsLog;", "", "stringSanitizer", "Lkotlin/Function1;", "", "(Lkotlin/jvm/functions/Function1;)V", "addRecordFunction", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "lambda", "Lorg/jetbrains/kotlin/checkers/LoggingStorageManager$CallData;", "", "getAddRecordFunction", "()Lkotlin/jvm/functions/Function2;", "ids", "Ljava/util/IdentityHashMap;", "", "getIds", "()Ljava/util/IdentityHashMap;", "records", "Ljava/util/ArrayList;", "Lorg/jetbrains/kotlin/checkers/LazyOperationsLog$Record;", "getStringSanitizer", "()Lkotlin/jvm/functions/Function1;", "getText", "objectId", "o", "render", "renderOwner", "owner", "", "renderRecord", "record", "renumberObjects", "Record", "tests-common"})
public final class LazyOperationsLog {
    @NotNull
    private final Function1<String, String> stringSanitizer;
    @NotNull
    private final IdentityHashMap<Object, Integer> ids;
    @NotNull
    private final ArrayList<Record> records;
    @NotNull
    private final Function2<Object, LoggingStorageManager.CallData, Unit> addRecordFunction;

    public LazyOperationsLog(@NotNull Function1<? super String, String> stringSanitizer) {
        Intrinsics.checkNotNullParameter(stringSanitizer, (String)"stringSanitizer");
        this.stringSanitizer = stringSanitizer;
        this.ids = new IdentityHashMap();
        this.records = new ArrayList();
        this.addRecordFunction = (Function2)new Function2<Object, LoggingStorageManager.CallData, Unit>(this){
            final /* synthetic */ LazyOperationsLog this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull Object lambda, @NotNull LoggingStorageManager.CallData data) {
                Intrinsics.checkNotNullParameter((Object)lambda, (String)"lambda");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                LazyOperationsLog.access$getRecords$p(this.this$0).add(new Record(lambda, data));
            }
        };
    }

    @NotNull
    public final Function1<String, String> getStringSanitizer() {
        return this.stringSanitizer;
    }

    @NotNull
    public final IdentityHashMap<Object, Integer> getIds() {
        return this.ids;
    }

    private final int objectId(Object o) {
        Object object;
        Map $this$getOrPut$iv = this.ids;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(o);
        if (value$iv == null) {
            boolean bl = false;
            Integer answer$iv = this.getIds().size();
            $this$getOrPut$iv.put(o, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        Object v = object;
        return ((Number)v).intValue();
    }

    @NotNull
    public final Function2<Object, LoggingStorageManager.CallData, Unit> getAddRecordFunction() {
        return this.addRecordFunction;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getText() {
        void $this$sortedBy$iv;
        Object object;
        Object object2;
        Object $this$mapTo$iv$iv;
        Pair key$iv;
        boolean bl;
        void $this$groupByTo$iv;
        Iterable iterable = this.records;
        Map destination$iv = new IdentityHashMap();
        boolean $i$f$groupByTo22 = false;
        for (Object element$iv : $this$groupByTo$iv) {
            Object object3;
            Record it = (Record)element$iv;
            bl = false;
            key$iv = it.getData().getFieldOwner();
            Map $this$getOrPut$iv$iv = destination$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv = $this$getOrPut$iv$iv.get(key$iv);
            if (value$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv.put(key$iv, answer$iv$iv);
                object3 = answer$iv$iv;
            } else {
                object3 = value$iv$iv;
            }
            List list$iv = (List)object3;
            list$iv.add(element$iv);
        }
        Object $this$map$iv = destination$iv;
        boolean $i$f$map = false;
        Map $i$f$groupByTo22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv;
        bl = false;
        key$iv = iterator.entrySet().iterator();
        while (key$iv.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry $i$f$getOrPut = item$iv$iv = key$iv.next();
            object2 = destination$iv$iv;
            boolean bl3 = false;
            object = new Pair(it.getKey(), it.getValue());
            object2.add(object);
        }
        List groupedByOwner = (List)destination$iv$iv;
        $this$map$iv = groupedByOwner;
        object2 = this;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            Object item$iv$iv = iterator.next();
            key$iv = (Pair)item$iv$iv;
            object = destination$iv$iv;
            boolean bl4 = false;
            void var11_20 = it;
            Object owner = var11_20.component1();
            List records = (List)var11_20.component2();
            Intrinsics.checkNotNullExpressionValue((Object)records, (String)"records");
            String string = this.renderOwner(owner, records);
            object.add(string);
        }
        object = (List)destination$iv$iv;
        $this$map$iv = (Iterable)object;
        Function1<String, String> selector$iv = this.stringSanitizer;
        boolean $i$f$sortedBy = false;
        boolean bl5 = false;
        return super.renumberObjects(CollectionsKt.joinToString$default((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(selector$iv){
            final /* synthetic */ Function1 $selector;
            {
                this.$selector = function1;
            }

            public final int compare(T a, T b) {
                boolean bl = false;
                return ComparisonsKt.compareValues((Comparable)((Comparable)this.$selector.invoke(a)), (Comparable)((Comparable)this.$selector.invoke(b)));
            }
        }), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
    }

    private final String renumberObjects(String $this$renumberObjects) {
        String string;
        HashMap<String, String> ids = new HashMap<String, String>();
        Matcher m = Pattern.compile("@\\d+").matcher($this$renumberObjects);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            string = m.group(0);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"m.group(0)");
            m.appendReplacement(sb, LazyOperationsLog.renumberObjects$newId(ids, string));
        }
        m.appendTail(sb);
        string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    private final String renderOwner(Object owner, List<Record> records) {
        StringBuilder sb = new StringBuilder();
        Object object = new Printer((Appendable)sb);
        boolean bl = false;
        boolean bl2 = false;
        Printer $this$renderOwner_u24lambda_u2d5 = object;
        boolean bl3 = false;
        Object[] objectArray = new Object[]{this.render(owner), " {"};
        $this$renderOwner_u24lambda_u2d5.println(objectArray);
        LazyOperationsLogKt.access$indent($this$renderOwner_u24lambda_u2d5, (Function1)new Function1<Printer, Unit>(records, this){
            final /* synthetic */ List<Record> $records;
            final /* synthetic */ LazyOperationsLog this$0;
            {
                this.$records = $records;
                this.this$0 = $receiver;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull Printer $this$indent) {
                void $this$sortedBy$iv;
                void $this$mapTo$iv$iv2;
                Iterable $this$map$iv;
                Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
                Iterable iterable = this.$records;
                LazyOperationsLog lazyOperationsLog = this.this$0;
                boolean $i$f$map = false;
                void var5_7 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv2) {
                    void it;
                    Record record = (Record)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    String string = LazyOperationsLog.access$renderRecord(lazyOperationsLog, (Record)it);
                    collection.add(string);
                }
                $this$map$iv = (List)destination$iv$iv;
                Function1<String, String> selector$iv = this.this$0.getStringSanitizer();
                boolean $i$f$sortedBy = false;
                boolean $this$mapTo$iv$iv2 = false;
                Iterable $this$forEach$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(selector$iv){
                    final /* synthetic */ Function1 $selector;
                    {
                        this.$selector = function1;
                    }

                    public final int compare(T a, T b) {
                        boolean bl = false;
                        return ComparisonsKt.compareValues((Comparable)((Comparable)this.$selector.invoke(a)), (Comparable)((Comparable)this.$selector.invoke(b)));
                    }
                });
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    Object[] objectArray = new Object[]{it};
                    $this$indent.println(objectArray);
                }
            }
        });
        objectArray = new Object[]{"}"};
        $this$renderOwner_u24lambda_u2d5.println(objectArray);
        object = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sb.toString()");
        return object;
    }

    private final String renderRecord(Record record) {
        LoggingStorageManager.CallData data = record.getData();
        StringBuilder sb = new StringBuilder();
        Field field = data.getField();
        String string = field == null ? null : field.getName();
        sb.append(string == null ? Intrinsics.stringPlus((String)"in ", (Object)LazyOperationsLogKt.access$getDeclarationName(data.getLambdaCreatedIn())) : string);
        if (!data.getArguments().isEmpty()) {
            CollectionsKt.joinTo$default((Iterable)data.getArguments(), (Appendable)sb, (CharSequence)", ", (CharSequence)"(", (CharSequence)")", (int)0, null, (Function1)((Function1)new Function1<Object, CharSequence>(this){
                final /* synthetic */ LazyOperationsLog this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(@Nullable Object it) {
                    return LazyOperationsLog.access$render(this.this$0, it);
                }
            }), (int)48, null);
        }
        sb.append(Intrinsics.stringPlus((String)" = ", (Object)this.render(data.getResult())));
        if (data.getFieldOwner() instanceof MemberScope) {
            sb.append(Intrinsics.stringPlus((String)" // through ", (Object)this.render(data.getFieldOwner())));
        }
        string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    private final String render(Object o) {
        String string;
        CharSequence charSequence;
        if (o == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        if (o instanceof FqName || o instanceof Name || o instanceof String || o instanceof Number || o instanceof Boolean) {
            sb.append("" + '\'' + o + "': ");
        }
        int id = this.objectId(o);
        Class<?> aClass = o.getClass();
        if (aClass.isAnonymousClass()) {
            charSequence = aClass.getName();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"aClass.name");
            string = StringsKt.substringAfterLast$default((String)charSequence, (char)'.', null, (int)2, null);
        } else {
            string = aClass.getSimpleName();
        }
        sb.append(string).append(Intrinsics.stringPlus((String)"@", (Object)id));
        if (o instanceof Named) {
            charSequence = ((Named)o).getName();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"o.name");
            LazyOperationsLog.render$appendQuoted(charSequence, sb);
        } else if (Intrinsics.areEqual((Object)o.getClass().getSimpleName(), (Object)"LazyJavaClassifierType")) {
            JavaTypeImpl javaType = (JavaTypeImpl)LazyOperationsLogKt.access$field(o, "javaType");
            String string2 = javaType.getPsi().getPresentableText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"javaType.psi.presentableText");
            LazyOperationsLog.render$appendQuoted(string2, sb);
        } else if (Intrinsics.areEqual((Object)o.getClass().getSimpleName(), (Object)"LazyJavaClassTypeConstructor")) {
            JavaClassImpl javaClass = (JavaClassImpl)LazyOperationsLogKt.access$field(LazyOperationsLogKt.access$field(o, "this$0"), "jClass");
            String string3 = ((PsiClass)javaClass.getPsi()).getName();
            Intrinsics.checkNotNull((Object)string3);
            String string4 = string3;
            LazyOperationsLog.render$appendQuoted(string4, sb);
        } else if (Intrinsics.areEqual((Object)o.getClass().getSimpleName(), (Object)"DeserializedType")) {
            String string5;
            TypeDeserializer typeDeserializer = (TypeDeserializer)LazyOperationsLogKt.access$field(o, "typeDeserializer");
            DeserializationContext context = (DeserializationContext)LazyOperationsLogKt.access$field(typeDeserializer, "c");
            ProtoBuf.Type typeProto = (ProtoBuf.Type)LazyOperationsLogKt.access$field(o, "typeProto");
            if (typeProto.hasClassName()) {
                string5 = NameResolverUtilKt.getClassId((NameResolver)context.getNameResolver(), (int)typeProto.getClassName()).asSingleFqName().asString();
            } else if (typeProto.hasTypeParameter()) {
                ClassifierDescriptor classifierDescriptor;
                ClassifierDescriptor classifierDescriptor2 = ((KotlinType)o).getConstructor().getDeclarationDescriptor();
                Intrinsics.checkNotNull((Object)classifierDescriptor2);
                ClassifierDescriptor classifier = classifierDescriptor = classifierDescriptor2;
                string5 = "" + classifier.getName() + " in " + DescriptorUtils.getFqName((DeclarationDescriptor)classifier.getContainingDeclaration());
            } else {
                string5 = "???";
            }
            String string6 = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"when {\n                    typeProto.hasClassName() -> context.nameResolver.getClassId(typeProto.className).asSingleFqName().asString()\n                    typeProto.hasTypeParameter() -> {\n                        val classifier = (o as KotlinType).constructor.declarationDescriptor!!\n                        \"\" + classifier.name + \" in \" + DescriptorUtils.getFqName(classifier.containingDeclaration)\n                    }\n                    else -> \"???\"\n                }");
            String text = string6;
            LazyOperationsLog.render$appendQuoted(text, sb);
        } else if (o instanceof JavaNamedElement) {
            LazyOperationsLog.render$appendQuoted(((JavaNamedElement)o).getName(), sb);
        } else if (o instanceof JavaTypeImpl) {
            charSequence = ((JavaTypeImpl)o).getPsi().getPresentableText();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"o.psi.presentableText");
            LazyOperationsLog.render$appendQuoted(charSequence, sb);
        } else if (o instanceof Collection) {
            if (((Collection)o).isEmpty()) {
                sb.append("[empty]");
            } else {
                sb.append("" + '[' + ((Collection)o).size() + "] ");
                CollectionsKt.joinTo$default((Iterable)((Iterable)o), (Appendable)sb, (CharSequence)", ", (CharSequence)"{", (CharSequence)"}", (int)3, null, (Function1)((Function1)new Function1<Object, CharSequence>(this){
                    final /* synthetic */ LazyOperationsLog this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @NotNull
                    public final CharSequence invoke(@Nullable Object it) {
                        return LazyOperationsLog.access$render(this.this$0, it);
                    }
                }), (int)32, null);
            }
        } else if (o instanceof KotlinType) {
            charSequence = new StringBuilder();
            boolean bl = false;
            boolean bl2 = false;
            CharSequence $this$render_u24lambda_u2d6 = charSequence;
            boolean bl3 = false;
            ((StringBuilder)$this$render_u24lambda_u2d6).append(((KotlinType)o).getConstructor());
            if (!((KotlinType)o).getArguments().isEmpty()) {
                ((StringBuilder)$this$render_u24lambda_u2d6).append("" + '<' + ((KotlinType)o).getArguments().size() + '>');
            }
            LazyOperationsLog.render$appendQuoted(charSequence, sb);
        } else if (o instanceof ResolutionCandidate) {
            charSequence = ((ResolutionCandidate)o).getDescriptor();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"o.descriptor");
            LazyOperationsLog.render$appendQuoted(DescriptorRenderer.COMPACT.render((DeclarationDescriptor)charSequence), sb);
        }
        charSequence = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"sb.toString()");
        return charSequence;
    }

    private static final String renumberObjects$newId(HashMap<String, String> ids, String objectId) {
        Object object;
        Map $this$getOrPut$iv = ids;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(objectId);
        if (value$iv == null) {
            boolean bl = false;
            String answer$iv = Intrinsics.stringPlus((String)"@", (Object)ids.size());
            $this$getOrPut$iv.put(objectId, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (String)object;
    }

    private static final void render$appendQuoted(Object $this$render_u24appendQuoted, StringBuilder sb) {
        sb.append("['").append($this$render_u24appendQuoted).append("']");
    }

    public static final /* synthetic */ String access$render(LazyOperationsLog $this, Object o) {
        return $this.render(o);
    }

    public static final /* synthetic */ String access$renderRecord(LazyOperationsLog $this, Record record) {
        return $this.renderRecord(record);
    }

    public static final /* synthetic */ ArrayList access$getRecords$p(LazyOperationsLog $this) {
        return $this.records;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=50, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/checkers/LazyOperationsLog$Record;", "", "lambda", "data", "Lorg/jetbrains/kotlin/checkers/LoggingStorageManager$CallData;", "(Ljava/lang/Object;Lorg/jetbrains/kotlin/checkers/LoggingStorageManager$CallData;)V", "getData", "()Lorg/jetbrains/kotlin/checkers/LoggingStorageManager$CallData;", "getLambda", "()Ljava/lang/Object;", "tests-common"})
    private static final class Record {
        @NotNull
        private final Object lambda;
        @NotNull
        private final LoggingStorageManager.CallData data;

        public Record(@NotNull Object lambda, @NotNull LoggingStorageManager.CallData data) {
            Intrinsics.checkNotNullParameter((Object)lambda, (String)"lambda");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            this.lambda = lambda;
            this.data = data;
        }

        @NotNull
        public final Object getLambda() {
            return this.lambda;
        }

        @NotNull
        public final LoggingStorageManager.CallData getData() {
            return this.data;
        }
    }
}

