/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.checkers;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.IntRange;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.reflect.jvm.ReflectJvmMapping;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.DuplicateJvmSignatureUtilKt;
import org.jetbrains.kotlin.checkers.BaseDiagnosticsTest;
import org.jetbrains.kotlin.checkers.CompilerTestLanguageVersionSettingsKt;
import org.jetbrains.kotlin.checkers.DiagnosedRange;
import org.jetbrains.kotlin.checkers.DiagnosticDiffCallbacks;
import org.jetbrains.kotlin.checkers.KotlinMultiFileTestWithJava;
import org.jetbrains.kotlin.checkers.TestCheckerUtil;
import org.jetbrains.kotlin.checkers.diagnostics.ActualDiagnostic;
import org.jetbrains.kotlin.checkers.diagnostics.PositionalTextDiagnostic;
import org.jetbrains.kotlin.checkers.diagnostics.TextDiagnostic;
import org.jetbrains.kotlin.checkers.diagnostics.factories.DebugInfoDiagnosticFactory0;
import org.jetbrains.kotlin.checkers.diagnostics.factories.SyntaxErrorDiagnosticFactory;
import org.jetbrains.kotlin.checkers.utils.CheckerTestUtil;
import org.jetbrains.kotlin.checkers.utils.DiagnosticsRenderingConfiguration;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.config.LanguageVersionSettingsImpl;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.impl.ModuleDescriptorImpl;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.PsiDiagnosticUtils;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.load.java.InternalFlexibleTypeTransformer;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.platform.CommonPlatforms;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.js.JsPlatforms;
import org.jetbrains.kotlin.platform.jvm.JvmPlatforms;
import org.jetbrains.kotlin.platform.konan.NativePlatforms;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactoryImpl;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;
import org.jetbrains.kotlin.test.Directives;
import org.jetbrains.kotlin.test.InTextDirectivesUtils;
import org.jetbrains.kotlin.test.KotlinBaseTest;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.junit.Assert;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=50, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000 22\u0012\u0012\u0004\u0012\u00020\u0002\u0012\b\u0012\u00060\u0003R\u00020\u00000\u0001:\u0003234B\u0005\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0010\u0010\u0013\u001a\f\u0012\b\u0012\u00060\u0003R\u00020\u00000\u0014H$J.\u0010\u0015\u001a\u00060\u0003R\u00020\u00002\b\u0010\u0016\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J,\u0010\u001c\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u00182\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00180\u00142\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00180\u0014H\u0014J\"\u0010 \u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u00122\u0010\u0010\u0013\u001a\f\u0012\b\u0012\u00060\u0003R\u00020\u00000\u0014H\u0014J@\u0010 \u001a\u00020\u00102\u0006\u0010!\u001a\u00020\u00122\u0010\u0010\u0013\u001a\f\u0012\b\u0012\u00060\u0003R\u00020\u00000\u00142\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010\u00122\b\b\u0002\u0010#\u001a\u00020$2\b\b\u0002\u0010%\u001a\u00020$J(\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u00142\u0010\u0010(\u001a\f\u0012\b\u0012\u00060\u0003R\u00020\u00000\u00142\u0006\u0010)\u001a\u00020$H\u0014J\u0012\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020\u001bH\u0002J\u0012\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010/\u001a\u00020\u0018H\u0004J\"\u00100\u001a\u00020$2\u0006\u0010!\u001a\u00020\u00122\u0010\u0010\u0013\u001a\f\u0012\b\u0012\u00060\u0003R\u00020\u00000\u0014H\u0014J\b\u00101\u001a\u00020\u0010H\u0014R\u001a\u0010\u0005\u001a\u00020\u0006X\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u00065"}, d2={"Lorg/jetbrains/kotlin/checkers/BaseDiagnosticsTest;", "Lorg/jetbrains/kotlin/checkers/KotlinMultiFileTestWithJava;", "Lorg/jetbrains/kotlin/checkers/BaseDiagnosticsTest$TestModule;", "Lorg/jetbrains/kotlin/checkers/BaseDiagnosticsTest$TestFile;", "()V", "environment", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "getEnvironment", "()Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "setEnvironment", "(Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;)V", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "analyzeAndCheck", "", "testDataFile", "Ljava/io/File;", "files", "", "createTestFile", "module", "fileName", "", "text", "directives", "Lorg/jetbrains/kotlin/test/Directives;", "createTestModule", "name", "dependencies", "friends", "doMultiFileTest", "wholeFile", "additionalClasspath", "usePsiClassFilesReading", "", "excludeNonTypeUseJetbrainsAnnotations", "getKtFiles", "Lorg/jetbrains/kotlin/psi/KtFile;", "testFiles", "includeExtras", "parseJvmTarget", "Lorg/jetbrains/kotlin/config/JvmTarget;", "directiveMap", "parseModulePlatformByName", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "moduleName", "shouldSkipTest", "tearDown", "Companion", "TestFile", "TestModule", "tests-common"})
public abstract class BaseDiagnosticsTest
extends KotlinMultiFileTestWithJava<TestModule, TestFile> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    protected KotlinCoreEnvironment environment;
    @NotNull
    private static final String HELPERS_PATH = "./compiler/testData/diagnostics/helpers";
    @NotNull
    private static final String DIAGNOSTICS_DIRECTIVE = "DIAGNOSTICS";
    @NotNull
    private static final Pattern DIAGNOSTICS_PATTERN;
    @NotNull
    private static final Set<DiagnosticFactory<?>> DIAGNOSTICS_TO_INCLUDE_ANYWAY;
    @NotNull
    private static final Map<LanguageFeature, LanguageFeature.State> DEFAULT_DIAGNOSTIC_TESTS_FEATURES;
    @NotNull
    private static final String CHECK_TYPE_DIRECTIVE;
    @NotNull
    private static final String EXPLICIT_FLEXIBLE_TYPES_DIRECTIVE;
    @NotNull
    private static final String EXPLICIT_FLEXIBLE_PACKAGE;
    @NotNull
    private static final String EXPLICIT_FLEXIBLE_CLASS_NAME;
    @NotNull
    private static final String EXPLICIT_FLEXIBLE_TYPES_DECLARATIONS;
    @NotNull
    private static final String EXPLICIT_FLEXIBLE_TYPES_IMPORT;
    @NotNull
    private static final String CHECK_LAZY_LOG_DIRECTIVE;
    private static final boolean CHECK_LAZY_LOG_DEFAULT;
    @NotNull
    private static final String MARK_DYNAMIC_CALLS_DIRECTIVE;
    @NotNull
    private static final String WITH_NEW_INFERENCE_DIRECTIVE;
    private static final boolean USE_OLD_INFERENCE_DIAGNOSTICS_FOR_NI;
    @NotNull
    private static final String RENDER_DIAGNOSTICS_MESSAGES;
    @NotNull
    private static final String RENDER_DIAGNOSTICS_FULL_TEXT;
    @NotNull
    private static final Regex DIAGNOSTIC_IN_TESTDATA_PATTERN;
    @NotNull
    private static final Regex SPEC_LINKED_TESTDATA_PATTERN;
    @NotNull
    private static final Regex SPEC_NOT_LINED_TESTDATA_PATTERN;

    @NotNull
    protected final KotlinCoreEnvironment getEnvironment() {
        KotlinCoreEnvironment kotlinCoreEnvironment = this.environment;
        if (kotlinCoreEnvironment != null) {
            return kotlinCoreEnvironment;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"environment");
        throw null;
    }

    protected final void setEnvironment(@NotNull KotlinCoreEnvironment kotlinCoreEnvironment) {
        Intrinsics.checkNotNullParameter((Object)kotlinCoreEnvironment, (String)"<set-?>");
        this.environment = kotlinCoreEnvironment;
    }

    @NotNull
    protected final Project getProject() {
        return this.getEnvironment().getProject();
    }

    @Override
    protected void tearDown() {
        Field field = ReflectJvmMapping.getJavaField((KProperty)((KProperty)new PropertyReference0((Object)this){

            @NotNull
            public String getName() {
                return "environment";
            }

            @NotNull
            public KDeclarationContainer getOwner() {
                return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(BaseDiagnosticsTest.class);
            }

            @NotNull
            public String getSignature() {
                return "getEnvironment()Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;";
            }

            @Nullable
            public Object get() {
                return ((BaseDiagnosticsTest)((Object)this.receiver)).getEnvironment();
            }
        }));
        Intrinsics.checkNotNull((Object)field);
        field.set((Object)this, null);
        super.tearDown();
    }

    @Override
    @NotNull
    protected TestModule createTestModule(@NotNull String name, @NotNull List<String> dependencies, @NotNull List<String> friends) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
        Intrinsics.checkNotNullParameter(friends, (String)"friends");
        return new TestModule(name, dependencies, friends);
    }

    @Override
    @NotNull
    protected TestFile createTestFile(@Nullable TestModule module2, @NotNull String fileName, @NotNull String text, @NotNull Directives directives) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)directives, (String)"directives");
        return new TestFile(module2, fileName, text, directives);
    }

    public final void doMultiFileTest(@NotNull File wholeFile, @NotNull List<TestFile> files, @Nullable File additionalClasspath, boolean usePsiClassFilesReading, boolean excludeNonTypeUseJetbrainsAnnotations) {
        Intrinsics.checkNotNullParameter((Object)wholeFile, (String)"wholeFile");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        this.setEnvironment(this.createEnvironment(wholeFile, files, additionalClasspath, usePsiClassFilesReading, excludeNonTypeUseJetbrainsAnnotations));
        if (this.shouldSkipTest(wholeFile, files)) {
            String string = Intrinsics.stringPlus((String)wholeFile.getName(), (Object)" test is skipped");
            boolean bl = false;
            System.out.println((Object)string);
            return;
        }
        this.setupEnvironment(this.getEnvironment());
        this.analyzeAndCheck(wholeFile, files);
    }

    public static /* synthetic */ void doMultiFileTest$default(BaseDiagnosticsTest baseDiagnosticsTest, File file, List list, File file2, boolean bl, boolean bl2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: doMultiFileTest");
        }
        if ((n & 4) != 0) {
            file2 = null;
        }
        if ((n & 8) != 0) {
            bl = true;
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        baseDiagnosticsTest.doMultiFileTest(file, list, file2, bl, bl2);
    }

    @Override
    protected void doMultiFileTest(@NotNull File wholeFile, @NotNull List<TestFile> files) {
        Intrinsics.checkNotNullParameter((Object)wholeFile, (String)"wholeFile");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        BaseDiagnosticsTest.doMultiFileTest$default(this, wholeFile, files, null, false, false, 24, null);
    }

    protected boolean shouldSkipTest(@NotNull File wholeFile, @NotNull List<TestFile> files) {
        Intrinsics.checkNotNullParameter((Object)wholeFile, (String)"wholeFile");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        return false;
    }

    protected abstract void analyzeAndCheck(@NotNull File var1, @NotNull List<TestFile> var2);

    @NotNull
    protected List<KtFile> getKtFiles(@NotNull List<TestFile> testFiles, boolean includeExtras) {
        Intrinsics.checkNotNullParameter(testFiles, (String)"testFiles");
        boolean declareFlexibleType = false;
        boolean declareCheckType = false;
        boolean bl = false;
        ArrayList<KtFile> ktFiles = new ArrayList<KtFile>();
        for (TestFile testFile : testFiles) {
            org.jetbrains.kotlin.utils.CollectionsKt.addIfNotNull((Collection)ktFiles, (Object)testFile.getKtFile());
            declareFlexibleType |= testFile.getDeclareFlexibleType();
            declareCheckType |= testFile.getDeclareCheckType();
        }
        if (includeExtras) {
            if (declareFlexibleType) {
                ktFiles.add(KtTestUtil.createFile((String)"EXPLICIT_FLEXIBLE_TYPES.kt", (String)EXPLICIT_FLEXIBLE_TYPES_DECLARATIONS, (Project)this.getProject()));
            }
            if (declareCheckType) {
                String checkTypeDeclarations = FilesKt.readText$default((File)new File("./compiler/testData/diagnostics/helpers/types/checkType.kt"), null, (int)1, null);
                ktFiles.add(KtTestUtil.createFile((String)"CHECK_TYPE.kt", (String)checkTypeDeclarations, (Project)this.getProject()));
            }
        }
        return ktFiles;
    }

    private final JvmTarget parseJvmTarget(Directives directiveMap) {
        JvmTarget jvmTarget;
        String string = directiveMap.get("JVM_TARGET");
        if (string == null) {
            jvmTarget = null;
        } else {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            jvmTarget = JvmTarget.Companion.fromString(it);
        }
        return jvmTarget;
    }

    @Nullable
    protected final TargetPlatform parseModulePlatformByName(@NotNull String moduleName) {
        TargetPlatform targetPlatform;
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        CharSequence charSequence = StringsKt.substringAfterLast((String)moduleName, (String)"-", (String)"");
        boolean bl = false;
        String string = charSequence;
        if (string == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string2 = string.toUpperCase();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).toUpperCase()");
        String nameSuffix = string2;
        if (Intrinsics.areEqual((Object)nameSuffix, (Object)"COMMON")) {
            targetPlatform = CommonPlatforms.INSTANCE.getDefaultCommonPlatform();
        } else if (Intrinsics.areEqual((Object)nameSuffix, (Object)"JVM")) {
            targetPlatform = JvmPlatforms.INSTANCE.getUnspecifiedJvmPlatform();
        } else if (Intrinsics.areEqual((Object)nameSuffix, (Object)"JS")) {
            targetPlatform = JsPlatforms.INSTANCE.getDefaultJsPlatform();
        } else if (Intrinsics.areEqual((Object)nameSuffix, (Object)"NATIVE")) {
            targetPlatform = NativePlatforms.INSTANCE.getUnspecifiedNativePlatform();
        } else {
            charSequence = nameSuffix;
            bl = false;
            if (charSequence.length() == 0) {
                targetPlatform = null;
            } else {
                throw new IllegalStateException(Intrinsics.stringPlus((String)"Can't determine platform by name ", (Object)nameSuffix));
            }
        }
        return targetPlatform;
    }

    static {
        Object object = Pattern.compile("([+\\-!])(\\w+)\\s*");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compile(\"([+\\\\-!])(\\\\w+)\\\\s*\")");
        DIAGNOSTICS_PATTERN = object;
        object = new DiagnosticFactory[]{(DiagnosticFactory)Errors.UNRESOLVED_REFERENCE, (DiagnosticFactory)Errors.UNRESOLVED_REFERENCE_WRONG_RECEIVER, (DiagnosticFactory)SyntaxErrorDiagnosticFactory.Companion.getINSTANCE(), (DiagnosticFactory)DebugInfoDiagnosticFactory0.Companion.getELEMENT_WITH_ERROR_TYPE(), (DiagnosticFactory)DebugInfoDiagnosticFactory0.Companion.getMISSING_UNRESOLVED(), (DiagnosticFactory)DebugInfoDiagnosticFactory0.Companion.getUNRESOLVED_WITH_TARGET()};
        DIAGNOSTICS_TO_INCLUDE_ANYWAY = SetsKt.setOf((Object[])object);
        DEFAULT_DIAGNOSTIC_TESTS_FEATURES = MapsKt.mapOf((Pair)TuplesKt.to((Object)LanguageFeature.Coroutines, (Object)LanguageFeature.State.ENABLED));
        CHECK_TYPE_DIRECTIVE = "CHECK_TYPE";
        EXPLICIT_FLEXIBLE_TYPES_DIRECTIVE = "EXPLICIT_FLEXIBLE_TYPES";
        object = InternalFlexibleTypeTransformer.FLEXIBLE_TYPE_CLASSIFIER.getPackageFqName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"FLEXIBLE_TYPE_CLASSIFIER.packageFqName.asString()");
        EXPLICIT_FLEXIBLE_PACKAGE = object;
        object = InternalFlexibleTypeTransformer.FLEXIBLE_TYPE_CLASSIFIER.getRelativeClassName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"FLEXIBLE_TYPE_CLASSIFIER.relativeClassName.asString()");
        EXPLICIT_FLEXIBLE_CLASS_NAME = object;
        EXPLICIT_FLEXIBLE_TYPES_DECLARATIONS = "\npackage " + EXPLICIT_FLEXIBLE_PACKAGE + "\npublic class " + EXPLICIT_FLEXIBLE_CLASS_NAME + "<L, U>";
        EXPLICIT_FLEXIBLE_TYPES_IMPORT = "import " + EXPLICIT_FLEXIBLE_PACKAGE + '.' + EXPLICIT_FLEXIBLE_CLASS_NAME;
        CHECK_LAZY_LOG_DIRECTIVE = "CHECK_LAZY_LOG";
        CHECK_LAZY_LOG_DEFAULT = Intrinsics.areEqual((Object)"true", (Object)System.getProperty("check.lazy.logs", "false"));
        MARK_DYNAMIC_CALLS_DIRECTIVE = "MARK_DYNAMIC_CALLS";
        WITH_NEW_INFERENCE_DIRECTIVE = "WITH_NEW_INFERENCE";
        RENDER_DIAGNOSTICS_MESSAGES = "RENDER_DIAGNOSTICS_MESSAGES";
        RENDER_DIAGNOSTICS_FULL_TEXT = "RENDER_DIAGNOSTICS_FULL_TEXT";
        DIAGNOSTIC_IN_TESTDATA_PATTERN = new Regex("<!>|<!(.*?(\\(\".*?\"\\)|\\(\\))??)+(?<!<)!>");
        SPEC_LINKED_TESTDATA_PATTERN = new Regex("\\/\\*\\s+? \\* KOTLIN (PSI|DIAGNOSTICS|CODEGEN BOX) SPEC TEST \\((POSITIVE|NEGATIVE)\\)\\n([\\s\\S]*?\\n)\\s+\\*\\/\\n");
        SPEC_NOT_LINED_TESTDATA_PATTERN = new Regex("\\/\\*\\s+? \\* KOTLIN (PSI|DIAGNOSTICS|CODEGEN BOX) NOT LINKED SPEC TEST \\((POSITIVE|NEGATIVE)\\)\\n([\\s\\S]*?\\n)\\s+\\*\\/\\n");
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=50, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/checkers/BaseDiagnosticsTest$TestModule;", "Lorg/jetbrains/kotlin/test/KotlinBaseTest$TestModule;", "name", "", "dependencies", "", "friends", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;)V", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "getLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "setLanguageVersionSettings", "(Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "tests-common"})
    public static final class TestModule
    extends KotlinBaseTest.TestModule {
        public LanguageVersionSettings languageVersionSettings;

        public TestModule(@NotNull String name, @NotNull List<String> dependencies, @NotNull List<String> friends) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
            Intrinsics.checkNotNullParameter(friends, (String)"friends");
            super(name, dependencies, friends);
        }

        @NotNull
        public final LanguageVersionSettings getLanguageVersionSettings() {
            LanguageVersionSettings languageVersionSettings = this.languageVersionSettings;
            if (languageVersionSettings != null) {
                return languageVersionSettings;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"languageVersionSettings");
            throw null;
        }

        public final void setLanguageVersionSettings(@NotNull LanguageVersionSettings languageVersionSettings) {
            Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"<set-?>");
            this.languageVersionSettings = languageVersionSettings;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=50, d1={"\u0000\u00ba\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B'\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010K\u001a\u00020\u00052\u0006\u0010L\u001a\u00020\u0005J\u0018\u0010M\u001a\u00020\u00052\u0006\u0010L\u001a\u00020\u00052\u0006\u00102\u001a\u00020\u0005H\u0002J\u0010\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020\u0010H\u0002J\u0016\u0010Q\u001a\b\u0012\u0004\u0012\u00020\f0R2\u0006\u0010S\u001a\u00020TH\u0002JL\u0010U\u001a\u00020\u00102\u0006\u0010S\u001a\u00020T2\u0018\u0010V\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020Y\u0012\u0004\u0012\u00020T0X0W2\n\u0010Z\u001a\u00060[j\u0002`\\2\u0006\u0010]\u001a\u00020\u00102\u0006\u0010^\u001a\u00020\u001a2\u0006\u0010_\u001a\u00020`J\b\u0010a\u001a\u00020\u0010H\u0002J\u0012\u0010b\u001a\u00020c2\n\u0010Z\u001a\u00060[j\u0002`\\J\b\u0010d\u001a\u00020\u0005H\u0016R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0019\u001a\u0004\u0018\u00010\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0012R\u0011\u0010\u001f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0012R\u0017\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u000eR#\u0010$\u001a\u0014\u0012\u0004\u0012\u00020&\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050'0%\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0017\u0010*\u001a\b\u0012\u0004\u0012\u00020+0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\u000eR\u0011\u0010-\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\u0015R\u0014\u0010/\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010\u0015R\u0014\u00102\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u0010\u0015R\u0013\u00104\u001a\u0004\u0018\u000105\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R\u001d\u00108\u001a\u0004\u0018\u00010\u00188FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b;\u0010<\u001a\u0004\b9\u0010:R\u000e\u0010=\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010?R\u0011\u0010@\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u0010\u0012R\u0011\u0010B\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u0010\u0012R\u0011\u0010D\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u0010\u0012R\u0014\u0010F\u001a\b\u0012\u0004\u0012\u00020H0GX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010I\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\bJ\u0010\u0012\u00a8\u0006e"}, d2={"Lorg/jetbrains/kotlin/checkers/BaseDiagnosticsTest$TestFile;", "Lorg/jetbrains/kotlin/test/KotlinBaseTest$TestFile;", "module", "Lorg/jetbrains/kotlin/checkers/BaseDiagnosticsTest$TestModule;", "fileName", "", "textWithMarkers", "directives", "Lorg/jetbrains/kotlin/test/Directives;", "(Lorg/jetbrains/kotlin/checkers/BaseDiagnosticsTest;Lorg/jetbrains/kotlin/checkers/BaseDiagnosticsTest$TestModule;Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/kotlin/test/Directives;)V", "actualDiagnostics", "", "Lorg/jetbrains/kotlin/checkers/diagnostics/ActualDiagnostic;", "getActualDiagnostics", "()Ljava/util/List;", "checkLazyLog", "", "getCheckLazyLog", "()Z", "clearText", "getClearText", "()Ljava/lang/String;", "createKtFile", "Lkotlin/Lazy;", "Lorg/jetbrains/kotlin/psi/KtFile;", "customLanguageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "getCustomLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "declareCheckType", "getDeclareCheckType", "declareFlexibleType", "getDeclareFlexibleType", "diagnosedRanges", "Lorg/jetbrains/kotlin/checkers/DiagnosedRange;", "getDiagnosedRanges", "diagnosedRangesToDiagnosticNames", "", "Lkotlin/ranges/IntRange;", "", "getDiagnosedRangesToDiagnosticNames", "()Ljava/util/Map;", "dynamicCallDescriptors", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "getDynamicCallDescriptors", "expectedText", "getExpectedText", "extras", "getExtras", "getFileName", "imports", "getImports", "jvmTarget", "Lorg/jetbrains/kotlin/config/JvmTarget;", "getJvmTarget", "()Lorg/jetbrains/kotlin/config/JvmTarget;", "ktFile", "getKtFile", "()Lorg/jetbrains/kotlin/psi/KtFile;", "ktFile$delegate", "Lkotlin/Lazy;", "markDynamicCalls", "getModule", "()Lorg/jetbrains/kotlin/checkers/BaseDiagnosticsTest$TestModule;", "newInferenceEnabled", "getNewInferenceEnabled", "renderDiagnosticMessages", "getRenderDiagnosticMessages", "renderDiagnosticsFullText", "getRenderDiagnosticsFullText", "whatDiagnosticsToConsider", "Lcom/intellij/openapi/util/Condition;", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "withNewInferenceDirective", "getWithNewInferenceDirective", "addExtras", "text", "addImports", "asInferenceCompatibility", "Lorg/jetbrains/kotlin/checkers/diagnostics/TextDiagnostic$InferenceCompatibility;", "isNewInference", "computeJvmSignatureDiagnostics", "", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "getActualText", "implementingModulesBindings", "", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "actualText", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "skipJvmSignatureDiagnostics", "languageVersionSettings", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/impl/ModuleDescriptorImpl;", "shouldUseNewInferenceForTests", "stripExtras", "", "toString", "tests-common"})
    public final class TestFile
    extends KotlinBaseTest.TestFile {
        @Nullable
        private final TestModule module;
        @NotNull
        private final String fileName;
        @NotNull
        private final List<DiagnosedRange> diagnosedRanges;
        @NotNull
        private final Map<IntRange, Set<String>> diagnosedRangesToDiagnosticNames;
        @NotNull
        private final List<ActualDiagnostic> actualDiagnostics;
        @NotNull
        private final String expectedText;
        @NotNull
        private final String clearText;
        @NotNull
        private final Lazy<KtFile> createKtFile;
        @NotNull
        private final Condition<Diagnostic> whatDiagnosticsToConsider;
        @Nullable
        private final LanguageVersionSettings customLanguageVersionSettings;
        @Nullable
        private final JvmTarget jvmTarget;
        private final boolean declareCheckType;
        private final boolean declareFlexibleType;
        private final boolean checkLazyLog;
        private final boolean markDynamicCalls;
        @NotNull
        private final List<DeclarationDescriptor> dynamicCallDescriptors;
        private final boolean withNewInferenceDirective;
        private final boolean newInferenceEnabled;
        private final boolean renderDiagnosticMessages;
        private final boolean renderDiagnosticsFullText;
        @NotNull
        private final Lazy ktFile$delegate;

        public TestFile(@NotNull TestModule module2, @NotNull String fileName, @NotNull String textWithMarkers, Directives directives) {
            Intrinsics.checkNotNullParameter((Object)((Object)BaseDiagnosticsTest.this), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            Intrinsics.checkNotNullParameter((Object)textWithMarkers, (String)"textWithMarkers");
            Intrinsics.checkNotNullParameter((Object)directives, (String)"directives");
            super(fileName, textWithMarkers, directives);
            this.module = module2;
            this.fileName = fileName;
            boolean bl = false;
            this.diagnosedRanges = new ArrayList();
            bl = false;
            this.diagnosedRangesToDiagnosticNames = new LinkedHashMap();
            bl = false;
            this.actualDiagnostics = new ArrayList();
            this.declareCheckType = directives.contains(Companion.getCHECK_TYPE_DIRECTIVE());
            bl = false;
            this.dynamicCallDescriptors = new ArrayList();
            this.whatDiagnosticsToConsider = Companion.parseDiagnosticFilterDirective(directives, this.declareCheckType);
            this.customLanguageVersionSettings = CompilerTestLanguageVersionSettingsKt.parseLanguageVersionSettings(directives);
            this.jvmTarget = BaseDiagnosticsTest.this.parseJvmTarget(directives);
            this.checkLazyLog = directives.contains(Companion.getCHECK_LAZY_LOG_DIRECTIVE()) || Companion.getCHECK_LAZY_LOG_DEFAULT();
            this.declareFlexibleType = directives.contains(Companion.getEXPLICIT_FLEXIBLE_TYPES_DIRECTIVE());
            this.markDynamicCalls = directives.contains(Companion.getMARK_DYNAMIC_CALLS_DIRECTIVE());
            this.withNewInferenceDirective = directives.contains(Companion.getWITH_NEW_INFERENCE_DIRECTIVE());
            LanguageVersionSettings languageVersionSettings = this.customLanguageVersionSettings;
            Boolean bl2 = languageVersionSettings == null ? null : Boolean.valueOf(languageVersionSettings.supportsFeature(LanguageFeature.NewInference));
            boolean bl3 = this.newInferenceEnabled = bl2 == null ? this.shouldUseNewInferenceForTests() : bl2.booleanValue();
            if (StringsKt.endsWith$default((String)this.fileName, (String)".java", (boolean)false, (int)2, null)) {
                this.createKtFile = LazyKt.lazyOf(null);
                this.expectedText = this.clearText = textWithMarkers;
            } else {
                this.expectedText = textWithMarkers;
                this.clearText = CheckerTestUtil.INSTANCE.parseDiagnosedRanges(this.addExtras(this.expectedText), this.diagnosedRanges, this.diagnosedRangesToDiagnosticNames);
                this.createKtFile = LazyKt.lazy((Function0)((Function0)new Function0<KtFile>(){

                    @NotNull
                    public final KtFile invoke() {
                        return TestCheckerUtil.createCheckAndReturnPsiFile(this.getFileName(), this.getClearText(), BaseDiagnosticsTest.this.getProject());
                    }
                }));
            }
            this.renderDiagnosticMessages = directives.contains(Companion.getRENDER_DIAGNOSTICS_MESSAGES());
            this.renderDiagnosticsFullText = directives.contains(Companion.getRENDER_DIAGNOSTICS_FULL_TEXT());
            this.ktFile$delegate = this.createKtFile;
        }

        @Nullable
        public final TestModule getModule() {
            return this.module;
        }

        @NotNull
        public final String getFileName() {
            return this.fileName;
        }

        @NotNull
        public final List<DiagnosedRange> getDiagnosedRanges() {
            return this.diagnosedRanges;
        }

        @NotNull
        public final Map<IntRange, Set<String>> getDiagnosedRangesToDiagnosticNames() {
            return this.diagnosedRangesToDiagnosticNames;
        }

        @NotNull
        public final List<ActualDiagnostic> getActualDiagnostics() {
            return this.actualDiagnostics;
        }

        @NotNull
        public final String getExpectedText() {
            return this.expectedText;
        }

        @NotNull
        public final String getClearText() {
            return this.clearText;
        }

        @Nullable
        public final LanguageVersionSettings getCustomLanguageVersionSettings() {
            return this.customLanguageVersionSettings;
        }

        @Nullable
        public final JvmTarget getJvmTarget() {
            return this.jvmTarget;
        }

        public final boolean getDeclareCheckType() {
            return this.declareCheckType;
        }

        public final boolean getDeclareFlexibleType() {
            return this.declareFlexibleType;
        }

        public final boolean getCheckLazyLog() {
            return this.checkLazyLog;
        }

        @NotNull
        public final List<DeclarationDescriptor> getDynamicCallDescriptors() {
            return this.dynamicCallDescriptors;
        }

        public final boolean getWithNewInferenceDirective() {
            return this.withNewInferenceDirective;
        }

        public final boolean getNewInferenceEnabled() {
            return this.newInferenceEnabled;
        }

        public final boolean getRenderDiagnosticMessages() {
            return this.renderDiagnosticMessages;
        }

        public final boolean getRenderDiagnosticsFullText() {
            return this.renderDiagnosticsFullText;
        }

        @Nullable
        public final KtFile getKtFile() {
            Lazy lazy = this.ktFile$delegate;
            boolean bl = false;
            return (KtFile)lazy.getValue();
        }

        private final String getImports() {
            boolean bl = false;
            boolean bl2 = false;
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl3 = false;
            boolean bl4 = false;
            StringBuilder $this$_get_imports__u24lambda_u2d0 = stringBuilder;
            boolean bl5 = false;
            if (this.getDeclareFlexibleType()) {
                $this$_get_imports__u24lambda_u2d0.append(Intrinsics.stringPlus((String)EXPLICIT_FLEXIBLE_TYPES_IMPORT, (Object)"\n"));
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
            return string;
        }

        private final String getExtras() {
            return "/*extras*/\n" + this.getImports() + "/*extras*/\n\n";
        }

        @NotNull
        public final String addExtras(@NotNull String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            return this.addImports(text, this.getExtras());
        }

        public final void stripExtras(@NotNull StringBuilder actualText) {
            Intrinsics.checkNotNullParameter((Object)actualText, (String)"actualText");
            String extras = this.getExtras();
            int start = actualText.indexOf(extras);
            if (start >= 0) {
                actualText.delete(start, start + extras.length());
            }
        }

        private final String addImports(String text, String imports) {
            String string;
            String result = text;
            Pattern pattern = Pattern.compile("^package [.\\w\\d]*\n", 8);
            Matcher matcher = pattern.matcher(result);
            if (matcher.find()) {
                StringBuilder stringBuilder = new StringBuilder();
                String string2 = result;
                int n = 0;
                int n2 = matcher.end();
                boolean bl = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.substring(n, n2);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                StringBuilder stringBuilder2 = stringBuilder.append(string4).append(imports);
                string2 = result;
                n = matcher.end();
                n2 = 0;
                String string5 = string2;
                if (string5 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string6 = string5.substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
                string = stringBuilder2.append(string6).toString();
            } else {
                string = Intrinsics.stringPlus((String)imports, (Object)result);
            }
            result = string;
            return result;
        }

        private final boolean shouldUseNewInferenceForTests() {
            if (Intrinsics.areEqual((Object)System.getProperty("kotlin.ni"), (Object)"true")) {
                return true;
            }
            return LanguageVersionSettingsImpl.DEFAULT.supportsFeature(LanguageFeature.NewInference);
        }

        /*
         * WARNING - void declaration
         */
        public final boolean getActualText(@NotNull BindingContext bindingContext, @NotNull List<? extends Pair<? extends TargetPlatform, ? extends BindingContext>> implementingModulesBindings, @NotNull StringBuilder actualText, boolean skipJvmSignatureDiagnostics, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull ModuleDescriptorImpl moduleDescriptor) {
            void $this$forEach$iv;
            Iterator $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
            Intrinsics.checkNotNullParameter(implementingModulesBindings, (String)"implementingModulesBindings");
            Intrinsics.checkNotNullParameter((Object)actualText, (String)"actualText");
            Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
            Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
            KtFile ktFile = this.getKtFile();
            if (ktFile == null) {
                actualText.append(this.clearText);
                return true;
            }
            String string = ktFile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ktFile.name");
            if (StringsKt.endsWith$default((String)string, (String)"CoroutineUtil.kt", (boolean)false, (int)2, null) && Intrinsics.areEqual((Object)ktFile.getPackageFqName(), (Object)new FqName("helpers"))) {
                return true;
            }
            Set<ActualDiagnostic> jvmSignatureDiagnostics = skipJvmSignatureDiagnostics ? SetsKt.emptySet() : this.computeJvmSignatureDiagnostics(bindingContext);
            boolean[] blArray = new boolean[]{true};
            boolean[] ok = blArray;
            boolean withNewInference = this.newInferenceEnabled && this.withNewInferenceDirective && !Companion.getUSE_OLD_INFERENCE_DIAGNOSTICS_FOR_NI();
            List diagnostics = CheckerTestUtil.INSTANCE.getDiagnosticsIncludingSyntaxErrors(bindingContext, implementingModulesBindings, (PsiElement)ktFile, this.markDynamicCalls, this.dynamicCallDescriptors, new DiagnosticsRenderingConfiguration(null, withNewInference, languageVersionSettings, BaseDiagnosticsTest.this.getEnvironment().getConfiguration().getBoolean(JVMConfigurationKeys.IR)), (DataFlowValueFactory)new DataFlowValueFactoryImpl(languageVersionSettings), moduleDescriptor, this.diagnosedRangesToDiagnosticNames);
            List list = ContainerUtil.filter((Collection)CollectionsKt.plus((Collection)diagnostics, (Iterable)jvmSignatureDiagnostics), (Condition)((Condition)new Condition<ActualDiagnostic>(this){
                final /* synthetic */ TestFile this$0;
                {
                    this.this$0 = $receiver;
                }

                public final boolean value(ActualDiagnostic it) {
                    return TestFile.access$getWhatDiagnosticsToConsider$p(this.this$0).value((Object)it.getDiagnostic());
                }
            }));
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fun getActualText(\n            bindingContext: BindingContext,\n            implementingModulesBindings: List<Pair<TargetPlatform, BindingContext>>,\n            actualText: StringBuilder,\n            skipJvmSignatureDiagnostics: Boolean,\n            languageVersionSettings: LanguageVersionSettings,\n            moduleDescriptor: ModuleDescriptorImpl\n        ): Boolean {\n            val ktFile = this.ktFile\n            if (ktFile == null) {\n                // TODO: check java files too\n                actualText.append(this.clearText)\n                return true\n            }\n\n            if (ktFile.name.endsWith(\"CoroutineUtil.kt\") && ktFile.packageFqName == FqName(\"helpers\")) return true\n\n            // TODO: report JVM signature diagnostics also for implementing modules\n            val jvmSignatureDiagnostics = if (skipJvmSignatureDiagnostics)\n                emptySet<ActualDiagnostic>()\n            else\n                computeJvmSignatureDiagnostics(bindingContext)\n\n            val ok = booleanArrayOf(true)\n            val withNewInference = newInferenceEnabled && withNewInferenceDirective && !USE_OLD_INFERENCE_DIAGNOSTICS_FOR_NI\n            val diagnostics = CheckerTestUtil.getDiagnosticsIncludingSyntaxErrors(\n                bindingContext,\n                implementingModulesBindings,\n                ktFile,\n                markDynamicCalls,\n                dynamicCallDescriptors,\n                DiagnosticsRenderingConfiguration(\n                    platform = null,\n                    withNewInference,\n                    languageVersionSettings,\n                    // When using JVM IR, binding context is empty at the end of compilation, so debug info markers can't be computed.\n                    environment.configuration.getBoolean(JVMConfigurationKeys.IR),\n                ),\n                DataFlowValueFactoryImpl(languageVersionSettings),\n                moduleDescriptor,\n                this.diagnosedRangesToDiagnosticNames\n            )\n            val filteredDiagnostics = ContainerUtil.filter(diagnostics + jvmSignatureDiagnostics) {\n                whatDiagnosticsToConsider.value(it.diagnostic)\n            }\n\n            filteredDiagnostics.map { it.diagnostic }.forEach { diagnostic ->\n                val diagnosticElementTextRange = diagnostic.psiElement.textRange\n                diagnostic.textRanges.forEach {\n                    check(diagnosticElementTextRange.contains(it)) {\n                        \"Annotation API violation:\" +\n                                \" diagnostic text range $it has to be in range of\" +\n                                \" diagnostic element ${diagnostic.psiElement} '${diagnostic.psiElement.text}'\" +\n                                \" (factory ${diagnostic.factory.name}): $diagnosticElementTextRange\"\n                    }\n                }\n            }\n\n            actualDiagnostics.addAll(filteredDiagnostics)\n\n            val uncheckedDiagnostics = mutableListOf<PositionalTextDiagnostic>()\n            val inferenceCompatibilityOfTest = asInferenceCompatibility(withNewInference)\n            val invertedInferenceCompatibilityOfTest = asInferenceCompatibility(!withNewInference)\n\n            val diagnosticToExpectedDiagnostic =\n                CheckerTestUtil.diagnosticsDiff(diagnosedRanges, filteredDiagnostics, object : DiagnosticDiffCallbacks {\n                    override fun missingDiagnostic(diagnostic: TextDiagnostic, expectedStart: Int, expectedEnd: Int) {\n                        if (withNewInferenceDirective && diagnostic.inferenceCompatibility != inferenceCompatibilityOfTest) {\n                            updateUncheckedDiagnostics(diagnostic, expectedStart, expectedEnd)\n                            return\n                        }\n\n                        val message = \"Missing \" + diagnostic.description + PsiDiagnosticUtils.atLocation(\n                            ktFile,\n                            TextRange(expectedStart, expectedEnd)\n                        )\n                        System.err.println(message)\n                        ok[0] = false\n                    }\n\n                    override fun wrongParametersDiagnostic(\n                        expectedDiagnostic: TextDiagnostic,\n                        actualDiagnostic: TextDiagnostic,\n                        start: Int,\n                        end: Int\n                    ) {\n                        val message = \"Parameters of diagnostic not equal at position \" +\n                                PsiDiagnosticUtils.atLocation(ktFile, TextRange(start, end)) +\n                                \". Expected: ${expectedDiagnostic.asString()}, actual: $actualDiagnostic\"\n                        System.err.println(message)\n                        ok[0] = false\n                    }\n\n                    override fun unexpectedDiagnostic(diagnostic: TextDiagnostic, actualStart: Int, actualEnd: Int) {\n                        if (withNewInferenceDirective && diagnostic.inferenceCompatibility != inferenceCompatibilityOfTest) {\n                            updateUncheckedDiagnostics(diagnostic, actualStart, actualEnd)\n                            return\n                        }\n\n                        val message = \"Unexpected ${diagnostic.description}${PsiDiagnosticUtils.atLocation(\n                            ktFile,\n                            TextRange(actualStart, actualEnd)\n                        )}\"\n                        System.err.println(message)\n                        ok[0] = false\n                    }\n\n                    fun updateUncheckedDiagnostics(diagnostic: TextDiagnostic, start: Int, end: Int) {\n                        diagnostic.enhanceInferenceCompatibility(invertedInferenceCompatibilityOfTest)\n                        uncheckedDiagnostics.add(PositionalTextDiagnostic(diagnostic, start, end))\n                    }\n                })\n\n            actualText.append(\n                CheckerTestUtil.addDiagnosticMarkersToText(\n                    ktFile,\n                    filteredDiagnostics,\n                    diagnosticToExpectedDiagnostic,\n                    { file -> file.text },\n                    uncheckedDiagnostics,\n                    withNewInferenceDirective,\n                    renderDiagnosticMessages\n                )\n            )\n\n            stripExtras(actualText)\n\n            return ok[0]\n        }");
            List filteredDiagnostics2 = list;
            Iterable $this$map$iv = filteredDiagnostics2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                Object item$iv$iv = iterator.next();
                ActualDiagnostic actualDiagnostic = (ActualDiagnostic)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Diagnostic diagnostic = it.getDiagnostic();
                collection.add(diagnostic);
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Diagnostic diagnostic = (Diagnostic)element$iv;
                boolean bl = false;
                TextRange diagnosticElementTextRange = diagnostic.getPsiElement().getTextRange();
                Iterable $this$forEach$iv2 = diagnostic.getTextRanges();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    TextRange it = (TextRange)element$iv2;
                    boolean bl2 = false;
                    boolean bl3 = diagnosticElementTextRange.contains(it);
                    boolean bl4 = false;
                    boolean bl5 = false;
                    if (bl3) continue;
                    boolean bl6 = false;
                    String string2 = "Annotation API violation: diagnostic text range " + it + " has to be in range of diagnostic element " + diagnostic.getPsiElement() + " '" + diagnostic.getPsiElement().getText() + "' (factory " + diagnostic.getFactory().getName() + "): " + diagnosticElementTextRange;
                    throw (Throwable)new IllegalStateException(string2.toString());
                }
            }
            this.actualDiagnostics.addAll(filteredDiagnostics2);
            $i$f$forEach = false;
            List uncheckedDiagnostics = new ArrayList();
            TextDiagnostic.InferenceCompatibility inferenceCompatibilityOfTest = this.asInferenceCompatibility(withNewInference);
            TextDiagnostic.InferenceCompatibility invertedInferenceCompatibilityOfTest = this.asInferenceCompatibility(!withNewInference);
            Map diagnosticToExpectedDiagnostic2 = CheckerTestUtil.INSTANCE.diagnosticsDiff(this.diagnosedRanges, (Collection)filteredDiagnostics2, new DiagnosticDiffCallbacks(this, inferenceCompatibilityOfTest, ktFile, ok, invertedInferenceCompatibilityOfTest, uncheckedDiagnostics){
                final /* synthetic */ TestFile this$0;
                final /* synthetic */ TextDiagnostic.InferenceCompatibility $inferenceCompatibilityOfTest;
                final /* synthetic */ KtFile $ktFile;
                final /* synthetic */ boolean[] $ok;
                final /* synthetic */ TextDiagnostic.InferenceCompatibility $invertedInferenceCompatibilityOfTest;
                final /* synthetic */ List<PositionalTextDiagnostic> $uncheckedDiagnostics;
                {
                    this.this$0 = $receiver;
                    this.$inferenceCompatibilityOfTest = $inferenceCompatibilityOfTest;
                    this.$ktFile = $ktFile;
                    this.$ok = $ok;
                    this.$invertedInferenceCompatibilityOfTest = $invertedInferenceCompatibilityOfTest;
                    this.$uncheckedDiagnostics = $uncheckedDiagnostics;
                }

                public void missingDiagnostic(@NotNull TextDiagnostic diagnostic, int expectedStart, int expectedEnd) {
                    Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
                    if (this.this$0.getWithNewInferenceDirective() && diagnostic.getInferenceCompatibility() != this.$inferenceCompatibilityOfTest) {
                        this.updateUncheckedDiagnostics(diagnostic, expectedStart, expectedEnd);
                        return;
                    }
                    String message = "Missing " + diagnostic.getDescription() + PsiDiagnosticUtils.atLocation((PsiFile)((PsiFile)this.$ktFile), (TextRange)new TextRange(expectedStart, expectedEnd));
                    System.err.println(message);
                    this.$ok[0] = false;
                }

                public void wrongParametersDiagnostic(@NotNull TextDiagnostic expectedDiagnostic, @NotNull TextDiagnostic actualDiagnostic, int start, int end) {
                    Intrinsics.checkNotNullParameter((Object)expectedDiagnostic, (String)"expectedDiagnostic");
                    Intrinsics.checkNotNullParameter((Object)actualDiagnostic, (String)"actualDiagnostic");
                    String message = "Parameters of diagnostic not equal at position " + PsiDiagnosticUtils.atLocation((PsiFile)((PsiFile)this.$ktFile), (TextRange)new TextRange(start, end)) + ". Expected: " + TextDiagnostic.asString$default((TextDiagnostic)expectedDiagnostic, (boolean)false, (boolean)false, (int)3, null) + ", actual: " + actualDiagnostic;
                    System.err.println(message);
                    this.$ok[0] = false;
                }

                public void unexpectedDiagnostic(@NotNull TextDiagnostic diagnostic, int actualStart, int actualEnd) {
                    Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
                    if (this.this$0.getWithNewInferenceDirective() && diagnostic.getInferenceCompatibility() != this.$inferenceCompatibilityOfTest) {
                        this.updateUncheckedDiagnostics(diagnostic, actualStart, actualEnd);
                        return;
                    }
                    String message = "Unexpected " + diagnostic.getDescription() + PsiDiagnosticUtils.atLocation((PsiFile)((PsiFile)this.$ktFile), (TextRange)new TextRange(actualStart, actualEnd));
                    System.err.println(message);
                    this.$ok[0] = false;
                }

                public final void updateUncheckedDiagnostics(@NotNull TextDiagnostic diagnostic, int start, int end) {
                    Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
                    diagnostic.enhanceInferenceCompatibility(this.$invertedInferenceCompatibilityOfTest);
                    this.$uncheckedDiagnostics.add(new PositionalTextDiagnostic(diagnostic, start, end));
                }
            });
            actualText.append(CheckerTestUtil.INSTANCE.addDiagnosticMarkersToText((PsiFile)ktFile, (Collection)filteredDiagnostics2, diagnosticToExpectedDiagnostic2, (Function1)getActualText.3.INSTANCE, (Collection)uncheckedDiagnostics, this.withNewInferenceDirective, this.renderDiagnosticMessages));
            this.stripExtras(actualText);
            return ok[0];
        }

        private final TextDiagnostic.InferenceCompatibility asInferenceCompatibility(boolean isNewInference) {
            return isNewInference ? TextDiagnostic.InferenceCompatibility.NEW : TextDiagnostic.InferenceCompatibility.OLD;
        }

        /*
         * WARNING - void declaration
         */
        private final Set<ActualDiagnostic> computeJvmSignatureDiagnostics(BindingContext bindingContext) {
            HashSet jvmSignatureDiagnostics = new HashSet();
            Collection collection = PsiTreeUtil.findChildrenOfType((PsiElement)((PsiElement)this.getKtFile()), KtDeclaration.class);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findChildrenOfType(ktFile, KtDeclaration::class.java)");
            Collection declarations = collection;
            for (KtDeclaration declaration : declarations) {
                Collection<ActualDiagnostic> collection2;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullExpressionValue((Object)declaration, (String)"declaration");
                PsiElement psiElement = (PsiElement)declaration;
                Diagnostics diagnostics = bindingContext.getDiagnostics();
                Intrinsics.checkNotNullExpressionValue((Object)diagnostics, (String)"bindingContext.diagnostics");
                Diagnostics diagnostics2 = diagnostics;
                diagnostics = GlobalSearchScope.allScope((Project)BaseDiagnosticsTest.this.getProject());
                Intrinsics.checkNotNullExpressionValue((Object)diagnostics, (String)"allScope(project)");
                Object object = DuplicateJvmSignatureUtilKt.getJvmSignatureDiagnostics((PsiElement)psiElement, (Diagnostics)diagnostics2, (GlobalSearchScope)diagnostics);
                if (object == null) continue;
                Diagnostics diagnostics3 = object;
                object = diagnostics3.forElement((PsiElement)declaration);
                HashSet hashSet = jvmSignatureDiagnostics;
                boolean $i$f$map = false;
                void var9_10 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Diagnostic diagnostic = (Diagnostic)item$iv$iv;
                    collection2 = destination$iv$iv;
                    boolean bl = false;
                    ActualDiagnostic actualDiagnostic = new ActualDiagnostic((Diagnostic)it, null, this.getNewInferenceEnabled());
                    collection2.add(actualDiagnostic);
                }
                collection2 = (List)destination$iv$iv;
                hashSet.addAll(collection2);
            }
            return jvmSignatureDiagnostics;
        }

        @Override
        @NotNull
        public String toString() {
            String string;
            KtFile ktFile = this.getKtFile();
            return ktFile == null ? "Java file" : ((string = ktFile.getName()) == null ? "Java file" : string);
        }

        public static final /* synthetic */ Condition access$getWhatDiagnosticsToConsider$p(TestFile $this) {
            return $this.whatDiagnosticsToConsider;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=50, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u00109\u001a\u00020\u00042\u0006\u0010:\u001a\u00020;J\u000e\u0010<\u001a\u00020\u00042\u0006\u0010:\u001a\u00020;J\u001c\u0010=\u001a\b\u0012\u0004\u0012\u00020?0>2\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020\u0004R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u001d\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\nR\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001b\u0010\u0019\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001b0\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\nR\u0011\u0010$\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\nR\u000e\u0010&\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010'\u001a\u00020\bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\nR\u000e\u0010)\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010+\u001a\u00020\bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010\nR\u0014\u0010-\u001a\u00020\bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\nR\u0014\u0010/\u001a\u00020\bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010\nR\u0011\u00101\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010!R\u0011\u00103\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010!R\u0014\u00105\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u0010\u0006R\u0014\u00107\u001a\u00020\bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010\n\u00a8\u0006C"}, d2={"Lorg/jetbrains/kotlin/checkers/BaseDiagnosticsTest$Companion;", "", "()V", "CHECK_LAZY_LOG_DEFAULT", "", "getCHECK_LAZY_LOG_DEFAULT", "()Z", "CHECK_LAZY_LOG_DIRECTIVE", "", "getCHECK_LAZY_LOG_DIRECTIVE", "()Ljava/lang/String;", "CHECK_TYPE_DIRECTIVE", "getCHECK_TYPE_DIRECTIVE", "DEFAULT_DIAGNOSTIC_TESTS_FEATURES", "", "Lorg/jetbrains/kotlin/config/LanguageFeature;", "Lorg/jetbrains/kotlin/config/LanguageFeature$State;", "getDEFAULT_DIAGNOSTIC_TESTS_FEATURES", "()Ljava/util/Map;", "DIAGNOSTICS_DIRECTIVE", "getDIAGNOSTICS_DIRECTIVE", "DIAGNOSTICS_PATTERN", "Ljava/util/regex/Pattern;", "getDIAGNOSTICS_PATTERN", "()Ljava/util/regex/Pattern;", "DIAGNOSTICS_TO_INCLUDE_ANYWAY", "", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory;", "getDIAGNOSTICS_TO_INCLUDE_ANYWAY", "()Ljava/util/Set;", "DIAGNOSTIC_IN_TESTDATA_PATTERN", "Lkotlin/text/Regex;", "getDIAGNOSTIC_IN_TESTDATA_PATTERN", "()Lkotlin/text/Regex;", "EXPLICIT_FLEXIBLE_CLASS_NAME", "getEXPLICIT_FLEXIBLE_CLASS_NAME", "EXPLICIT_FLEXIBLE_PACKAGE", "getEXPLICIT_FLEXIBLE_PACKAGE", "EXPLICIT_FLEXIBLE_TYPES_DECLARATIONS", "EXPLICIT_FLEXIBLE_TYPES_DIRECTIVE", "getEXPLICIT_FLEXIBLE_TYPES_DIRECTIVE", "EXPLICIT_FLEXIBLE_TYPES_IMPORT", "HELPERS_PATH", "MARK_DYNAMIC_CALLS_DIRECTIVE", "getMARK_DYNAMIC_CALLS_DIRECTIVE", "RENDER_DIAGNOSTICS_FULL_TEXT", "getRENDER_DIAGNOSTICS_FULL_TEXT", "RENDER_DIAGNOSTICS_MESSAGES", "getRENDER_DIAGNOSTICS_MESSAGES", "SPEC_LINKED_TESTDATA_PATTERN", "getSPEC_LINKED_TESTDATA_PATTERN", "SPEC_NOT_LINED_TESTDATA_PATTERN", "getSPEC_NOT_LINED_TESTDATA_PATTERN", "USE_OLD_INFERENCE_DIAGNOSTICS_FOR_NI", "getUSE_OLD_INFERENCE_DIAGNOSTICS_FOR_NI", "WITH_NEW_INFERENCE_DIRECTIVE", "getWITH_NEW_INFERENCE_DIRECTIVE", "isJavacSkipTest", "wholeFile", "Ljava/io/File;", "isSkipJavacTest", "parseDiagnosticFilterDirective", "Lcom/intellij/openapi/util/Condition;", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "directiveMap", "Lorg/jetbrains/kotlin/test/Directives;", "allowUnderscoreUsage", "tests-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getDIAGNOSTICS_DIRECTIVE() {
            return DIAGNOSTICS_DIRECTIVE;
        }

        @NotNull
        public final Pattern getDIAGNOSTICS_PATTERN() {
            return DIAGNOSTICS_PATTERN;
        }

        @NotNull
        public final Set<DiagnosticFactory<?>> getDIAGNOSTICS_TO_INCLUDE_ANYWAY() {
            return DIAGNOSTICS_TO_INCLUDE_ANYWAY;
        }

        @NotNull
        public final Map<LanguageFeature, LanguageFeature.State> getDEFAULT_DIAGNOSTIC_TESTS_FEATURES() {
            return DEFAULT_DIAGNOSTIC_TESTS_FEATURES;
        }

        @NotNull
        public final String getCHECK_TYPE_DIRECTIVE() {
            return CHECK_TYPE_DIRECTIVE;
        }

        @NotNull
        public final String getEXPLICIT_FLEXIBLE_TYPES_DIRECTIVE() {
            return EXPLICIT_FLEXIBLE_TYPES_DIRECTIVE;
        }

        @NotNull
        public final String getEXPLICIT_FLEXIBLE_PACKAGE() {
            return EXPLICIT_FLEXIBLE_PACKAGE;
        }

        @NotNull
        public final String getEXPLICIT_FLEXIBLE_CLASS_NAME() {
            return EXPLICIT_FLEXIBLE_CLASS_NAME;
        }

        @NotNull
        public final String getCHECK_LAZY_LOG_DIRECTIVE() {
            return CHECK_LAZY_LOG_DIRECTIVE;
        }

        public final boolean getCHECK_LAZY_LOG_DEFAULT() {
            return CHECK_LAZY_LOG_DEFAULT;
        }

        @NotNull
        public final String getMARK_DYNAMIC_CALLS_DIRECTIVE() {
            return MARK_DYNAMIC_CALLS_DIRECTIVE;
        }

        @NotNull
        public final String getWITH_NEW_INFERENCE_DIRECTIVE() {
            return WITH_NEW_INFERENCE_DIRECTIVE;
        }

        public final boolean getUSE_OLD_INFERENCE_DIAGNOSTICS_FOR_NI() {
            return USE_OLD_INFERENCE_DIAGNOSTICS_FOR_NI;
        }

        @NotNull
        public final String getRENDER_DIAGNOSTICS_MESSAGES() {
            return RENDER_DIAGNOSTICS_MESSAGES;
        }

        @NotNull
        public final String getRENDER_DIAGNOSTICS_FULL_TEXT() {
            return RENDER_DIAGNOSTICS_FULL_TEXT;
        }

        @NotNull
        public final Regex getDIAGNOSTIC_IN_TESTDATA_PATTERN() {
            return DIAGNOSTIC_IN_TESTDATA_PATTERN;
        }

        @NotNull
        public final Regex getSPEC_LINKED_TESTDATA_PATTERN() {
            return SPEC_LINKED_TESTDATA_PATTERN;
        }

        @NotNull
        public final Regex getSPEC_NOT_LINED_TESTDATA_PATTERN() {
            return SPEC_NOT_LINED_TESTDATA_PATTERN;
        }

        @NotNull
        public final Condition<Diagnostic> parseDiagnosticFilterDirective(@NotNull Directives directiveMap, boolean allowUnderscoreUsage) {
            Condition initialCondition2;
            Condition condition;
            Condition condition2;
            Intrinsics.checkNotNullParameter((Object)directiveMap, (String)"directiveMap");
            String directives = directiveMap.get(this.getDIAGNOSTICS_DIRECTIVE());
            if (allowUnderscoreUsage) {
                condition2 = parseDiagnosticFilterDirective.initialCondition.1.INSTANCE;
            } else {
                condition = Conditions.alwaysTrue();
                Intrinsics.checkNotNullExpressionValue((Object)condition, (String)"alwaysTrue()");
                condition2 = initialCondition2 = condition;
            }
            if (directives == null) {
                if (directiveMap.contains("API_VERSION")) {
                    condition = Conditions.and((Condition)initialCondition2, (Condition)parseDiagnosticFilterDirective.1.INSTANCE);
                    Intrinsics.checkNotNullExpressionValue((Object)condition, (String)"and(initialCondition, Condition { diagnostic ->\n                        diagnostic.factory !== Errors.NEWER_VERSION_IN_SINCE_KOTLIN\n                    })");
                    return condition;
                }
                return initialCondition2;
            }
            Condition condition3 = initialCondition2;
            Matcher matcher = this.getDIAGNOSTICS_PATTERN().matcher(directives);
            if (!matcher.find()) {
                Assert.fail((String)("Wrong syntax in the '// !" + this.getDIAGNOSTICS_DIRECTIVE() + ": ...' directive:\nfound: '" + directives + "'\nMust be '([+-!]DIAGNOSTIC_FACTORY_NAME|ERROR|WARNING|INFO)+'\nwhere '+' means 'include'\n      '-' means 'exclude'\n      '!' means 'exclude everything but this'\ndirectives are applied in the order of appearance, i.e. !FOO +BAR means include only FOO and BAR"));
            }
            boolean first = true;
            do {
                block20: {
                    String operation = matcher.group(1);
                    String name = matcher.group(2);
                    Object object = new String[]{"ERROR", "WARNING", "INFO"};
                    Condition newCondition2 = SetsKt.setOf((Object[])object).contains(name) ? (Condition)new Condition<Diagnostic>(name){
                        final /* synthetic */ String $name;
                        {
                            this.$name = $name;
                        }

                        public final boolean value(Diagnostic diagnostic) {
                            Severity severity = diagnostic.getSeverity();
                            String string = this.$name;
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
                            return severity == Severity.valueOf((String)string);
                        }
                    } : (Condition)new Condition<Diagnostic>(name){
                        final /* synthetic */ String $name;
                        {
                            this.$name = $name;
                        }

                        public final boolean value(Diagnostic diagnostic) {
                            return Intrinsics.areEqual((Object)this.$name, (Object)diagnostic.getFactory().getName());
                        }
                    };
                    object = operation;
                    if (object == null) break block20;
                    int n = -1;
                    switch (((String)object).hashCode()) {
                        case 33: {
                            if (((String)object).equals("!")) {
                                n = 1;
                            }
                            break;
                        }
                        case 43: {
                            if (((String)object).equals("+")) {
                                n = 2;
                            }
                            break;
                        }
                        case 45: {
                            if (((String)object).equals("-")) {
                                n = 3;
                            }
                            break;
                        }
                    }
                    switch (n) {
                        case 1: {
                            if (!first) {
                                Assert.fail((String)('\'' + operation + name + "' appears in a position rather than the first one, which effectively cancels all the previous filters in this directive"));
                            }
                            condition3 = newCondition2;
                            break;
                        }
                        case 2: {
                            Condition condition4 = Conditions.or((Condition)condition3, (Condition)newCondition2);
                            Intrinsics.checkNotNullExpressionValue((Object)condition4, (String)"or(condition, newCondition)");
                            condition3 = condition4;
                            break;
                        }
                        case 3: {
                            Condition condition4 = Conditions.and((Condition)condition3, (Condition)Conditions.not((Condition)newCondition2));
                            Intrinsics.checkNotNullExpressionValue((Object)condition4, (String)"and(condition, Conditions.not(newCondition))");
                            condition3 = condition4;
                        }
                    }
                }
                first = false;
            } while (matcher.find());
            Condition condition5 = Conditions.or((Condition)condition3, (Condition)parseDiagnosticFilterDirective.2.INSTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)condition5, (String)"or(\n                condition,\n                Condition { diagnostic -> diagnostic.factory in DIAGNOSTICS_TO_INCLUDE_ANYWAY }\n            )");
            return condition5;
        }

        public final boolean isJavacSkipTest(@NotNull File wholeFile) {
            Intrinsics.checkNotNullParameter((Object)wholeFile, (String)"wholeFile");
            String testDataFileText = FilesKt.readText$default((File)wholeFile, null, (int)1, null);
            return InTextDirectivesUtils.isDirectiveDefined((String)testDataFileText, (String)"// JAVAC_SKIP");
        }

        public final boolean isSkipJavacTest(@NotNull File wholeFile) {
            Intrinsics.checkNotNullParameter((Object)wholeFile, (String)"wholeFile");
            String testDataFileText = FilesKt.readText$default((File)wholeFile, null, (int)1, null);
            return InTextDirectivesUtils.isDirectiveDefined((String)testDataFileText, (String)"// SKIP_JAVAC");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

