/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cfg;

import com.google.common.collect.Lists;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javaslang.Tuple2;
import javaslang.collection.Map;
import kotlin.jvm.functions.Function3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cfg.AbstractPseudocodeTest;
import org.jetbrains.kotlin.cfg.ReadOnlyControlFlowInfo;
import org.jetbrains.kotlin.cfg.pseudocode.PseudocodeImpl;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.Instruction;
import org.jetbrains.kotlin.cfg.pseudocodeTraverser.Edges;
import org.jetbrains.kotlin.cfg.variable.PseudocodeVariablesData;
import org.jetbrains.kotlin.cfg.variable.VariableInitReadOnlyControlFlowInfo;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.resolve.BindingContext;

public abstract class AbstractDataFlowTest
extends AbstractPseudocodeTest {
    @Override
    public void dumpInstructions(@NotNull PseudocodeImpl pseudocode, @NotNull StringBuilder out, @NotNull BindingContext bindingContext) {
        if (pseudocode == null) {
            AbstractDataFlowTest.$$$reportNull$$$0(0);
        }
        if (out == null) {
            AbstractDataFlowTest.$$$reportNull$$$0(1);
        }
        if (bindingContext == null) {
            AbstractDataFlowTest.$$$reportNull$$$0(2);
        }
        PseudocodeVariablesData pseudocodeVariablesData = new PseudocodeVariablesData(pseudocode.getRootPseudocode(), bindingContext);
        java.util.Map variableInitializers = pseudocodeVariablesData.getVariableInitializers();
        java.util.Map useStatusData = pseudocodeVariablesData.getVariableUseStatusData();
        String initPrefix = "    INIT:";
        String usePrefix = "    USE:";
        int initializersColumnWidth = AbstractDataFlowTest.countDataColumnWidth(initPrefix, pseudocode.getInstructionsIncludingDeadCode(), variableInitializers, pseudocodeVariablesData);
        this.dumpInstructions(pseudocode, out, (Function3<Instruction, Instruction, Instruction, String>)((Function3)(instruction, next, prev) -> {
            StringBuilder result = new StringBuilder();
            Edges initializersEdges = (Edges)variableInitializers.get(instruction);
            Edges previousInitializersEdges = (Edges)variableInitializers.get(prev);
            String initializersData = "";
            if (initializersEdges != null && !initializersEdges.equals((Object)previousInitializersEdges)) {
                initializersData = AbstractDataFlowTest.dumpEdgesData(initPrefix, initializersEdges, pseudocodeVariablesData);
            }
            result.append(String.format("%1$-" + initializersColumnWidth + "s", initializersData));
            Edges useStatusEdges = (Edges)useStatusData.get(instruction);
            Edges nextUseStatusEdges = (Edges)useStatusData.get(next);
            if (useStatusEdges != null && !useStatusEdges.equals((Object)nextUseStatusEdges)) {
                result.append(AbstractDataFlowTest.dumpEdgesData(usePrefix, useStatusEdges, pseudocodeVariablesData));
            }
            return result.toString();
        }));
    }

    private static int countDataColumnWidth(@NotNull String prefix, @NotNull List<Instruction> instructions, @NotNull java.util.Map<Instruction, Edges<VariableInitReadOnlyControlFlowInfo>> data, @NotNull PseudocodeVariablesData variablesData) {
        if (prefix == null) {
            AbstractDataFlowTest.$$$reportNull$$$0(3);
        }
        if (instructions == null) {
            AbstractDataFlowTest.$$$reportNull$$$0(4);
        }
        if (data == null) {
            AbstractDataFlowTest.$$$reportNull$$$0(5);
        }
        if (variablesData == null) {
            AbstractDataFlowTest.$$$reportNull$$$0(6);
        }
        int maxWidth = 0;
        for (Instruction instruction : instructions) {
            int length;
            Edges<VariableInitReadOnlyControlFlowInfo> edges = data.get(instruction);
            if (edges == null || maxWidth >= (length = AbstractDataFlowTest.dumpEdgesData(prefix, edges, variablesData).length())) continue;
            maxWidth = length;
        }
        return maxWidth;
    }

    @NotNull
    private static <S, I extends ReadOnlyControlFlowInfo<VariableDescriptor, S>> String dumpEdgesData(String prefix, @NotNull Edges<I> edges, @NotNull PseudocodeVariablesData variablesData) {
        if (edges == null) {
            AbstractDataFlowTest.$$$reportNull$$$0(7);
        }
        if (variablesData == null) {
            AbstractDataFlowTest.$$$reportNull$$$0(8);
        }
        String string = prefix + " in: " + AbstractDataFlowTest.renderVariableMap(((ReadOnlyControlFlowInfo)edges.getIncoming()).asMap(), variablesData) + " out: " + AbstractDataFlowTest.renderVariableMap(((ReadOnlyControlFlowInfo)edges.getOutgoing()).asMap(), variablesData);
        if (string == null) {
            AbstractDataFlowTest.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static <S> String renderVariableMap(Map<VariableDescriptor, S> map, PseudocodeVariablesData variablesData) {
        ArrayList result = Lists.newArrayList();
        for (Tuple2 entry : map) {
            VariableDescriptor variable = (VariableDescriptor)entry._1;
            Object state = entry._2;
            if (variablesData.isVariableWithTrivialInitializer(variable)) continue;
            result.add(variable.getName() + "=" + state);
        }
        Collections.sort(result);
        return "{" + StringUtil.join((Collection)result, (String)", ") + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pseudocode";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bindingContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instructions";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variablesData";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edges";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/cfg/AbstractDataFlowTest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/cfg/AbstractDataFlowTest";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpEdgesData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "dumpInstructions";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "countDataColumnWidth";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "dumpEdgesData";
                break;
            }
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

