/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test;

import junit.framework.TestCase;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.test.AutoMuteKt;
import org.jetbrains.kotlin.test.mutes.MutedSetKt;
import org.jetbrains.kotlin.test.mutes.MutedTest;
import org.jetbrains.kotlin.test.mutes.MutedTestKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001e\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u001c\u0010\b\u001a\u00020\u00012\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\u0007H\u0002\u001a\u001c\u0010\f\u001a\u00020\u00012\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\u0007H\u0002\u001a\u0012\u0010\r\u001a\u00020\u00012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002\u001a\u001c\u0010\u0010\u001a\u00020\u00072\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\u0007H\u0002\u001a\u001c\u0010\u0006\u001a\u00020\u00072\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\u0007H\u0002\u001a&\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00052\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u0000\u001a\u0018\u0010\u0015\u001a\u00020\u0003*\u00020\u00142\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"SKIP_MUTED_TESTS", "", "invertMutedTestResultWithLog", "", "f", "Lkotlin/Function0;", "testKey", "", "isMutedInDatabase", "testClass", "Ljava/lang/Class;", "methodKey", "isMutedInDatabaseWithLog", "isPresentedInDatabaseWithoutFailMarker", "mutedTest", "Lorg/jetbrains/kotlin/test/mutes/MutedTest;", "mutedMessage", "klass", "wrapWithMuteInDatabase", "testCase", "Ljunit/framework/TestCase;", "runTest", "test", "tests-common"})
public final class MuteWithDatabaseKt {
    private static final boolean SKIP_MUTED_TESTS = Boolean.getBoolean("org.jetbrains.kotlin.skip.muted.tests");

    private static final boolean isMutedInDatabase(Class<?> testClass, String methodKey) {
        MutedTest mutedTest = MutedSetKt.getMutedSet().mutedTest(testClass, methodKey);
        return SKIP_MUTED_TESTS && MuteWithDatabaseKt.isPresentedInDatabaseWithoutFailMarker(mutedTest);
    }

    private static final boolean isMutedInDatabaseWithLog(Class<?> testClass, String methodKey) {
        boolean mutedInDatabase = MuteWithDatabaseKt.isMutedInDatabase(testClass, methodKey);
        if (mutedInDatabase) {
            System.err.println(MuteWithDatabaseKt.mutedMessage(testClass, methodKey));
        }
        return mutedInDatabase;
    }

    private static final boolean isPresentedInDatabaseWithoutFailMarker(MutedTest mutedTest) {
        return mutedTest != null && !mutedTest.getHasFailFile();
    }

    @Nullable
    public static final Function0<Unit> wrapWithMuteInDatabase(@NotNull TestCase testCase, @NotNull Function0<Unit> f) {
        Intrinsics.checkNotNullParameter((Object)testCase, (String)"testCase");
        Intrinsics.checkNotNullParameter(f, (String)"f");
        Class<TestCase> testClass = testCase.getClass();
        String methodKey = testCase.getName();
        Intrinsics.checkNotNullExpressionValue((Object)methodKey, (String)"methodKey");
        MutedTest mutedTest = MutedTestKt.getMutedTest(testClass, (String)methodKey);
        String testKey = MuteWithDatabaseKt.testKey(testClass, methodKey);
        if (MuteWithDatabaseKt.isMutedInDatabase(testClass, methodKey)) {
            return (Function0)new Function0<Unit>(testClass, methodKey){
                final /* synthetic */ Class<TestCase> $testClass;
                final /* synthetic */ String $methodKey;
                {
                    this.$testClass = $testClass;
                    this.$methodKey = $methodKey;
                    super(0);
                }

                public final void invoke() {
                    String string = this.$methodKey;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"methodKey");
                    System.err.println(MuteWithDatabaseKt.access$mutedMessage(this.$testClass, string));
                }
            };
        }
        if (MuteWithDatabaseKt.isPresentedInDatabaseWithoutFailMarker(mutedTest)) {
            MutedTest mutedTest2 = mutedTest;
            if (Intrinsics.areEqual((Object)(mutedTest2 == null ? null : Boolean.valueOf(mutedTest2.isFlaky())), (Object)true)) {
                return f;
            }
            return (Function0)new Function0<Unit>(f, testKey){
                final /* synthetic */ Function0<Unit> $f;
                final /* synthetic */ String $testKey;
                {
                    this.$f = $f;
                    this.$testKey = $testKey;
                    super(0);
                }

                public final void invoke() {
                    MuteWithDatabaseKt.access$invertMutedTestResultWithLog(this.$f, this.$testKey);
                }
            };
        }
        return AutoMuteKt.wrapWithAutoMute(f, testKey);
    }

    private static final String mutedMessage(Class<?> klass, String methodKey) {
        return Intrinsics.stringPlus((String)"MUTED TEST: ", (Object)MuteWithDatabaseKt.testKey(klass, methodKey));
    }

    private static final String testKey(Class<?> klass, String methodKey) {
        return klass.getCanonicalName() + '.' + methodKey;
    }

    private static final void invertMutedTestResultWithLog(Function0<Unit> f, String testKey) {
        boolean isTestGreen = true;
        try {
            f.invoke();
        }
        catch (Throwable e) {
            String string = Intrinsics.stringPlus((String)"MUTED TEST STILL FAILS: ", (Object)testKey);
            boolean bl = false;
            System.out.println((Object)string);
            isTestGreen = false;
        }
        if (isTestGreen) {
            System.err.println(Intrinsics.stringPlus((String)"SUCCESS RESULT OF MUTED TEST: ", (Object)testKey));
            throw new Exception("Muted non-flaky test " + testKey + " finished successfully. Please remove it from csv file");
        }
    }

    public static final void runTest(@NotNull TestCase $this$runTest, @NotNull Function0<Unit> test2) {
        Intrinsics.checkNotNullParameter((Object)$this$runTest, (String)"<this>");
        Intrinsics.checkNotNullParameter(test2, (String)"test");
        Function0<Unit> function0 = MuteWithDatabaseKt.wrapWithMuteInDatabase($this$runTest, test2);
        (function0 == null ? test2 : function0).invoke();
    }

    public static final /* synthetic */ boolean access$isMutedInDatabaseWithLog(Class testClass, String methodKey) {
        return MuteWithDatabaseKt.isMutedInDatabaseWithLog(testClass, methodKey);
    }

    public static final /* synthetic */ String access$testKey(Class klass, String methodKey) {
        return MuteWithDatabaseKt.testKey(klass, methodKey);
    }

    public static final /* synthetic */ boolean access$isPresentedInDatabaseWithoutFailMarker(MutedTest mutedTest) {
        return MuteWithDatabaseKt.isPresentedInDatabaseWithoutFailMarker(mutedTest);
    }

    public static final /* synthetic */ void access$invertMutedTestResultWithLog(Function0 f, String testKey) {
        MuteWithDatabaseKt.invertMutedTestResultWithLog((Function0<Unit>)f, testKey);
    }

    public static final /* synthetic */ String access$mutedMessage(Class klass, String methodKey) {
        return MuteWithDatabaseKt.mutedMessage(klass, methodKey);
    }
}

