/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.test.AssertionsKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.CLITool;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.jvm.K2JVMCompiler;
import org.jetbrains.kotlin.test.CompilerTestUtil;
import org.jetbrains.kotlin.test.KotlinTestUtils;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t2\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\tH\u0007J.\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\r0\f2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\tH\u0007J\"\u0010\u0011\u001a\u00020\u00122\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\tH\u0007\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/test/CompilerTestUtil;", "", "()V", "compileJvmLibrary", "Ljava/io/File;", "src", "libraryName", "", "extraOptions", "", "extraClasspath", "executeCompiler", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "compiler", "Lorg/jetbrains/kotlin/cli/common/CLITool;", "args", "executeCompilerAssertSuccessful", "", "tests-common"})
public final class CompilerTestUtil {
    @NotNull
    public static final CompilerTestUtil INSTANCE = new CompilerTestUtil();

    private CompilerTestUtil() {
    }

    @JvmStatic
    public static final void executeCompilerAssertSuccessful(@NotNull CLITool<?> compiler, @NotNull List<String> args2) {
        Intrinsics.checkNotNullParameter(compiler, (String)"compiler");
        Intrinsics.checkNotNullParameter(args2, (String)"args");
        Pair<String, ExitCode> pair = CompilerTestUtil.executeCompiler(compiler, args2);
        String output = (String)pair.component1();
        ExitCode exitCode = (ExitCode)pair.component2();
        AssertionsKt.assertEquals((Object)ExitCode.OK, (Object)exitCode, (String)output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @NotNull
    public static final Pair<String, ExitCode> executeCompiler(@NotNull CLITool<?> compiler, @NotNull List<String> args2) {
        Intrinsics.checkNotNullParameter(compiler, (String)"compiler");
        Intrinsics.checkNotNullParameter(args2, (String)"args");
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        PrintStream origErr = System.err;
        try {
            System.setErr(new PrintStream(bytes));
            Collection $this$toTypedArray$iv = args2;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            ExitCode exitCode = CLITool.Companion.doMainNoExit$default((CLITool.Companion)CLITool.Companion, compiler, (String[])stringArray, null, (int)4, null);
            Object object = bytes.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"bytes.toByteArray()");
            boolean bl = false;
            object = new Pair((Object)new String((byte[])object, Charsets.UTF_8), (Object)exitCode);
            return object;
        }
        finally {
            System.setErr(origErr);
        }
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final File compileJvmLibrary(@NotNull File src, @NotNull String libraryName, @NotNull List<String> extraOptions, @NotNull List<? extends File> extraClasspath) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)libraryName, (String)"libraryName");
        Intrinsics.checkNotNullParameter(extraOptions, (String)"extraOptions");
        Intrinsics.checkNotNullParameter(extraClasspath, (String)"extraClasspath");
        File destination = new File(KotlinTestUtils.tmpDir("testLibrary"), Intrinsics.stringPlus((String)libraryName, (Object)".jar"));
        boolean bl = false;
        List list = new ArrayList();
        boolean bl2 = false;
        boolean bl3 = false;
        List $this$compileJvmLibrary_u24lambda_u2d0 = list;
        boolean bl4 = false;
        Object object = src.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"src.path");
        $this$compileJvmLibrary_u24lambda_u2d0.add(object);
        $this$compileJvmLibrary_u24lambda_u2d0.add("-d");
        object = destination.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"destination.path");
        $this$compileJvmLibrary_u24lambda_u2d0.add(object);
        object = extraClasspath;
        boolean bl5 = false;
        if (!object.isEmpty()) {
            $this$compileJvmLibrary_u24lambda_u2d0.add("-cp");
            $this$compileJvmLibrary_u24lambda_u2d0.add(CollectionsKt.joinToString$default((Iterable)extraClasspath, (CharSequence)":", null, null, (int)0, null, (Function1)compileJvmLibrary.args.1.1.INSTANCE, (int)30, null));
        }
        $this$compileJvmLibrary_u24lambda_u2d0.addAll((Collection)extraOptions);
        List args2 = list;
        CompilerTestUtil.executeCompilerAssertSuccessful((CLITool)new K2JVMCompiler(), args2);
        return destination;
    }

    public static /* synthetic */ File compileJvmLibrary$default(File file, String string, List list, List list2, int n, Object object) {
        if ((n & 2) != 0) {
            string = "library";
        }
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        return CompilerTestUtil.compileJvmLibrary(file, string, list, list2);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final File compileJvmLibrary(@NotNull File src, @NotNull String libraryName, @NotNull List<String> extraOptions) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)libraryName, (String)"libraryName");
        Intrinsics.checkNotNullParameter(extraOptions, (String)"extraOptions");
        return CompilerTestUtil.compileJvmLibrary$default(src, libraryName, extraOptions, null, 8, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final File compileJvmLibrary(@NotNull File src, @NotNull String libraryName) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)libraryName, (String)"libraryName");
        return CompilerTestUtil.compileJvmLibrary$default(src, libraryName, null, null, 12, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final File compileJvmLibrary(@NotNull File src) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        return CompilerTestUtil.compileJvmLibrary$default(src, null, null, null, 14, null);
    }
}

