/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.codegen.ClassFileFactory;
import org.jetbrains.kotlin.codegen.CodegenTestFiles;
import org.jetbrains.kotlin.codegen.GenerationUtils;
import org.jetbrains.kotlin.codegen.forTestCompile.ForTestCompileRuntime;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.utils.ExceptionUtilsKt;
import org.jetbrains.kotlin.utils.StringsKt;
import org.junit.Assert;

public class CodegenTestUtil {
    private CodegenTestUtil() {
    }

    @NotNull
    public static ClassFileFactory generateFiles(@NotNull KotlinCoreEnvironment environment, @NotNull CodegenTestFiles files) {
        if (environment == null) {
            CodegenTestUtil.$$$reportNull$$$0(0);
        }
        if (files == null) {
            CodegenTestUtil.$$$reportNull$$$0(1);
        }
        ClassFileFactory classFileFactory = GenerationUtils.compileFiles(files.getPsiFiles(), environment).getFactory();
        if (classFileFactory == null) {
            CodegenTestUtil.$$$reportNull$$$0(2);
        }
        return classFileFactory;
    }

    public static void assertThrows(@NotNull Method foo, @NotNull Class<? extends Throwable> exceptionClass, @Nullable Object instance, Object ... args2) throws IllegalAccessException {
        if (foo == null) {
            CodegenTestUtil.$$$reportNull$$$0(3);
        }
        if (exceptionClass == null) {
            CodegenTestUtil.$$$reportNull$$$0(4);
        }
        if (args2 == null) {
            CodegenTestUtil.$$$reportNull$$$0(5);
        }
        boolean caught = false;
        try {
            foo.invoke(instance, args2);
        }
        catch (InvocationTargetException ex) {
            caught = exceptionClass.isInstance(ex.getTargetException());
        }
        Assert.assertTrue((boolean)caught);
    }

    @NotNull
    public static Method findDeclaredMethodByName(@NotNull Class<?> aClass, @NotNull String name) {
        Method result;
        if (aClass == null) {
            CodegenTestUtil.$$$reportNull$$$0(6);
        }
        if (name == null) {
            CodegenTestUtil.$$$reportNull$$$0(7);
        }
        if ((result = CodegenTestUtil.findDeclaredMethodByNameOrNull(aClass, name)) == null) {
            throw new AssertionError((Object)("Method " + name + " is not found in " + aClass));
        }
        Method method = result;
        if (method == null) {
            CodegenTestUtil.$$$reportNull$$$0(8);
        }
        return method;
    }

    public static Method findDeclaredMethodByNameOrNull(@NotNull Class<?> aClass, @NotNull String name) {
        if (aClass == null) {
            CodegenTestUtil.$$$reportNull$$$0(9);
        }
        if (name == null) {
            CodegenTestUtil.$$$reportNull$$$0(10);
        }
        for (Method method : aClass.getDeclaredMethods()) {
            if (!method.getName().equals(name)) continue;
            return method;
        }
        return null;
    }

    @NotNull
    public static File compileJava(@NotNull List<String> fileNames, @NotNull List<String> additionalClasspath, @NotNull List<String> additionalOptions) {
        File file;
        if (fileNames == null) {
            CodegenTestUtil.$$$reportNull$$$0(11);
        }
        if (additionalClasspath == null) {
            CodegenTestUtil.$$$reportNull$$$0(12);
        }
        if (additionalOptions == null) {
            CodegenTestUtil.$$$reportNull$$$0(13);
        }
        try {
            File directory = KotlinTestUtils.tmpDir("java-classes");
            CodegenTestUtil.compileJava(fileNames, additionalClasspath, additionalOptions, directory);
            file = directory;
        }
        catch (IOException e) {
            throw ExceptionUtilsKt.rethrow((Throwable)e);
        }
        if (file == null) {
            CodegenTestUtil.$$$reportNull$$$0(14);
        }
        return file;
    }

    public static void compileJava(@NotNull List<String> fileNames, @NotNull List<String> additionalClasspath, @NotNull List<String> additionalOptions, @NotNull File outDirectory) {
        if (fileNames == null) {
            CodegenTestUtil.$$$reportNull$$$0(15);
        }
        if (additionalClasspath == null) {
            CodegenTestUtil.$$$reportNull$$$0(16);
        }
        if (additionalOptions == null) {
            CodegenTestUtil.$$$reportNull$$$0(17);
        }
        if (outDirectory == null) {
            CodegenTestUtil.$$$reportNull$$$0(18);
        }
        try {
            List<String> options = CodegenTestUtil.prepareJavacOptions(additionalClasspath, additionalOptions, outDirectory);
            KotlinTestUtils.compileJavaFiles(CollectionsKt.map(fileNames, File::new), options);
        }
        catch (IOException e) {
            throw ExceptionUtilsKt.rethrow((Throwable)e);
        }
    }

    @NotNull
    public static List<String> prepareJavacOptions(@NotNull List<String> additionalClasspath, @NotNull List<String> additionalOptions, @NotNull File outDirectory) {
        if (additionalClasspath == null) {
            CodegenTestUtil.$$$reportNull$$$0(19);
        }
        if (additionalOptions == null) {
            CodegenTestUtil.$$$reportNull$$$0(20);
        }
        if (outDirectory == null) {
            CodegenTestUtil.$$$reportNull$$$0(21);
        }
        ArrayList<String> classpath = new ArrayList<String>();
        classpath.add(ForTestCompileRuntime.runtimeJarForTests().getPath());
        classpath.add(ForTestCompileRuntime.reflectJarForTests().getPath());
        classpath.add(KotlinTestUtils.getAnnotationsJar().getPath());
        classpath.addAll(additionalClasspath);
        ArrayList<String> options = new ArrayList<String>(Arrays.asList("-classpath", StringsKt.join(classpath, (String)File.pathSeparator), "-d", outDirectory.getPath()));
        options.addAll(additionalOptions);
        ArrayList<String> arrayList = options;
        if (arrayList == null) {
            CodegenTestUtil.$$$reportNull$$$0(22);
        }
        return arrayList;
    }

    @NotNull
    public static Method findTheOnlyMethod(@NotNull Class<?> aClass) {
        if (aClass == null) {
            CodegenTestUtil.$$$reportNull$$$0(23);
        }
        Method r = null;
        for (Method method : aClass.getMethods()) {
            if (method.getDeclaringClass().equals(Object.class)) continue;
            if (r != null) {
                throw new AssertionError((Object)("More than one public method in class " + aClass));
            }
            r = method;
        }
        if (r == null) {
            throw new AssertionError((Object)("No public methods in class " + aClass));
        }
        Method method = r;
        if (method == null) {
            CodegenTestUtil.$$$reportNull$$$0(24);
        }
        return method;
    }

    @Nullable
    public static Object getAnnotationAttribute(@NotNull Object annotation, @NotNull String name) {
        if (annotation == null) {
            CodegenTestUtil.$$$reportNull$$$0(25);
        }
        if (name == null) {
            CodegenTestUtil.$$$reportNull$$$0(26);
        }
        try {
            return annotation.getClass().getMethod(name, new Class[0]).invoke(annotation, new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionUtilsKt.rethrow((Throwable)e);
        }
    }

    @NotNull
    public static List<String> findJavaSourcesInDirectory(@NotNull File directory) {
        if (directory == null) {
            CodegenTestUtil.$$$reportNull$$$0(27);
        }
        ArrayList<String> javaFilePaths = new ArrayList<String>(1);
        FileUtil.processFilesRecursively((File)directory, file -> {
            if (file.isFile() && FilesKt.getExtension((File)file).equals("java")) {
                javaFilePaths.add(file.getPath());
            }
            return true;
        });
        ArrayList<String> arrayList = javaFilePaths;
        if (arrayList == null) {
            CodegenTestUtil.$$$reportNull$$$0(28);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 8: 
            case 14: 
            case 22: 
            case 24: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 8: 
            case 14: 
            case 22: 
            case 24: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 2: 
            case 8: 
            case 14: 
            case 22: 
            case 24: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/CodegenTestUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foo";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionClass";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 6: 
            case 9: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 7: 
            case 10: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNames";
                break;
            }
            case 12: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalClasspath";
                break;
            }
            case 13: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalOptions";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outDirectory";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/CodegenTestUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "generateFiles";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findDeclaredMethodByName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "compileJava";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareJavacOptions";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "findTheOnlyMethod";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "findJavaSourcesInDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "generateFiles";
                break;
            }
            case 2: 
            case 8: 
            case 14: 
            case 22: 
            case 24: 
            case 28: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "assertThrows";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findDeclaredMethodByName";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findDeclaredMethodByNameOrNull";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "compileJava";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "prepareJavacOptions";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findTheOnlyMethod";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationAttribute";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "findJavaSourcesInDirectory";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 8: 
            case 14: 
            case 22: 
            case 24: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

