/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import java.util.List;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.TestsRuntimeError;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.codegen.BytecodeListingTextCollectingVisitor;
import org.jetbrains.kotlin.codegen.CodegenTestCase;
import org.jetbrains.kotlin.codegen.GeneratedClassLoader;
import org.jetbrains.kotlin.codegen.TestUtilsKt;
import org.jetbrains.kotlin.codegen.ir.AbstractFirBlackBoxCodegenTest;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.test.InTextDirectivesUtils;
import org.jetbrains.kotlin.test.KotlinBaseTest;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.clientserver.TestProcessServerKt;
import org.jetbrains.kotlin.utils.ExceptionUtilsKt;

public abstract class AbstractBlackBoxCodegenTest
extends CodegenTestCase {
    protected void doMultiFileTest(@NotNull File wholeFile, @NotNull List<KotlinBaseTest.TestFile> files, boolean unexpectedBehaviour) throws Exception {
        boolean isIgnored;
        if (wholeFile == null) {
            AbstractBlackBoxCodegenTest.$$$reportNull$$$0(0);
        }
        if (files == null) {
            AbstractBlackBoxCodegenTest.$$$reportNull$$$0(1);
        }
        this.compile(files, !(isIgnored = this.isIgnoredTarget(wholeFile)), false);
        try {
            this.blackBox(!isIgnored, unexpectedBehaviour);
        }
        catch (Throwable t) {
            if (!isIgnored) {
                try {
                    this.doBytecodeListingTest(wholeFile);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            throw new TestsRuntimeError(t);
        }
        this.doBytecodeListingTest(wholeFile);
    }

    @Override
    protected void doMultiFileTest(@NotNull File wholeFile, @NotNull List<? extends KotlinBaseTest.TestFile> files) throws Exception {
        if (wholeFile == null) {
            AbstractBlackBoxCodegenTest.$$$reportNull$$$0(2);
        }
        if (files == null) {
            AbstractBlackBoxCodegenTest.$$$reportNull$$$0(3);
        }
        this.doMultiFileTest(wholeFile, files, false);
    }

    private void doBytecodeListingTest(@NotNull File wholeFile) throws Exception {
        if (wholeFile == null) {
            AbstractBlackBoxCodegenTest.$$$reportNull$$$0(4);
        }
        if (!InTextDirectivesUtils.isDirectiveDefined(FileUtil.loadFile((File)wholeFile), "CHECK_BYTECODE_LISTING")) {
            return;
        }
        String suffix = (this.coroutinesPackage.equals(StandardNames.COROUTINES_PACKAGE_FQ_NAME_EXPERIMENTAL.asString()) || this.coroutinesPackage.isEmpty()) && InTextDirectivesUtils.isDirectiveDefined(FileUtil.loadFile((File)wholeFile), "COMMON_COROUTINES_TEST") ? "_1_2" : (this.getBackend().isIR() ? "_ir" : "");
        File expectedFile = new File(wholeFile.getParent(), FilesKt.getNameWithoutExtension((File)wholeFile) + suffix + ".txt");
        String text = BytecodeListingTextCollectingVisitor.Companion.getText(this.classFileFactory, new BytecodeListingTextCollectingVisitor.Filter(){

            @Override
            public boolean shouldWriteClass(int access, @NotNull String name) {
                if (name == null) {
                    1.$$$reportNull$$$0(0);
                }
                return !name.startsWith("helpers/");
            }

            @Override
            public boolean shouldWriteMethod(int access, @NotNull String name, @NotNull String desc) {
                if (name == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (desc == null) {
                    1.$$$reportNull$$$0(2);
                }
                return true;
            }

            @Override
            public boolean shouldWriteField(int access, @NotNull String name, @NotNull String desc) {
                if (name == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (desc == null) {
                    1.$$$reportNull$$$0(4);
                }
                return true;
            }

            @Override
            public boolean shouldWriteInnerClass(@NotNull String name) {
                if (name == null) {
                    1.$$$reportNull$$$0(5);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                    case 2: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "desc";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/kotlin/codegen/AbstractBlackBoxCodegenTest$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "shouldWriteClass";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "shouldWriteMethod";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "shouldWriteField";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[2] = "shouldWriteInnerClass";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        KotlinTestUtils.assertEqualsToFile(expectedFile, text, (Function1<String, String>)((Function1)s -> s.replace("COROUTINES_PACKAGE", this.coroutinesPackage)));
    }

    protected void blackBox(boolean reportProblems, boolean unexpectedBehaviour) {
        GeneratedClassLoader generatedClassLoader = this.generateAndCreateClassLoader(reportProblems);
        for (KtFile firstFile : this.myFiles.getPsiFiles()) {
            String className = AbstractBlackBoxCodegenTest.getFacadeFqName(firstFile);
            if (className == null) continue;
            Class aClass = TestProcessServerKt.getGeneratedClass((ClassLoader)generatedClassLoader, (String)className);
            try {
                Method method = TestProcessServerKt.getBoxMethodOrNull((Class)aClass);
                if (method == null) continue;
                this.callBoxMethodAndCheckResult((URLClassLoader)generatedClassLoader, aClass, method, unexpectedBehaviour);
                return;
            }
            catch (Throwable e) {
                if (reportProblems) {
                    System.out.println(this.generateToText());
                }
                throw ExceptionUtilsKt.rethrow((Throwable)e);
            }
            finally {
                TestUtilsKt.clearReflectionCache((ClassLoader)generatedClassLoader);
            }
        }
        AbstractBlackBoxCodegenTest.fail((String)"Can't find box method!");
    }

    protected void blackBox(boolean reportProblems) {
        this.blackBox(reportProblems, false);
    }

    @Nullable
    protected static String getFacadeFqName(@NotNull KtFile file) {
        if (file == null) {
            AbstractBlackBoxCodegenTest.$$$reportNull$$$0(5);
        }
        return CodegenUtil.getMemberDeclarationsToGenerate((KtFile)file).isEmpty() ? null : JvmFileClassUtil.getFileClassInfoNoResolve((KtFile)file).getFacadeClassFqName().asString();
    }

    protected boolean isIgnoredTarget(@NotNull File wholeFile) {
        if (wholeFile == null) {
            AbstractBlackBoxCodegenTest.$$$reportNull$$$0(6);
        }
        try {
            return InTextDirectivesUtils.isIgnoredTarget(this.getBackend(), wholeFile) || this instanceof AbstractFirBlackBoxCodegenTest && InTextDirectivesUtils.isDirectiveDefined(FileUtil.loadFile((File)wholeFile), "IGNORE_BACKEND_FIR: JVM_IR");
        }
        catch (Exception e) {
            throw ExceptionUtilsKt.rethrow((Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wholeFile";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/kotlin/codegen/AbstractBlackBoxCodegenTest";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doMultiFileTest";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "doBytecodeListingTest";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getFacadeFqName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isIgnoredTarget";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

