/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cfg;

import com.google.common.collect.Sets;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cfg.pseudocode.Pseudocode;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.Instruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.InstructionVisitor;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.InstructionWithNext;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.MagicInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.eval.MagicKind;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.AbstractJumpInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.ConditionalJumpInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.NondeterministicJumpInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.ReturnNoValueInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.ReturnValueInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.jumps.UnconditionalJumpInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.LocalFunctionDeclarationInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.SubroutineEnterInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.SubroutineExitInstruction;
import org.jetbrains.kotlin.cfg.pseudocode.instructions.special.SubroutineSinkInstruction;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.test.KotlinTestUtils;

public class CFGraphToDotFilePrinter {
    public static void dumpDot(File file, Collection<Pseudocode> pseudocodes) throws FileNotFoundException {
        File target = KotlinTestUtils.replaceExtension(file, "dot");
        PrintStream out = new PrintStream(target);
        out.println("digraph " + FileUtil.getNameWithoutExtension((File)file) + " {");
        int[] count = new int[1];
        HashMap<Instruction, String> nodeToName = new HashMap<Instruction, String>();
        for (Pseudocode pseudocode : pseudocodes) {
            CFGraphToDotFilePrinter.dumpNodes(pseudocode.getInstructionsIncludingDeadCode(), out, count, nodeToName, Sets.newHashSet((Iterable)pseudocode.getInstructions()));
        }
        int i = 0;
        for (Pseudocode pseudocode : pseudocodes) {
            String label;
            KtElement correspondingElement = pseudocode.getCorrespondingElement();
            if (correspondingElement instanceof KtNamedDeclaration) {
                KtNamedDeclaration namedDeclaration = (KtNamedDeclaration)correspondingElement;
                label = namedDeclaration.getName();
            } else {
                label = "anonymous_" + i;
            }
            out.println("subgraph cluster_" + i + " {\nlabel=\"" + label + "\";\ncolor=blue;\n");
            CFGraphToDotFilePrinter.dumpEdges(pseudocode.getInstructionsIncludingDeadCode(), out, count, nodeToName);
            out.println("}");
            ++i;
        }
        out.println("}");
        out.close();
    }

    private static void dumpEdges(List<Instruction> instructions, final PrintStream out, final int[] count, final Map<Instruction, String> nodeToName) {
        for (Instruction fromInst : instructions) {
            fromInst.accept(new InstructionVisitor(){

                public void visitLocalFunctionDeclarationInstruction(@NotNull LocalFunctionDeclarationInstruction instruction) {
                    if (instruction == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    int index = count[0];
                    CFGraphToDotFilePrinter.printEdge(out, (String)nodeToName.get(instruction), (String)nodeToName.get(instruction.getBody().getInstructionsIncludingDeadCode().get(0)), null);
                    this.visitInstructionWithNext((InstructionWithNext)instruction);
                }

                public void visitUnconditionalJump(@NotNull UnconditionalJumpInstruction instruction) {
                    if (instruction == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    CFGraphToDotFilePrinter.printEdge(out, (String)nodeToName.get(instruction), (String)nodeToName.get(instruction.getResolvedTarget()), null);
                }

                public void visitJump(@NotNull AbstractJumpInstruction instruction) {
                    if (instruction == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    CFGraphToDotFilePrinter.printEdge(out, (String)nodeToName.get(instruction), (String)nodeToName.get(instruction.getResolvedTarget()), null);
                }

                public void visitNondeterministicJump(@NotNull NondeterministicJumpInstruction instruction) {
                    if (instruction == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    for (Instruction nextInstruction : instruction.getNextInstructions()) {
                        CFGraphToDotFilePrinter.printEdge(out, (String)nodeToName.get(instruction), (String)nodeToName.get(nextInstruction), null);
                    }
                }

                public void visitReturnValue(@NotNull ReturnValueInstruction instruction) {
                    if (instruction == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    super.visitReturnValue(instruction);
                }

                public void visitReturnNoValue(@NotNull ReturnNoValueInstruction instruction) {
                    if (instruction == null) {
                        1.$$$reportNull$$$0(5);
                    }
                    super.visitReturnNoValue(instruction);
                }

                public void visitConditionalJump(@NotNull ConditionalJumpInstruction instruction) {
                    if (instruction == null) {
                        1.$$$reportNull$$$0(6);
                    }
                    String from = (String)nodeToName.get(instruction);
                    CFGraphToDotFilePrinter.printEdge(out, from, (String)nodeToName.get(instruction.getNextOnFalse()), "no");
                    CFGraphToDotFilePrinter.printEdge(out, from, (String)nodeToName.get(instruction.getNextOnTrue()), "yes");
                }

                public void visitInstructionWithNext(@NotNull InstructionWithNext instruction) {
                    if (instruction == null) {
                        1.$$$reportNull$$$0(7);
                    }
                    CFGraphToDotFilePrinter.printEdge(out, (String)nodeToName.get(instruction), (String)nodeToName.get(instruction.getNext()), null);
                }

                public void visitSubroutineExit(@NotNull SubroutineExitInstruction instruction) {
                    if (instruction == null) {
                        1.$$$reportNull$$$0(8);
                    }
                    if (!instruction.getNextInstructions().isEmpty()) {
                        CFGraphToDotFilePrinter.printEdge(out, (String)nodeToName.get(instruction), (String)nodeToName.get(instruction.getNextInstructions().iterator().next()), null);
                    }
                }

                public void visitSubroutineSink(@NotNull SubroutineSinkInstruction instruction) {
                    if (instruction == null) {
                        1.$$$reportNull$$$0(9);
                    }
                }

                public void visitInstruction(@NotNull Instruction instruction) {
                    if (instruction == null) {
                        1.$$$reportNull$$$0(10);
                    }
                    throw new UnsupportedOperationException(instruction.toString());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "instruction";
                    objectArray2[1] = "org/jetbrains/kotlin/cfg/CFGraphToDotFilePrinter$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitLocalFunctionDeclarationInstruction";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitUnconditionalJump";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitJump";
                            break;
                        }
                        case 3: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitNondeterministicJump";
                            break;
                        }
                        case 4: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitReturnValue";
                            break;
                        }
                        case 5: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitReturnNoValue";
                            break;
                        }
                        case 6: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitConditionalJump";
                            break;
                        }
                        case 7: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitInstructionWithNext";
                            break;
                        }
                        case 8: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitSubroutineExit";
                            break;
                        }
                        case 9: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitSubroutineSink";
                            break;
                        }
                        case 10: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitInstruction";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
    }

    private static void dumpNodes(List<Instruction> instructions, PrintStream out, int[] count, Map<Instruction, String> nodeToName, Set<Instruction> remainedAfterPostProcessInstructions) {
        for (Instruction node : instructions) {
            int n = count[0];
            count[0] = n + 1;
            String name = "n" + n;
            nodeToName.put(node, name);
            String text = node.toString();
            int newline = text.indexOf("\n");
            if (newline >= 0) {
                text = text.substring(0, newline);
            }
            String shape = "box";
            if (node instanceof ConditionalJumpInstruction || node instanceof UnconditionalJumpInstruction) {
                shape = "diamond";
            } else if (node instanceof NondeterministicJumpInstruction) {
                shape = "Mdiamond";
            } else if (node instanceof MagicInstruction && ((MagicInstruction)node).getKind() == MagicKind.UNSUPPORTED_ELEMENT) {
                shape = "box, fillcolor=red, style=filled";
            } else if (node instanceof LocalFunctionDeclarationInstruction) {
                shape = "Mcircle";
            } else if (node instanceof SubroutineEnterInstruction || node instanceof SubroutineExitInstruction) {
                shape = "roundrect, style=rounded";
            }
            if (!remainedAfterPostProcessInstructions.contains(node)) {
                shape = shape + "box, fillcolor=grey, style=filled";
            }
            out.println(name + "[label=\"" + text + "\", shape=" + shape + "];");
        }
    }

    private static void printEdge(PrintStream out, String from, String to, String label) {
        label = label != null ? "[label=\"" + label + "\"]" : "";
        out.println(from + " -> " + to + label + ";");
    }
}

