/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.checkers;

import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.checkers.CompilerTestLanguageVersionSettingsKt;
import org.jetbrains.kotlin.config.AnalysisFlag;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.KotlinCompilerVersion;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.config.LanguageVersionSettingsImpl;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001BE\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u001a\b\u0002\u0010\n\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\u0003\u00a2\u0006\u0002\u0010\rJ\u0015\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c2\u0003J\t\u0010\u0019\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\tH\u00c6\u0003J\u001b\u0010\u001b\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\u0003H\u00c6\u0003JO\u0010\u001c\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\u001a\b\u0002\u0010\n\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\u0003H\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\u0010\u0010 \u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u0004H\u0016J!\u0010\"\u001a\u0002H#\"\u0004\b\u0000\u0010#2\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H#0\u000bH\u0016\u00a2\u0006\u0002\u0010%J\t\u0010&\u001a\u00020'H\u00d6\u0001J\b\u0010(\u001a\u00020\u001eH\u0016J\t\u0010)\u001a\u00020*H\u00d6\u0001R#\u0010\n\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000fR\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/checkers/CompilerTestLanguageVersionSettings;", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "initialLanguageFeatures", "", "Lorg/jetbrains/kotlin/config/LanguageFeature;", "Lorg/jetbrains/kotlin/config/LanguageFeature$State;", "apiVersion", "Lorg/jetbrains/kotlin/config/ApiVersion;", "languageVersion", "Lorg/jetbrains/kotlin/config/LanguageVersion;", "analysisFlags", "Lorg/jetbrains/kotlin/config/AnalysisFlag;", "", "(Ljava/util/Map;Lorg/jetbrains/kotlin/config/ApiVersion;Lorg/jetbrains/kotlin/config/LanguageVersion;Ljava/util/Map;)V", "getAnalysisFlags", "()Ljava/util/Map;", "getApiVersion", "()Lorg/jetbrains/kotlin/config/ApiVersion;", "delegate", "Lorg/jetbrains/kotlin/config/LanguageVersionSettingsImpl;", "extraLanguageFeatures", "getExtraLanguageFeatures", "getLanguageVersion", "()Lorg/jetbrains/kotlin/config/LanguageVersion;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "getFeatureSupport", "feature", "getFlag", "T", "flag", "(Lorg/jetbrains/kotlin/config/AnalysisFlag;)Ljava/lang/Object;", "hashCode", "", "isPreRelease", "toString", "", "tests-common"})
public final class CompilerTestLanguageVersionSettings
implements LanguageVersionSettings {
    @NotNull
    private final Map<LanguageFeature, LanguageFeature.State> initialLanguageFeatures;
    @NotNull
    private final ApiVersion apiVersion;
    @NotNull
    private final LanguageVersion languageVersion;
    @NotNull
    private final Map<AnalysisFlag<?>, Object> analysisFlags;
    @NotNull
    private final Map<LanguageFeature, LanguageFeature.State> extraLanguageFeatures;
    @NotNull
    private final LanguageVersionSettingsImpl delegate;

    public CompilerTestLanguageVersionSettings(@NotNull Map<LanguageFeature, ? extends LanguageFeature.State> initialLanguageFeatures, @NotNull ApiVersion apiVersion, @NotNull LanguageVersion languageVersion, @NotNull Map<AnalysisFlag<?>, ? extends Object> analysisFlags) {
        Intrinsics.checkNotNullParameter(initialLanguageFeatures, (String)"initialLanguageFeatures");
        Intrinsics.checkNotNullParameter((Object)apiVersion, (String)"apiVersion");
        Intrinsics.checkNotNullParameter((Object)languageVersion, (String)"languageVersion");
        Intrinsics.checkNotNullParameter(analysisFlags, (String)"analysisFlags");
        this.initialLanguageFeatures = initialLanguageFeatures;
        this.apiVersion = apiVersion;
        this.languageVersion = languageVersion;
        this.analysisFlags = analysisFlags;
        this.extraLanguageFeatures = MapsKt.plus((Map)CompilerTestLanguageVersionSettingsKt.access$specificFeaturesForTests(), this.initialLanguageFeatures);
        this.delegate = new LanguageVersionSettingsImpl(this.getLanguageVersion(), this.getApiVersion(), MapsKt.emptyMap(), this.extraLanguageFeatures);
    }

    public /* synthetic */ CompilerTestLanguageVersionSettings(Map map, ApiVersion apiVersion, LanguageVersion languageVersion, Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            map2 = MapsKt.emptyMap();
        }
        this(map, apiVersion, languageVersion, map2);
    }

    @NotNull
    public ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    @NotNull
    public LanguageVersion getLanguageVersion() {
        return this.languageVersion;
    }

    @NotNull
    public final Map<AnalysisFlag<?>, Object> getAnalysisFlags() {
        return this.analysisFlags;
    }

    @NotNull
    public final Map<LanguageFeature, LanguageFeature.State> getExtraLanguageFeatures() {
        return this.extraLanguageFeatures;
    }

    @NotNull
    public LanguageFeature.State getFeatureSupport(@NotNull LanguageFeature feature) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        LanguageFeature.State state = this.extraLanguageFeatures.get(feature);
        return state == null ? this.delegate.getFeatureSupport(feature) : state;
    }

    public boolean isPreRelease() {
        return KotlinCompilerVersion.isPreRelease();
    }

    public <T> T getFlag(@NotNull AnalysisFlag<? extends T> flag) {
        Intrinsics.checkNotNullParameter(flag, (String)"flag");
        Object object = this.analysisFlags.get(flag);
        return (T)(object == null ? flag.getDefaultValue() : object);
    }

    public boolean supportsFeature(@NotNull LanguageFeature feature) {
        return LanguageVersionSettings.DefaultImpls.supportsFeature((LanguageVersionSettings)this, (LanguageFeature)feature);
    }

    private final Map<LanguageFeature, LanguageFeature.State> component1() {
        return this.initialLanguageFeatures;
    }

    @NotNull
    public final ApiVersion component2() {
        return this.apiVersion;
    }

    @NotNull
    public final LanguageVersion component3() {
        return this.languageVersion;
    }

    @NotNull
    public final Map<AnalysisFlag<?>, Object> component4() {
        return this.analysisFlags;
    }

    @NotNull
    public final CompilerTestLanguageVersionSettings copy(@NotNull Map<LanguageFeature, ? extends LanguageFeature.State> initialLanguageFeatures, @NotNull ApiVersion apiVersion, @NotNull LanguageVersion languageVersion, @NotNull Map<AnalysisFlag<?>, ? extends Object> analysisFlags) {
        Intrinsics.checkNotNullParameter(initialLanguageFeatures, (String)"initialLanguageFeatures");
        Intrinsics.checkNotNullParameter((Object)apiVersion, (String)"apiVersion");
        Intrinsics.checkNotNullParameter((Object)languageVersion, (String)"languageVersion");
        Intrinsics.checkNotNullParameter(analysisFlags, (String)"analysisFlags");
        return new CompilerTestLanguageVersionSettings(initialLanguageFeatures, apiVersion, languageVersion, analysisFlags);
    }

    public static /* synthetic */ CompilerTestLanguageVersionSettings copy$default(CompilerTestLanguageVersionSettings compilerTestLanguageVersionSettings, Map map, ApiVersion apiVersion, LanguageVersion languageVersion, Map map2, int n, Object object) {
        if ((n & 1) != 0) {
            map = compilerTestLanguageVersionSettings.initialLanguageFeatures;
        }
        if ((n & 2) != 0) {
            apiVersion = compilerTestLanguageVersionSettings.apiVersion;
        }
        if ((n & 4) != 0) {
            languageVersion = compilerTestLanguageVersionSettings.languageVersion;
        }
        if ((n & 8) != 0) {
            map2 = compilerTestLanguageVersionSettings.analysisFlags;
        }
        return compilerTestLanguageVersionSettings.copy(map, apiVersion, languageVersion, map2);
    }

    @NotNull
    public String toString() {
        return "CompilerTestLanguageVersionSettings(initialLanguageFeatures=" + this.initialLanguageFeatures + ", apiVersion=" + this.apiVersion + ", languageVersion=" + this.languageVersion + ", analysisFlags=" + this.analysisFlags + ')';
    }

    public int hashCode() {
        int result = ((Object)this.initialLanguageFeatures).hashCode();
        result = result * 31 + this.apiVersion.hashCode();
        result = result * 31 + this.languageVersion.hashCode();
        result = result * 31 + ((Object)this.analysisFlags).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CompilerTestLanguageVersionSettings)) {
            return false;
        }
        CompilerTestLanguageVersionSettings compilerTestLanguageVersionSettings = (CompilerTestLanguageVersionSettings)other;
        if (!Intrinsics.areEqual(this.initialLanguageFeatures, compilerTestLanguageVersionSettings.initialLanguageFeatures)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.apiVersion, (Object)compilerTestLanguageVersionSettings.apiVersion)) {
            return false;
        }
        if (this.languageVersion != compilerTestLanguageVersionSettings.languageVersion) {
            return false;
        }
        return Intrinsics.areEqual(this.analysisFlags, compilerTestLanguageVersionSettings.analysisFlags);
    }
}

