/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.test.testFramework;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.concurrency.IdeaForkJoinWorkerThreadFactory;
import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.impl.DocumentCommitProcessor;
import com.intellij.psi.impl.DocumentCommitThread;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.rt.execution.junit.FileComparisonFailure;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.EdtTestUtilKt;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.RunAll;
import com.intellij.testFramework.TestFrameworkUtil;
import com.intellij.testFramework.TestLoggerFactory;
import com.intellij.testFramework.TestRunnerUtil;
import com.intellij.testFramework.Timings;
import com.intellij.testFramework.VfsTestUtil;
import com.intellij.testFramework.exceptionCases.AbstractExceptionCase;
import com.intellij.testFramework.fixtures.IdeaTestExecutionPolicy;
import com.intellij.util.Consumer;
import com.intellij.util.DocumentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.PeekableIteratorWrapper;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.lang.CompoundRuntimeException;
import com.intellij.util.ui.UIUtil;
import gnu.trove.Equality;
import gnu.trove.THashSet;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.jdom.Element;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.test.testFramework.TestApplicationUtilKt;
import org.jetbrains.kotlin.testFramework.MockComponentManagerCreationTracer;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.FlexibleTypeImpl;
import org.junit.Assert;
import org.junit.ComparisonFailure;

public abstract class KtUsefulTestCase
extends TestCase {
    public static final boolean IS_UNDER_TEAMCITY;
    public static final String TEMP_DIR_MARKER = "unitTest_";
    public static final boolean OVERWRITE_TESTDATA;
    private static final String ORIGINAL_TEMP_DIR;
    private static final Map<String, Long> TOTAL_SETUP_COST_MILLIS;
    private static final Map<String, Long> TOTAL_TEARDOWN_COST_MILLIS;
    private Application application;
    protected static final Logger LOG;
    @NotNull
    private final Disposable myTestRootDisposable;
    static Path ourPathToKeep;
    private final List<String> myPathsToKeep;
    private String myTempDir;
    private static final String DEFAULT_SETTINGS_EXTERNALIZED;
    private static final CodeInsightSettings defaultSettings;
    private List<Throwable> mySuppressedExceptions;
    private static final Set<String> DELETE_ON_EXIT_HOOK_DOT_FILES;
    private static final Class<?> DELETE_ON_EXIT_HOOK_CLASS;

    protected void addSuppressedException(@NotNull Throwable e) {
        SmartList list;
        if (e == null) {
            KtUsefulTestCase.$$$reportNull$$$0(0);
        }
        if ((list = this.mySuppressedExceptions) == null) {
            this.mySuppressedExceptions = list = new SmartList();
        }
        list.add((Throwable)e);
    }

    public KtUsefulTestCase() {
        this.myTestRootDisposable = new TestDisposable();
        this.myPathsToKeep = new ArrayList<String>();
    }

    public KtUsefulTestCase(@NotNull String name) {
        if (name == null) {
            KtUsefulTestCase.$$$reportNull$$$0(1);
        }
        super(name);
        this.myTestRootDisposable = new TestDisposable();
        this.myPathsToKeep = new ArrayList<String>();
    }

    protected boolean shouldContainTempFiles() {
        return true;
    }

    protected void setUp() throws Exception {
        this.application = ApplicationManager.getApplication();
        if (this.application != null && this.application.isDisposed()) {
            MockComponentManagerCreationTracer.diagnoseDisposedButNotClearedApplication(this.application);
        }
        super.setUp();
        if (this.shouldContainTempFiles()) {
            IdeaTestExecutionPolicy policy = IdeaTestExecutionPolicy.current();
            String testName = null;
            if (policy != null) {
                testName = policy.getPerTestTempDirName();
            }
            if (testName == null) {
                testName = FileUtil.sanitizeFileName((String)this.getTestName(true));
            }
            testName = new File(testName).getName();
            this.myTempDir = FileUtil.createTempDirectory((String)(TEMP_DIR_MARKER + testName), (String)"", (boolean)false).getPath();
            FileUtil.resetCanonicalTempPathCache((String)this.myTempDir);
        }
        boolean isStressTest = this.isStressTest();
        ApplicationInfoImpl.setInStressTest((boolean)isStressTest);
        if (this.isPerformanceTest()) {
            Timings.getStatistics();
        }
        Disposer.setDebugMode((!isStressTest ? 1 : 0) != 0);
        if (this.isIconRequired()) {
            IconLoader.deactivate();
        }
    }

    protected boolean isIconRequired() {
        return false;
    }

    protected void tearDown() throws Exception {
        try {
            new RunAll(new ThrowableRunnable[]{() -> {
                if (this.isIconRequired()) {
                    // empty if block
                }
            }, () -> this.disposeRootDisposable(), () -> KtUsefulTestCase.cleanupSwingDataStructures(), () -> KtUsefulTestCase.cleanupDeleteOnExitHookList(), () -> Disposer.setDebugMode((boolean)true), () -> {
                if (this.shouldContainTempFiles()) {
                    FileUtil.resetCanonicalTempPathCache((String)ORIGINAL_TEMP_DIR);
                    if (this.hasTmpFilesToKeep()) {
                        File[] files = new File(this.myTempDir).listFiles();
                        if (files != null) {
                            for (File file : files) {
                                if (this.shouldKeepTmpFile(file)) continue;
                                FileUtil.delete((File)file);
                            }
                        }
                    } else {
                        FileUtil.delete((File)new File(this.myTempDir));
                    }
                }
            }, () -> KtUsefulTestCase.waitForAppLeakingThreads(10L, TimeUnit.SECONDS)}).run((List)ObjectUtils.notNull(this.mySuppressedExceptions, Collections.emptyList()));
        }
        finally {
            TestApplicationUtilKt.resetApplicationToNull(this.application);
            this.application = null;
        }
    }

    protected final void disposeRootDisposable() {
        Disposer.dispose((Disposable)this.getTestRootDisposable());
    }

    protected void addTmpFileToKeep(@NotNull File file) {
        if (file == null) {
            KtUsefulTestCase.$$$reportNull$$$0(2);
        }
        this.myPathsToKeep.add(file.getPath());
    }

    private boolean hasTmpFilesToKeep() {
        return ourPathToKeep != null && FileUtil.isAncestor((String)this.myTempDir, (String)ourPathToKeep.toString(), (boolean)false) || !this.myPathsToKeep.isEmpty();
    }

    private boolean shouldKeepTmpFile(@NotNull File file) {
        String path;
        if (file == null) {
            KtUsefulTestCase.$$$reportNull$$$0(3);
        }
        if (FileUtil.pathsEqual((String)(path = file.getPath()), (String)ourPathToKeep.toString())) {
            return true;
        }
        for (String pathToKeep : this.myPathsToKeep) {
            if (!FileUtil.pathsEqual((String)path, (String)pathToKeep)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cleanupDeleteOnExitHookList() {
        ArrayList<String> list;
        Class<?> clazz = DELETE_ON_EXIT_HOOK_CLASS;
        synchronized (clazz) {
            if (DELETE_ON_EXIT_HOOK_DOT_FILES.isEmpty()) {
                return;
            }
            list = new ArrayList<String>(DELETE_ON_EXIT_HOOK_DOT_FILES);
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            String path = (String)list.get(i);
            File file = new File(path);
            if (!file.delete() && file.exists()) continue;
            Class<?> clazz2 = DELETE_ON_EXIT_HOOK_CLASS;
            synchronized (clazz2) {
                DELETE_ON_EXIT_HOOK_DOT_FILES.remove(path);
                continue;
            }
        }
    }

    private static void cleanupSwingDataStructures() throws Exception {
        Object manager = ReflectionUtil.getDeclaredMethod(Class.forName("javax.swing.KeyboardManager"), (String)"getCurrentManager", (Class[])new Class[0]).invoke(null, new Object[0]);
        Map componentKeyStrokeMap = (Map)ReflectionUtil.getField(manager.getClass(), (Object)manager, Hashtable.class, (String)"componentKeyStrokeMap");
        componentKeyStrokeMap.clear();
        Map containerMap = (Map)ReflectionUtil.getField(manager.getClass(), (Object)manager, Hashtable.class, (String)"containerMap");
        containerMap.clear();
    }

    static void doCheckForSettingsDamage(@NotNull CodeStyleSettings oldCodeStyleSettings, @NotNull CodeStyleSettings currentCodeStyleSettings) {
        if (oldCodeStyleSettings == null) {
            KtUsefulTestCase.$$$reportNull$$$0(4);
        }
        if (currentCodeStyleSettings == null) {
            KtUsefulTestCase.$$$reportNull$$$0(5);
        }
        CodeInsightSettings settings = CodeInsightSettings.getInstance();
        new RunAll(new ThrowableRunnable[0]).append(new ThrowableRunnable[]{() -> {
            try {
                KtUsefulTestCase.checkCodeInsightSettingsEqual(defaultSettings, settings);
            }
            catch (AssertionError error) {
                CodeInsightSettings clean = new CodeInsightSettings();
                for (Field field : clean.getClass().getFields()) {
                    try {
                        ReflectionUtil.copyFieldValue((Object)clean, (Object)settings, (Field)field);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                throw error;
            }
        }}).append(new ThrowableRunnable[]{() -> {
            currentCodeStyleSettings.getIndentOptions((FileType)StdFileTypes.JAVA);
            try {
                KtUsefulTestCase.checkCodeStyleSettingsEqual(oldCodeStyleSettings, currentCodeStyleSettings);
            }
            finally {
                currentCodeStyleSettings.clearCodeStyleSettings();
            }
        }}).run();
    }

    @NotNull
    public Disposable getTestRootDisposable() {
        Disposable disposable = this.myTestRootDisposable;
        if (disposable == null) {
            KtUsefulTestCase.$$$reportNull$$$0(6);
        }
        return disposable;
    }

    protected void runTest() throws Throwable {
        Throwable[] throwables = new Throwable[1];
        Runnable runnable = () -> {
            try {
                TestLoggerFactory.onTestStarted();
                super.runTest();
                TestLoggerFactory.onTestFinished((boolean)true);
            }
            catch (InvocationTargetException e) {
                TestLoggerFactory.onTestFinished((boolean)false);
                e.fillInStackTrace();
                throwables[0] = e.getTargetException();
            }
            catch (IllegalAccessException e) {
                TestLoggerFactory.onTestFinished((boolean)false);
                e.fillInStackTrace();
                throwables[0] = e;
            }
            catch (Throwable e) {
                TestLoggerFactory.onTestFinished((boolean)false);
                throwables[0] = e;
            }
        };
        this.invokeTestRunnable(runnable);
        if (throwables[0] != null) {
            throw throwables[0];
        }
    }

    protected boolean shouldRunTest() {
        return TestFrameworkUtil.canRunTest(((Object)((Object)this)).getClass());
    }

    protected void invokeTestRunnable(@NotNull Runnable runnable) throws Exception {
        if (runnable == null) {
            KtUsefulTestCase.$$$reportNull$$$0(7);
        }
        if (this.runInDispatchThread()) {
            EdtTestUtilKt.runInEdtAndWait(() -> {
                runnable.run();
                return null;
            });
        } else {
            runnable.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void defaultRunBare() throws Throwable {
        Throwable exception;
        block13: {
            exception = null;
            long setupStart = System.nanoTime();
            this.setUp();
            long setupCost = (System.nanoTime() - setupStart) / 1000000L;
            this.logPerClassCost(setupCost, TOTAL_SETUP_COST_MILLIS);
            this.runTest();
            try {
                long teardownStart = System.nanoTime();
                this.tearDown();
                long teardownCost = (System.nanoTime() - teardownStart) / 1000000L;
                this.logPerClassCost(teardownCost, TOTAL_TEARDOWN_COST_MILLIS);
            }
            catch (Throwable tearingDown) {
                if (exception == null) {
                    exception = tearingDown;
                    break block13;
                }
                exception = new CompoundRuntimeException(Arrays.asList(exception, tearingDown));
            }
            break block13;
            catch (Throwable running) {
                try {
                    exception = running;
                }
                catch (Throwable throwable) {
                    try {
                        long teardownStart = System.nanoTime();
                        this.tearDown();
                        long teardownCost = (System.nanoTime() - teardownStart) / 1000000L;
                        this.logPerClassCost(teardownCost, TOTAL_TEARDOWN_COST_MILLIS);
                    }
                    catch (Throwable tearingDown) {
                        exception = exception == null ? tearingDown : new CompoundRuntimeException(Arrays.asList(exception, tearingDown));
                    }
                    throw throwable;
                }
                try {
                    long teardownStart = System.nanoTime();
                    this.tearDown();
                    long teardownCost = (System.nanoTime() - teardownStart) / 1000000L;
                    this.logPerClassCost(teardownCost, TOTAL_TEARDOWN_COST_MILLIS);
                }
                catch (Throwable tearingDown) {
                    if (exception == null) {
                        exception = tearingDown;
                        break block13;
                    }
                    exception = new CompoundRuntimeException(Arrays.asList(exception, tearingDown));
                }
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void logPerClassCost(long cost, @NotNull Map<String, Long> map) {
        Class<?> superclass;
        void costMap;
        Long oldCost;
        if (map == null) {
            KtUsefulTestCase.$$$reportNull$$$0(8);
        }
        long newCost = (oldCost = (Long)costMap.get((superclass = ((Object)((Object)this)).getClass().getSuperclass()).getName())) == null ? cost : oldCost + cost;
        costMap.put(superclass.getName(), newCost);
    }

    static void logSetupTeardownCosts() {
        System.out.println("Setup costs");
        long totalSetup = 0L;
        for (Map.Entry<String, Long> entry : TOTAL_SETUP_COST_MILLIS.entrySet()) {
            System.out.println(String.format("  %s: %d ms", entry.getKey(), entry.getValue()));
            totalSetup += entry.getValue().longValue();
        }
        System.out.println("Teardown costs");
        long totalTeardown = 0L;
        for (Map.Entry<String, Long> entry : TOTAL_TEARDOWN_COST_MILLIS.entrySet()) {
            System.out.println(String.format("  %s: %d ms", entry.getKey(), entry.getValue()));
            totalTeardown += entry.getValue().longValue();
        }
        System.out.println(String.format("Total overhead: setup %d ms, teardown %d ms", totalSetup, totalTeardown));
        System.out.println(String.format("##teamcity[buildStatisticValue key='ideaTests.totalSetupMs' value='%d']", totalSetup));
        System.out.println(String.format("##teamcity[buildStatisticValue key='ideaTests.totalTeardownMs' value='%d']", totalTeardown));
    }

    public void runBare() throws Throwable {
        if (!this.shouldRunTest()) {
            return;
        }
        if (this.runInDispatchThread()) {
            TestRunnerUtil.replaceIdeEventQueueSafely();
            EdtTestUtil.runInEdtAndWait(this::defaultRunBare);
        } else {
            this.defaultRunBare();
        }
    }

    protected boolean runInDispatchThread() {
        IdeaTestExecutionPolicy policy = IdeaTestExecutionPolicy.current();
        if (policy != null) {
            return policy.runInDispatchThread();
        }
        return true;
    }

    protected void edt(@NotNull ThrowableRunnable<Throwable> runnable) {
        if (runnable == null) {
            KtUsefulTestCase.$$$reportNull$$$0(9);
        }
        EdtTestUtil.runInEdtAndWait(runnable);
    }

    @NotNull
    public static String toString(@NotNull Iterable<?> collection) {
        if (collection == null) {
            KtUsefulTestCase.$$$reportNull$$$0(10);
        }
        if (!collection.iterator().hasNext()) {
            return "<empty>";
        }
        StringBuilder builder = new StringBuilder();
        for (Object o : collection) {
            if (o instanceof THashSet) {
                builder.append(new TreeSet((THashSet)o));
            } else {
                builder.append(o);
            }
            builder.append('\n');
        }
        String string = builder.toString();
        if (string == null) {
            KtUsefulTestCase.$$$reportNull$$$0(11);
        }
        return string;
    }

    @SafeVarargs
    public static <T> void assertOrderedEquals(@NotNull T[] actual2, T ... expected) {
        if (actual2 == null) {
            KtUsefulTestCase.$$$reportNull$$$0(12);
        }
        if (expected == null) {
            KtUsefulTestCase.$$$reportNull$$$0(13);
        }
        KtUsefulTestCase.assertOrderedEquals(Arrays.asList(actual2), expected);
    }

    @SafeVarargs
    public static <T> void assertOrderedEquals(@NotNull Iterable<? extends T> actual2, T ... expected) {
        if (actual2 == null) {
            KtUsefulTestCase.$$$reportNull$$$0(14);
        }
        if (expected == null) {
            KtUsefulTestCase.$$$reportNull$$$0(15);
        }
        KtUsefulTestCase.assertOrderedEquals("", actual2, expected);
    }

    public static void assertOrderedEquals(@NotNull byte[] actual2, @NotNull byte[] expected) {
        if (actual2 == null) {
            KtUsefulTestCase.$$$reportNull$$$0(16);
        }
        if (expected == null) {
            KtUsefulTestCase.$$$reportNull$$$0(17);
        }
        KtUsefulTestCase.assertEquals((int)expected.length, (int)actual2.length);
        for (int i = 0; i < actual2.length; ++i) {
            byte a = actual2[i];
            byte e = expected[i];
            KtUsefulTestCase.assertEquals((String)("not equals at index: " + i), (byte)e, (byte)a);
        }
    }

    public static void assertOrderedEquals(@NotNull int[] actual2, @NotNull int[] expected) {
        if (actual2 == null) {
            KtUsefulTestCase.$$$reportNull$$$0(18);
        }
        if (expected == null) {
            KtUsefulTestCase.$$$reportNull$$$0(19);
        }
        if (actual2.length != expected.length) {
            KtUsefulTestCase.fail((String)("Expected size: " + expected.length + "; actual: " + actual2.length + "\nexpected: " + Arrays.toString(expected) + "\nactual  : " + Arrays.toString(actual2)));
        }
        for (int i = 0; i < actual2.length; ++i) {
            int a = actual2[i];
            int e = expected[i];
            KtUsefulTestCase.assertEquals((String)("not equals at index: " + i), (int)e, (int)a);
        }
    }

    @SafeVarargs
    public static <T> void assertOrderedEquals(@NotNull String errorMsg, @NotNull Iterable<? extends T> actual2, T ... expected) {
        if (errorMsg == null) {
            KtUsefulTestCase.$$$reportNull$$$0(20);
        }
        if (actual2 == null) {
            KtUsefulTestCase.$$$reportNull$$$0(21);
        }
        if (expected == null) {
            KtUsefulTestCase.$$$reportNull$$$0(22);
        }
        KtUsefulTestCase.assertOrderedEquals(errorMsg, actual2, Arrays.asList(expected));
    }

    public static <T> void assertOrderedEquals(@NotNull Iterable<? extends T> actual2, @NotNull Iterable<? extends T> expected) {
        if (actual2 == null) {
            KtUsefulTestCase.$$$reportNull$$$0(23);
        }
        if (expected == null) {
            KtUsefulTestCase.$$$reportNull$$$0(24);
        }
        KtUsefulTestCase.assertOrderedEquals("", actual2, expected);
    }

    public static <T> void assertOrderedEquals(@NotNull String errorMsg, @NotNull Iterable<? extends T> actual2, @NotNull Iterable<? extends T> expected) {
        if (errorMsg == null) {
            KtUsefulTestCase.$$$reportNull$$$0(25);
        }
        if (actual2 == null) {
            KtUsefulTestCase.$$$reportNull$$$0(26);
        }
        if (expected == null) {
            KtUsefulTestCase.$$$reportNull$$$0(27);
        }
        KtUsefulTestCase.assertOrderedEquals(errorMsg, actual2, expected, Equality.CANONICAL);
    }

    public static <T> void assertOrderedEquals(@NotNull String errorMsg, @NotNull Iterable<? extends T> actual2, @NotNull Iterable<? extends T> expected, @NotNull Equality<? super T> comparator) {
        if (errorMsg == null) {
            KtUsefulTestCase.$$$reportNull$$$0(28);
        }
        if (actual2 == null) {
            KtUsefulTestCase.$$$reportNull$$$0(29);
        }
        if (expected == null) {
            KtUsefulTestCase.$$$reportNull$$$0(30);
        }
        if (comparator == null) {
            KtUsefulTestCase.$$$reportNull$$$0(31);
        }
        if (!KtUsefulTestCase.equals(actual2, expected, comparator)) {
            String expectedString = KtUsefulTestCase.toString(expected);
            String actualString = KtUsefulTestCase.toString(actual2);
            Assert.assertEquals((String)errorMsg, (Object)expectedString, (Object)actualString);
            Assert.fail((String)("Warning! 'toString' does not reflect the difference.\nExpected: " + expectedString + "\nActual: " + actualString));
        }
    }

    private static <T> boolean equals(@NotNull Iterable<? extends T> a1, @NotNull Iterable<? extends T> a2, @NotNull Equality<? super T> comparator) {
        if (a1 == null) {
            KtUsefulTestCase.$$$reportNull$$$0(32);
        }
        if (a2 == null) {
            KtUsefulTestCase.$$$reportNull$$$0(33);
        }
        if (comparator == null) {
            KtUsefulTestCase.$$$reportNull$$$0(34);
        }
        Iterator<T> it1 = a1.iterator();
        Iterator<T> it2 = a2.iterator();
        while (it1.hasNext() || it2.hasNext()) {
            if (!it1.hasNext() || !it2.hasNext()) {
                return false;
            }
            if (comparator.equals(it1.next(), it2.next())) continue;
            return false;
        }
        return true;
    }

    @SafeVarargs
    public static <T> void assertOrderedCollection(@NotNull T[] collection, Consumer<T> ... checkers) {
        if (collection == null) {
            KtUsefulTestCase.$$$reportNull$$$0(35);
        }
        if (checkers == null) {
            KtUsefulTestCase.$$$reportNull$$$0(36);
        }
        KtUsefulTestCase.assertOrderedCollection(Arrays.asList(collection), checkers);
    }

    @SafeVarargs
    public static <T> void assertSameElements(@NotNull T[] actual2, T ... expected) {
        if (actual2 == null) {
            KtUsefulTestCase.$$$reportNull$$$0(37);
        }
        if (expected == null) {
            KtUsefulTestCase.$$$reportNull$$$0(38);
        }
        KtUsefulTestCase.assertSameElements(Arrays.asList(actual2), expected);
    }

    @SafeVarargs
    public static <T> void assertSameElements(@NotNull Collection<? extends T> actual2, T ... expected) {
        if (actual2 == null) {
            KtUsefulTestCase.$$$reportNull$$$0(39);
        }
        if (expected == null) {
            KtUsefulTestCase.$$$reportNull$$$0(40);
        }
        KtUsefulTestCase.assertSameElements(actual2, Arrays.asList(expected));
    }

    public static <T> void assertSameElements(@NotNull Collection<? extends T> actual2, @NotNull Collection<? extends T> expected) {
        if (actual2 == null) {
            KtUsefulTestCase.$$$reportNull$$$0(41);
        }
        if (expected == null) {
            KtUsefulTestCase.$$$reportNull$$$0(42);
        }
        KtUsefulTestCase.assertSameElements("", actual2, expected);
    }

    public static <T> void assertSameElements(@NotNull String message, @NotNull Collection<? extends T> actual2, @NotNull Collection<? extends T> expected) {
        if (message == null) {
            KtUsefulTestCase.$$$reportNull$$$0(43);
        }
        if (actual2 == null) {
            KtUsefulTestCase.$$$reportNull$$$0(44);
        }
        if (expected == null) {
            KtUsefulTestCase.$$$reportNull$$$0(45);
        }
        if (actual2.size() != expected.size() || !new HashSet<T>(expected).equals(new HashSet<T>(actual2))) {
            Assert.assertEquals((String)message, new HashSet<T>(expected), new HashSet<T>(actual2));
        }
    }

    @SafeVarargs
    public static <T> void assertContainsOrdered(@NotNull Collection<? extends T> collection, T ... expected) {
        if (collection == null) {
            KtUsefulTestCase.$$$reportNull$$$0(46);
        }
        if (expected == null) {
            KtUsefulTestCase.$$$reportNull$$$0(47);
        }
        KtUsefulTestCase.assertContainsOrdered(collection, Arrays.asList(expected));
    }

    public static <T> void assertContainsOrdered(@NotNull Collection<? extends T> collection, @NotNull Collection<? extends T> expected) {
        if (collection == null) {
            KtUsefulTestCase.$$$reportNull$$$0(48);
        }
        if (expected == null) {
            KtUsefulTestCase.$$$reportNull$$$0(49);
        }
        PeekableIteratorWrapper expectedIt = new PeekableIteratorWrapper(expected.iterator());
        PeekableIteratorWrapper actualIt = new PeekableIteratorWrapper(collection.iterator());
        while (actualIt.hasNext() && expectedIt.hasNext()) {
            Object actualElem;
            Object expectedElem = expectedIt.peek();
            if (expectedElem.equals(actualElem = actualIt.peek())) {
                expectedIt.next();
            }
            actualIt.next();
        }
        if (expectedIt.hasNext()) {
            throw new ComparisonFailure("", KtUsefulTestCase.toString(expected), KtUsefulTestCase.toString(collection));
        }
    }

    @SafeVarargs
    public static <T> void assertContainsElements(@NotNull Collection<? extends T> collection, T ... expected) {
        if (collection == null) {
            KtUsefulTestCase.$$$reportNull$$$0(50);
        }
        if (expected == null) {
            KtUsefulTestCase.$$$reportNull$$$0(51);
        }
        KtUsefulTestCase.assertContainsElements(collection, Arrays.asList(expected));
    }

    public static <T> void assertContainsElements(@NotNull Collection<? extends T> collection, @NotNull Collection<? extends T> expected) {
        if (collection == null) {
            KtUsefulTestCase.$$$reportNull$$$0(52);
        }
        if (expected == null) {
            KtUsefulTestCase.$$$reportNull$$$0(53);
        }
        ArrayList<T> copy = new ArrayList<T>(collection);
        copy.retainAll(expected);
        KtUsefulTestCase.assertSameElements(KtUsefulTestCase.toString(collection), copy, expected);
    }

    @NotNull
    public static String toString(@NotNull Object[] collection, @NotNull String separator) {
        if (collection == null) {
            KtUsefulTestCase.$$$reportNull$$$0(54);
        }
        if (separator == null) {
            KtUsefulTestCase.$$$reportNull$$$0(55);
        }
        return KtUsefulTestCase.toString(Arrays.asList(collection), separator);
    }

    @SafeVarargs
    public static <T> void assertDoesntContain(@NotNull Collection<? extends T> collection, T ... notExpected) {
        if (collection == null) {
            KtUsefulTestCase.$$$reportNull$$$0(56);
        }
        if (notExpected == null) {
            KtUsefulTestCase.$$$reportNull$$$0(57);
        }
        KtUsefulTestCase.assertDoesntContain(collection, Arrays.asList(notExpected));
    }

    public static <T> void assertDoesntContain(@NotNull Collection<? extends T> collection, @NotNull Collection<? extends T> notExpected) {
        if (collection == null) {
            KtUsefulTestCase.$$$reportNull$$$0(58);
        }
        if (notExpected == null) {
            KtUsefulTestCase.$$$reportNull$$$0(59);
        }
        ArrayList<T> expected = new ArrayList<T>(collection);
        expected.removeAll(notExpected);
        KtUsefulTestCase.assertSameElements(collection, expected);
    }

    @NotNull
    public static String toString(@NotNull Collection<?> collection, @NotNull String separator) {
        if (collection == null) {
            KtUsefulTestCase.$$$reportNull$$$0(60);
        }
        if (separator == null) {
            KtUsefulTestCase.$$$reportNull$$$0(61);
        }
        List list = ContainerUtil.map2List(collection, String::valueOf);
        Collections.sort(list);
        StringBuilder builder = new StringBuilder();
        boolean flag = false;
        for (String o : list) {
            if (flag) {
                builder.append(separator);
            }
            builder.append(o);
            flag = true;
        }
        String string = builder.toString();
        if (string == null) {
            KtUsefulTestCase.$$$reportNull$$$0(62);
        }
        return string;
    }

    @SafeVarargs
    public static <T> void assertOrderedCollection(@NotNull Collection<? extends T> collection, Consumer<T> ... checkers) {
        if (collection == null) {
            KtUsefulTestCase.$$$reportNull$$$0(63);
        }
        if (checkers == null) {
            KtUsefulTestCase.$$$reportNull$$$0(64);
        }
        if (collection.size() != checkers.length) {
            Assert.fail((String)KtUsefulTestCase.toString(collection));
        }
        int i = 0;
        for (T actual2 : collection) {
            try {
                checkers[i].consume(actual2);
            }
            catch (AssertionFailedError e) {
                System.out.println(i + ": " + actual2);
                throw e;
            }
            ++i;
        }
    }

    @SafeVarargs
    public static <T> void assertUnorderedCollection(@NotNull T[] collection, Consumer<T> ... checkers) {
        if (collection == null) {
            KtUsefulTestCase.$$$reportNull$$$0(65);
        }
        if (checkers == null) {
            KtUsefulTestCase.$$$reportNull$$$0(66);
        }
        KtUsefulTestCase.assertUnorderedCollection(Arrays.asList(collection), checkers);
    }

    @SafeVarargs
    public static <T> void assertUnorderedCollection(@NotNull Collection<? extends T> collection, Consumer<T> ... checkers) {
        if (collection == null) {
            KtUsefulTestCase.$$$reportNull$$$0(67);
        }
        if (checkers == null) {
            KtUsefulTestCase.$$$reportNull$$$0(68);
        }
        if (collection.size() != checkers.length) {
            Assert.fail((String)KtUsefulTestCase.toString(collection));
        }
        Set checkerSet = ContainerUtil.set((Object[])checkers);
        int i = 0;
        Throwable lastError = null;
        for (T actual2 : collection) {
            boolean flag = true;
            for (Consumer condition : checkerSet) {
                Throwable error = KtUsefulTestCase.accepts(condition, actual2);
                if (error == null) {
                    checkerSet.remove(condition);
                    flag = false;
                    break;
                }
                lastError = error;
            }
            if (flag) {
                lastError.printStackTrace();
                Assert.fail((String)("Incorrect element(" + i + "): " + actual2));
            }
            ++i;
        }
    }

    private static <T> Throwable accepts(@NotNull Consumer<? super T> condition, T actual2) {
        if (condition == null) {
            KtUsefulTestCase.$$$reportNull$$$0(69);
        }
        try {
            condition.consume(actual2);
            return null;
        }
        catch (Throwable e) {
            return e;
        }
    }

    @Contract(value="null, _ -> fail")
    @NotNull
    public static <T> T assertInstanceOf(Object o, @NotNull Class<T> aClass) {
        Object t;
        if (aClass == null) {
            KtUsefulTestCase.$$$reportNull$$$0(70);
        }
        Assert.assertNotNull((String)("Expected instance of: " + aClass.getName() + " actual: " + null), (Object)o);
        Assert.assertTrue((String)("Expected instance of: " + aClass.getName() + " actual: " + o.getClass().getName()), (boolean)aClass.isInstance(o));
        Object object = t = o;
        if (object == null) {
            KtUsefulTestCase.$$$reportNull$$$0(71);
        }
        return (T)object;
    }

    public static <T> T assertOneElement(@NotNull Collection<? extends T> collection) {
        if (collection == null) {
            KtUsefulTestCase.$$$reportNull$$$0(72);
        }
        Iterator<T> iterator = collection.iterator();
        String toString = KtUsefulTestCase.toString(collection);
        Assert.assertTrue((String)toString, (boolean)iterator.hasNext());
        T t = iterator.next();
        Assert.assertFalse((String)toString, (boolean)iterator.hasNext());
        return t;
    }

    public static <T> T assertOneElement(@NotNull T[] ts) {
        if (ts == null) {
            KtUsefulTestCase.$$$reportNull$$$0(73);
        }
        Assert.assertEquals((String)Arrays.asList(ts).toString(), (long)1L, (long)ts.length);
        return ts[0];
    }

    @SafeVarargs
    public static <T> void assertOneOf(T value, T ... values) {
        if (values == null) {
            KtUsefulTestCase.$$$reportNull$$$0(74);
        }
        for (T v : values) {
            if (!Objects.equals(value, v)) continue;
            return;
        }
        Assert.fail((String)(value + " should be equal to one of " + Arrays.toString(values)));
    }

    public static void printThreadDump() {
        PerformanceWatcher.dumpThreadsToConsole((String)"Thread dump:");
    }

    public static void assertEmpty(@NotNull Object[] array) {
        if (array == null) {
            KtUsefulTestCase.$$$reportNull$$$0(75);
        }
        KtUsefulTestCase.assertOrderedEquals(array, new Object[0]);
    }

    public static void assertNotEmpty(Collection<?> collection) {
        KtUsefulTestCase.assertNotNull(collection);
        KtUsefulTestCase.assertFalse((boolean)collection.isEmpty());
    }

    public static void assertEmpty(@NotNull Collection<?> collection) {
        if (collection == null) {
            KtUsefulTestCase.$$$reportNull$$$0(76);
        }
        KtUsefulTestCase.assertEmpty(collection.toString(), collection);
    }

    public static void assertNullOrEmpty(@Nullable Collection<?> collection) {
        if (collection == null) {
            return;
        }
        KtUsefulTestCase.assertEmpty("", collection);
    }

    public static void assertEmpty(String s) {
        KtUsefulTestCase.assertTrue((String)s, (boolean)StringUtil.isEmpty((String)s));
    }

    public static <T> void assertEmpty(@NotNull String errorMsg, @NotNull Collection<? extends T> collection) {
        if (errorMsg == null) {
            KtUsefulTestCase.$$$reportNull$$$0(77);
        }
        if (collection == null) {
            KtUsefulTestCase.$$$reportNull$$$0(78);
        }
        KtUsefulTestCase.assertOrderedEquals(errorMsg, collection, Collections.emptyList());
    }

    public static void assertSize(int expectedSize, @NotNull Object[] array) {
        if (array == null) {
            KtUsefulTestCase.$$$reportNull$$$0(79);
        }
        if (array.length != expectedSize) {
            KtUsefulTestCase.assertEquals((String)KtUsefulTestCase.toString(Arrays.asList(array)), (int)expectedSize, (int)array.length);
        }
    }

    public static void assertSize(int expectedSize, @NotNull Collection<?> c) {
        if (c == null) {
            KtUsefulTestCase.$$$reportNull$$$0(80);
        }
        if (c.size() != expectedSize) {
            KtUsefulTestCase.assertEquals((String)KtUsefulTestCase.toString(c), (int)expectedSize, (int)c.size());
        }
    }

    @NotNull
    protected <T extends Disposable> T disposeOnTearDown(@NotNull T disposable) {
        if (disposable == null) {
            KtUsefulTestCase.$$$reportNull$$$0(81);
        }
        Disposer.register((Disposable)this.getTestRootDisposable(), disposable);
        T t = disposable;
        if (t == null) {
            KtUsefulTestCase.$$$reportNull$$$0(82);
        }
        return t;
    }

    public static void assertSameLines(@NotNull String expected, @NotNull String actual2) {
        if (expected == null) {
            KtUsefulTestCase.$$$reportNull$$$0(83);
        }
        if (actual2 == null) {
            KtUsefulTestCase.$$$reportNull$$$0(84);
        }
        KtUsefulTestCase.assertSameLines(null, expected, actual2);
    }

    public static void assertSameLines(@Nullable String message, @NotNull String expected, @NotNull String actual2) {
        if (expected == null) {
            KtUsefulTestCase.$$$reportNull$$$0(85);
        }
        if (actual2 == null) {
            KtUsefulTestCase.$$$reportNull$$$0(86);
        }
        String expectedText = StringUtil.convertLineSeparators((String)expected.trim());
        String actualText = StringUtil.convertLineSeparators((String)actual2.trim());
        Assert.assertEquals((String)message, (Object)expectedText, (Object)actualText);
    }

    public static void assertExists(@NotNull File file) {
        if (file == null) {
            KtUsefulTestCase.$$$reportNull$$$0(87);
        }
        KtUsefulTestCase.assertTrue((String)("File should exist " + file), (boolean)file.exists());
    }

    public static void assertDoesntExist(@NotNull File file) {
        if (file == null) {
            KtUsefulTestCase.$$$reportNull$$$0(88);
        }
        KtUsefulTestCase.assertFalse((String)("File should not exist " + file), (boolean)file.exists());
    }

    @NotNull
    protected String getTestName(boolean lowercaseFirstLetter) {
        return KtUsefulTestCase.getTestName(this.getName(), lowercaseFirstLetter);
    }

    @NotNull
    public static String getTestName(@Nullable String name, boolean lowercaseFirstLetter) {
        String string = name == null ? "" : PlatformTestUtil.getTestName((String)name, (boolean)lowercaseFirstLetter);
        if (string == null) {
            KtUsefulTestCase.$$$reportNull$$$0(89);
        }
        return string;
    }

    @NotNull
    protected String getTestDirectoryName() {
        String testName = this.getTestName(true);
        String string = testName.replaceAll("_.*", "");
        if (string == null) {
            KtUsefulTestCase.$$$reportNull$$$0(90);
        }
        return string;
    }

    public static void assertSameLinesWithFile(@NotNull String filePath, @NotNull String actualText) {
        if (filePath == null) {
            KtUsefulTestCase.$$$reportNull$$$0(91);
        }
        if (actualText == null) {
            KtUsefulTestCase.$$$reportNull$$$0(92);
        }
        KtUsefulTestCase.assertSameLinesWithFile(filePath, actualText, true);
    }

    public static void assertSameLinesWithFile(@NotNull String filePath, @NotNull String actualText, @NotNull Supplier<String> messageProducer) {
        if (filePath == null) {
            KtUsefulTestCase.$$$reportNull$$$0(93);
        }
        if (actualText == null) {
            KtUsefulTestCase.$$$reportNull$$$0(94);
        }
        if (messageProducer == null) {
            KtUsefulTestCase.$$$reportNull$$$0(95);
        }
        KtUsefulTestCase.assertSameLinesWithFile(filePath, actualText, true, messageProducer);
    }

    public static void assertSameLinesWithFile(@NotNull String filePath, @NotNull String actualText, boolean trimBeforeComparing) {
        if (filePath == null) {
            KtUsefulTestCase.$$$reportNull$$$0(96);
        }
        if (actualText == null) {
            KtUsefulTestCase.$$$reportNull$$$0(97);
        }
        KtUsefulTestCase.assertSameLinesWithFile(filePath, actualText, trimBeforeComparing, null);
    }

    public static void assertSameLinesWithFile(@NotNull String filePath, @NotNull String actualText, boolean trimBeforeComparing, @Nullable Supplier<String> messageProducer) {
        String fileText;
        if (filePath == null) {
            KtUsefulTestCase.$$$reportNull$$$0(98);
        }
        if (actualText == null) {
            KtUsefulTestCase.$$$reportNull$$$0(99);
        }
        try {
            if (OVERWRITE_TESTDATA) {
                VfsTestUtil.overwriteTestData((String)filePath, (String)actualText);
                System.out.println("File " + filePath + " created.");
            }
            fileText = FileUtil.loadFile((File)new File(filePath), (Charset)StandardCharsets.UTF_8);
        }
        catch (FileNotFoundException e) {
            VfsTestUtil.overwriteTestData((String)filePath, (String)actualText);
            throw new AssertionFailedError("No output text found. File " + filePath + " created.");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String expected = StringUtil.convertLineSeparators((String)(trimBeforeComparing ? fileText.trim() : fileText));
        String actual2 = StringUtil.convertLineSeparators((String)(trimBeforeComparing ? actualText.trim() : actualText));
        if (!Comparing.equal((String)expected, (String)actual2)) {
            throw new FileComparisonFailure(messageProducer == null ? null : messageProducer.get(), expected, actual2, filePath);
        }
    }

    protected static void clearFields(@NotNull Object test2) throws IllegalAccessException {
        if (test2 == null) {
            KtUsefulTestCase.$$$reportNull$$$0(100);
        }
        for (Class<?> aClass = test2.getClass(); aClass != null; aClass = aClass.getSuperclass()) {
            KtUsefulTestCase.clearDeclaredFields(test2, aClass);
        }
    }

    public static void clearDeclaredFields(@NotNull Object test2, @NotNull Class<?> aClass) throws IllegalAccessException {
        if (test2 == null) {
            KtUsefulTestCase.$$$reportNull$$$0(101);
        }
        if (aClass == null) {
            KtUsefulTestCase.$$$reportNull$$$0(102);
        }
        for (Field field : aClass.getDeclaredFields()) {
            int modifiers;
            String name = field.getDeclaringClass().getName();
            if (name.startsWith("junit.framework.") || name.startsWith("com.intellij.testFramework.") || ((modifiers = field.getModifiers()) & 0x10) != 0 || (modifiers & 8) != 0 || field.getType().isPrimitive()) continue;
            field.setAccessible(true);
            field.set(test2, null);
        }
    }

    private static void checkCodeStyleSettingsEqual(@NotNull CodeStyleSettings expected, @NotNull CodeStyleSettings settings) {
        if (expected == null) {
            KtUsefulTestCase.$$$reportNull$$$0(103);
        }
        if (settings == null) {
            KtUsefulTestCase.$$$reportNull$$$0(104);
        }
        if (!expected.equals((Object)settings)) {
            Element oldS = new Element("temp");
            expected.writeExternal(oldS);
            Element newS = new Element("temp");
            settings.writeExternal(newS);
            String newString = JDOMUtil.writeElement((Element)newS);
            String oldString = JDOMUtil.writeElement((Element)oldS);
            Assert.assertEquals((String)"Code style settings damaged", (Object)oldString, (Object)newString);
        }
    }

    private static void checkCodeInsightSettingsEqual(@NotNull CodeInsightSettings oldSettings, @NotNull CodeInsightSettings settings) {
        if (oldSettings == null) {
            KtUsefulTestCase.$$$reportNull$$$0(105);
        }
        if (settings == null) {
            KtUsefulTestCase.$$$reportNull$$$0(106);
        }
        if (!oldSettings.equals((Object)settings)) {
            Element newS = new Element("temp");
            settings.writeExternal(newS);
            Assert.assertEquals((String)"Code insight settings damaged", (Object)DEFAULT_SETTINGS_EXTERNALIZED, (Object)JDOMUtil.writeElement((Element)newS));
        }
    }

    public boolean isPerformanceTest() {
        String testName = this.getName();
        String className = ((Object)((Object)this)).getClass().getSimpleName();
        return TestFrameworkUtil.isPerformanceTest((String)testName, (String)className);
    }

    public boolean isStressTest() {
        return KtUsefulTestCase.isStressTest(this.getName(), ((Object)((Object)this)).getClass().getName());
    }

    private static boolean isStressTest(String testName, String className) {
        return TestFrameworkUtil.isPerformanceTest((String)testName, (String)className) || KtUsefulTestCase.containsStressWords(testName) || KtUsefulTestCase.containsStressWords(className);
    }

    private static boolean containsStressWords(@Nullable String name) {
        return name != null && (name.contains("Stress") || name.contains("Slow"));
    }

    public static void doPostponedFormatting(@NotNull Project project) {
        if (project == null) {
            KtUsefulTestCase.$$$reportNull$$$0(107);
        }
        DocumentUtil.writeInRunUndoTransparentAction(() -> {
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            PostprocessReformattingAspect.getInstance((Project)project).doPostponedFormatting();
        });
    }

    protected void assertException(@NotNull AbstractExceptionCase<?> exceptionCase) {
        if (exceptionCase == null) {
            KtUsefulTestCase.$$$reportNull$$$0(108);
        }
        this.assertException(exceptionCase, null);
    }

    protected void assertException(@NotNull AbstractExceptionCase exceptionCase, @Nullable String expectedErrorMsg) {
        if (exceptionCase == null) {
            KtUsefulTestCase.$$$reportNull$$$0(109);
        }
        KtUsefulTestCase.assertExceptionOccurred(true, exceptionCase, expectedErrorMsg);
    }

    public static <T extends Throwable> void assertThrows(@NotNull Class<? extends Throwable> exceptionClass, @NotNull ThrowableRunnable<T> runnable) {
        if (exceptionClass == null) {
            KtUsefulTestCase.$$$reportNull$$$0(110);
        }
        if (runnable == null) {
            KtUsefulTestCase.$$$reportNull$$$0(111);
        }
        KtUsefulTestCase.assertThrows(exceptionClass, null, runnable);
    }

    public static <T extends Throwable> void assertThrows(final @NotNull Class<? extends Throwable> exceptionClass, @Nullable String expectedErrorMsgPart, final @NotNull ThrowableRunnable<T> runnable) {
        if (exceptionClass == null) {
            KtUsefulTestCase.$$$reportNull$$$0(112);
        }
        if (runnable == null) {
            KtUsefulTestCase.$$$reportNull$$$0(113);
        }
        KtUsefulTestCase.assertExceptionOccurred(true, new AbstractExceptionCase(){

            public Class<Throwable> getExpectedExceptionClass() {
                return exceptionClass;
            }

            public void tryClosure() throws Throwable {
                runnable.run();
            }
        }, expectedErrorMsgPart);
    }

    protected <T extends Throwable> void assertNoException(@NotNull AbstractExceptionCase<T> exceptionCase) throws T {
        if (exceptionCase == null) {
            KtUsefulTestCase.$$$reportNull$$$0(114);
        }
        KtUsefulTestCase.assertExceptionOccurred(false, exceptionCase, null);
    }

    protected void assertNoThrowable(@NotNull Runnable closure) {
        if (closure == null) {
            KtUsefulTestCase.$$$reportNull$$$0(115);
        }
        String throwableName = null;
        try {
            closure.run();
        }
        catch (Throwable thr) {
            throwableName = thr.getClass().getName();
        }
        KtUsefulTestCase.assertNull(throwableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T extends Throwable> void assertExceptionOccurred(boolean shouldOccur, @NotNull AbstractExceptionCase<T> exceptionCase, String expectedErrorMsgPart) throws T {
        block10: {
            if (exceptionCase == null) {
                KtUsefulTestCase.$$$reportNull$$$0(116);
            }
            boolean wasThrown = false;
            try {
                exceptionCase.tryClosure();
            }
            catch (Throwable e) {
                Throwable cause = e;
                if (shouldOccur) {
                    wasThrown = true;
                    KtUsefulTestCase.assertInstanceOf(cause, exceptionCase.getExpectedExceptionClass());
                    if (expectedErrorMsgPart != null) {
                        KtUsefulTestCase.assertTrue((String)cause.getMessage(), (boolean)cause.getMessage().contains(expectedErrorMsgPart));
                    }
                    break block10;
                }
                if (exceptionCase.getExpectedExceptionClass().equals(cause.getClass())) {
                    wasThrown = true;
                    System.out.println();
                    e.printStackTrace(System.out);
                    KtUsefulTestCase.fail((String)("Exception isn't expected here. Exception message: " + cause.getMessage()));
                    break block10;
                }
                throw e;
            }
            finally {
                if (shouldOccur && !wasThrown) {
                    KtUsefulTestCase.fail((String)(exceptionCase.getExpectedExceptionClass().getName() + " must be thrown."));
                }
            }
        }
    }

    protected boolean annotatedWith(@NotNull Class<? extends Annotation> annotationClass) {
        if (annotationClass == null) {
            KtUsefulTestCase.$$$reportNull$$$0(117);
        }
        String methodName = "test" + this.getTestName(false);
        boolean methodChecked = false;
        for (Class<?> aClass = ((Object)((Object)this)).getClass(); aClass != null && aClass != Object.class; aClass = aClass.getSuperclass()) {
            Method method;
            if (aClass.getAnnotation(annotationClass) != null) {
                return true;
            }
            if (methodChecked || (method = ReflectionUtil.getDeclaredMethod(aClass, (String)methodName, (Class[])new Class[0])) == null) continue;
            if (method.getAnnotation(annotationClass) != null) {
                return true;
            }
            methodChecked = true;
        }
        return false;
    }

    @NotNull
    protected String getHomePath() {
        String string = PathManager.getHomePath().replace(File.separatorChar, '/');
        if (string == null) {
            KtUsefulTestCase.$$$reportNull$$$0(118);
        }
        return string;
    }

    public static void refreshRecursively(@NotNull VirtualFile file) {
        if (file == null) {
            KtUsefulTestCase.$$$reportNull$$$0(119);
        }
        VfsUtilCore.visitChildrenRecursively((VirtualFile)file, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file) {
                if (file == null) {
                    2.$$$reportNull$$$0(0);
                }
                file.getChildren();
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/kotlin/test/testFramework/KtUsefulTestCase$2", "visitFile"));
            }
        });
        file.refresh(false, true);
    }

    public static VirtualFile refreshAndFindFile(@NotNull File file) {
        if (file == null) {
            KtUsefulTestCase.$$$reportNull$$$0(120);
        }
        return (VirtualFile)UIUtil.invokeAndWaitIfNeeded(() -> LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file));
    }

    /*
     * WARNING - void declaration
     */
    public static void waitForAppLeakingThreads(long timeout, @NotNull TimeUnit timeUnit) {
        void timeUnit2;
        if (timeUnit == null) {
            KtUsefulTestCase.$$$reportNull$$$0(121);
        }
        EdtTestUtil.runInEdtAndWait(() -> KtUsefulTestCase.lambda$waitForAppLeakingThreads$13(timeout, (TimeUnit)timeUnit2));
    }

    private static /* synthetic */ void lambda$waitForAppLeakingThreads$13(long timeout, TimeUnit timeUnit) throws Throwable {
        Application app = ApplicationManager.getApplication();
        if (app != null && !app.isDisposed()) {
            DocumentCommitThread commitThread;
            FileBasedIndexImpl index = (FileBasedIndexImpl)app.getServiceIfCreated(FileBasedIndex.class);
            if (index != null) {
                index.getChangedFilesCollector().waitForVfsEventsExecuted(timeout, timeUnit);
            }
            if ((commitThread = (DocumentCommitThread)app.getServiceIfCreated(DocumentCommitProcessor.class)) != null) {
                commitThread.waitForAllCommits(timeout, timeUnit);
            }
        }
    }

    static {
        Class<?> aClass;
        IS_UNDER_TEAMCITY = System.getenv("TEAMCITY_VERSION") != null;
        OVERWRITE_TESTDATA = Boolean.getBoolean("idea.tests.overwrite.data");
        ORIGINAL_TEMP_DIR = FileUtil.getTempDirectory();
        TOTAL_SETUP_COST_MILLIS = new HashMap<String, Long>();
        TOTAL_TEARDOWN_COST_MILLIS = new HashMap<String, Long>();
        IdeaForkJoinWorkerThreadFactory.setupPoisonFactory();
        Logger.setFactory(TestLoggerFactory.class);
        LOG = Logger.getInstance(KtUsefulTestCase.class);
        defaultSettings = new CodeInsightSettings();
        System.setProperty("apple.awt.UIElement", "true");
        try {
            Element oldS = new Element("temp");
            defaultSettings.writeExternal(oldS);
            DEFAULT_SETTINGS_EXTERNALIZED = JDOMUtil.writeElement((Element)oldS);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        FlexibleTypeImpl.RUN_SLOW_ASSERTIONS = true;
        AbstractTypeChecker.RUN_SLOW_ASSERTIONS = true;
        try {
            aClass = Class.forName("java.io.DeleteOnExitHook");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Set files = (Set)ReflectionUtil.getStaticFieldValue(aClass, Set.class, (String)"files");
        DELETE_ON_EXIT_HOOK_CLASS = aClass;
        DELETE_ON_EXIT_HOOK_DOT_FILES = files;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 11: 
            case 62: 
            case 71: 
            case 82: 
            case 89: 
            case 90: 
            case 118: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 11: 
            case 62: 
            case 71: 
            case 82: 
            case 89: 
            case 90: 
            case 118: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 3: 
            case 87: 
            case 88: 
            case 119: 
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldCodeStyleSettings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentCodeStyleSettings";
                break;
            }
            case 6: 
            case 11: 
            case 62: 
            case 71: 
            case 82: 
            case 89: 
            case 90: 
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/test/testFramework/KtUsefulTestCase";
                break;
            }
            case 7: 
            case 9: 
            case 111: 
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "costMap";
                break;
            }
            case 10: 
            case 35: 
            case 46: 
            case 48: 
            case 50: 
            case 52: 
            case 54: 
            case 56: 
            case 58: 
            case 60: 
            case 63: 
            case 65: 
            case 67: 
            case 72: 
            case 76: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 21: 
            case 23: 
            case 26: 
            case 29: 
            case 37: 
            case 39: 
            case 41: 
            case 44: 
            case 84: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actual";
                break;
            }
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 22: 
            case 24: 
            case 27: 
            case 30: 
            case 38: 
            case 40: 
            case 42: 
            case 45: 
            case 47: 
            case 49: 
            case 51: 
            case 53: 
            case 83: 
            case 85: 
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expected";
                break;
            }
            case 20: 
            case 25: 
            case 28: 
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMsg";
                break;
            }
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a1";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a2";
                break;
            }
            case 36: 
            case 64: 
            case 66: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkers";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 55: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 57: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notExpected";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 70: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ts";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 75: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 91: 
            case 93: 
            case 96: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 92: 
            case 94: 
            case 97: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualText";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageProducer";
                break;
            }
            case 100: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "test";
                break;
            }
            case 104: 
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldSettings";
                break;
            }
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 108: 
            case 109: 
            case 114: 
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionCase";
                break;
            }
            case 110: 
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionClass";
                break;
            }
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closure";
                break;
            }
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationClass";
                break;
            }
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeUnit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/test/testFramework/KtUsefulTestCase";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestRootDisposable";
                break;
            }
            case 11: 
            case 62: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 71: {
                objectArray = objectArray2;
                objectArray2[1] = "assertInstanceOf";
                break;
            }
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "disposeOnTearDown";
                break;
            }
            case 89: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestName";
                break;
            }
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestDirectoryName";
                break;
            }
            case 118: {
                objectArray = objectArray2;
                objectArray2[1] = "getHomePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addSuppressedException";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addTmpFileToKeep";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "shouldKeepTmpFile";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doCheckForSettingsDamage";
                break;
            }
            case 6: 
            case 11: 
            case 62: 
            case 71: 
            case 82: 
            case 89: 
            case 90: 
            case 118: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invokeTestRunnable";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "logPerClassCost";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "edt";
                break;
            }
            case 10: 
            case 54: 
            case 55: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "toString";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "assertOrderedEquals";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "equals";
                break;
            }
            case 35: 
            case 36: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "assertOrderedCollection";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "assertSameElements";
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "assertContainsOrdered";
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "assertContainsElements";
                break;
            }
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "assertDoesntContain";
                break;
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "assertUnorderedCollection";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "accepts";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "assertInstanceOf";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "assertOneElement";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "assertOneOf";
                break;
            }
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "assertEmpty";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "assertSize";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "disposeOnTearDown";
                break;
            }
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "assertSameLines";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "assertExists";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "assertDoesntExist";
                break;
            }
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "assertSameLinesWithFile";
                break;
            }
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "clearFields";
                break;
            }
            case 101: 
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "clearDeclaredFields";
                break;
            }
            case 103: 
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "checkCodeStyleSettingsEqual";
                break;
            }
            case 105: 
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "checkCodeInsightSettingsEqual";
                break;
            }
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "doPostponedFormatting";
                break;
            }
            case 108: 
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "assertException";
                break;
            }
            case 110: 
            case 111: 
            case 112: 
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "assertThrows";
                break;
            }
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "assertNoException";
                break;
            }
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "assertNoThrowable";
                break;
            }
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "assertExceptionOccurred";
                break;
            }
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "annotatedWith";
                break;
            }
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "refreshRecursively";
                break;
            }
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndFindFile";
                break;
            }
            case 121: {
                objectArray = objectArray;
                objectArray[2] = "waitForAppLeakingThreads";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 11: 
            case 62: 
            case 71: 
            case 82: 
            case 89: 
            case 90: 
            case 118: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected class TestDisposable
    implements Disposable {
        private volatile boolean myDisposed;

        public void dispose() {
            this.myDisposed = true;
        }

        public boolean isDisposed() {
            return this.myDisposed;
        }

        public String toString() {
            String testName = KtUsefulTestCase.this.getTestName(false);
            return ((Object)((Object)KtUsefulTestCase.this)).getClass() + (StringUtil.isEmpty((String)testName) ? "" : ".test" + testName);
        }
    }
}

