/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.TestHelperGeneratorKt;
import org.jetbrains.kotlin.TestsCompilerError;
import org.jetbrains.kotlin.TestsCompiletimeError;
import org.jetbrains.kotlin.backend.common.output.OutputFile;
import org.jetbrains.kotlin.backend.common.output.OutputFileCollection;
import org.jetbrains.kotlin.backend.common.output.SimpleOutputFileCollection;
import org.jetbrains.kotlin.checkers.utils.CheckerTestUtil;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.output.OutputUtilsKt;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.compiler.NoScopeRecordCliBindingTrace;
import org.jetbrains.kotlin.cli.jvm.config.JvmClasspathRoot;
import org.jetbrains.kotlin.codegen.ClassBuilderFactories;
import org.jetbrains.kotlin.codegen.ClassBuilderFactory;
import org.jetbrains.kotlin.codegen.ClassFileFactory;
import org.jetbrains.kotlin.codegen.ClassFileUtilsKt;
import org.jetbrains.kotlin.codegen.CodegenTestFiles;
import org.jetbrains.kotlin.codegen.CodegenTestUtil;
import org.jetbrains.kotlin.codegen.D8Checker;
import org.jetbrains.kotlin.codegen.DxChecker;
import org.jetbrains.kotlin.codegen.GeneratedClassLoader;
import org.jetbrains.kotlin.codegen.GenerationUtils;
import org.jetbrains.kotlin.codegen.TestUtilsKt;
import org.jetbrains.kotlin.codegen.forTestCompile.ForTestCompileRuntime;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.scripting.definitions.ScriptDependenciesProvider;
import org.jetbrains.kotlin.scripting.resolve.ScriptCompilationConfigurationWrapper;
import org.jetbrains.kotlin.test.ConfigurationKind;
import org.jetbrains.kotlin.test.Directives;
import org.jetbrains.kotlin.test.InTextDirectivesUtils;
import org.jetbrains.kotlin.test.KotlinBaseTest;
import org.jetbrains.kotlin.test.KotlinTestUtils;
import org.jetbrains.kotlin.test.TargetBackend;
import org.jetbrains.kotlin.test.TestFiles;
import org.jetbrains.kotlin.test.TestJdkKind;
import org.jetbrains.kotlin.test.clientserver.TestProcessServerKt;
import org.jetbrains.kotlin.test.clientserver.TestProxy;
import org.jetbrains.kotlin.utils.ExceptionUtilsKt;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.tree.ClassNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.Analyzer;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jetbrains.org.objectweb.asm.tree.analysis.Interpreter;
import org.jetbrains.org.objectweb.asm.tree.analysis.SimpleVerifier;
import org.jetbrains.org.objectweb.asm.util.Printer;
import org.jetbrains.org.objectweb.asm.util.Textifier;
import org.jetbrains.org.objectweb.asm.util.TraceMethodVisitor;

public abstract class CodegenTestCase
extends KotlinBaseTest<KotlinBaseTest.TestFile> {
    private static final String DEFAULT_TEST_FILE_NAME = "a_test";
    private static final String DEFAULT_JVM_TARGET = System.getProperty("kotlin.test.default.jvm.target");
    public static final String BOX_IN_SEPARATE_PROCESS_PORT = System.getProperty("kotlin.test.box.in.separate.process.port");
    private static final String JAVA_COMPILATION_TARGET = System.getProperty("kotlin.test.java.compilation.target");
    protected KotlinCoreEnvironment myEnvironment;
    protected CodegenTestFiles myFiles;
    protected ClassFileFactory classFileFactory;
    protected GeneratedClassLoader initializedClassLoader;
    protected File javaClassesOutputDirectory = null;
    protected List<File> additionalDependencies = null;
    protected ConfigurationKind configurationKind = ConfigurationKind.JDK_ONLY;
    private static final boolean IS_SOURCE_6_STILL_SUPPORTED = Arrays.asList("1.6", "1.7", "1.8", "9", "10", "11").contains(System.getProperty("java.specification.version"));

    protected final void createEnvironmentWithMockJdkAndIdeaAnnotations(@NotNull ConfigurationKind configurationKind, File ... javaSourceRoots) {
        if (configurationKind == null) {
            CodegenTestCase.$$$reportNull$$$0(0);
        }
        if (javaSourceRoots == null) {
            CodegenTestCase.$$$reportNull$$$0(1);
        }
        this.createEnvironmentWithMockJdkAndIdeaAnnotations(configurationKind, Collections.emptyList(), TestJdkKind.MOCK_JDK, javaSourceRoots);
    }

    protected final void createEnvironmentWithMockJdkAndIdeaAnnotations(@NotNull ConfigurationKind configurationKind, @NotNull List<KotlinBaseTest.TestFile> testFilesWithConfigurationDirectives, @NotNull TestJdkKind testJdkKind, File ... javaSourceRoots) {
        if (configurationKind == null) {
            CodegenTestCase.$$$reportNull$$$0(2);
        }
        if (testFilesWithConfigurationDirectives == null) {
            CodegenTestCase.$$$reportNull$$$0(3);
        }
        if (testJdkKind == null) {
            CodegenTestCase.$$$reportNull$$$0(4);
        }
        if (javaSourceRoots == null) {
            CodegenTestCase.$$$reportNull$$$0(5);
        }
        if (this.myEnvironment != null) {
            throw new IllegalStateException("must not set up myEnvironment twice");
        }
        CompilerConfiguration configuration = this.createConfiguration(configurationKind, testJdkKind, this.getBackend(), Collections.singletonList(KotlinTestUtils.getAnnotationsJar()), ArraysKt.filterNotNull((Object[])javaSourceRoots), testFilesWithConfigurationDirectives);
        this.myEnvironment = KotlinCoreEnvironment.createForTests((Disposable)this.getTestRootDisposable(), (CompilerConfiguration)configuration, (EnvironmentConfigFiles)EnvironmentConfigFiles.JVM_CONFIG_FILES);
        this.setupEnvironment(this.myEnvironment);
    }

    @Override
    protected void tearDown() throws Exception {
        this.myFiles = null;
        this.myEnvironment = null;
        this.classFileFactory = null;
        if (this.initializedClassLoader != null) {
            this.initializedClassLoader.dispose();
            this.initializedClassLoader = null;
        }
        super.tearDown();
    }

    protected void loadText(@NotNull String text) {
        if (text == null) {
            CodegenTestCase.$$$reportNull$$$0(6);
        }
        this.myFiles = CodegenTestFiles.create("a_test.kt", text, this.myEnvironment.getProject());
    }

    @NotNull
    protected String loadFile(@NotNull String name) {
        if (name == null) {
            CodegenTestCase.$$$reportNull$$$0(7);
        }
        String string = this.loadFileByFullPath(KotlinTestUtils.getTestDataPathBase() + "/codegen/" + name);
        if (string == null) {
            CodegenTestCase.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    protected String loadFileByFullPath(@NotNull String fullPath) {
        String string;
        if (fullPath == null) {
            CodegenTestCase.$$$reportNull$$$0(9);
        }
        try {
            File file = new File(fullPath);
            String content2 = FileUtil.loadFile((File)file, (String)Charsets.UTF_8.name(), (boolean)true);
            assert (this.myFiles == null) : "Should not initialize myFiles twice";
            this.myFiles = CodegenTestFiles.create(file.getName(), content2, this.myEnvironment.getProject());
            string = content2;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (string == null) {
            CodegenTestCase.$$$reportNull$$$0(10);
        }
        return string;
    }

    protected void loadFiles(String ... names) {
        if (names == null) {
            CodegenTestCase.$$$reportNull$$$0(11);
        }
        this.myFiles = CodegenTestFiles.create(this.myEnvironment.getProject(), names);
    }

    protected void loadFile() {
        this.loadFile(this.getPrefix() + "/" + this.getTestName(true) + ".kt");
    }

    protected void loadMultiFiles(@NotNull List<KotlinBaseTest.TestFile> files) {
        if (files == null) {
            CodegenTestCase.$$$reportNull$$$0(12);
        }
        this.myFiles = CodegenTestCase.loadMultiFiles(files, this.myEnvironment.getProject());
    }

    @NotNull
    public static CodegenTestFiles loadMultiFiles(@NotNull List<KotlinBaseTest.TestFile> files, @NotNull Project project) {
        if (files == null) {
            CodegenTestCase.$$$reportNull$$$0(13);
        }
        if (project == null) {
            CodegenTestCase.$$$reportNull$$$0(14);
        }
        Collections.sort(files);
        ArrayList<KtFile> ktFiles = new ArrayList<KtFile>(files.size());
        for (KotlinBaseTest.TestFile file : files) {
            if (!file.name.endsWith(".kt") && !file.name.endsWith(".kts")) continue;
            String content2 = CheckerTestUtil.INSTANCE.parseDiagnosedRanges(file.content, new ArrayList(0), null);
            ktFiles.add(KotlinTestUtils.createFile(file.name, content2, project));
        }
        CodegenTestFiles codegenTestFiles = CodegenTestFiles.create(ktFiles);
        if (codegenTestFiles == null) {
            CodegenTestCase.$$$reportNull$$$0(15);
        }
        return codegenTestFiles;
    }

    @NotNull
    protected String codegenTestBasePath() {
        return "compiler/testData/codegen/";
    }

    @NotNull
    protected String relativePath(@NotNull File file) {
        if (file == null) {
            CodegenTestCase.$$$reportNull$$$0(16);
        }
        String string = FilesKt.toRelativeString((File)file.getAbsoluteFile(), (File)new File(this.codegenTestBasePath()).getAbsoluteFile());
        if (string == null) {
            CodegenTestCase.$$$reportNull$$$0(17);
        }
        return string;
    }

    @NotNull
    protected String getPrefix() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    protected GeneratedClassLoader generateAndCreateClassLoader(boolean reportProblems) {
        if (this.initializedClassLoader != null) {
            CodegenTestCase.fail((String)"Double initialization of class loader in same test");
        }
        this.initializedClassLoader = this.createClassLoader();
        if (!CodegenTestCase.verifyAllFilesWithAsm(this.generateClassesInFile(reportProblems), (ClassLoader)this.initializedClassLoader, reportProblems)) {
            CodegenTestCase.fail((String)"Verification failed: see exceptions above");
        }
        GeneratedClassLoader generatedClassLoader = this.initializedClassLoader;
        if (generatedClassLoader == null) {
            CodegenTestCase.$$$reportNull$$$0(18);
        }
        return generatedClassLoader;
    }

    @NotNull
    protected GeneratedClassLoader createClassLoader() {
        ClassLoader classLoader = this.configurationKind.getWithReflection() ? ForTestCompileRuntime.runtimeAndReflectJarClassLoader() : ForTestCompileRuntime.runtimeJarClassLoader();
        return new GeneratedClassLoader(this.generateClassesInFile(), classLoader, this.getClassPathURLs());
    }

    @NotNull
    protected URL[] getClassPathURLs() {
        URL[] result;
        block6: {
            ArrayList<File> files = new ArrayList<File>();
            if (this.javaClassesOutputDirectory != null) {
                files.add(this.javaClassesOutputDirectory);
            }
            if (this.additionalDependencies != null) {
                files.addAll(this.additionalDependencies);
            }
            files.addAll(this.getExtraDependenciesFromKotlinCompileClasspath());
            ScriptDependenciesProvider externalImportsProvider = ScriptDependenciesProvider.Companion.getInstance(this.myEnvironment.getProject());
            if (externalImportsProvider != null) {
                this.myEnvironment.getSourceFiles().forEach(file -> {
                    ScriptCompilationConfigurationWrapper refinedConfiguration = externalImportsProvider.getScriptConfiguration(file);
                    if (refinedConfiguration != null) {
                        files.addAll(refinedConfiguration.getDependenciesClassPath());
                    }
                });
            }
            try {
                result = new URL[files.size()];
                for (int i = 0; i < files.size(); ++i) {
                    result[i] = ((File)files.get(i)).toURI().toURL();
                }
                if (result != null) break block6;
            }
            catch (MalformedURLException e) {
                throw ExceptionUtilsKt.rethrow((Throwable)e);
            }
            CodegenTestCase.$$$reportNull$$$0(19);
        }
        return result;
    }

    private Set<File> getExtraDependenciesFromKotlinCompileClasspath() {
        List includeFromCompileClasspath = CollectionsKt.listOf((Object)ForTestCompileRuntime.coroutinesCompatForTests());
        List compileClasspath = CollectionsKt.map((Iterable)CollectionsKt.filterIsInstance((Iterable)((Iterable)this.myEnvironment.getConfiguration().get(CLIConfigurationKeys.CONTENT_ROOTS)), JvmClasspathRoot.class), JvmClasspathRoot::getFile);
        return CollectionsKt.intersect((Iterable)compileClasspath, (Iterable)includeFromCompileClasspath);
    }

    @NotNull
    protected String generateToText() {
        String string = this.generateToText(null);
        if (string == null) {
            CodegenTestCase.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    protected String generateToText(@Nullable String ignorePathPrefix) {
        if (this.classFileFactory == null) {
            this.classFileFactory = CodegenTestUtil.generateFiles(this.myEnvironment, this.myFiles);
        }
        String string = this.classFileFactory.createText(ignorePathPrefix);
        if (string == null) {
            CodegenTestCase.$$$reportNull$$$0(21);
        }
        return string;
    }

    @NotNull
    protected Map<String, String> generateEachFileToText() {
        if (this.classFileFactory == null) {
            this.classFileFactory = CodegenTestUtil.generateFiles(this.myEnvironment, this.myFiles);
        }
        Map map = this.classFileFactory.createTextForEachFile();
        if (map == null) {
            CodegenTestCase.$$$reportNull$$$0(22);
        }
        return map;
    }

    @NotNull
    protected Class<?> generateFacadeClass() {
        FqName facadeClassFqName = JvmFileClassUtil.getFileClassInfoNoResolve((KtFile)this.myFiles.getPsiFile()).getFacadeClassFqName();
        Class<?> clazz = this.generateClass(facadeClassFqName.asString());
        if (clazz == null) {
            CodegenTestCase.$$$reportNull$$$0(23);
        }
        return clazz;
    }

    @NotNull
    protected Class<?> generateClass(@NotNull String name) {
        if (name == null) {
            CodegenTestCase.$$$reportNull$$$0(24);
        }
        Class<?> clazz = this.generateClass(name, true);
        if (clazz == null) {
            CodegenTestCase.$$$reportNull$$$0(25);
        }
        return clazz;
    }

    @NotNull
    protected Class<?> generateClass(@NotNull String name, boolean reportProblems) {
        Class clazz;
        if (name == null) {
            CodegenTestCase.$$$reportNull$$$0(26);
        }
        try {
            clazz = this.generateAndCreateClassLoader(reportProblems).loadClass(name);
        }
        catch (ClassNotFoundException e) {
            CodegenTestCase.fail((String)("No class file was generated for: " + name));
            if (null == null) {
                CodegenTestCase.$$$reportNull$$$0(28);
            }
            return null;
        }
        if (clazz == null) {
            CodegenTestCase.$$$reportNull$$$0(27);
        }
        return clazz;
    }

    @NotNull
    protected ClassFileFactory generateClassesInFile() {
        return this.generateClassesInFile(true);
    }

    @NotNull
    private ClassFileFactory generateClassesInFile(boolean reportProblems) {
        if (this.classFileFactory != null) {
            ClassFileFactory classFileFactory = this.classFileFactory;
            if (classFileFactory == null) {
                CodegenTestCase.$$$reportNull$$$0(29);
            }
            return classFileFactory;
        }
        try {
            GenerationState generationState = GenerationUtils.compileFiles(this.myFiles.getPsiFiles(), this.myEnvironment, this.getClassBuilderFactory(), (BindingTrace)new NoScopeRecordCliBindingTrace());
            this.classFileFactory = generationState.getFactory();
            boolean ignoreDexing = this.myFiles.getPsiFiles().stream().anyMatch(it -> InTextDirectivesUtils.isDirectiveDefined(it.getText(), "IGNORE_DEXING"));
            if (this.verifyWithDex() && !ignoreDexing) {
                DxChecker.check(this.classFileFactory);
                D8Checker.check(this.classFileFactory);
            }
        }
        catch (TestsCompiletimeError e) {
            if (reportProblems) {
                e.getOriginal().printStackTrace();
                this.generateInstructionsAsText();
                System.err.println("See exceptions above");
            } else {
                System.err.println("Compilation failure");
            }
            throw e;
        }
        catch (Throwable e) {
            if (reportProblems) {
                this.generateInstructionsAsText();
            }
            throw new TestsCompilerError(e);
        }
        ClassFileFactory classFileFactory = this.classFileFactory;
        if (classFileFactory == null) {
            CodegenTestCase.$$$reportNull$$$0(30);
        }
        return classFileFactory;
    }

    private void generateInstructionsAsText() {
        System.err.println("Generating instructions as text...");
        try {
            if (this.classFileFactory == null) {
                System.err.println("Cannot generate text: exception was thrown during generation");
            } else {
                System.err.println(this.classFileFactory.createText());
            }
        }
        catch (Throwable e1) {
            System.err.println("Exception thrown while trying to generate text, the actual exception follows:");
            e1.printStackTrace();
            System.err.println("-----------------------------------------------------------------------------");
        }
    }

    protected boolean verifyWithDex() {
        return true;
    }

    private static boolean verifyAllFilesWithAsm(ClassFileFactory factory, ClassLoader loader, boolean reportProblems) {
        boolean noErrors = true;
        for (OutputFile file : ClassFileUtilsKt.getClassFiles((ClassFileFactory)factory)) {
            noErrors &= CodegenTestCase.verifyWithAsm(file, loader, reportProblems);
        }
        return noErrors;
    }

    private static boolean verifyWithAsm(@NotNull OutputFile file, ClassLoader loader, boolean reportProblems) {
        if (file == null) {
            CodegenTestCase.$$$reportNull$$$0(31);
        }
        ClassNode classNode = new ClassNode();
        new ClassReader(file.asByteArray()).accept((ClassVisitor)classNode, 0);
        SimpleVerifier verifier = new SimpleVerifier();
        verifier.setClassLoader(loader);
        Analyzer analyzer = new Analyzer((Interpreter)verifier);
        boolean noErrors = true;
        for (MethodNode method : classNode.methods) {
            try {
                analyzer.analyze(classNode.name, method);
            }
            catch (Throwable e) {
                if (reportProblems) {
                    System.err.println(file.asText());
                    System.err.println(classNode.name + "::" + method.name + method.desc);
                    if (e instanceof AnalyzerException) {
                        TraceMethodVisitor tmv = new TraceMethodVisitor((Printer)new Textifier());
                        ((AnalyzerException)e).node.accept((MethodVisitor)tmv);
                        PrintWriter pw = new PrintWriter(System.err);
                        tmv.p.print(pw);
                        pw.flush();
                    }
                    e.printStackTrace();
                }
                noErrors = false;
            }
        }
        return noErrors;
    }

    @NotNull
    protected Method generateFunction() {
        Method method;
        Class<?> aClass = this.generateFacadeClass();
        try {
            method = CodegenTestUtil.findTheOnlyMethod(aClass);
        }
        catch (Error e) {
            System.out.println(this.generateToText());
            throw e;
        }
        if (method == null) {
            CodegenTestCase.$$$reportNull$$$0(32);
        }
        return method;
    }

    @NotNull
    protected Method generateFunction(@NotNull String name) {
        if (name == null) {
            CodegenTestCase.$$$reportNull$$$0(33);
        }
        Method method = CodegenTestUtil.findDeclaredMethodByName(this.generateFacadeClass(), name);
        if (method == null) {
            CodegenTestCase.$$$reportNull$$$0(34);
        }
        return method;
    }

    @Override
    protected void updateConfiguration(@NotNull CompilerConfiguration configuration) {
        if (configuration == null) {
            CodegenTestCase.$$$reportNull$$$0(35);
        }
        CodegenTestCase.setCustomDefaultJvmTarget(configuration);
    }

    protected ClassBuilderFactory getClassBuilderFactory() {
        return ClassBuilderFactories.TEST;
    }

    private static void setCustomDefaultJvmTarget(CompilerConfiguration configuration) {
        if (DEFAULT_JVM_TARGET != null) {
            JvmTarget customDefaultTarget = JvmTarget.fromString((String)DEFAULT_JVM_TARGET);
            assert (customDefaultTarget != null) : "Can't construct JvmTarget for " + DEFAULT_JVM_TARGET;
            JvmTarget originalTarget = (JvmTarget)configuration.get(JVMConfigurationKeys.JVM_TARGET);
            if (originalTarget == null || customDefaultTarget.getMajorVersion() > originalTarget.getMajorVersion()) {
                configuration.put(JVMConfigurationKeys.JVM_TARGET, (Object)customDefaultTarget);
            }
        }
    }

    protected void compile(@NotNull List<KotlinBaseTest.TestFile> files) {
        if (files == null) {
            CodegenTestCase.$$$reportNull$$$0(36);
        }
        this.compile(files, true, false);
    }

    protected void compile(@NotNull List<KotlinBaseTest.TestFile> files, boolean reportProblems, boolean dumpKotlinFiles) {
        if (files == null) {
            CodegenTestCase.$$$reportNull$$$0(37);
        }
        File javaSourceDir = this.writeJavaFiles(files);
        this.configurationKind = this.extractConfigurationKind(files);
        boolean loadAndroidAnnotations = files.stream().anyMatch(it -> InTextDirectivesUtils.isDirectiveDefined(it.content, "ANDROID_ANNOTATIONS"));
        ArrayList<File> classpath = new ArrayList<File>();
        classpath.add(KotlinTestUtils.getAnnotationsJar());
        if (loadAndroidAnnotations) {
            classpath.add(ForTestCompileRuntime.androidAnnotationsForTests());
        }
        CompilerConfiguration configuration = this.createConfiguration(this.configurationKind, this.getTestJdkKind(files), this.getBackend(), classpath, ArraysKt.filterNotNull((Object[])new File[]{javaSourceDir}), files);
        this.myEnvironment = KotlinCoreEnvironment.createForTests((Disposable)this.getTestRootDisposable(), (CompilerConfiguration)configuration, (EnvironmentConfigFiles)EnvironmentConfigFiles.JVM_CONFIG_FILES);
        this.setupEnvironment(this.myEnvironment);
        this.loadMultiFiles(files);
        this.generateClassesInFile(reportProblems);
        boolean compileJavaFiles = javaSourceDir != null && this.javaClassesOutputDirectory == null;
        File kotlinOut = null;
        if (dumpKotlinFiles || compileJavaFiles) {
            kotlinOut = this.getKotlinClassesOutputDirectory();
            OutputUtilsKt.writeAllTo((OutputFileCollection)this.classFileFactory, (File)kotlinOut);
        }
        if (compileJavaFiles) {
            ArrayList<String> javaClasspath = new ArrayList<String>();
            javaClasspath.add(kotlinOut.getPath());
            if (loadAndroidAnnotations) {
                javaClasspath.add(ForTestCompileRuntime.androidAnnotationsForTests().getPath());
            }
            javaClasspath.addAll(CollectionsKt.map(this.getExtraDependenciesFromKotlinCompileClasspath(), File::getPath));
            this.updateJavaClasspath(javaClasspath);
            this.javaClassesOutputDirectory = this.getJavaClassesOutputDirectory();
            List<String> javacOptions = CodegenTestCase.extractJavacOptions(files, (JvmTarget)configuration.get(JVMConfigurationKeys.JVM_TARGET), configuration.getBoolean(JVMConfigurationKeys.ENABLE_JVM_PREVIEW));
            List<String> finalJavacOptions = CodegenTestUtil.prepareJavacOptions(javaClasspath, javacOptions, this.javaClassesOutputDirectory);
            try {
                this.runJavacTask(CodegenTestUtil.findJavaSourcesInDirectory(javaSourceDir).stream().map(File::new).collect(Collectors.toList()), finalJavacOptions);
            }
            catch (IOException e) {
                throw ExceptionUtilsKt.rethrow((Throwable)e);
            }
        }
    }

    protected void runJavacTask(@NotNull Collection<File> files, @NotNull List<String> options) throws IOException {
        if (files == null) {
            CodegenTestCase.$$$reportNull$$$0(38);
        }
        if (options == null) {
            CodegenTestCase.$$$reportNull$$$0(39);
        }
        KotlinTestUtils.compileJavaFiles(files, options);
    }

    protected void updateJavaClasspath(@NotNull List<String> javaClasspath) {
        if (javaClasspath == null) {
            CodegenTestCase.$$$reportNull$$$0(40);
        }
    }

    @NotNull
    protected static List<String> extractJavacOptions(@NotNull List<KotlinBaseTest.TestFile> files, @Nullable JvmTarget kotlinTarget, boolean isJvmPreviewEnabled) {
        if (files == null) {
            CodegenTestCase.$$$reportNull$$$0(41);
        }
        ArrayList<String> javacOptions = new ArrayList<String>(0);
        for (KotlinBaseTest.TestFile file : files) {
            javacOptions.addAll(InTextDirectivesUtils.findListWithPrefixes(file.content, "// JAVAC_OPTIONS:"));
        }
        if (kotlinTarget != null && isJvmPreviewEnabled) {
            javacOptions.add("--release");
            javacOptions.add(kotlinTarget.getDescription());
            javacOptions.add("--enable-preview");
            ArrayList<String> arrayList = javacOptions;
            if (arrayList == null) {
                CodegenTestCase.$$$reportNull$$$0(42);
            }
            return arrayList;
        }
        String javaTarget = CodegenTestCase.computeJavaTarget(javacOptions, kotlinTarget);
        if (javaTarget != null) {
            javacOptions.add("-source");
            javacOptions.add(javaTarget);
            javacOptions.add("-target");
            javacOptions.add(javaTarget);
        }
        ArrayList<String> arrayList = javacOptions;
        if (arrayList == null) {
            CodegenTestCase.$$$reportNull$$$0(43);
        }
        return arrayList;
    }

    private static String computeJavaTarget(@NotNull List<String> javacOptions, @Nullable JvmTarget kotlinTarget) {
        if (javacOptions == null) {
            CodegenTestCase.$$$reportNull$$$0(44);
        }
        if (JAVA_COMPILATION_TARGET != null && !javacOptions.contains("-target")) {
            return JAVA_COMPILATION_TARGET;
        }
        if (kotlinTarget != null && kotlinTarget.compareTo((Enum)JvmTarget.JVM_1_6) > 0) {
            return kotlinTarget.getDescription();
        }
        if (IS_SOURCE_6_STILL_SUPPORTED) {
            return "1.6";
        }
        return null;
    }

    @Override
    @NotNull
    protected TargetBackend getBackend() {
        TargetBackend targetBackend = TargetBackend.JVM;
        if (targetBackend == null) {
            CodegenTestCase.$$$reportNull$$$0(45);
        }
        return targetBackend;
    }

    @Override
    protected void doTest(@NotNull String filePath) throws Exception {
        if (filePath == null) {
            CodegenTestCase.$$$reportNull$$$0(46);
        }
        File file = new File(filePath);
        String expectedText = KotlinTestUtils.doLoadFile(file);
        if (!this.coroutinesPackage.isEmpty()) {
            expectedText = expectedText.replace("COROUTINES_PACKAGE", this.coroutinesPackage);
        }
        List<KotlinBaseTest.TestFile> testFiles = this.createTestFilesFromFile(file, expectedText);
        this.doMultiFileTest(file, testFiles);
    }

    @Override
    protected void doTestWithCoroutinesPackageReplacement(@NotNull String filePath, @NotNull String packageName) throws Exception {
        if (filePath == null) {
            CodegenTestCase.$$$reportNull$$$0(47);
        }
        if (packageName == null) {
            CodegenTestCase.$$$reportNull$$$0(48);
        }
        this.coroutinesPackage = packageName;
        this.doTest(filePath);
    }

    @Override
    @NotNull
    protected List<KotlinBaseTest.TestFile> createTestFilesFromFile(@NotNull File file, @NotNull String expectedText) {
        if (file == null) {
            CodegenTestCase.$$$reportNull$$$0(49);
        }
        if (expectedText == null) {
            CodegenTestCase.$$$reportNull$$$0(50);
        }
        return CodegenTestCase.createTestFilesFromFile(file, expectedText, this.coroutinesPackage, this.parseDirectivesPerFiles(), this.getBackend());
    }

    @NotNull
    public static List<KotlinBaseTest.TestFile> createTestFilesFromFile(@NotNull File file, @NotNull String expectedText, @NotNull String coroutinesPackage, boolean parseDirectivesPerFiles, @NotNull TargetBackend backend) {
        if (file == null) {
            CodegenTestCase.$$$reportNull$$$0(51);
        }
        if (expectedText == null) {
            CodegenTestCase.$$$reportNull$$$0(52);
        }
        if (coroutinesPackage == null) {
            CodegenTestCase.$$$reportNull$$$0(53);
        }
        if (backend == null) {
            CodegenTestCase.$$$reportNull$$$0(54);
        }
        List<KotlinBaseTest.TestFile> testFiles = TestFiles.createTestFiles(file.getName(), expectedText, new TestFiles.TestFileFactoryNoModules<KotlinBaseTest.TestFile>(){

            @Override
            @NotNull
            public KotlinBaseTest.TestFile create(@NotNull String fileName, @NotNull String text, @NotNull Directives directives) {
                if (fileName == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (text == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (directives == null) {
                    1.$$$reportNull$$$0(2);
                }
                return new KotlinBaseTest.TestFile(fileName, text, directives);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "fileName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "text";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "directives";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/kotlin/codegen/CodegenTestCase$1";
                objectArray[2] = "create";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, false, coroutinesPackage, parseDirectivesPerFiles);
        if (InTextDirectivesUtils.isDirectiveDefined(expectedText, "WITH_HELPERS")) {
            testFiles.add(new KotlinBaseTest.TestFile("CodegenTestHelpers.kt", TestHelperGeneratorKt.createTextForCodegenTestHelpers(backend)));
        }
        List<KotlinBaseTest.TestFile> list = testFiles;
        if (list == null) {
            CodegenTestCase.$$$reportNull$$$0(55);
        }
        return list;
    }

    @NotNull
    protected File getJavaSourcesOutputDirectory() {
        return CodegenTestCase.createTempDirectory("java-files");
    }

    @NotNull
    protected File getJavaClassesOutputDirectory() {
        return CodegenTestCase.createTempDirectory("java-classes");
    }

    protected File getKotlinClassesOutputDirectory() {
        return CodegenTestCase.createTempDirectory(this.toString());
    }

    @NotNull
    private static File createTempDirectory(String prefix) {
        File file;
        try {
            file = KotlinTestUtils.tmpDir(prefix);
        }
        catch (IOException e) {
            throw ExceptionUtilsKt.rethrow((Throwable)e);
        }
        if (file == null) {
            CodegenTestCase.$$$reportNull$$$0(56);
        }
        return file;
    }

    @Nullable
    protected File writeJavaFiles(@NotNull List<KotlinBaseTest.TestFile> files) {
        List javaFiles;
        if (files == null) {
            CodegenTestCase.$$$reportNull$$$0(57);
        }
        if ((javaFiles = CollectionsKt.filter(files, file -> file.name.endsWith(".java"))).isEmpty()) {
            return null;
        }
        File dir = this.getJavaSourcesOutputDirectory();
        for (KotlinBaseTest.TestFile testFile : javaFiles) {
            File file2 = new File(dir, testFile.name);
            KotlinTestUtils.mkdirs(file2.getParentFile());
            FilesKt.writeText((File)file2, (String)testFile.content, (Charset)Charsets.UTF_8);
        }
        return dir;
    }

    protected void callBoxMethodAndCheckResult(URLClassLoader classLoader, String className) throws IOException, InvocationTargetException, IllegalAccessException {
        Class aClass = TestProcessServerKt.getGeneratedClass((ClassLoader)classLoader, (String)className);
        Method method = TestProcessServerKt.getBoxMethodOrNull((Class)aClass);
        CodegenTestCase.assertNotNull((String)("Can't find box method in " + aClass), (Object)method);
        this.callBoxMethodAndCheckResult(classLoader, aClass, method);
    }

    private void callBoxMethodAndCheckResult(URLClassLoader classLoader, Class<?> aClass, Method method) throws IOException, IllegalAccessException, InvocationTargetException {
        this.callBoxMethodAndCheckResult(classLoader, aClass, method, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void callBoxMethodAndCheckResult(URLClassLoader classLoader, Class<?> aClass, Method method, boolean unexpectedBehaviour) throws IOException, IllegalAccessException, InvocationTargetException {
        String result;
        if (BOX_IN_SEPARATE_PROCESS_PORT != null) {
            result = this.invokeBoxInSeparateProcess(classLoader, aClass);
        } else {
            ClassLoader savedClassLoader = Thread.currentThread().getContextClassLoader();
            if (savedClassLoader != classLoader) {
                Thread.currentThread().setContextClassLoader(classLoader);
            }
            try {
                result = TestProcessServerKt.runBoxMethod((Method)method);
            }
            finally {
                if (savedClassLoader != classLoader) {
                    Thread.currentThread().setContextClassLoader(savedClassLoader);
                }
            }
        }
        if (unexpectedBehaviour) {
            CodegenTestCase.assertNotSame((Object)"OK", (Object)result);
        } else {
            CodegenTestCase.assertEquals((String)"OK", (String)result);
        }
    }

    @NotNull
    private String invokeBoxInSeparateProcess(URLClassLoader classLoader, Class<?> aClass) throws IOException {
        List<URL> classPath = TestUtilsKt.extractUrls(classLoader);
        if (classLoader instanceof GeneratedClassLoader) {
            File outDir = KotlinTestUtils.tmpDirForTest(this);
            SimpleOutputFileCollection currentOutput = new SimpleOutputFileCollection(((GeneratedClassLoader)classLoader).getAllGeneratedFiles());
            OutputUtilsKt.writeAllTo((OutputFileCollection)currentOutput, (File)outDir);
            classPath.add(0, outDir.toURI().toURL());
        }
        String string = new TestProxy(Integer.valueOf(BOX_IN_SEPARATE_PROCESS_PORT).intValue(), aClass.getCanonicalName(), classPath).runTest();
        if (string == null) {
            CodegenTestCase.$$$reportNull$$$0(58);
        }
        return string;
    }

    protected void printReport(File wholeFile) {
        boolean isIgnored = InTextDirectivesUtils.isIgnoredTarget(this.getBackend(), wholeFile, this.getIgnoreBackendDirectivePrefix());
        if (!isIgnored) {
            System.out.println(this.generateToText());
        }
    }

    protected String getIgnoreBackendDirectivePrefix() {
        return "// IGNORE_BACKEND: ";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 10: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 34: 
            case 42: 
            case 43: 
            case 45: 
            case 55: 
            case 56: 
            case 58: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 10: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 34: 
            case 42: 
            case 43: 
            case 45: 
            case 55: 
            case 56: 
            case 58: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationKind";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaSourceRoots";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFilesWithConfigurationDirectives";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testJdkKind";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 7: 
            case 24: 
            case 26: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: 
            case 10: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 34: 
            case 42: 
            case 43: 
            case 45: 
            case 55: 
            case 56: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/CodegenTestCase";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullPath";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 12: 
            case 13: 
            case 36: 
            case 37: 
            case 38: 
            case 41: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 16: 
            case 31: 
            case 49: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaClasspath";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javacOptions";
                break;
            }
            case 46: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 50: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedText";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coroutinesPackage";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backend";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/CodegenTestCase";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "loadFile";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "loadFileByFullPath";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "loadMultiFiles";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "relativePath";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "generateAndCreateClassLoader";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassPathURLs";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "generateToText";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "generateEachFileToText";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "generateFacadeClass";
                break;
            }
            case 25: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "generateClass";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "generateClassesInFile";
                break;
            }
            case 32: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "generateFunction";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "extractJavacOptions";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getBackend";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "createTestFilesFromFile";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempDirectory";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "invokeBoxInSeparateProcess";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createEnvironmentWithMockJdkAndIdeaAnnotations";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadText";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadFile";
                break;
            }
            case 8: 
            case 10: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 34: 
            case 42: 
            case 43: 
            case 45: 
            case 55: 
            case 56: 
            case 58: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "loadFileByFullPath";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "loadFiles";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "loadMultiFiles";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "relativePath";
                break;
            }
            case 24: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "generateClass";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "verifyWithAsm";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "generateFunction";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "updateConfiguration";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "compile";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "runJavacTask";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "updateJavaClasspath";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "extractJavacOptions";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "computeJavaTarget";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "doTest";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "doTestWithCoroutinesPackageReplacement";
                break;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "createTestFilesFromFile";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "writeJavaFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 10: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 34: 
            case 42: 
            case 43: 
            case 45: 
            case 55: 
            case 56: 
            case 58: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

