/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.diagnostics.StandardLibrarySpecialCompatibilityChecker;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.library.KotlinLibraryKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0014\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/checkers/WasmStandardLibrarySpecialCompatibilityChecker;", "Lorg/jetbrains/kotlin/backend/common/diagnostics/StandardLibrarySpecialCompatibilityChecker;", "<init>", "()V", "isStdlib", "", "library", "Lorg/jetbrains/kotlin/library/KotlinLibrary;", "getMessageToReport", "", "compilerVersion", "Lorg/jetbrains/kotlin/backend/common/diagnostics/StandardLibrarySpecialCompatibilityChecker$Version;", "stdlibVersion", "ir.serialization.js"})
@SourceDebugExtension(value={"SMAP\nWasmStandardLibrarySpecialCompatibilityChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WasmStandardLibrarySpecialCompatibilityChecker.kt\norg/jetbrains/kotlin/ir/backend/js/checkers/WasmStandardLibrarySpecialCompatibilityChecker\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,25:1\n234#2:26\n*S KotlinDebug\n*F\n+ 1 WasmStandardLibrarySpecialCompatibilityChecker.kt\norg/jetbrains/kotlin/ir/backend/js/checkers/WasmStandardLibrarySpecialCompatibilityChecker\n*L\n17#1:26\n*E\n"})
public final class WasmStandardLibrarySpecialCompatibilityChecker
extends StandardLibrarySpecialCompatibilityChecker {
    @NotNull
    public static final WasmStandardLibrarySpecialCompatibilityChecker INSTANCE = new WasmStandardLibrarySpecialCompatibilityChecker();

    private WasmStandardLibrarySpecialCompatibilityChecker() {
    }

    @Override
    protected boolean isStdlib(@NotNull KotlinLibrary library) {
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        return KotlinLibraryKt.isWasmStdlib(library);
    }

    @Override
    @Nullable
    protected String getMessageToReport(@NotNull StandardLibrarySpecialCompatibilityChecker.Version compilerVersion2, @NotNull StandardLibrarySpecialCompatibilityChecker.Version stdlibVersion) {
        String string;
        Intrinsics.checkNotNullParameter((Object)compilerVersion2, (String)"compilerVersion");
        Intrinsics.checkNotNullParameter((Object)stdlibVersion, (String)"stdlibVersion");
        boolean condition$iv = Intrinsics.areEqual((Object)stdlibVersion, (Object)compilerVersion2);
        boolean $i$f$runUnless = false;
        if (condition$iv) {
            string = null;
        } else {
            boolean bl = false;
            string = "The version of the Kotlin/Wasm standard library (" + stdlibVersion + ") differs from the version of the compiler (" + compilerVersion2 + "). Please, note that while Kotlin/Wasm is in active development phase only matching versions are supported.\nPlease, make sure that the standard library has the same version as the compiler. Adjust your project's settings if necessary.";
        }
        return string;
    }
}

