/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.classpathDiff;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.build.report.ICReporterKt;
import org.jetbrains.kotlin.build.report.metrics.BuildMetricsReporter;
import org.jetbrains.kotlin.build.report.metrics.BuildTime;
import org.jetbrains.kotlin.build.report.metrics.GradleBuildPerformanceMetric;
import org.jetbrains.kotlin.build.report.metrics.GradleBuildTime;
import org.jetbrains.kotlin.com.intellij.util.io.DataExternalizer;
import org.jetbrains.kotlin.incremental.ClasspathChanges;
import org.jetbrains.kotlin.incremental.LookupStorage;
import org.jetbrains.kotlin.incremental.classpathDiff.AccessibleClassSnapshot;
import org.jetbrains.kotlin.incremental.classpathDiff.AccessibleClassSnapshotExternalizer;
import org.jetbrains.kotlin.incremental.classpathDiff.ClassSnapshot;
import org.jetbrains.kotlin.incremental.classpathDiff.ClasspathEntrySnapshot;
import org.jetbrains.kotlin.incremental.classpathDiff.ClasspathSnapshot;
import org.jetbrains.kotlin.incremental.classpathDiff.ClasspathSnapshotBuildReporter;
import org.jetbrains.kotlin.incremental.classpathDiff.ClasspathSnapshotShrinker;
import org.jetbrains.kotlin.incremental.classpathDiff.ShrinkMode;
import org.jetbrains.kotlin.incremental.snapshots.LazyClasspathSnapshot;
import org.jetbrains.kotlin.incremental.snapshots.LazySnapshotLoadingMetrics;
import org.jetbrains.kotlin.incremental.storage.ExternalizersKt;
import org.jetbrains.kotlin.incremental.storage.ListExternalizer;
import org.jetbrains.kotlin.incremental.storage.LookupSymbolKey;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u0003H\u0000\u001a\u0012\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00050\u0001*\u00020\u0003H\u0002\u001a(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a4\u0010\u0010\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00010\u0011*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a0\u0010\u0014\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u00a8\u0006\u0018"}, d2={"removeDuplicateAndInaccessibleClasses", "", "Lorg/jetbrains/kotlin/incremental/classpathDiff/AccessibleClassSnapshot;", "Lorg/jetbrains/kotlin/incremental/classpathDiff/ClasspathSnapshot;", "getNonDuplicateClassSnapshots", "Lorg/jetbrains/kotlin/incremental/classpathDiff/ClassSnapshot;", "chooseShrinkMode", "Lorg/jetbrains/kotlin/incremental/classpathDiff/ShrinkMode;", "compilationWasIncremental", "", "classpathChanges", "Lorg/jetbrains/kotlin/incremental/ClasspathChanges$ClasspathSnapshotEnabled;", "lazyClasspathSnapshot", "Lorg/jetbrains/kotlin/incremental/snapshots/LazyClasspathSnapshot;", "lookupStorage", "Lorg/jetbrains/kotlin/incremental/LookupStorage;", "getLazyClasspathState", "Lkotlin/Pair;", "metricsMode", "Lorg/jetbrains/kotlin/incremental/snapshots/LazySnapshotLoadingMetrics;", "shrinkAndSaveClasspathSnapshot", "", "reporter", "Lorg/jetbrains/kotlin/incremental/classpathDiff/ClasspathSnapshotBuildReporter;", "incremental-compilation-impl"})
@SourceDebugExtension(value={"SMAP\nClasspathSnapshotShrinker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClasspathSnapshotShrinker.kt\norg/jetbrains/kotlin/incremental/classpathDiff/ClasspathSnapshotShrinkerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 BuildMetricsReporter.kt\norg/jetbrains/kotlin/build/report/metrics/BuildMetricsReporterKt\n*L\n1#1,321:1\n808#2,11:322\n1634#2,3:337\n774#2:340\n865#2,2:341\n1#3:333\n32#4,3:334\n36#4:343\n32#4,5:344\n*S KotlinDebug\n*F\n+ 1 ClasspathSnapshotShrinker.kt\norg/jetbrains/kotlin/incremental/classpathDiff/ClasspathSnapshotShrinkerKt\n*L\n148#1:322,11\n272#1:337,3\n273#1:340\n273#1:341,2\n260#1:334,3\n260#1:343\n292#1:344,5\n*E\n"})
public final class ClasspathSnapshotShrinkerKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<AccessibleClassSnapshot> removeDuplicateAndInaccessibleClasses(@NotNull ClasspathSnapshot $this$removeDuplicateAndInaccessibleClasses) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$removeDuplicateAndInaccessibleClasses, (String)"<this>");
        Iterable $this$filterIsInstance$iv = ClasspathSnapshotShrinkerKt.getNonDuplicateClassSnapshots($this$removeDuplicateAndInaccessibleClasses);
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof AccessibleClassSnapshot)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<ClassSnapshot> getNonDuplicateClassSnapshots(ClasspathSnapshot $this$getNonDuplicateClassSnapshots) {
        Iterable iterable = $this$getNonDuplicateClassSnapshots.getClasspathEntrySnapshots();
        int n2 = 0;
        Iterator<Object> iterator2 = iterable.iterator();
        while (iterator2.hasNext()) {
            void it;
            Object object = iterator2.next();
            ClasspathEntrySnapshot classpathEntrySnapshot = (ClasspathEntrySnapshot)object;
            int n3 = n2;
            boolean bl = false;
            int n4 = it.getClassSnapshots().size();
            n2 = n3 + n4;
        }
        int n5 = n2;
        LinkedHashMap<String, ClassSnapshot> classSnapshots = new LinkedHashMap<String, ClassSnapshot>(n5);
        for (ClasspathEntrySnapshot classpathEntrySnapshot : $this$getNonDuplicateClassSnapshots.getClasspathEntrySnapshots()) {
            for (Map.Entry entry : ((Map)classpathEntrySnapshot.getClassSnapshots()).entrySet()) {
                String unixStyleRelativePath = (String)entry.getKey();
                ClassSnapshot classSnapshot = (ClassSnapshot)entry.getValue();
                classSnapshots.putIfAbsent(unixStyleRelativePath, classSnapshot);
            }
        }
        Collection collection = classSnapshots.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return CollectionsKt.toList((Iterable)collection);
    }

    private static final ShrinkMode chooseShrinkMode(boolean compilationWasIncremental, ClasspathChanges.ClasspathSnapshotEnabled classpathChanges, LazyClasspathSnapshot lazyClasspathSnapshot, LookupStorage lookupStorage) {
        ShrinkMode shrinkMode;
        if (!compilationWasIncremental) {
            shrinkMode = ShrinkMode.NonIncremental.INSTANCE;
        } else {
            ClasspathChanges.ClasspathSnapshotEnabled classpathSnapshotEnabled = classpathChanges;
            if (classpathSnapshotEnabled instanceof ClasspathChanges.ClasspathSnapshotEnabled.IncrementalRun.NoChanges) {
                Set<LookupSymbolKey> addedLookupSymbols = lookupStorage.getAddedLookupSymbols();
                shrinkMode = addedLookupSymbols.isEmpty() ? (ShrinkMode)ShrinkMode.UnchangedLookupsUnchangedClasspath.INSTANCE : (ShrinkMode)new ShrinkMode.ChangedLookupsUnchangedClasspath(addedLookupSymbols);
            } else if (classpathSnapshotEnabled instanceof ClasspathChanges.ClasspathSnapshotEnabled.IncrementalRun.ToBeComputedByIncrementalCompiler) {
                Set<LookupSymbolKey> addedLookupSymbols = lookupStorage.getAddedLookupSymbols();
                Pair<List<AccessibleClassSnapshot>, List<AccessibleClassSnapshot>> pair = ClasspathSnapshotShrinkerKt.getLazyClasspathState(lazyClasspathSnapshot, lookupStorage, LazySnapshotLoadingMetrics.AssertThatDataIsAlreadyComputed.INSTANCE);
                List currentSnapshot = (List)pair.component1();
                List shrunkSnapshotAgainstPreviousLookups = (List)pair.component2();
                shrinkMode = addedLookupSymbols.isEmpty() ? (ShrinkMode)new ShrinkMode.UnchangedLookupsChangedClasspath(currentSnapshot, shrunkSnapshotAgainstPreviousLookups) : (ShrinkMode)new ShrinkMode.ChangedLookupsChangedClasspath(addedLookupSymbols, currentSnapshot, shrunkSnapshotAgainstPreviousLookups);
            } else if (classpathSnapshotEnabled instanceof ClasspathChanges.ClasspathSnapshotEnabled.NotAvailableDueToMissingClasspathSnapshot) {
                shrinkMode = ShrinkMode.NonIncremental.INSTANCE;
            } else {
                if (classpathSnapshotEnabled instanceof ClasspathChanges.ClasspathSnapshotEnabled.NotAvailableForNonIncrementalRun) {
                    throw new IllegalStateException("NotAvailableForNonIncrementalRun is not expected as compilationWasIncremental==true".toString());
                }
                throw new NoWhenBranchMatchedException();
            }
        }
        return shrinkMode;
    }

    private static final Pair<List<AccessibleClassSnapshot>, List<AccessibleClassSnapshot>> getLazyClasspathState(LazyClasspathSnapshot $this$getLazyClasspathState, LookupStorage lookupStorage, LazySnapshotLoadingMetrics metricsMode) {
        List<AccessibleClassSnapshot> snapshot = $this$getLazyClasspathState.getCurrentClasspathSnapshot(metricsMode);
        List<AccessibleClassSnapshot> shrunkClasspath = $this$getLazyClasspathState.getComputedShrunkClasspathAgainstPreviousLookups(lookupStorage, metricsMode);
        return TuplesKt.to(snapshot, shrunkClasspath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final void shrinkAndSaveClasspathSnapshot(boolean compilationWasIncremental, @NotNull ClasspathChanges.ClasspathSnapshotEnabled classpathChanges, @NotNull LookupStorage lookupStorage, @NotNull LazyClasspathSnapshot lazyClasspathSnapshot, @NotNull ClasspathSnapshotBuildReporter reporter) {
        long l2;
        Object shrunkCurrentClasspathAgainstPrevLookups;
        ShrinkMode.ChangedLookups changedLookups2;
        Object time$iv;
        Pair pair;
        ShrinkMode shrinkMode;
        Intrinsics.checkNotNullParameter((Object)classpathChanges, (String)"classpathChanges");
        Intrinsics.checkNotNullParameter((Object)lookupStorage, (String)"lookupStorage");
        Intrinsics.checkNotNullParameter((Object)lazyClasspathSnapshot, (String)"lazyClasspathSnapshot");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        ShrinkMode shrinkMode2 = shrinkMode = ClasspathSnapshotShrinkerKt.chooseShrinkMode(compilationWasIncremental, classpathChanges, lazyClasspathSnapshot, lookupStorage);
        if (shrinkMode2 instanceof ShrinkMode.UnchangedLookupsUnchangedClasspath) {
            pair = TuplesKt.to(null, null);
        } else if (shrinkMode2 instanceof ShrinkMode.UnchangedLookupsChangedClasspath) {
            pair = TuplesKt.to(((ShrinkMode.UnchangedLookupsChangedClasspath)shrinkMode).getCurrentClasspathSnapshot(), ((ShrinkMode.UnchangedLookupsChangedClasspath)shrinkMode).getShrunkCurrentClasspathAgainstPreviousLookups());
        } else if (shrinkMode2 instanceof ShrinkMode.ChangedLookups) {
            void $this$measure$iv;
            BuildMetricsReporter buildMetricsReporter = reporter;
            time$iv = GradleBuildTime.INCREMENTAL_SHRINK_CURRENT_CLASSPATH_SNAPSHOT;
            boolean $i$f$measure = false;
            $this$measure$iv.startMeasure(time$iv);
            try {
                void $this$filterTo$iv$iv;
                void destination$iv;
                void $this$mapTo$iv;
                List<AccessibleClassSnapshot> list;
                boolean bl = false;
                List<AccessibleClassSnapshot> currentClasspath = lazyClasspathSnapshot.getCurrentClasspathSnapshot(LazySnapshotLoadingMetrics.OnIncrementalShrunkClasspathUpdate.INSTANCE);
                changedLookups2 = (ShrinkMode.ChangedLookups)shrinkMode;
                if (changedLookups2 instanceof ShrinkMode.ChangedLookupsUnchangedClasspath) {
                    list = lazyClasspathSnapshot.getSavedShrunkClasspathAgainstPreviousLookups(LazySnapshotLoadingMetrics.OnIncrementalShrunkClasspathUpdate.INSTANCE);
                } else if (changedLookups2 instanceof ShrinkMode.ChangedLookupsChangedClasspath) {
                    list = ((ShrinkMode.ChangedLookupsChangedClasspath)shrinkMode).getShrunkCurrentClasspathAgainstPreviousLookups();
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                shrunkCurrentClasspathAgainstPrevLookups = list;
                Iterable iterable = (Iterable)shrunkCurrentClasspathAgainstPrevLookups;
                Collection collection = new LinkedHashSet();
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    void it;
                    AccessibleClassSnapshot accessibleClassSnapshot = (AccessibleClassSnapshot)item$iv;
                    void var21_28 = destination$iv;
                    boolean bl2 = false;
                    var21_28.add(it.getClassId());
                }
                Set shrunkClasses = (Set)destination$iv;
                Iterable $this$filter$iv = currentClasspath;
                boolean $i$f$filter = false;
                Iterable iterable2 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    AccessibleClassSnapshot it = (AccessibleClassSnapshot)element$iv$iv;
                    boolean bl3 = false;
                    if (!(!shrunkClasses.contains(it.getClassId()))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List notYetShrunkClasses = (List)destination$iv$iv;
                List shrunkRemainingClassesAgainstNewLookups = ClasspathSnapshotShrinker.shrinkClasses$default(ClasspathSnapshotShrinker.INSTANCE, notYetShrunkClasses, ((ShrinkMode.ChangedLookups)shrinkMode).getAddedLookupSymbols(), null, 4, null);
                List shrunkCurrentClasspath = CollectionsKt.plus((Collection)((Collection)shrunkCurrentClasspathAgainstPrevLookups), (Iterable)shrunkRemainingClassesAgainstNewLookups);
                Pair pair2 = TuplesKt.to(currentClasspath, (Object)shrunkCurrentClasspath);
                pair = pair2;
            }
            finally {
                $this$measure$iv.endMeasure(time$iv);
            }
        } else if (shrinkMode2 instanceof ShrinkMode.NonIncremental) {
            pair = ClasspathSnapshotShrinkerKt.getLazyClasspathState(lazyClasspathSnapshot, lookupStorage, LazySnapshotLoadingMetrics.OnNonIncrementalShrunkClasspathUpdate.INSTANCE);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Pair pair3 = pair;
        List currentClasspath = (List)pair3.component1();
        List shrunkCurrentClasspath = (List)pair3.component2();
        if (Intrinsics.areEqual((Object)shrinkMode, (Object)ShrinkMode.UnchangedLookupsUnchangedClasspath.INSTANCE)) {
            if (!classpathChanges.getClasspathSnapshotFiles().getShrunkPreviousClasspathSnapshotFile().isFile()) {
                boolean $i$a$-check-ClasspathSnapshotShrinkerKt$shrinkAndSaveClasspathSnapshot$32 = false;
                String $i$a$-check-ClasspathSnapshotShrinkerKt$shrinkAndSaveClasspathSnapshot$32 = "File '" + classpathChanges.getClasspathSnapshotFiles().getShrunkPreviousClasspathSnapshotFile().getPath() + "' does not exist";
                throw new IllegalStateException($i$a$-check-ClasspathSnapshotShrinkerKt$shrinkAndSaveClasspathSnapshot$32.toString());
            }
        } else {
            void $this$measure$iv;
            time$iv = reporter;
            BuildTime time$iv2 = GradleBuildTime.SAVE_SHRUNK_CURRENT_CLASSPATH_SNAPSHOT;
            boolean $i$f$measure = false;
            $this$measure$iv.startMeasure(time$iv2);
            try {
                boolean bl = false;
                DataExternalizer dataExternalizer = new ListExternalizer(AccessibleClassSnapshotExternalizer.INSTANCE);
                File file = classpathChanges.getClasspathSnapshotFiles().getShrunkPreviousClasspathSnapshotFile();
                List list = shrunkCurrentClasspath;
                Intrinsics.checkNotNull((Object)list);
                ExternalizersKt.saveToFile(dataExternalizer, file, list);
                changedLookups2 = Unit.INSTANCE;
            }
            finally {
                $this$measure$iv.endMeasure(time$iv2);
            }
        }
        ICReporterKt.debug(reporter, (Function0<String>)((Function0)() -> ClasspathSnapshotShrinkerKt.shrinkAndSaveClasspathSnapshot$lambda$6(shrinkMode, shrunkCurrentClasspath, currentClasspath)));
        reporter.addMetric(GradleBuildPerformanceMetric.SHRINK_AND_SAVE_CLASSPATH_SNAPSHOT_EXECUTION_COUNT, 1L);
        reporter.addMetric(GradleBuildPerformanceMetric.CLASSPATH_ENTRY_COUNT, (long)classpathChanges.getClasspathSnapshotFiles().getCurrentClasspathEntrySnapshotFiles().size());
        Iterable iterable = classpathChanges.getClasspathSnapshotFiles().getCurrentClasspathEntrySnapshotFiles();
        GradleBuildPerformanceMetric gradleBuildPerformanceMetric = GradleBuildPerformanceMetric.CLASSPATH_SNAPSHOT_SIZE;
        ClasspathSnapshotBuildReporter classpathSnapshotBuildReporter = reporter;
        long l3 = 0L;
        for (ShrinkMode.ChangedLookups changedLookups2 : iterable) {
            void it;
            shrunkCurrentClasspathAgainstPrevLookups = (File)((Object)changedLookups2);
            l2 = l3;
            boolean bl = false;
            long l4 = it.length();
            l3 = l2 + l4;
        }
        l2 = l3;
        classpathSnapshotBuildReporter.addMetric(gradleBuildPerformanceMetric, l2);
        reporter.addMetric(GradleBuildPerformanceMetric.SHRUNK_CLASSPATH_SNAPSHOT_SIZE, classpathChanges.getClasspathSnapshotFiles().getShrunkPreviousClasspathSnapshotFile().length());
    }

    private static final String shrinkAndSaveClasspathSnapshot$lambda$6(ShrinkMode $shrinkMode, List $shrunkCurrentClasspath, List $currentClasspath) {
        String string;
        StringBuilder stringBuilder = new StringBuilder().append("Shrunk current classpath snapshot after compilation (shrink mode = ").append(Reflection.getOrCreateKotlinClass($shrinkMode.getClass()).getSimpleName()).append(')');
        if ($shrinkMode instanceof ShrinkMode.UnchangedLookupsUnchangedClasspath) {
            string = ", no updates since previous run";
        } else {
            StringBuilder stringBuilder2 = new StringBuilder().append(", retained ");
            List list = $shrunkCurrentClasspath;
            Intrinsics.checkNotNull((Object)list);
            StringBuilder stringBuilder3 = stringBuilder2.append(list.size()).append(" / ");
            List list2 = $currentClasspath;
            Intrinsics.checkNotNull((Object)list2);
            string = stringBuilder3.append(list2.size()).append(" classes").toString();
        }
        return stringBuilder.append(string).toString();
    }
}

