/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.serialization;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.contracts.description.EventOccurrencesRange;
import org.jetbrains.kotlin.contracts.description.KtBinaryLogicExpression;
import org.jetbrains.kotlin.contracts.description.KtCallsEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.KtConditionalEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.KtConditionalReturnsDeclaration;
import org.jetbrains.kotlin.contracts.description.KtConstantReference;
import org.jetbrains.kotlin.contracts.description.KtContractDescriptionElement;
import org.jetbrains.kotlin.contracts.description.KtContractDescriptionVisitor;
import org.jetbrains.kotlin.contracts.description.KtEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.KtHoldsInEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.KtIsInstancePredicate;
import org.jetbrains.kotlin.contracts.description.KtIsNullPredicate;
import org.jetbrains.kotlin.contracts.description.KtLogicalNot;
import org.jetbrains.kotlin.contracts.description.KtReturnsEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.KtValueParameterReference;
import org.jetbrains.kotlin.contracts.description.LogicOperationKind;
import org.jetbrains.kotlin.fir.contracts.ContractUtilsKt;
import org.jetbrains.kotlin.fir.contracts.FirContractDescription;
import org.jetbrains.kotlin.fir.contracts.FirEffectDeclaration;
import org.jetbrains.kotlin.fir.contracts.description.ConeContractConstantValues;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.serialization.FirElementSerializer;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.Flags;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/serialization/FirContractSerializer;", "", "<init>", "()V", "serializeContractOfFunctionIfAny", "", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "proto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Function$Builder;", "parentSerializer", "Lorg/jetbrains/kotlin/fir/serialization/FirElementSerializer;", "ContractSerializerWorker", "fir-serialization"})
public final class FirContractSerializer {
    public final void serializeContractOfFunctionIfAny(@NotNull FirFunction function2, @NotNull ProtoBuf.Function.Builder proto, @NotNull FirElementSerializer parentSerializer) {
        Collection collection;
        FirContractDescription contractDescription;
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        Intrinsics.checkNotNullParameter((Object)parentSerializer, (String)"parentSerializer");
        FirSimpleFunction firSimpleFunction = function2 instanceof FirSimpleFunction ? (FirSimpleFunction)function2 : null;
        FirContractDescription firContractDescription = contractDescription = firSimpleFunction != null ? firSimpleFunction.getContractDescription() : null;
        if (contractDescription == null || (collection = (Collection)ContractUtilsKt.getEffects(contractDescription)) == null || collection.isEmpty()) {
            return;
        }
        ContractSerializerWorker worker = new ContractSerializerWorker(parentSerializer);
        proto.setContract(worker.contractProto(contractDescription));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ(\u0010\n\u001a\u00020\u000b2\u0016\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rj\u0002`\u00102\u0006\u0010\b\u001a\u00020\tH\u0002J0\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000b2\u0016\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rj\u0002`\u00102\u0006\u0010\b\u001a\u00020\tH\u0002J(\u0010\u0014\u001a\u00020\u00152\u0016\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\u0017j\u0002`\u00182\u0006\u0010\b\u001a\u00020\tH\u0002J\u0014\u0010\u0019\u001a\u00020\u0012*\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\"\u0010 \u001a\u0004\u0018\u00010!2\u0016\u0010\"\u001a\u0012\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0#j\u0002`$H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/fir/serialization/FirContractSerializer$ContractSerializerWorker;", "", "parentSerializer", "Lorg/jetbrains/kotlin/fir/serialization/FirElementSerializer;", "<init>", "(Lorg/jetbrains/kotlin/fir/serialization/FirElementSerializer;)V", "contractProto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Contract$Builder;", "contractDescription", "Lorg/jetbrains/kotlin/fir/contracts/FirContractDescription;", "effectProto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Effect$Builder;", "effectDeclaration", "Lorg/jetbrains/kotlin/contracts/description/KtEffectDeclaration;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeEffectDeclaration;", "fillEffectProto", "", "builder", "contractExpressionProto", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Expression$Builder;", "contractDescriptionElement", "Lorg/jetbrains/kotlin/contracts/description/KtContractDescriptionElement;", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeContractDescriptionElement;", "writeFlags", "newFlagsValue", "", "invocationKindProtobufEnum", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Effect$InvocationKind;", "kind", "Lorg/jetbrains/kotlin/contracts/description/EventOccurrencesRange;", "constantValueProtobufEnum", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Expression$ConstantValue;", "constantReference", "Lorg/jetbrains/kotlin/contracts/description/KtConstantReference;", "Lorg/jetbrains/kotlin/fir/contracts/description/ConeConstantReference;", "fir-serialization"})
    @SourceDebugExtension(value={"SMAP\nFirContractSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirContractSerializer.kt\norg/jetbrains/kotlin/fir/serialization/FirContractSerializer$ContractSerializerWorker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,233:1\n1869#2,2:234\n*S KotlinDebug\n*F\n+ 1 FirContractSerializer.kt\norg/jetbrains/kotlin/fir/serialization/FirContractSerializer$ContractSerializerWorker\n*L\n38#1:234,2\n*E\n"})
    private static final class ContractSerializerWorker {
        @NotNull
        private final FirElementSerializer parentSerializer;

        public ContractSerializerWorker(@NotNull FirElementSerializer parentSerializer) {
            Intrinsics.checkNotNullParameter((Object)parentSerializer, (String)"parentSerializer");
            this.parentSerializer = parentSerializer;
        }

        @NotNull
        public final ProtoBuf.Contract.Builder contractProto(@NotNull FirContractDescription contractDescription) {
            ProtoBuf.Contract.Builder builder;
            Intrinsics.checkNotNullParameter((Object)contractDescription, (String)"contractDescription");
            ProtoBuf.Contract.Builder $this$contractProto_u24lambda_u241 = builder = ProtoBuf.Contract.newBuilder();
            boolean bl = false;
            List<FirEffectDeclaration> list = ContractUtilsKt.getEffects(contractDescription);
            if (list != null) {
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    FirEffectDeclaration it = (FirEffectDeclaration)element$iv;
                    boolean bl2 = false;
                    $this$contractProto_u24lambda_u241.addEffect(this.effectProto(it.getEffect(), contractDescription));
                }
            }
            ProtoBuf.Contract.Builder builder2 = builder;
            Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"apply(...)");
            return builder2;
        }

        private final ProtoBuf.Effect.Builder effectProto(KtEffectDeclaration<ConeKotlinType, ConeDiagnostic> effectDeclaration, FirContractDescription contractDescription) {
            ProtoBuf.Effect.Builder builder;
            ProtoBuf.Effect.Builder $this$effectProto_u24lambda_u242 = builder = ProtoBuf.Effect.newBuilder();
            boolean bl = false;
            Intrinsics.checkNotNull((Object)$this$effectProto_u24lambda_u242);
            this.fillEffectProto($this$effectProto_u24lambda_u242, effectDeclaration, contractDescription);
            ProtoBuf.Effect.Builder builder2 = builder;
            Intrinsics.checkNotNullExpressionValue((Object)builder2, (String)"apply(...)");
            return builder2;
        }

        private final void fillEffectProto(ProtoBuf.Effect.Builder builder, KtEffectDeclaration<ConeKotlinType, ConeDiagnostic> effectDeclaration, FirContractDescription contractDescription) {
            KtEffectDeclaration<ConeKotlinType, ConeDiagnostic> ktEffectDeclaration = effectDeclaration;
            if (ktEffectDeclaration instanceof KtConditionalEffectDeclaration) {
                builder.setConclusionOfConditionalEffect(this.contractExpressionProto(((KtConditionalEffectDeclaration)effectDeclaration).getCondition(), contractDescription));
                this.fillEffectProto(builder, ((KtConditionalEffectDeclaration)effectDeclaration).getEffect(), contractDescription);
            } else if (ktEffectDeclaration instanceof KtReturnsEffectDeclaration) {
                KtConstantReference ktConstantReference = ((KtReturnsEffectDeclaration)effectDeclaration).getValue();
                if (Intrinsics.areEqual(ktConstantReference, ConeContractConstantValues.INSTANCE.getNOT_NULL())) {
                    builder.setEffectType(ProtoBuf.Effect.EffectType.RETURNS_NOT_NULL);
                } else if (Intrinsics.areEqual(ktConstantReference, ConeContractConstantValues.INSTANCE.getWILDCARD())) {
                    builder.setEffectType(ProtoBuf.Effect.EffectType.RETURNS_CONSTANT);
                } else {
                    builder.setEffectType(ProtoBuf.Effect.EffectType.RETURNS_CONSTANT);
                    builder.addEffectConstructorArgument(this.contractExpressionProto(((KtReturnsEffectDeclaration)effectDeclaration).getValue(), contractDescription));
                }
            } else if (ktEffectDeclaration instanceof KtCallsEffectDeclaration) {
                builder.setEffectType(ProtoBuf.Effect.EffectType.CALLS);
                builder.addEffectConstructorArgument(this.contractExpressionProto(((KtCallsEffectDeclaration)effectDeclaration).getValueParameterReference(), contractDescription));
                ProtoBuf.Effect.InvocationKind invocationKindProtobufEnum = this.invocationKindProtobufEnum(((KtCallsEffectDeclaration)effectDeclaration).getKind());
                if (invocationKindProtobufEnum != null) {
                    builder.setKind(invocationKindProtobufEnum);
                }
            } else if (ktEffectDeclaration instanceof KtConditionalReturnsDeclaration) {
                builder.setConditionKind(ProtoBuf.Effect.EffectConditionKind.RETURNS_CONDITION);
                builder.setConclusionOfConditionalEffect(this.contractExpressionProto(((KtConditionalReturnsDeclaration)effectDeclaration).getArgumentsCondition(), contractDescription));
                this.fillEffectProto(builder, ((KtConditionalReturnsDeclaration)effectDeclaration).getReturnsEffect(), contractDescription);
            } else if (ktEffectDeclaration instanceof KtHoldsInEffectDeclaration) {
                builder.setConditionKind(ProtoBuf.Effect.EffectConditionKind.HOLDSIN_CONDITION);
                builder.setConclusionOfConditionalEffect(this.contractExpressionProto(((KtHoldsInEffectDeclaration)effectDeclaration).getArgumentsCondition(), contractDescription));
                builder.addEffectConstructorArgument(this.contractExpressionProto(((KtHoldsInEffectDeclaration)effectDeclaration).getValueParameterReference(), contractDescription));
            } else {
                throw new IllegalStateException("Unsupported effect type: " + Reflection.getOrCreateKotlinClass(effectDeclaration.getClass()).getSimpleName());
            }
        }

        private final ProtoBuf.Expression.Builder contractExpressionProto(KtContractDescriptionElement<ConeKotlinType, ConeDiagnostic> contractDescriptionElement, FirContractDescription contractDescription) {
            return (ProtoBuf.Expression.Builder)contractDescriptionElement.accept((KtContractDescriptionVisitor)new KtContractDescriptionVisitor<ProtoBuf.Expression.Builder, Unit, ConeKotlinType, ConeDiagnostic>(this, contractDescription){
                final /* synthetic */ ContractSerializerWorker this$0;
                final /* synthetic */ FirContractDescription $contractDescription;
                {
                    this.this$0 = $receiver;
                    this.$contractDescription = $contractDescription;
                }

                public ProtoBuf.Expression.Builder visitLogicalBinaryOperationContractExpression(KtBinaryLogicExpression<ConeKotlinType, ConeDiagnostic> binaryLogicExpression, Unit data) {
                    Intrinsics.checkNotNullParameter(binaryLogicExpression, (String)"binaryLogicExpression");
                    Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                    return binaryLogicExpression.getKind() == LogicOperationKind.AND ? this.visitLogicalAnd(binaryLogicExpression, data) : this.visitLogicalOr(binaryLogicExpression, data);
                }

                private final ProtoBuf.Expression.Builder visitLogicalOr(KtBinaryLogicExpression<ConeKotlinType, ConeDiagnostic> logicalOr, Unit data) {
                    ProtoBuf.Expression.Builder builder;
                    ProtoBuf.Expression.Builder leftBuilder = (ProtoBuf.Expression.Builder)logicalOr.getLeft().accept(this, data);
                    if (leftBuilder.getAndArgumentCount() != 0) {
                        ProtoBuf.Expression.Builder builder2 = ProtoBuf.Expression.newBuilder();
                        ContractSerializerWorker contractSerializerWorker = this.this$0;
                        FirContractDescription firContractDescription = this.$contractDescription;
                        ProtoBuf.Expression.Builder $this$visitLogicalOr_u24lambda_u240 = builder2;
                        boolean bl = false;
                        $this$visitLogicalOr_u24lambda_u240.addOrArgument(leftBuilder);
                        $this$visitLogicalOr_u24lambda_u240.addOrArgument(ContractSerializerWorker.access$contractExpressionProto(contractSerializerWorker, logicalOr.getRight(), firContractDescription));
                        ProtoBuf.Expression.Builder builder3 = builder2;
                        Intrinsics.checkNotNull((Object)builder3);
                        builder = builder3;
                    } else {
                        ProtoBuf.Expression.Builder builder4 = leftBuilder;
                        ContractSerializerWorker contractSerializerWorker = this.this$0;
                        FirContractDescription firContractDescription = this.$contractDescription;
                        ProtoBuf.Expression.Builder $this$visitLogicalOr_u24lambda_u241 = builder4;
                        boolean bl = false;
                        $this$visitLogicalOr_u24lambda_u241.addOrArgument(ContractSerializerWorker.access$contractExpressionProto(contractSerializerWorker, logicalOr.getRight(), firContractDescription));
                        builder = builder4;
                    }
                    return builder;
                }

                private final ProtoBuf.Expression.Builder visitLogicalAnd(KtBinaryLogicExpression<ConeKotlinType, ConeDiagnostic> logicalAnd, Unit data) {
                    ProtoBuf.Expression.Builder builder;
                    ProtoBuf.Expression.Builder leftBuilder = (ProtoBuf.Expression.Builder)logicalAnd.getLeft().accept(this, data);
                    if (leftBuilder.getOrArgumentCount() != 0) {
                        ProtoBuf.Expression.Builder builder2 = ProtoBuf.Expression.newBuilder();
                        ContractSerializerWorker contractSerializerWorker = this.this$0;
                        FirContractDescription firContractDescription = this.$contractDescription;
                        ProtoBuf.Expression.Builder $this$visitLogicalAnd_u24lambda_u242 = builder2;
                        boolean bl = false;
                        $this$visitLogicalAnd_u24lambda_u242.addAndArgument(leftBuilder);
                        $this$visitLogicalAnd_u24lambda_u242.addAndArgument(ContractSerializerWorker.access$contractExpressionProto(contractSerializerWorker, logicalAnd.getRight(), firContractDescription));
                        ProtoBuf.Expression.Builder builder3 = builder2;
                        Intrinsics.checkNotNull((Object)builder3);
                        builder = builder3;
                    } else {
                        ProtoBuf.Expression.Builder builder4 = leftBuilder;
                        ContractSerializerWorker contractSerializerWorker = this.this$0;
                        FirContractDescription firContractDescription = this.$contractDescription;
                        ProtoBuf.Expression.Builder $this$visitLogicalAnd_u24lambda_u243 = builder4;
                        boolean bl = false;
                        $this$visitLogicalAnd_u24lambda_u243.addAndArgument(ContractSerializerWorker.access$contractExpressionProto(contractSerializerWorker, logicalAnd.getRight(), firContractDescription));
                        builder = builder4;
                    }
                    return builder;
                }

                public ProtoBuf.Expression.Builder visitLogicalNot(KtLogicalNot<ConeKotlinType, ConeDiagnostic> logicalNot, Unit data) {
                    Intrinsics.checkNotNullParameter(logicalNot, (String)"logicalNot");
                    Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                    R r2 = logicalNot.getArg().accept(this, data);
                    ContractSerializerWorker contractSerializerWorker = this.this$0;
                    ProtoBuf.Expression.Builder $this$visitLogicalNot_u24lambda_u244 = (ProtoBuf.Expression.Builder)r2;
                    boolean bl = false;
                    ContractSerializerWorker.access$writeFlags(contractSerializerWorker, $this$visitLogicalNot_u24lambda_u244, Flags.IS_NEGATED.invert($this$visitLogicalNot_u24lambda_u244.getFlags()));
                    return (ProtoBuf.Expression.Builder)r2;
                }

                public ProtoBuf.Expression.Builder visitIsInstancePredicate(KtIsInstancePredicate<ConeKotlinType, ConeDiagnostic> isInstancePredicate, Unit data) {
                    Intrinsics.checkNotNullParameter(isInstancePredicate, (String)"isInstancePredicate");
                    Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                    ProtoBuf.Expression.Builder builder = this.visitValueParameterReference(isInstancePredicate.getArg(), data);
                    builder.setIsInstanceTypeId(FirElementSerializer.typeId$default(ContractSerializerWorker.access$getParentSerializer$p(this.this$0), isInstancePredicate.getType(), false, 2, null));
                    ContractSerializerWorker.access$writeFlags(this.this$0, builder, Flags.getContractExpressionFlags(isInstancePredicate.isNegated(), false));
                    return builder;
                }

                public ProtoBuf.Expression.Builder visitIsNullPredicate(KtIsNullPredicate<ConeKotlinType, ConeDiagnostic> isNullPredicate, Unit data) {
                    Intrinsics.checkNotNullParameter(isNullPredicate, (String)"isNullPredicate");
                    Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                    ProtoBuf.Expression.Builder builder = this.visitValueParameterReference(isNullPredicate.getArg(), data);
                    ContractSerializerWorker.access$writeFlags(this.this$0, builder, Flags.getContractExpressionFlags(isNullPredicate.isNegated(), true));
                    return builder;
                }

                public ProtoBuf.Expression.Builder visitConstantDescriptor(KtConstantReference<ConeKotlinType, ConeDiagnostic> constantReference, Unit data) {
                    Intrinsics.checkNotNullParameter(constantReference, (String)"constantReference");
                    Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                    ProtoBuf.Expression.Builder builder = ProtoBuf.Expression.newBuilder();
                    ProtoBuf.Expression.ConstantValue constantValueProtobufEnum = ContractSerializerWorker.access$constantValueProtobufEnum(this.this$0, constantReference);
                    if (constantValueProtobufEnum != null) {
                        builder.setConstantValue(constantValueProtobufEnum);
                    }
                    Intrinsics.checkNotNull((Object)builder);
                    return builder;
                }

                public ProtoBuf.Expression.Builder visitValueParameterReference(KtValueParameterReference<ConeKotlinType, ConeDiagnostic> valueParameterReference, Unit data) {
                    Intrinsics.checkNotNullParameter(valueParameterReference, (String)"valueParameterReference");
                    Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                    ProtoBuf.Expression.Builder builder = ProtoBuf.Expression.newBuilder();
                    int indexOfParameter = valueParameterReference.getParameterIndex() + 1;
                    builder.setValueParameterReference(indexOfParameter);
                    Intrinsics.checkNotNull((Object)builder);
                    return builder;
                }
            }, Unit.INSTANCE);
        }

        private final void writeFlags(ProtoBuf.Expression.Builder $this$writeFlags, int newFlagsValue) {
            if ($this$writeFlags.getFlags() != newFlagsValue) {
                $this$writeFlags.setFlags(newFlagsValue);
            }
        }

        private final ProtoBuf.Effect.InvocationKind invocationKindProtobufEnum(EventOccurrencesRange kind) {
            ProtoBuf.Effect.InvocationKind invocationKind;
            switch (WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
                case 1: {
                    invocationKind = ProtoBuf.Effect.InvocationKind.AT_MOST_ONCE;
                    break;
                }
                case 2: {
                    invocationKind = ProtoBuf.Effect.InvocationKind.EXACTLY_ONCE;
                    break;
                }
                case 3: {
                    invocationKind = ProtoBuf.Effect.InvocationKind.AT_LEAST_ONCE;
                    break;
                }
                default: {
                    invocationKind = null;
                }
            }
            return invocationKind;
        }

        private final ProtoBuf.Expression.ConstantValue constantValueProtobufEnum(KtConstantReference<ConeKotlinType, ConeDiagnostic> constantReference) {
            ProtoBuf.Expression.ConstantValue constantValue;
            KtConstantReference<ConeKotlinType, ConeDiagnostic> ktConstantReference = constantReference;
            if (Intrinsics.areEqual(ktConstantReference, ConeContractConstantValues.INSTANCE.getTRUE())) {
                constantValue = ProtoBuf.Expression.ConstantValue.TRUE;
            } else if (Intrinsics.areEqual(ktConstantReference, ConeContractConstantValues.INSTANCE.getFALSE())) {
                constantValue = ProtoBuf.Expression.ConstantValue.FALSE;
            } else if (Intrinsics.areEqual(ktConstantReference, ConeContractConstantValues.INSTANCE.getNULL())) {
                constantValue = ProtoBuf.Expression.ConstantValue.NULL;
            } else {
                if (Intrinsics.areEqual(ktConstantReference, ConeContractConstantValues.INSTANCE.getNOT_NULL())) {
                    throw new IllegalStateException("Internal error during serialization of function contract: NOT_NULL constant isn't denotable in protobuf format. Its serialization should be handled at higher level");
                }
                if (Intrinsics.areEqual(ktConstantReference, ConeContractConstantValues.INSTANCE.getWILDCARD())) {
                    constantValue = null;
                } else {
                    throw new IllegalArgumentException("Unknown constant: " + constantReference);
                }
            }
            return constantValue;
        }

        public static final /* synthetic */ FirElementSerializer access$getParentSerializer$p(ContractSerializerWorker $this) {
            return $this.parentSerializer;
        }

        public static final /* synthetic */ void access$writeFlags(ContractSerializerWorker $this, ProtoBuf.Expression.Builder $receiver, int newFlagsValue) {
            $this.writeFlags($receiver, newFlagsValue);
        }

        public static final /* synthetic */ ProtoBuf.Expression.ConstantValue access$constantValueProtobufEnum(ContractSerializerWorker $this, KtConstantReference constantReference) {
            return $this.constantValueProtobufEnum(constantReference);
        }

        public static final /* synthetic */ ProtoBuf.Expression.Builder access$contractExpressionProto(ContractSerializerWorker $this, KtContractDescriptionElement contractDescriptionElement, FirContractDescription contractDescription) {
            return $this.contractExpressionProto(contractDescriptionElement, contractDescription);
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[EventOccurrencesRange.values().length];
                try {
                    nArray[EventOccurrencesRange.AT_MOST_ONCE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[EventOccurrencesRange.EXACTLY_ONCE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[EventOccurrencesRange.AT_LEAST_ONCE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

