/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.IrValidatorConfig;
import org.jetbrains.kotlin.backend.common.checkers.context.CheckerContext;
import org.jetbrains.kotlin.backend.common.checkers.context.ContextUpdater;
import org.jetbrains.kotlin.backend.common.checkers.context.ParentChainUpdater;
import org.jetbrains.kotlin.backend.common.checkers.context.TypeParameterScopeUpdater;
import org.jetbrains.kotlin.backend.common.checkers.context.ValueScopeUpdater;
import org.jetbrains.kotlin.backend.common.checkers.declaration.IrConstructorReceiverChecker;
import org.jetbrains.kotlin.backend.common.checkers.declaration.IrDeclarationChecker;
import org.jetbrains.kotlin.backend.common.checkers.declaration.IrDeclarationCheckerKt;
import org.jetbrains.kotlin.backend.common.checkers.declaration.IrFieldVisibilityChecker;
import org.jetbrains.kotlin.backend.common.checkers.declaration.IrFunctionBodyChecker;
import org.jetbrains.kotlin.backend.common.checkers.declaration.IrFunctionDispatchReceiverChecker;
import org.jetbrains.kotlin.backend.common.checkers.declaration.IrFunctionParametersChecker;
import org.jetbrains.kotlin.backend.common.checkers.declaration.IrFunctionPropertiesChecker;
import org.jetbrains.kotlin.backend.common.checkers.declaration.IrPrivateDeclarationOverrideChecker;
import org.jetbrains.kotlin.backend.common.checkers.declaration.IrPropertyAccessorsChecker;
import org.jetbrains.kotlin.backend.common.checkers.declaration.IrValueParameterVarargTypesChecker;
import org.jetbrains.kotlin.backend.common.checkers.expression.IrCallFunctionDispatchReceiverChecker;
import org.jetbrains.kotlin.backend.common.checkers.expression.IrCallFunctionPropertiesChecker;
import org.jetbrains.kotlin.backend.common.checkers.expression.IrCallTypeChecker;
import org.jetbrains.kotlin.backend.common.checkers.expression.IrConstTypeChecker;
import org.jetbrains.kotlin.backend.common.checkers.expression.IrCrossFileFieldUsageChecker;
import org.jetbrains.kotlin.backend.common.checkers.expression.IrDynamicTypeFieldAccessChecker;
import org.jetbrains.kotlin.backend.common.checkers.expression.IrExpressionChecker;
import org.jetbrains.kotlin.backend.common.checkers.expression.IrExpressionCheckerKt;
import org.jetbrains.kotlin.backend.common.checkers.expression.IrExpressionTypeChecker;
import org.jetbrains.kotlin.backend.common.checkers.expression.IrFunctionReferenceFunctionDispatchReceiverChecker;
import org.jetbrains.kotlin.backend.common.checkers.expression.IrFunctionReferenceFunctionPropertiesChecker;
import org.jetbrains.kotlin.backend.common.checkers.expression.IrGetFieldTypeChecker;
import org.jetbrains.kotlin.backend.common.checkers.expression.IrGetObjectValueTypeChecker;
import org.jetbrains.kotlin.backend.common.checkers.expression.IrGetValueTypeChecker;
import org.jetbrains.kotlin.backend.common.checkers.expression.IrNoInlineUseSitesChecker;
import org.jetbrains.kotlin.backend.common.checkers.expression.IrNothingTypeExpressionChecker;
import org.jetbrains.kotlin.backend.common.checkers.expression.IrSetValueAssignabilityChecker;
import org.jetbrains.kotlin.backend.common.checkers.expression.IrStringConcatenationTypeChecker;
import org.jetbrains.kotlin.backend.common.checkers.expression.IrTypeOperatorTypeChecker;
import org.jetbrains.kotlin.backend.common.checkers.expression.IrTypeOperatorTypeOperandChecker;
import org.jetbrains.kotlin.backend.common.checkers.expression.IrUnitTypeExpressionChecker;
import org.jetbrains.kotlin.backend.common.checkers.expression.IrValueAccessScopeChecker;
import org.jetbrains.kotlin.backend.common.checkers.expression.IrVarargTypesChecker;
import org.jetbrains.kotlin.backend.common.checkers.symbol.IrSymbolChecker;
import org.jetbrains.kotlin.backend.common.checkers.symbol.IrSymbolCheckerKt;
import org.jetbrains.kotlin.backend.common.checkers.symbol.IrVisibilityChecker;
import org.jetbrains.kotlin.backend.common.checkers.type.IrTypeChecker;
import org.jetbrains.kotlin.backend.common.checkers.type.IrTypeCheckerKt;
import org.jetbrains.kotlin.backend.common.checkers.type.IrTypeParameterScopeChecker;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IrTreeSymbolsVisitor;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00f6\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010f\u001a\u00020g2\u0006\u0010h\u001a\u00020iH\u0016J\u0010\u0010j\u001a\u00020g2\u0006\u0010k\u001a\u00020*H\u0016J\u0010\u0010l\u001a\u00020g2\u0006\u0010k\u001a\u00020-H\u0016J\u0010\u0010m\u001a\u00020g2\u0006\u0010k\u001a\u000200H\u0016J\u0010\u0010n\u001a\u00020g2\u0006\u0010k\u001a\u000203H\u0016J\u0010\u0010o\u001a\u00020g2\u0006\u0010k\u001a\u000206H\u0016J\u0010\u0010p\u001a\u00020g2\u0006\u0010k\u001a\u000209H\u0016J\u0010\u0010q\u001a\u00020g2\u0006\u0010k\u001a\u00020<H\u0016J\u0010\u0010r\u001a\u00020g2\u0006\u0010k\u001a\u00020dH\u0016J\u0010\u0010s\u001a\u00020g2\u0006\u0010k\u001a\u00020?H\u0016J\u0010\u0010t\u001a\u00020g2\u0006\u0010k\u001a\u00020BH\u0016J\u0010\u0010u\u001a\u00020g2\u0006\u0010k\u001a\u00020^H\u0016J\u0010\u0010v\u001a\u00020g2\u0006\u0010w\u001a\u00020EH\u0016J\u0010\u0010x\u001a\u00020g2\u0006\u0010y\u001a\u00020HH\u0016J\u0010\u0010z\u001a\u00020g2\u0006\u0010k\u001a\u00020KH\u0016J\u0010\u0010{\u001a\u00020g2\u0006\u0010k\u001a\u00020NH\u0016J\u0010\u0010|\u001a\u00020g2\u0006\u0010}\u001a\u00020QH\u0016J\u0010\u0010~\u001a\u00020g2\u0006\u0010k\u001a\u00020!H\u0016J\u0010\u0010\u007f\u001a\u00020g2\u0006\u0010}\u001a\u00020\rH\u0016J\u0011\u0010\u0080\u0001\u001a\u00020g2\u0006\u0010k\u001a\u00020\u0011H\u0016J\u001c\u0010\u0081\u0001\u001a\u00020g2\u0007\u0010\u0082\u0001\u001a\u00020i2\b\u0010\u0083\u0001\u001a\u00030\u0084\u0001H\u0016J\u001c\u0010\u0085\u0001\u001a\u00020g2\u0007\u0010\u0082\u0001\u001a\u00020i2\b\u0010\u0086\u0001\u001a\u00030\u0087\u0001H\u0016J\u0011\u0010\u0088\u0001\u001a\u00020g2\u0006\u0010k\u001a\u00020\u0018H\u0016J\u0012\u0010\u0089\u0001\u001a\u00020g2\u0007\u0010}\u001a\u00030\u008a\u0001H\u0016J\u0011\u0010\u008b\u0001\u001a\u00020g2\u0006\u0010k\u001a\u00020VH\u0016J\u0011\u0010\u008c\u0001\u001a\u00020g2\u0006\u0010k\u001a\u00020YH\u0016J\u0011\u0010\u008d\u0001\u001a\u00020g2\u0006\u0010k\u001a\u00020\\H\u0016J\u0011\u0010\u008e\u0001\u001a\u00020g2\u0006\u0010k\u001a\u00020\u001bH\u0016J\u0011\u0010\u008f\u0001\u001a\u00020g2\u0006\u0010}\u001a\u00020\u001eH\u0016J\u0011\u0010\u0090\u0001\u001a\u00020g2\u0006\u0010k\u001a\u00020'H\u0016J\u0011\u0010\u0091\u0001\u001a\u00020g2\u0006\u0010k\u001a\u00020$H\u0016J\u0011\u0010\u0092\u0001\u001a\u00020g2\u0006\u0010}\u001a\u00020aH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\r0\fj\u0002`\u000e0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00110\u0010j\u0002`\u00120\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0017\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u00180\u0010j\u0002`\u00190\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001a\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u001b0\u0010j\u0002`\u001c0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001d\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u001e0\fj\u0002`\u001f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010 \u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020!0\u0010j\u0002`\"0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010#\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020$0\u0010j\u0002`%0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010&\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020'0\u0010j\u0002`(0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010)\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020*0\u0010j\u0002`+0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010,\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020-0\u0010j\u0002`.0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010/\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u0002000\u0010j\u0002`10\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u00102\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u0002030\u0010j\u0002`40\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u00105\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u0002060\u0010j\u0002`70\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u00108\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u0002090\u0010j\u0002`:0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010;\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020<0\u0010j\u0002`=0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010>\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020?0\u0010j\u0002`@0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010A\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020B0\u0010j\u0002`C0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010D\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020E0\u0010j\u0002`F0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010G\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020H0\u0010j\u0002`I0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010J\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020K0\u0010j\u0002`L0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010M\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020N0\u0010j\u0002`O0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010P\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020Q0\fj\u0002`R0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010S\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020T0\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010U\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020V0\u0010j\u0002`W0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010X\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020Y0\u0010j\u0002`Z0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010[\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\\0\u00100\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010]\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020^0\u0010j\u0002`_0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010`\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020a0\fj\u0002`b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010c\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020d0\u0010j\u0002`e0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0093\u0001"}, d2={"Lorg/jetbrains/kotlin/backend/common/IrFileValidator;", "Lorg/jetbrains/kotlin/ir/util/IrTreeSymbolsVisitor;", "config", "Lorg/jetbrains/kotlin/backend/common/IrValidatorConfig;", "context", "Lorg/jetbrains/kotlin/backend/common/checkers/context/CheckerContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/IrValidatorConfig;Lorg/jetbrains/kotlin/backend/common/checkers/context/CheckerContext;)V", "contextUpdaters", "", "Lorg/jetbrains/kotlin/backend/common/checkers/context/ContextUpdater;", "fieldCheckers", "Lorg/jetbrains/kotlin/backend/common/checkers/declaration/IrDeclarationChecker;", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "Lorg/jetbrains/kotlin/backend/common/checkers/declaration/IrFieldChecker;", "fieldAccessExpressionCheckers", "Lorg/jetbrains/kotlin/backend/common/checkers/expression/IrExpressionChecker;", "Lorg/jetbrains/kotlin/ir/expressions/IrFieldAccessExpression;", "Lorg/jetbrains/kotlin/backend/common/checkers/expression/IrFieldAccessChecker;", "typeCheckers", "Lorg/jetbrains/kotlin/backend/common/checkers/type/IrTypeChecker;", "symbolCheckers", "Lorg/jetbrains/kotlin/backend/common/checkers/symbol/IrSymbolChecker;", "declarationReferenceCheckers", "Lorg/jetbrains/kotlin/ir/expressions/IrDeclarationReference;", "Lorg/jetbrains/kotlin/backend/common/checkers/expression/IrDeclarationReferenceChecker;", "varargCheckers", "Lorg/jetbrains/kotlin/ir/expressions/IrVararg;", "Lorg/jetbrains/kotlin/backend/common/checkers/expression/IrVarargChecker;", "valueParameterCheckers", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "Lorg/jetbrains/kotlin/backend/common/checkers/declaration/IrValueParameterChecker;", "valueAccessCheckers", "Lorg/jetbrains/kotlin/ir/expressions/IrValueAccessExpression;", "Lorg/jetbrains/kotlin/backend/common/checkers/expression/IrValueAccessChecker;", "functionAccessCheckers", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "Lorg/jetbrains/kotlin/backend/common/checkers/expression/IrFunctionAccessChecker;", "functionReferenceCheckers", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "Lorg/jetbrains/kotlin/backend/common/checkers/expression/IrFunctionReferenceChecker;", "constCheckers", "Lorg/jetbrains/kotlin/ir/expressions/IrConst;", "Lorg/jetbrains/kotlin/backend/common/checkers/expression/IrConstChecker;", "stringConcatenationCheckers", "Lorg/jetbrains/kotlin/ir/expressions/IrStringConcatenation;", "Lorg/jetbrains/kotlin/backend/common/checkers/expression/IrStringConcatenationChecker;", "getObjectValueCheckers", "Lorg/jetbrains/kotlin/ir/expressions/IrGetObjectValue;", "Lorg/jetbrains/kotlin/backend/common/checkers/expression/IrGetObjectValueChecker;", "getValueCheckers", "Lorg/jetbrains/kotlin/ir/expressions/IrGetValue;", "Lorg/jetbrains/kotlin/backend/common/checkers/expression/IrGetValueChecker;", "setValueCheckers", "Lorg/jetbrains/kotlin/ir/expressions/IrSetValue;", "Lorg/jetbrains/kotlin/backend/common/checkers/expression/IrSetValueChecker;", "getFieldCheckers", "Lorg/jetbrains/kotlin/ir/expressions/IrGetField;", "Lorg/jetbrains/kotlin/backend/common/checkers/expression/IrGetFieldChecker;", "setFieldCheckers", "Lorg/jetbrains/kotlin/ir/expressions/IrSetField;", "Lorg/jetbrains/kotlin/backend/common/checkers/expression/IrSetFieldChecker;", "delegatingConstructorCallCheckers", "Lorg/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;", "Lorg/jetbrains/kotlin/backend/common/checkers/expression/IrDelegatingConstructorCallChecker;", "instanceInitializerCallCheckers", "Lorg/jetbrains/kotlin/ir/expressions/IrInstanceInitializerCall;", "Lorg/jetbrains/kotlin/backend/common/checkers/expression/IrInstanceInitializerCallChecker;", "loopCheckers", "Lorg/jetbrains/kotlin/ir/expressions/IrLoop;", "Lorg/jetbrains/kotlin/backend/common/checkers/expression/IrLoopChecker;", "breakContinueCheckers", "Lorg/jetbrains/kotlin/ir/expressions/IrBreakContinue;", "Lorg/jetbrains/kotlin/backend/common/checkers/expression/IrBreakContinueChecker;", "returnCheckers", "Lorg/jetbrains/kotlin/ir/expressions/IrReturn;", "Lorg/jetbrains/kotlin/backend/common/checkers/expression/IrReturnChecker;", "throwCheckers", "Lorg/jetbrains/kotlin/ir/expressions/IrThrow;", "Lorg/jetbrains/kotlin/backend/common/checkers/expression/IrThrowChecker;", "functionCheckers", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "Lorg/jetbrains/kotlin/backend/common/checkers/declaration/IrFunctionChecker;", "declarationBaseCheckers", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "propertyReferenceCheckers", "Lorg/jetbrains/kotlin/ir/expressions/IrPropertyReference;", "Lorg/jetbrains/kotlin/backend/common/checkers/expression/IrPropertyReferenceChecker;", "localDelegatedPropertyReferenceCheckers", "Lorg/jetbrains/kotlin/ir/expressions/IrLocalDelegatedPropertyReference;", "Lorg/jetbrains/kotlin/backend/common/checkers/expression/IrLocalDelegatedPropertyReferenceChecker;", "expressionCheckers", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "typeOperatorCheckers", "Lorg/jetbrains/kotlin/ir/expressions/IrTypeOperatorCall;", "Lorg/jetbrains/kotlin/backend/common/checkers/expression/IrTypeOperatorChecker;", "propertyCheckers", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "Lorg/jetbrains/kotlin/backend/common/checkers/declaration/IrPropertyChecker;", "callCheckers", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "Lorg/jetbrains/kotlin/backend/common/checkers/expression/IrCallChecker;", "visitElement", "", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "visitConst", "expression", "visitStringConcatenation", "visitGetObjectValue", "visitGetValue", "visitSetValue", "visitGetField", "visitSetField", "visitCall", "visitDelegatingConstructorCall", "visitInstanceInitializerCall", "visitTypeOperator", "visitLoop", "loop", "visitBreakContinue", "jump", "visitReturn", "visitThrow", "visitFunction", "declaration", "visitValueAccess", "visitField", "visitFieldAccess", "visitType", "container", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "visitSymbol", "symbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "visitDeclarationReference", "visitDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationBase;", "visitPropertyReference", "visitLocalDelegatedPropertyReference", "visitExpression", "visitVararg", "visitValueParameter", "visitFunctionReference", "visitFunctionAccess", "visitProperty", "ir.backend.common"})
final class IrFileValidator
extends IrTreeSymbolsVisitor {
    @NotNull
    private final CheckerContext context;
    @NotNull
    private final List<ContextUpdater> contextUpdaters;
    @NotNull
    private final List<IrDeclarationChecker<IrField>> fieldCheckers;
    @NotNull
    private final List<IrExpressionChecker<IrFieldAccessExpression>> fieldAccessExpressionCheckers;
    @NotNull
    private final List<IrTypeChecker> typeCheckers;
    @NotNull
    private final List<IrSymbolChecker> symbolCheckers;
    @NotNull
    private final List<IrExpressionChecker<IrDeclarationReference>> declarationReferenceCheckers;
    @NotNull
    private final List<IrExpressionChecker<IrVararg>> varargCheckers;
    @NotNull
    private final List<IrDeclarationChecker<IrValueParameter>> valueParameterCheckers;
    @NotNull
    private final List<IrExpressionChecker<IrValueAccessExpression>> valueAccessCheckers;
    @NotNull
    private final List<IrExpressionChecker<IrFunctionAccessExpression>> functionAccessCheckers;
    @NotNull
    private final List<IrExpressionChecker<IrFunctionReference>> functionReferenceCheckers;
    @NotNull
    private final List<IrExpressionChecker<IrConst>> constCheckers;
    @NotNull
    private final List<IrExpressionChecker<IrStringConcatenation>> stringConcatenationCheckers;
    @NotNull
    private final List<IrExpressionChecker<IrGetObjectValue>> getObjectValueCheckers;
    @NotNull
    private final List<IrExpressionChecker<IrGetValue>> getValueCheckers;
    @NotNull
    private final List<IrExpressionChecker<IrSetValue>> setValueCheckers;
    @NotNull
    private final List<IrExpressionChecker<IrGetField>> getFieldCheckers;
    @NotNull
    private final List<IrExpressionChecker<IrSetField>> setFieldCheckers;
    @NotNull
    private final List<IrExpressionChecker<IrDelegatingConstructorCall>> delegatingConstructorCallCheckers;
    @NotNull
    private final List<IrExpressionChecker<IrInstanceInitializerCall>> instanceInitializerCallCheckers;
    @NotNull
    private final List<IrExpressionChecker<IrLoop>> loopCheckers;
    @NotNull
    private final List<IrExpressionChecker<IrBreakContinue>> breakContinueCheckers;
    @NotNull
    private final List<IrExpressionChecker<IrReturn>> returnCheckers;
    @NotNull
    private final List<IrExpressionChecker<IrThrow>> throwCheckers;
    @NotNull
    private final List<IrDeclarationChecker<IrFunction>> functionCheckers;
    @NotNull
    private final List<IrDeclarationChecker<IrDeclaration>> declarationBaseCheckers;
    @NotNull
    private final List<IrExpressionChecker<IrPropertyReference>> propertyReferenceCheckers;
    @NotNull
    private final List<IrExpressionChecker<IrLocalDelegatedPropertyReference>> localDelegatedPropertyReferenceCheckers;
    @NotNull
    private final List<IrExpressionChecker<IrExpression>> expressionCheckers;
    @NotNull
    private final List<IrExpressionChecker<IrTypeOperatorCall>> typeOperatorCheckers;
    @NotNull
    private final List<IrDeclarationChecker<IrProperty>> propertyCheckers;
    @NotNull
    private final List<IrExpressionChecker<IrCall>> callCheckers;

    public IrFileValidator(@NotNull IrValidatorConfig config, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        Object[] objectArray = new ContextUpdater[]{ParentChainUpdater.INSTANCE};
        this.contextUpdaters = CollectionsKt.mutableListOf((Object[])objectArray);
        this.fieldCheckers = new ArrayList();
        this.fieldAccessExpressionCheckers = new ArrayList();
        this.typeCheckers = new ArrayList();
        this.symbolCheckers = new ArrayList();
        this.declarationReferenceCheckers = new ArrayList();
        this.varargCheckers = new ArrayList();
        this.valueParameterCheckers = new ArrayList();
        this.valueAccessCheckers = new ArrayList();
        objectArray = new IrExpressionChecker[]{IrNoInlineUseSitesChecker.INSTANCE};
        this.functionAccessCheckers = CollectionsKt.mutableListOf((Object[])objectArray);
        objectArray = new IrExpressionChecker[]{IrFunctionReferenceFunctionDispatchReceiverChecker.INSTANCE, IrNoInlineUseSitesChecker.INSTANCE};
        this.functionReferenceCheckers = CollectionsKt.mutableListOf((Object[])objectArray);
        this.constCheckers = new ArrayList();
        this.stringConcatenationCheckers = new ArrayList();
        this.getObjectValueCheckers = new ArrayList();
        this.getValueCheckers = new ArrayList();
        objectArray = new IrExpressionChecker[]{IrSetValueAssignabilityChecker.INSTANCE};
        this.setValueCheckers = CollectionsKt.mutableListOf((Object[])objectArray);
        this.getFieldCheckers = new ArrayList();
        this.setFieldCheckers = new ArrayList();
        this.delegatingConstructorCallCheckers = new ArrayList();
        this.instanceInitializerCallCheckers = new ArrayList();
        this.loopCheckers = new ArrayList();
        this.breakContinueCheckers = new ArrayList();
        this.returnCheckers = new ArrayList();
        this.throwCheckers = new ArrayList();
        objectArray = new IrDeclarationChecker[]{IrFunctionDispatchReceiverChecker.INSTANCE, IrFunctionParametersChecker.INSTANCE, IrConstructorReceiverChecker.INSTANCE};
        this.functionCheckers = CollectionsKt.mutableListOf((Object[])objectArray);
        objectArray = new IrDeclarationChecker[]{IrPrivateDeclarationOverrideChecker.INSTANCE};
        this.declarationBaseCheckers = CollectionsKt.mutableListOf((Object[])objectArray);
        this.propertyReferenceCheckers = new ArrayList();
        this.localDelegatedPropertyReferenceCheckers = new ArrayList();
        objectArray = new IrExpressionChecker[]{IrExpressionTypeChecker.INSTANCE};
        this.expressionCheckers = CollectionsKt.mutableListOf((Object[])objectArray);
        objectArray = new IrExpressionChecker[]{IrTypeOperatorTypeOperandChecker.INSTANCE};
        this.typeOperatorCheckers = CollectionsKt.mutableListOf((Object[])objectArray);
        this.propertyCheckers = new ArrayList();
        objectArray = new IrExpressionChecker[]{IrCallFunctionDispatchReceiverChecker.INSTANCE};
        this.callCheckers = CollectionsKt.mutableListOf((Object[])objectArray);
        if (config.getCheckValueScopes()) {
            this.contextUpdaters.add(ValueScopeUpdater.INSTANCE);
            this.valueAccessCheckers.add(IrValueAccessScopeChecker.INSTANCE);
        }
        if (config.getCheckTypeParameterScopes()) {
            this.contextUpdaters.add(TypeParameterScopeUpdater.INSTANCE);
            this.typeCheckers.add(IrTypeParameterScopeChecker.INSTANCE);
        }
        if (config.getCheckAllKotlinFieldsArePrivate()) {
            this.fieldCheckers.add(IrFieldVisibilityChecker.INSTANCE);
        }
        if (config.getCheckCrossFileFieldUsage()) {
            this.fieldAccessExpressionCheckers.add(IrCrossFileFieldUsageChecker.INSTANCE);
        }
        if (config.getCheckVisibilities()) {
            this.symbolCheckers.add(IrVisibilityChecker.INSTANCE);
        }
        if (config.getCheckVarargTypes()) {
            this.varargCheckers.add(IrVarargTypesChecker.INSTANCE);
            this.valueParameterCheckers.add(IrValueParameterVarargTypesChecker.INSTANCE);
        }
        if (config.getCheckTypes()) {
            this.constCheckers.add(IrConstTypeChecker.INSTANCE);
            this.stringConcatenationCheckers.add(IrStringConcatenationTypeChecker.INSTANCE);
            this.getObjectValueCheckers.add(IrGetObjectValueTypeChecker.INSTANCE);
            this.getValueCheckers.add(IrGetValueTypeChecker.INSTANCE);
            this.setValueCheckers.add(IrUnitTypeExpressionChecker.INSTANCE);
            this.getFieldCheckers.add(IrGetFieldTypeChecker.INSTANCE);
            this.setFieldCheckers.add(IrUnitTypeExpressionChecker.INSTANCE);
            this.callCheckers.add(IrCallTypeChecker.INSTANCE);
            this.delegatingConstructorCallCheckers.add(IrUnitTypeExpressionChecker.INSTANCE);
            this.instanceInitializerCallCheckers.add(IrUnitTypeExpressionChecker.INSTANCE);
            this.typeOperatorCheckers.add(IrTypeOperatorTypeChecker.INSTANCE);
            this.loopCheckers.add(IrUnitTypeExpressionChecker.INSTANCE);
            this.breakContinueCheckers.add(IrNothingTypeExpressionChecker.INSTANCE);
            this.returnCheckers.add(IrNothingTypeExpressionChecker.INSTANCE);
            this.throwCheckers.add(IrNothingTypeExpressionChecker.INSTANCE);
            this.fieldAccessExpressionCheckers.add(IrDynamicTypeFieldAccessChecker.INSTANCE);
        }
        if (config.getCheckProperties()) {
            this.callCheckers.add(IrCallFunctionPropertiesChecker.INSTANCE);
            this.functionCheckers.add(IrFunctionPropertiesChecker.INSTANCE);
            this.functionReferenceCheckers.add(IrFunctionReferenceFunctionPropertiesChecker.INSTANCE);
            this.propertyCheckers.add(IrPropertyAccessorsChecker.INSTANCE);
        }
        if (config.getCheckFunctionBody()) {
            this.functionCheckers.add(IrFunctionBodyChecker.INSTANCE);
        }
    }

    @Override
    public void visitElement(@NotNull IrElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Function0 block = () -> IrFileValidator.visitElement$lambda$0(element, this);
        for (ContextUpdater contextUpdater : this.contextUpdaters) {
            Function0 currentBlock = block;
            block = () -> IrFileValidator.visitElement$lambda$1(contextUpdater, this, element, currentBlock);
        }
        block.invoke();
    }

    @Override
    public void visitConst(@NotNull IrConst expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super.visitConst(expression2);
        IrExpressionCheckerKt.check(this.constCheckers, (IrExpression)expression2, this.context);
    }

    @Override
    public void visitStringConcatenation(@NotNull IrStringConcatenation expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super.visitStringConcatenation(expression2);
        IrExpressionCheckerKt.check(this.stringConcatenationCheckers, (IrExpression)expression2, this.context);
    }

    @Override
    public void visitGetObjectValue(@NotNull IrGetObjectValue expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super.visitGetObjectValue(expression2);
        IrExpressionCheckerKt.check(this.getObjectValueCheckers, (IrExpression)expression2, this.context);
    }

    @Override
    public void visitGetValue(@NotNull IrGetValue expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super.visitGetValue(expression2);
        IrExpressionCheckerKt.check(this.getValueCheckers, (IrExpression)expression2, this.context);
    }

    @Override
    public void visitSetValue(@NotNull IrSetValue expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super.visitSetValue(expression2);
        IrExpressionCheckerKt.check(this.setValueCheckers, (IrExpression)expression2, this.context);
    }

    @Override
    public void visitGetField(@NotNull IrGetField expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super.visitGetField(expression2);
        IrExpressionCheckerKt.check(this.getFieldCheckers, (IrExpression)expression2, this.context);
    }

    @Override
    public void visitSetField(@NotNull IrSetField expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super.visitSetField(expression2);
        IrExpressionCheckerKt.check(this.setFieldCheckers, (IrExpression)expression2, this.context);
    }

    @Override
    public void visitCall(@NotNull IrCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super.visitCall(expression2);
        IrExpressionCheckerKt.check(this.callCheckers, (IrExpression)expression2, this.context);
    }

    @Override
    public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super.visitDelegatingConstructorCall(expression2);
        IrExpressionCheckerKt.check(this.delegatingConstructorCallCheckers, (IrExpression)expression2, this.context);
    }

    @Override
    public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super.visitInstanceInitializerCall(expression2);
        IrExpressionCheckerKt.check(this.instanceInitializerCallCheckers, (IrExpression)expression2, this.context);
    }

    @Override
    public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super.visitTypeOperator(expression2);
        IrExpressionCheckerKt.check(this.typeOperatorCheckers, (IrExpression)expression2, this.context);
    }

    @Override
    public void visitLoop(@NotNull IrLoop loop) {
        Intrinsics.checkNotNullParameter((Object)loop, (String)"loop");
        super.visitLoop(loop);
        IrExpressionCheckerKt.check(this.loopCheckers, (IrExpression)loop, this.context);
    }

    @Override
    public void visitBreakContinue(@NotNull IrBreakContinue jump) {
        Intrinsics.checkNotNullParameter((Object)jump, (String)"jump");
        super.visitBreakContinue(jump);
        IrExpressionCheckerKt.check(this.breakContinueCheckers, (IrExpression)jump, this.context);
    }

    @Override
    public void visitReturn(@NotNull IrReturn expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super.visitReturn(expression2);
        IrExpressionCheckerKt.check(this.returnCheckers, (IrExpression)expression2, this.context);
    }

    @Override
    public void visitThrow(@NotNull IrThrow expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super.visitThrow(expression2);
        IrExpressionCheckerKt.check(this.throwCheckers, (IrExpression)expression2, this.context);
    }

    @Override
    public void visitFunction(@NotNull IrFunction declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        super.visitFunction(declaration);
        IrDeclarationCheckerKt.check(this.functionCheckers, (IrDeclaration)declaration, this.context);
    }

    @Override
    public void visitValueAccess(@NotNull IrValueAccessExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super.visitValueAccess(expression2);
        IrExpressionCheckerKt.check(this.valueAccessCheckers, (IrExpression)expression2, this.context);
    }

    @Override
    public void visitField(@NotNull IrField declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        super.visitField(declaration);
        IrDeclarationCheckerKt.check(this.fieldCheckers, (IrDeclaration)declaration, this.context);
    }

    @Override
    public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super.visitFieldAccess(expression2);
        IrExpressionCheckerKt.check(this.fieldAccessExpressionCheckers, (IrExpression)expression2, this.context);
    }

    @Override
    public void visitType(@NotNull IrElement container, @NotNull IrType type) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        super.visitType(container, type);
        IrTypeCheckerKt.check(this.typeCheckers, type, container, this.context);
    }

    @Override
    public void visitSymbol(@NotNull IrElement container, @NotNull IrSymbol symbol) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        IrSymbolCheckerKt.check(this.symbolCheckers, symbol, container, this.context);
    }

    @Override
    public void visitDeclarationReference(@NotNull IrDeclarationReference expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super.visitDeclarationReference(expression2);
        IrExpressionCheckerKt.check(this.declarationReferenceCheckers, (IrExpression)expression2, this.context);
    }

    @Override
    public void visitDeclaration(@NotNull IrDeclarationBase declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        super.visitDeclaration(declaration);
        IrDeclarationCheckerKt.check(this.declarationBaseCheckers, (IrDeclaration)declaration, this.context);
    }

    @Override
    public void visitPropertyReference(@NotNull IrPropertyReference expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super.visitPropertyReference(expression2);
        IrExpressionCheckerKt.check(this.propertyReferenceCheckers, (IrExpression)expression2, this.context);
    }

    @Override
    public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super.visitLocalDelegatedPropertyReference(expression2);
        IrExpressionCheckerKt.check(this.localDelegatedPropertyReferenceCheckers, (IrExpression)expression2, this.context);
    }

    @Override
    public void visitExpression(@NotNull IrExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super.visitExpression(expression2);
        IrExpressionCheckerKt.check(this.expressionCheckers, expression2, this.context);
    }

    @Override
    public void visitVararg(@NotNull IrVararg expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super.visitVararg(expression2);
        IrExpressionCheckerKt.check(this.varargCheckers, (IrExpression)expression2, this.context);
    }

    @Override
    public void visitValueParameter(@NotNull IrValueParameter declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        super.visitValueParameter(declaration);
        IrDeclarationCheckerKt.check(this.valueParameterCheckers, (IrDeclaration)declaration, this.context);
    }

    @Override
    public void visitFunctionReference(@NotNull IrFunctionReference expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super.visitFunctionReference(expression2);
        IrExpressionCheckerKt.check(this.functionReferenceCheckers, (IrExpression)expression2, this.context);
    }

    @Override
    public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super.visitFunctionAccess(expression2);
        IrExpressionCheckerKt.check(this.functionAccessCheckers, (IrExpression)expression2, this.context);
    }

    @Override
    public void visitProperty(@NotNull IrProperty declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        super.visitProperty(declaration);
        IrDeclarationCheckerKt.check(this.propertyCheckers, (IrDeclaration)declaration, this.context);
    }

    private static final Unit visitElement$lambda$0(IrElement $element, IrFileValidator this$0) {
        IrVisitorsKt.acceptChildrenVoid($element, this$0);
        return Unit.INSTANCE;
    }

    private static final Unit visitElement$lambda$1(ContextUpdater $contextUpdater, IrFileValidator this$0, IrElement $element, Function0 $currentBlock) {
        $contextUpdater.runInNewContext(this$0.context, $element, (Function0<Unit>)$currentBlock);
        return Unit.INSTANCE;
    }
}

