/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.messages.impl;

import java.util.ArrayDeque;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.kotlin.com.intellij.util.concurrency.AppExecutorUtil;
import org.jetbrains.kotlin.com.intellij.util.messages.MessageBusOwner;
import org.jetbrains.kotlin.com.intellij.util.messages.Topic;
import org.jetbrains.kotlin.com.intellij.util.messages.impl.CompositeMessageBus;
import org.jetbrains.kotlin.com.intellij.util.messages.impl.Message;
import org.jetbrains.kotlin.com.intellij.util.messages.impl.MessageQueue;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u001a\u0010\u0013\u001a\u00020\u00122\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0012R\u001a\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/com/intellij/util/messages/impl/RootBus;", "Lorg/jetbrains/kotlin/com/intellij/util/messages/impl/CompositeMessageBus;", "owner", "Lorg/jetbrains/kotlin/com/intellij/util/messages/MessageBusOwner;", "(Lcom/intellij/util/messages/MessageBusOwner;)V", "compactionFutureRef", "Ljava/util/concurrent/atomic/AtomicReference;", "Ljava/util/concurrent/CompletableFuture;", "compactionRequest", "Ljava/util/concurrent/atomic/AtomicInteger;", "emptyConnectionCounter", "queue", "Lorg/jetbrains/kotlin/com/intellij/util/messages/impl/MessageQueue;", "getQueue$intellij_platform_core", "()Lcom/intellij/util/messages/impl/MessageQueue;", "queueThreadLocal", "Ljava/lang/ThreadLocal;", "dispose", "", "removeDisposedHandlers", "topic", "Lorg/jetbrains/kotlin/com/intellij/util/messages/Topic;", "handler", "", "scheduleEmptyConnectionRemoving", "intellij.platform.core"})
@ApiStatus.Internal
@VisibleForTesting
public final class RootBus
extends CompositeMessageBus {
    @NotNull
    private final AtomicReference<CompletableFuture<?>> compactionFutureRef;
    @NotNull
    private final AtomicInteger compactionRequest;
    @NotNull
    private final AtomicInteger emptyConnectionCounter;
    @NotNull
    private final ThreadLocal<MessageQueue> queueThreadLocal;

    public RootBus(@NotNull MessageBusOwner owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        super(owner);
        this.compactionFutureRef = new AtomicReference();
        this.compactionRequest = new AtomicInteger();
        this.emptyConnectionCounter = new AtomicInteger();
        ThreadLocal<MessageQueue> threadLocal = ThreadLocal.withInitial(RootBus::queueThreadLocal$lambda$0);
        Intrinsics.checkNotNullExpressionValue(threadLocal, (String)"withInitial(...)");
        this.queueThreadLocal = threadLocal;
    }

    @NotNull
    public final MessageQueue getQueue$intellij_platform_core() {
        MessageQueue messageQueue = this.queueThreadLocal.get();
        Intrinsics.checkNotNullExpressionValue((Object)messageQueue, (String)"get(...)");
        return messageQueue;
    }

    public final void scheduleEmptyConnectionRemoving() {
        int counter = this.emptyConnectionCounter.incrementAndGet();
        if (counter < 128 || !this.emptyConnectionCounter.compareAndSet(counter, 0)) {
            return;
        }
        if (this.compactionRequest.incrementAndGet() == 1) {
            this.compactionFutureRef.set(CompletableFuture.runAsync(() -> RootBus.scheduleEmptyConnectionRemoving$lambda$1(this), AppExecutorUtil.getAppExecutorService()));
        }
    }

    @Override
    public void dispose() {
        CompletableFuture compactionFuture;
        CompletableFuture completableFuture = compactionFuture = (CompletableFuture)this.compactionFutureRef.getAndSet(null);
        if (completableFuture != null) {
            completableFuture.cancel(false);
        }
        this.compactionRequest.set(0);
        super.dispose();
    }

    public final void removeDisposedHandlers(@NotNull Topic<?> topic, @NotNull Object handler2) {
        Intrinsics.checkNotNullParameter(topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)handler2, (String)"handler");
        ArrayDeque<Message> queue = this.getQueue$intellij_platform_core().queue;
        if (queue.isEmpty()) {
            return;
        }
        queue.removeIf(arg_0 -> RootBus.removeDisposedHandlers$lambda$2((Function1)new Function1<Message, Boolean>(topic, handler2){
            final /* synthetic */ Topic<?> $topic;
            final /* synthetic */ Object $handler;
            {
                this.$topic = $topic;
                this.$handler = $handler;
                super(1);
            }

            @NotNull
            public final Boolean invoke(Message message2) {
                int n = message2.handlers.length;
                for (int messageIndex = 0; messageIndex < n; ++messageIndex) {
                    Object messageHandler;
                    if (message2.handlers[messageIndex] == null) {
                        return false;
                    }
                    if (message2.topic != this.$topic || messageHandler != this.$handler) continue;
                    message2.handlers[messageIndex] = null;
                    return message2.handlers.length == 1;
                }
                return false;
            }
        }, arg_0));
    }

    private static final MessageQueue queueThreadLocal$lambda$0() {
        return new MessageQueue();
    }

    private static final void scheduleEmptyConnectionRemoving$lambda$1(RootBus this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        int request = 0;
        do {
            request = this$0.compactionRequest.get();
            this$0.removeEmptyConnectionsRecursively();
        } while (!this$0.compactionRequest.compareAndSet(request, 0));
    }

    private static final boolean removeDisposedHandlers$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

