/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.transformers.irToJs;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsCodeKt;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.JsAnnotations;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\bJ\u001c\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u0011J\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\r\u001a\u00020\u0006J\u0018\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013*\b\u0012\u0004\u0012\u00020\b0\u0016H\u0002J\u0018\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013*\b\u0012\u0004\u0012\u00020\b0\u0017H\u0002RJ\u0010\u0004\u001a>\u0012\u0004\u0012\u00020\u0006\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\t0\u0005j\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/JsPolyfills;", "", "<init>", "()V", "polyfillsPerFile", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "Lkotlin/collections/HashSet;", "Lkotlin/collections/HashMap;", "registerDeclarationNativeImplementation", "", "file", "declaration", "saveOnlyIntersectionOfNextDeclarationsFor", "declarations", "", "getAllPolyfillsFor", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "asImplementationList", "", "Lkotlin/sequences/Sequence;", "backend.js"})
public final class JsPolyfills {
    @NotNull
    private final HashMap<IrFile, HashSet<IrDeclaration>> polyfillsPerFile = new HashMap();

    public final void registerDeclarationNativeImplementation(@NotNull IrFile file2, @NotNull IrDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (!AnnotationUtilsKt.hasJsPolyfill(declaration)) {
            return;
        }
        HashSet<IrDeclaration> hashSet = this.polyfillsPerFile.get(file2);
        if (hashSet == null) {
            hashSet = new HashSet<IrDeclaration>();
        }
        HashSet<IrDeclaration> declarations2 = hashSet;
        declarations2.add(declaration);
        ((Map)this.polyfillsPerFile).put(file2, declarations2);
    }

    public final void saveOnlyIntersectionOfNextDeclarationsFor(@NotNull IrFile file2, @NotNull Set<? extends IrDeclaration> declarations2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter(declarations2, (String)"declarations");
        HashSet<IrDeclaration> hashSet = this.polyfillsPerFile.get(file2);
        if (hashSet == null) {
            return;
        }
        HashSet<IrDeclaration> polyfills = hashSet;
        ((Map)this.polyfillsPerFile).put(file2, CollectionsKt.toHashSet((Iterable)CollectionsKt.intersect((Iterable)polyfills, (Iterable)declarations2)));
    }

    @NotNull
    public final List<JsStatement> getAllPolyfillsFor(@NotNull IrFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Set set = this.polyfillsPerFile.get(file2);
        if (set == null) {
            set = SetsKt.emptySet();
        }
        return this.asImplementationList(set);
    }

    private final List<JsStatement> asImplementationList(Iterable<? extends IrDeclaration> $this$asImplementationList) {
        return this.asImplementationList((Sequence<? extends IrDeclaration>)CollectionsKt.asSequence($this$asImplementationList));
    }

    private final List<JsStatement> asImplementationList(Sequence<? extends IrDeclaration> $this$asImplementationList) {
        return SequencesKt.toList((Sequence)SequencesKt.flatMapIterable((Sequence)SequencesKt.distinctBy((Sequence)SequencesKt.map($this$asImplementationList, JsPolyfills::asImplementationList$lambda$0), JsPolyfills::asImplementationList$lambda$1), JsPolyfills::asImplementationList$lambda$2));
    }

    private static final Pair asImplementationList$lambda$0(IrDeclaration it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        IrConstructorCall irConstructorCall = IrUtilsKt.getAnnotation(it, JsAnnotations.INSTANCE.getJsPolyfillFqn());
        Intrinsics.checkNotNull((Object)irConstructorCall);
        IrExpression irExpression = irConstructorCall.getValueArgument(0);
        Intrinsics.checkNotNull((Object)irExpression);
        return TuplesKt.to((Object)it, (Object)irExpression);
    }

    private static final String asImplementationList$lambda$1(Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object object = it.getSecond();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrConst");
        Object object2 = ((IrConst)object).getValue();
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.String");
        return (String)object2;
    }

    private static final Iterable asImplementationList$lambda$2(Pair pair) {
        Intrinsics.checkNotNullParameter((Object)pair, (String)"<destruct>");
        IrDeclaration container = (IrDeclaration)pair.component1();
        IrExpression polyfill = (IrExpression)pair.component2();
        List list = JsCodeKt.translateJsCodeIntoStatementList(polyfill, container);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }
}

